// Code generated by go-swagger; DO NOT EDIT.

//
// Copyright 2021 The Sigstore Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package entries

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/sigstore/rekor/pkg/generated/models"
)

// CreateLogEntryCreatedCode is the HTTP code returned for type CreateLogEntryCreated
const CreateLogEntryCreatedCode int = 201

/*
CreateLogEntryCreated Returns the entry created in the transparency log

swagger:response createLogEntryCreated
*/
type CreateLogEntryCreated struct {
	/*UUID of log entry

	 */
	ETag string `json:"ETag"`
	/*URI location of log entry

	 */
	Location strfmt.URI `json:"Location"`

	/*
	  In: Body
	*/
	Payload models.LogEntry `json:"body,omitempty"`
}

// NewCreateLogEntryCreated creates CreateLogEntryCreated with default headers values
func NewCreateLogEntryCreated() *CreateLogEntryCreated {

	return &CreateLogEntryCreated{}
}

// WithETag adds the eTag to the create log entry created response
func (o *CreateLogEntryCreated) WithETag(eTag string) *CreateLogEntryCreated {
	o.ETag = eTag
	return o
}

// SetETag sets the eTag to the create log entry created response
func (o *CreateLogEntryCreated) SetETag(eTag string) {
	o.ETag = eTag
}

// WithLocation adds the location to the create log entry created response
func (o *CreateLogEntryCreated) WithLocation(location strfmt.URI) *CreateLogEntryCreated {
	o.Location = location
	return o
}

// SetLocation sets the location to the create log entry created response
func (o *CreateLogEntryCreated) SetLocation(location strfmt.URI) {
	o.Location = location
}

// WithPayload adds the payload to the create log entry created response
func (o *CreateLogEntryCreated) WithPayload(payload models.LogEntry) *CreateLogEntryCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create log entry created response
func (o *CreateLogEntryCreated) SetPayload(payload models.LogEntry) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateLogEntryCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header ETag

	eTag := o.ETag
	if eTag != "" {
		rw.Header().Set("ETag", eTag)
	}

	// response header Location

	location := o.Location.String()
	if location != "" {
		rw.Header().Set("Location", location)
	}

	rw.WriteHeader(201)
	payload := o.Payload
	if payload == nil {
		// return empty map
		payload = models.LogEntry{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// CreateLogEntryBadRequestCode is the HTTP code returned for type CreateLogEntryBadRequest
const CreateLogEntryBadRequestCode int = 400

/*
CreateLogEntryBadRequest The content supplied to the server was invalid

swagger:response createLogEntryBadRequest
*/
type CreateLogEntryBadRequest struct {

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateLogEntryBadRequest creates CreateLogEntryBadRequest with default headers values
func NewCreateLogEntryBadRequest() *CreateLogEntryBadRequest {

	return &CreateLogEntryBadRequest{}
}

// WithPayload adds the payload to the create log entry bad request response
func (o *CreateLogEntryBadRequest) WithPayload(payload *models.Error) *CreateLogEntryBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create log entry bad request response
func (o *CreateLogEntryBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateLogEntryBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateLogEntryConflictCode is the HTTP code returned for type CreateLogEntryConflict
const CreateLogEntryConflictCode int = 409

/*
CreateLogEntryConflict The request conflicts with the current state of the transparency log

swagger:response createLogEntryConflict
*/
type CreateLogEntryConflict struct {
	/*

	 */
	Location strfmt.URI `json:"Location"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateLogEntryConflict creates CreateLogEntryConflict with default headers values
func NewCreateLogEntryConflict() *CreateLogEntryConflict {

	return &CreateLogEntryConflict{}
}

// WithLocation adds the location to the create log entry conflict response
func (o *CreateLogEntryConflict) WithLocation(location strfmt.URI) *CreateLogEntryConflict {
	o.Location = location
	return o
}

// SetLocation sets the location to the create log entry conflict response
func (o *CreateLogEntryConflict) SetLocation(location strfmt.URI) {
	o.Location = location
}

// WithPayload adds the payload to the create log entry conflict response
func (o *CreateLogEntryConflict) WithPayload(payload *models.Error) *CreateLogEntryConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create log entry conflict response
func (o *CreateLogEntryConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateLogEntryConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Location

	location := o.Location.String()
	if location != "" {
		rw.Header().Set("Location", location)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateLogEntryDefault There was an internal error in the server while processing the request

swagger:response createLogEntryDefault
*/
type CreateLogEntryDefault struct {
	_statusCode int

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateLogEntryDefault creates CreateLogEntryDefault with default headers values
func NewCreateLogEntryDefault(code int) *CreateLogEntryDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateLogEntryDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create log entry default response
func (o *CreateLogEntryDefault) WithStatusCode(code int) *CreateLogEntryDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create log entry default response
func (o *CreateLogEntryDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithPayload adds the payload to the create log entry default response
func (o *CreateLogEntryDefault) WithPayload(payload *models.Error) *CreateLogEntryDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create log entry default response
func (o *CreateLogEntryDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateLogEntryDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
