% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterAnalysis.R
\name{getFinalElites}
\alias{getFinalElites}
\title{Return the elite configurations of the final iteration.}
\usage{
getFinalElites(iraceResults, n = 0L, drop.metadata = FALSE)
}
\arguments{
\item{iraceResults}{\code{list()}|\code{character(1)}\cr Object created by \pkg{irace} and typically saved in the log file \code{irace.Rdata}. If a character string is given, then it is interpreted as the path to the log file from which the \code{iraceResults} object will be loaded.}

\item{n}{\code{integer(1)}\cr Number of elite configurations to return, if \code{n} is larger than the
number of configurations, then only the existing ones are returned. The default (\code{n=0}) returns all of them.}

\item{drop.metadata}{\code{logical(1)}\cr Remove metadata, such as the
configuration ID and the ID of the parent, from the returned
configurations.  See \code{\link[=removeConfigurationsMetaData]{removeConfigurationsMetaData()}}.}
}
\value{
A data frame containing the elite configurations required.
}
\description{
Return the elite configurations of the final iteration.
}
\examples{
log_file <- system.file("exdata/irace-acotsp.Rdata", package="irace", mustWork=TRUE)
print(removeConfigurationsMetaData(getFinalElites(log_file, n=1)))

}
\author{
Manuel López-Ibáñez and Leslie Pérez Cáceres
}
\concept{analysis}
