/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.gradle.cli.CommandLineArgumentException;
import org.gradle.cli.CommandLineOption;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.cli.ParsedCommandLineOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineParser {
    private static final Pattern OPTION_NAME_PATTERN = Pattern.compile("(\\?|\\p{Alnum}[\\p{Alnum}-_]*)");
    private Map<String, CommandLineOption> optionsByString = new HashMap<String, CommandLineOption>();
    private boolean allowMixedOptions;
    private boolean allowUnknownOptions;

    public ParsedCommandLine parse(String ... commandLine) throws CommandLineArgumentException {
        return this.parse(Arrays.asList(commandLine));
    }

    public ParsedCommandLine parse(Iterable<String> commandLine) throws CommandLineArgumentException {
        ParsedCommandLine parsedCommandLine = new ParsedCommandLine(new HashSet<CommandLineOption>(this.optionsByString.values()));
        ParserState parseState = new BeforeFirstSubCommand(parsedCommandLine);
        for (String arg : commandLine) {
            if (parseState.maybeStartOption(arg)) {
                OptionParserState parsedOption;
                OptionParserState parsedOption2;
                OptionParserState parsedOption3;
                if (arg.equals("--")) {
                    parseState = new AfterOptions(parsedCommandLine);
                    continue;
                }
                if (arg.matches("--[^=]+")) {
                    parsedOption3 = parseState.onStartOption(arg, arg.substring(2));
                    parseState = parsedOption3.onStartNextArg();
                    continue;
                }
                if (arg.matches("(?s)--[^=]+=.*")) {
                    int endArg = arg.indexOf(61);
                    parsedOption2 = parseState.onStartOption(arg, arg.substring(2, endArg));
                    parseState = parsedOption2.onArgument(arg.substring(endArg + 1));
                    continue;
                }
                if (arg.matches("(?s)-[^=]=.*")) {
                    parsedOption3 = parseState.onStartOption(arg, arg.substring(1, 2));
                    parseState = parsedOption3.onArgument(arg.substring(3));
                    continue;
                }
                assert (arg.matches("(?s)-[^-].*"));
                String option = arg.substring(1);
                if (this.optionsByString.containsKey(option)) {
                    parsedOption2 = parseState.onStartOption(arg, option);
                    parseState = parsedOption2.onStartNextArg();
                    continue;
                }
                String option1 = arg.substring(1, 2);
                if (this.optionsByString.containsKey(option1)) {
                    parsedOption = parseState.onStartOption("-" + option1, option1);
                    if (parsedOption.getHasArgument()) {
                        parseState = parsedOption.onArgument(arg.substring(2));
                        continue;
                    }
                    parseState = parsedOption.onComplete();
                    for (int i = 2; i < arg.length(); ++i) {
                        String optionStr = arg.substring(i, i + 1);
                        parsedOption = parseState.onStartOption("-" + optionStr, optionStr);
                        parseState = parsedOption.onComplete();
                    }
                    continue;
                }
                if (this.allowUnknownOptions) {
                    parsedOption = parseState.onStartOption(arg, option);
                    parseState = parsedOption.onComplete();
                    continue;
                }
                parsedOption = parseState.onStartOption("-" + option1, option1);
                parseState = parsedOption.onComplete();
                continue;
            }
            parseState = parseState.onNonOption(arg);
        }
        parseState.onCommandLineEnd();
        return parsedCommandLine;
    }

    public CommandLineParser allowMixedSubcommandsAndOptions() {
        this.allowMixedOptions = true;
        return this;
    }

    public CommandLineParser allowUnknownOptions() {
        this.allowUnknownOptions = true;
        return this;
    }

    public CommandLineParser allowOneOf(String ... options) {
        HashSet<CommandLineOption> commandLineOptions = new HashSet<CommandLineOption>();
        for (String option : options) {
            commandLineOptions.add(this.optionsByString.get(option));
        }
        for (CommandLineOption commandLineOption : commandLineOptions) {
            commandLineOption.groupWith(commandLineOptions);
        }
        return this;
    }

    public void printUsage(Appendable out) {
        Formatter formatter = new Formatter(out);
        TreeSet<CommandLineOption> orderedOptions = new TreeSet<CommandLineOption>(new OptionComparator());
        orderedOptions.addAll(this.optionsByString.values());
        LinkedHashMap<String, String> lines = new LinkedHashMap<String, String>();
        for (CommandLineOption option : orderedOptions) {
            TreeSet<String> treeSet = new TreeSet<String>(new OptionStringComparator());
            treeSet.addAll(option.getOptions());
            ArrayList<String> prefixedStrings = new ArrayList<String>();
            for (String optionString : treeSet) {
                if (optionString.length() == 1) {
                    prefixedStrings.add("-" + optionString);
                    continue;
                }
                prefixedStrings.add("--" + optionString);
            }
            String key = CommandLineParser.join(prefixedStrings, ", ");
            String value = option.getDescription();
            if (value == null || value.length() == 0) {
                value = "";
            }
            lines.put(key, value);
        }
        int max = 0;
        for (String string : lines.keySet()) {
            max = Math.max(max, string.length());
        }
        for (Map.Entry entry : lines.entrySet()) {
            if (((String)entry.getValue()).length() == 0) {
                formatter.format("%s%n", entry.getKey());
                continue;
            }
            formatter.format("%-" + max + "s  %s%n", entry.getKey(), entry.getValue());
        }
        formatter.flush();
    }

    private static String join(Collection<?> things, String separator) {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        if (separator == null) {
            separator = "";
        }
        for (Object thing : things) {
            if (!first) {
                buffer.append(separator);
            }
            buffer.append(thing.toString());
            first = false;
        }
        return buffer.toString();
    }

    public CommandLineOption option(String ... options) {
        for (String option : options) {
            if (this.optionsByString.containsKey(option)) {
                throw new IllegalArgumentException(String.format("Option '%s' is already defined.", option));
            }
            if (option.startsWith("-")) {
                throw new IllegalArgumentException(String.format("Cannot add option '%s' as an option cannot start with '-'.", option));
            }
            if (OPTION_NAME_PATTERN.matcher(option).matches()) continue;
            throw new IllegalArgumentException(String.format("Cannot add option '%s' as an option can only contain alphanumeric characters or '-' or '_'.", option));
        }
        CommandLineOption option = new CommandLineOption(Arrays.asList(options));
        for (String optionStr : option.getOptions()) {
            this.optionsByString.put(optionStr, option);
        }
        return option;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OptionStringComparator
    implements Comparator<String> {
        private OptionStringComparator() {
        }

        @Override
        public int compare(String option1, String option2) {
            boolean short2;
            boolean short1 = option1.length() == 1;
            boolean bl = short2 = option2.length() == 1;
            if (short1 && !short2) {
                return -1;
            }
            if (!short1 && short2) {
                return 1;
            }
            return new CaseInsensitiveStringComparator().compare(option1, option2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CaseInsensitiveStringComparator
    implements Comparator<String> {
        private CaseInsensitiveStringComparator() {
        }

        @Override
        public int compare(String option1, String option2) {
            int diff = option1.compareToIgnoreCase(option2);
            if (diff != 0) {
                return diff;
            }
            return option1.compareTo(option2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OptionComparator
    implements Comparator<CommandLineOption> {
        private OptionComparator() {
        }

        @Override
        public int compare(CommandLineOption option1, CommandLineOption option2) {
            String min1 = Collections.min(option1.getOptions(), new OptionStringComparator());
            String min2 = Collections.min(option2.getOptions(), new OptionStringComparator());
            return new CaseInsensitiveStringComparator().compare(min1, min2);
        }
    }

    private static class UnknownOptionParserState
    extends OptionParserState {
        private final ParserState state;
        private final String arg;
        private final ParsedCommandLine commandLine;

        private UnknownOptionParserState(String arg, ParsedCommandLine commandLine, ParserState state) {
            this.arg = arg;
            this.commandLine = commandLine;
            this.state = state;
        }

        public boolean getHasArgument() {
            return true;
        }

        public ParserState onStartNextArg() {
            return this.onComplete();
        }

        public ParserState onArgument(String argument) {
            return this.onComplete();
        }

        public ParserState onComplete() {
            this.commandLine.addExtraValue(this.arg);
            return this.state;
        }
    }

    private class KnownOptionParserState
    extends OptionParserState {
        private final OptionString optionString;
        private final CommandLineOption option;
        private final ParsedCommandLine commandLine;
        private final ParserState state;
        private final List<String> values;

        private KnownOptionParserState(OptionString optionString, CommandLineOption option, ParsedCommandLine commandLine, ParserState state) {
            this.values = new ArrayList<String>();
            this.optionString = optionString;
            this.option = option;
            this.commandLine = commandLine;
            this.state = state;
        }

        public ParserState onArgument(String argument) {
            if (!this.getHasArgument()) {
                throw new CommandLineArgumentException(String.format("Command-line option '%s' does not take an argument.", this.optionString));
            }
            if (argument.length() == 0) {
                throw new CommandLineArgumentException(String.format("An empty argument was provided for command-line option '%s'.", this.optionString));
            }
            this.values.add(argument);
            return this.onComplete();
        }

        public ParserState onStartNextArg() {
            if (this.option.getAllowsArguments() && this.values.isEmpty()) {
                return new MissingOptionArgState(this);
            }
            return this.onComplete();
        }

        public boolean getHasArgument() {
            return this.option.getAllowsArguments();
        }

        public ParserState onComplete() {
            if (this.getHasArgument() && this.values.isEmpty()) {
                throw new CommandLineArgumentException(String.format("No argument was provided for command-line option '%s'.", this.optionString));
            }
            ParsedCommandLineOption parsedOption = this.commandLine.addOption(this.optionString.option, this.option);
            if (this.values.size() + parsedOption.getValues().size() > 1 && !this.option.getAllowsMultipleArguments()) {
                throw new CommandLineArgumentException(String.format("Multiple arguments were provided for command-line option '%s'.", this.optionString));
            }
            for (String value : this.values) {
                parsedOption.addArgument(value);
            }
            for (CommandLineOption otherOption : this.option.getGroupWith()) {
                this.commandLine.removeOption(otherOption);
            }
            return this.state;
        }
    }

    private static abstract class OptionParserState {
        private OptionParserState() {
        }

        public abstract ParserState onStartNextArg();

        public abstract ParserState onArgument(String var1);

        public abstract boolean getHasArgument();

        public abstract ParserState onComplete();
    }

    private static class MissingOptionArgState
    extends ParserState {
        private final OptionParserState option;

        private MissingOptionArgState(OptionParserState option) {
            this.option = option;
        }

        public boolean maybeStartOption(String arg) {
            return this.isOption(arg);
        }

        public OptionParserState onStartOption(String arg, String option) {
            return this.option.onComplete().onStartOption(arg, option);
        }

        public ParserState onNonOption(String arg) {
            return this.option.onArgument(arg);
        }

        public void onCommandLineEnd() {
            this.option.onComplete();
        }
    }

    private static class AfterOptions
    extends ParserState {
        private final ParsedCommandLine commandLine;

        private AfterOptions(ParsedCommandLine commandLine) {
            this.commandLine = commandLine;
        }

        public boolean maybeStartOption(String arg) {
            return false;
        }

        public OptionParserState onStartOption(String arg, String option) {
            return new UnknownOptionParserState(arg, this.commandLine, this);
        }

        public ParserState onNonOption(String arg) {
            this.commandLine.addExtraValue(arg);
            return this;
        }
    }

    private class AfterFirstSubCommand
    extends OptionAwareParserState {
        private AfterFirstSubCommand(ParsedCommandLine commandLine) {
            super(commandLine);
        }

        public OptionParserState onStartOption(String arg, String option) {
            CommandLineOption commandLineOption = (CommandLineOption)CommandLineParser.this.optionsByString.get(option);
            if (commandLineOption == null) {
                return new UnknownOptionParserState(arg, this.commandLine, this);
            }
            return new KnownOptionParserState(new OptionString(arg, option), commandLineOption, this.commandLine, this);
        }
    }

    private class BeforeFirstSubCommand
    extends OptionAwareParserState {
        private BeforeFirstSubCommand(ParsedCommandLine commandLine) {
            super(commandLine);
        }

        public OptionParserState onStartOption(String arg, String option) {
            OptionString optionString = new OptionString(arg, option);
            CommandLineOption commandLineOption = (CommandLineOption)CommandLineParser.this.optionsByString.get(option);
            if (commandLineOption == null) {
                if (CommandLineParser.this.allowUnknownOptions) {
                    return new UnknownOptionParserState(arg, this.commandLine, this);
                }
                throw new CommandLineArgumentException(String.format("Unknown command-line option '%s'.", optionString));
            }
            return new KnownOptionParserState(optionString, commandLineOption, this.commandLine, this);
        }
    }

    private abstract class OptionAwareParserState
    extends ParserState {
        protected final ParsedCommandLine commandLine;

        protected OptionAwareParserState(ParsedCommandLine commandLine) {
            this.commandLine = commandLine;
        }

        public boolean maybeStartOption(String arg) {
            return this.isOption(arg);
        }

        public ParserState onNonOption(String arg) {
            this.commandLine.addExtraValue(arg);
            return CommandLineParser.this.allowMixedOptions ? new AfterFirstSubCommand(this.commandLine) : new AfterOptions(this.commandLine);
        }
    }

    private static abstract class ParserState {
        private ParserState() {
        }

        public abstract boolean maybeStartOption(String var1);

        boolean isOption(String arg) {
            return arg.matches("(?s)-.+");
        }

        public abstract OptionParserState onStartOption(String var1, String var2);

        public abstract ParserState onNonOption(String var1);

        public void onCommandLineEnd() {
        }
    }

    private static class OptionString {
        private final String arg;
        private final String option;

        private OptionString(String arg, String option) {
            this.arg = arg;
            this.option = option;
        }

        public String getDisplayName() {
            return this.arg.startsWith("--") ? "--" + this.option : "-" + this.option;
        }

        public String toString() {
            return this.getDisplayName();
        }
    }
}

