# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class CertificateUsage(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Activities for which the cryptographic certificate can be used."""

    DIGITAL_SIGNATURE = "digitalSignature"
    """This certificate can be used to add a signature to a message"""
    NON_REPUDIATION = "nonRepudiation"
    """This certificates provides a non-repudiation service that protects against false denial of a
    message"""
    CONTENT_COMMITMENT = "contentCommitment"
    """A synonym for NonRepudiation used in newer x509 certificates"""
    KEY_ENCIPHERMENT = "keyEncipherment"
    """This certificate can be used to encrypt a private or secret key"""
    DATA_ENCIPHERMENT = "dataEncipherment"
    """This certificate can be used to decrypt a private or secret key"""
    KEY_AGREEMENT = "keyAgreement"
    """This certificate can be used to perform a key agreement, such as with a Diffie-Hellman key
    exchange"""
    KEY_CERT_SIGN = "keyCertSign"
    """This certificate can be used to verify a other public keys"""
    CRL_SIGN = "crlSign"
    """This certificate can be used to verify a certificate revocation list"""
    ENCIPHER_ONLY = "encipherOnly"
    """This certificate can be only be used to encrypt data"""
    DECIPHER_ONLY = "decipherOnly"
    """This certificate can only be used to decrypt data"""
    SERVER_AUTHENTICATION = "serverAuth"
    """This certificate can be used to authenticate a server in a TLS/SSL connection"""
    CLIENT_AUTHENTICATION = "clientAuth"
    """This certificate can be used to authenticate a client in a TLS/SSL connection"""
    CODE_SIGNING = "codeSigning"
    """This certificate can be used to authenticate a code object"""
    EMAIL_PROTECTION = "emailProtection"
    """This certificate can be used to authenticate an email address"""
    TIME_STAMPING = "timeStamping"
    """This certificate binds the hash of an object to a time"""
    OCSP_SIGNING = "ocspSigning"
    """This certificate can be used to sign OCSP responses"""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class CryptoKeyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Different types of cryptographic keys."""

    PUBLIC = "Public"
    """The key is an asymmetric public key."""
    PRIVATE = "Private"
    """The key is an asymmetric private key."""


class ExecutableClass(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """String to indicate if the executable is 32 or 64 bit."""

    X86 = "x86"
    """The binary is 32-bit."""
    X64 = "x64"
    """The binary is 64-bit."""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of a firmware analysis job."""

    SUCCEEDED = "Succeeded"
    """The request has successfully completed."""
    FAILED = "Failed"
    """There was an error during the request."""
    CANCELED = "Canceled"
    """The request was canceled."""
    PENDING = "Pending"
    """The request is queued and awaiting execution"""
    EXTRACTING = "Extracting"
    """The Firmware is currently being extracted."""
    ANALYZING = "Analyzing"
    """Analysis is being run on the firmware"""


class SkuTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This field is required to be implemented by the Resource Provider if the service has more than
    one tier, but is not required on a PUT.
    """

    FREE = "Free"
    """The Free service tier."""
    BASIC = "Basic"
    """The Basic service tier."""
    STANDARD = "Standard"
    """The Standard service tier."""
    PREMIUM = "Premium"
    """The Premium service tier."""


class Status(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of a firmware analysis job."""

    PENDING = "Pending"
    """The analysis job is queued"""
    EXTRACTING = "Extracting"
    """The firmware is currently being extracted"""
    ANALYZING = "Analyzing"
    """Analysis is being run on the firmware"""
    READY = "Ready"
    """Analysis job results are ready"""
    ERROR = "Error"
    """An error occurred while running firmware analysis"""


class SummaryType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes the type of summary."""

    FIRMWARE = "Firmware"
    """The summary contains information about the submitted firmware"""
    COMMON_VULNERABILITIES_AND_EXPOSURES = "CommonVulnerabilitiesAndExposures"
    """The summary contains information about the Common Vulnerabilities and Exposures analysis
    results"""
    BINARY_HARDENING = "BinaryHardening"
    """The summary contains information about the binary hardening analysis results"""
    CRYPTO_CERTIFICATE = "CryptoCertificate"
    """The summary contains information about the cryptographic certificate analysis results"""
    CRYPTO_KEY = "CryptoKey"
    """The summary contains information about the cryptographic key analysis results"""
