#
# @file    TestSBMLConvert.py
# @brief   SBMLConvert unit tests
#
# @author  Akiya Jouraku (Python conversion)
# @author  Ben Bornstein 
# 
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/sbml/test/TestSBMLConvert.c
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------

import sys
import unittest
import libsbml


class TestSBMLConvert(unittest.TestCase):


  def test_SBMLConvert_addModifiersToReaction(self):
    d = libsbml.SBMLDocument(1,2)
    m = d.createModel()
    r = m.createReaction()
    kl = r.createKineticLaw()
    kl.setFormula( "k1*S1*S2*S3*S4*S5")
    s1 = m.createSpecies()
    s1.setId( "S1" )
    s2 = m.createSpecies()
    s2.setId( "S2")
    s3 = m.createSpecies()
    s3.setId( "S3")
    s4 = m.createSpecies()
    s4.setId( "S4")
    s5 = m.createSpecies()
    s5.setId( "S5")
    sr1 = r.createReactant()
    sr2 = r.createReactant()
    sr3 = r.createProduct()
    sr1.setSpecies( "S1")
    sr2.setSpecies( "S2")
    sr3.setSpecies( "S5")
    self.assertTrue( r.getNumModifiers() == 0 )
    self.assertTrue( d.setLevelAndVersion(2,1,False) == True )
    self.assertTrue( d.getLevel() == 2 )
    self.assertTrue( d.getVersion() == 1 )
    self.assertTrue( m.getReaction(0).getNumModifiers() == 2 )
    ssr1 = m.getReaction(0).getModifier(0)
    ssr2 = m.getReaction(0).getModifier(1)
    self.assertTrue((  "S3" == ssr1.getSpecies() ))
    self.assertTrue((  "S4" == ssr2.getSpecies() ))
    _dummyList = [ d ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBMLConvert_convertFromL3(self):
    d = libsbml.SBMLDocument(3,1)
    m = d.createModel()
    sid =  "C";
    c = m.createCompartment()
    c.setId(sid)
    c.setSize(1.2)
    c.setConstant(True)
    c.setSpatialDimensions(3.4)
    self.assertTrue( d.setLevelAndVersion(1,1,True) == False )
    self.assertTrue( d.setLevelAndVersion(1,2,True) == False )
    self.assertTrue( d.setLevelAndVersion(2,1,True) == False )
    self.assertTrue( d.setLevelAndVersion(2,2,True) == False )
    self.assertTrue( d.setLevelAndVersion(2,3,True) == False )
    self.assertTrue( d.setLevelAndVersion(2,4,True) == False )
    self.assertTrue( d.setLevelAndVersion(3,1,True) == True )
    pass  

  def test_SBMLConvert_convertFromL3_conversionFactor(self):
    d = libsbml.SBMLDocument(3,1)
    m = d.createModel()
    sid =  "P";
    m.setConversionFactor(sid)
    c = m.createParameter()
    c.setId(sid)
    c.setConstant(True)
    self.assertTrue( d.setLevelAndVersion(1,1,True) == False )
    self.assertTrue( d.setLevelAndVersion(1,2,True) == False )
    self.assertTrue( d.setLevelAndVersion(2,1,True) == False )
    self.assertTrue( d.setLevelAndVersion(2,2,True) == False )
    self.assertTrue( d.setLevelAndVersion(2,3,True) == False )
    self.assertTrue( d.setLevelAndVersion(2,4,True) == False )
    self.assertTrue( d.setLevelAndVersion(3,1,True) == True )
    pass  

  def test_SBMLConvert_convertFromL3_initialValue(self):
    d = libsbml.SBMLDocument(3,1)
    m = d.createModel()
    e = m.createEvent()
    t = e.createTrigger()
    t.setInitialValue(False)
    self.assertTrue( d.setLevelAndVersion(1,1,False) == False )
    self.assertTrue( d.setLevelAndVersion(1,2,False) == True )
    self.assertTrue( d.setLevelAndVersion(2,1,False) == True )
    self.assertTrue( d.setLevelAndVersion(2,2,False) == True )
    self.assertTrue( d.setLevelAndVersion(2,3,False) == True )
    self.assertTrue( d.setLevelAndVersion(2,4,False) == True )
    self.assertTrue( d.setLevelAndVersion(3,1,False) == True )
    pass  

  def test_SBMLConvert_convertFromL3_modelUnits(self):
    d = libsbml.SBMLDocument(3,1)
    m = d.createModel()
    m.setVolumeUnits( "litre")
    self.assertTrue( m.getNumUnitDefinitions() == 0 )
    self.assertTrue( d.setLevelAndVersion(2,4,False) == True )
    m = d.getModel()
    self.assertTrue( m.getNumUnitDefinitions() == 1 )
    ud = m.getUnitDefinition(0)
    self.assertTrue((  "volume" == ud.getId() ))
    self.assertTrue( ud.getNumUnits() == 1 )
    self.assertTrue( ud.getUnit(0).getKind() == libsbml.UNIT_KIND_LITRE )
    pass  

  def test_SBMLConvert_convertFromL3_persistent(self):
    d = libsbml.SBMLDocument(3,1)
    m = d.createModel()
    e = m.createEvent()
    t = e.createTrigger()
    t.setPersistent(False)
    self.assertTrue( d.setLevelAndVersion(1,1,False) == False )
    self.assertTrue( d.setLevelAndVersion(1,2,False) == True )
    self.assertTrue( d.setLevelAndVersion(2,1,False) == True )
    self.assertTrue( d.setLevelAndVersion(2,2,False) == True )
    self.assertTrue( d.setLevelAndVersion(2,3,False) == True )
    self.assertTrue( d.setLevelAndVersion(2,4,False) == True )
    self.assertTrue( d.setLevelAndVersion(3,1,False) == True )
    pass  

  def test_SBMLConvert_convertFromL3_priority(self):
    d = libsbml.SBMLDocument(3,1)
    m = d.createModel()
    e = m.createEvent()
    p = e.createPriority()
    self.assertTrue( d.setLevelAndVersion(1,1,False) == False )
    self.assertTrue( d.setLevelAndVersion(1,2,False) == True )
    self.assertTrue( d.setLevelAndVersion(2,1,False) == True )
    self.assertTrue( d.setLevelAndVersion(2,2,False) == True )
    self.assertTrue( d.setLevelAndVersion(2,3,False) == True )
    self.assertTrue( d.setLevelAndVersion(2,4,False) == True )
    self.assertTrue( d.setLevelAndVersion(3,1,False) == True )
    pass  

  def test_SBMLConvert_convertToL1_SBMLDocument(self):
    d = libsbml.SBMLDocument(2,1)
    self.assertTrue( d.setLevelAndVersion(1,2,False) == True )
    self.assertTrue( d.getLevel() == 1 )
    self.assertTrue( d.getVersion() == 2 )
    _dummyList = [ d ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBMLConvert_convertToL1_Species_Amount(self):
    d = libsbml.SBMLDocument(2,1)
    m = d.createModel()
    sid =  "C";
    c = libsbml.Compartment(2,4)
    s = libsbml.Species(2,4)
    c.setId(sid)
    m.addCompartment(c)
    s.setCompartment(sid)
    s.setInitialAmount(2.34)
    m.addSpecies(s)
    self.assertTrue( d.setLevelAndVersion(1,2,True) == True )
    self.assertTrue( s.getInitialAmount() == 2.34 )
    _dummyList = [ d ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBMLConvert_convertToL1_Species_Concentration(self):
    d = libsbml.SBMLDocument(2,1)
    m = d.createModel()
    sid =  "C";
    c = libsbml.Compartment(2,1)
    s = libsbml.Species(2,1)
    c.setId(sid)
    c.setSize(1.2)
    m.addCompartment(c)
    s.setId( "s"  )
    s.setCompartment(sid)
    s.setInitialConcentration(2.34)
    m.addSpecies(s)
    self.assertTrue( d.setLevelAndVersion(1,2,True) == True )
    s1 = m.getSpecies(0)
    self.assertTrue( s1 != None )
    self.assertTrue((  "C" == s1.getCompartment() ))
    self.assertTrue( m.getCompartment( "C").getSize() == 1.2 )
    self.assertTrue( s1.getInitialConcentration() == 2.34 )
    self.assertTrue( s1.isSetInitialConcentration() == True )
    _dummyList = [ d ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBMLConvert_convertToL2_SBMLDocument(self):
    d = libsbml.SBMLDocument(1,2)
    self.assertTrue( d.setLevelAndVersion(2,1,False) == True )
    self.assertTrue( d.getLevel() == 2 )
    self.assertTrue( d.getVersion() == 1 )
    self.assertTrue( d.setLevelAndVersion(2,2,False) == True )
    self.assertTrue( d.getLevel() == 2 )
    self.assertTrue( d.getVersion() == 2 )
    self.assertTrue( d.setLevelAndVersion(2,3,False) == True )
    self.assertTrue( d.getLevel() == 2 )
    self.assertTrue( d.getVersion() == 3 )
    _dummyList = [ d ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBMLConvert_convertToL2v4_DuplicateAnnotations_doc(self):
    d = libsbml.SBMLDocument(2,1)
    d.createModel()
    annotation =  "<rdf/>\n<rdf/>";
    i = (d).setAnnotation(annotation)
    self.assertTrue( d.getLevel() == 2 )
    self.assertTrue( d.getVersion() == 1 )
    self.assertTrue( (d).getAnnotation().getNumChildren() == 2 )
    self.assertTrue( d.setLevelAndVersion(2,4,True) == True )
    self.assertTrue( d.getLevel() == 2 )
    self.assertTrue( d.getVersion() == 4 )
    self.assertTrue( (d).getAnnotation().getNumChildren() == 1 )
    _dummyList = [ d ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBMLConvert_convertToL2v4_DuplicateAnnotations_model(self):
    d = libsbml.SBMLDocument(2,1)
    m = d.createModel()
    annotation =  "<rdf/>\n<rdf/>";
    i = (m).setAnnotation(annotation)
    self.assertTrue( d.getLevel() == 2 )
    self.assertTrue( d.getVersion() == 1 )
    self.assertTrue( (m).getAnnotation().getNumChildren() == 2 )
    self.assertTrue( d.setLevelAndVersion(2,4,True) == True )
    self.assertTrue( d.getLevel() == 2 )
    self.assertTrue( d.getVersion() == 4 )
    m = d.getModel()
    self.assertTrue( (m).getAnnotation().getNumChildren() == 1 )
    _dummyList = [ d ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBMLConvert_convertToL3_compartment(self):
    d = libsbml.SBMLDocument(2,2)
    m = d.createModel()
    sid =  "C";
    c = m.createCompartment()
    c.setId(sid)
    self.assertTrue( d.setLevelAndVersion(3,1,False) == True )
    c1 = m.getCompartment(0)
    self.assertTrue( c1.hasRequiredAttributes() == 1 )
    _dummyList = [ d ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBMLConvert_convertToL3_defaultUnits(self):
    d = libsbml.SBMLDocument(1,2)
    m = d.createModel()
    sid =  "C";
    c = m.createCompartment()
    c.setId(sid)
    c.setSize(1.2)
    c.setUnits( "volume")
    self.assertTrue( m.getNumUnitDefinitions() == 0 )
    self.assertTrue( d.setLevelAndVersion(3,1,True) == True )
    self.assertTrue( m.getNumUnitDefinitions() == 2 )
    ud = m.getUnitDefinition(0)
    self.assertTrue( ud != None )
    self.assertTrue((  "volume" == ud.getId() ))
    self.assertTrue( ud.getNumUnits() == 1 )
    u = ud.getUnit(0)
    self.assertTrue( u.getKind() == libsbml.UNIT_KIND_LITRE )
    self.assertTrue( u.getExponent() == 1 )
    self.assertTrue( u.getMultiplier() == 1 )
    self.assertTrue( u.getScale() == 0 )
    ud = m.getUnitDefinition(1)
    self.assertTrue( ud != None )
    self.assertTrue((  "area" == ud.getId() ))
    self.assertTrue( ud.getNumUnits() == 1 )
    u = ud.getUnit(0)
    self.assertTrue( u.getKind() == libsbml.UNIT_KIND_METRE )
    self.assertTrue( u.getExponent() == 2 )
    self.assertTrue( u.getMultiplier() == 1 )
    self.assertTrue( u.getScale() == 0 )
    self.assertTrue((  "second" == m.getTimeUnits() ))
    _dummyList = [ d ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBMLConvert_convertToL3_event(self):
    d = libsbml.SBMLDocument(2,2)
    m = d.createModel()
    e = m.createEvent()
    self.assertTrue( d.setLevelAndVersion(3,1,False) == True )
    e1 = m.getEvent(0)
    self.assertTrue( e1.hasRequiredAttributes() == 1 )
    _dummyList = [ d ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBMLConvert_convertToL3_localParameters(self):
    d = libsbml.SBMLDocument(1,2)
    m = d.createModel()
    c = m.createCompartment()
    c.setId( "c" )
    s = m.createSpecies()
    s.setId( "s")
    s.setCompartment( "c")
    r = m.createReaction()
    sr = r.createReactant()
    sr.setSpecies( "s")
    kl = r.createKineticLaw()
    kl.setFormula( "s*k")
    p = kl.createParameter()
    p.setId( "k")
    self.assertTrue( kl.getNumLocalParameters() == 0 )
    self.assertTrue( d.setLevelAndVersion(3,1,False) == True )
    m = d.getModel()
    r = m.getReaction(0)
    kl = r.getKineticLaw()
    self.assertTrue( kl.getNumLocalParameters() == 1 )
    lp = kl.getLocalParameter(0)
    _dummyList = [ d ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBMLConvert_convertToL3_parameter(self):
    d = libsbml.SBMLDocument(2,2)
    m = d.createModel()
    sid =  "C";
    p = m.createParameter()
    p.setId(sid)
    self.assertTrue( d.setLevelAndVersion(3,1,False) == True )
    p1 = m.getParameter(0)
    self.assertTrue( p1.hasRequiredAttributes() == 1 )
    _dummyList = [ d ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBMLConvert_convertToL3_product(self):
    d = libsbml.SBMLDocument(2,2)
    m = d.createModel()
    r = m.createReaction()
    sr = r.createProduct()
    sr.setSpecies( "s" )
    self.assertTrue( d.setLevelAndVersion(3,1,False) == True )
    sr1 = m.getReaction(0).getProduct(0)
    self.assertTrue( sr1.hasRequiredAttributes() == 1 )
    _dummyList = [ d ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBMLConvert_convertToL3_reactant(self):
    d = libsbml.SBMLDocument(2,2)
    m = d.createModel()
    r = m.createReaction()
    sr = r.createReactant()
    sr.setSpecies( "s" )
    self.assertTrue( d.setLevelAndVersion(3,1,False) == True )
    sr1 = m.getReaction(0).getReactant(0)
    self.assertTrue( sr1.hasRequiredAttributes() == 1 )
    _dummyList = [ d ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBMLConvert_convertToL3_reaction(self):
    d = libsbml.SBMLDocument(2,2)
    m = d.createModel()
    sid =  "C";
    r = m.createReaction()
    r.setId(sid)
    self.assertTrue( d.setLevelAndVersion(3,1,False) == True )
    r1 = m.getReaction(0)
    self.assertTrue( r1.hasRequiredAttributes() == 1 )
    _dummyList = [ d ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBMLConvert_convertToL3_species(self):
    d = libsbml.SBMLDocument(2,2)
    m = d.createModel()
    sid =  "C";
    s = m.createSpecies()
    s.setId(sid)
    s.setCompartment( "comp")
    self.assertTrue( d.setLevelAndVersion(3,1,False) == True )
    s1 = m.getSpecies(0)
    self.assertTrue( s1.hasRequiredAttributes() == 1 )
    _dummyList = [ d ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBMLConvert_convertToL3_stoichiometryMath(self):
    d = libsbml.SBMLDocument(2,1)
    m = d.createModel()
    c = m.createCompartment()
    c.setId( "c" )
    s = m.createSpecies()
    s.setId( "s")
    s.setCompartment( "c")
    r = m.createReaction()
    sr = r.createReactant()
    sr.setSpecies( "s")
    sm = sr.createStoichiometryMath()
    ast = libsbml.parseFormula("c*2")
    sm.setMath(ast)
    self.assertTrue( m.getNumRules() == 0 )
    self.assertTrue( sr.isSetId() == False )
    self.assertTrue( d.setLevelAndVersion(3,1,False) == True )
    m = d.getModel()
    r = m.getReaction(0)
    sr = r.getReactant(0)
    self.assertTrue( m.getNumRules() == 1 )
    self.assertTrue( sr.isSetId() == True )
    rule = m.getRule(0)
    self.assertTrue( sr.getId() == rule.getVariable() )
    _dummyList = [ d ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBMLConvert_convertToL3_trigger(self):
    d = libsbml.SBMLDocument(2,2)
    m = d.createModel()
    e = m.createEvent()
    t = e.createTrigger()
    self.assertTrue( d.setLevelAndVersion(3,1,False) == True )
    t1 = m.getEvent(0).getTrigger()
    self.assertTrue( t1.hasRequiredAttributes() == 1 )
    _dummyList = [ d ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBMLConvert_convertToL3_unit(self):
    d = libsbml.SBMLDocument(2,2)
    m = d.createModel()
    sid =  "C";
    ud = m.createUnitDefinition()
    ud.setId(sid)
    u = ud.createUnit()
    u.setKind(libsbml.UNIT_KIND_MOLE)
    self.assertTrue( d.setLevelAndVersion(3,1,False) == True )
    u1 = m.getUnitDefinition(0).getUnit(0)
    self.assertTrue( u1.hasRequiredAttributes() == 1 )
    _dummyList = [ d ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBMLConvert_invalidLevelVersion(self):
    d = libsbml.SBMLDocument(2,1)
    m = d.createModel()
    sid =  "C";
    c = m.createCompartment()
    c.setId(sid)
    c.setSize(1.2)
    c.setUnits( "volume")
    self.assertTrue( d.setLevelAndVersion(1,3,True) == False )
    self.assertTrue( d.setLevelAndVersion(2,7,True) == False )
    self.assertTrue( d.setLevelAndVersion(3,5,True) == False )
    self.assertTrue( d.setLevelAndVersion(4,1,True) == False )
    pass  

def suite():
  suite = unittest.TestSuite()
  suite.addTest(unittest.TestLoader.loadTestsFromTestCase(TestSBMLConvert))

  return suite

if __name__ == "__main__":
  if unittest.TextTestRunner(verbosity=1).run(suite()).wasSuccessful() :
    sys.exit(0)
  else:
    sys.exit(1)

