/* { dg-options "-mlasx -w -fno-strict-aliasing" } */
#include "../simd_correctness_check.h"
#include <lasxintrin.h>

int
main ()
{
  __m256i __m256i_op0, __m256i_op1, __m256i_op2, __m256i_out, __m256i_result;
  __m256 __m256_op0, __m256_op1, __m256_op2, __m256_out, __m256_result;
  __m256d __m256d_op0, __m256d_op1, __m256d_op2, __m256d_out, __m256d_result;

  int int_op0, int_op1, int_op2, int_out, int_result, i = 1, fail;
  long int long_op0, long_op1, long_op2, lont_out, lont_result;
  long int long_int_out, long_int_result;
  unsigned int unsigned_int_out, unsigned_int_result;
  unsigned long int unsigned_long_int_out, unsigned_long_int_result;

  *((unsigned long *)&__m256i_op0[3]) = 0x0006000000040000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0006000000040000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvaddwod_h_bu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x000000007fffffff;
  *((unsigned long *)&__m256i_op0[1]) = 0x7ffe00007f000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x000000007fffffff;
  *((unsigned long *)&__m256i_op1[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[3]) = 0x00ff00ff00ff00ff;
  *((unsigned long *)&__m256i_result[2]) = 0x00ff00ff017e01fe;
  *((unsigned long *)&__m256i_result[1]) = 0x017e00ff017e00ff;
  *((unsigned long *)&__m256i_result[0]) = 0x00ff00ff017e01fe;
  __m256i_out = __lasx_xvaddwod_h_bu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xb70036db12c4007e;
  *((unsigned long *)&__m256i_op0[2]) = 0xb7146213fc1e0049;
  *((unsigned long *)&__m256i_op0[1]) = 0x000000fefe02fffe;
  *((unsigned long *)&__m256i_op0[0]) = 0xb71c413b199d04b5;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x00b7003600120000;
  *((unsigned long *)&__m256i_result[2]) = 0x00b7006200fc0000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000fe00ff;
  *((unsigned long *)&__m256i_result[0]) = 0x00b7004100190004;
  __m256i_out = __lasx_xvaddwod_h_bu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x000000007aff7c00;
  *((unsigned long *)&__m256i_op0[2]) = 0xfffffffffd017d00;
  *((unsigned long *)&__m256i_op0[1]) = 0x000000007aff7c00;
  *((unsigned long *)&__m256i_op0[0]) = 0xfffffffffd017d00;
  *((unsigned long *)&__m256i_op1[3]) = 0x00000000008e7c00;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000067751500;
  *((unsigned long *)&__m256i_op1[1]) = 0x00000000008e7c00;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000067751500;
  *((unsigned long *)&__m256i_result[3]) = 0x00000000007a00f8;
  *((unsigned long *)&__m256i_result[2]) = 0x00ff00ff01640092;
  *((unsigned long *)&__m256i_result[1]) = 0x00000000007a00f8;
  *((unsigned long *)&__m256i_result[0]) = 0x00ff00ff01640092;
  __m256i_out = __lasx_xvaddwod_h_bu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0xfffefffefffefffe;
  *((unsigned long *)&__m256i_op1[2]) = 0xfffa0078fffa0074;
  *((unsigned long *)&__m256i_op1[1]) = 0xfffefffefffefffe;
  *((unsigned long *)&__m256i_op1[0]) = 0xfffa0078fffa0074;
  *((unsigned long *)&__m256i_result[3]) = 0x00ff00ff00ff00ff;
  *((unsigned long *)&__m256i_result[2]) = 0x00ff000000ff0000;
  *((unsigned long *)&__m256i_result[1]) = 0x00ff00ff00ff00ff;
  *((unsigned long *)&__m256i_result[0]) = 0x00ff000000ff0000;
  __m256i_out = __lasx_xvaddwod_h_bu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x00ff00ff00ff00ff;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x00ff00ff00ff00ff;
  __m256i_out = __lasx_xvaddwod_h_bu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x00ff00ff00ff00ff;
  *((unsigned long *)&__m256i_op0[2]) = 0x00ff00ff00ff00ff;
  *((unsigned long *)&__m256i_op0[1]) = 0x00ff00ff00ff00ff;
  *((unsigned long *)&__m256i_op0[0]) = 0x00ff00ff00ff00ff;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvaddwod_h_bu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0xffff800000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0xffff800000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0xffff800000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0xffff800000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x00ff008000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x00ff008000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x00ff008000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x00ff008000000000;
  __m256i_out = __lasx_xvaddwod_h_bu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x00000000ffff0020;
  *((unsigned long *)&__m256i_op0[2]) = 0xffff8001ffff0001;
  *((unsigned long *)&__m256i_op0[1]) = 0x00000000ffff0020;
  *((unsigned long *)&__m256i_op0[0]) = 0xffff8001ffff0001;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000ff0000;
  *((unsigned long *)&__m256i_result[2]) = 0x00ff008000ff0000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000ff0000;
  *((unsigned long *)&__m256i_result[0]) = 0x00ff008000ff0000;
  __m256i_out = __lasx_xvaddwod_h_bu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0xffff000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0xffff000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000ffff00000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000ffff00000000;
  __m256i_out = __lasx_xvaddwod_w_hu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000800000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000804000004141;
  *((unsigned long *)&__m256i_op0[1]) = 0x00017fff0000ffff;
  *((unsigned long *)&__m256i_op0[0]) = 0x00007fff0000ffff;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000100000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvaddwod_w_hu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvaddwod_w_hu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000044444443;
  *((unsigned long *)&__m256i_op1[2]) = 0x7bbbbbbbf7777778;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000044444443;
  *((unsigned long *)&__m256i_op1[0]) = 0x7bbbbbbbf7777778;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000004444;
  *((unsigned long *)&__m256i_result[2]) = 0x00007bbb0000f777;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000004444;
  *((unsigned long *)&__m256i_result[0]) = 0x00007bbb0000f777;
  __m256i_out = __lasx_xvaddwod_w_hu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x4010000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x3e6ce7d9cb7afb62;
  *((unsigned long *)&__m256i_op0[1]) = 0x4010000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x3e6ce7d9cb7afb62;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000401000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x00003e6c0000cb7a;
  *((unsigned long *)&__m256i_result[1]) = 0x0000401000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x00003e6c0000cb7a;
  __m256i_out = __lasx_xvaddwod_w_hu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x3aadec4f6c7975b1;
  *((unsigned long *)&__m256i_op0[2]) = 0x3abac5447fffca89;
  *((unsigned long *)&__m256i_op0[1]) = 0x3aadec4f6c7975b1;
  *((unsigned long *)&__m256i_op0[0]) = 0x3abac5447fffca89;
  *((unsigned long *)&__m256i_op1[3]) = 0x3aadec4f6c7975b1;
  *((unsigned long *)&__m256i_op1[2]) = 0x3abac5447fffca89;
  *((unsigned long *)&__m256i_op1[1]) = 0x3aadec4f6c7975b1;
  *((unsigned long *)&__m256i_op1[0]) = 0x3abac5447fffca89;
  *((unsigned long *)&__m256i_result[3]) = 0x0000755a0000d8f2;
  *((unsigned long *)&__m256i_result[2]) = 0x000075740000fffe;
  *((unsigned long *)&__m256i_result[1]) = 0x0000755a0000d8f2;
  *((unsigned long *)&__m256i_result[0]) = 0x000075740000fffe;
  __m256i_out = __lasx_xvaddwod_w_hu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000002000000020;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000002000000020;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000002000000020;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000002000000020;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0xffffffffffee00ba;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0xffffffffffee00ba;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000ffff0000ffee;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000ffff0000ffee;
  __m256i_out = __lasx_xvaddwod_w_hu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x9ffffd8020010001;
  *((unsigned long *)&__m256i_op1[2]) = 0xfffffff9fffffff9;
  *((unsigned long *)&__m256i_op1[1]) = 0x9ffffd8020010001;
  *((unsigned long *)&__m256i_op1[0]) = 0xfffffff9fffffff9;
  *((unsigned long *)&__m256i_result[3]) = 0x00009fff00002001;
  *((unsigned long *)&__m256i_result[2]) = 0x0000ffff0000ffff;
  *((unsigned long *)&__m256i_result[1]) = 0x00009fff00002001;
  *((unsigned long *)&__m256i_result[0]) = 0x0000ffff0000ffff;
  __m256i_out = __lasx_xvaddwod_w_hu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000010001;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000010001;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000010001;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000010001;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000001;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000001;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000001;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000001;
  __m256i_out = __lasx_xvaddwod_w_hu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000001a00000001;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000900000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000001a00000001;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000900000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x000000000000001a;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000009;
  *((unsigned long *)&__m256i_result[1]) = 0x000000000000001a;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000009;
  __m256i_out = __lasx_xvaddwod_d_wu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvaddwod_d_wu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x8000800000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x8000800000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x8000800000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x8000800000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x8000800000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x8000800000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x8000800000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x8000800000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000100010000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000100010000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000100010000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000100010000;
  __m256i_out = __lasx_xvaddwod_d_wu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xffffffffffffffee;
  *((unsigned long *)&__m256i_op0[2]) = 0xffffffffffffffee;
  *((unsigned long *)&__m256i_op0[1]) = 0xffffffffffffffee;
  *((unsigned long *)&__m256i_op0[0]) = 0xffffffffffffffee;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_result[2]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_result[1]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_result[0]) = 0x00000000ffffffff;
  __m256i_out = __lasx_xvaddwod_d_wu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x00000000003f0000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000030007;
  *((unsigned long *)&__m256i_op0[1]) = 0x00000000003f0000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000030007;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000ffffffffffff;
  *((unsigned long *)&__m256i_op1[2]) = 0x00153f1594ea02ff;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000ffffffff0100;
  *((unsigned long *)&__m256i_op1[0]) = 0xff15c1ea95ea02ff;
  *((unsigned long *)&__m256i_result[3]) = 0x000000000000ffff;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000153f15;
  *((unsigned long *)&__m256i_result[1]) = 0x000000000000ffff;
  *((unsigned long *)&__m256i_result[0]) = 0x00000000ff15c1ea;
  __m256i_out = __lasx_xvaddwod_d_wu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xffff040000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0xffff040000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x00ff00ff00fe00fe;
  *((unsigned long *)&__m256i_op1[2]) = 0x00ff00ff00fe00fe;
  *((unsigned long *)&__m256i_op1[1]) = 0x00ff00ff00fe00fe;
  *((unsigned long *)&__m256i_op1[0]) = 0x00ff00ff00fe00fe;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000100fe04ff;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000ff00ff;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000100fe04ff;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000ff00ff;
  __m256i_out = __lasx_xvaddwod_d_wu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000ffff0000ffff;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000ffff0000ffff;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000ffff0000ffff;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000ffff0000ffff;
  *((unsigned long *)&__m256i_result[3]) = 0x000000000000ffff;
  *((unsigned long *)&__m256i_result[2]) = 0x000000000000ffff;
  *((unsigned long *)&__m256i_result[1]) = 0x000000000000ffff;
  *((unsigned long *)&__m256i_result[0]) = 0x000000000000ffff;
  __m256i_out = __lasx_xvaddwod_d_wu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000ffff0000ffff;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000ffff00000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000ffff0000ffff;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000ffff00000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x000000000003ffff;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x000000000000ffff;
  *((unsigned long *)&__m256i_result[2]) = 0x000000000000ffff;
  *((unsigned long *)&__m256i_result[1]) = 0x000000000000ffff;
  *((unsigned long *)&__m256i_result[0]) = 0x000000000000ffff;
  __m256i_out = __lasx_xvaddwod_d_wu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x00f9f9f900000002;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x00f9f9f900000002;
  *((unsigned long *)&__m256i_op1[3]) = 0xf9f9f9f9f9f9f9f9;
  *((unsigned long *)&__m256i_op1[2]) = 0xf9f9f9f9f9f9f9f9;
  *((unsigned long *)&__m256i_op1[1]) = 0xf9f9f9f9f9f9f9f9;
  *((unsigned long *)&__m256i_op1[0]) = 0xf9f9f9f9f9f9f9f9;
  *((unsigned long *)&__m256i_result[3]) = 0x00000000f9f9f9f9;
  *((unsigned long *)&__m256i_result[2]) = 0x00000000faf3f3f2;
  *((unsigned long *)&__m256i_result[1]) = 0x00000000f9f9f9f9;
  *((unsigned long *)&__m256i_result[0]) = 0x00000000faf3f3f2;
  __m256i_out = __lasx_xvaddwod_d_wu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000001fff000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000029170;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000001fff000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000029170;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvaddwod_d_wu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvaddwod_q_du (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x7fffffff7fffffff;
  *((unsigned long *)&__m256i_op0[2]) = 0x7fffffff7fffffff;
  *((unsigned long *)&__m256i_op0[1]) = 0x7fffffff7fffffff;
  *((unsigned long *)&__m256i_op0[0]) = 0x7fffffff7fffffff;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x7fffffff7fffffff;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x7fffffff7fffffff;
  __m256i_out = __lasx_xvaddwod_q_du (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xc3f0c3f0c3f0c3f0;
  *((unsigned long *)&__m256i_op0[2]) = 0xc3f0c3f0c3f0c3f0;
  *((unsigned long *)&__m256i_op0[1]) = 0xc3f0c3f0c3f0c3f0;
  *((unsigned long *)&__m256i_op0[0]) = 0xc3f0c3f0c3f0c3f0;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0xc3f0c3f0c3f0c3f0;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0xc3f0c3f0c3f0c3f0;
  __m256i_out = __lasx_xvaddwod_q_du (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xff00ff00ff00ef32;
  *((unsigned long *)&__m256i_op0[2]) = 0xff00ff00ff00ef32;
  *((unsigned long *)&__m256i_op0[1]) = 0xff00ff00ff00ef32;
  *((unsigned long *)&__m256i_op0[0]) = 0xff00ff00ff00ef32;
  *((unsigned long *)&__m256i_op1[3]) = 0xe7e7e7e7e7e7e7e7;
  *((unsigned long *)&__m256i_op1[2]) = 0xe7e7e7e7e7e7e7e7;
  *((unsigned long *)&__m256i_op1[1]) = 0xe7e7e7e7e7e7e7e7;
  *((unsigned long *)&__m256i_op1[0]) = 0xe7e7e7e7e7e7e7e7;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000001;
  *((unsigned long *)&__m256i_result[2]) = 0xe6e8e6e8e6e8d719;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000001;
  *((unsigned long *)&__m256i_result[0]) = 0xe6e8e6e8e6e8d719;
  __m256i_out = __lasx_xvaddwod_q_du (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvaddwod_q_du (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvaddwod_q_du (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x000800400010006d;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x000800400010006d;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x000800400010006d;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x000800400010006d;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvaddwod_q_du (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[2]) = 0x00000000003fffff;
  *((unsigned long *)&__m256i_op0[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[0]) = 0x00000000003fffff;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0xffffffffffffffff;
  __m256i_out = __lasx_xvaddwod_q_du (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  return 0;
}
