// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

// DO NOT EDIT THIS FILE! IT IS AUTOGENERATED
// FROM /src/coreclr/tools/Common/JitInterface/ThunkGenerator/InstructionSetDesc.txt
// using /src/coreclr/tools/Common/JitInterface/ThunkGenerator/gen.bat

#ifndef CORINFOINSTRUCTIONSET_H
#define CORINFOINSTRUCTIONSET_H

#include "readytoruninstructionset.h"
#include <stdint.h>

enum CORINFO_InstructionSet
{
    InstructionSet_ILLEGAL = 0,
    InstructionSet_NONE = 127,
#ifdef TARGET_ARM64
    InstructionSet_ArmBase=1,
    InstructionSet_AdvSimd=2,
    InstructionSet_Aes=3,
    InstructionSet_Crc32=4,
    InstructionSet_Dp=5,
    InstructionSet_Rdm=6,
    InstructionSet_Sha1=7,
    InstructionSet_Sha256=8,
    InstructionSet_Atomics=9,
    InstructionSet_Vector64=10,
    InstructionSet_Vector128=11,
    InstructionSet_Dczva=12,
    InstructionSet_Rcpc=13,
    InstructionSet_VectorT128=14,
    InstructionSet_Rcpc2=15,
    InstructionSet_Sve=16,
    InstructionSet_Sve2=17,
    InstructionSet_ArmBase_Arm64=18,
    InstructionSet_AdvSimd_Arm64=19,
    InstructionSet_Aes_Arm64=20,
    InstructionSet_Crc32_Arm64=21,
    InstructionSet_Dp_Arm64=22,
    InstructionSet_Rdm_Arm64=23,
    InstructionSet_Sha1_Arm64=24,
    InstructionSet_Sha256_Arm64=25,
    InstructionSet_Sve_Arm64=26,
    InstructionSet_Sve2_Arm64=27,
#endif // TARGET_ARM64
#ifdef TARGET_RISCV64
    InstructionSet_RiscV64Base=1,
    InstructionSet_Zba=2,
    InstructionSet_Zbb=3,
#endif // TARGET_RISCV64
#ifdef TARGET_AMD64
    InstructionSet_X86Base=1,
    InstructionSet_SSE42=2,
    InstructionSet_AVX=3,
    InstructionSet_AVX2=4,
    InstructionSet_AVX512=5,
    InstructionSet_AVX512v2=6,
    InstructionSet_AVX512v3=7,
    InstructionSet_AVX10v1=8,
    InstructionSet_AVX10v2=9,
    InstructionSet_APX=10,
    InstructionSet_AES=11,
    InstructionSet_AES_V256=12,
    InstructionSet_AES_V512=13,
    InstructionSet_AVX512VP2INTERSECT=14,
    InstructionSet_AVXIFMA=15,
    InstructionSet_AVXVNNI=16,
    InstructionSet_GFNI=17,
    InstructionSet_GFNI_V256=18,
    InstructionSet_GFNI_V512=19,
    InstructionSet_SHA=20,
    InstructionSet_WAITPKG=21,
    InstructionSet_X86Serialize=22,
    InstructionSet_Vector128=23,
    InstructionSet_Vector256=24,
    InstructionSet_Vector512=25,
    InstructionSet_VectorT128=26,
    InstructionSet_VectorT256=27,
    InstructionSet_VectorT512=28,
    InstructionSet_AVXVNNIINT=29,
    InstructionSet_AVXVNNIINT_V512=30,
    InstructionSet_X86Base_X64=31,
    InstructionSet_SSE42_X64=32,
    InstructionSet_AVX_X64=33,
    InstructionSet_AVX2_X64=34,
    InstructionSet_AVX512_X64=35,
    InstructionSet_AVX512v2_X64=36,
    InstructionSet_AVX512v3_X64=37,
    InstructionSet_AVX10v1_X64=38,
    InstructionSet_AVX10v2_X64=39,
    InstructionSet_AES_X64=40,
    InstructionSet_AVX512VP2INTERSECT_X64=41,
    InstructionSet_AVXIFMA_X64=42,
    InstructionSet_AVXVNNI_X64=43,
    InstructionSet_GFNI_X64=44,
    InstructionSet_SHA_X64=45,
    InstructionSet_WAITPKG_X64=46,
    InstructionSet_X86Serialize_X64=47,
#endif // TARGET_AMD64
#ifdef TARGET_X86
    InstructionSet_X86Base=1,
    InstructionSet_SSE42=2,
    InstructionSet_AVX=3,
    InstructionSet_AVX2=4,
    InstructionSet_AVX512=5,
    InstructionSet_AVX512v2=6,
    InstructionSet_AVX512v3=7,
    InstructionSet_AVX10v1=8,
    InstructionSet_AVX10v2=9,
    InstructionSet_APX=10,
    InstructionSet_AES=11,
    InstructionSet_AES_V256=12,
    InstructionSet_AES_V512=13,
    InstructionSet_AVX512VP2INTERSECT=14,
    InstructionSet_AVXIFMA=15,
    InstructionSet_AVXVNNI=16,
    InstructionSet_GFNI=17,
    InstructionSet_GFNI_V256=18,
    InstructionSet_GFNI_V512=19,
    InstructionSet_SHA=20,
    InstructionSet_WAITPKG=21,
    InstructionSet_X86Serialize=22,
    InstructionSet_Vector128=23,
    InstructionSet_Vector256=24,
    InstructionSet_Vector512=25,
    InstructionSet_VectorT128=26,
    InstructionSet_VectorT256=27,
    InstructionSet_VectorT512=28,
    InstructionSet_AVXVNNIINT=29,
    InstructionSet_AVXVNNIINT_V512=30,
    InstructionSet_X86Base_X64=31,
    InstructionSet_SSE42_X64=32,
    InstructionSet_AVX_X64=33,
    InstructionSet_AVX2_X64=34,
    InstructionSet_AVX512_X64=35,
    InstructionSet_AVX512v2_X64=36,
    InstructionSet_AVX512v3_X64=37,
    InstructionSet_AVX10v1_X64=38,
    InstructionSet_AVX10v2_X64=39,
    InstructionSet_AES_X64=40,
    InstructionSet_AVX512VP2INTERSECT_X64=41,
    InstructionSet_AVXIFMA_X64=42,
    InstructionSet_AVXVNNI_X64=43,
    InstructionSet_GFNI_X64=44,
    InstructionSet_SHA_X64=45,
    InstructionSet_WAITPKG_X64=46,
    InstructionSet_X86Serialize_X64=47,
#endif // TARGET_X86

};

struct CORINFO_InstructionSetFlags
{
private:
    static const int32_t FlagsFieldCount = 2;
    static const int32_t BitsPerFlagsField = sizeof(uint64_t) * 8;
    uint64_t _flags[FlagsFieldCount] = { };


    static uint32_t GetFlagsFieldIndex(CORINFO_InstructionSet instructionSet)
    {
        uint32_t bitIndex = (uint32_t)instructionSet;
        return (uint32_t)(bitIndex / (uint32_t)BitsPerFlagsField);
    }

    static uint64_t GetRelativeBitMask(CORINFO_InstructionSet instructionSet)
    {
        return ((uint64_t)1) << (instructionSet & 0x3F);
    }

public:

    const int GetInstructionFlagsFieldCount() const
    {
        return FlagsFieldCount;
    }

    void AddInstructionSet(CORINFO_InstructionSet instructionSet)
    {
        uint32_t index = GetFlagsFieldIndex(instructionSet);
        _flags[index] |= GetRelativeBitMask(instructionSet);
    }

    void RemoveInstructionSet(CORINFO_InstructionSet instructionSet)
    {
        uint32_t index = GetFlagsFieldIndex(instructionSet);
        uint64_t bitIndex = GetRelativeBitMask(instructionSet);
        _flags[index] &= ~bitIndex;
    }

    bool HasInstructionSet(CORINFO_InstructionSet instructionSet) const
    {
        uint32_t index = GetFlagsFieldIndex(instructionSet);
        uint64_t bitIndex = GetRelativeBitMask(instructionSet);
        return ((_flags[index] & bitIndex) != 0);
    }

    bool Equals(CORINFO_InstructionSetFlags other) const
    {
        for (int i = 0; i < FlagsFieldCount; i++)
        {
            if (_flags[i] != other._flags[i])
            {
                return false;
            }

        }
        return true;
    }

    void Add(CORINFO_InstructionSetFlags other)
    {
        for (int i = 0; i < FlagsFieldCount; i++)
        {
            _flags[i] |= other._flags[i];
        }
    }

    bool IsEmpty() const
    {
        for (int i = 0; i < FlagsFieldCount; i++)
        {
            if (_flags[i] != 0)
            {
                return false;
            }

        }
        return true;
    }

    void Reset()
    {
        for (int i = 0; i < FlagsFieldCount; i++)
        {
            _flags[i] = 0;
        }
    }

    void Set64BitInstructionSetVariants()
    {
#ifdef TARGET_ARM64
        if (HasInstructionSet(InstructionSet_ArmBase))
            AddInstructionSet(InstructionSet_ArmBase_Arm64);
        if (HasInstructionSet(InstructionSet_AdvSimd))
            AddInstructionSet(InstructionSet_AdvSimd_Arm64);
        if (HasInstructionSet(InstructionSet_Aes))
            AddInstructionSet(InstructionSet_Aes_Arm64);
        if (HasInstructionSet(InstructionSet_Crc32))
            AddInstructionSet(InstructionSet_Crc32_Arm64);
        if (HasInstructionSet(InstructionSet_Dp))
            AddInstructionSet(InstructionSet_Dp_Arm64);
        if (HasInstructionSet(InstructionSet_Rdm))
            AddInstructionSet(InstructionSet_Rdm_Arm64);
        if (HasInstructionSet(InstructionSet_Sha1))
            AddInstructionSet(InstructionSet_Sha1_Arm64);
        if (HasInstructionSet(InstructionSet_Sha256))
            AddInstructionSet(InstructionSet_Sha256_Arm64);
        if (HasInstructionSet(InstructionSet_Sve))
            AddInstructionSet(InstructionSet_Sve_Arm64);
        if (HasInstructionSet(InstructionSet_Sve2))
            AddInstructionSet(InstructionSet_Sve2_Arm64);
#endif // TARGET_ARM64
#ifdef TARGET_RISCV64
#endif // TARGET_RISCV64
#ifdef TARGET_AMD64
        if (HasInstructionSet(InstructionSet_X86Base))
            AddInstructionSet(InstructionSet_X86Base_X64);
        if (HasInstructionSet(InstructionSet_SSE42))
            AddInstructionSet(InstructionSet_SSE42_X64);
        if (HasInstructionSet(InstructionSet_AVX))
            AddInstructionSet(InstructionSet_AVX_X64);
        if (HasInstructionSet(InstructionSet_AVX2))
            AddInstructionSet(InstructionSet_AVX2_X64);
        if (HasInstructionSet(InstructionSet_AVX512))
            AddInstructionSet(InstructionSet_AVX512_X64);
        if (HasInstructionSet(InstructionSet_AVX512v2))
            AddInstructionSet(InstructionSet_AVX512v2_X64);
        if (HasInstructionSet(InstructionSet_AVX512v3))
            AddInstructionSet(InstructionSet_AVX512v3_X64);
        if (HasInstructionSet(InstructionSet_AVX10v1))
            AddInstructionSet(InstructionSet_AVX10v1_X64);
        if (HasInstructionSet(InstructionSet_AVX10v2))
            AddInstructionSet(InstructionSet_AVX10v2_X64);
        if (HasInstructionSet(InstructionSet_AES))
            AddInstructionSet(InstructionSet_AES_X64);
        if (HasInstructionSet(InstructionSet_AVX512VP2INTERSECT))
            AddInstructionSet(InstructionSet_AVX512VP2INTERSECT_X64);
        if (HasInstructionSet(InstructionSet_AVXIFMA))
            AddInstructionSet(InstructionSet_AVXIFMA_X64);
        if (HasInstructionSet(InstructionSet_AVXVNNI))
            AddInstructionSet(InstructionSet_AVXVNNI_X64);
        if (HasInstructionSet(InstructionSet_GFNI))
            AddInstructionSet(InstructionSet_GFNI_X64);
        if (HasInstructionSet(InstructionSet_SHA))
            AddInstructionSet(InstructionSet_SHA_X64);
        if (HasInstructionSet(InstructionSet_WAITPKG))
            AddInstructionSet(InstructionSet_WAITPKG_X64);
        if (HasInstructionSet(InstructionSet_X86Serialize))
            AddInstructionSet(InstructionSet_X86Serialize_X64);
#endif // TARGET_AMD64
#ifdef TARGET_X86
#endif // TARGET_X86

    }

    uint64_t* GetFlagsRaw()
    {
        return _flags;
    }
};

inline CORINFO_InstructionSetFlags EnsureInstructionSetFlagsAreValid(CORINFO_InstructionSetFlags input)
{
    CORINFO_InstructionSetFlags oldflags = input;
    CORINFO_InstructionSetFlags resultflags = input;
    do
    {
        oldflags = resultflags;
#ifdef TARGET_ARM64
        if (resultflags.HasInstructionSet(InstructionSet_ArmBase) && !resultflags.HasInstructionSet(InstructionSet_ArmBase_Arm64))
            resultflags.RemoveInstructionSet(InstructionSet_ArmBase);
        if (resultflags.HasInstructionSet(InstructionSet_ArmBase_Arm64) && !resultflags.HasInstructionSet(InstructionSet_ArmBase))
            resultflags.RemoveInstructionSet(InstructionSet_ArmBase_Arm64);
        if (resultflags.HasInstructionSet(InstructionSet_AdvSimd) && !resultflags.HasInstructionSet(InstructionSet_AdvSimd_Arm64))
            resultflags.RemoveInstructionSet(InstructionSet_AdvSimd);
        if (resultflags.HasInstructionSet(InstructionSet_AdvSimd_Arm64) && !resultflags.HasInstructionSet(InstructionSet_AdvSimd))
            resultflags.RemoveInstructionSet(InstructionSet_AdvSimd_Arm64);
        if (resultflags.HasInstructionSet(InstructionSet_Aes) && !resultflags.HasInstructionSet(InstructionSet_Aes_Arm64))
            resultflags.RemoveInstructionSet(InstructionSet_Aes);
        if (resultflags.HasInstructionSet(InstructionSet_Aes_Arm64) && !resultflags.HasInstructionSet(InstructionSet_Aes))
            resultflags.RemoveInstructionSet(InstructionSet_Aes_Arm64);
        if (resultflags.HasInstructionSet(InstructionSet_Crc32) && !resultflags.HasInstructionSet(InstructionSet_Crc32_Arm64))
            resultflags.RemoveInstructionSet(InstructionSet_Crc32);
        if (resultflags.HasInstructionSet(InstructionSet_Crc32_Arm64) && !resultflags.HasInstructionSet(InstructionSet_Crc32))
            resultflags.RemoveInstructionSet(InstructionSet_Crc32_Arm64);
        if (resultflags.HasInstructionSet(InstructionSet_Dp) && !resultflags.HasInstructionSet(InstructionSet_Dp_Arm64))
            resultflags.RemoveInstructionSet(InstructionSet_Dp);
        if (resultflags.HasInstructionSet(InstructionSet_Dp_Arm64) && !resultflags.HasInstructionSet(InstructionSet_Dp))
            resultflags.RemoveInstructionSet(InstructionSet_Dp_Arm64);
        if (resultflags.HasInstructionSet(InstructionSet_Rdm) && !resultflags.HasInstructionSet(InstructionSet_Rdm_Arm64))
            resultflags.RemoveInstructionSet(InstructionSet_Rdm);
        if (resultflags.HasInstructionSet(InstructionSet_Rdm_Arm64) && !resultflags.HasInstructionSet(InstructionSet_Rdm))
            resultflags.RemoveInstructionSet(InstructionSet_Rdm_Arm64);
        if (resultflags.HasInstructionSet(InstructionSet_Sha1) && !resultflags.HasInstructionSet(InstructionSet_Sha1_Arm64))
            resultflags.RemoveInstructionSet(InstructionSet_Sha1);
        if (resultflags.HasInstructionSet(InstructionSet_Sha1_Arm64) && !resultflags.HasInstructionSet(InstructionSet_Sha1))
            resultflags.RemoveInstructionSet(InstructionSet_Sha1_Arm64);
        if (resultflags.HasInstructionSet(InstructionSet_Sha256) && !resultflags.HasInstructionSet(InstructionSet_Sha256_Arm64))
            resultflags.RemoveInstructionSet(InstructionSet_Sha256);
        if (resultflags.HasInstructionSet(InstructionSet_Sha256_Arm64) && !resultflags.HasInstructionSet(InstructionSet_Sha256))
            resultflags.RemoveInstructionSet(InstructionSet_Sha256_Arm64);
        if (resultflags.HasInstructionSet(InstructionSet_Sve) && !resultflags.HasInstructionSet(InstructionSet_Sve_Arm64))
            resultflags.RemoveInstructionSet(InstructionSet_Sve);
        if (resultflags.HasInstructionSet(InstructionSet_Sve_Arm64) && !resultflags.HasInstructionSet(InstructionSet_Sve))
            resultflags.RemoveInstructionSet(InstructionSet_Sve_Arm64);
        if (resultflags.HasInstructionSet(InstructionSet_Sve2) && !resultflags.HasInstructionSet(InstructionSet_Sve2_Arm64))
            resultflags.RemoveInstructionSet(InstructionSet_Sve2);
        if (resultflags.HasInstructionSet(InstructionSet_Sve2_Arm64) && !resultflags.HasInstructionSet(InstructionSet_Sve2))
            resultflags.RemoveInstructionSet(InstructionSet_Sve2_Arm64);
        if (resultflags.HasInstructionSet(InstructionSet_AdvSimd) && !resultflags.HasInstructionSet(InstructionSet_ArmBase))
            resultflags.RemoveInstructionSet(InstructionSet_AdvSimd);
        if (resultflags.HasInstructionSet(InstructionSet_Aes) && !resultflags.HasInstructionSet(InstructionSet_ArmBase))
            resultflags.RemoveInstructionSet(InstructionSet_Aes);
        if (resultflags.HasInstructionSet(InstructionSet_Crc32) && !resultflags.HasInstructionSet(InstructionSet_ArmBase))
            resultflags.RemoveInstructionSet(InstructionSet_Crc32);
        if (resultflags.HasInstructionSet(InstructionSet_Dp) && !resultflags.HasInstructionSet(InstructionSet_AdvSimd))
            resultflags.RemoveInstructionSet(InstructionSet_Dp);
        if (resultflags.HasInstructionSet(InstructionSet_Rdm) && !resultflags.HasInstructionSet(InstructionSet_AdvSimd))
            resultflags.RemoveInstructionSet(InstructionSet_Rdm);
        if (resultflags.HasInstructionSet(InstructionSet_Sha1) && !resultflags.HasInstructionSet(InstructionSet_ArmBase))
            resultflags.RemoveInstructionSet(InstructionSet_Sha1);
        if (resultflags.HasInstructionSet(InstructionSet_Sha256) && !resultflags.HasInstructionSet(InstructionSet_ArmBase))
            resultflags.RemoveInstructionSet(InstructionSet_Sha256);
        if (resultflags.HasInstructionSet(InstructionSet_Vector64) && !resultflags.HasInstructionSet(InstructionSet_AdvSimd))
            resultflags.RemoveInstructionSet(InstructionSet_Vector64);
        if (resultflags.HasInstructionSet(InstructionSet_Vector128) && !resultflags.HasInstructionSet(InstructionSet_AdvSimd))
            resultflags.RemoveInstructionSet(InstructionSet_Vector128);
        if (resultflags.HasInstructionSet(InstructionSet_VectorT128) && !resultflags.HasInstructionSet(InstructionSet_AdvSimd))
            resultflags.RemoveInstructionSet(InstructionSet_VectorT128);
        if (resultflags.HasInstructionSet(InstructionSet_Sve) && !resultflags.HasInstructionSet(InstructionSet_AdvSimd))
            resultflags.RemoveInstructionSet(InstructionSet_Sve);
        if (resultflags.HasInstructionSet(InstructionSet_Sve2) && !resultflags.HasInstructionSet(InstructionSet_Sve))
            resultflags.RemoveInstructionSet(InstructionSet_Sve2);
#endif // TARGET_ARM64
#ifdef TARGET_RISCV64
        if (resultflags.HasInstructionSet(InstructionSet_Zbb) && !resultflags.HasInstructionSet(InstructionSet_RiscV64Base))
            resultflags.RemoveInstructionSet(InstructionSet_Zbb);
        if (resultflags.HasInstructionSet(InstructionSet_Zba) && !resultflags.HasInstructionSet(InstructionSet_RiscV64Base))
            resultflags.RemoveInstructionSet(InstructionSet_Zba);
#endif // TARGET_RISCV64
#ifdef TARGET_AMD64
        if (resultflags.HasInstructionSet(InstructionSet_X86Base) && !resultflags.HasInstructionSet(InstructionSet_X86Base_X64))
            resultflags.RemoveInstructionSet(InstructionSet_X86Base);
        if (resultflags.HasInstructionSet(InstructionSet_X86Base_X64) && !resultflags.HasInstructionSet(InstructionSet_X86Base))
            resultflags.RemoveInstructionSet(InstructionSet_X86Base_X64);
        if (resultflags.HasInstructionSet(InstructionSet_SSE42) && !resultflags.HasInstructionSet(InstructionSet_SSE42_X64))
            resultflags.RemoveInstructionSet(InstructionSet_SSE42);
        if (resultflags.HasInstructionSet(InstructionSet_SSE42_X64) && !resultflags.HasInstructionSet(InstructionSet_SSE42))
            resultflags.RemoveInstructionSet(InstructionSet_SSE42_X64);
        if (resultflags.HasInstructionSet(InstructionSet_AVX) && !resultflags.HasInstructionSet(InstructionSet_AVX_X64))
            resultflags.RemoveInstructionSet(InstructionSet_AVX);
        if (resultflags.HasInstructionSet(InstructionSet_AVX_X64) && !resultflags.HasInstructionSet(InstructionSet_AVX))
            resultflags.RemoveInstructionSet(InstructionSet_AVX_X64);
        if (resultflags.HasInstructionSet(InstructionSet_AVX2) && !resultflags.HasInstructionSet(InstructionSet_AVX2_X64))
            resultflags.RemoveInstructionSet(InstructionSet_AVX2);
        if (resultflags.HasInstructionSet(InstructionSet_AVX2_X64) && !resultflags.HasInstructionSet(InstructionSet_AVX2))
            resultflags.RemoveInstructionSet(InstructionSet_AVX2_X64);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512) && !resultflags.HasInstructionSet(InstructionSet_AVX512_X64))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512_X64) && !resultflags.HasInstructionSet(InstructionSet_AVX512))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512_X64);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512v2) && !resultflags.HasInstructionSet(InstructionSet_AVX512v2_X64))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512v2);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512v2_X64) && !resultflags.HasInstructionSet(InstructionSet_AVX512v2))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512v2_X64);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512v3) && !resultflags.HasInstructionSet(InstructionSet_AVX512v3_X64))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512v3);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512v3_X64) && !resultflags.HasInstructionSet(InstructionSet_AVX512v3))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512v3_X64);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v1) && !resultflags.HasInstructionSet(InstructionSet_AVX10v1_X64))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v1);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v1_X64) && !resultflags.HasInstructionSet(InstructionSet_AVX10v1))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v1_X64);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v2) && !resultflags.HasInstructionSet(InstructionSet_AVX10v2_X64))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v2);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v2_X64) && !resultflags.HasInstructionSet(InstructionSet_AVX10v2))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v2_X64);
        if (resultflags.HasInstructionSet(InstructionSet_AES) && !resultflags.HasInstructionSet(InstructionSet_AES_X64))
            resultflags.RemoveInstructionSet(InstructionSet_AES);
        if (resultflags.HasInstructionSet(InstructionSet_AES_X64) && !resultflags.HasInstructionSet(InstructionSet_AES))
            resultflags.RemoveInstructionSet(InstructionSet_AES_X64);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512VP2INTERSECT) && !resultflags.HasInstructionSet(InstructionSet_AVX512VP2INTERSECT_X64))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512VP2INTERSECT);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512VP2INTERSECT_X64) && !resultflags.HasInstructionSet(InstructionSet_AVX512VP2INTERSECT))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512VP2INTERSECT_X64);
        if (resultflags.HasInstructionSet(InstructionSet_AVXIFMA) && !resultflags.HasInstructionSet(InstructionSet_AVXIFMA_X64))
            resultflags.RemoveInstructionSet(InstructionSet_AVXIFMA);
        if (resultflags.HasInstructionSet(InstructionSet_AVXIFMA_X64) && !resultflags.HasInstructionSet(InstructionSet_AVXIFMA))
            resultflags.RemoveInstructionSet(InstructionSet_AVXIFMA_X64);
        if (resultflags.HasInstructionSet(InstructionSet_AVXVNNI) && !resultflags.HasInstructionSet(InstructionSet_AVXVNNI_X64))
            resultflags.RemoveInstructionSet(InstructionSet_AVXVNNI);
        if (resultflags.HasInstructionSet(InstructionSet_AVXVNNI_X64) && !resultflags.HasInstructionSet(InstructionSet_AVXVNNI))
            resultflags.RemoveInstructionSet(InstructionSet_AVXVNNI_X64);
        if (resultflags.HasInstructionSet(InstructionSet_GFNI) && !resultflags.HasInstructionSet(InstructionSet_GFNI_X64))
            resultflags.RemoveInstructionSet(InstructionSet_GFNI);
        if (resultflags.HasInstructionSet(InstructionSet_GFNI_X64) && !resultflags.HasInstructionSet(InstructionSet_GFNI))
            resultflags.RemoveInstructionSet(InstructionSet_GFNI_X64);
        if (resultflags.HasInstructionSet(InstructionSet_SHA) && !resultflags.HasInstructionSet(InstructionSet_SHA_X64))
            resultflags.RemoveInstructionSet(InstructionSet_SHA);
        if (resultflags.HasInstructionSet(InstructionSet_SHA_X64) && !resultflags.HasInstructionSet(InstructionSet_SHA))
            resultflags.RemoveInstructionSet(InstructionSet_SHA_X64);
        if (resultflags.HasInstructionSet(InstructionSet_WAITPKG) && !resultflags.HasInstructionSet(InstructionSet_WAITPKG_X64))
            resultflags.RemoveInstructionSet(InstructionSet_WAITPKG);
        if (resultflags.HasInstructionSet(InstructionSet_WAITPKG_X64) && !resultflags.HasInstructionSet(InstructionSet_WAITPKG))
            resultflags.RemoveInstructionSet(InstructionSet_WAITPKG_X64);
        if (resultflags.HasInstructionSet(InstructionSet_X86Serialize) && !resultflags.HasInstructionSet(InstructionSet_X86Serialize_X64))
            resultflags.RemoveInstructionSet(InstructionSet_X86Serialize);
        if (resultflags.HasInstructionSet(InstructionSet_X86Serialize_X64) && !resultflags.HasInstructionSet(InstructionSet_X86Serialize))
            resultflags.RemoveInstructionSet(InstructionSet_X86Serialize_X64);
        if (resultflags.HasInstructionSet(InstructionSet_SSE42) && !resultflags.HasInstructionSet(InstructionSet_X86Base))
            resultflags.RemoveInstructionSet(InstructionSet_SSE42);
        if (resultflags.HasInstructionSet(InstructionSet_AVX) && !resultflags.HasInstructionSet(InstructionSet_SSE42))
            resultflags.RemoveInstructionSet(InstructionSet_AVX);
        if (resultflags.HasInstructionSet(InstructionSet_AVX2) && !resultflags.HasInstructionSet(InstructionSet_AVX))
            resultflags.RemoveInstructionSet(InstructionSet_AVX2);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512) && !resultflags.HasInstructionSet(InstructionSet_AVX2))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512v2) && !resultflags.HasInstructionSet(InstructionSet_AVX512))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512v2);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512v3) && !resultflags.HasInstructionSet(InstructionSet_AVX512v2))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512v3);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v1) && !resultflags.HasInstructionSet(InstructionSet_AVX512v3))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v1);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v2) && !resultflags.HasInstructionSet(InstructionSet_AVX10v1))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v2);
        if (resultflags.HasInstructionSet(InstructionSet_AES) && !resultflags.HasInstructionSet(InstructionSet_X86Base))
            resultflags.RemoveInstructionSet(InstructionSet_AES);
        if (resultflags.HasInstructionSet(InstructionSet_AES_V256) && !resultflags.HasInstructionSet(InstructionSet_AES))
            resultflags.RemoveInstructionSet(InstructionSet_AES_V256);
        if (resultflags.HasInstructionSet(InstructionSet_AES_V256) && !resultflags.HasInstructionSet(InstructionSet_AVX))
            resultflags.RemoveInstructionSet(InstructionSet_AES_V256);
        if (resultflags.HasInstructionSet(InstructionSet_AES_V512) && !resultflags.HasInstructionSet(InstructionSet_AES_V256))
            resultflags.RemoveInstructionSet(InstructionSet_AES_V512);
        if (resultflags.HasInstructionSet(InstructionSet_AES_V512) && !resultflags.HasInstructionSet(InstructionSet_AVX512))
            resultflags.RemoveInstructionSet(InstructionSet_AES_V512);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512VP2INTERSECT) && !resultflags.HasInstructionSet(InstructionSet_AVX512))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512VP2INTERSECT);
        if (resultflags.HasInstructionSet(InstructionSet_AVXIFMA) && !resultflags.HasInstructionSet(InstructionSet_AVX2))
            resultflags.RemoveInstructionSet(InstructionSet_AVXIFMA);
        if (resultflags.HasInstructionSet(InstructionSet_AVXVNNI) && !resultflags.HasInstructionSet(InstructionSet_AVX2))
            resultflags.RemoveInstructionSet(InstructionSet_AVXVNNI);
        if (resultflags.HasInstructionSet(InstructionSet_GFNI) && !resultflags.HasInstructionSet(InstructionSet_SSE42))
            resultflags.RemoveInstructionSet(InstructionSet_GFNI);
        if (resultflags.HasInstructionSet(InstructionSet_GFNI_V256) && !resultflags.HasInstructionSet(InstructionSet_GFNI))
            resultflags.RemoveInstructionSet(InstructionSet_GFNI_V256);
        if (resultflags.HasInstructionSet(InstructionSet_GFNI_V256) && !resultflags.HasInstructionSet(InstructionSet_AVX))
            resultflags.RemoveInstructionSet(InstructionSet_GFNI_V256);
        if (resultflags.HasInstructionSet(InstructionSet_GFNI_V512) && !resultflags.HasInstructionSet(InstructionSet_GFNI_V256))
            resultflags.RemoveInstructionSet(InstructionSet_GFNI_V512);
        if (resultflags.HasInstructionSet(InstructionSet_GFNI_V512) && !resultflags.HasInstructionSet(InstructionSet_AVX512))
            resultflags.RemoveInstructionSet(InstructionSet_GFNI_V512);
        if (resultflags.HasInstructionSet(InstructionSet_SHA) && !resultflags.HasInstructionSet(InstructionSet_X86Base))
            resultflags.RemoveInstructionSet(InstructionSet_SHA);
        if (resultflags.HasInstructionSet(InstructionSet_WAITPKG) && !resultflags.HasInstructionSet(InstructionSet_X86Base))
            resultflags.RemoveInstructionSet(InstructionSet_WAITPKG);
        if (resultflags.HasInstructionSet(InstructionSet_X86Serialize) && !resultflags.HasInstructionSet(InstructionSet_X86Base))
            resultflags.RemoveInstructionSet(InstructionSet_X86Serialize);
        if (resultflags.HasInstructionSet(InstructionSet_AVXVNNIINT) && !resultflags.HasInstructionSet(InstructionSet_AVX2))
            resultflags.RemoveInstructionSet(InstructionSet_AVXVNNIINT);
        if (resultflags.HasInstructionSet(InstructionSet_AVXVNNIINT_V512) && !resultflags.HasInstructionSet(InstructionSet_AVX10v2))
            resultflags.RemoveInstructionSet(InstructionSet_AVXVNNIINT_V512);
        if (resultflags.HasInstructionSet(InstructionSet_Vector128) && !resultflags.HasInstructionSet(InstructionSet_X86Base))
            resultflags.RemoveInstructionSet(InstructionSet_Vector128);
        if (resultflags.HasInstructionSet(InstructionSet_Vector256) && !resultflags.HasInstructionSet(InstructionSet_AVX))
            resultflags.RemoveInstructionSet(InstructionSet_Vector256);
        if (resultflags.HasInstructionSet(InstructionSet_Vector512) && !resultflags.HasInstructionSet(InstructionSet_AVX512))
            resultflags.RemoveInstructionSet(InstructionSet_Vector512);
        if (resultflags.HasInstructionSet(InstructionSet_VectorT128) && !resultflags.HasInstructionSet(InstructionSet_X86Base))
            resultflags.RemoveInstructionSet(InstructionSet_VectorT128);
        if (resultflags.HasInstructionSet(InstructionSet_VectorT256) && !resultflags.HasInstructionSet(InstructionSet_AVX2))
            resultflags.RemoveInstructionSet(InstructionSet_VectorT256);
        if (resultflags.HasInstructionSet(InstructionSet_VectorT512) && !resultflags.HasInstructionSet(InstructionSet_AVX512))
            resultflags.RemoveInstructionSet(InstructionSet_VectorT512);
#endif // TARGET_AMD64
#ifdef TARGET_X86
        if (resultflags.HasInstructionSet(InstructionSet_SSE42) && !resultflags.HasInstructionSet(InstructionSet_X86Base))
            resultflags.RemoveInstructionSet(InstructionSet_SSE42);
        if (resultflags.HasInstructionSet(InstructionSet_AVX) && !resultflags.HasInstructionSet(InstructionSet_SSE42))
            resultflags.RemoveInstructionSet(InstructionSet_AVX);
        if (resultflags.HasInstructionSet(InstructionSet_AVX2) && !resultflags.HasInstructionSet(InstructionSet_AVX))
            resultflags.RemoveInstructionSet(InstructionSet_AVX2);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512) && !resultflags.HasInstructionSet(InstructionSet_AVX2))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512v2) && !resultflags.HasInstructionSet(InstructionSet_AVX512))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512v2);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512v3) && !resultflags.HasInstructionSet(InstructionSet_AVX512v2))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512v3);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v1) && !resultflags.HasInstructionSet(InstructionSet_AVX512v3))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v1);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v2) && !resultflags.HasInstructionSet(InstructionSet_AVX10v1))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v2);
        if (resultflags.HasInstructionSet(InstructionSet_AES) && !resultflags.HasInstructionSet(InstructionSet_X86Base))
            resultflags.RemoveInstructionSet(InstructionSet_AES);
        if (resultflags.HasInstructionSet(InstructionSet_AES_V256) && !resultflags.HasInstructionSet(InstructionSet_AES))
            resultflags.RemoveInstructionSet(InstructionSet_AES_V256);
        if (resultflags.HasInstructionSet(InstructionSet_AES_V256) && !resultflags.HasInstructionSet(InstructionSet_AVX))
            resultflags.RemoveInstructionSet(InstructionSet_AES_V256);
        if (resultflags.HasInstructionSet(InstructionSet_AES_V512) && !resultflags.HasInstructionSet(InstructionSet_AES_V256))
            resultflags.RemoveInstructionSet(InstructionSet_AES_V512);
        if (resultflags.HasInstructionSet(InstructionSet_AES_V512) && !resultflags.HasInstructionSet(InstructionSet_AVX512))
            resultflags.RemoveInstructionSet(InstructionSet_AES_V512);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512VP2INTERSECT) && !resultflags.HasInstructionSet(InstructionSet_AVX512))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512VP2INTERSECT);
        if (resultflags.HasInstructionSet(InstructionSet_AVXIFMA) && !resultflags.HasInstructionSet(InstructionSet_AVX2))
            resultflags.RemoveInstructionSet(InstructionSet_AVXIFMA);
        if (resultflags.HasInstructionSet(InstructionSet_AVXVNNI) && !resultflags.HasInstructionSet(InstructionSet_AVX2))
            resultflags.RemoveInstructionSet(InstructionSet_AVXVNNI);
        if (resultflags.HasInstructionSet(InstructionSet_GFNI) && !resultflags.HasInstructionSet(InstructionSet_SSE42))
            resultflags.RemoveInstructionSet(InstructionSet_GFNI);
        if (resultflags.HasInstructionSet(InstructionSet_GFNI_V256) && !resultflags.HasInstructionSet(InstructionSet_GFNI))
            resultflags.RemoveInstructionSet(InstructionSet_GFNI_V256);
        if (resultflags.HasInstructionSet(InstructionSet_GFNI_V256) && !resultflags.HasInstructionSet(InstructionSet_AVX))
            resultflags.RemoveInstructionSet(InstructionSet_GFNI_V256);
        if (resultflags.HasInstructionSet(InstructionSet_GFNI_V512) && !resultflags.HasInstructionSet(InstructionSet_GFNI_V256))
            resultflags.RemoveInstructionSet(InstructionSet_GFNI_V512);
        if (resultflags.HasInstructionSet(InstructionSet_GFNI_V512) && !resultflags.HasInstructionSet(InstructionSet_AVX512))
            resultflags.RemoveInstructionSet(InstructionSet_GFNI_V512);
        if (resultflags.HasInstructionSet(InstructionSet_SHA) && !resultflags.HasInstructionSet(InstructionSet_X86Base))
            resultflags.RemoveInstructionSet(InstructionSet_SHA);
        if (resultflags.HasInstructionSet(InstructionSet_WAITPKG) && !resultflags.HasInstructionSet(InstructionSet_X86Base))
            resultflags.RemoveInstructionSet(InstructionSet_WAITPKG);
        if (resultflags.HasInstructionSet(InstructionSet_X86Serialize) && !resultflags.HasInstructionSet(InstructionSet_X86Base))
            resultflags.RemoveInstructionSet(InstructionSet_X86Serialize);
        if (resultflags.HasInstructionSet(InstructionSet_AVXVNNIINT) && !resultflags.HasInstructionSet(InstructionSet_AVX2))
            resultflags.RemoveInstructionSet(InstructionSet_AVXVNNIINT);
        if (resultflags.HasInstructionSet(InstructionSet_AVXVNNIINT_V512) && !resultflags.HasInstructionSet(InstructionSet_AVX10v2))
            resultflags.RemoveInstructionSet(InstructionSet_AVXVNNIINT_V512);
        if (resultflags.HasInstructionSet(InstructionSet_Vector128) && !resultflags.HasInstructionSet(InstructionSet_X86Base))
            resultflags.RemoveInstructionSet(InstructionSet_Vector128);
        if (resultflags.HasInstructionSet(InstructionSet_Vector256) && !resultflags.HasInstructionSet(InstructionSet_AVX))
            resultflags.RemoveInstructionSet(InstructionSet_Vector256);
        if (resultflags.HasInstructionSet(InstructionSet_Vector512) && !resultflags.HasInstructionSet(InstructionSet_AVX512))
            resultflags.RemoveInstructionSet(InstructionSet_Vector512);
        if (resultflags.HasInstructionSet(InstructionSet_VectorT128) && !resultflags.HasInstructionSet(InstructionSet_X86Base))
            resultflags.RemoveInstructionSet(InstructionSet_VectorT128);
        if (resultflags.HasInstructionSet(InstructionSet_VectorT256) && !resultflags.HasInstructionSet(InstructionSet_AVX2))
            resultflags.RemoveInstructionSet(InstructionSet_VectorT256);
        if (resultflags.HasInstructionSet(InstructionSet_VectorT512) && !resultflags.HasInstructionSet(InstructionSet_AVX512))
            resultflags.RemoveInstructionSet(InstructionSet_VectorT512);
#endif // TARGET_X86

    } while (!oldflags.Equals(resultflags));
    return resultflags;
}

inline const char *InstructionSetToString(CORINFO_InstructionSet instructionSet)
{
#ifdef _MSC_VER
#pragma warning(push)
#pragma warning(disable: 4065) // disable warning for switch statement with only default label.
#endif

    switch (instructionSet)
    {
#ifdef TARGET_ARM64
        case InstructionSet_ArmBase :
            return "ArmBase";
        case InstructionSet_ArmBase_Arm64 :
            return "ArmBase_Arm64";
        case InstructionSet_AdvSimd :
            return "AdvSimd";
        case InstructionSet_AdvSimd_Arm64 :
            return "AdvSimd_Arm64";
        case InstructionSet_Aes :
            return "Aes";
        case InstructionSet_Aes_Arm64 :
            return "Aes_Arm64";
        case InstructionSet_Crc32 :
            return "Crc32";
        case InstructionSet_Crc32_Arm64 :
            return "Crc32_Arm64";
        case InstructionSet_Dp :
            return "Dp";
        case InstructionSet_Dp_Arm64 :
            return "Dp_Arm64";
        case InstructionSet_Rdm :
            return "Rdm";
        case InstructionSet_Rdm_Arm64 :
            return "Rdm_Arm64";
        case InstructionSet_Sha1 :
            return "Sha1";
        case InstructionSet_Sha1_Arm64 :
            return "Sha1_Arm64";
        case InstructionSet_Sha256 :
            return "Sha256";
        case InstructionSet_Sha256_Arm64 :
            return "Sha256_Arm64";
        case InstructionSet_Atomics :
            return "Atomics";
        case InstructionSet_Vector64 :
            return "Vector64";
        case InstructionSet_Vector128 :
            return "Vector128";
        case InstructionSet_Dczva :
            return "Dczva";
        case InstructionSet_Rcpc :
            return "Rcpc";
        case InstructionSet_VectorT128 :
            return "VectorT128";
        case InstructionSet_Rcpc2 :
            return "Rcpc2";
        case InstructionSet_Sve :
            return "Sve";
        case InstructionSet_Sve_Arm64 :
            return "Sve_Arm64";
        case InstructionSet_Sve2 :
            return "Sve2";
        case InstructionSet_Sve2_Arm64 :
            return "Sve2_Arm64";
#endif // TARGET_ARM64
#ifdef TARGET_RISCV64
        case InstructionSet_RiscV64Base :
            return "RiscV64Base";
        case InstructionSet_Zba :
            return "Zba";
        case InstructionSet_Zbb :
            return "Zbb";
#endif // TARGET_RISCV64
#ifdef TARGET_AMD64
        case InstructionSet_X86Base :
            return "X86Base";
        case InstructionSet_X86Base_X64 :
            return "X86Base_X64";
        case InstructionSet_SSE42 :
            return "SSE42";
        case InstructionSet_SSE42_X64 :
            return "SSE42_X64";
        case InstructionSet_AVX :
            return "AVX";
        case InstructionSet_AVX_X64 :
            return "AVX_X64";
        case InstructionSet_AVX2 :
            return "AVX2";
        case InstructionSet_AVX2_X64 :
            return "AVX2_X64";
        case InstructionSet_AVX512 :
            return "AVX512";
        case InstructionSet_AVX512_X64 :
            return "AVX512_X64";
        case InstructionSet_AVX512v2 :
            return "AVX512v2";
        case InstructionSet_AVX512v2_X64 :
            return "AVX512v2_X64";
        case InstructionSet_AVX512v3 :
            return "AVX512v3";
        case InstructionSet_AVX512v3_X64 :
            return "AVX512v3_X64";
        case InstructionSet_AVX10v1 :
            return "AVX10v1";
        case InstructionSet_AVX10v1_X64 :
            return "AVX10v1_X64";
        case InstructionSet_AVX10v2 :
            return "AVX10v2";
        case InstructionSet_AVX10v2_X64 :
            return "AVX10v2_X64";
        case InstructionSet_APX :
            return "APX";
        case InstructionSet_AES :
            return "AES";
        case InstructionSet_AES_X64 :
            return "AES_X64";
        case InstructionSet_AES_V256 :
            return "AES_V256";
        case InstructionSet_AES_V512 :
            return "AES_V512";
        case InstructionSet_AVX512VP2INTERSECT :
            return "AVX512VP2INTERSECT";
        case InstructionSet_AVX512VP2INTERSECT_X64 :
            return "AVX512VP2INTERSECT_X64";
        case InstructionSet_AVXIFMA :
            return "AVXIFMA";
        case InstructionSet_AVXIFMA_X64 :
            return "AVXIFMA_X64";
        case InstructionSet_AVXVNNI :
            return "AVXVNNI";
        case InstructionSet_AVXVNNI_X64 :
            return "AVXVNNI_X64";
        case InstructionSet_GFNI :
            return "GFNI";
        case InstructionSet_GFNI_X64 :
            return "GFNI_X64";
        case InstructionSet_GFNI_V256 :
            return "GFNI_V256";
        case InstructionSet_GFNI_V512 :
            return "GFNI_V512";
        case InstructionSet_SHA :
            return "SHA";
        case InstructionSet_SHA_X64 :
            return "SHA_X64";
        case InstructionSet_WAITPKG :
            return "WAITPKG";
        case InstructionSet_WAITPKG_X64 :
            return "WAITPKG_X64";
        case InstructionSet_X86Serialize :
            return "X86Serialize";
        case InstructionSet_X86Serialize_X64 :
            return "X86Serialize_X64";
        case InstructionSet_Vector128 :
            return "Vector128";
        case InstructionSet_Vector256 :
            return "Vector256";
        case InstructionSet_Vector512 :
            return "Vector512";
        case InstructionSet_VectorT128 :
            return "VectorT128";
        case InstructionSet_VectorT256 :
            return "VectorT256";
        case InstructionSet_VectorT512 :
            return "VectorT512";
        case InstructionSet_AVXVNNIINT :
            return "AVXVNNIINT";
        case InstructionSet_AVXVNNIINT_V512 :
            return "AVXVNNIINT_V512";
#endif // TARGET_AMD64
#ifdef TARGET_X86
        case InstructionSet_X86Base :
            return "X86Base";
        case InstructionSet_SSE42 :
            return "SSE42";
        case InstructionSet_AVX :
            return "AVX";
        case InstructionSet_AVX2 :
            return "AVX2";
        case InstructionSet_AVX512 :
            return "AVX512";
        case InstructionSet_AVX512v2 :
            return "AVX512v2";
        case InstructionSet_AVX512v3 :
            return "AVX512v3";
        case InstructionSet_AVX10v1 :
            return "AVX10v1";
        case InstructionSet_AVX10v2 :
            return "AVX10v2";
        case InstructionSet_APX :
            return "APX";
        case InstructionSet_AES :
            return "AES";
        case InstructionSet_AES_V256 :
            return "AES_V256";
        case InstructionSet_AES_V512 :
            return "AES_V512";
        case InstructionSet_AVX512VP2INTERSECT :
            return "AVX512VP2INTERSECT";
        case InstructionSet_AVXIFMA :
            return "AVXIFMA";
        case InstructionSet_AVXVNNI :
            return "AVXVNNI";
        case InstructionSet_GFNI :
            return "GFNI";
        case InstructionSet_GFNI_V256 :
            return "GFNI_V256";
        case InstructionSet_GFNI_V512 :
            return "GFNI_V512";
        case InstructionSet_SHA :
            return "SHA";
        case InstructionSet_WAITPKG :
            return "WAITPKG";
        case InstructionSet_X86Serialize :
            return "X86Serialize";
        case InstructionSet_Vector128 :
            return "Vector128";
        case InstructionSet_Vector256 :
            return "Vector256";
        case InstructionSet_Vector512 :
            return "Vector512";
        case InstructionSet_VectorT128 :
            return "VectorT128";
        case InstructionSet_VectorT256 :
            return "VectorT256";
        case InstructionSet_VectorT512 :
            return "VectorT512";
        case InstructionSet_AVXVNNIINT :
            return "AVXVNNIINT";
        case InstructionSet_AVXVNNIINT_V512 :
            return "AVXVNNIINT_V512";
#endif // TARGET_X86

        default:
            return "UnknownInstructionSet";
    }
#ifdef _MSC_VER
#pragma warning(pop)
#endif
}

inline CORINFO_InstructionSet InstructionSetFromR2RInstructionSet(ReadyToRunInstructionSet r2rSet)
{
#ifdef _MSC_VER
#pragma warning(push)
#pragma warning(disable: 4065) // disable warning for switch statement with only default label.
#endif

    switch (r2rSet)
    {
#ifdef TARGET_ARM64
        case READYTORUN_INSTRUCTION_ArmBase: return InstructionSet_ArmBase;
        case READYTORUN_INSTRUCTION_AdvSimd: return InstructionSet_AdvSimd;
        case READYTORUN_INSTRUCTION_Aes: return InstructionSet_Aes;
        case READYTORUN_INSTRUCTION_Crc32: return InstructionSet_Crc32;
        case READYTORUN_INSTRUCTION_Dp: return InstructionSet_Dp;
        case READYTORUN_INSTRUCTION_Rdm: return InstructionSet_Rdm;
        case READYTORUN_INSTRUCTION_Sha1: return InstructionSet_Sha1;
        case READYTORUN_INSTRUCTION_Sha256: return InstructionSet_Sha256;
        case READYTORUN_INSTRUCTION_Atomics: return InstructionSet_Atomics;
        case READYTORUN_INSTRUCTION_Rcpc: return InstructionSet_Rcpc;
        case READYTORUN_INSTRUCTION_VectorT128: return InstructionSet_VectorT128;
        case READYTORUN_INSTRUCTION_Rcpc2: return InstructionSet_Rcpc2;
        case READYTORUN_INSTRUCTION_Sve: return InstructionSet_Sve;
        case READYTORUN_INSTRUCTION_Sve2: return InstructionSet_Sve2;
#endif // TARGET_ARM64
#ifdef TARGET_RISCV64
        case READYTORUN_INSTRUCTION_RiscV64Base: return InstructionSet_RiscV64Base;
        case READYTORUN_INSTRUCTION_Zba: return InstructionSet_Zba;
        case READYTORUN_INSTRUCTION_Zbb: return InstructionSet_Zbb;
#endif // TARGET_RISCV64
#ifdef TARGET_AMD64
        case READYTORUN_INSTRUCTION_X86Base: return InstructionSet_X86Base;
        case READYTORUN_INSTRUCTION_Sse: return InstructionSet_X86Base;
        case READYTORUN_INSTRUCTION_Sse2: return InstructionSet_X86Base;
        case READYTORUN_INSTRUCTION_Sse42: return InstructionSet_SSE42;
        case READYTORUN_INSTRUCTION_Sse3: return InstructionSet_SSE42;
        case READYTORUN_INSTRUCTION_Ssse3: return InstructionSet_SSE42;
        case READYTORUN_INSTRUCTION_Sse41: return InstructionSet_SSE42;
        case READYTORUN_INSTRUCTION_Popcnt: return InstructionSet_SSE42;
        case READYTORUN_INSTRUCTION_Avx: return InstructionSet_AVX;
        case READYTORUN_INSTRUCTION_Avx2: return InstructionSet_AVX2;
        case READYTORUN_INSTRUCTION_Bmi1: return InstructionSet_AVX2;
        case READYTORUN_INSTRUCTION_Bmi2: return InstructionSet_AVX2;
        case READYTORUN_INSTRUCTION_F16C: return InstructionSet_AVX2;
        case READYTORUN_INSTRUCTION_Fma: return InstructionSet_AVX2;
        case READYTORUN_INSTRUCTION_Lzcnt: return InstructionSet_AVX2;
        case READYTORUN_INSTRUCTION_Movbe: return InstructionSet_AVX2;
        case READYTORUN_INSTRUCTION_Evex: return InstructionSet_AVX512;
        case READYTORUN_INSTRUCTION_Avx512F: return InstructionSet_AVX512;
        case READYTORUN_INSTRUCTION_Avx512F_VL: return InstructionSet_AVX512;
        case READYTORUN_INSTRUCTION_Avx512BW: return InstructionSet_AVX512;
        case READYTORUN_INSTRUCTION_Avx512BW_VL: return InstructionSet_AVX512;
        case READYTORUN_INSTRUCTION_Avx512CD: return InstructionSet_AVX512;
        case READYTORUN_INSTRUCTION_Avx512CD_VL: return InstructionSet_AVX512;
        case READYTORUN_INSTRUCTION_Avx512DQ: return InstructionSet_AVX512;
        case READYTORUN_INSTRUCTION_Avx512DQ_VL: return InstructionSet_AVX512;
        case READYTORUN_INSTRUCTION_Avx512Ifma: return InstructionSet_AVX512v2;
        case READYTORUN_INSTRUCTION_Avx512Vbmi: return InstructionSet_AVX512v2;
        case READYTORUN_INSTRUCTION_Avx512Vbmi_VL: return InstructionSet_AVX512v2;
        case READYTORUN_INSTRUCTION_Avx512Bitalg: return InstructionSet_AVX512v3;
        case READYTORUN_INSTRUCTION_Avx512Bitalg_VL: return InstructionSet_AVX512v3;
        case READYTORUN_INSTRUCTION_Avx512Vbmi2: return InstructionSet_AVX512v3;
        case READYTORUN_INSTRUCTION_Avx512Vbmi2_VL: return InstructionSet_AVX512v3;
        case READYTORUN_INSTRUCTION_Avx512Vnni: return InstructionSet_AVX512v3;
        case READYTORUN_INSTRUCTION_Avx512Vpopcntdq: return InstructionSet_AVX512v3;
        case READYTORUN_INSTRUCTION_Avx512Vpopcntdq_VL: return InstructionSet_AVX512v3;
        case READYTORUN_INSTRUCTION_Avx512Bf16: return InstructionSet_AVX10v1;
        case READYTORUN_INSTRUCTION_Avx512Bf16_VL: return InstructionSet_AVX10v1;
        case READYTORUN_INSTRUCTION_Avx512Fp16: return InstructionSet_AVX10v1;
        case READYTORUN_INSTRUCTION_Avx512Fp16_VL: return InstructionSet_AVX10v1;
        case READYTORUN_INSTRUCTION_Avx10v1: return InstructionSet_AVX10v1;
        case READYTORUN_INSTRUCTION_Avx10v1_V512: return InstructionSet_AVX10v1;
        case READYTORUN_INSTRUCTION_Avx10v2: return InstructionSet_AVX10v2;
        case READYTORUN_INSTRUCTION_Avx10v2_V512: return InstructionSet_AVX10v2;
        case READYTORUN_INSTRUCTION_Apx: return InstructionSet_APX;
        case READYTORUN_INSTRUCTION_Aes: return InstructionSet_AES;
        case READYTORUN_INSTRUCTION_Aes_V256: return InstructionSet_AES_V256;
        case READYTORUN_INSTRUCTION_Aes_V512: return InstructionSet_AES_V512;
        case READYTORUN_INSTRUCTION_Pclmulqdq: return InstructionSet_AES;
        case READYTORUN_INSTRUCTION_Pclmulqdq_V256: return InstructionSet_AES_V256;
        case READYTORUN_INSTRUCTION_Pclmulqdq_V512: return InstructionSet_AES_V512;
        case READYTORUN_INSTRUCTION_Avx512Vp2intersect: return InstructionSet_AVX512VP2INTERSECT;
        case READYTORUN_INSTRUCTION_Avx512Vp2intersect_VL: return InstructionSet_AVX512VP2INTERSECT;
        case READYTORUN_INSTRUCTION_AvxIfma: return InstructionSet_AVXIFMA;
        case READYTORUN_INSTRUCTION_AvxVnni: return InstructionSet_AVXVNNI;
        case READYTORUN_INSTRUCTION_Gfni: return InstructionSet_GFNI;
        case READYTORUN_INSTRUCTION_Gfni_V256: return InstructionSet_GFNI_V256;
        case READYTORUN_INSTRUCTION_Gfni_V512: return InstructionSet_GFNI_V512;
        case READYTORUN_INSTRUCTION_Sha: return InstructionSet_SHA;
        case READYTORUN_INSTRUCTION_WaitPkg: return InstructionSet_WAITPKG;
        case READYTORUN_INSTRUCTION_X86Serialize: return InstructionSet_X86Serialize;
        case READYTORUN_INSTRUCTION_VectorT128: return InstructionSet_VectorT128;
        case READYTORUN_INSTRUCTION_VectorT256: return InstructionSet_VectorT256;
        case READYTORUN_INSTRUCTION_VectorT512: return InstructionSet_VectorT512;
        case READYTORUN_INSTRUCTION_AvxVnniInt8: return InstructionSet_AVXVNNIINT;
        case READYTORUN_INSTRUCTION_AvxVnniInt8_V512: return InstructionSet_AVXVNNIINT_V512;
        case READYTORUN_INSTRUCTION_AvxVnniInt16: return InstructionSet_AVXVNNIINT;
        case READYTORUN_INSTRUCTION_AvxVnniInt16_V512: return InstructionSet_AVXVNNIINT_V512;
#endif // TARGET_AMD64
#ifdef TARGET_X86
        case READYTORUN_INSTRUCTION_X86Base: return InstructionSet_X86Base;
        case READYTORUN_INSTRUCTION_Sse: return InstructionSet_X86Base;
        case READYTORUN_INSTRUCTION_Sse2: return InstructionSet_X86Base;
        case READYTORUN_INSTRUCTION_Sse42: return InstructionSet_SSE42;
        case READYTORUN_INSTRUCTION_Sse3: return InstructionSet_SSE42;
        case READYTORUN_INSTRUCTION_Ssse3: return InstructionSet_SSE42;
        case READYTORUN_INSTRUCTION_Sse41: return InstructionSet_SSE42;
        case READYTORUN_INSTRUCTION_Popcnt: return InstructionSet_SSE42;
        case READYTORUN_INSTRUCTION_Avx: return InstructionSet_AVX;
        case READYTORUN_INSTRUCTION_Avx2: return InstructionSet_AVX2;
        case READYTORUN_INSTRUCTION_Bmi1: return InstructionSet_AVX2;
        case READYTORUN_INSTRUCTION_Bmi2: return InstructionSet_AVX2;
        case READYTORUN_INSTRUCTION_F16C: return InstructionSet_AVX2;
        case READYTORUN_INSTRUCTION_Fma: return InstructionSet_AVX2;
        case READYTORUN_INSTRUCTION_Lzcnt: return InstructionSet_AVX2;
        case READYTORUN_INSTRUCTION_Movbe: return InstructionSet_AVX2;
        case READYTORUN_INSTRUCTION_Evex: return InstructionSet_AVX512;
        case READYTORUN_INSTRUCTION_Avx512F: return InstructionSet_AVX512;
        case READYTORUN_INSTRUCTION_Avx512F_VL: return InstructionSet_AVX512;
        case READYTORUN_INSTRUCTION_Avx512BW: return InstructionSet_AVX512;
        case READYTORUN_INSTRUCTION_Avx512BW_VL: return InstructionSet_AVX512;
        case READYTORUN_INSTRUCTION_Avx512CD: return InstructionSet_AVX512;
        case READYTORUN_INSTRUCTION_Avx512CD_VL: return InstructionSet_AVX512;
        case READYTORUN_INSTRUCTION_Avx512DQ: return InstructionSet_AVX512;
        case READYTORUN_INSTRUCTION_Avx512DQ_VL: return InstructionSet_AVX512;
        case READYTORUN_INSTRUCTION_Avx512Ifma: return InstructionSet_AVX512v2;
        case READYTORUN_INSTRUCTION_Avx512Vbmi: return InstructionSet_AVX512v2;
        case READYTORUN_INSTRUCTION_Avx512Vbmi_VL: return InstructionSet_AVX512v2;
        case READYTORUN_INSTRUCTION_Avx512Bitalg: return InstructionSet_AVX512v3;
        case READYTORUN_INSTRUCTION_Avx512Bitalg_VL: return InstructionSet_AVX512v3;
        case READYTORUN_INSTRUCTION_Avx512Vbmi2: return InstructionSet_AVX512v3;
        case READYTORUN_INSTRUCTION_Avx512Vbmi2_VL: return InstructionSet_AVX512v3;
        case READYTORUN_INSTRUCTION_Avx512Vnni: return InstructionSet_AVX512v3;
        case READYTORUN_INSTRUCTION_Avx512Vpopcntdq: return InstructionSet_AVX512v3;
        case READYTORUN_INSTRUCTION_Avx512Vpopcntdq_VL: return InstructionSet_AVX512v3;
        case READYTORUN_INSTRUCTION_Avx512Bf16: return InstructionSet_AVX10v1;
        case READYTORUN_INSTRUCTION_Avx512Bf16_VL: return InstructionSet_AVX10v1;
        case READYTORUN_INSTRUCTION_Avx512Fp16: return InstructionSet_AVX10v1;
        case READYTORUN_INSTRUCTION_Avx512Fp16_VL: return InstructionSet_AVX10v1;
        case READYTORUN_INSTRUCTION_Avx10v1: return InstructionSet_AVX10v1;
        case READYTORUN_INSTRUCTION_Avx10v1_V512: return InstructionSet_AVX10v1;
        case READYTORUN_INSTRUCTION_Avx10v2: return InstructionSet_AVX10v2;
        case READYTORUN_INSTRUCTION_Avx10v2_V512: return InstructionSet_AVX10v2;
        case READYTORUN_INSTRUCTION_Apx: return InstructionSet_APX;
        case READYTORUN_INSTRUCTION_Aes: return InstructionSet_AES;
        case READYTORUN_INSTRUCTION_Aes_V256: return InstructionSet_AES_V256;
        case READYTORUN_INSTRUCTION_Aes_V512: return InstructionSet_AES_V512;
        case READYTORUN_INSTRUCTION_Pclmulqdq: return InstructionSet_AES;
        case READYTORUN_INSTRUCTION_Pclmulqdq_V256: return InstructionSet_AES_V256;
        case READYTORUN_INSTRUCTION_Pclmulqdq_V512: return InstructionSet_AES_V512;
        case READYTORUN_INSTRUCTION_Avx512Vp2intersect: return InstructionSet_AVX512VP2INTERSECT;
        case READYTORUN_INSTRUCTION_Avx512Vp2intersect_VL: return InstructionSet_AVX512VP2INTERSECT;
        case READYTORUN_INSTRUCTION_AvxIfma: return InstructionSet_AVXIFMA;
        case READYTORUN_INSTRUCTION_AvxVnni: return InstructionSet_AVXVNNI;
        case READYTORUN_INSTRUCTION_Gfni: return InstructionSet_GFNI;
        case READYTORUN_INSTRUCTION_Gfni_V256: return InstructionSet_GFNI_V256;
        case READYTORUN_INSTRUCTION_Gfni_V512: return InstructionSet_GFNI_V512;
        case READYTORUN_INSTRUCTION_Sha: return InstructionSet_SHA;
        case READYTORUN_INSTRUCTION_WaitPkg: return InstructionSet_WAITPKG;
        case READYTORUN_INSTRUCTION_X86Serialize: return InstructionSet_X86Serialize;
        case READYTORUN_INSTRUCTION_VectorT128: return InstructionSet_VectorT128;
        case READYTORUN_INSTRUCTION_VectorT256: return InstructionSet_VectorT256;
        case READYTORUN_INSTRUCTION_VectorT512: return InstructionSet_VectorT512;
        case READYTORUN_INSTRUCTION_AvxVnniInt8: return InstructionSet_AVXVNNIINT;
        case READYTORUN_INSTRUCTION_AvxVnniInt8_V512: return InstructionSet_AVXVNNIINT_V512;
        case READYTORUN_INSTRUCTION_AvxVnniInt16: return InstructionSet_AVXVNNIINT;
        case READYTORUN_INSTRUCTION_AvxVnniInt16_V512: return InstructionSet_AVXVNNIINT_V512;
#endif // TARGET_X86

        default:
            return InstructionSet_ILLEGAL;
    }
#ifdef _MSC_VER
#pragma warning(pop)
#endif
}

#endif // CORINFOINSTRUCTIONSET_H
