/* Generated by re2c */
#line 1 "real_world/scanner_s.re"
// re2c $INPUT -o $OUTPUT -s
/* Id: scanner.re,v 1.37 2006/02/25 12:41:41 helly Exp */
#include <stdlib.h>
#include <string.h>
#include <iostream>
#include <sstream>
#include "scanner.h"
#include "parser.h"
#include "y.tab.h"
#include "globals.h"
#include "dfa.h"

extern YYSTYPE yylval;

#ifndef MAX
#define MAX(a,b) (((a)>(b))?(a):(b))
#endif

#define	BSIZE	8192

#define	YYCTYPE		char
#define	YYCURSOR	cursor
#define	YYLIMIT		lim
#define	YYMARKER	ptr
#define	YYFILL(n)	{cursor = fill(cursor);}

#define	RETURN(i)	{cur = cursor; return i;}

namespace re2c
{

Scanner::Scanner(std::istream& i, std::ostream& o)
	: in(i)
	, out(o)
	, bot(NULL), tok(NULL), ptr(NULL), cur(NULL), pos(NULL), lim(NULL)
	, top(NULL), eof(NULL), tchar(0), tline(0), cline(1), iscfg(0)
{
    ;
}

char *Scanner::fill(char *cursor)
{
	if(!eof)
	{
		uint cnt = tok - bot;
		if(cnt)
		{
			memcpy(bot, tok, lim - tok);
			tok = bot;
			ptr -= cnt;
			cursor -= cnt;
			pos -= cnt;
			lim -= cnt;
		}
		if((top - lim) < BSIZE)
		{
			char *buf = new char[(lim - bot) + BSIZE];
			memcpy(buf, tok, lim - tok);
			tok = buf;
			ptr = &buf[ptr - bot];
			cursor = &buf[cursor - bot];
			pos = &buf[pos - bot];
			lim = &buf[lim - bot];
			top = &lim[BSIZE];
			delete [] bot;
			bot = buf;
		}
		in.read(lim, BSIZE);
		if ((cnt = in.gcount()) != BSIZE )
		{
			eof = &lim[cnt]; *eof++ = '\0';
		}
		lim += cnt;
	}
	return cursor;
}

#line 96 "real_world/scanner_s.re"


int Scanner::echo()
{
    char *cursor = cur;
    bool ignore_eoc = false;

    if (eof && cursor == eof) // Catch EOF
	{
    	return 0;
	}

    tok = cursor;
echo:

#line 97 "real_world/scanner_s.c"
{
	YYCTYPE yych;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
	if (yych <= ')') {
		if (yych <= 0x00) goto yy1;
		if (yych == '\n') goto yy4;
		goto yy2;
	} else {
		if (yych <= '*') goto yy5;
		if (yych == '/') goto yy6;
		goto yy2;
	}
yy1:
	++YYCURSOR;
#line 136 "real_world/scanner_s.re"
	{
					out.write((const char*)(tok), (const char*)(cursor) - (const char*)(tok) - 1); // -1 so we don't write out the \0
					if(cursor == eof) {
						RETURN(0);
					}
				}
#line 120 "real_world/scanner_s.c"
yy2:
	++YYCURSOR;
yy3:
#line 142 "real_world/scanner_s.re"
	{
					goto echo;
				}
#line 128 "real_world/scanner_s.c"
yy4:
	++YYCURSOR;
#line 131 "real_world/scanner_s.re"
	{
					out.write((const char*)(tok), (const char*)(cursor) - (const char*)(tok));
					tok = pos = cursor; cline++;
				  	goto echo;
				}
#line 137 "real_world/scanner_s.c"
yy5:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy7;
	goto yy3;
yy6:
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '*') goto yy8;
	goto yy3;
yy7:
	++YYCURSOR;
#line 122 "real_world/scanner_s.re"
	{
					if (ignore_eoc) {
						ignore_eoc = false;
					} else {
						out.write((const char*)(tok), (const char*)(cursor) - (const char*)(tok));
					}
					tok = pos = cursor;
					goto echo;
				}
#line 158 "real_world/scanner_s.c"
yy8:
	yych = *++YYCURSOR;
	if (yych == '!') goto yy10;
yy9:
	YYCURSOR = YYMARKER;
	goto yy3;
yy10:
	yych = *++YYCURSOR;
	if (yych == 'm') goto yy11;
	if (yych == 'r') goto yy12;
	goto yy9;
yy11:
	yych = *++YYCURSOR;
	if (yych == 'a') goto yy13;
	goto yy9;
yy12:
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy14;
	goto yy9;
yy13:
	yych = *++YYCURSOR;
	if (yych == 'x') goto yy15;
	goto yy9;
yy14:
	yych = *++YYCURSOR;
	if (yych == '2') goto yy16;
	goto yy9;
yy15:
	yych = *++YYCURSOR;
	if (yych == ':') goto yy17;
	goto yy9;
yy16:
	yych = *++YYCURSOR;
	if (yych == 'c') goto yy18;
	goto yy9;
yy17:
	yych = *++YYCURSOR;
	if (yych == 'r') goto yy19;
	goto yy9;
yy18:
	++YYCURSOR;
#line 111 "real_world/scanner_s.re"
	{ 
					out.write((const char*)(tok), (const char*)(&cursor[-7]) - (const char*)(tok));
					tok = cursor;
					RETURN(1);
				}
#line 206 "real_world/scanner_s.c"
yy19:
	yych = *++YYCURSOR;
	if (yych != 'e') goto yy9;
	yych = *++YYCURSOR;
	if (yych != '2') goto yy9;
	yych = *++YYCURSOR;
	if (yych != 'c') goto yy9;
	++YYCURSOR;
#line 116 "real_world/scanner_s.re"
	{
					out << "#define YYMAXFILL " << maxFill << std::endl;
					tok = pos = cursor;
					ignore_eoc = true;
					goto echo;
				}
#line 222 "real_world/scanner_s.c"
}
#line 145 "real_world/scanner_s.re"

}


int Scanner::scan()
{
    char *cursor = cur;
    uint depth;

scan:
    tchar = cursor - pos;
    tline = cline;
    tok = cursor;
	if (iscfg == 1)
	{
		goto config;
	}
	else if (iscfg == 2)
	{
   		goto value;
    }

#line 247 "real_world/scanner_s.c"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= '/') {
		if (yych <= '!') {
			if (yych <= '\f') {
				if (yych <= 0x08) goto yy21;
				if (yych <= '\t') goto yy23;
				if (yych <= '\n') goto yy24;
			} else {
				if (yych <= '\r') goto yy25;
				if (yych == ' ') goto yy23;
			}
		} else {
			if (yych <= ')') {
				if (yych <= '"') goto yy26;
				if (yych <= '&') goto yy21;
				if (yych <= '\'') goto yy28;
				goto yy30;
			} else {
				if (yych <= '+') {
					if (yych <= '*') goto yy32;
					goto yy34;
				} else {
					if (yych <= '-') goto yy21;
					if (yych <= '.') goto yy35;
					goto yy36;
				}
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '=') {
				if (yych == ';') goto yy30;
				if (yych >= '=') goto yy30;
			} else {
				if (yych == '?') goto yy34;
				if (yych >= 'A') goto yy37;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '[') goto yy40;
				if (yych <= '\\') goto yy30;
				if (yych >= 'a') goto yy37;
			} else {
				if (yych <= 'z') {
					if (yych <= 'r') goto yy42;
					goto yy37;
				} else {
					if (yych <= '{') goto yy43;
					if (yych <= '|') goto yy30;
				}
			}
		}
	}
yy21:
	++YYCURSOR;
yy22:
#line 242 "real_world/scanner_s.re"
	{ std::ostringstream msg;
				  msg << "unexpected character: ";
				  prtChOrHex(msg, *tok);
				  fatal(msg.str().c_str());
				  goto scan;
				}
#line 315 "real_world/scanner_s.c"
yy23:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == '\t') goto yy23;
	if (yych == ' ') goto yy23;
#line 235 "real_world/scanner_s.re"
	{ goto scan; }
#line 324 "real_world/scanner_s.c"
yy24:
	++YYCURSOR;
#line 237 "real_world/scanner_s.re"
	{ if(cursor == eof) RETURN(0);
				  pos = cursor; cline++;
				  goto scan;
	    			}
#line 332 "real_world/scanner_s.c"
yy25:
	yych = *++YYCURSOR;
	if (yych == '\n') goto yy24;
	goto yy22;
yy26:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '\n') goto yy46;
yy27:
#line 184 "real_world/scanner_s.re"
	{ fatal("unterminated string constant (missing \")"); }
#line 344 "real_world/scanner_s.c"
yy28:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych != '\n') goto yy51;
yy29:
#line 185 "real_world/scanner_s.re"
	{ fatal("unterminated string constant (missing ')"); }
#line 352 "real_world/scanner_s.c"
yy30:
	++YYCURSOR;
yy31:
#line 197 "real_world/scanner_s.re"
	{ RETURN(*tok); }
#line 358 "real_world/scanner_s.c"
yy32:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy54;
yy33:
#line 199 "real_world/scanner_s.re"
	{ yylval.op = *tok;
				  RETURN(CLOSE); }
#line 366 "real_world/scanner_s.c"
yy34:
	++YYCURSOR;
	goto yy33;
yy35:
	++YYCURSOR;
#line 230 "real_world/scanner_s.re"
	{ cur = cursor;
				  yylval.regexp = mkDot();
				  return RANGE;
				}
#line 377 "real_world/scanner_s.c"
yy36:
	yych = *++YYCURSOR;
	if (yych == '*') goto yy55;
	goto yy31;
yy37:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy38:
	if (yych <= '@') {
		if (yych <= '/') goto yy39;
		if (yych <= '9') goto yy37;
	} else {
		if (yych <= 'Z') goto yy37;
		if (yych <= '`') goto yy39;
		if (yych <= 'z') goto yy37;
	}
yy39:
#line 226 "real_world/scanner_s.re"
	{ cur = cursor;
				  yylval.symbol = Symbol::find(token());
				  return ID; }
#line 400 "real_world/scanner_s.c"
yy40:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '\n') goto yy41;
	if (yych == '^') goto yy60;
	goto yy57;
yy41:
#line 195 "real_world/scanner_s.re"
	{ fatal("unterminated range (missing ])"); }
#line 410 "real_world/scanner_s.c"
yy42:
	yych = *++YYCURSOR;
	if (yych == 'e') goto yy61;
	goto yy38;
yy43:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == ',') goto yy62;
	} else {
		if (yych <= '0') goto yy64;
		if (yych <= '9') goto yy65;
	}
yy44:
#line 167 "real_world/scanner_s.re"
	{ depth = 1;
				  goto code;
				}
#line 429 "real_world/scanner_s.c"
yy45:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy46:
	if (yych <= '!') {
		if (yych != '\n') goto yy45;
	} else {
		if (yych <= '"') goto yy48;
		if (yych == '\\') goto yy49;
		goto yy45;
	}
yy47:
	YYCURSOR = YYMARKER;
	if (yyaccept <= 3) {
		if (yyaccept <= 1) {
			if (yyaccept == 0) goto yy27;
			else goto yy29;
		} else {
			if (yyaccept == 2) goto yy41;
			else goto yy44;
		}
	} else {
		if (yyaccept <= 5) {
			if (yyaccept == 4) goto yy63;
			else goto yy39;
		} else {
			goto yy80;
		}
	}
yy48:
	++YYCURSOR;
#line 176 "real_world/scanner_s.re"
	{ cur = cursor;
				  yylval.regexp = strToRE(token());
				  return STRING; }
#line 466 "real_world/scanner_s.c"
yy49:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == '\n') goto yy47;
	goto yy45;
yy50:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy51:
	if (yych <= '&') {
		if (yych == '\n') goto yy47;
		goto yy50;
	} else {
		if (yych <= '\'') goto yy52;
		if (yych == '\\') goto yy53;
		goto yy50;
	}
yy52:
	++YYCURSOR;
#line 180 "real_world/scanner_s.re"
	{ cur = cursor;
				  yylval.regexp = strToCaseInsensitiveRE(token());
				  return STRING; }
#line 492 "real_world/scanner_s.c"
yy53:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == '\n') goto yy47;
	goto yy50;
yy54:
	++YYCURSOR;
#line 173 "real_world/scanner_s.re"
	{ tok = cursor;
				  RETURN(0); }
#line 504 "real_world/scanner_s.c"
yy55:
	++YYCURSOR;
#line 170 "real_world/scanner_s.re"
	{ depth = 1;
				  goto comment; }
#line 510 "real_world/scanner_s.c"
yy56:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy57:
	if (yych <= '[') {
		if (yych == '\n') goto yy47;
		goto yy56;
	} else {
		if (yych <= '\\') goto yy58;
		if (yych <= ']') goto yy59;
		goto yy56;
	}
yy58:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == '\n') goto yy47;
	goto yy56;
yy59:
	++YYCURSOR;
#line 191 "real_world/scanner_s.re"
	{ cur = cursor;
				  yylval.regexp = ranToRE(token());
				  return RANGE; }
#line 536 "real_world/scanner_s.c"
yy60:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '[') {
		if (yych == '\n') goto yy47;
		goto yy60;
	} else {
		if (yych <= '\\') goto yy67;
		if (yych <= ']') goto yy68;
		goto yy60;
	}
yy61:
	yych = *++YYCURSOR;
	if (yych == '2') goto yy69;
	goto yy38;
yy62:
	++YYCURSOR;
yy63:
#line 217 "real_world/scanner_s.re"
	{ fatal("illegal closure form, use '{n}', '{n,}', '{n,m}' where n and m are numbers"); }
#line 558 "real_world/scanner_s.c"
yy64:
	yych = *++YYCURSOR;
	if (yych == ',') goto yy70;
	goto yy66;
yy65:
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
yy66:
	if (yych <= '/') {
		if (yych == ',') goto yy72;
		goto yy47;
	} else {
		if (yych <= '9') goto yy65;
		if (yych == '}') goto yy71;
		goto yy47;
	}
yy67:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == '\n') goto yy47;
	goto yy60;
yy68:
	++YYCURSOR;
#line 187 "real_world/scanner_s.re"
	{ cur = cursor;
				  yylval.regexp = invToRE(token());
				  return RANGE; }
#line 588 "real_world/scanner_s.c"
yy69:
	yych = *++YYCURSOR;
	if (yych == 'c') goto yy73;
	goto yy38;
yy70:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy63;
	if (yych <= '9') goto yy74;
	if (yych == '}') goto yy75;
	goto yy63;
yy71:
	++YYCURSOR;
#line 205 "real_world/scanner_s.re"
	{ yylval.extop.minsize = atoi((char *)tok+1);
				  yylval.extop.maxsize = atoi((char *)tok+1);
				  RETURN(CLOSESIZE); }
#line 606 "real_world/scanner_s.c"
yy72:
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy63;
	if (yych <= '9') goto yy74;
	if (yych == '}') goto yy76;
	goto yy63;
yy73:
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == ':') goto yy77;
	goto yy38;
yy74:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '/') goto yy47;
	if (yych <= '9') goto yy74;
	if (yych == '}') goto yy78;
	goto yy47;
yy75:
	++YYCURSOR;
#line 202 "real_world/scanner_s.re"
	{ yylval.op = '*';
				  RETURN(CLOSE); }
#line 632 "real_world/scanner_s.c"
yy76:
	++YYCURSOR;
#line 213 "real_world/scanner_s.re"
	{ yylval.extop.minsize = atoi((char *)tok+1);
				  yylval.extop.maxsize = -1;
				  RETURN(CLOSESIZE); }
#line 639 "real_world/scanner_s.c"
yy77:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') goto yy47;
	if (yych <= 'Z') goto yy79;
	if (yych <= '`') goto yy47;
	if (yych <= 'z') goto yy79;
	goto yy47;
yy78:
	++YYCURSOR;
#line 209 "real_world/scanner_s.re"
	{ yylval.extop.minsize = atoi((char *)tok+1);
				  yylval.extop.maxsize = MAX(yylval.extop.minsize,atoi(strchr((char *)tok, ',')+1));
				  RETURN(CLOSESIZE); }
#line 655 "real_world/scanner_s.c"
yy79:
	yyaccept = 6;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= 'Z') {
		if (yych <= '9') {
			if (yych >= '0') goto yy79;
		} else {
			if (yych <= ':') goto yy77;
			if (yych >= 'A') goto yy79;
		}
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto yy79;
		} else {
			if (yych <= '`') goto yy80;
			if (yych <= 'z') goto yy79;
		}
	}
yy80:
#line 219 "real_world/scanner_s.re"
	{ cur = cursor;
				  tok+= 5; /* skip "re2c:" */
				  iscfg = 1;
				  yylval.str = new Str(token());
				  return CONFIG;
				}
#line 684 "real_world/scanner_s.c"
}
#line 248 "real_world/scanner_s.re"


code:

#line 691 "real_world/scanner_s.c"
{
	YYCTYPE yych;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	if (yych <= '&') {
		if (yych <= '\n') {
			if (yych >= '\n') goto yy84;
		} else {
			if (yych == '"') goto yy85;
		}
	} else {
		if (yych <= '{') {
			if (yych <= '\'') goto yy86;
			if (yych >= '{') goto yy87;
		} else {
			if (yych == '}') goto yy88;
		}
	}
yy82:
	++YYCURSOR;
yy83:
#line 264 "real_world/scanner_s.re"
	{ goto code; }
#line 715 "real_world/scanner_s.c"
yy84:
	++YYCURSOR;
#line 260 "real_world/scanner_s.re"
	{ if(cursor == eof) fatal("missing '}'");
				  pos = cursor; cline++;
				  goto code;
				}
#line 723 "real_world/scanner_s.c"
yy85:
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '\n') goto yy83;
	goto yy90;
yy86:
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '\n') goto yy83;
	goto yy94;
yy87:
	++YYCURSOR;
#line 258 "real_world/scanner_s.re"
	{ ++depth;
				  goto code; }
#line 737 "real_world/scanner_s.c"
yy88:
	++YYCURSOR;
#line 252 "real_world/scanner_s.re"
	{ if(--depth == 0){
					cur = cursor;
					yylval.token = new Token(token(), tline);
					return CODE;
				  }
				  goto code; }
#line 747 "real_world/scanner_s.c"
yy89:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy90:
	if (yych <= '!') {
		if (yych != '\n') goto yy89;
	} else {
		if (yych <= '"') goto yy82;
		if (yych == '\\') goto yy92;
		goto yy89;
	}
yy91:
	YYCURSOR = YYMARKER;
	goto yy83;
yy92:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == '\n') goto yy91;
	goto yy89;
yy93:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy94:
	if (yych <= '&') {
		if (yych == '\n') goto yy91;
		goto yy93;
	} else {
		if (yych <= '\'') goto yy82;
		if (yych != '\\') goto yy93;
	}
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == '\n') goto yy91;
	goto yy93;
}
#line 265 "real_world/scanner_s.re"


comment:

#line 792 "real_world/scanner_s.c"
{
	YYCTYPE yych;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	if (yych <= ')') {
		if (yych == '\n') goto yy97;
	} else {
		if (yych <= '*') goto yy98;
		if (yych == '/') goto yy99;
	}
	++YYCURSOR;
yy96:
#line 280 "real_world/scanner_s.re"
	{ if(cursor == eof) RETURN(0);
				  goto comment; }
#line 808 "real_world/scanner_s.c"
yy97:
	++YYCURSOR;
#line 276 "real_world/scanner_s.re"
	{ if(cursor == eof) RETURN(0);
				  tok = pos = cursor; cline++;
				  goto comment;
				}
#line 816 "real_world/scanner_s.c"
yy98:
	yych = *++YYCURSOR;
	if (yych == '/') goto yy100;
	goto yy96;
yy99:
	yych = *++YYCURSOR;
	if (yych == '*') goto yy101;
	goto yy96;
yy100:
	++YYCURSOR;
#line 269 "real_world/scanner_s.re"
	{ if(--depth == 0)
					goto scan;
				    else
					goto comment; }
#line 832 "real_world/scanner_s.c"
yy101:
	++YYCURSOR;
#line 273 "real_world/scanner_s.re"
	{ ++depth;
				  fatal("ambiguous /* found");
				  goto comment; }
#line 839 "real_world/scanner_s.c"
}
#line 282 "real_world/scanner_s.re"


config:

#line 846 "real_world/scanner_s.c"
{
	YYCTYPE yych;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= 0x1F) {
		if (yych == '\t') goto yy103;
	} else {
		if (yych <= ' ') goto yy103;
		if (yych == '=') goto yy104;
	}
	++YYCURSOR;
#line 291 "real_world/scanner_s.re"
	{ fatal("missing '='"); }
#line 860 "real_world/scanner_s.c"
yy103:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == '\t') goto yy103;
	if (yych == ' ') goto yy103;
#line 286 "real_world/scanner_s.re"
	{ goto config; }
#line 869 "real_world/scanner_s.c"
yy104:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == '\t') goto yy104;
	if (yych == ' ') goto yy104;
#line 287 "real_world/scanner_s.re"
	{ iscfg = 2;
				  cur = cursor;
				  RETURN('='); 
				}
#line 881 "real_world/scanner_s.c"
}
#line 292 "real_world/scanner_s.re"


value:

#line 888 "real_world/scanner_s.c"
{
	YYCTYPE yych;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	if (yych <= '&') {
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy107;
			if (yych <= '\n') goto yy106;
			if (yych <= '\f') goto yy107;
		} else {
			if (yych <= ' ') {
				if (yych <= 0x1F) goto yy107;
			} else {
				if (yych == '"') goto yy109;
				goto yy107;
			}
		}
	} else {
		if (yych <= '/') {
			if (yych <= '\'') goto yy110;
			if (yych == '-') goto yy111;
			goto yy107;
		} else {
			if (yych <= '9') {
				if (yych <= '0') goto yy112;
				goto yy114;
			} else {
				if (yych != ';') goto yy107;
			}
		}
	}
yy106:
#line 301 "real_world/scanner_s.re"
	{ cur = cursor;
				  yylval.str = new Str(token());
				  iscfg = 0;
				  return VALUE;
				}
#line 927 "real_world/scanner_s.c"
yy107:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy108:
	if (yych <= '\r') {
		if (yych <= 0x08) goto yy107;
		if (yych <= '\n') goto yy106;
		if (yych <= '\f') goto yy107;
		goto yy106;
	} else {
		if (yych <= ' ') {
			if (yych <= 0x1F) goto yy107;
			goto yy106;
		} else {
			if (yych == ';') goto yy106;
			goto yy107;
		}
	}
yy109:
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= ' ') {
		if (yych <= '\n') {
			if (yych <= 0x08) goto yy109;
			if (yych <= '\t') goto yy115;
			goto yy106;
		} else {
			if (yych == '\r') goto yy115;
			if (yych <= 0x1F) goto yy109;
			goto yy115;
		}
	} else {
		if (yych <= ':') {
			if (yych == '"') goto yy107;
			goto yy109;
		} else {
			if (yych <= ';') goto yy115;
			if (yych == '\\') goto yy117;
			goto yy109;
		}
	}
yy110:
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= ' ') {
		if (yych <= '\n') {
			if (yych <= 0x08) goto yy110;
			if (yych <= '\t') goto yy118;
			goto yy106;
		} else {
			if (yych == '\r') goto yy118;
			if (yych <= 0x1F) goto yy110;
			goto yy118;
		}
	} else {
		if (yych <= ':') {
			if (yych == '\'') goto yy107;
			goto yy110;
		} else {
			if (yych <= ';') goto yy118;
			if (yych == '\\') goto yy119;
			goto yy110;
		}
	}
yy111:
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy108;
	if (yych <= '9') goto yy114;
	goto yy108;
yy112:
	yych = *++YYCURSOR;
	if (yych <= '\r') {
		if (yych <= 0x08) goto yy107;
		if (yych <= '\n') goto yy113;
		if (yych <= '\f') goto yy107;
	} else {
		if (yych <= ' ') {
			if (yych <= 0x1F) goto yy107;
		} else {
			if (yych != ';') goto yy107;
		}
	}
yy113:
#line 296 "real_world/scanner_s.re"
	{ cur = cursor;
				  yylval.number = atoi(token().to_string().c_str());
				  iscfg = 0;
				  return NUMBER;
				}
#line 1020 "real_world/scanner_s.c"
yy114:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych <= 0x08) goto yy107;
			goto yy113;
		} else {
			if (yych == '\r') goto yy113;
			goto yy107;
		}
	} else {
		if (yych <= '9') {
			if (yych <= ' ') goto yy113;
			if (yych <= '/') goto yy107;
			goto yy114;
		} else {
			if (yych == ';') goto yy113;
			goto yy107;
		}
	}
yy115:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '!') {
		if (yych != '\n') goto yy115;
	} else {
		if (yych <= '"') goto yy120;
		if (yych == '\\') goto yy121;
		goto yy115;
	}
yy116:
	YYCURSOR = YYMARKER;
	goto yy106;
yy117:
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '\r') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy109;
			goto yy115;
		} else {
			if (yych <= '\n') goto yy106;
			if (yych <= '\f') goto yy109;
			goto yy115;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= 0x1F) goto yy109;
			goto yy115;
		} else {
			if (yych == ';') goto yy115;
			goto yy109;
		}
	}
yy118:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '&') {
		if (yych == '\n') goto yy116;
		goto yy118;
	} else {
		if (yych <= '\'') goto yy120;
		if (yych == '\\') goto yy122;
		goto yy118;
	}
yy119:
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '\r') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy110;
			goto yy118;
		} else {
			if (yych <= '\n') goto yy106;
			if (yych <= '\f') goto yy110;
			goto yy118;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= 0x1F) goto yy110;
			goto yy118;
		} else {
			if (yych == ';') goto yy118;
			goto yy110;
		}
	}
yy120:
	++YYCURSOR;
	goto yy106;
yy121:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == '\n') goto yy116;
	goto yy115;
yy122:
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych == '\n') goto yy116;
	goto yy118;
}
#line 306 "real_world/scanner_s.re"

}

void Scanner::fatal(uint ofs, const char *msg) const
{
	out.flush();
	std::cerr << "re2c: error: "
		<< "line " << tline << ", column " << (tchar + ofs + 1) << ": "
		<< msg << std::endl;
   	exit(1);
}

} // end namespace re2c

real_world/scanner_s.re:301:8: warning: rule matches empty string [-Wmatch-empty-string]
