/* Generated by re2c */
// re2c $INPUT -o $OUTPUT --recursive-functions -i
#include <assert.h>
#include <stdlib.h>
#include <string.h>

#define YYMAXFILL 1


struct State {
    const char* cur;
    const char* lim;
    int count;
};


int yy0(State& st);
int yy1(State& st);
int yy2(State& st);
int yy3(State& st);
int yy4(State& st);
int yy5(State& st);
int yy6(State& st);
int yy7(State& st);
int lex(State& st);

int yy0(State& st) {
	if (st.lim <= st.cur) return -1;
	char yych = *st.cur++;
	switch (yych) {
		case 0x00: return yy1(st);
		case ' ': return yy3(st);
		case '\'': return yy5(st);
		default: return yy2(st);
	}
}

int yy1(State& st) {
	return st.cur + YYMAXFILL - 1 == st.lim ? st.count : -1;
}

int yy2(State& st) {
	return -1;
}

int yy3(State& st) {
	if (st.lim <= st.cur) return -1;
	char yych = *st.cur;
	switch (yych) {
		case ' ':
			++st.cur;
			return yy3(st);
		default: return yy4(st);
	}
}

int yy4(State& st) {
	return lex(st);
}

int yy5(State& st) {
	if (st.lim <= st.cur) return -1;
	char yych = *st.cur++;
	switch (yych) {
		case '\'': return yy6(st);
		case '\\': return yy7(st);
		default: return yy5(st);
	}
}

int yy6(State& st) {
	++st.count; return lex(st);
}

int yy7(State& st) {
	if (st.lim <= st.cur) return -1;
	++st.cur;
	return yy5(st);
}

int lex(State& st) {
	return yy0(st);
}



// make a copy of the string with YYMAXFILL zeroes at the end
static void test(const char *str, unsigned int len, int res) {
    char *s = (char*) malloc(len + YYMAXFILL);
    memcpy(s, str, len);
    memset(s + len, 0, YYMAXFILL);
    State st{s, s + len + YYMAXFILL, 0};
    int r = lex(st);
    free(s);
    assert(r == res);
}

#define TEST(s, r) test(s, sizeof(s) - 1, r)
int main() {
    TEST("", 0);
    TEST("'qu\0tes' 'are' 'fine: \\'' ", 3);
    TEST("'unterminated\\'", -1);
    return 0;
}
