from typing import Any

from . import MQTTException as MQTTException

class MalformedPacket(MQTTException): ...

def writeInt16(length: int) -> bytearray: ...
def readInt16(buf: bytes) -> int: ...
def writeInt32(length: int) -> bytearray: ...
def readInt32(buf: bytes) -> int: ...
def writeUTF(data: str | bytes) -> bytearray: ...
def readUTF(buffer: bytes, maxlen: int) -> tuple[str, int]: ...
def writeBytes(buffer: bytes) -> bytearray: ...
def readBytes(buffer: bytes) -> tuple[bytes, int]: ...

class VariableByteIntegers:
    @staticmethod
    def encode(x: int) -> bytes: ...
    @staticmethod
    def decode(buffer: bytes) -> tuple[int, int]: ...

class Properties:
    packetType: int
    types: list[str]
    names: dict[str, int]
    properties: dict[int, tuple[int, list[int]]]
    def __init__(self, packetType: int) -> None: ...
    def allowsMultiple(self, compressedName: str) -> bool: ...
    def getIdentFromName(self, compressedName: str) -> int: ...
    def __setattr__(self, name: str, value: Any) -> None: ...
    def json(self) -> dict[str, Any]: ...
    def isEmpty(self) -> bool: ...
    def clear(self) -> None: ...
    def writeProperty(self, identifier: int, type: int, value: Any) -> bytes: ...
    def pack(self) -> bytes: ...
    def readProperty(self, buffer: bytes, type: int, propslen: int) -> Any: ...
    def getNameFromIdent(self, identifier: int) -> str | None: ...
    def unpack(self, buffer: bytes) -> tuple[Properties, int]: ...
