# -*- coding: utf-8 -*-
#
# Copyright © 2018 Michal Čihař <michal@cihar.com>
#
# This file is part of Weblate translation-finder
# <https://github.com/WeblateOrg/translation-finder>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#

"""
Language data definitions.

This is an automatically generated file, see scripts/generate-language-data

Do not edit, please adjust language definitions in following repository:
https://github.com/WeblateOrg/language-data
"""

from __future__ import unicode_literals


# Known language codes
LANGUAGES = frozenset(
    (
        "aa",
        "ab",
        "ace",
        "ach",
        "ady",
        "ae",
        "af",
        "ak",
        "am",
        "an",
        "anp",
        "ar",
        "ar_ar",
        "ar_dz",
        "ar_eg",
        "ar_kw",
        "ar_ma",
        "ar_sa",
        "arabic",
        "arn",
        "ars",
        "as",
        "asa",
        "ast",
        "av",
        "ay",
        "az",
        "ba",
        "ba_ck",
        "bar",
        "base",
        "be",
        "be@latin",
        "be_latn",
        "be_rby",
        "bem",
        "bez",
        "bg",
        "bh",
        "bi",
        "bm",
        "bn",
        "bn_bd",
        "bn_in",
        "bo",
        "br",
        "braz_por",
        "brx",
        "bs",
        "bs_cyrl",
        "bs_latn",
        "bs_latn_ba",
        "by",
        "byn",
        "ca",
        "ca@valencia",
        "ca_es@valencia",
        "ca_ps",
        "ce",
        "ceb",
        "cgg",
        "ch",
        "chinese_chs",
        "chinese_zh",
        "chm",
        "chr",
        "ckb",
        "cmn",
        "co",
        "cr",
        "crh",
        "cs",
        "csb",
        "cu",
        "cv",
        "cy",
        "da",
        "de",
        "de_at",
        "de_ch",
        "de_fo",
        "dk",
        "doi",
        "dsb",
        "dutch_be",
        "dv",
        "dz",
        "ee",
        "el",
        "en",
        "en_au",
        "en_ca",
        "en_en",
        "en_gb",
        "en_ie",
        "en_in",
        "en_nz",
        "en_ph",
        "en_us",
        "en_za",
        "english",
        "english_uk",
        "eo",
        "es",
        "es_419",
        "es_ar",
        "es_cl",
        "es_do",
        "es_ec",
        "es_eu",
        "es_mx",
        "es_pe",
        "es_pr",
        "es_us",
        "et",
        "eu",
        "fa",
        "fa_af",
        "ff",
        "fi",
        "fil",
        "fj",
        "fo",
        "fr",
        "fr_be",
        "fr_ca",
        "fr_ch",
        "french",
        "frp",
        "fur",
        "fy",
        "ga",
        "gd",
        "german",
        "gez",
        "gl",
        "gn",
        "gr",
        "gsw",
        "gu",
        "gun",
        "guw",
        "gv",
        "ha",
        "haw",
        "he",
        "hi",
        "hil",
        "hne",
        "ho",
        "hr",
        "hrx",
        "hsb",
        "ht",
        "hu",
        "hy",
        "hz",
        "ia",
        "id",
        "ie",
        "ig",
        "ii",
        "ik",
        "in",
        "indonesian",
        "io",
        "is",
        "it",
        "iu",
        "iw",
        "ja",
        "ja_ks",
        "jam",
        "jbo",
        "jgo",
        "ji",
        "jmc",
        "jp",
        "jpn",
        "jv",
        "jw",
        "ka",
        "kab",
        "kaj",
        "kcg",
        "kde",
        "kea",
        "kg",
        "ki",
        "kj",
        "kk",
        "kkj",
        "kl",
        "km",
        "kmr",
        "kn",
        "ko",
        "kok",
        "korean",
        "kr",
        "ks",
        "ksb",
        "ksh",
        "ku",
        "kv",
        "kw",
        "ky",
        "la",
        "lag",
        "lb",
        "lg",
        "li",
        "lkt",
        "ln",
        "lo",
        "lt",
        "lu",
        "lv",
        "mai",
        "mas",
        "me",
        "mfe",
        "mg",
        "mgo",
        "mh",
        "mhr",
        "mi",
        "mk",
        "ml",
        "mn",
        "mni",
        "mnk",
        "mo",
        "mr",
        "ms",
        "mt",
        "my",
        "na",
        "nah",
        "nap",
        "naq",
        "nb",
        "nb_no",
        "nd",
        "nds",
        "ne",
        "ng",
        "nl",
        "nl_be",
        "nn",
        "nnh",
        "no",
        "no_nb",
        "norwegian",
        "nqo",
        "nr",
        "nso",
        "nv",
        "ny",
        "nyn",
        "oc",
        "oj",
        "om",
        "or",
        "os",
        "pa",
        "pap",
        "pi",
        "pl",
        "pms",
        "polish",
        "portuguese_br",
        "portuguese_portugal",
        "pr",
        "prg",
        "ps",
        "pt",
        "pt_ao",
        "pt_br",
        "pt_pt",
        "qu",
        "rm",
        "rn",
        "ro",
        "ro_md",
        "rof",
        "rs",
        "ru",
        "ru_r",
        "ru_rr",
        "rue",
        "russian",
        "rw",
        "rwk",
        "sa",
        "sah",
        "saq",
        "sat",
        "sc",
        "scc",
        "schinese",
        "sco",
        "scr",
        "sd",
        "sdh",
        "se",
        "seh",
        "serbian",
        "serbo_croatian",
        "ses",
        "sg",
        "sh",
        "shi",
        "shn",
        "si",
        "sk",
        "sl",
        "sm",
        "sma",
        "smi",
        "smj",
        "smn",
        "sms",
        "sn",
        "so",
        "son",
        "source",
        "spanish",
        "sq",
        "sr",
        "sr@cyrillic",
        "sr@latin",
        "sr_cs",
        "sr_cyrl",
        "sr_latn",
        "sr_latn_rs",
        "sr_rs@cyrillic",
        "sr_rs@latin",
        "ss",
        "ssy",
        "st",
        "su",
        "sv",
        "sw",
        "sw_cd",
        "swe",
        "syr",
        "szl",
        "ta",
        "ta_lk",
        "tchinese",
        "te",
        "teo",
        "tg",
        "th",
        "ti",
        "tig",
        "tk",
        "tl",
        "tlh",
        "tlh-qaak",
        "tn",
        "to",
        "tr",
        "ts",
        "tt",
        "tt@iqtelif",
        "tw",
        "ty",
        "tzm",
        "ua",
        "ug",
        "uk",
        "ur",
        "ur_pk",
        "uz",
        "uz@latin",
        "uz_latn",
        "val_es",
        "ve",
        "vec",
        "vi",
        "vls",
        "vo",
        "vun",
        "wa",
        "wae",
        "wal",
        "wen",
        "wo",
        "xh",
        "xog",
        "yi",
        "yo",
        "yue",
        "za",
        "zh",
        "zh_chs",
        "zh_cmn_hans",
        "zh_cmn_hant",
        "zh_cn",
        "zh_hans",
        "zh_hans_cn",
        "zh_hant",
        "zh_hant_hk",
        "zh_hk",
        "zh_tw",
        "zho",
        "zu",
    )
)
