---
myst:
  html_meta:
    keywords: LaTeX, langages de programmation, mise en forme de code, coloration syntaxique, formater un programme,formater du code, verbatim, insérer du code-source, listing informatique, listings, listing"
---
# Comment présenter du code informatique avec le package <ctanpkg:listings> ?

Le package <ctanpkg:listings> est un des packages les plus aboutis pour mettre en page du
code informatique. Ce n’est pas le plus puissant, mais il est le plus immédiat à utiliser.

Pour les autres solutions on pourra se référer à [](/4_domaines_specialises/sciences/informatique/inserer_du_code_source_informatique.md)

:::{important}
<ctanpkg:listings> est à charger **après** <ctanpkg:babel>
:::

## L’environnement `lstlisting`
### Premier exemple
La syntaxe de base est la suivante :

```{noedit}
\begin{lstlisting}[⟨options⟩]
⟨bloc de code⟩
\end{lstlisting}
```

``` 
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage{babel}
\usepackage{listings}

\begin{document}
\begin{lstlisting}[language=python]
# Une  boucle
for i in range(0,5): 
    print(i)
# Une autre boucle 
while i != "4": 
    print("Encore un tour !")
\end{lstlisting}
\end{document}
```

:::{note}
Le seul argument optionnel utilisé dans cet exemple indique le language utilisé. Sans
cette précision, les mots clefs ne seraient pas mis en gras, les commentaires ne
seraient pas en italique et les espaces dans les chaînes de caractères ne
seraient pas matérialisés.
:::

### Amélioration de la présentation avec quelques options.
L’exemple précédent est très sommaire et on peut bien sûr améliorer le rendu avec quelques
options.

```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage{xcolor}
\usepackage{babel}
\usepackage{listings}

\begin{document}
\begin{lstlisting}[
    basicstyle = \ttfamily,
	language = python,
	frame = single,
	keywordstyle = \color{green!60!black},
	keywordstyle = {[2]\color{orange}},
	commentstyle = \color{gray}\itshape,
	stringstyle  = \color{blue},
	showstringspaces = false,
	numbers = left,
	numberstyle = \tiny,
	stepnumber = 1,
	numbersep = 15pt
]
# Une boucle
for i in range(0,5): 
    print(i)
# Une autre boucle 
while i != "4": 
    print("Encore un tour !")
\end{lstlisting}
\end{document}
```

:::{note}
Dans cet exemple, on utilise aussi le package <ctanpkg:xcolor>, pour la gestion des couleurs.
:::

## Réglage général des options
Pour ne pas avoir à réécrire les options à chaque fois, <ctanpkg:listings> fournit la
commande ```\lstset{⟨options⟩}```.

Cette commande est à placer dans le préambule. Les options choisies s’appliqueront à
l’ensemble du document.

```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage{xcolor}
\usepackage{babel}
\usepackage{listings}
\lstset{
    basicstyle = \ttfamily,
	language = python,
	frame = single,
	keywordstyle = \color{green!60!black},
	keywordstyle = {[2]\color{orange}},
	commentstyle = \color{gray}\itshape,
	stringstyle  = \color{blue},
	showstringspaces = false,
	numbers = left,
	numberstyle = \tiny,
	stepnumber = 1,
	numbersep = 15pt
}

\begin{document}
\begin{lstlisting}
# Une boucle
for i in range(0,5): 
    print(i)
# Une autre boucle 
while i != "4": 
    print("Encore un tour !")
\end{lstlisting}
\end{document}
```

## Stockage du code dans un fichier externe

Il est en général plus pratique de stocker le code informatique dans un fichier
externe et de l'insérer dans le fichier `.tex`. Ceci se fait au moyen de la
commande `\lstinputlisting` dont la syntaxe est :

```{noedit}
\lstinputlisting[⟨options⟩]{⟨nom du fichier externe⟩}
```

```
% Code particulier pour rendre l'exemple observable dans la FAQ
\begin{filecontents}[force,noheader]{mon_fichier_python.py}
# Une boucle
for i in range(0,5):
    print(i)
# Une autre boucle
while i != "4":
    print("Encore un tour !")
\end{filecontents}
% Fin du code particulier

\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage{xcolor}
\usepackage{babel}
\usepackage{listings}
\lstset{
    basicstyle = \ttfamily,
	language = python,
	frame = single,
	keywordstyle = \color{green!60!black},
	keywordstyle = {[2]\color{orange}},
	commentstyle = \color{gray}\itshape,
	stringstyle  = \color{blue},
	showstringspaces = false,
	numbers = left,
	numberstyle = \tiny,
	stepnumber = 1,
	numbersep = 15pt
}

\begin{document}
\lstinputlisting{mon_fichier_python.py}
\end{document}
```

## Problème des accents avec le moteur `pdflatex`

Des caractères accentués sont susceptibles de se trouver dans des codes
informatiques, notamment en commentaires. Avec le package <ctanpkg:listings>,
ils ne posent pas de problème lorsqu'on compile avec `xelatex` ou avec
`lualatex` mais ils font en revanche par défaut échouer les compilations
`pdflatex` :

```{noedit}
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage{xcolor}
\usepackage{babel}
\usepackage{listings}
\lstset{
    basicstyle = \ttfamily,
	language = python,
	frame = single,
	keywordstyle = \color{green!60!black},
	keywordstyle = {[2]\color{orange}},
	commentstyle = \color{gray}\itshape,
	stringstyle  = \color{blue},
	showstringspaces = false,
	numbers = left,
	numberstyle = \tiny,
	stepnumber = 1,
	numbersep = 15pt
}

\begin{document}
\begin{lstlisting}
# Une première boucle
for i in range(0,5):
    print(i)
# Une autre boucle
while i != "4":
    print("Encore un tour !")
\end{lstlisting}
\end{document}
```

Il y a deux moyens de résoudre ce problème : avec le package
<ctanpkg:listingsutf8> et avec l'option `literate`.

### Package <ctanpkg:listingsutf8>

Il suffit de :

1. charger, non pas <ctanpkg:listings>, mais <ctanpkg:listingsutf8> ;
2. recourir à l'option `inputencoding=utf8/latin1` ;
3. se contenter de `\lstinputlisting` (l'environnement `lstlisting` ne
   peut être utilisé).

```
% Code particulier pour rendre l'exemple observable dans la FAQ
\begin{filecontents}[force,noheader]{mon_autre_fichier_python.py}
# Une première boucle
for i in range(0,5):
    print(i)
# Une autre boucle
while i != "4":
    print("Encore un tour !")
\end{filecontents}
% Fin du code particulier

\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage{xcolor}
\usepackage{babel}
\usepackage{listingsutf8}
\lstset{
    basicstyle = \ttfamily,
	language = python,
    inputencoding = utf8/latin1,
	frame = single,
	keywordstyle = \color{green!60!black},
	keywordstyle = {[2]\color{orange}},
	commentstyle = \color{gray}\itshape,
	stringstyle  = \color{blue},
	showstringspaces = false,
	numbers = left,
	numberstyle = \tiny,
	stepnumber = 1,
	numbersep = 15pt
}

\begin{document}
\lstinputlisting{mon_autre_fichier_python.py}
\end{document}
```

### Option `literate`

L'option `literate` permet de remplacer les caractères accentués eux-mêmes par
leurs commandes LaTeX correspondantes qui, elles, sont reconnues par
<ctanpkg:listings>.

```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage{xcolor}
\usepackage{babel}
\usepackage{listings}
\lstset{
    basicstyle = \ttfamily,
	language = python,
	frame = single,
	keywordstyle = \color{green!60!black},
	keywordstyle = {[2]\color{orange}},
	commentstyle = \color{gray}\itshape,
	stringstyle  = \color{blue},
	showstringspaces = false,
	numbers = left,
	numberstyle = \tiny,
	stepnumber = 1,
	numbersep = 15pt,
	% pour les accents
	literate=
		{é}{{\'e}}1
		{è}{{\`{e}}}1
		{ê}{{\^{e}}}1
		{ë}{{\¨{e}}}1
		{É}{{\'{E}}}1
		{Ê}{{\^{E}}}1
		{û}{{\^{u}}}1
		{ù}{{\`{u}}}1
		{â}{{\^{a}}}1
		{à}{{\`{a}}}1
		{Â}{{\^{A}}}1
		{ç}{{\c{c}}}1
		{Ç}{{\c{C}}}1
		{ô}{{\^{o}}}1
		{Ô}{{\^{O}}}1
		{î}{{\^{i}}}1
		{Î}{{\^{I}}}1,	
}

\begin{document}
\begin{lstlisting}
# Une première boucle
for i in range(0,5): 
    print(i)
# Une autre boucle 
while i != "4": 
    print("Encore un tour !")
\end{lstlisting}
\end{document}
```

## Code en mode *inline*

Pour insérer de courts extraits de code dans du texte, <ctanpkg:listings> fournit
la commande `\lstinline` dont la syntaxe générale est la suivante :

```{noedit}
\lstinline⟨caractère au choix⟩⟨code⟩⟨(même) caractère au choix⟩
```

```
\documentclass[french]{article}
\usepackage[T1]{fontenc}
\usepackage{xcolor}
\usepackage{babel}
\usepackage{listings}
\lstset{
    basicstyle = \ttfamily,
	language = python,
	frame = single,
	keywordstyle = \color{green!60!black},
	keywordstyle = {[2]\color{orange}},
	commentstyle = \color{gray}\itshape,
	stringstyle  = \color{blue},
	showstringspaces = false,
	numbers = left,
	numberstyle = \tiny,
	stepnumber = 1,
	numbersep = 15pt
}

\begin{document}
En Python, on utilise \lstinline|for| pour les boucles bornées et
\lstinline|while| pour les boucles non bornées.
\end{document}
```

:::{note}
 - On note l’absence d’accolades pour délimiter le code après `\lstinline`, mais
   la présence d’un « *caractère au choix* », qui doit être le même au début et
   à la fin.
 - Dans cet exemple, on a choisi « | » comme caractère.
::::

:::{admonition} Info
:class: tip
Pour une mise en forme plus élaborée, on pourra utiliser le package
<ctanpkg:tcolorbox> :
cf. [](/4_domaines_specialises/sciences/informatique/inserer_du_code_source_informatique_tcolorbox.md)
:::
