from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


base_aliases = _Mock()

base_flags = _Mock()

catch_config_error = _Mock()

dedent = _Mock()

exporter_map = _Mock()

exporters = _Mock()

get_export_names = _Mock()

glob = _Mock()

import_item = _Mock()

launch_new_instance = _Mock()

logging = _Mock()

nbconvert_aliases = _Mock()

nbconvert_flags = _Mock()

os = _Mock()

postprocessors = _Mock()

preprocessors = _Mock()

print_function = _Mock()

sys = _Mock()

writers = _Mock()



class BaseIPythonApplication(_Mock):
  pass
  _in_init_profile_dir = False

class CaselessStrEnum(_Mock):
  pass
  info_text = 'any value'

class Configurable(_Mock):
  pass


class ConversionException(_Mock):
  pass


class DottedObjectName(_Mock):
  pass
  info_text = 'a valid object identifier in Python'

class DottedOrNone(_Mock):
  pass
  default_value = u''
  info_text = 'a valid object identifier in Python'

class Instance(_Mock):
  pass
  info_text = 'any value'

class List(_Mock):
  pass
  info_text = 'any value'

class NbConvertApp(_Mock):
  pass
  _in_init_profile_dir = False
  name = 'ipython-nbconvert'

class NbConvertBase(_Mock):
  pass


class ProfileDir(_Mock):
  pass


class Type(_Mock):
  pass
  info_text = 'any value'

class Unicode(_Mock):
  pass
  default_value = u''
  info_text = 'a unicode string'

