/*
 * QuteCom, a voice over Internet phone
 * Copyright (C) 2010 Mbdsys
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef OWWSSOFTUPDATE_H
#define OWWSSOFTUPDATE_H

#include <model/webservices/QuteComWebService.h>

/**
 * QuteCom update web service.
 *
 * Checks for the availability of QuteCom updates.
 *
 * @author Tanguy Krotoff
 */
class WsSoftUpdate : public QuteComWebService {
public:

	/**
	 * Default constructor.
	 *
	 * @param qutecomAccount the QuteComAccount used for web services
	 */
	WsSoftUpdate(QuteComAccount * qutecomAccount = 0);

	virtual ~WsSoftUpdate() {}

	/**
	 * Event QuteCom should be updated.
	 *
	 * @param sender this class
	 * @param downloadUrl QuteCom update download URL
	 * @param buildId QuteCom update build ID
	 * @param version QuteCom update version number
	 * @param fileSize QuteCom update file size in kil bytes
	 */
	Event<void (WsSoftUpdate & sender,
			const std::string & downloadUrl,
			unsigned long long buildId,
			const std::string & version,
			unsigned fileSize)> updateQuteComEvent;

	/**
	 * Checks if a QuteCom update is available.
	 */
	void checkForUpdate();

private:

	/**
	 * @see QuteComWebService
	 */
	void answerReceived(const std::string & answer, int id);
};

#endif //OWWSSOFTUPDATE_H
