%define OT_BasisSequenceFactory_doc
"Basis sequence factory.

Available constructors:
    BasisSequenceFactory(*basisSeqFacImp*)

Parameters
----------
basisSeqFacImp : a BasisSequenceFactoryImplementation

See also
--------
LARS

Notes
-----
BasisSequenceFactory is the interface of the BasisSequenceFactoryImplementation.
This class is not usable because it operates only within the
:class:`~openturns.FunctionalChaosAlgorithm`."
%enddef
%feature("docstring") OT::BasisSequenceFactoryImplementation
OT_BasisSequenceFactory_doc

// ---------------------------------------------------------------------

%define OT_BasisSequenceFactory_getMaximumRelativeConvergence_doc
"Accessor to the stopping criterion on the L1-norm of the coefficients.

Returns
-------
e : float
    Stopping criterion."
%enddef
%feature("docstring") OT::BasisSequenceFactoryImplementation::getMaximumRelativeConvergence
OT_BasisSequenceFactory_getMaximumRelativeConvergence_doc

// ---------------------------------------------------------------------

%define OT_BasisSequenceFactory_setMaximumRelativeConvergence_doc
"Accessor to the stopping criterion on the L1-norm of the coefficients.

Parameters
----------
e : float
    Stopping criterion."
%enddef
%feature("docstring") OT::BasisSequenceFactoryImplementation::setMaximumRelativeConvergence
OT_BasisSequenceFactory_setMaximumRelativeConvergence_doc

// ---------------------------------------------------------------------

%define OT_BasisSequenceFactory_build_doc
"Run the algorithm.

Parameters
----------
x : 2-d sequence of float
    Input sample
y : 2-d sequence of float
    Output sample
psi : sequence of :class:`~openturns.Function`
    Basis
indices : sequence of int
    Current indices of the basis

Returns
-------
measure : :class:`~openturns.BasisSequence`
    Fitting measure"
%enddef
%feature("docstring") OT::BasisSequenceFactoryImplementation::build
OT_BasisSequenceFactory_build_doc

