/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class StringUtils {
    public static final int PPKEY_CLASSNAME = 0;
    public static final int PPKEY_ID = 1;
    public static final int PPKEY_PROPERTY = 2;

    public static final String makeString(String foo) {
        return foo == null ? "" : foo.trim();
    }

    public static final boolean isValid(String foo) {
        return foo != null && foo.length() > 0;
    }

    public static final boolean isEmpty(String foo) {
        return foo == null || foo.trim().length() == 0;
    }

    public static final String stackTrace(Throwable e) {
        String foo = null;
        try {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            e.printStackTrace(new PrintWriter(buf, true));
            foo = buf.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return foo;
    }

    public static final String stackTrace(Throwable e, boolean addPre) {
        if (addPre) {
            return "<pre>" + StringUtils.stackTrace(e) + "</pre>";
        }
        return StringUtils.stackTrace(e);
    }

    public static boolean equals(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static String[] parseObjectKey(String s) {
        String[] p = new String[3];
        StringTokenizer st = new StringTokenizer(s, "[]");
        int count = st.countTokens();
        if (count > 1) {
            p[0] = st.nextToken();
            p[1] = st.nextToken();
            if (count == 3) {
                p[2] = st.nextToken();
            }
        }
        return p;
    }

    public static String removeUnderScores(String data) {
        String temp = null;
        StringBuffer out = new StringBuffer();
        temp = data;
        StringTokenizer st = new StringTokenizer(temp, "_");
        while (st.hasMoreTokens()) {
            String element = (String)st.nextElement();
            out.append(StringUtils.firstLetterCaps(element));
        }
        return out.toString();
    }

    public static String firstLetterCaps(String data) {
        StringBuffer sbuf = new StringBuffer(data.length());
        sbuf.append(data.substring(0, 1).toUpperCase()).append(data.substring(1));
        return sbuf.toString();
    }

    public static String[] split(String text, String separator) {
        StringTokenizer st = new StringTokenizer(text, separator);
        String[] values = new String[st.countTokens()];
        int pos = 0;
        while (st.hasMoreTokens()) {
            values[pos++] = st.nextToken();
        }
        return values;
    }

    public static String join(String[] list, String separator) {
        StringBuffer csv = new StringBuffer();
        int i = 0;
        while (i < list.length) {
            if (i > 0) {
                csv.append(separator);
            }
            csv.append(list[i]);
            ++i;
        }
        return csv.toString();
    }

    public static String wrapText(String inString, String newline, int wrapColumn) {
        StringTokenizer lineTokenizer = new StringTokenizer(inString, newline, true);
        StringBuffer stringBuffer = new StringBuffer();
        while (lineTokenizer.hasMoreTokens()) {
            try {
                String nextLine = lineTokenizer.nextToken();
                if (nextLine.length() > wrapColumn) {
                    nextLine = StringUtils.wrapLine(nextLine, newline, wrapColumn);
                }
                stringBuffer.append(nextLine);
            }
            catch (NoSuchElementException nsee) {
                break;
            }
        }
        return stringBuffer.toString();
    }

    protected static String wrapLine(String line, String newline, int wrapColumn) {
        StringBuffer wrappedLine = new StringBuffer();
        while (line.length() > wrapColumn) {
            int spaceToWrapAt = line.lastIndexOf(32, wrapColumn);
            if (spaceToWrapAt >= 0) {
                wrappedLine.append(line.substring(0, spaceToWrapAt));
                wrappedLine.append(newline);
                line = line.substring(spaceToWrapAt + 1);
                continue;
            }
            spaceToWrapAt = line.indexOf(32, wrapColumn);
            if (spaceToWrapAt >= 0) {
                wrappedLine.append(line.substring(0, spaceToWrapAt));
                wrappedLine.append(newline);
                line = line.substring(spaceToWrapAt + 1);
                continue;
            }
            wrappedLine.append(line);
            line = "";
        }
        wrappedLine.append(line);
        return wrappedLine.toString();
    }
}

