/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.io;
public class BaseEncodingTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.io.testModule";
}
public void testAtMostOneSeparator() throws Exception {
  com.google.common.io.BaseEncodingTest testCase = new com.google.common.io.BaseEncodingTest();
  testCase.testAtMostOneSeparator();
}

public void testBase16() throws Exception {
  com.google.common.io.BaseEncodingTest testCase = new com.google.common.io.BaseEncodingTest();
  testCase.testBase16();
}

public void testBase16InvalidDecodings() throws Exception {
  com.google.common.io.BaseEncodingTest testCase = new com.google.common.io.BaseEncodingTest();
  testCase.testBase16InvalidDecodings();
}

public void testBase16Offset() throws Exception {
  com.google.common.io.BaseEncodingTest testCase = new com.google.common.io.BaseEncodingTest();
  testCase.testBase16Offset();
}

public void testBase16UpperCaseIsNoOp() throws Exception {
  com.google.common.io.BaseEncodingTest testCase = new com.google.common.io.BaseEncodingTest();
  testCase.testBase16UpperCaseIsNoOp();
}

public void testBase32() throws Exception {
  com.google.common.io.BaseEncodingTest testCase = new com.google.common.io.BaseEncodingTest();
  testCase.testBase32();
}

public void testBase32AlternatePadding() throws Exception {
  com.google.common.io.BaseEncodingTest testCase = new com.google.common.io.BaseEncodingTest();
  testCase.testBase32AlternatePadding();
}

public void testBase32Hex() throws Exception {
  com.google.common.io.BaseEncodingTest testCase = new com.google.common.io.BaseEncodingTest();
  testCase.testBase32Hex();
}

public void testBase32HexInvalidDecodings() throws Exception {
  com.google.common.io.BaseEncodingTest testCase = new com.google.common.io.BaseEncodingTest();
  testCase.testBase32HexInvalidDecodings();
}

public void testBase32HexLenientPadding() throws Exception {
  com.google.common.io.BaseEncodingTest testCase = new com.google.common.io.BaseEncodingTest();
  testCase.testBase32HexLenientPadding();
}

public void testBase32HexUpperCaseIsNoOp() throws Exception {
  com.google.common.io.BaseEncodingTest testCase = new com.google.common.io.BaseEncodingTest();
  testCase.testBase32HexUpperCaseIsNoOp();
}

public void testBase32InvalidDecodings() throws Exception {
  com.google.common.io.BaseEncodingTest testCase = new com.google.common.io.BaseEncodingTest();
  testCase.testBase32InvalidDecodings();
}

public void testBase32LenientPadding() throws Exception {
  com.google.common.io.BaseEncodingTest testCase = new com.google.common.io.BaseEncodingTest();
  testCase.testBase32LenientPadding();
}

public void testBase32Offset() throws Exception {
  com.google.common.io.BaseEncodingTest testCase = new com.google.common.io.BaseEncodingTest();
  testCase.testBase32Offset();
}

public void testBase32UpperCaseIsNoOp() throws Exception {
  com.google.common.io.BaseEncodingTest testCase = new com.google.common.io.BaseEncodingTest();
  testCase.testBase32UpperCaseIsNoOp();
}

public void testBase64() throws Exception {
  com.google.common.io.BaseEncodingTest testCase = new com.google.common.io.BaseEncodingTest();
  testCase.testBase64();
}

public void testBase64AlternatePadding() throws Exception {
  com.google.common.io.BaseEncodingTest testCase = new com.google.common.io.BaseEncodingTest();
  testCase.testBase64AlternatePadding();
}

public void testBase64CannotLowerCase() throws Exception {
  com.google.common.io.BaseEncodingTest testCase = new com.google.common.io.BaseEncodingTest();
  testCase.testBase64CannotLowerCase();
}

public void testBase64CannotUpperCase() throws Exception {
  com.google.common.io.BaseEncodingTest testCase = new com.google.common.io.BaseEncodingTest();
  testCase.testBase64CannotUpperCase();
}

public void testBase64InvalidDecodings() throws Exception {
  com.google.common.io.BaseEncodingTest testCase = new com.google.common.io.BaseEncodingTest();
  testCase.testBase64InvalidDecodings();
}

public void testBase64LenientPadding() throws Exception {
  com.google.common.io.BaseEncodingTest testCase = new com.google.common.io.BaseEncodingTest();
  testCase.testBase64LenientPadding();
}

public void testBase64Offset() throws Exception {
  com.google.common.io.BaseEncodingTest testCase = new com.google.common.io.BaseEncodingTest();
  testCase.testBase64Offset();
}

public void testBase64OmitPadding() throws Exception {
  com.google.common.io.BaseEncodingTest testCase = new com.google.common.io.BaseEncodingTest();
  testCase.testBase64OmitPadding();
}

public void testBase64Url() throws Exception {
  com.google.common.io.BaseEncodingTest testCase = new com.google.common.io.BaseEncodingTest();
  testCase.testBase64Url();
}

public void testBase64UrlInvalidDecodings() throws Exception {
  com.google.common.io.BaseEncodingTest testCase = new com.google.common.io.BaseEncodingTest();
  testCase.testBase64UrlInvalidDecodings();
}

public void testSeparatorSameAsPadChar() throws Exception {
  com.google.common.io.BaseEncodingTest testCase = new com.google.common.io.BaseEncodingTest();
  testCase.testSeparatorSameAsPadChar();
}

public void testSeparatorsExplicitly() throws Exception {
  com.google.common.io.BaseEncodingTest testCase = new com.google.common.io.BaseEncodingTest();
  testCase.testSeparatorsExplicitly();
}

public void testToString() throws Exception {
  com.google.common.io.BaseEncodingTest testCase = new com.google.common.io.BaseEncodingTest();
  testCase.testToString();
}
}
