/* Main.c generated by valac 0.34.4, the Vala compiler
 * generated from Main.vala, do not modify */

/*
 * Copyright (C) 2008-2011 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <gee.h>
#include <stdarg.h>
#include <stdio.h>
#include <signal.h>
#include <gst/mpegts/mpegts.h>


#define DVB_TYPE_MANAGER (dvb_manager_get_type ())
#define DVB_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_MANAGER, DVBManager))
#define DVB_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_MANAGER, DVBManagerClass))
#define DVB_IS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_MANAGER))
#define DVB_IS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_MANAGER))
#define DVB_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_MANAGER, DVBManagerClass))

typedef struct _DVBManager DVBManager;
typedef struct _DVBManagerClass DVBManagerClass;

#define DVB_TYPE_RECORDINGS_STORE (dvb_recordings_store_get_type ())
#define DVB_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStore))
#define DVB_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))
#define DVB_IS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDINGS_STORE))
#define DVB_IS_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDINGS_STORE))
#define DVB_RECORDINGS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))

typedef struct _DVBRecordingsStore DVBRecordingsStore;
typedef struct _DVBRecordingsStoreClass DVBRecordingsStoreClass;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_TYPE_ID_BUS_MANAGER (dvb_id_bus_manager_get_type ())
#define DVB_ID_BUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_MANAGER, DVBIDBusManager))
#define DVB_IS_ID_BUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_MANAGER))
#define DVB_ID_BUS_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_MANAGER, DVBIDBusManagerIface))

typedef struct _DVBIDBusManager DVBIDBusManager;
typedef struct _DVBIDBusManagerIface DVBIDBusManagerIface;

#define DVB_TYPE_ID_BUS_MANAGER_PROXY (dvb_id_bus_manager_proxy_get_type ())

#define DVB_TYPE_ADAPTER_TYPE (dvb_adapter_type_get_type ())

#define DVB_TYPE_CHANNEL_GROUP_INFO (dvb_channel_group_info_get_type ())
typedef struct _DVBChannelGroupInfo DVBChannelGroupInfo;

#define DVB_TYPE_ADAPTER_INFO (dvb_adapter_info_get_type ())
typedef struct _DVBAdapterInfo DVBAdapterInfo;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DVB_TYPE_ID_BUS_RECORDINGS_STORE (dvb_id_bus_recordings_store_get_type ())
#define DVB_ID_BUS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_RECORDINGS_STORE, DVBIDBusRecordingsStore))
#define DVB_IS_ID_BUS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_RECORDINGS_STORE))
#define DVB_ID_BUS_RECORDINGS_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_RECORDINGS_STORE, DVBIDBusRecordingsStoreIface))

typedef struct _DVBIDBusRecordingsStore DVBIDBusRecordingsStore;
typedef struct _DVBIDBusRecordingsStoreIface DVBIDBusRecordingsStoreIface;

#define DVB_TYPE_ID_BUS_RECORDINGS_STORE_PROXY (dvb_id_bus_recordings_store_proxy_get_type ())

#define DVB_TYPE_RECORDING_INFO (dvb_recording_info_get_type ())
typedef struct _DVBRecordingInfo DVBRecordingInfo;

#define DVB_TYPE_FACTORY (dvb_factory_get_type ())
#define DVB_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_FACTORY, DVBFactory))
#define DVB_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_FACTORY, DVBFactoryClass))
#define DVB_IS_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_FACTORY))
#define DVB_IS_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_FACTORY))
#define DVB_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_FACTORY, DVBFactoryClass))

typedef struct _DVBFactory DVBFactory;
typedef struct _DVBFactoryClass DVBFactoryClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_DATABASE_TYPE_CONFIG_STORE (dvb_database_config_store_get_type ())
#define DVB_DATABASE_CONFIG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_CONFIG_STORE, DVBdatabaseConfigStore))
#define DVB_DATABASE_IS_CONFIG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_CONFIG_STORE))
#define DVB_DATABASE_CONFIG_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_CONFIG_STORE, DVBdatabaseConfigStoreIface))

typedef struct _DVBdatabaseConfigStore DVBdatabaseConfigStore;
typedef struct _DVBdatabaseConfigStoreIface DVBdatabaseConfigStoreIface;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;

#define DVB_TYPE_CHANNEL_GROUP (dvb_channel_group_get_type ())
#define DVB_CHANNEL_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroup))
#define DVB_CHANNEL_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroupClass))
#define DVB_IS_CHANNEL_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_GROUP))
#define DVB_IS_CHANNEL_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_GROUP))
#define DVB_CHANNEL_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroupClass))

typedef struct _DVBChannelGroup DVBChannelGroup;
typedef struct _DVBChannelGroupClass DVBChannelGroupClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DVB_TYPE_ID_BUS_DEVICE_GROUP (dvb_id_bus_device_group_get_type ())
#define DVB_ID_BUS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_DEVICE_GROUP, DVBIDBusDeviceGroup))
#define DVB_IS_ID_BUS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_DEVICE_GROUP))
#define DVB_ID_BUS_DEVICE_GROUP_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_DEVICE_GROUP, DVBIDBusDeviceGroupIface))

typedef struct _DVBIDBusDeviceGroup DVBIDBusDeviceGroup;
typedef struct _DVBIDBusDeviceGroupIface DVBIDBusDeviceGroupIface;

#define DVB_TYPE_ID_BUS_DEVICE_GROUP_PROXY (dvb_id_bus_device_group_proxy_get_type ())

#define DVB_LOGGING_TYPE_FILE_HANDLER (dvb_logging_file_handler_get_type ())
#define DVB_LOGGING_FILE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_FILE_HANDLER, DVBLoggingFileHandler))
#define DVB_LOGGING_FILE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_FILE_HANDLER, DVBLoggingFileHandlerClass))
#define DVB_LOGGING_IS_FILE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_FILE_HANDLER))
#define DVB_LOGGING_IS_FILE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_FILE_HANDLER))
#define DVB_LOGGING_FILE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_FILE_HANDLER, DVBLoggingFileHandlerClass))

typedef struct _DVBLoggingFileHandler DVBLoggingFileHandler;
typedef struct _DVBLoggingFileHandlerClass DVBLoggingFileHandlerClass;

#define DVB_LOGGING_TYPE_HANDLER (dvb_logging_handler_get_type ())
#define DVB_LOGGING_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_HANDLER, DVBLoggingHandler))
#define DVB_LOGGING_IS_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_HANDLER))
#define DVB_LOGGING_HANDLER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_LOGGING_TYPE_HANDLER, DVBLoggingHandlerIface))

typedef struct _DVBLoggingHandler DVBLoggingHandler;
typedef struct _DVBLoggingHandlerIface DVBLoggingHandlerIface;

#define DVB_LOGGING_TYPE_LOG_LEVEL (dvb_logging_log_level_get_type ())

#define DVB_LOGGING_TYPE_FORMATTER (dvb_logging_formatter_get_type ())
#define DVB_LOGGING_FORMATTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_FORMATTER, DVBLoggingFormatter))
#define DVB_LOGGING_IS_FORMATTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_FORMATTER))
#define DVB_LOGGING_FORMATTER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_LOGGING_TYPE_FORMATTER, DVBLoggingFormatterIface))

typedef struct _DVBLoggingFormatter DVBLoggingFormatter;
typedef struct _DVBLoggingFormatterIface DVBLoggingFormatterIface;

#define DVB_LOGGING_TYPE_CONSOLE_HANDLER (dvb_logging_console_handler_get_type ())
#define DVB_LOGGING_CONSOLE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_CONSOLE_HANDLER, DVBLoggingConsoleHandler))
#define DVB_LOGGING_CONSOLE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_CONSOLE_HANDLER, DVBLoggingConsoleHandlerClass))
#define DVB_LOGGING_IS_CONSOLE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_CONSOLE_HANDLER))
#define DVB_LOGGING_IS_CONSOLE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_CONSOLE_HANDLER))
#define DVB_LOGGING_CONSOLE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_CONSOLE_HANDLER, DVBLoggingConsoleHandlerClass))

typedef struct _DVBLoggingConsoleHandler DVBLoggingConsoleHandler;
typedef struct _DVBLoggingConsoleHandlerClass DVBLoggingConsoleHandlerClass;

#define DVB_LOGGING_TYPE_DEFAULT_FORMATTER (dvb_logging_default_formatter_get_type ())
#define DVB_LOGGING_DEFAULT_FORMATTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_DEFAULT_FORMATTER, DVBLoggingDefaultFormatter))
#define DVB_LOGGING_DEFAULT_FORMATTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_DEFAULT_FORMATTER, DVBLoggingDefaultFormatterClass))
#define DVB_LOGGING_IS_DEFAULT_FORMATTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_DEFAULT_FORMATTER))
#define DVB_LOGGING_IS_DEFAULT_FORMATTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_DEFAULT_FORMATTER))
#define DVB_LOGGING_DEFAULT_FORMATTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_DEFAULT_FORMATTER, DVBLoggingDefaultFormatterClass))

typedef struct _DVBLoggingDefaultFormatter DVBLoggingDefaultFormatter;
typedef struct _DVBLoggingDefaultFormatterClass DVBLoggingDefaultFormatterClass;

#define DVB_LOGGING_TYPE_COLOR_FORMATTER (dvb_logging_color_formatter_get_type ())
#define DVB_LOGGING_COLOR_FORMATTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_COLOR_FORMATTER, DVBLoggingColorFormatter))
#define DVB_LOGGING_COLOR_FORMATTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_COLOR_FORMATTER, DVBLoggingColorFormatterClass))
#define DVB_LOGGING_IS_COLOR_FORMATTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_COLOR_FORMATTER))
#define DVB_LOGGING_IS_COLOR_FORMATTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_COLOR_FORMATTER))
#define DVB_LOGGING_COLOR_FORMATTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_COLOR_FORMATTER, DVBLoggingColorFormatterClass))

typedef struct _DVBLoggingColorFormatter DVBLoggingColorFormatter;
typedef struct _DVBLoggingColorFormatterClass DVBLoggingColorFormatterClass;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))

typedef enum  {
	DVB_ADAPTER_TYPE_UNKNOWN,
	DVB_ADAPTER_TYPE_TERRESTRIAL,
	DVB_ADAPTER_TYPE_SATELLITE,
	DVB_ADAPTER_TYPE_CABLE
} DVBAdapterType;

struct _DVBChannelGroupInfo {
	gint id;
	gchar* name;
};

struct _DVBAdapterInfo {
	gchar* name;
	gboolean type_t;
	gboolean type_s;
	gboolean type_c;
};

struct _DVBIDBusManagerIface {
	GTypeInterface parent_iface;
	gboolean (*GetScannerForDevice) (DVBIDBusManager* self, guint adapter, guint frontend, DVBAdapterType type, char** opath, gchar** dbusiface, GError** error);
	char** (*GetRegisteredDeviceGroups) (DVBIDBusManager* self, int* result_length1, GError** error);
	gboolean (*GetDeviceGroup) (DVBIDBusManager* self, guint group_id, char** opath, GError** error);
	gboolean (*AddDeviceToNewGroup) (DVBIDBusManager* self, guint adapter, guint frontend, DVBAdapterType type, const gchar* channels_conf, const gchar* recordings_dir, const gchar* name, GError** error);
	gboolean (*GetNameOfRegisteredDevice) (DVBIDBusManager* self, guint adapter, guint frontend, gchar** name, GError** error);
	gint (*GetDeviceGroupSize) (DVBIDBusManager* self, GError** error);
	DVBChannelGroupInfo* (*GetChannelGroups) (DVBIDBusManager* self, int* result_length1, GError** error);
	gboolean (*AddChannelGroup) (DVBIDBusManager* self, const gchar* name, gint* channel_group_id, GError** error);
	gboolean (*RemoveChannelGroup) (DVBIDBusManager* self, gint channel_group_id, GError** error);
	GHashTable** (*GetDevices) (DVBIDBusManager* self, int* result_length1, GError** error);
	gboolean (*GetAdapterInfo) (DVBIDBusManager* self, guint adapter, guint frontend, DVBAdapterInfo* info, GError** error);
};

struct _DVBRecordingInfo {
	guint32 id;
	gchar* name;
	gchar* description;
	gint64 length;
	gint64 start_timestamp;
	gchar* channel;
	gchar* location;
};

struct _DVBIDBusRecordingsStoreIface {
	GTypeInterface parent_iface;
	guint32* (*GetRecordings) (DVBIDBusRecordingsStore* self, int* result_length1, GError** error);
	gboolean (*GetLocation) (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** location, GError** error);
	gboolean (*GetName) (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** name, GError** error);
	gboolean (*GetDescription) (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** description, GError** error);
	gboolean (*GetStartTime) (DVBIDBusRecordingsStore* self, guint32 rec_id, guint** start_time, int* start_time_length1, GError** error);
	gboolean (*GetStartTimestamp) (DVBIDBusRecordingsStore* self, guint32 rec_id, gint64* timestamp, GError** error);
	gboolean (*GetLength) (DVBIDBusRecordingsStore* self, guint32 rec_id, gint64* length, GError** error);
	gboolean (*Delete) (DVBIDBusRecordingsStore* self, guint32 rec_id, GError** error);
	gboolean (*GetChannelName) (DVBIDBusRecordingsStore* self, guint32 rec_id, gchar** name, GError** error);
	gboolean (*GetAllInformations) (DVBIDBusRecordingsStore* self, guint32 rec_id, DVBRecordingInfo* infos, GError** error);
};

typedef enum  {
	DVB_DATABASE_SQL_ERROR_ERROR,
	DVB_DATABASE_SQL_ERROR_INTERNAL,
	DVB_DATABASE_SQL_ERROR_PERM,
	DVB_DATABASE_SQL_ERROR_ABORT,
	DVB_DATABASE_SQL_ERROR_BUSY,
	DVB_DATABASE_SQL_ERROR_LOCKED,
	DVB_DATABASE_SQL_ERROR_NOMEM,
	DVB_DATABASE_SQL_ERROR_READONLY,
	DVB_DATABASE_SQL_ERROR_INTERRUPT,
	DVB_DATABASE_SQL_ERROR_IOERR,
	DVB_DATABASE_SQL_ERROR_CORRUPT,
	DVB_DATABASE_SQL_ERROR_NOTFOUND,
	DVB_DATABASE_SQL_ERROR_FULL,
	DVB_DATABASE_SQL_ERROR_CANTOPEN,
	DVB_DATABASE_SQL_ERROR_PROTOCOL,
	DVB_DATABASE_SQL_ERROR_EMPTY,
	DVB_DATABASE_SQL_ERROR_SCHEMA,
	DVB_DATABASE_SQL_ERROR_TOOBIG,
	DVB_DATABASE_SQL_ERROR_CONSTRAINT,
	DVB_DATABASE_SQL_ERROR_MISMATCH,
	DVB_DATABASE_SQL_ERROR_MISUSE,
	DVB_DATABASE_SQL_ERROR_NOLFS,
	DVB_DATABASE_SQL_ERROR_AUTH,
	DVB_DATABASE_SQL_ERROR_FORMAT,
	DVB_DATABASE_SQL_ERROR_RANGE,
	DVB_DATABASE_SQL_ERROR_NOTADB
} DVBdatabaseSqlError;
#define DVB_DATABASE_SQL_ERROR dvb_database_sql_error_quark ()
struct _DVBdatabaseConfigStoreIface {
	GTypeInterface parent_iface;
	GeeList* (*get_all_device_groups) (DVBdatabaseConfigStore* self, GError** error);
	DVBDeviceGroup* (*get_device_group) (DVBdatabaseConfigStore* self, guint group_id, GError** error);
	gboolean (*is_last_device) (DVBdatabaseConfigStore* self, guint group_id, GError** error);
	gboolean (*is_group_member) (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* group, GError** error);
	gboolean (*add_device_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* dev_group, GError** error);
	gboolean (*remove_device_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*add_device_to_group) (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*remove_device_from_group) (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*update_from_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*get_parent_groups) (DVBdatabaseConfigStore* self, guint adapter, guint frontend, guint** group_ids, int* group_ids_length1, GError** error);
	gboolean (*add_channel_group) (DVBdatabaseConfigStore* self, const gchar* name, gint* channel_group_id, GError** error);
	gboolean (*remove_channel_group) (DVBdatabaseConfigStore* self, gint group_id, GError** error);
	GeeList* (*get_channel_groups) (DVBdatabaseConfigStore* self, GError** error);
	GeeList* (*get_channels_of_group) (DVBdatabaseConfigStore* self, guint dev_group_id, gint channel_group_id, GError** error);
	gboolean (*add_channel_to_group) (DVBdatabaseConfigStore* self, DVBChannel* channel, gint group_id, GError** error);
	gboolean (*remove_channel_from_group) (DVBdatabaseConfigStore* self, DVBChannel* channel, gint group_id, GError** error);
};

struct _DVBIDBusDeviceGroupIface {
	GTypeInterface parent_iface;
	DVBAdapterType (*GetType) (DVBIDBusDeviceGroup* self, GError** error);
	char* (*GetRecorder) (DVBIDBusDeviceGroup* self, GError** error);
	gboolean (*AddDevice) (DVBIDBusDeviceGroup* self, guint adapter, guint frontend, GError** error);
	gboolean (*RemoveDevice) (DVBIDBusDeviceGroup* self, guint adapter, guint frontend, GError** error);
	char* (*GetChannelList) (DVBIDBusDeviceGroup* self, GError** error);
	gchar* (*GetName) (DVBIDBusDeviceGroup* self, GError** error);
	gboolean (*SetName) (DVBIDBusDeviceGroup* self, const gchar* name, GError** error);
	gchar** (*GetMembers) (DVBIDBusDeviceGroup* self, int* result_length1, GError** error);
	gboolean (*GetSchedule) (DVBIDBusDeviceGroup* self, guint channel_sid, char** opath, GError** error);
	gchar* (*GetRecordingsDirectory) (DVBIDBusDeviceGroup* self, GError** error);
	gboolean (*SetRecordingsDirectory) (DVBIDBusDeviceGroup* self, const gchar* location, GError** error);
};

typedef enum  {
	DVB_LOGGING_LOG_LEVEL_LOG,
	DVB_LOGGING_LOG_LEVEL_DEBUG,
	DVB_LOGGING_LOG_LEVEL_INFO,
	DVB_LOGGING_LOG_LEVEL_WARNING,
	DVB_LOGGING_LOG_LEVEL_ERROR
} DVBLoggingLogLevel;

struct _DVBLoggingFormatterIface {
	GTypeInterface parent_iface;
	gchar* (*format) (DVBLoggingFormatter* self, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format);
};

struct _DVBLoggingHandlerIface {
	GTypeInterface parent_iface;
	void (*publish) (DVBLoggingHandler* self, const gchar* logger_name, DVBLoggingLogLevel level, const gchar* format, va_list args);
	void (*close) (DVBLoggingHandler* self);
	DVBLoggingFormatter* (*get_formatter) (DVBLoggingHandler* self);
	void (*set_formatter) (DVBLoggingHandler* self, DVBLoggingFormatter* value);
	DVBLoggingLogLevel (*get_threshold) (DVBLoggingHandler* self);
	void (*set_threshold) (DVBLoggingHandler* self, DVBLoggingLogLevel value);
};


extern DVBManager* main_manager;
DVBManager* main_manager = NULL;
extern DVBRecordingsStore* main_recstore;
DVBRecordingsStore* main_recstore = NULL;
extern gboolean main_has_debug;
gboolean main_has_debug = FALSE;
extern gboolean main_has_version;
gboolean main_has_version = FALSE;
extern gboolean main_disable_epg_scanner;
gboolean main_disable_epg_scanner = FALSE;
extern gboolean main_disable_mediaserver;
gboolean main_disable_mediaserver = FALSE;
extern GMainLoop* main_mainloop;
GMainLoop* main_mainloop = NULL;
extern DVBLoggingLogger* main_log;
DVBLoggingLogger* main_log = NULL;
extern GDBusConnection* main_conn;
GDBusConnection* main_conn = NULL;

GType dvb_manager_get_type (void) G_GNUC_CONST;
GType dvb_recordings_store_get_type (void) G_GNUC_CONST;
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
void main_start_manager (void);
DVBManager* dvb_manager_get_instance (void);
void dvb_utils_dbus_own_name (const gchar* service_name, GBusAcquiredCallback cb, void* cb_target);
#define DVB_CONSTANTS_DBUS_SERVICE "org.gnome.DVB"
void main_on_bus_acquired (GDBusConnection* _conn);
static void _main_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self);
void dvb_utils_dbus_register_object (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GDBusConnection* conn, const gchar* object_path, gconstpointer obj);
#define DVB_CONSTANTS_DBUS_MANAGER_PATH "/org/gnome/DVB/Manager"
GType dvb_id_bus_manager_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_manager_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_adapter_type_get_type (void) G_GNUC_CONST;
GType dvb_channel_group_info_get_type (void) G_GNUC_CONST;
DVBChannelGroupInfo* dvb_channel_group_info_dup (const DVBChannelGroupInfo* self);
void dvb_channel_group_info_free (DVBChannelGroupInfo* self);
void dvb_channel_group_info_copy (const DVBChannelGroupInfo* self, DVBChannelGroupInfo* dest);
void dvb_channel_group_info_destroy (DVBChannelGroupInfo* self);
GType dvb_adapter_info_get_type (void) G_GNUC_CONST;
DVBAdapterInfo* dvb_adapter_info_dup (const DVBAdapterInfo* self);
void dvb_adapter_info_free (DVBAdapterInfo* self);
void dvb_adapter_info_copy (const DVBAdapterInfo* self, DVBAdapterInfo* dest);
void dvb_adapter_info_destroy (DVBAdapterInfo* self);
GType dvb_id_bus_manager_get_type (void) G_GNUC_CONST;
void main_restore_device_groups (void);
void main_start_recordings_store (void);
void dvb_logging_logger_info (DVBLoggingLogger* self, const gchar* format, ...);
DVBRecordingsStore* dvb_recordings_store_get_instance (void);
#define DVB_CONSTANTS_DBUS_RECORDINGS_STORE_PATH "/org/gnome/DVB/RecordingsStore"
GType dvb_id_bus_recordings_store_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_recordings_store_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_recording_info_get_type (void) G_GNUC_CONST;
DVBRecordingInfo* dvb_recording_info_dup (const DVBRecordingInfo* self);
void dvb_recording_info_free (DVBRecordingInfo* self);
void dvb_recording_info_copy (const DVBRecordingInfo* self, DVBRecordingInfo* dest);
void dvb_recording_info_destroy (DVBRecordingInfo* self);
GType dvb_id_bus_recordings_store_get_type (void) G_GNUC_CONST;
void main_on_exit (gint signum);
void dvb_rtsp_server_shutdown (void);
void dvb_manager_shutdown (void);
DVBFactory* dvb_factory_new (void);
DVBFactory* dvb_factory_construct (GType object_type);
GType dvb_factory_get_type (void) G_GNUC_CONST;
void dvb_factory_shutdown (DVBFactory* self);
void dvb_recordings_store_shutdown (void);
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
void dvb_logging_log_manager_cleanup (DVBLoggingLogManager* self);
gboolean main_get_disable_epg_scanner (void);
gboolean main_check_feature_version (const gchar* name, guint major, guint minor, guint micro);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
gboolean main_check_requirements (void);
GType dvb_device_group_get_type (void) G_GNUC_CONST;
GQuark dvb_database_sql_error_quark (void);
GType dvb_device_get_type (void) G_GNUC_CONST;
GType dvb_channel_group_get_type (void) G_GNUC_CONST;
GType dvb_channel_get_type (void) G_GNUC_CONST;
GType dvb_database_config_store_get_type (void) G_GNUC_CONST;
DVBdatabaseConfigStore* dvb_factory_get_config_store (DVBFactory* self);
GeeList* dvb_database_config_store_get_all_device_groups (DVBdatabaseConfigStore* self, GError** error);
GeeArrayList* dvb_manager_get_devs (DVBManager* self);
gboolean dvb_database_config_store_is_group_member (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* group, GError** error);
const gchar* dvb_device_get_DevFile (DVBDevice* self);
gboolean dvb_device_group_add (DVBDeviceGroup* self, DVBDevice* device);
GType dvb_id_bus_device_group_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_device_group_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_id_bus_device_group_get_type (void) G_GNUC_CONST;
guint dvb_device_get_Adapter (DVBDevice* self);
guint dvb_device_get_Frontend (DVBDevice* self);
void dvb_manager_restore_device_group_and_timers (DVBManager* self, DVBDeviceGroup* device_group);
guint dvb_device_group_get_Id (DVBDeviceGroup* self);
void dvb_device_group_start_epg_scanner (DVBDeviceGroup* self);
void main_configure_logging (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
GType dvb_logging_file_handler_get_type (void) G_GNUC_CONST;
DVBLoggingFileHandler* dvb_logging_file_handler_new (const gchar* file_pattern, GError** error);
DVBLoggingFileHandler* dvb_logging_file_handler_construct (GType object_type, const gchar* file_pattern, GError** error);
void dvb_logging_file_handler_set_limit (DVBLoggingFileHandler* self, gint value);
gint dvb_logging_file_handler_get_limit (DVBLoggingFileHandler* self);
GType dvb_logging_log_level_get_type (void) G_GNUC_CONST;
GType dvb_logging_formatter_get_type (void) G_GNUC_CONST;
GType dvb_logging_handler_get_type (void) G_GNUC_CONST;
void dvb_logging_handler_set_threshold (DVBLoggingHandler* self, DVBLoggingLogLevel value);
void dvb_logging_logger_addHandler (DVBLoggingLogger* self, DVBLoggingHandler* handler);
GType dvb_logging_console_handler_get_type (void) G_GNUC_CONST;
DVBLoggingConsoleHandler* dvb_logging_console_handler_new (void);
DVBLoggingConsoleHandler* dvb_logging_console_handler_construct (GType object_type);
DVBLoggingColorFormatter* dvb_logging_color_formatter_new (void);
DVBLoggingColorFormatter* dvb_logging_color_formatter_construct (GType object_type);
GType dvb_logging_default_formatter_get_type (void) G_GNUC_CONST;
GType dvb_logging_color_formatter_get_type (void) G_GNUC_CONST;
void dvb_logging_handler_set_formatter (DVBLoggingHandler* self, DVBLoggingFormatter* value);
gint main_main (gchar** args, int args_length1);
static void _main_on_exit_gsignal_handler_func (gint signum);
void dvb_rtsp_server_start (GAsyncReadyCallback _callback_, gpointer _user_data_);
void dvb_rtsp_server_start_finish (GAsyncResult* _res_);
void dvb_media_server2_start_rygel_services (GAsyncReadyCallback _callback_, gpointer _user_data_);
void dvb_media_server2_start_rygel_services_finish (GAsyncResult* _res_);

const GOptionEntry MAIN_options[5] = {{"debug", 'd', 0, G_OPTION_ARG_NONE, &main_has_debug, "Display debug statements on stdout", NULL}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &main_has_version, "Display version number", NULL}, {"disable-epg-scanner", (gchar) 0, 0, G_OPTION_ARG_NONE, &main_disable_epg_scanner, "Disable scanning for EPG data", NULL}, {"disable-mediaserver2", (gchar) 0, 0, G_OPTION_ARG_NONE, &main_disable_mediaserver, "Disable exporting devices and channels according to Rygel's MediaServe" \
"r2 specification", NULL}, {NULL}};

static void _main_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	main_on_bus_acquired (connection);
}


void main_start_manager (void) {
	DVBManager* _tmp0_ = NULL;
	_tmp0_ = dvb_manager_get_instance ();
	main_manager = _tmp0_;
	dvb_utils_dbus_own_name (DVB_CONSTANTS_DBUS_SERVICE, _main_on_bus_acquired_gbus_acquired_callback, NULL);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void main_on_bus_acquired (GDBusConnection* _conn) {
	GDBusConnection* _tmp0_ = NULL;
	DVBManager* _tmp1_ = NULL;
	GDBusConnection* _tmp2_ = NULL;
	GDBusConnection* _tmp3_ = NULL;
	g_return_if_fail (_conn != NULL);
	_tmp0_ = _conn;
	_tmp1_ = main_manager;
	dvb_utils_dbus_register_object (DVB_TYPE_ID_BUS_MANAGER, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp0_, DVB_CONSTANTS_DBUS_MANAGER_PATH, (DVBIDBusManager*) _tmp1_);
	_tmp2_ = _conn;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (main_conn);
	main_conn = _tmp3_;
	main_restore_device_groups ();
	main_start_recordings_store ();
}


void main_start_recordings_store (void) {
	DVBLoggingLogger* _tmp0_ = NULL;
	DVBRecordingsStore* _tmp1_ = NULL;
	DVBRecordingsStore* _tmp2_ = NULL;
	GDBusConnection* _tmp3_ = NULL;
	DVBRecordingsStore* _tmp4_ = NULL;
	_tmp0_ = main_log;
	dvb_logging_logger_info (_tmp0_, "Main.vala:64: Creating new RecordingsStore D-Bus service");
	_tmp1_ = dvb_recordings_store_get_instance ();
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (main_recstore);
	main_recstore = _tmp2_;
	_tmp3_ = main_conn;
	_tmp4_ = main_recstore;
	dvb_utils_dbus_register_object (DVB_TYPE_ID_BUS_RECORDINGS_STORE, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp3_, DVB_CONSTANTS_DBUS_RECORDINGS_STORE_PATH, (DVBIDBusRecordingsStore*) _tmp4_);
}


void main_on_exit (gint signum) {
	DVBLoggingLogger* _tmp0_ = NULL;
	DVBFactory* _tmp1_ = NULL;
	DVBFactory* _tmp2_ = NULL;
	DVBLoggingLogManager* _tmp3_ = NULL;
	GMainLoop* _tmp4_ = NULL;
	_tmp0_ = main_log;
	dvb_logging_logger_info (_tmp0_, "Main.vala:72: Exiting");
	dvb_rtsp_server_shutdown ();
	dvb_manager_shutdown ();
	_tmp1_ = dvb_factory_new ();
	_tmp2_ = _tmp1_;
	dvb_factory_shutdown (_tmp2_);
	_g_object_unref0 (_tmp2_);
	dvb_recordings_store_shutdown ();
	_tmp3_ = dvb_logging_log_manager_getLogManager ();
	dvb_logging_log_manager_cleanup (_tmp3_);
	_g_object_unref0 (main_recstore);
	main_recstore = NULL;
	main_manager = NULL;
	_tmp4_ = main_mainloop;
	g_main_loop_quit (_tmp4_);
}


gboolean main_get_disable_epg_scanner (void) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	_tmp0_ = main_disable_epg_scanner;
	result = _tmp0_;
	return result;
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_ = NULL;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


gboolean main_check_feature_version (const gchar* name, guint major, guint minor, guint micro) {
	gboolean result = FALSE;
	GstRegistry* reg = NULL;
	GstRegistry* _tmp0_ = NULL;
	GstRegistry* _tmp1_ = NULL;
	GstPluginFeature* feature = NULL;
	GstRegistry* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GstPluginFeature* _tmp4_ = NULL;
	gboolean ret = FALSE;
	GstPluginFeature* _tmp5_ = NULL;
	DVBLoggingLogger* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	guint _tmp13_ = 0U;
	guint _tmp14_ = 0U;
	guint _tmp15_ = 0U;
	gboolean _tmp16_ = FALSE;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = gst_registry_get ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	reg = _tmp1_;
	_tmp2_ = reg;
	_tmp3_ = name;
	_tmp4_ = gst_registry_lookup_feature (_tmp2_, _tmp3_);
	feature = _tmp4_;
	_tmp5_ = feature;
	if (_tmp5_ == NULL) {
		ret = FALSE;
	} else {
		GstPluginFeature* _tmp6_ = NULL;
		guint _tmp7_ = 0U;
		guint _tmp8_ = 0U;
		guint _tmp9_ = 0U;
		gboolean _tmp10_ = FALSE;
		_tmp6_ = feature;
		_tmp7_ = major;
		_tmp8_ = minor;
		_tmp9_ = micro;
		_tmp10_ = gst_plugin_feature_check_version (_tmp6_, _tmp7_, _tmp8_, _tmp9_);
		ret = _tmp10_;
	}
	_tmp11_ = main_log;
	_tmp12_ = name;
	_tmp13_ = major;
	_tmp14_ = minor;
	_tmp15_ = micro;
	_tmp16_ = ret;
	_tmp17_ = bool_to_string (_tmp16_);
	_tmp18_ = _tmp17_;
	dvb_logging_logger_debug (_tmp11_, "Main.vala:99: Has %s >= %u.%u.%u: %s", _tmp12_, _tmp13_, _tmp14_, _tmp15_, _tmp18_);
	_g_free0 (_tmp18_);
	result = ret;
	_g_object_unref0 (feature);
	_g_object_unref0 (reg);
	return result;
}


gboolean main_check_requirements (void) {
	gboolean result = FALSE;
	gboolean val = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	_tmp0_ = main_check_feature_version ("dvbsrc", (guint) 1, (guint) 3, (guint) 1);
	val = _tmp0_;
	_tmp1_ = val;
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = main_check_feature_version ("dvbbasebin", (guint) 1, (guint) 3, (guint) 1);
	val = _tmp2_;
	_tmp3_ = val;
	if (!_tmp3_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = main_check_feature_version ("tsparse", (guint) 1, (guint) 3, (guint) 1);
	val = _tmp4_;
	_tmp5_ = val;
	if (!_tmp5_) {
		result = FALSE;
		return result;
	}
	_tmp6_ = main_check_feature_version ("rtpmp2tpay", (guint) 1, (guint) 3, (guint) 1);
	val = _tmp6_;
	result = val;
	return result;
}


void main_restore_device_groups (void) {
	DVBdatabaseConfigStore* config_store = NULL;
	DVBFactory* _tmp0_ = NULL;
	DVBFactory* _tmp1_ = NULL;
	DVBdatabaseConfigStore* _tmp2_ = NULL;
	DVBdatabaseConfigStore* _tmp3_ = NULL;
	GeeList* device_groups = NULL;
	guint max_group_id = 0U;
	DVBLoggingLogger* _tmp10_ = NULL;
	GeeList* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	GError * _inner_error_ = NULL;
	_tmp0_ = dvb_factory_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = dvb_factory_get_config_store (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	config_store = _tmp3_;
	{
		GeeList* _tmp4_ = NULL;
		DVBdatabaseConfigStore* _tmp5_ = NULL;
		GeeList* _tmp6_ = NULL;
		GeeList* _tmp7_ = NULL;
		_tmp5_ = config_store;
		_tmp6_ = dvb_database_config_store_get_all_device_groups (_tmp5_, &_inner_error_);
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch80_dvb_database_sql_error;
			}
			_g_object_unref0 (device_groups);
			_g_object_unref0 (config_store);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp7_ = _tmp4_;
		_tmp4_ = NULL;
		_g_object_unref0 (device_groups);
		device_groups = _tmp7_;
		_g_object_unref0 (_tmp4_);
	}
	goto __finally80;
	__catch80_dvb_database_sql_error:
	{
		GError* e = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_critical ("Main.vala:125: %s", _tmp9_);
		_g_error_free0 (e);
		_g_object_unref0 (device_groups);
		_g_object_unref0 (config_store);
		return;
	}
	__finally80:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (device_groups);
		_g_object_unref0 (config_store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	max_group_id = (guint) 0;
	_tmp10_ = main_log;
	_tmp11_ = device_groups;
	_tmp12_ = gee_collection_get_size ((GeeCollection*) _tmp11_);
	_tmp13_ = _tmp12_;
	dvb_logging_logger_info (_tmp10_, "Main.vala:130: Restoring %d device groups", _tmp13_);
	{
		GeeList* _device_group_list = NULL;
		GeeList* _tmp14_ = NULL;
		GeeList* _tmp15_ = NULL;
		gint _device_group_size = 0;
		GeeList* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		gint _device_group_index = 0;
		_tmp14_ = device_groups;
		_tmp15_ = _g_object_ref0 (_tmp14_);
		_device_group_list = _tmp15_;
		_tmp16_ = _device_group_list;
		_tmp17_ = gee_collection_get_size ((GeeCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_device_group_size = _tmp18_;
		_device_group_index = -1;
		while (TRUE) {
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			DVBDeviceGroup* device_group = NULL;
			GeeList* _tmp22_ = NULL;
			gint _tmp23_ = 0;
			gpointer _tmp24_ = NULL;
			DVBManager* _tmp60_ = NULL;
			DVBDeviceGroup* _tmp61_ = NULL;
			DVBDeviceGroup* _tmp62_ = NULL;
			guint _tmp63_ = 0U;
			guint _tmp64_ = 0U;
			guint _tmp65_ = 0U;
			DVBDeviceGroup* _tmp69_ = NULL;
			_tmp19_ = _device_group_index;
			_device_group_index = _tmp19_ + 1;
			_tmp20_ = _device_group_index;
			_tmp21_ = _device_group_size;
			if (!(_tmp20_ < _tmp21_)) {
				break;
			}
			_tmp22_ = _device_group_list;
			_tmp23_ = _device_group_index;
			_tmp24_ = gee_list_get (_tmp22_, _tmp23_);
			device_group = (DVBDeviceGroup*) _tmp24_;
			{
				GeeArrayList* _dev_list = NULL;
				DVBManager* _tmp25_ = NULL;
				GeeArrayList* _tmp26_ = NULL;
				GeeArrayList* _tmp27_ = NULL;
				GeeArrayList* _tmp28_ = NULL;
				gint _dev_size = 0;
				GeeArrayList* _tmp29_ = NULL;
				gint _tmp30_ = 0;
				gint _tmp31_ = 0;
				gint _dev_index = 0;
				_tmp25_ = main_manager;
				_tmp26_ = dvb_manager_get_devs (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = _g_object_ref0 (_tmp27_);
				_dev_list = _tmp28_;
				_tmp29_ = _dev_list;
				_tmp30_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp29_);
				_tmp31_ = _tmp30_;
				_dev_size = _tmp31_;
				_dev_index = -1;
				while (TRUE) {
					gint _tmp32_ = 0;
					gint _tmp33_ = 0;
					gint _tmp34_ = 0;
					DVBDevice* dev = NULL;
					GeeArrayList* _tmp35_ = NULL;
					gint _tmp36_ = 0;
					gpointer _tmp37_ = NULL;
					DVBLoggingLogger* _tmp38_ = NULL;
					_tmp32_ = _dev_index;
					_dev_index = _tmp32_ + 1;
					_tmp33_ = _dev_index;
					_tmp34_ = _dev_size;
					if (!(_tmp33_ < _tmp34_)) {
						break;
					}
					_tmp35_ = _dev_list;
					_tmp36_ = _dev_index;
					_tmp37_ = gee_abstract_list_get ((GeeAbstractList*) _tmp35_, _tmp36_);
					dev = (DVBDevice*) _tmp37_;
					_tmp38_ = main_log;
					dvb_logging_logger_debug (_tmp38_, "Main.vala:134: restoring device");
					{
						gboolean _tmp39_ = FALSE;
						DVBdatabaseConfigStore* _tmp40_ = NULL;
						DVBDevice* _tmp41_ = NULL;
						DVBDeviceGroup* _tmp42_ = NULL;
						gboolean _tmp43_ = FALSE;
						_tmp40_ = config_store;
						_tmp41_ = dev;
						_tmp42_ = device_group;
						_tmp43_ = dvb_database_config_store_is_group_member (_tmp40_, _tmp41_, _tmp42_, &_inner_error_);
						_tmp39_ = _tmp43_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
								goto __catch81_dvb_database_sql_error;
							}
							_g_object_unref0 (dev);
							_g_object_unref0 (_dev_list);
							_g_object_unref0 (device_group);
							_g_object_unref0 (_device_group_list);
							_g_object_unref0 (device_groups);
							_g_object_unref0 (config_store);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						if (_tmp39_) {
							DVBLoggingLogger* _tmp44_ = NULL;
							DVBDevice* _tmp45_ = NULL;
							const gchar* _tmp46_ = NULL;
							const gchar* _tmp47_ = NULL;
							DVBDeviceGroup* _tmp48_ = NULL;
							DVBDevice* _tmp49_ = NULL;
							gboolean _tmp50_ = FALSE;
							_tmp44_ = main_log;
							_tmp45_ = dev;
							_tmp46_ = dvb_device_get_DevFile (_tmp45_);
							_tmp47_ = _tmp46_;
							dvb_logging_logger_debug (_tmp44_, "Main.vala:137: add device %s", _tmp47_);
							_tmp48_ = device_group;
							_tmp49_ = dev;
							_tmp50_ = dvb_device_group_add (_tmp48_, _tmp49_);
							if (_tmp50_) {
								DVBDeviceGroup* _tmp51_ = NULL;
								DVBDevice* _tmp52_ = NULL;
								guint _tmp53_ = 0U;
								guint _tmp54_ = 0U;
								DVBDevice* _tmp55_ = NULL;
								guint _tmp56_ = 0U;
								guint _tmp57_ = 0U;
								_tmp51_ = device_group;
								_tmp52_ = dev;
								_tmp53_ = dvb_device_get_Adapter (_tmp52_);
								_tmp54_ = _tmp53_;
								_tmp55_ = dev;
								_tmp56_ = dvb_device_get_Frontend (_tmp55_);
								_tmp57_ = _tmp56_;
								g_signal_emit_by_name ((DVBIDBusDeviceGroup*) _tmp51_, "device-added", _tmp54_, _tmp57_);
							}
						}
					}
					goto __finally81;
					__catch81_dvb_database_sql_error:
					{
						GError* e = NULL;
						GError* _tmp58_ = NULL;
						const gchar* _tmp59_ = NULL;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp58_ = e;
						_tmp59_ = _tmp58_->message;
						g_warning ("Main.vala:142: %s", _tmp59_);
						_g_error_free0 (e);
					}
					__finally81:
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_object_unref0 (dev);
						_g_object_unref0 (_dev_list);
						_g_object_unref0 (device_group);
						_g_object_unref0 (_device_group_list);
						_g_object_unref0 (device_groups);
						_g_object_unref0 (config_store);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_g_object_unref0 (dev);
				}
				_g_object_unref0 (_dev_list);
			}
			_tmp60_ = main_manager;
			_tmp61_ = device_group;
			dvb_manager_restore_device_group_and_timers (_tmp60_, _tmp61_);
			_tmp62_ = device_group;
			_tmp63_ = dvb_device_group_get_Id (_tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = max_group_id;
			if (_tmp64_ > _tmp65_) {
				DVBDeviceGroup* _tmp66_ = NULL;
				guint _tmp67_ = 0U;
				guint _tmp68_ = 0U;
				_tmp66_ = device_group;
				_tmp67_ = dvb_device_group_get_Id (_tmp66_);
				_tmp68_ = _tmp67_;
				max_group_id = _tmp68_;
			}
			_tmp69_ = device_group;
			dvb_device_group_start_epg_scanner (_tmp69_);
			_g_object_unref0 (device_group);
		}
		_g_object_unref0 (_device_group_list);
	}
	_g_object_unref0 (device_groups);
	_g_object_unref0 (config_store);
}


void main_configure_logging (void) {
	DVBLoggingLogManager* manager = NULL;
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogManager* _tmp1_ = NULL;
	DVBLoggingLogger* _tmp2_ = NULL;
	GFile* cache_dir = NULL;
	const gchar* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GFile* our_cache = NULL;
	GFile* _tmp5_ = NULL;
	GFile* log_file = NULL;
	GFile* _tmp6_ = NULL;
	DVBLoggingConsoleHandler* chandler = NULL;
	DVBLoggingConsoleHandler* _tmp18_ = NULL;
	DVBLoggingConsoleHandler* _tmp19_ = NULL;
	DVBLoggingColorFormatter* _tmp20_ = NULL;
	DVBLoggingColorFormatter* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	DVBLoggingLogger* _tmp24_ = NULL;
	DVBLoggingConsoleHandler* _tmp25_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	manager = _tmp1_;
	_tmp2_ = dvb_logging_log_manager_getDefaultLogger (manager);
	_g_object_unref0 (main_log);
	main_log = _tmp2_;
	_tmp3_ = g_get_user_cache_dir ();
	_tmp4_ = g_file_new_for_path (_tmp3_);
	cache_dir = _tmp4_;
	_tmp5_ = g_file_get_child (cache_dir, "gnome-dvb-daemon");
	our_cache = _tmp5_;
	_tmp6_ = g_file_get_child (our_cache, "debug%d.log");
	log_file = _tmp6_;
	{
		DVBLoggingFileHandler* fhandler = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		DVBLoggingFileHandler* _tmp9_ = NULL;
		DVBLoggingFileHandler* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		DVBLoggingLogger* _tmp14_ = NULL;
		_tmp7_ = g_file_get_path (log_file);
		_tmp8_ = _tmp7_;
		_tmp9_ = dvb_logging_file_handler_new (_tmp8_, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		fhandler = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch82_g_error;
		}
		dvb_logging_file_handler_set_limit (fhandler, 1024 * 1024);
		_tmp11_ = main_has_debug;
		if (_tmp11_) {
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			_tmp12_ = dvb_logging_file_handler_get_limit (fhandler);
			_tmp13_ = _tmp12_;
			dvb_logging_file_handler_set_limit (fhandler, _tmp13_ * 5);
		} else {
			dvb_logging_handler_set_threshold ((DVBLoggingHandler*) fhandler, DVB_LOGGING_LOG_LEVEL_WARNING);
		}
		_tmp14_ = main_log;
		dvb_logging_logger_addHandler (_tmp14_, (DVBLoggingHandler*) fhandler);
		_g_object_unref0 (fhandler);
	}
	goto __finally82;
	__catch82_g_error:
	{
		GError* e = NULL;
		FILE* _tmp15_ = NULL;
		GError* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = stderr;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		fprintf (_tmp15_, "*** Failed creating DVB.Logging.FileHandler: %s\n", _tmp17_);
		_g_error_free0 (e);
	}
	__finally82:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (log_file);
		_g_object_unref0 (our_cache);
		_g_object_unref0 (cache_dir);
		_g_object_unref0 (manager);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp18_ = dvb_logging_console_handler_new ();
	chandler = _tmp18_;
	_tmp19_ = chandler;
	_tmp20_ = dvb_logging_color_formatter_new ();
	_tmp21_ = _tmp20_;
	dvb_logging_handler_set_formatter ((DVBLoggingHandler*) _tmp19_, (DVBLoggingFormatter*) _tmp21_);
	_g_object_unref0 (_tmp21_);
	_tmp22_ = main_has_debug;
	if (!_tmp22_) {
		DVBLoggingConsoleHandler* _tmp23_ = NULL;
		_tmp23_ = chandler;
		dvb_logging_handler_set_threshold ((DVBLoggingHandler*) _tmp23_, DVB_LOGGING_LOG_LEVEL_ERROR);
	}
	_tmp24_ = main_log;
	_tmp25_ = chandler;
	dvb_logging_logger_addHandler (_tmp24_, (DVBLoggingHandler*) _tmp25_);
	_g_object_unref0 (chandler);
	_g_object_unref0 (log_file);
	_g_object_unref0 (our_cache);
	_g_object_unref0 (cache_dir);
	_g_object_unref0 (manager);
}


static void _main_on_exit_gsignal_handler_func (gint signum) {
	main_on_exit (signum);
}


gint main_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* context = NULL;
	GOptionContext* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	GOptionContext* _tmp2_ = NULL;
	GOptionGroup* _tmp3_ = NULL;
	gboolean _tmp11_ = FALSE;
	GMainLoop* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp18_ = FALSE;
	GMainLoop* _tmp19_ = NULL;
	GError * _inner_error_ = NULL;
	g_setenv ("TZ", "/etc/localtime", FALSE);
	signal (SIGINT, _main_on_exit_gsignal_handler_func);
	signal (SIGTERM, _main_on_exit_gsignal_handler_func);
	_tmp0_ = g_option_context_new ("- record and watch TV shows using one or more DVB adapters");
	context = _tmp0_;
	_tmp1_ = context;
	g_option_context_add_main_entries (_tmp1_, MAIN_options, NULL);
	_tmp2_ = context;
	_tmp3_ = gst_init_get_option_group ();
	g_option_context_add_group (_tmp2_, _tmp3_);
	{
		GOptionContext* _tmp4_ = NULL;
		_tmp4_ = context;
		g_option_context_parse (_tmp4_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch83_g_option_error;
			}
			_g_option_context_free0 (context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	goto __finally83;
	__catch83_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		FILE* _tmp8_ = NULL;
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		const gchar* _tmp10_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = stderr;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp5_, "%s\n", _tmp7_);
		_tmp8_ = stderr;
		_tmp9_ = args;
		_tmp9__length1 = args_length1;
		_tmp10_ = _tmp9_[0];
		fprintf (_tmp8_, "Run '%s --help' to see a full list of available command line options.\n", _tmp10_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		return result;
	}
	__finally83:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp11_ = main_has_version;
	if (_tmp11_) {
		FILE* _tmp12_ = NULL;
		FILE* _tmp13_ = NULL;
		_tmp12_ = stdout;
		fprintf (_tmp12_, "%s", PACKAGE_NAME);
		_tmp13_ = stdout;
		fprintf (_tmp13_, " %s\n", PACKAGE_VERSION);
		result = 0;
		_g_option_context_free0 (context);
		return result;
	}
	_tmp14_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (main_mainloop);
	main_mainloop = _tmp14_;
	gst_init (&args_length1, &args);
	gst_mpegts_initialize ();
	main_configure_logging ();
	_tmp15_ = main_check_requirements ();
	if (!_tmp15_) {
		FILE* _tmp16_ = NULL;
		FILE* _tmp17_ = NULL;
		_tmp16_ = stderr;
		fprintf (_tmp16_, "You don't have all of the necessary requirements to run %s.\n", PACKAGE_NAME);
		_tmp17_ = stderr;
		fprintf (_tmp17_, "Start the daemon with the --debug flag for more details.\n");
		result = -1;
		_g_option_context_free0 (context);
		return result;
	}
	main_start_manager ();
	dvb_rtsp_server_start (NULL, NULL);
	_tmp18_ = main_disable_mediaserver;
	if (!_tmp18_) {
		dvb_media_server2_start_rygel_services (NULL, NULL);
	}
	_tmp19_ = main_mainloop;
	g_main_loop_run (_tmp19_);
	result = 0;
	_g_option_context_free0 (context);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return main_main (argv, argc);
}



