#include "FuseCreateAndOpenTest.h"

using cpputils::unique_ref;
using cpputils::make_unique_ref;

void FuseCreateAndOpenTest::CreateAndOpenFile(const std::string &filename, int flags) {
    auto fs = TestFS();

    auto fd = CreateAndOpenFileAllowErrors(fs.get(), filename, flags);
    EXPECT_GE(fd->fd(), 0) << "Opening file failed";
}

int FuseCreateAndOpenTest::CreateAndOpenFileReturnError(const std::string &filename, int flags) {
    auto fs = TestFS();

    auto fd = CreateAndOpenFileAllowErrors(fs.get(), filename, flags);
    return fd->errorcode();
}

unique_ref<OpenFileHandle> FuseCreateAndOpenTest::CreateAndOpenFileAllowErrors(const TempTestFS *fs, const std::string &filename, int flags) {
    auto real_path = fs->mountDir() / filename;
    auto fd = make_unique_ref<OpenFileHandle>(real_path.string().c_str(), flags | O_CREAT, S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH);
    return fd;
}
