# -*- coding: utf-8 -*-
#############################################
#  Rafael Proença     <cypherbios@ubuntu.com>
#  Laudeci Oliveira    <laudeci@gmail.com>
#
#  Copyright 2006 APTonCD DevTeam.
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published
#  by the Free Software Foundation; version 2 only.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#############################################
import gtk

from APTonCD.core import gui
from APTonCD.core import constants
from APTonCD.core.package import DebPackage

WINDOW_NAME = 'pkgProperties'

class PackagePropety:
    """
        Class to show a property info from selected package
    """
    def __init__(self, package, controller = None, pixbuf = None):
        """
            Constructor
        """
        self.glade = gui.get_glade(constants.PROPERTY_GUI, WINDOW_NAME)        
        self.package = package
        
        self.window = gui.get_widget(self.glade, WINDOW_NAME)
        self.window.set_title(" %s " % self.package.package + constants.MESSAGE_0072)
        
        if controller:
            self.window.set_transient_for(controller.get_main_window())
        
        self.pixbuf = pixbuf
        self.create_ui()
        
       
    def create_ui(self):
        """
            Setup the user interface.
        """
        gui.get_widget(self.glade, 'lblPackage').set_text(self.package.package)
        gui.get_widget(self.glade, 'lblVersion').set_text(self.package.version)
        
        # FIXME: Use this method to show the lblStatus
        # for a more verbose and elegant label
        #compare = DebPackage()
        #status = compare.compare_version(self.package.version)
        #print status
        #if status == 0:
        #	gui.get_widget(self.glade, 'lblStatus').set_text("This package is the same as the installed")
        #elif status < 0:
        #	gui.get_widget(self.glade, 'lblStatus').set_text("An older version is installed")
        #elif status > 0:
        #	gui.get_widget(self.glade, 'lblStatus').set_text("A later version is already installed")
        #else:
        #	gui.get_widget(self.glade, 'lblStatus').set_text("This package is not installed")
        
       	if self.package.installed == True:
        	gui.get_widget(self.glade, 'lblStatus').set_text(constants.MESSAGE_0058)
        else:
        	gui.get_widget(self.glade, 'lblStatus').set_text(constants.MESSAGE_0059)
        	
        gui.get_widget(self.glade, 'lblFilename').set_text(self.package.deb_filename)
        gui.get_widget(self.glade, 'lblSize').set_text(self.package.size_text)
        
        if self.package.custom == True:
        	gui.get_widget(self.glade, 'lblCustom').set_text(constants.MESSAGE_0060)
        else:
        	gui.get_widget(self.glade, 'lblCustom').set_text(constants.MESSAGE_0061)
        
        gui.get_widget(self.glade, 'lblDescription').set_text(self.package.short_description)
        
        textview = gui.get_widget(self.glade, 'txtvwDesc').get_buffer()
        textview.set_text(self.package.long_description)
        
        if self.pixbuf:
            gui.get_widget(self.glade, 'imgPackage').set_from_pixbuf(self.pixbuf)
        gui.get_widget(self.glade,'button1').connect('clicked', self.on_click)

    def on_click(self, widget):
        self.window.destroy()
        
    def show(self):
        """
            Show the window
        """
        self.window.run()
