#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2025 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Prim
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250927.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='prim'
GAME_NAME='PRIM'

ARCHIVE_BASE_1_NAME='prim_1_4_32_85305.sh'
ARCHIVE_BASE_1_MD5='8ef4c6324e694cd73b7183c0bb3c5d3b'
ARCHIVE_BASE_1_SIZE='1097978'
ARCHIVE_BASE_1_VERSION='1.4.32-gog85305'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/prim'

ARCHIVE_BASE_0_NAME='prim_1_1_18_78616.sh'
ARCHIVE_BASE_0_MD5='c8e37c77a417e00583cc5d5142ebb03c'
ARCHIVE_BASE_0_SIZE='1083289'
ARCHIVE_BASE_0_VERSION='1.1.18-gog78616'

UNITY3D_NAME='PRIM'

CONTENT_PATH_DEFAULT='data/noarch/game'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libpthread.so.0
librt.so.1
libz.so.1'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialization actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default
## Prevent inclusion of Steam libraries.
rm --recursive "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/$(unity3d_name)_Data/Plugins"

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

launchers_generation 'PKG_BIN'

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
