/* sudoku-view.c generated by valac 0.39.92.14-46f76, the Vala compiler
 * generated from sudoku-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include "libsudoku.h"
#include <gdk/gdk.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <pango/pangocairo.h>
#include <glib/gi18n-lib.h>


#define TYPE_SUDOKU_CELL_VIEW (sudoku_cell_view_get_type ())
#define SUDOKU_CELL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_CELL_VIEW, SudokuCellView))
#define SUDOKU_CELL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_CELL_VIEW, SudokuCellViewClass))
#define IS_SUDOKU_CELL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_CELL_VIEW))
#define IS_SUDOKU_CELL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_CELL_VIEW))
#define SUDOKU_CELL_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_CELL_VIEW, SudokuCellViewClass))

typedef struct _SudokuCellView SudokuCellView;
typedef struct _SudokuCellViewClass SudokuCellViewClass;
typedef struct _SudokuCellViewPrivate SudokuCellViewPrivate;

#define TYPE_NUMBER_PICKER (number_picker_get_type ())
#define NUMBER_PICKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER_PICKER, NumberPicker))
#define NUMBER_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER_PICKER, NumberPickerClass))
#define IS_NUMBER_PICKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER_PICKER))
#define IS_NUMBER_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER_PICKER))
#define NUMBER_PICKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER_PICKER, NumberPickerClass))

typedef struct _NumberPicker NumberPicker;
typedef struct _NumberPickerClass NumberPickerClass;
enum  {
	SUDOKU_CELL_VIEW_0_PROPERTY,
	SUDOKU_CELL_VIEW_VALUE_PROPERTY,
	SUDOKU_CELL_VIEW_IS_FIXED_PROPERTY,
	SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES_PROPERTY,
	SUDOKU_CELL_VIEW_SHOW_WARNINGS_PROPERTY,
	SUDOKU_CELL_VIEW_SELECTED_PROPERTY,
	SUDOKU_CELL_VIEW_BACKGROUND_COLOR_PROPERTY,
	SUDOKU_CELL_VIEW_NUM_PROPERTIES
};
static GParamSpec* sudoku_cell_view_properties[SUDOKU_CELL_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SUDOKU_VIEW (sudoku_view_get_type ())
#define SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_VIEW, SudokuView))
#define SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_VIEW, SudokuViewClass))
#define IS_SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_VIEW))
#define IS_SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_VIEW))
#define SUDOKU_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_VIEW, SudokuViewClass))

typedef struct _SudokuView SudokuView;
typedef struct _SudokuViewClass SudokuViewClass;
typedef struct _SudokuViewPrivate SudokuViewPrivate;
enum  {
	SUDOKU_VIEW_0_PROPERTY,
	SUDOKU_VIEW_SHOW_WARNINGS_PROPERTY,
	SUDOKU_VIEW_SHOW_POSSIBILITIES_PROPERTY,
	SUDOKU_VIEW_HIGHLIGHTER_PROPERTY,
	SUDOKU_VIEW_NUM_PROPERTIES
};
static GParamSpec* sudoku_view_properties[SUDOKU_VIEW_NUM_PROPERTIES];
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SudokuCellView {
	GtkDrawingArea parent_instance;
	SudokuCellViewPrivate * priv;
};

struct _SudokuCellViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _SudokuCellViewPrivate {
	PangoLayout* layout;
	gdouble size_ratio;
	GtkPopover* popover;
	GtkPopover* earmark_popover;
	SudokuGame* game;
	gint row;
	gint col;
	gboolean _show_possibilities;
	gboolean _show_warnings;
	gboolean _selected;
	GdkRGBA _background_color;
	NumberPicker* number_picker;
	NumberPicker* earmark_picker;
};

struct _SudokuView {
	GtkAspectFrame parent_instance;
	SudokuViewPrivate * priv;
	SudokuGame* game;
};

struct _SudokuViewClass {
	GtkAspectFrameClass parent_class;
};

struct _SudokuViewPrivate {
	SudokuCellView** cells;
	gint cells_length1;
	gint cells_length2;
	gboolean previous_board_broken_state;
	GtkOverlay* overlay;
	GtkDrawingArea* drawing;
	GtkGrid* grid;
	gint selected_row;
	gint selected_col;
	gboolean _show_warnings;
	gboolean _show_possibilities;
	gboolean _highlighter;
};

struct _Block5Data {
	int _ref_count_;
	SudokuView* self;
	SudokuGame* game;
};

struct _Block6Data {
	int _ref_count_;
	Block5Data * _data5_;
	gint cell_row;
	gint cell_col;
};


static gpointer sudoku_cell_view_parent_class = NULL;
static gpointer sudoku_view_parent_class = NULL;

GType sudoku_cell_view_get_type (void) G_GNUC_CONST;
GType number_picker_get_type (void) G_GNUC_CONST;
#define SUDOKU_CELL_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_CELL_VIEW, SudokuCellViewPrivate))
SudokuCellView* sudoku_cell_view_new (gint row,
                                      gint col,
                                      SudokuGame* * game);
SudokuCellView* sudoku_cell_view_construct (GType object_type,
                                            gint row,
                                            gint col,
                                            SudokuGame* * game);
void sudoku_cell_view_set_value (SudokuCellView* self,
                                 gint value);
gboolean sudoku_cell_view_get_is_fixed (SudokuCellView* self);
static gboolean sudoku_cell_view_focus_out_cb (SudokuCellView* self,
                                        GtkWidget* widget,
                                        GdkEventFocus* event);
static gboolean _sudoku_cell_view_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                    GdkEventFocus* event,
                                                                    gpointer self);
void sudoku_cell_view_cell_changed_cb (SudokuCellView* self,
                                       gint row,
                                       gint col,
                                       gint old_val,
                                       gint new_val);
static void _sudoku_cell_view_cell_changed_cb_sudoku_game_cell_changed (SudokuGame* _sender,
                                                                 gint row,
                                                                 gint col,
                                                                 gint old_val,
                                                                 gint new_val,
                                                                 gpointer self);
static gboolean sudoku_cell_view_real_button_press_event (GtkWidget* base,
                                                   GdkEventButton* event);
static void sudoku_cell_view_hide_both_popovers (SudokuCellView* self);
static void sudoku_cell_view_show_earmark_picker (SudokuCellView* self);
static void sudoku_cell_view_show_number_picker (SudokuCellView* self);
static void sudoku_cell_view_create_earmark_picker (SudokuCellView* self);
NumberPicker* number_picker_new (SudokuBoard* * board,
                                 gboolean earmark);
NumberPicker* number_picker_construct (GType object_type,
                                       SudokuBoard* * board,
                                       gboolean earmark);
static void __lambda7_ (SudokuCellView* self,
                 gint number,
                 gboolean state);
gint sudoku_cell_view_get_value (SudokuCellView* self);
static void ___lambda7__number_picker_earmark_state_changed (NumberPicker* _sender,
                                                      gint number,
                                                      gboolean active,
                                                      gpointer self);
void number_picker_set_earmarks (NumberPicker* self,
                                 gint row,
                                 gint col);
static void __lambda10_ (SudokuCellView* self,
                  NumberPicker* o,
                  gint number);
static void ___lambda10__number_picker_number_picked (NumberPicker* _sender,
                                               gint number,
                                               gpointer self);
void number_picker_set_clear_button_visibility (NumberPicker* self,
                                                gboolean visible);
static void __lambda11_ (SudokuCellView* self);
static void sudoku_cell_view_destroy_popover (SudokuCellView* self,
                                       GtkPopover* * popover);
static void ___lambda11__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static gboolean __lambda12_ (SudokuCellView* self);
static gboolean ___lambda12__gtk_widget_focus_out_event (GtkWidget* _sender,
                                                  GdkEventFocus* event,
                                                  gpointer self);
static void __lambda8_ (SudokuCellView* self);
static void ___lambda8__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static gboolean __lambda9_ (SudokuCellView* self);
static gboolean ___lambda9__gtk_widget_focus_out_event (GtkWidget* _sender,
                                                 GdkEventFocus* event,
                                                 gpointer self);
static gint sudoku_cell_view_key_map_keypad (SudokuCellView* self,
                                      const gchar* key_name);
static gboolean sudoku_cell_view_real_key_press_event (GtkWidget* base,
                                                GdkEventKey* event);
gboolean number_picker_set_earmark (NumberPicker* self,
                                    gint row,
                                    gint col,
                                    gint index,
                                    gboolean state);
static gboolean sudoku_cell_view_real_draw (GtkWidget* base,
                                     cairo_t* c);
void sudoku_cell_view_set_background_color (SudokuCellView* self,
                                            GdkRGBA * value);
void sudoku_cell_view_clear (SudokuCellView* self);
gboolean sudoku_cell_view_get_show_possibilities (SudokuCellView* self);
void sudoku_cell_view_set_show_possibilities (SudokuCellView* self,
                                              gboolean value);
gboolean sudoku_cell_view_get_show_warnings (SudokuCellView* self);
void sudoku_cell_view_set_show_warnings (SudokuCellView* self,
                                         gboolean value);
gboolean sudoku_cell_view_get_selected (SudokuCellView* self);
void sudoku_cell_view_set_selected (SudokuCellView* self,
                                    gboolean value);
void sudoku_cell_view_get_background_color (SudokuCellView* self,
                                            GdkRGBA * result);
static gboolean _gdk_rgba_equal (const GdkRGBA * s1,
                          const GdkRGBA * s2);
static void sudoku_cell_view_finalize (GObject * obj);
static void _vala_sudoku_cell_view_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_sudoku_cell_view_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);
GType sudoku_view_get_type (void) G_GNUC_CONST;
#define SUDOKU_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_VIEW, SudokuViewPrivate))
static void sudoku_view_set_selected (SudokuView* self,
                               gint cell_row,
                               gint cell_col);
SudokuView* sudoku_view_new (SudokuGame* game);
SudokuView* sudoku_view_construct (GType object_type,
                                   SudokuGame* game);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean sudoku_view_draw_board (SudokuView* self,
                                 cairo_t* c);
static gboolean _sudoku_view_draw_board_gtk_widget_draw (GtkWidget* _sender,
                                                  cairo_t* cr,
                                                  gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static gboolean ________lambda13_ (Block6Data* _data6_);
static gboolean _________lambda13__gtk_widget_focus_in_event (GtkWidget* _sender,
                                                       GdkEventFocus* event,
                                                       gpointer self);
static void ________lambda14_ (Block6Data* _data6_,
                        GObject* s,
                        GParamSpec* p);
static void _________lambda14__g_object_notify (GObject* _sender,
                                         GParamSpec* pspec,
                                         gpointer self);
void sudoku_view_clear (SudokuView* self);
gboolean sudoku_view_get_show_warnings (SudokuView* self);
void sudoku_view_set_show_warnings (SudokuView* self,
                                    gboolean value);
gboolean sudoku_view_get_show_possibilities (SudokuView* self);
void sudoku_view_set_show_possibilities (SudokuView* self,
                                         gboolean value);
gboolean sudoku_view_get_highlighter (SudokuView* self);
void sudoku_view_set_highlighter (SudokuView* self,
                                  gboolean value);
static void sudoku_view_finalize (GObject * obj);
static void _vala_sudoku_view_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_sudoku_view_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

const GdkRGBA selected_bg_color = {0.7, 0.8, 0.9};
const GdkRGBA fixed_cell_color = {0.8, 0.8, 0.8, (gdouble) 0};
const GdkRGBA free_cell_color = {1.0, 1.0, 1.0, 1.0};
const GdkRGBA highlight_color = {0.93, 0.93, 0.93, (gdouble) 0};

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static gboolean
_sudoku_cell_view_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                           GdkEventFocus* event,
                                                           gpointer self)
{
	gboolean result;
	result = sudoku_cell_view_focus_out_cb ((SudokuCellView*) self, _sender, event);
	return result;
}


static void
_sudoku_cell_view_cell_changed_cb_sudoku_game_cell_changed (SudokuGame* _sender,
                                                            gint row,
                                                            gint col,
                                                            gint old_val,
                                                            gint new_val,
                                                            gpointer self)
{
	sudoku_cell_view_cell_changed_cb ((SudokuCellView*) self, row, col, old_val, new_val);
}


SudokuCellView*
sudoku_cell_view_construct (GType object_type,
                            gint row,
                            gint col,
                            SudokuGame* * game)
{
	SudokuCellView * self = NULL;
	SudokuGame* _tmp0_;
	GtkStyle* _tmp1_;
	GtkStyle* _tmp2_;
	PangoFontDescription* _tmp3_;
	SudokuBoard* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_val_if_fail (*game != NULL, NULL);
	self = (SudokuCellView*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (*game);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp0_;
	self->priv->row = row;
	self->priv->col = col;
	_tmp1_ = gtk_widget_get_style ((GtkWidget*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->font_desc;
	pango_font_description_set_size (_tmp3_, PANGO_SCALE * 13);
	_tmp4_ = (*game)->board;
	sudoku_cell_view_set_value (self, sudoku_board_get (_tmp4_, row, col));
	gtk_widget_set_can_focus ((GtkWidget*) self, TRUE);
	gtk_widget_set_events ((GtkWidget*) self, ((GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_BUTTON_RELEASE_MASK) | GDK_KEY_PRESS_MASK);
	_tmp6_ = sudoku_cell_view_get_is_fixed (self);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		GameMode _tmp8_;
		_tmp8_ = (*game)->mode;
		_tmp5_ = _tmp8_ == GAME_MODE_PLAY;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		return self;
	}
	g_signal_connect_object ((GtkWidget*) self, "focus-out-event", (GCallback) _sudoku_cell_view_focus_out_cb_gtk_widget_focus_out_event, self, 0);
	g_signal_connect_object (*game, "cell-changed", (GCallback) _sudoku_cell_view_cell_changed_cb_sudoku_game_cell_changed, self, 0);
	return self;
}


SudokuCellView*
sudoku_cell_view_new (gint row,
                      gint col,
                      SudokuGame* * game)
{
	return sudoku_cell_view_construct (TYPE_SUDOKU_CELL_VIEW, row, col, game);
}


static gboolean
sudoku_cell_view_real_button_press_event (GtkWidget* base,
                                          GdkEventButton* event)
{
	SudokuCellView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	guint _tmp1_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_ = FALSE;
	SudokuGame* _tmp6_;
	GameMode _tmp7_;
	gboolean _tmp14_ = FALSE;
	GtkPopover* _tmp15_;
	guint _tmp17_;
	self = (SudokuCellView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = event->button;
	if (_tmp1_ != ((guint) 1)) {
		guint _tmp2_;
		_tmp2_ = event->button;
		_tmp0_ = _tmp2_ != ((guint) 3);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	g_object_get ((GtkWidget*) self, "is-focus", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	if (!_tmp4_) {
		gtk_widget_grab_focus ((GtkWidget*) self);
	}
	_tmp6_ = self->priv->game;
	_tmp7_ = _tmp6_->mode;
	if (_tmp7_ == GAME_MODE_PLAY) {
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp9_ = sudoku_cell_view_get_is_fixed (self);
		_tmp10_ = _tmp9_;
		if (_tmp10_) {
			_tmp8_ = TRUE;
		} else {
			SudokuGame* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp11_ = self->priv->game;
			_tmp12_ = sudoku_game_get_paused (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp8_ = _tmp13_;
		}
		_tmp5_ = _tmp8_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		result = FALSE;
		return result;
	}
	_tmp15_ = self->priv->popover;
	if (_tmp15_ != NULL) {
		_tmp14_ = TRUE;
	} else {
		GtkPopover* _tmp16_;
		_tmp16_ = self->priv->earmark_popover;
		_tmp14_ = _tmp16_ != NULL;
	}
	if (_tmp14_) {
		sudoku_cell_view_hide_both_popovers (self);
		result = FALSE;
		return result;
	}
	_tmp17_ = event->button;
	if (_tmp17_ == ((guint) 1)) {
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_;
		_tmp20_ = self->priv->_show_possibilities;
		if (!_tmp20_) {
			GdkModifierType _tmp21_;
			_tmp21_ = event->state;
			_tmp19_ = (_tmp21_ & GDK_CONTROL_MASK) > 0;
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			SudokuGame* _tmp22_;
			GameMode _tmp23_;
			_tmp22_ = self->priv->game;
			_tmp23_ = _tmp22_->mode;
			_tmp18_ = _tmp23_ == GAME_MODE_PLAY;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			sudoku_cell_view_show_earmark_picker (self);
		} else {
			sudoku_cell_view_show_number_picker (self);
		}
	} else {
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		gboolean _tmp26_;
		_tmp26_ = self->priv->_show_possibilities;
		if (!_tmp26_) {
			guint _tmp27_;
			_tmp27_ = event->button;
			_tmp25_ = _tmp27_ == ((guint) 3);
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			SudokuGame* _tmp28_;
			GameMode _tmp29_;
			_tmp28_ = self->priv->game;
			_tmp29_ = _tmp28_->mode;
			_tmp24_ = _tmp29_ == GAME_MODE_PLAY;
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			sudoku_cell_view_show_earmark_picker (self);
		}
	}
	result = FALSE;
	return result;
}


static void
__lambda7_ (SudokuCellView* self,
            gint number,
            gboolean state)
{
	SudokuGame* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	if (state) {
		SudokuGame* _tmp0_;
		SudokuBoard* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp0_ = self->priv->game;
		_tmp1_ = _tmp0_->board;
		_tmp2_ = self->priv->row;
		_tmp3_ = self->priv->col;
		sudoku_board_enable_earmark (_tmp1_, _tmp2_, _tmp3_, number);
	} else {
		SudokuGame* _tmp4_;
		SudokuBoard* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp4_ = self->priv->game;
		_tmp5_ = _tmp4_->board;
		_tmp6_ = self->priv->row;
		_tmp7_ = self->priv->col;
		sudoku_board_disable_earmark (_tmp5_, _tmp6_, _tmp7_, number);
	}
	_tmp8_ = self->priv->game;
	_tmp9_ = self->priv->row;
	_tmp10_ = self->priv->col;
	_tmp11_ = sudoku_cell_view_get_value (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = sudoku_cell_view_get_value (self);
	_tmp14_ = _tmp13_;
	g_signal_emit_by_name (_tmp8_, "cell-changed", _tmp9_, _tmp10_, _tmp12_, _tmp14_);
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static void
___lambda7__number_picker_earmark_state_changed (NumberPicker* _sender,
                                                 gint number,
                                                 gboolean active,
                                                 gpointer self)
{
	__lambda7_ ((SudokuCellView*) self, number, active);
}


static void
sudoku_cell_view_create_earmark_picker (SudokuCellView* self)
{
	SudokuGame* _tmp0_;
	NumberPicker* _tmp1_;
	NumberPicker* _tmp2_;
	NumberPicker* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = number_picker_new (&_tmp0_->board, TRUE);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->earmark_picker);
	self->priv->earmark_picker = _tmp1_;
	_tmp2_ = self->priv->earmark_picker;
	g_signal_connect_object (_tmp2_, "earmark-state-changed", (GCallback) ___lambda7__number_picker_earmark_state_changed, self, 0);
	_tmp3_ = self->priv->earmark_picker;
	_tmp4_ = self->priv->row;
	_tmp5_ = self->priv->col;
	number_picker_set_earmarks (_tmp3_, _tmp4_, _tmp5_);
}


static void
__lambda10_ (SudokuCellView* self,
             NumberPicker* o,
             gint number)
{
	SudokuGame* _tmp0_;
	SudokuBoard* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GtkPopover* _tmp4_;
	g_return_if_fail (o != NULL);
	sudoku_cell_view_set_value (self, number);
	if (number == 0) {
		g_object_notify ((GObject*) self, "value");
	}
	_tmp0_ = self->priv->game;
	_tmp1_ = _tmp0_->board;
	_tmp2_ = self->priv->row;
	_tmp3_ = self->priv->col;
	sudoku_board_disable_all_earmarks (_tmp1_, _tmp2_, _tmp3_);
	_tmp4_ = self->priv->popover;
	gtk_widget_hide ((GtkWidget*) _tmp4_);
}


static void
___lambda10__number_picker_number_picked (NumberPicker* _sender,
                                          gint number,
                                          gpointer self)
{
	__lambda10_ ((SudokuCellView*) self, _sender, number);
}


static void
__lambda11_ (SudokuCellView* self)
{
	GtkPopover* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->popover;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		sudoku_cell_view_destroy_popover (self, &self->priv->popover);
	}
}


static void
___lambda11__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda11_ ((SudokuCellView*) self);
}


static gboolean
__lambda12_ (SudokuCellView* self)
{
	gboolean result = FALSE;
	GtkPopover* _tmp0_;
	_tmp0_ = self->priv->popover;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	result = TRUE;
	return result;
}


static gboolean
___lambda12__gtk_widget_focus_out_event (GtkWidget* _sender,
                                         GdkEventFocus* event,
                                         gpointer self)
{
	gboolean result;
	result = __lambda12_ ((SudokuCellView*) self);
	return result;
}


static void
sudoku_cell_view_show_number_picker (SudokuCellView* self)
{
	GtkPopover* _tmp0_;
	SudokuGame* _tmp2_;
	NumberPicker* _tmp3_;
	NumberPicker* _tmp4_;
	NumberPicker* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GtkPopover* _tmp8_;
	GtkPopover* _tmp9_;
	NumberPicker* _tmp10_;
	GtkPopover* _tmp11_;
	GtkPopover* _tmp12_;
	GtkPopover* _tmp13_;
	GtkPopover* _tmp14_;
	GtkPopover* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->earmark_popover;
	if (_tmp0_ != NULL) {
		GtkPopover* _tmp1_;
		_tmp1_ = self->priv->earmark_popover;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
	}
	_tmp2_ = self->priv->game;
	_tmp3_ = number_picker_new (&_tmp2_->board, FALSE);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->number_picker);
	self->priv->number_picker = _tmp3_;
	_tmp4_ = self->priv->number_picker;
	g_signal_connect_object (_tmp4_, "number-picked", (GCallback) ___lambda10__number_picker_number_picked, self, 0);
	_tmp5_ = self->priv->number_picker;
	_tmp6_ = sudoku_cell_view_get_value (self);
	_tmp7_ = _tmp6_;
	number_picker_set_clear_button_visibility (_tmp5_, _tmp7_ != 0);
	_tmp8_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) self);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->popover);
	self->priv->popover = _tmp8_;
	_tmp9_ = self->priv->popover;
	_tmp10_ = self->priv->number_picker;
	gtk_container_add ((GtkContainer*) _tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = self->priv->popover;
	gtk_popover_set_modal (_tmp11_, FALSE);
	_tmp12_ = self->priv->popover;
	gtk_popover_set_position (_tmp12_, GTK_POS_BOTTOM);
	_tmp13_ = self->priv->popover;
	g_signal_connect_object ((GObject*) _tmp13_, "notify::visible", (GCallback) ___lambda11__g_object_notify, self, 0);
	_tmp14_ = self->priv->popover;
	g_signal_connect_object ((GtkWidget*) _tmp14_, "focus-out-event", (GCallback) ___lambda12__gtk_widget_focus_out_event, self, 0);
	_tmp15_ = self->priv->popover;
	gtk_widget_show ((GtkWidget*) _tmp15_);
}


static void
__lambda8_ (SudokuCellView* self)
{
	GtkPopover* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->earmark_popover;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		sudoku_cell_view_destroy_popover (self, &self->priv->earmark_popover);
	}
}


static void
___lambda8__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda8_ ((SudokuCellView*) self);
}


static gboolean
__lambda9_ (SudokuCellView* self)
{
	gboolean result = FALSE;
	GtkPopover* _tmp0_;
	_tmp0_ = self->priv->earmark_popover;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	result = TRUE;
	return result;
}


static gboolean
___lambda9__gtk_widget_focus_out_event (GtkWidget* _sender,
                                        GdkEventFocus* event,
                                        gpointer self)
{
	gboolean result;
	result = __lambda9_ ((SudokuCellView*) self);
	return result;
}


static void
sudoku_cell_view_show_earmark_picker (SudokuCellView* self)
{
	GtkPopover* _tmp0_;
	GtkPopover* _tmp2_;
	GtkPopover* _tmp3_;
	NumberPicker* _tmp4_;
	GtkPopover* _tmp5_;
	GtkPopover* _tmp6_;
	GtkPopover* _tmp7_;
	GtkPopover* _tmp8_;
	GtkPopover* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->popover;
	if (_tmp0_ != NULL) {
		GtkPopover* _tmp1_;
		_tmp1_ = self->priv->popover;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
	}
	sudoku_cell_view_create_earmark_picker (self);
	_tmp2_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) self);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->earmark_popover);
	self->priv->earmark_popover = _tmp2_;
	_tmp3_ = self->priv->earmark_popover;
	_tmp4_ = self->priv->earmark_picker;
	gtk_container_add ((GtkContainer*) _tmp3_, (GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->earmark_popover;
	gtk_popover_set_modal (_tmp5_, FALSE);
	_tmp6_ = self->priv->earmark_popover;
	gtk_popover_set_position (_tmp6_, GTK_POS_BOTTOM);
	_tmp7_ = self->priv->earmark_popover;
	g_signal_connect_object ((GObject*) _tmp7_, "notify::visible", (GCallback) ___lambda8__g_object_notify, self, 0);
	_tmp8_ = self->priv->earmark_popover;
	g_signal_connect_object ((GtkWidget*) _tmp8_, "focus-out-event", (GCallback) ___lambda9__gtk_widget_focus_out_event, self, 0);
	_tmp9_ = self->priv->earmark_popover;
	gtk_widget_show ((GtkWidget*) _tmp9_);
}


static void
sudoku_cell_view_destroy_popover (SudokuCellView* self,
                                  GtkPopover* * popover)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (*popover != NULL);
	if ((*popover) != NULL) {
		gtk_widget_destroy ((GtkWidget*) (*popover));
		_g_object_unref0 (*popover);
		*popover = NULL;
	}
}


static void
sudoku_cell_view_hide_both_popovers (SudokuCellView* self)
{
	GtkPopover* _tmp0_;
	GtkPopover* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->popover;
	if (_tmp0_ != NULL) {
		GtkPopover* _tmp1_;
		_tmp1_ = self->priv->popover;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
	}
	_tmp2_ = self->priv->earmark_popover;
	if (_tmp2_ != NULL) {
		GtkPopover* _tmp3_;
		_tmp3_ = self->priv->earmark_popover;
		gtk_widget_hide ((GtkWidget*) _tmp3_);
	}
}


static gboolean
sudoku_cell_view_focus_out_cb (SudokuCellView* self,
                               GtkWidget* widget,
                               GdkEventFocus* event)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	sudoku_cell_view_hide_both_popovers (self);
	result = FALSE;
	return result;
}


static gint
sudoku_cell_view_key_map_keypad (SudokuCellView* self,
                                 const gchar* key_name)
{
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (key_name != NULL, 0);
	if (g_strcmp0 (key_name, "KP_0") == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (key_name, "0") == 0;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	}
	if (g_strcmp0 (key_name, "KP_1") == 0) {
		result = 1;
		return result;
	}
	if (g_strcmp0 (key_name, "KP_2") == 0) {
		result = 2;
		return result;
	}
	if (g_strcmp0 (key_name, "KP_3") == 0) {
		result = 3;
		return result;
	}
	if (g_strcmp0 (key_name, "KP_4") == 0) {
		result = 4;
		return result;
	}
	if (g_strcmp0 (key_name, "KP_5") == 0) {
		result = 5;
		return result;
	}
	if (g_strcmp0 (key_name, "KP_6") == 0) {
		result = 6;
		return result;
	}
	if (g_strcmp0 (key_name, "KP_7") == 0) {
		result = 7;
		return result;
	}
	if (g_strcmp0 (key_name, "KP_8") == 0) {
		result = 8;
		return result;
	}
	if (g_strcmp0 (key_name, "KP_9") == 0) {
		result = 9;
		return result;
	}
	result = -1;
	return result;
}


static gboolean
sudoku_cell_view_real_key_press_event (GtkWidget* base,
                                       GdkEventKey* event)
{
	SudokuCellView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	SudokuGame* _tmp1_;
	GameMode _tmp2_;
	gchar* k_name = NULL;
	guint _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gint k_no = 0;
	const gchar* _tmp12_;
	gint _tmp13_;
	gboolean _tmp15_ = FALSE;
	gint _tmp16_;
	gboolean _tmp49_ = FALSE;
	gboolean _tmp50_ = FALSE;
	gint _tmp51_;
	gboolean _tmp54_ = FALSE;
	gboolean _tmp55_ = FALSE;
	const gchar* _tmp56_;
	const gchar* _tmp61_;
	self = (SudokuCellView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = self->priv->game;
	_tmp2_ = _tmp1_->mode;
	if (_tmp2_ == GAME_MODE_PLAY) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = sudoku_cell_view_get_is_fixed (self);
		_tmp5_ = _tmp4_;
		if (_tmp5_) {
			_tmp3_ = TRUE;
		} else {
			SudokuGame* _tmp6_;
			gboolean _tmp7_;
			gboolean _tmp8_;
			_tmp6_ = self->priv->game;
			_tmp7_ = sudoku_game_get_paused (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp3_ = _tmp8_;
		}
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp9_ = event->keyval;
	_tmp10_ = gdk_keyval_name (_tmp9_);
	_tmp11_ = g_strdup (_tmp10_);
	k_name = _tmp11_;
	_tmp12_ = k_name;
	k_no = atoi (_tmp12_);
	_tmp13_ = k_no;
	if (_tmp13_ == 0) {
		const gchar* _tmp14_;
		_tmp14_ = k_name;
		k_no = sudoku_cell_view_key_map_keypad (self, _tmp14_);
	}
	_tmp16_ = k_no;
	if (_tmp16_ >= 1) {
		gint _tmp17_;
		_tmp17_ = k_no;
		_tmp15_ = _tmp17_ <= 9;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		gboolean _tmp18_ = FALSE;
		GdkModifierType _tmp19_;
		_tmp19_ = event->state;
		if ((_tmp19_ & GDK_CONTROL_MASK) > 0) {
			SudokuGame* _tmp20_;
			GameMode _tmp21_;
			_tmp20_ = self->priv->game;
			_tmp21_ = _tmp20_->mode;
			_tmp18_ = _tmp21_ == GAME_MODE_PLAY;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			gboolean new_state = FALSE;
			SudokuGame* _tmp22_;
			SudokuBoard* _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			NumberPicker* _tmp27_;
			NumberPicker* _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			gint _tmp31_;
			gboolean _tmp32_;
			_tmp22_ = self->priv->game;
			_tmp23_ = _tmp22_->board;
			_tmp24_ = self->priv->row;
			_tmp25_ = self->priv->col;
			_tmp26_ = k_no;
			new_state = !sudoku_board_is_earmark_enabled (_tmp23_, _tmp24_, _tmp25_, _tmp26_);
			_tmp27_ = self->priv->earmark_picker;
			if (_tmp27_ == NULL) {
				sudoku_cell_view_create_earmark_picker (self);
			}
			_tmp28_ = self->priv->earmark_picker;
			_tmp29_ = self->priv->row;
			_tmp30_ = self->priv->col;
			_tmp31_ = k_no;
			_tmp32_ = new_state;
			if (number_picker_set_earmark (_tmp28_, _tmp29_, _tmp30_, _tmp31_ - 1, _tmp32_)) {
				gboolean _tmp33_;
				_tmp33_ = new_state;
				if (_tmp33_) {
					SudokuGame* _tmp34_;
					SudokuBoard* _tmp35_;
					gint _tmp36_;
					gint _tmp37_;
					gint _tmp38_;
					_tmp34_ = self->priv->game;
					_tmp35_ = _tmp34_->board;
					_tmp36_ = self->priv->row;
					_tmp37_ = self->priv->col;
					_tmp38_ = k_no;
					sudoku_board_enable_earmark (_tmp35_, _tmp36_, _tmp37_, _tmp38_);
				} else {
					SudokuGame* _tmp39_;
					SudokuBoard* _tmp40_;
					gint _tmp41_;
					gint _tmp42_;
					gint _tmp43_;
					_tmp39_ = self->priv->game;
					_tmp40_ = _tmp39_->board;
					_tmp41_ = self->priv->row;
					_tmp42_ = self->priv->col;
					_tmp43_ = k_no;
					sudoku_board_disable_earmark (_tmp40_, _tmp41_, _tmp42_, _tmp43_);
				}
				gtk_widget_queue_draw ((GtkWidget*) self);
			}
		} else {
			gint _tmp44_;
			SudokuGame* _tmp45_;
			SudokuBoard* _tmp46_;
			gint _tmp47_;
			gint _tmp48_;
			_tmp44_ = k_no;
			sudoku_cell_view_set_value (self, _tmp44_);
			_tmp45_ = self->priv->game;
			_tmp46_ = _tmp45_->board;
			_tmp47_ = self->priv->row;
			_tmp48_ = self->priv->col;
			sudoku_board_disable_all_earmarks (_tmp46_, _tmp47_, _tmp48_);
			sudoku_cell_view_hide_both_popovers (self);
		}
		result = TRUE;
		_g_free0 (k_name);
		return result;
	}
	_tmp51_ = k_no;
	if (_tmp51_ == 0) {
		_tmp50_ = TRUE;
	} else {
		const gchar* _tmp52_;
		_tmp52_ = k_name;
		_tmp50_ = g_strcmp0 (_tmp52_, "BackSpace") == 0;
	}
	if (_tmp50_) {
		_tmp49_ = TRUE;
	} else {
		const gchar* _tmp53_;
		_tmp53_ = k_name;
		_tmp49_ = g_strcmp0 (_tmp53_, "Delete") == 0;
	}
	if (_tmp49_) {
		sudoku_cell_view_set_value (self, 0);
		g_object_notify ((GObject*) self, "value");
		result = TRUE;
		_g_free0 (k_name);
		return result;
	}
	_tmp56_ = k_name;
	if (g_strcmp0 (_tmp56_, "space") == 0) {
		_tmp55_ = TRUE;
	} else {
		const gchar* _tmp57_;
		_tmp57_ = k_name;
		_tmp55_ = g_strcmp0 (_tmp57_, "Return") == 0;
	}
	if (_tmp55_) {
		_tmp54_ = TRUE;
	} else {
		const gchar* _tmp58_;
		_tmp58_ = k_name;
		_tmp54_ = g_strcmp0 (_tmp58_, "KP_Enter") == 0;
	}
	if (_tmp54_) {
		GtkPopover* _tmp59_;
		_tmp59_ = self->priv->popover;
		if (_tmp59_ != NULL) {
			GtkPopover* _tmp60_;
			_tmp60_ = self->priv->popover;
			gtk_widget_hide ((GtkWidget*) _tmp60_);
			result = FALSE;
			_g_free0 (k_name);
			return result;
		}
		sudoku_cell_view_show_number_picker (self);
		result = TRUE;
		_g_free0 (k_name);
		return result;
	}
	_tmp61_ = k_name;
	if (g_strcmp0 (_tmp61_, "Escape") == 0) {
		sudoku_cell_view_hide_both_popovers (self);
		result = TRUE;
		_g_free0 (k_name);
		return result;
	}
	result = FALSE;
	_g_free0 (k_name);
	return result;
}


static gboolean
sudoku_cell_view_real_draw (GtkWidget* base,
                            cairo_t* c)
{
	SudokuCellView * self;
	gboolean result = FALSE;
	gint glyph_width = 0;
	gint glyph_height = 0;
	PangoLayout* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	SudokuGame* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp31_;
	gboolean _tmp32_;
	gboolean _tmp35_;
	gboolean _tmp89_ = FALSE;
	gboolean _tmp90_;
	self = (SudokuCellView*) base;
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = self->priv->layout;
	pango_layout_get_pixel_size (_tmp0_, &_tmp1_, &_tmp2_);
	glyph_width = _tmp1_;
	glyph_height = _tmp2_;
	_tmp4_ = self->priv->_show_warnings;
	if (_tmp4_) {
		SudokuGame* _tmp5_;
		SudokuBoard* _tmp6_;
		GeeSet* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		Coord _tmp10_ = {0};
		_tmp5_ = self->priv->game;
		_tmp6_ = _tmp5_->board;
		_tmp7_ = _tmp6_->broken_coords;
		_tmp8_ = self->priv->row;
		_tmp9_ = self->priv->col;
		coord_init (&_tmp10_, _tmp8_, _tmp9_);
		_tmp3_ = gee_collection_contains ((GeeCollection*) _tmp7_, &_tmp10_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		cairo_set_source_rgb (c, 1.0, 0.0, 0.0);
	} else {
		gboolean _tmp11_;
		_tmp11_ = self->priv->_selected;
		if (_tmp11_) {
			cairo_set_source_rgb (c, 0.2, 0.2, 0.2);
		} else {
			cairo_set_source_rgb (c, 0.0, 0.0, 0.0);
		}
	}
	_tmp12_ = self->priv->game;
	_tmp13_ = sudoku_game_get_paused (_tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_) {
		result = FALSE;
		return result;
	}
	_tmp15_ = sudoku_cell_view_get_value (self);
	_tmp16_ = _tmp15_;
	if (_tmp16_ != 0) {
		gint width = 0;
		gint height = 0;
		PangoLayout* _tmp17_;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gint _tmp20_;
		gdouble scale = 0.0;
		gdouble _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gdouble _tmp24_;
		gint _tmp25_;
		gdouble _tmp26_;
		gdouble _tmp27_;
		gdouble _tmp28_;
		PangoLayout* _tmp29_;
		_tmp17_ = self->priv->layout;
		pango_layout_get_size (_tmp17_, &_tmp18_, &_tmp19_);
		width = _tmp18_;
		height = _tmp19_;
		_tmp20_ = height;
		height = _tmp20_ / PANGO_SCALE;
		_tmp21_ = self->priv->size_ratio;
		_tmp22_ = height;
		scale = (((gdouble) gtk_widget_get_allocated_height ((GtkWidget*) self)) / _tmp21_) / _tmp22_;
		_tmp23_ = glyph_width;
		_tmp24_ = scale;
		_tmp25_ = glyph_height;
		_tmp26_ = scale;
		cairo_move_to (c, (gtk_widget_get_allocated_width ((GtkWidget*) self) - (_tmp23_ * _tmp24_)) / 2, (gtk_widget_get_allocated_height ((GtkWidget*) self) - (_tmp25_ * _tmp26_)) / 2);
		cairo_save (c);
		_tmp27_ = scale;
		_tmp28_ = scale;
		cairo_scale (c, _tmp27_, _tmp28_);
		_tmp29_ = self->priv->layout;
		pango_cairo_show_layout (c, _tmp29_);
		cairo_restore (c);
	}
	_tmp31_ = sudoku_cell_view_get_is_fixed (self);
	_tmp32_ = _tmp31_;
	if (_tmp32_) {
		SudokuGame* _tmp33_;
		GameMode _tmp34_;
		_tmp33_ = self->priv->game;
		_tmp34_ = _tmp33_->mode;
		_tmp30_ = _tmp34_ == GAME_MODE_PLAY;
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		result = FALSE;
		return result;
	}
	_tmp35_ = self->priv->_show_possibilities;
	if (!_tmp35_) {
		gdouble earmark_size = 0.0;
		gdouble _tmp36_;
		gdouble _tmp37_;
		gdouble _tmp38_;
		SudokuGame* _tmp39_;
		SudokuBoard* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		_tmp36_ = self->priv->size_ratio;
		earmark_size = gtk_widget_get_allocated_height ((GtkWidget*) self) / (_tmp36_ * 2);
		_tmp37_ = earmark_size;
		cairo_set_font_size (c, _tmp37_);
		_tmp38_ = earmark_size;
		cairo_move_to (c, (gdouble) 0, _tmp38_);
		cairo_set_source_rgb (c, 0.0, 0.0, 0.0);
		_tmp39_ = self->priv->game;
		_tmp40_ = _tmp39_->board;
		_tmp41_ = self->priv->row;
		_tmp42_ = self->priv->col;
		_tmp43_ = sudoku_board_get_earmarks_string (_tmp40_, _tmp41_, _tmp42_);
		_tmp44_ = _tmp43_;
		cairo_show_text (c, _tmp44_);
		_g_free0 (_tmp44_);
	} else {
		gint _tmp45_;
		gint _tmp46_;
		_tmp45_ = sudoku_cell_view_get_value (self);
		_tmp46_ = _tmp45_;
		if (_tmp46_ == 0) {
			gdouble possibility_size = 0.0;
			gdouble _tmp47_;
			gdouble _tmp48_;
			gboolean* possibilities = NULL;
			SudokuGame* _tmp49_;
			SudokuBoard* _tmp50_;
			gint _tmp51_;
			gint _tmp52_;
			gint _tmp53_;
			gboolean* _tmp54_;
			gint possibilities_length1;
			gint _possibilities_size_;
			gint height = 0;
			SudokuGame* _tmp55_;
			SudokuBoard* _tmp56_;
			gint _tmp57_;
			gint _tmp58_;
			gint width = 0;
			SudokuGame* _tmp59_;
			SudokuBoard* _tmp60_;
			gint _tmp61_;
			gint _tmp62_;
			gint num = 0;
			_tmp47_ = self->priv->size_ratio;
			possibility_size = gtk_widget_get_allocated_height ((GtkWidget*) self) / (_tmp47_ * 2);
			_tmp48_ = possibility_size;
			cairo_set_font_size (c, _tmp48_);
			cairo_set_source_rgb (c, 0.0, 0.0, 0.0);
			_tmp49_ = self->priv->game;
			_tmp50_ = _tmp49_->board;
			_tmp51_ = self->priv->row;
			_tmp52_ = self->priv->col;
			_tmp54_ = sudoku_board_get_possibilities_as_bool_array (_tmp50_, _tmp51_, _tmp52_, &_tmp53_);
			possibilities = _tmp54_;
			possibilities_length1 = _tmp53_;
			_possibilities_size_ = possibilities_length1;
			_tmp55_ = self->priv->game;
			_tmp56_ = _tmp55_->board;
			_tmp57_ = sudoku_board_get_block_cols (_tmp56_);
			_tmp58_ = _tmp57_;
			height = gtk_widget_get_allocated_height ((GtkWidget*) self) / _tmp58_;
			_tmp59_ = self->priv->game;
			_tmp60_ = _tmp59_->board;
			_tmp61_ = sudoku_board_get_block_rows (_tmp60_);
			_tmp62_ = _tmp61_;
			width = gtk_widget_get_allocated_height ((GtkWidget*) self) / _tmp62_;
			num = 0;
			{
				gint row_tmp = 0;
				row_tmp = 0;
				{
					gboolean _tmp63_ = FALSE;
					_tmp63_ = TRUE;
					while (TRUE) {
						gint _tmp65_;
						SudokuGame* _tmp66_;
						SudokuBoard* _tmp67_;
						gint _tmp68_;
						gint _tmp69_;
						if (!_tmp63_) {
							gint _tmp64_;
							_tmp64_ = row_tmp;
							row_tmp = _tmp64_ + 1;
						}
						_tmp63_ = FALSE;
						_tmp65_ = row_tmp;
						_tmp66_ = self->priv->game;
						_tmp67_ = _tmp66_->board;
						_tmp68_ = sudoku_board_get_block_rows (_tmp67_);
						_tmp69_ = _tmp68_;
						if (!(_tmp65_ < _tmp69_)) {
							break;
						}
						{
							gint col_tmp = 0;
							col_tmp = 0;
							{
								gboolean _tmp70_ = FALSE;
								_tmp70_ = TRUE;
								while (TRUE) {
									gint _tmp72_;
									SudokuGame* _tmp73_;
									SudokuBoard* _tmp74_;
									gint _tmp75_;
									gint _tmp76_;
									gint _tmp77_;
									gboolean* _tmp78_;
									gint _tmp78__length1;
									gint _tmp79_;
									gboolean _tmp80_;
									if (!_tmp70_) {
										gint _tmp71_;
										_tmp71_ = col_tmp;
										col_tmp = _tmp71_ + 1;
									}
									_tmp70_ = FALSE;
									_tmp72_ = col_tmp;
									_tmp73_ = self->priv->game;
									_tmp74_ = _tmp73_->board;
									_tmp75_ = sudoku_board_get_block_cols (_tmp74_);
									_tmp76_ = _tmp75_;
									if (!(_tmp72_ < _tmp76_)) {
										break;
									}
									_tmp77_ = num;
									num = _tmp77_ + 1;
									_tmp78_ = possibilities;
									_tmp78__length1 = possibilities_length1;
									_tmp79_ = num;
									_tmp80_ = _tmp78_[_tmp79_ - 1];
									if (_tmp80_) {
										gint _tmp81_;
										gint _tmp82_;
										gint _tmp83_;
										gint _tmp84_;
										gdouble _tmp85_;
										gint _tmp86_;
										gchar* _tmp87_;
										gchar* _tmp88_;
										_tmp81_ = col_tmp;
										_tmp82_ = width;
										_tmp83_ = row_tmp;
										_tmp84_ = height;
										_tmp85_ = possibility_size;
										cairo_move_to (c, (gdouble) (_tmp81_ * _tmp82_), (_tmp83_ * _tmp84_) + _tmp85_);
										_tmp86_ = num;
										_tmp87_ = g_strdup_printf ("%d", _tmp86_);
										_tmp88_ = _tmp87_;
										cairo_show_text (c, _tmp88_);
										_g_free0 (_tmp88_);
									}
								}
							}
						}
					}
				}
			}
			possibilities = (g_free (possibilities), NULL);
		}
	}
	_tmp90_ = self->priv->_show_warnings;
	if (_tmp90_) {
		gboolean _tmp91_ = FALSE;
		gint _tmp92_;
		gint _tmp93_;
		_tmp92_ = sudoku_cell_view_get_value (self);
		_tmp93_ = _tmp92_;
		if (_tmp93_ == 0) {
			SudokuGame* _tmp94_;
			SudokuBoard* _tmp95_;
			gint _tmp96_;
			gint _tmp97_;
			_tmp94_ = self->priv->game;
			_tmp95_ = _tmp94_->board;
			_tmp96_ = self->priv->row;
			_tmp97_ = self->priv->col;
			_tmp91_ = sudoku_board_count_possibilities (_tmp95_, _tmp96_, _tmp97_) == 0;
		} else {
			_tmp91_ = FALSE;
		}
		_tmp89_ = _tmp91_;
	} else {
		_tmp89_ = FALSE;
	}
	if (_tmp89_) {
		gchar* warning = NULL;
		gchar* _tmp98_;
		cairo_text_extents_t extents = {0};
		const gchar* _tmp99_;
		cairo_text_extents_t _tmp100_ = {0};
		cairo_text_extents_t _tmp101_;
		gdouble _tmp102_;
		cairo_text_extents_t _tmp103_;
		gdouble _tmp104_;
		const gchar* _tmp105_;
		_tmp98_ = g_strdup ("X");
		warning = _tmp98_;
		cairo_set_font_size (c, (gdouble) (gtk_widget_get_allocated_height ((GtkWidget*) self) / 2));
		_tmp99_ = warning;
		cairo_text_extents (c, _tmp99_, &_tmp100_);
		extents = _tmp100_;
		_tmp101_ = extents;
		_tmp102_ = _tmp101_.width;
		_tmp103_ = extents;
		_tmp104_ = _tmp103_.height;
		cairo_move_to (c, ((gtk_widget_get_allocated_width ((GtkWidget*) self) - _tmp102_) / 2) - 1, ((gtk_widget_get_allocated_height ((GtkWidget*) self) + _tmp104_) / 2) + 1);
		cairo_set_source_rgb (c, 1.0, 0.0, 0.0);
		_tmp105_ = warning;
		cairo_show_text (c, _tmp105_);
		_g_free0 (warning);
	}
	result = FALSE;
	return result;
}


void
sudoku_cell_view_cell_changed_cb (SudokuCellView* self,
                                  gint row,
                                  gint col,
                                  gint old_val,
                                  gint new_val)
{
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->row;
	if (row == _tmp1_) {
		gint _tmp2_;
		_tmp2_ = self->priv->col;
		_tmp0_ = col == _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		SudokuGame* _tmp3_;
		GameMode _tmp4_;
		sudoku_cell_view_set_value (self, new_val);
		_tmp3_ = self->priv->game;
		_tmp4_ = _tmp3_->mode;
		if (_tmp4_ == GAME_MODE_CREATE) {
			gboolean _tmp5_;
			_tmp5_ = self->priv->_selected;
			if (_tmp5_) {
				sudoku_cell_view_set_background_color (self, &selected_bg_color);
			} else {
				GdkRGBA _tmp6_ = {0};
				gboolean _tmp7_;
				gboolean _tmp8_;
				_tmp7_ = sudoku_cell_view_get_is_fixed (self);
				_tmp8_ = _tmp7_;
				if (_tmp8_) {
					_tmp6_ = fixed_cell_color;
				} else {
					_tmp6_ = free_cell_color;
				}
				sudoku_cell_view_set_background_color (self, &_tmp6_);
			}
		}
		g_object_notify ((GObject*) self, "value");
	}
}


void
sudoku_cell_view_clear (SudokuCellView* self)
{
	SudokuGame* _tmp0_;
	SudokuBoard* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = _tmp0_->board;
	_tmp2_ = self->priv->row;
	_tmp3_ = self->priv->col;
	sudoku_board_disable_all_earmarks (_tmp1_, _tmp2_, _tmp3_);
}


gint
sudoku_cell_view_get_value (SudokuCellView* self)
{
	gint result;
	SudokuGame* _tmp0_;
	SudokuBoard* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->game;
	_tmp1_ = _tmp0_->board;
	_tmp2_ = self->priv->row;
	_tmp3_ = self->priv->col;
	result = sudoku_board_get (_tmp1_, _tmp2_, _tmp3_);
	return result;
}


void
sudoku_cell_view_set_value (SudokuCellView* self,
                            gint value)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	SudokuGame* _tmp31_;
	SudokuBoard* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	PangoLayout* _tmp42_;
	SudokuGame* _tmp43_;
	gint _tmp44_;
	gint _tmp45_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sudoku_cell_view_get_is_fixed (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gchar* text = NULL;
		SudokuGame* _tmp2_;
		SudokuBoard* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		PangoLayout* _tmp8_;
		PangoLayout* _tmp9_;
		GtkStyle* _tmp10_;
		GtkStyle* _tmp11_;
		PangoFontDescription* _tmp12_;
		SudokuGame* _tmp13_;
		GameMode _tmp14_;
		_tmp2_ = self->priv->game;
		_tmp3_ = _tmp2_->board;
		_tmp4_ = self->priv->row;
		_tmp5_ = self->priv->col;
		_tmp6_ = g_strdup_printf ("%d", sudoku_board_get (_tmp3_, _tmp4_, _tmp5_));
		text = _tmp6_;
		_tmp7_ = text;
		_tmp8_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp7_);
		_g_object_unref0 (self->priv->layout);
		self->priv->layout = _tmp8_;
		_tmp9_ = self->priv->layout;
		_tmp10_ = gtk_widget_get_style ((GtkWidget*) self);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_->font_desc;
		pango_layout_set_font_description (_tmp9_, _tmp12_);
		_tmp13_ = self->priv->game;
		_tmp14_ = _tmp13_->mode;
		if (_tmp14_ == GAME_MODE_PLAY) {
			_g_free0 (text);
			return;
		}
		_g_free0 (text);
	}
	if (value == 0) {
		gchar* text = NULL;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		PangoLayout* _tmp17_;
		PangoLayout* _tmp18_;
		GtkStyle* _tmp19_;
		GtkStyle* _tmp20_;
		PangoFontDescription* _tmp21_;
		SudokuGame* _tmp22_;
		SudokuBoard* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		SudokuGame* _tmp29_;
		GameMode _tmp30_;
		_tmp15_ = g_strdup ("");
		text = _tmp15_;
		_tmp16_ = text;
		_tmp17_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp16_);
		_g_object_unref0 (self->priv->layout);
		self->priv->layout = _tmp17_;
		_tmp18_ = self->priv->layout;
		_tmp19_ = gtk_widget_get_style ((GtkWidget*) self);
		_tmp20_ = _tmp19_;
		_tmp21_ = _tmp20_->font_desc;
		pango_layout_set_font_description (_tmp18_, _tmp21_);
		_tmp22_ = self->priv->game;
		_tmp23_ = _tmp22_->board;
		_tmp24_ = self->priv->row;
		_tmp25_ = self->priv->col;
		if (sudoku_board_get (_tmp23_, _tmp24_, _tmp25_) != 0) {
			SudokuGame* _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			_tmp26_ = self->priv->game;
			_tmp27_ = self->priv->row;
			_tmp28_ = self->priv->col;
			sudoku_game_remove (_tmp26_, _tmp27_, _tmp28_);
		}
		_tmp29_ = self->priv->game;
		_tmp30_ = _tmp29_->mode;
		if (_tmp30_ == GAME_MODE_PLAY) {
			_g_free0 (text);
			return;
		}
		_g_free0 (text);
	}
	_tmp31_ = self->priv->game;
	_tmp32_ = _tmp31_->board;
	_tmp33_ = self->priv->row;
	_tmp34_ = self->priv->col;
	if (value == sudoku_board_get (_tmp32_, _tmp33_, _tmp34_)) {
		gchar* text = NULL;
		gchar* _tmp35_;
		const gchar* _tmp36_;
		PangoLayout* _tmp37_;
		PangoLayout* _tmp38_;
		GtkStyle* _tmp39_;
		GtkStyle* _tmp40_;
		PangoFontDescription* _tmp41_;
		_tmp35_ = g_strdup_printf ("%d", value);
		text = _tmp35_;
		_tmp36_ = text;
		_tmp37_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp36_);
		_g_object_unref0 (self->priv->layout);
		self->priv->layout = _tmp37_;
		_tmp38_ = self->priv->layout;
		_tmp39_ = gtk_widget_get_style ((GtkWidget*) self);
		_tmp40_ = _tmp39_;
		_tmp41_ = _tmp40_->font_desc;
		pango_layout_set_font_description (_tmp38_, _tmp41_);
		_g_free0 (text);
		return;
	}
	_tmp42_ = self->priv->layout;
	_vala_assert (_tmp42_ != NULL, "layout != null");
	_tmp43_ = self->priv->game;
	_tmp44_ = self->priv->row;
	_tmp45_ = self->priv->col;
	sudoku_game_insert (_tmp43_, _tmp44_, _tmp45_, value);
	g_object_notify_by_pspec ((GObject *) self, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_VALUE_PROPERTY]);
}


gboolean
sudoku_cell_view_get_is_fixed (SudokuCellView* self)
{
	gboolean result;
	SudokuGame* _tmp0_;
	SudokuBoard* _tmp1_;
	gboolean* _tmp2_;
	gint _tmp2__length1;
	gint _tmp2__length2;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->game;
	_tmp1_ = _tmp0_->board;
	_tmp2_ = _tmp1_->is_fixed;
	_tmp2__length1 = _tmp1_->is_fixed_length1;
	_tmp2__length2 = _tmp1_->is_fixed_length2;
	_tmp3_ = self->priv->row;
	_tmp4_ = self->priv->col;
	_tmp5_ = _tmp2_[(_tmp3_ * _tmp2__length2) + _tmp4_];
	result = _tmp5_;
	return result;
}


gboolean
sudoku_cell_view_get_show_possibilities (SudokuCellView* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_possibilities;
	result = _tmp0_;
	return result;
}


void
sudoku_cell_view_set_show_possibilities (SudokuCellView* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_show_possibilities = value;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES_PROPERTY]);
}


gboolean
sudoku_cell_view_get_show_warnings (SudokuCellView* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_warnings;
	result = _tmp0_;
	return result;
}


void
sudoku_cell_view_set_show_warnings (SudokuCellView* self,
                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_show_warnings = value;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_SHOW_WARNINGS_PROPERTY]);
}


gboolean
sudoku_cell_view_get_selected (SudokuCellView* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_selected;
	result = _tmp0_;
	return result;
}


void
sudoku_cell_view_set_selected (SudokuCellView* self,
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	if (sudoku_cell_view_get_selected (self) != value) {
		self->priv->_selected = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_SELECTED_PROPERTY]);
	}
}


void
sudoku_cell_view_get_background_color (SudokuCellView* self,
                                       GdkRGBA * result)
{
	GdkRGBA _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_background_color;
	*result = _tmp0_;
	return;
}


static gboolean
_gdk_rgba_equal (const GdkRGBA * s1,
                 const GdkRGBA * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->red != s2->red) {
		return FALSE;
	}
	if (s1->green != s2->green) {
		return FALSE;
	}
	if (s1->blue != s2->blue) {
		return FALSE;
	}
	if (s1->alpha != s2->alpha) {
		return FALSE;
	}
	return TRUE;
}


void
sudoku_cell_view_set_background_color (SudokuCellView* self,
                                       GdkRGBA * value)
{
	GdkRGBA old_value;
	g_return_if_fail (self != NULL);
	if (_gdk_rgba_equal (value, (sudoku_cell_view_get_background_color (self, &old_value), &old_value)) != TRUE) {
		GdkRGBA _tmp0_;
		_tmp0_ = *value;
		self->priv->_background_color = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_BACKGROUND_COLOR_PROPERTY]);
	}
}


static void
sudoku_cell_view_class_init (SudokuCellViewClass * klass)
{
	sudoku_cell_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SudokuCellViewPrivate));
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*) (GtkWidget *, GdkEventButton*)) sudoku_cell_view_real_button_press_event;
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget *, GdkEventKey*)) sudoku_cell_view_real_key_press_event;
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget *, cairo_t*)) sudoku_cell_view_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_cell_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_cell_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = sudoku_cell_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_VALUE_PROPERTY, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_VALUE_PROPERTY] = g_param_spec_int ("value", "value", "value", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_IS_FIXED_PROPERTY, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_IS_FIXED_PROPERTY] = g_param_spec_boolean ("is-fixed", "is-fixed", "is-fixed", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES_PROPERTY, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES_PROPERTY] = g_param_spec_boolean ("show-possibilities", "show-possibilities", "show-possibilities", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_SHOW_WARNINGS_PROPERTY, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_SHOW_WARNINGS_PROPERTY] = g_param_spec_boolean ("show-warnings", "show-warnings", "show-warnings", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_SELECTED_PROPERTY, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_SELECTED_PROPERTY] = g_param_spec_boolean ("selected", "selected", "selected", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_BACKGROUND_COLOR_PROPERTY, sudoku_cell_view_properties[SUDOKU_CELL_VIEW_BACKGROUND_COLOR_PROPERTY] = g_param_spec_boxed ("background-color", "background-color", "background-color", gdk_rgba_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void
sudoku_cell_view_instance_init (SudokuCellView * self)
{
	self->priv = SUDOKU_CELL_VIEW_GET_PRIVATE (self);
	self->priv->size_ratio = (gdouble) 2;
	self->priv->_show_warnings = TRUE;
}


static void
sudoku_cell_view_finalize (GObject * obj)
{
	SudokuCellView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_CELL_VIEW, SudokuCellView);
	_g_object_unref0 (self->priv->layout);
	_g_object_unref0 (self->priv->popover);
	_g_object_unref0 (self->priv->earmark_popover);
	_g_object_unref0 (self->priv->game);
	_g_object_unref0 (self->priv->number_picker);
	_g_object_unref0 (self->priv->earmark_picker);
	G_OBJECT_CLASS (sudoku_cell_view_parent_class)->finalize (obj);
}


GType
sudoku_cell_view_get_type (void)
{
	static volatile gsize sudoku_cell_view_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_cell_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuCellViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_cell_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuCellView), 0, (GInstanceInitFunc) sudoku_cell_view_instance_init, NULL };
		GType sudoku_cell_view_type_id;
		sudoku_cell_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "SudokuCellView", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_cell_view_type_id__volatile, sudoku_cell_view_type_id);
	}
	return sudoku_cell_view_type_id__volatile;
}


static void
_vala_sudoku_cell_view_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	SudokuCellView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_CELL_VIEW, SudokuCellView);
	switch (property_id) {
		case SUDOKU_CELL_VIEW_VALUE_PROPERTY:
		g_value_set_int (value, sudoku_cell_view_get_value (self));
		break;
		case SUDOKU_CELL_VIEW_IS_FIXED_PROPERTY:
		g_value_set_boolean (value, sudoku_cell_view_get_is_fixed (self));
		break;
		case SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES_PROPERTY:
		g_value_set_boolean (value, sudoku_cell_view_get_show_possibilities (self));
		break;
		case SUDOKU_CELL_VIEW_SHOW_WARNINGS_PROPERTY:
		g_value_set_boolean (value, sudoku_cell_view_get_show_warnings (self));
		break;
		case SUDOKU_CELL_VIEW_SELECTED_PROPERTY:
		g_value_set_boolean (value, sudoku_cell_view_get_selected (self));
		break;
		case SUDOKU_CELL_VIEW_BACKGROUND_COLOR_PROPERTY:
		{
			GdkRGBA boxed;
			sudoku_cell_view_get_background_color (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_sudoku_cell_view_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	SudokuCellView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_CELL_VIEW, SudokuCellView);
	switch (property_id) {
		case SUDOKU_CELL_VIEW_VALUE_PROPERTY:
		sudoku_cell_view_set_value (self, g_value_get_int (value));
		break;
		case SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES_PROPERTY:
		sudoku_cell_view_set_show_possibilities (self, g_value_get_boolean (value));
		break;
		case SUDOKU_CELL_VIEW_SHOW_WARNINGS_PROPERTY:
		sudoku_cell_view_set_show_warnings (self, g_value_get_boolean (value));
		break;
		case SUDOKU_CELL_VIEW_SELECTED_PROPERTY:
		sudoku_cell_view_set_selected (self, g_value_get_boolean (value));
		break;
		case SUDOKU_CELL_VIEW_BACKGROUND_COLOR_PROPERTY:
		sudoku_cell_view_set_background_color (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
sudoku_view_set_selected (SudokuView* self,
                          gint cell_row,
                          gint cell_col)
{
	SudokuCellView** _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp1_;
	gint _tmp2_;
	SudokuCellView* _tmp3_;
	SudokuCellView** _tmp4_;
	gint _tmp4__length1;
	gint _tmp4__length2;
	gint _tmp5_;
	gint _tmp6_;
	SudokuCellView* _tmp7_;
	SudokuCellView** _tmp8_;
	gint _tmp8__length1;
	gint _tmp8__length2;
	gint _tmp9_;
	gint _tmp10_;
	SudokuCellView* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cells;
	_tmp0__length1 = self->priv->cells_length1;
	_tmp0__length2 = self->priv->cells_length2;
	_tmp1_ = self->priv->selected_row;
	_tmp2_ = self->priv->selected_col;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	sudoku_cell_view_set_selected (_tmp3_, FALSE);
	_tmp4_ = self->priv->cells;
	_tmp4__length1 = self->priv->cells_length1;
	_tmp4__length2 = self->priv->cells_length2;
	_tmp5_ = self->priv->selected_row;
	_tmp6_ = self->priv->selected_col;
	_tmp7_ = _tmp4_[(_tmp5_ * _tmp4__length2) + _tmp6_];
	gtk_widget_queue_draw ((GtkWidget*) _tmp7_);
	self->priv->selected_row = cell_row;
	self->priv->selected_col = cell_col;
	_tmp8_ = self->priv->cells;
	_tmp8__length1 = self->priv->cells_length1;
	_tmp8__length2 = self->priv->cells_length2;
	_tmp9_ = self->priv->selected_row;
	_tmp10_ = self->priv->selected_col;
	_tmp11_ = _tmp8_[(_tmp9_ * _tmp8__length2) + _tmp10_];
	sudoku_cell_view_set_selected (_tmp11_, TRUE);
}


static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		SudokuView* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->game);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static gboolean
_sudoku_view_draw_board_gtk_widget_draw (GtkWidget* _sender,
                                         cairo_t* cr,
                                         gpointer self)
{
	gboolean result;
	result = sudoku_view_draw_board ((SudokuView*) self, cr);
	return result;
}


static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		SudokuView* self;
		self = _data6_->_data5_->self;
		block5_data_unref (_data6_->_data5_);
		_data6_->_data5_ = NULL;
		g_slice_free (Block6Data, _data6_);
	}
}


static gboolean
________lambda13_ (Block6Data* _data6_)
{
	Block5Data* _data5_;
	SudokuView* self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	SudokuCellView** _tmp106_;
	gint _tmp106__length1;
	gint _tmp106__length2;
	gint _tmp107_;
	gint _tmp108_;
	SudokuCellView* _tmp109_;
	_data5_ = _data6_->_data5_;
	self = _data5_->self;
	_tmp0_ = sudoku_game_get_paused (_data5_->game);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = _data6_->cell_row;
	_tmp3_ = _data6_->cell_col;
	sudoku_view_set_selected (self, _tmp2_, _tmp3_);
	{
		gint col_tmp = 0;
		col_tmp = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_;
				SudokuBoard* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				GdkRGBA _tmp10_ = {0};
				gboolean _tmp11_ = FALSE;
				gint _tmp12_;
				gint _tmp13_;
				GdkRGBA color = {0};
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = col_tmp;
					col_tmp = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = col_tmp;
				_tmp7_ = _data5_->game->board;
				_tmp8_ = sudoku_board_get_cols (_tmp7_);
				_tmp9_ = _tmp8_;
				if (!(_tmp6_ < _tmp9_)) {
					break;
				}
				_tmp12_ = col_tmp;
				_tmp13_ = _data6_->cell_col;
				if (_tmp12_ == _tmp13_) {
					gboolean _tmp14_;
					_tmp14_ = self->priv->_highlighter;
					_tmp11_ = _tmp14_;
				} else {
					_tmp11_ = FALSE;
				}
				if (_tmp11_) {
					_tmp10_ = highlight_color;
				} else {
					_tmp10_ = free_cell_color;
				}
				color = _tmp10_;
				{
					gint row_tmp = 0;
					row_tmp = 0;
					{
						gboolean _tmp15_ = FALSE;
						_tmp15_ = TRUE;
						while (TRUE) {
							gint _tmp17_;
							SudokuBoard* _tmp18_;
							gint _tmp19_;
							gint _tmp20_;
							GdkRGBA _tmp21_ = {0};
							SudokuCellView** _tmp22_;
							gint _tmp22__length1;
							gint _tmp22__length2;
							gint _tmp23_;
							gint _tmp24_;
							SudokuCellView* _tmp25_;
							gboolean _tmp26_;
							gboolean _tmp27_;
							SudokuCellView** _tmp29_;
							gint _tmp29__length1;
							gint _tmp29__length2;
							gint _tmp30_;
							gint _tmp31_;
							SudokuCellView* _tmp32_;
							if (!_tmp15_) {
								gint _tmp16_;
								_tmp16_ = row_tmp;
								row_tmp = _tmp16_ + 1;
							}
							_tmp15_ = FALSE;
							_tmp17_ = row_tmp;
							_tmp18_ = _data5_->game->board;
							_tmp19_ = sudoku_board_get_rows (_tmp18_);
							_tmp20_ = _tmp19_;
							if (!(_tmp17_ < _tmp20_)) {
								break;
							}
							_tmp22_ = self->priv->cells;
							_tmp22__length1 = self->priv->cells_length1;
							_tmp22__length2 = self->priv->cells_length2;
							_tmp23_ = row_tmp;
							_tmp24_ = col_tmp;
							_tmp25_ = _tmp22_[(_tmp23_ * _tmp22__length2) + _tmp24_];
							_tmp26_ = sudoku_cell_view_get_is_fixed (_tmp25_);
							_tmp27_ = _tmp26_;
							if (_tmp27_) {
								_tmp21_ = fixed_cell_color;
							} else {
								GdkRGBA _tmp28_;
								_tmp28_ = color;
								_tmp21_ = _tmp28_;
							}
							_tmp29_ = self->priv->cells;
							_tmp29__length1 = self->priv->cells_length1;
							_tmp29__length2 = self->priv->cells_length2;
							_tmp30_ = row_tmp;
							_tmp31_ = col_tmp;
							_tmp32_ = _tmp29_[(_tmp30_ * _tmp29__length2) + _tmp31_];
							sudoku_cell_view_set_background_color (_tmp32_, &_tmp21_);
						}
					}
				}
			}
		}
	}
	{
		gint col_tmp = 0;
		col_tmp = 0;
		{
			gboolean _tmp33_ = FALSE;
			_tmp33_ = TRUE;
			while (TRUE) {
				gint _tmp35_;
				SudokuBoard* _tmp36_;
				gint _tmp37_;
				gint _tmp38_;
				SudokuCellView** _tmp39_;
				gint _tmp39__length1;
				gint _tmp39__length2;
				gint _tmp40_;
				gint _tmp41_;
				SudokuCellView* _tmp42_;
				gboolean _tmp43_;
				gboolean _tmp44_;
				if (!_tmp33_) {
					gint _tmp34_;
					_tmp34_ = col_tmp;
					col_tmp = _tmp34_ + 1;
				}
				_tmp33_ = FALSE;
				_tmp35_ = col_tmp;
				_tmp36_ = _data5_->game->board;
				_tmp37_ = sudoku_board_get_cols (_tmp36_);
				_tmp38_ = _tmp37_;
				if (!(_tmp35_ < _tmp38_)) {
					break;
				}
				_tmp39_ = self->priv->cells;
				_tmp39__length1 = self->priv->cells_length1;
				_tmp39__length2 = self->priv->cells_length2;
				_tmp40_ = _data6_->cell_row;
				_tmp41_ = col_tmp;
				_tmp42_ = _tmp39_[(_tmp40_ * _tmp39__length2) + _tmp41_];
				_tmp43_ = sudoku_cell_view_get_is_fixed (_tmp42_);
				_tmp44_ = _tmp43_;
				if (_tmp44_) {
					SudokuCellView** _tmp45_;
					gint _tmp45__length1;
					gint _tmp45__length2;
					gint _tmp46_;
					gint _tmp47_;
					SudokuCellView* _tmp48_;
					_tmp45_ = self->priv->cells;
					_tmp45__length1 = self->priv->cells_length1;
					_tmp45__length2 = self->priv->cells_length2;
					_tmp46_ = _data6_->cell_row;
					_tmp47_ = col_tmp;
					_tmp48_ = _tmp45_[(_tmp46_ * _tmp45__length2) + _tmp47_];
					sudoku_cell_view_set_background_color (_tmp48_, &fixed_cell_color);
				} else {
					gboolean _tmp49_;
					_tmp49_ = self->priv->_highlighter;
					if (_tmp49_) {
						SudokuCellView** _tmp50_;
						gint _tmp50__length1;
						gint _tmp50__length2;
						gint _tmp51_;
						gint _tmp52_;
						SudokuCellView* _tmp53_;
						_tmp50_ = self->priv->cells;
						_tmp50__length1 = self->priv->cells_length1;
						_tmp50__length2 = self->priv->cells_length2;
						_tmp51_ = _data6_->cell_row;
						_tmp52_ = col_tmp;
						_tmp53_ = _tmp50_[(_tmp51_ * _tmp50__length2) + _tmp52_];
						sudoku_cell_view_set_background_color (_tmp53_, &highlight_color);
					} else {
						SudokuCellView** _tmp54_;
						gint _tmp54__length1;
						gint _tmp54__length2;
						gint _tmp55_;
						gint _tmp56_;
						SudokuCellView* _tmp57_;
						_tmp54_ = self->priv->cells;
						_tmp54__length1 = self->priv->cells_length1;
						_tmp54__length2 = self->priv->cells_length2;
						_tmp55_ = _data6_->cell_row;
						_tmp56_ = col_tmp;
						_tmp57_ = _tmp54_[(_tmp55_ * _tmp54__length2) + _tmp56_];
						sudoku_cell_view_set_background_color (_tmp57_, &free_cell_color);
					}
				}
			}
		}
	}
	{
		GeeList* _coord_list = NULL;
		SudokuBoard* _tmp58_;
		GeeMap* _tmp59_;
		gint _tmp60_;
		SudokuBoard* _tmp61_;
		gint _tmp62_;
		gint _tmp63_;
		gint _tmp64_;
		SudokuBoard* _tmp65_;
		gint _tmp66_;
		gint _tmp67_;
		Coord _tmp68_ = {0};
		gpointer _tmp69_;
		gint _coord_size = 0;
		GeeList* _tmp70_;
		gint _tmp71_;
		gint _tmp72_;
		gint _coord_index = 0;
		_tmp58_ = _data5_->game->board;
		_tmp59_ = _tmp58_->coords_for_block;
		_tmp60_ = _data6_->cell_row;
		_tmp61_ = _data5_->game->board;
		_tmp62_ = sudoku_board_get_block_rows (_tmp61_);
		_tmp63_ = _tmp62_;
		_tmp64_ = _data6_->cell_col;
		_tmp65_ = _data5_->game->board;
		_tmp66_ = sudoku_board_get_block_cols (_tmp65_);
		_tmp67_ = _tmp66_;
		coord_init (&_tmp68_, _tmp60_ / _tmp63_, _tmp64_ / _tmp67_);
		_tmp69_ = gee_map_get (_tmp59_, &_tmp68_);
		_coord_list = (GeeList*) _tmp69_;
		_tmp70_ = _coord_list;
		_tmp71_ = gee_collection_get_size ((GeeCollection*) _tmp70_);
		_tmp72_ = _tmp71_;
		_coord_size = _tmp72_;
		_coord_index = -1;
		while (TRUE) {
			gint _tmp73_;
			gint _tmp74_;
			gint _tmp75_;
			Coord* coord = NULL;
			GeeList* _tmp76_;
			gint _tmp77_;
			gpointer _tmp78_;
			SudokuCellView** _tmp79_;
			gint _tmp79__length1;
			gint _tmp79__length2;
			Coord* _tmp80_;
			gint _tmp81_;
			Coord* _tmp82_;
			gint _tmp83_;
			SudokuCellView* _tmp84_;
			gboolean _tmp85_;
			gboolean _tmp86_;
			_tmp73_ = _coord_index;
			_coord_index = _tmp73_ + 1;
			_tmp74_ = _coord_index;
			_tmp75_ = _coord_size;
			if (!(_tmp74_ < _tmp75_)) {
				break;
			}
			_tmp76_ = _coord_list;
			_tmp77_ = _coord_index;
			_tmp78_ = gee_list_get (_tmp76_, _tmp77_);
			coord = (Coord*) _tmp78_;
			_tmp79_ = self->priv->cells;
			_tmp79__length1 = self->priv->cells_length1;
			_tmp79__length2 = self->priv->cells_length2;
			_tmp80_ = coord;
			_tmp81_ = (*_tmp80_).row;
			_tmp82_ = coord;
			_tmp83_ = (*_tmp82_).col;
			_tmp84_ = _tmp79_[(_tmp81_ * _tmp79__length2) + _tmp83_];
			_tmp85_ = sudoku_cell_view_get_is_fixed (_tmp84_);
			_tmp86_ = _tmp85_;
			if (_tmp86_) {
				SudokuCellView** _tmp87_;
				gint _tmp87__length1;
				gint _tmp87__length2;
				Coord* _tmp88_;
				gint _tmp89_;
				Coord* _tmp90_;
				gint _tmp91_;
				SudokuCellView* _tmp92_;
				_tmp87_ = self->priv->cells;
				_tmp87__length1 = self->priv->cells_length1;
				_tmp87__length2 = self->priv->cells_length2;
				_tmp88_ = coord;
				_tmp89_ = (*_tmp88_).row;
				_tmp90_ = coord;
				_tmp91_ = (*_tmp90_).col;
				_tmp92_ = _tmp87_[(_tmp89_ * _tmp87__length2) + _tmp91_];
				sudoku_cell_view_set_background_color (_tmp92_, &fixed_cell_color);
			} else {
				gboolean _tmp93_;
				_tmp93_ = self->priv->_highlighter;
				if (_tmp93_) {
					SudokuCellView** _tmp94_;
					gint _tmp94__length1;
					gint _tmp94__length2;
					Coord* _tmp95_;
					gint _tmp96_;
					Coord* _tmp97_;
					gint _tmp98_;
					SudokuCellView* _tmp99_;
					_tmp94_ = self->priv->cells;
					_tmp94__length1 = self->priv->cells_length1;
					_tmp94__length2 = self->priv->cells_length2;
					_tmp95_ = coord;
					_tmp96_ = (*_tmp95_).row;
					_tmp97_ = coord;
					_tmp98_ = (*_tmp97_).col;
					_tmp99_ = _tmp94_[(_tmp96_ * _tmp94__length2) + _tmp98_];
					sudoku_cell_view_set_background_color (_tmp99_, &highlight_color);
				} else {
					SudokuCellView** _tmp100_;
					gint _tmp100__length1;
					gint _tmp100__length2;
					Coord* _tmp101_;
					gint _tmp102_;
					Coord* _tmp103_;
					gint _tmp104_;
					SudokuCellView* _tmp105_;
					_tmp100_ = self->priv->cells;
					_tmp100__length1 = self->priv->cells_length1;
					_tmp100__length2 = self->priv->cells_length2;
					_tmp101_ = coord;
					_tmp102_ = (*_tmp101_).row;
					_tmp103_ = coord;
					_tmp104_ = (*_tmp103_).col;
					_tmp105_ = _tmp100_[(_tmp102_ * _tmp100__length2) + _tmp104_];
					sudoku_cell_view_set_background_color (_tmp105_, &free_cell_color);
				}
			}
			_g_free0 (coord);
		}
		_g_object_unref0 (_coord_list);
	}
	_tmp106_ = self->priv->cells;
	_tmp106__length1 = self->priv->cells_length1;
	_tmp106__length2 = self->priv->cells_length2;
	_tmp107_ = _data6_->cell_row;
	_tmp108_ = _data6_->cell_col;
	_tmp109_ = _tmp106_[(_tmp107_ * _tmp106__length2) + _tmp108_];
	sudoku_cell_view_set_background_color (_tmp109_, &selected_bg_color);
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = FALSE;
	return result;
}


static gboolean
_________lambda13__gtk_widget_focus_in_event (GtkWidget* _sender,
                                              GdkEventFocus* event,
                                              gpointer self)
{
	gboolean result;
	result = ________lambda13_ (self);
	return result;
}


static void
________lambda14_ (Block6Data* _data6_,
                   GObject* s,
                   GParamSpec* p)
{
	Block5Data* _data5_;
	SudokuView* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	_data5_ = _data6_->_data5_;
	self = _data5_->self;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp3_ = self->priv->_show_possibilities;
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp4_;
		_tmp4_ = self->priv->_show_warnings;
		_tmp2_ = _tmp4_;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		SudokuBoard* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = _data5_->game->board;
		_tmp6_ = sudoku_board_get_broken (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = _tmp7_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp8_;
		_tmp8_ = self->priv->previous_board_broken_state;
		_tmp0_ = _tmp8_;
	}
	if (_tmp0_) {
		SudokuBoard* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp9_ = _data5_->game->board;
		_tmp10_ = sudoku_board_get_broken (_tmp9_);
		_tmp11_ = _tmp10_;
		self->priv->previous_board_broken_state = _tmp11_;
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static void
_________lambda14__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self)
{
	________lambda14_ (self, _sender, pspec);
}


SudokuView*
sudoku_view_construct (GType object_type,
                       SudokuGame* game)
{
	SudokuView * self = NULL;
	Block5Data* _data5_;
	SudokuGame* _tmp0_;
	GtkOverlay* _tmp1_;
	GtkOverlay* _tmp2_;
	GtkDrawingArea* _tmp3_;
	GtkDrawingArea* _tmp4_;
	GtkGrid* _tmp5_;
	SudokuGame* _tmp8_;
	GtkGrid* _tmp9_;
	GtkGrid* _tmp10_;
	GtkGrid* _tmp11_;
	GtkGrid* _tmp12_;
	GtkGrid* _tmp13_;
	SudokuBoard* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	SudokuBoard* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	SudokuCellView** _tmp20_;
	GtkOverlay* _tmp55_;
	GtkDrawingArea* _tmp56_;
	GtkOverlay* _tmp57_;
	GtkGrid* _tmp58_;
	GtkDrawingArea* _tmp59_;
	GtkGrid* _tmp60_;
	GtkOverlay* _tmp61_;
	g_return_val_if_fail (game != NULL, NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (game);
	_g_object_unref0 (_data5_->game);
	_data5_->game = _tmp0_;
	self = (SudokuView*) g_object_new (object_type, NULL);
	_data5_->self = g_object_ref (self);
	gtk_frame_set_shadow_type ((GtkFrame*) self, GTK_SHADOW_NONE);
	g_object_set ((GtkAspectFrame*) self, "obey-child", FALSE, NULL);
	g_object_set ((GtkAspectFrame*) self, "ratio", (gfloat) 1, NULL);
	_tmp1_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->overlay);
	self->priv->overlay = _tmp1_;
	_tmp2_ = self->priv->overlay;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp2_);
	_tmp3_ = (GtkDrawingArea*) gtk_drawing_area_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->drawing);
	self->priv->drawing = _tmp3_;
	_tmp4_ = self->priv->drawing;
	g_signal_connect_object ((GtkWidget*) _tmp4_, "draw", (GCallback) _sudoku_view_draw_board_gtk_widget_draw, self, 0);
	_tmp5_ = self->priv->grid;
	if (_tmp5_ != NULL) {
		GtkOverlay* _tmp6_;
		GtkGrid* _tmp7_;
		_tmp6_ = self->priv->overlay;
		_tmp7_ = self->priv->grid;
		gtk_container_remove ((GtkContainer*) _tmp6_, (GtkWidget*) _tmp7_);
	}
	_tmp8_ = _g_object_ref0 (_data5_->game);
	_g_object_unref0 (self->game);
	self->game = _tmp8_;
	_tmp9_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->grid);
	self->priv->grid = _tmp9_;
	_tmp10_ = self->priv->grid;
	gtk_grid_set_row_spacing (_tmp10_, 1);
	_tmp11_ = self->priv->grid;
	gtk_grid_set_column_spacing (_tmp11_, 1);
	_tmp12_ = self->priv->grid;
	gtk_grid_set_column_homogeneous (_tmp12_, TRUE);
	_tmp13_ = self->priv->grid;
	gtk_grid_set_row_homogeneous (_tmp13_, TRUE);
	_tmp14_ = _data5_->game->board;
	_tmp15_ = sudoku_board_get_rows (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = _data5_->game->board;
	_tmp18_ = sudoku_board_get_cols (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_new0 (SudokuCellView*, (_tmp16_ * _tmp19_) + 1);
	self->priv->cells = (_vala_array_free (self->priv->cells, self->priv->cells_length1 * self->priv->cells_length2, (GDestroyNotify) g_object_unref), NULL);
	self->priv->cells = _tmp20_;
	self->priv->cells_length1 = _tmp16_;
	self->priv->cells_length2 = _tmp19_;
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp21_ = FALSE;
			_tmp21_ = TRUE;
			while (TRUE) {
				gint _tmp23_;
				SudokuBoard* _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				if (!_tmp21_) {
					gint _tmp22_;
					_tmp22_ = row;
					row = _tmp22_ + 1;
				}
				_tmp21_ = FALSE;
				_tmp23_ = row;
				_tmp24_ = _data5_->game->board;
				_tmp25_ = sudoku_board_get_rows (_tmp24_);
				_tmp26_ = _tmp25_;
				if (!(_tmp23_ < _tmp26_)) {
					break;
				}
				{
					gint col = 0;
					col = 0;
					{
						gboolean _tmp27_ = FALSE;
						_tmp27_ = TRUE;
						while (TRUE) {
							Block6Data* _data6_;
							gint _tmp29_;
							SudokuBoard* _tmp30_;
							gint _tmp31_;
							gint _tmp32_;
							SudokuCellView* cell = NULL;
							gint _tmp33_;
							gint _tmp34_;
							SudokuCellView* _tmp35_;
							gint _tmp36_;
							gint _tmp37_;
							GdkRGBA _tmp38_ = {0};
							SudokuCellView* _tmp39_;
							gboolean _tmp40_;
							gboolean _tmp41_;
							SudokuCellView* _tmp42_;
							SudokuCellView* _tmp43_;
							SudokuCellView* _tmp44_;
							SudokuCellView** _tmp45_;
							gint _tmp45__length1;
							gint _tmp45__length2;
							gint _tmp46_;
							gint _tmp47_;
							SudokuCellView* _tmp48_;
							SudokuCellView* _tmp49_;
							SudokuCellView* _tmp50_;
							GtkGrid* _tmp51_;
							SudokuCellView* _tmp52_;
							gint _tmp53_;
							gint _tmp54_;
							_data6_ = g_slice_new0 (Block6Data);
							_data6_->_ref_count_ = 1;
							_data6_->_data5_ = block5_data_ref (_data5_);
							if (!_tmp27_) {
								gint _tmp28_;
								_tmp28_ = col;
								col = _tmp28_ + 1;
							}
							_tmp27_ = FALSE;
							_tmp29_ = col;
							_tmp30_ = _data5_->game->board;
							_tmp31_ = sudoku_board_get_cols (_tmp30_);
							_tmp32_ = _tmp31_;
							if (!(_tmp29_ < _tmp32_)) {
								block6_data_unref (_data6_);
								_data6_ = NULL;
								break;
							}
							_tmp33_ = row;
							_tmp34_ = col;
							_tmp35_ = sudoku_cell_view_new (_tmp33_, _tmp34_, &self->game);
							g_object_ref_sink (_tmp35_);
							cell = _tmp35_;
							_tmp36_ = row;
							_data6_->cell_row = _tmp36_;
							_tmp37_ = col;
							_data6_->cell_col = _tmp37_;
							_tmp39_ = cell;
							_tmp40_ = sudoku_cell_view_get_is_fixed (_tmp39_);
							_tmp41_ = _tmp40_;
							if (_tmp41_) {
								_tmp38_ = fixed_cell_color;
							} else {
								_tmp38_ = free_cell_color;
							}
							_tmp42_ = cell;
							sudoku_cell_view_set_background_color (_tmp42_, &_tmp38_);
							_tmp43_ = cell;
							g_signal_connect_data ((GtkWidget*) _tmp43_, "focus-in-event", (GCallback) _________lambda13__gtk_widget_focus_in_event, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
							_tmp44_ = cell;
							g_signal_connect_data ((GObject*) _tmp44_, "notify::value", (GCallback) _________lambda14__g_object_notify, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
							_tmp45_ = self->priv->cells;
							_tmp45__length1 = self->priv->cells_length1;
							_tmp45__length2 = self->priv->cells_length2;
							_tmp46_ = row;
							_tmp47_ = col;
							_tmp48_ = cell;
							_tmp49_ = _g_object_ref0 (_tmp48_);
							_g_object_unref0 (_tmp45_[(_tmp46_ * _tmp45__length2) + _tmp47_]);
							_tmp45_[(_tmp46_ * _tmp45__length2) + _tmp47_] = _tmp49_;
							_tmp50_ = _tmp45_[(_tmp46_ * _tmp45__length2) + _tmp47_];
							_tmp51_ = self->priv->grid;
							_tmp52_ = cell;
							_tmp53_ = col;
							_tmp54_ = row;
							gtk_grid_attach (_tmp51_, (GtkWidget*) _tmp52_, _tmp53_, _tmp54_, 1, 1);
							_g_object_unref0 (cell);
							block6_data_unref (_data6_);
							_data6_ = NULL;
						}
					}
				}
			}
		}
	}
	_tmp55_ = self->priv->overlay;
	_tmp56_ = self->priv->drawing;
	gtk_container_add ((GtkContainer*) _tmp55_, (GtkWidget*) _tmp56_);
	_tmp57_ = self->priv->overlay;
	_tmp58_ = self->priv->grid;
	gtk_overlay_add_overlay (_tmp57_, (GtkWidget*) _tmp58_);
	_tmp59_ = self->priv->drawing;
	gtk_widget_show ((GtkWidget*) _tmp59_);
	_tmp60_ = self->priv->grid;
	gtk_widget_show_all ((GtkWidget*) _tmp60_);
	_tmp61_ = self->priv->overlay;
	gtk_widget_show ((GtkWidget*) _tmp61_);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return self;
}


SudokuView*
sudoku_view_new (SudokuGame* game)
{
	return sudoku_view_construct (TYPE_SUDOKU_VIEW, game);
}


static gboolean
sudoku_view_draw_board (SudokuView* self,
                        cairo_t* c)
{
	gboolean result = FALSE;
	gint board_length = 0;
	GtkGrid* _tmp0_;
	gdouble tile_length = 0.0;
	gint _tmp1_;
	SudokuGame* _tmp2_;
	SudokuBoard* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	SudokuGame* _tmp107_;
	gboolean _tmp108_;
	gboolean _tmp109_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = self->priv->grid;
	board_length = gtk_widget_get_allocated_width ((GtkWidget*) _tmp0_);
	_tmp1_ = board_length;
	_tmp2_ = self->game;
	_tmp3_ = _tmp2_->board;
	_tmp4_ = sudoku_board_get_cols (_tmp3_);
	_tmp5_ = _tmp4_;
	tile_length = ((gdouble) (_tmp1_ - 1)) / _tmp5_;
	if (gtk_widget_get_default_direction () == GTK_TEXT_DIR_RTL) {
		gint _tmp6_;
		_tmp6_ = board_length;
		cairo_translate (c, (gdouble) _tmp6_, (gdouble) 0);
		cairo_scale (c, (gdouble) -1, (gdouble) 1);
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint _tmp9_;
				SudokuGame* _tmp10_;
				SudokuBoard* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = i;
				_tmp10_ = self->game;
				_tmp11_ = _tmp10_->board;
				_tmp12_ = sudoku_board_get_cols (_tmp11_);
				_tmp13_ = _tmp12_;
				if (!(_tmp9_ < _tmp13_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp14_ = FALSE;
						_tmp14_ = TRUE;
						while (TRUE) {
							gint _tmp16_;
							SudokuGame* _tmp17_;
							SudokuBoard* _tmp18_;
							gint _tmp19_;
							gint _tmp20_;
							GdkRGBA background_color = {0};
							SudokuCellView** _tmp21_;
							gint _tmp21__length1;
							gint _tmp21__length2;
							gint _tmp22_;
							gint _tmp23_;
							SudokuCellView* _tmp24_;
							GdkRGBA _tmp25_ = {0};
							GdkRGBA _tmp26_;
							GdkRGBA _tmp27_;
							gdouble _tmp28_;
							GdkRGBA _tmp29_;
							gdouble _tmp30_;
							GdkRGBA _tmp31_;
							gdouble _tmp32_;
							gint _tmp33_;
							gdouble _tmp34_;
							gint _tmp35_;
							gdouble _tmp36_;
							gint _tmp37_;
							gdouble _tmp38_;
							gint _tmp39_;
							gdouble _tmp40_;
							if (!_tmp14_) {
								gint _tmp15_;
								_tmp15_ = j;
								j = _tmp15_ + 1;
							}
							_tmp14_ = FALSE;
							_tmp16_ = j;
							_tmp17_ = self->game;
							_tmp18_ = _tmp17_->board;
							_tmp19_ = sudoku_board_get_cols (_tmp18_);
							_tmp20_ = _tmp19_;
							if (!(_tmp16_ < _tmp20_)) {
								break;
							}
							_tmp21_ = self->priv->cells;
							_tmp21__length1 = self->priv->cells_length1;
							_tmp21__length2 = self->priv->cells_length2;
							_tmp22_ = i;
							_tmp23_ = j;
							_tmp24_ = _tmp21_[(_tmp22_ * _tmp21__length2) + _tmp23_];
							sudoku_cell_view_get_background_color (_tmp24_, &_tmp25_);
							_tmp26_ = _tmp25_;
							background_color = _tmp26_;
							_tmp27_ = background_color;
							_tmp28_ = _tmp27_.red;
							_tmp29_ = background_color;
							_tmp30_ = _tmp29_.green;
							_tmp31_ = background_color;
							_tmp32_ = _tmp31_.blue;
							cairo_set_source_rgb (c, _tmp28_, _tmp30_, _tmp32_);
							_tmp33_ = j;
							_tmp34_ = tile_length;
							_tmp35_ = i;
							_tmp36_ = tile_length;
							_tmp37_ = j;
							_tmp38_ = tile_length;
							_tmp39_ = i;
							_tmp40_ = tile_length;
							cairo_rectangle (c, ((gint) (_tmp33_ * _tmp34_)) + 0.5, ((gint) (_tmp35_ * _tmp36_)) + 0.5, ((gint) ((_tmp37_ + 1) * _tmp38_)) + 0.5, ((gint) ((_tmp39_ + 1) * _tmp40_)) + 0.5);
							cairo_fill (c);
						}
					}
				}
			}
		}
	}
	cairo_set_line_width (c, (gdouble) 1);
	cairo_set_source_rgb (c, 0.6, 0.6, 0.6);
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp41_ = FALSE;
			_tmp41_ = TRUE;
			while (TRUE) {
				gint _tmp43_;
				SudokuGame* _tmp44_;
				SudokuBoard* _tmp45_;
				gint _tmp46_;
				gint _tmp47_;
				gint _tmp48_;
				SudokuGame* _tmp49_;
				SudokuBoard* _tmp50_;
				gint _tmp51_;
				gint _tmp52_;
				gint _tmp53_;
				gdouble _tmp54_;
				gint _tmp55_;
				gdouble _tmp56_;
				gint _tmp57_;
				if (!_tmp41_) {
					gint _tmp42_;
					_tmp42_ = i;
					i = _tmp42_ + 1;
				}
				_tmp41_ = FALSE;
				_tmp43_ = i;
				_tmp44_ = self->game;
				_tmp45_ = _tmp44_->board;
				_tmp46_ = sudoku_board_get_cols (_tmp45_);
				_tmp47_ = _tmp46_;
				if (!(_tmp43_ < _tmp47_)) {
					break;
				}
				_tmp48_ = i;
				_tmp49_ = self->game;
				_tmp50_ = _tmp49_->board;
				_tmp51_ = sudoku_board_get_block_cols (_tmp50_);
				_tmp52_ = _tmp51_;
				if ((_tmp48_ % _tmp52_) == 0) {
					continue;
				}
				_tmp53_ = i;
				_tmp54_ = tile_length;
				cairo_move_to (c, ((gint) (_tmp53_ * _tmp54_)) + 0.5, (gdouble) 1);
				_tmp55_ = i;
				_tmp56_ = tile_length;
				_tmp57_ = board_length;
				cairo_line_to (c, ((gint) (_tmp55_ * _tmp56_)) + 0.5, (gdouble) _tmp57_);
			}
		}
	}
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp58_ = FALSE;
			_tmp58_ = TRUE;
			while (TRUE) {
				gint _tmp60_;
				SudokuGame* _tmp61_;
				SudokuBoard* _tmp62_;
				gint _tmp63_;
				gint _tmp64_;
				gint _tmp65_;
				SudokuGame* _tmp66_;
				SudokuBoard* _tmp67_;
				gint _tmp68_;
				gint _tmp69_;
				gint _tmp70_;
				gdouble _tmp71_;
				gint _tmp72_;
				gint _tmp73_;
				gdouble _tmp74_;
				if (!_tmp58_) {
					gint _tmp59_;
					_tmp59_ = i;
					i = _tmp59_ + 1;
				}
				_tmp58_ = FALSE;
				_tmp60_ = i;
				_tmp61_ = self->game;
				_tmp62_ = _tmp61_->board;
				_tmp63_ = sudoku_board_get_cols (_tmp62_);
				_tmp64_ = _tmp63_;
				if (!(_tmp60_ < _tmp64_)) {
					break;
				}
				_tmp65_ = i;
				_tmp66_ = self->game;
				_tmp67_ = _tmp66_->board;
				_tmp68_ = sudoku_board_get_block_rows (_tmp67_);
				_tmp69_ = _tmp68_;
				if ((_tmp65_ % _tmp69_) == 0) {
					continue;
				}
				_tmp70_ = i;
				_tmp71_ = tile_length;
				cairo_move_to (c, (gdouble) 1, ((gint) (_tmp70_ * _tmp71_)) + 0.5);
				_tmp72_ = board_length;
				_tmp73_ = i;
				_tmp74_ = tile_length;
				cairo_line_to (c, (gdouble) _tmp72_, ((gint) (_tmp73_ * _tmp74_)) + 0.5);
			}
		}
	}
	cairo_stroke (c);
	cairo_set_line_width (c, (gdouble) 2);
	cairo_set_source_rgb (c, 0.0, 0.0, 0.0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp75_ = FALSE;
			_tmp75_ = TRUE;
			while (TRUE) {
				gint _tmp81_;
				SudokuGame* _tmp82_;
				SudokuBoard* _tmp83_;
				gint _tmp84_;
				gint _tmp85_;
				gint _tmp86_;
				gdouble _tmp87_;
				gint _tmp88_;
				gdouble _tmp89_;
				gint _tmp90_;
				if (!_tmp75_) {
					gint _tmp76_;
					SudokuGame* _tmp77_;
					SudokuBoard* _tmp78_;
					gint _tmp79_;
					gint _tmp80_;
					_tmp76_ = i;
					_tmp77_ = self->game;
					_tmp78_ = _tmp77_->board;
					_tmp79_ = sudoku_board_get_block_cols (_tmp78_);
					_tmp80_ = _tmp79_;
					i = _tmp76_ + _tmp80_;
				}
				_tmp75_ = FALSE;
				_tmp81_ = i;
				_tmp82_ = self->game;
				_tmp83_ = _tmp82_->board;
				_tmp84_ = sudoku_board_get_cols (_tmp83_);
				_tmp85_ = _tmp84_;
				if (!(_tmp81_ <= _tmp85_)) {
					break;
				}
				_tmp86_ = i;
				_tmp87_ = tile_length;
				cairo_move_to (c, ((gint) (_tmp86_ * _tmp87_)) + 0.5, (gdouble) 0);
				_tmp88_ = i;
				_tmp89_ = tile_length;
				_tmp90_ = board_length;
				cairo_line_to (c, ((gint) (_tmp88_ * _tmp89_)) + 0.5, (gdouble) _tmp90_);
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp91_ = FALSE;
			_tmp91_ = TRUE;
			while (TRUE) {
				gint _tmp97_;
				SudokuGame* _tmp98_;
				SudokuBoard* _tmp99_;
				gint _tmp100_;
				gint _tmp101_;
				gint _tmp102_;
				gdouble _tmp103_;
				gint _tmp104_;
				gint _tmp105_;
				gdouble _tmp106_;
				if (!_tmp91_) {
					gint _tmp92_;
					SudokuGame* _tmp93_;
					SudokuBoard* _tmp94_;
					gint _tmp95_;
					gint _tmp96_;
					_tmp92_ = i;
					_tmp93_ = self->game;
					_tmp94_ = _tmp93_->board;
					_tmp95_ = sudoku_board_get_block_rows (_tmp94_);
					_tmp96_ = _tmp95_;
					i = _tmp92_ + _tmp96_;
				}
				_tmp91_ = FALSE;
				_tmp97_ = i;
				_tmp98_ = self->game;
				_tmp99_ = _tmp98_->board;
				_tmp100_ = sudoku_board_get_cols (_tmp99_);
				_tmp101_ = _tmp100_;
				if (!(_tmp97_ <= _tmp101_)) {
					break;
				}
				_tmp102_ = i;
				_tmp103_ = tile_length;
				cairo_move_to (c, (gdouble) 0, ((gint) (_tmp102_ * _tmp103_)) + 0.5);
				_tmp104_ = board_length;
				_tmp105_ = i;
				_tmp106_ = tile_length;
				cairo_line_to (c, (gdouble) _tmp104_, ((gint) (_tmp105_ * _tmp106_)) + 0.5);
			}
		}
	}
	cairo_stroke (c);
	_tmp107_ = self->game;
	_tmp108_ = sudoku_game_get_paused (_tmp107_);
	_tmp109_ = _tmp108_;
	if (_tmp109_) {
		gchar* text = NULL;
		gchar* _tmp110_;
		cairo_text_extents_t extents = {0};
		const gchar* _tmp111_;
		cairo_text_extents_t _tmp112_ = {0};
		gint _tmp113_;
		cairo_text_extents_t _tmp114_;
		gdouble _tmp115_;
		gint _tmp116_;
		cairo_text_extents_t _tmp117_;
		gdouble _tmp118_;
		const gchar* _tmp119_;
		cairo_set_source_rgba (c, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.75);
		cairo_paint (c);
		cairo_select_font_face (c, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
		cairo_set_font_size (c, gtk_widget_get_allocated_width ((GtkWidget*) self) * 0.125);
		_tmp110_ = g_strdup (_ ("Paused"));
		text = _tmp110_;
		_tmp111_ = text;
		cairo_text_extents (c, _tmp111_, &_tmp112_);
		extents = _tmp112_;
		_tmp113_ = board_length;
		_tmp114_ = extents;
		_tmp115_ = _tmp114_.width;
		_tmp116_ = board_length;
		_tmp117_ = extents;
		_tmp118_ = _tmp117_.height;
		cairo_move_to (c, (_tmp113_ / 2.0) - (_tmp115_ / 2.0), (_tmp116_ / 2.0) + (_tmp118_ / 2.0));
		cairo_set_source_rgb (c, (gdouble) 1, (gdouble) 1, (gdouble) 1);
		_tmp119_ = text;
		cairo_show_text (c, _tmp119_);
		_g_free0 (text);
	}
	result = FALSE;
	return result;
}


void
sudoku_view_clear (SudokuView* self)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				SudokuGame* _tmp3_;
				SudokuBoard* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->game;
				_tmp4_ = _tmp3_->board;
				_tmp5_ = sudoku_board_get_rows (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp2_ < _tmp6_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp7_ = FALSE;
						_tmp7_ = TRUE;
						while (TRUE) {
							gint _tmp9_;
							SudokuGame* _tmp10_;
							SudokuBoard* _tmp11_;
							gint _tmp12_;
							gint _tmp13_;
							SudokuCellView** _tmp14_;
							gint _tmp14__length1;
							gint _tmp14__length2;
							gint _tmp15_;
							gint _tmp16_;
							SudokuCellView* _tmp17_;
							if (!_tmp7_) {
								gint _tmp8_;
								_tmp8_ = j;
								j = _tmp8_ + 1;
							}
							_tmp7_ = FALSE;
							_tmp9_ = j;
							_tmp10_ = self->game;
							_tmp11_ = _tmp10_->board;
							_tmp12_ = sudoku_board_get_cols (_tmp11_);
							_tmp13_ = _tmp12_;
							if (!(_tmp9_ < _tmp13_)) {
								break;
							}
							_tmp14_ = self->priv->cells;
							_tmp14__length1 = self->priv->cells_length1;
							_tmp14__length2 = self->priv->cells_length2;
							_tmp15_ = i;
							_tmp16_ = j;
							_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
							sudoku_cell_view_clear (_tmp17_);
						}
					}
				}
			}
		}
	}
}


gboolean
sudoku_view_get_show_warnings (SudokuView* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_warnings;
	result = _tmp0_;
	return result;
}


void
sudoku_view_set_show_warnings (SudokuView* self,
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_show_warnings = value;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				SudokuGame* _tmp3_;
				SudokuBoard* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->game;
				_tmp4_ = _tmp3_->board;
				_tmp5_ = sudoku_board_get_rows (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp2_ < _tmp6_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp7_ = FALSE;
						_tmp7_ = TRUE;
						while (TRUE) {
							gint _tmp9_;
							SudokuGame* _tmp10_;
							SudokuBoard* _tmp11_;
							gint _tmp12_;
							gint _tmp13_;
							SudokuCellView** _tmp14_;
							gint _tmp14__length1;
							gint _tmp14__length2;
							gint _tmp15_;
							gint _tmp16_;
							SudokuCellView* _tmp17_;
							gboolean _tmp18_;
							if (!_tmp7_) {
								gint _tmp8_;
								_tmp8_ = j;
								j = _tmp8_ + 1;
							}
							_tmp7_ = FALSE;
							_tmp9_ = j;
							_tmp10_ = self->game;
							_tmp11_ = _tmp10_->board;
							_tmp12_ = sudoku_board_get_cols (_tmp11_);
							_tmp13_ = _tmp12_;
							if (!(_tmp9_ < _tmp13_)) {
								break;
							}
							_tmp14_ = self->priv->cells;
							_tmp14__length1 = self->priv->cells_length1;
							_tmp14__length2 = self->priv->cells_length2;
							_tmp15_ = i;
							_tmp16_ = j;
							_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
							_tmp18_ = self->priv->_show_warnings;
							sudoku_cell_view_set_show_warnings (_tmp17_, _tmp18_);
						}
					}
				}
			}
		}
	}
	g_object_notify_by_pspec ((GObject *) self, sudoku_view_properties[SUDOKU_VIEW_SHOW_WARNINGS_PROPERTY]);
}


gboolean
sudoku_view_get_show_possibilities (SudokuView* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_possibilities;
	result = _tmp0_;
	return result;
}


void
sudoku_view_set_show_possibilities (SudokuView* self,
                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_show_possibilities = value;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				SudokuGame* _tmp3_;
				SudokuBoard* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->game;
				_tmp4_ = _tmp3_->board;
				_tmp5_ = sudoku_board_get_rows (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp2_ < _tmp6_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp7_ = FALSE;
						_tmp7_ = TRUE;
						while (TRUE) {
							gint _tmp9_;
							SudokuGame* _tmp10_;
							SudokuBoard* _tmp11_;
							gint _tmp12_;
							gint _tmp13_;
							SudokuCellView** _tmp14_;
							gint _tmp14__length1;
							gint _tmp14__length2;
							gint _tmp15_;
							gint _tmp16_;
							SudokuCellView* _tmp17_;
							if (!_tmp7_) {
								gint _tmp8_;
								_tmp8_ = j;
								j = _tmp8_ + 1;
							}
							_tmp7_ = FALSE;
							_tmp9_ = j;
							_tmp10_ = self->game;
							_tmp11_ = _tmp10_->board;
							_tmp12_ = sudoku_board_get_cols (_tmp11_);
							_tmp13_ = _tmp12_;
							if (!(_tmp9_ < _tmp13_)) {
								break;
							}
							_tmp14_ = self->priv->cells;
							_tmp14__length1 = self->priv->cells_length1;
							_tmp14__length2 = self->priv->cells_length2;
							_tmp15_ = i;
							_tmp16_ = j;
							_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
							sudoku_cell_view_set_show_possibilities (_tmp17_, value);
						}
					}
				}
			}
		}
	}
	g_object_notify_by_pspec ((GObject *) self, sudoku_view_properties[SUDOKU_VIEW_SHOW_POSSIBILITIES_PROPERTY]);
}


gboolean
sudoku_view_get_highlighter (SudokuView* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_highlighter;
	result = _tmp0_;
	return result;
}


void
sudoku_view_set_highlighter (SudokuView* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_highlighter = value;
	g_object_notify_by_pspec ((GObject *) self, sudoku_view_properties[SUDOKU_VIEW_HIGHLIGHTER_PROPERTY]);
}


static void
sudoku_view_class_init (SudokuViewClass * klass)
{
	sudoku_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SudokuViewPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = sudoku_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_SHOW_WARNINGS_PROPERTY, sudoku_view_properties[SUDOKU_VIEW_SHOW_WARNINGS_PROPERTY] = g_param_spec_boolean ("show-warnings", "show-warnings", "show-warnings", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_SHOW_POSSIBILITIES_PROPERTY, sudoku_view_properties[SUDOKU_VIEW_SHOW_POSSIBILITIES_PROPERTY] = g_param_spec_boolean ("show-possibilities", "show-possibilities", "show-possibilities", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_HIGHLIGHTER_PROPERTY, sudoku_view_properties[SUDOKU_VIEW_HIGHLIGHTER_PROPERTY] = g_param_spec_boolean ("highlighter", "highlighter", "highlighter", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void
sudoku_view_instance_init (SudokuView * self)
{
	self->priv = SUDOKU_VIEW_GET_PRIVATE (self);
	self->priv->previous_board_broken_state = FALSE;
	self->priv->selected_row = 0;
	self->priv->selected_col = 0;
	self->priv->_show_warnings = FALSE;
	self->priv->_show_possibilities = FALSE;
	self->priv->_highlighter = FALSE;
}


static void
sudoku_view_finalize (GObject * obj)
{
	SudokuView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_VIEW, SudokuView);
	_g_object_unref0 (self->game);
	self->priv->cells = (_vala_array_free (self->priv->cells, self->priv->cells_length1 * self->priv->cells_length2, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->overlay);
	_g_object_unref0 (self->priv->drawing);
	_g_object_unref0 (self->priv->grid);
	G_OBJECT_CLASS (sudoku_view_parent_class)->finalize (obj);
}


GType
sudoku_view_get_type (void)
{
	static volatile gsize sudoku_view_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuView), 0, (GInstanceInitFunc) sudoku_view_instance_init, NULL };
		GType sudoku_view_type_id;
		sudoku_view_type_id = g_type_register_static (gtk_aspect_frame_get_type (), "SudokuView", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_view_type_id__volatile, sudoku_view_type_id);
	}
	return sudoku_view_type_id__volatile;
}


static void
_vala_sudoku_view_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	SudokuView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_VIEW, SudokuView);
	switch (property_id) {
		case SUDOKU_VIEW_SHOW_WARNINGS_PROPERTY:
		g_value_set_boolean (value, sudoku_view_get_show_warnings (self));
		break;
		case SUDOKU_VIEW_SHOW_POSSIBILITIES_PROPERTY:
		g_value_set_boolean (value, sudoku_view_get_show_possibilities (self));
		break;
		case SUDOKU_VIEW_HIGHLIGHTER_PROPERTY:
		g_value_set_boolean (value, sudoku_view_get_highlighter (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_sudoku_view_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	SudokuView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_VIEW, SudokuView);
	switch (property_id) {
		case SUDOKU_VIEW_SHOW_WARNINGS_PROPERTY:
		sudoku_view_set_show_warnings (self, g_value_get_boolean (value));
		break;
		case SUDOKU_VIEW_SHOW_POSSIBILITIES_PROPERTY:
		sudoku_view_set_show_possibilities (self, g_value_get_boolean (value));
		break;
		case SUDOKU_VIEW_HIGHLIGHTER_PROPERTY:
		sudoku_view_set_highlighter (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



