#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#include "version.h"

typedef struct preferences_t {
    int leading; /* leading width */
    int marginx, marginy; /* margin around text */
    char *font[NUMFONTS];
    unsigned long forecolor;
    unsigned long backcolor;
    unsigned long textcolor[NUMFONTS];
    unsigned long greycolor;
    int paging; /* flag: use "[MORE]" and pause while paging? */
    int inputattr; /* style for input (absolute, not additive) */
    int fulljustify; /* flag: full-justify text window? */
    int autoresize; /* flag: automatically resize status window? */
    int resizeupward; /* flag: resize status window upward rather than down? */
    int autoclear; /* flag: automatically clear anything below status line? */
    int historylength; /* lines in command history */
    long buffersize; /* how much stuff to save, minimum */
    long bufferslack; /* how much to save (over the minumum) before trimming */
    int winx, winy; /* geometry stuff */
    int winw, winh; /* geometry stuff */
    int statwinx, statwiny;
    int statwid, stathgt; /* in chars */
} preferences;

#ifdef __STDC__
typedef void (*cmdfunc_ptr)(int operand);
#else
typedef void (*cmdfunc_ptr)();
#endif

typedef struct cmdentry_t {
    cmdfunc_ptr func;
    int operand;
    int ignoremods;
    char *name;
} cmdentry;

extern int xioscn;
extern Display *xiodpy;
extern Window xiowin, xioswin;
extern int xiodepth;
extern int xiobackstore;
extern GC gcblack, gcwhite, gcgrey, gcflip; 
extern GC gcfont[NUMFONTS];
extern GC gcsblack, gcsflip; 
extern GC gcsfont[NUMFONTS], gcsnegfont[NUMFONTS];
extern XFontStruct *fontstr[NUMFONTS]; 
extern int spacewidth[NUMFONTS]; 
extern int lineheight, lineheightoff;
extern preferences prefs;

extern cmdentry *keycmds[];
extern char *keycmdargs[];

#define keytype_main (0)
#define keytype_meta (256)
#define keytype_sym  (512)
#define keytype_Mask (768)

#ifdef __STDC__

extern void xinit_openconnection();
extern void xio_pause();

extern void xtext_init();
extern void xtext_add(char ch, long pos);
extern void xtext_replace(long pos, long oldlen, char *buf, long newlen);
extern void xtext_setstyle(long pos, int attr);
extern void xtext_layout();
extern void xtext_resize(int xpos, int ypos, int width, int height);
extern void xtext_redraw();
extern void xtext_hitdown(int xpos, int ypos, unsigned int button, unsigned int mods, int clicknum);
extern void xtext_hitmove(int xpos, int ypos, unsigned int button, unsigned int mods, int clicknum);
extern void xtext_hitup(int xpos, int ypos, unsigned int button, unsigned int mods, int clicknum);
extern void xtext_end_visible();
extern void xtext_set_lastseen();
extern void xtext_clear_window();
extern void xtext_line_timeout();

extern void xkey_init();
extern char *xkey_get_key_name(int key);
extern void xkey_parse_bindings(char *str);
extern cmdentry *xkey_find_cmd_by_name(char *str);

extern void xmess_init();
extern void xmess_resize(int xpos, int ypos, int width, int height);
extern void xmess_redraw();
extern void xmess_set_message(char *str, int sticky);
extern void xmess_check_timeout();

extern void xstat_init(int cols, int rows, int xpos, int ypos);
extern void xstat_redraw();
extern void xstat_layout();
extern void xstat_insert(int ch);
extern void xstat_setattr(int attr);
extern void xstat_newline();
extern void xstat_getpos(int *row, int *col);
extern void xstat_setpos(int row, int col);
extern void xstat_set_window_size(int lines);
extern void xstat_clear_window();
extern void xstat_newgeometry(int newx, int newy, int newwid, int newhgt);
extern void xstat_set_dot_active(int visible);

#else

extern void xinit_openconnection();
extern void xio_pause();

extern void xtext_init();
extern void xtext_add();
extern void xtext_replace();
extern void xtext_setstyle();
extern void xtext_layout();
extern void xtext_resize();
extern void xtext_redraw();
extern void xtext_hitdown();
extern void xtext_hitmove();
extern void xtext_hitup();
extern void xtext_end_visible();
extern void xtext_set_lastseen();
extern void xtext_clear_window();
extern void xtext_line_timeout();

extern void xkey_init();
extern char *xkey_get_key_name();
extern void xkey_parse_bindings();
extern cmdentry *xkey_find_cmd_by_name();

extern void xmess_init();
extern void xmess_resize();
extern void xmess_redraw();
extern void xmess_set_message();
extern void xmess_check_timeout();

extern void xstat_init();
extern void xstat_redraw();
extern void xstat_layout();
extern void xstat_insert();
extern void xstat_setattr();
extern void xstat_newline();
extern void xstat_getpos();
extern void xstat_setpos();
extern void xstat_set_window_size();
extern void xstat_clear_window();
extern void xstat_newgeometry();
extern void xstat_set_dot_active();

#endif

/* for cutbuf */
#define op_Yank 1
#define op_Wipe 2
#define op_Copy 3
#define op_YankReplace 4
#define op_Kill 5
#define op_Untype 6

/* for movecursor and delete */
#define op_ForeChar 1
#define op_BackChar 2
#define op_ForeWord 3
#define op_BackWord 4
#define op_ForeLine 5
#define op_BackLine 6
#define op_BeginLine 7
#define op_EndLine 8

/* for scroll */
#define op_UpLine 1
#define op_DownLine 2
#define op_UpPage 3
#define op_DownPage 4
#define op_ToTop 5
#define op_ToBottom 6

#define op_Enter 1
/* for redraw */
#define op_TextWin 1
/* for meta */
#define op_Cancel 1
#define op_Escape 2
#define op_DefineMacro 3
#define op_ExplainKey 4
/* for redraw */
#define op_Screen 1
#define op_Status 2
#define op_AllWindows 3
/* for status window */
#define op_Shrink 1
#define op_Zoom 2
#define op_Clear 3

#ifdef __STDC__

extern void xted_init(int buflen, char *buffer, int *readpos, int *killflag,
  int firsttime);
extern void xted_insert(int ch);
extern void xted_delete(int op);
extern void xted_enter(int op);
extern void xted_scroll(int op);
extern void xted_movecursor(int op);
extern void xted_cutbuf(int op);
extern void xted_history(int op);
extern void xted_noop(int op);
extern void xtexted_redraw(int op);
extern void xtexted_meta(int op);
extern void xted_macro(int op);
extern void xted_define_macro(int keynum);
extern void xstat_reset_window_size(int op);
extern void xtexted_modify(int keynum, int op);

#else

extern void xted_init();
extern void xted_insert();
extern void xted_delete();
extern void xted_enter();
extern void xted_scroll();
extern void xted_movecursor();
extern void xted_cutbuf();
extern void xted_history();
extern void xted_noop();
extern void xtexted_redraw();
extern void xtexted_meta();
extern void xted_macro();
extern void xted_define_macro();
extern void xstat_reset_window_size();
extern void xtexted_modify();

#endif
