/* xkeycaps, Copyright (c) 1994 Jamie Zawinski <jwz@jwz.org>
 *
 * AGE and IBM have conspired to confuse us all.
 *
 * AGE XoftWare 2.0 is a PC software product, and therefore works with a
 * variety of PC keyboards.  It comes with the vendor id "AGE Logic, Inc."
 *
 * The IBM Xstation 130 X terminal is an IBM hardware product, which comes
 * with "X Station Manager Software 1.4" which is in fact made by AGE.  It
 * has the vendor id "AGE Logic, Inc. Release 090493".  It has a different
 * default keymap than the PC software, though it comes with a PC101 keyboard.
 * This is apparently so that the IBM product ends up with the same default
 * keymap (and keycaps) as the IBM RS6K keyboards.
 *
 * This file describes the default R5 keymap of the AGE PC software product.
 * Generated by Dan R. Greening <greening@sti.com>.
 */

static const struct default_keycode_map xoft2_map [] = {
  {  13, ShiftMask,	{ XK_Shift_R,	XK_Shift_R }},
  {  14, ControlMask,	{ XK_Control_R,	XK_Control_R }},
  {  15, Mod1Mask,	{ XK_Alt_R,	XK_Alt_R }},
  {  16, 0,		{ XK_BackSpace,	XK_BackSpace }},
  {  17, 0,		{ XK_Tab,	XK_Tab }},
  {  18, Mod1Mask,	{ XK_Alt_L,	XK_Alt_L }},
  {  20, 0,		{ XK_Clear,	XK_Clear }},
  {  21, 0,		{ XK_Return,	XK_Return }},
  {  24, ShiftMask,	{ XK_Shift_L,	XK_Shift_L }},
  {  25, ControlMask,	{ XK_Control_L,	XK_Control_L }},
  {  26, 0,		{ XK_Menu,	XK_Menu }},
  {  27, 0,		{ XK_Pause,	XK_Pause }},
  {  28, LockMask,	{ XK_Caps_Lock,	XK_Caps_Lock }},
  {  35, 0,		{ XK_Escape,	XK_Escape }},
  {  40, 0,		{ XK_space,	XK_space }},
  {  41, 0,		{ XK_Prior,	XK_Prior }},
  {  42, 0,		{ XK_Next,	XK_Next }},
  {  43, 0,		{ XK_End,	XK_End }},
  {  44, 0,		{ XK_Home,	XK_Home }},
  {  45, 0,		{ XK_Left,	XK_Left }},
  {  46, 0,		{ XK_Up,	XK_Up }},
  {  47, 0,		{ XK_Right,	XK_Right }},
  {  48, 0,		{ XK_Down,	XK_Down }},
  {  49, 0,		{ XK_Select,	XK_Select }},
  {  50, 0,		{ XK_Print,	XK_Print }},
  {  51, 0,		{ XK_Execute,	XK_Execute }},
  {  53, 0,		{ XK_Insert,	XK_Insert }},
  {  54, 0,		{ XK_Delete,	XK_Delete }},
  {  55, 0,		{ XK_Help,	XK_Help }},
  {  56, 0,		{ XK_0,	XK_parenright }},
  {  57, 0,		{ XK_1,	XK_exclam }},
  {  58, 0,		{ XK_2,	XK_at }},
  {  59, 0,		{ XK_3,	XK_numbersign }},
  {  60, 0,		{ XK_4,	XK_dollar }},
  {  61, 0,		{ XK_5,	XK_percent }},
  {  62, 0,		{ XK_6,	XK_asciicircum }},
  {  63, 0,		{ XK_7,	XK_ampersand }},
  {  64, 0,		{ XK_8,	XK_asterisk }},
  {  65, 0,		{ XK_9,	XK_parenleft }},
  {  73, 0,		{ XK_a,	XK_A }},
  {  74, 0,		{ XK_b,	XK_B }},
  {  75, 0,		{ XK_c,	XK_C }},
  {  76, 0,		{ XK_d,	XK_D }},
  {  77, 0,		{ XK_e,	XK_E }},
  {  78, 0,		{ XK_f,	XK_F }},
  {  79, 0,		{ XK_g,	XK_G }},
  {  80, 0,		{ XK_h,	XK_H }},
  {  81, 0,		{ XK_i,	XK_I }},
  {  82, 0,		{ XK_j,	XK_J }},
  {  83, 0,		{ XK_k,	XK_K }},
  {  84, 0,		{ XK_l,	XK_L }},
  {  85, 0,		{ XK_m,	XK_M }},
  {  86, 0,		{ XK_n,	XK_N }},
  {  87, 0,		{ XK_o,	XK_O }},
  {  88, 0,		{ XK_p,	XK_P }},
  {  89, 0,		{ XK_q,	XK_Q }},
  {  90, 0,		{ XK_r,	XK_R }},
  {  91, 0,		{ XK_s,	XK_S }},
  {  92, 0,		{ XK_t,	XK_T }},
  {  93, 0,		{ XK_u,	XK_U }},
  {  94, 0,		{ XK_v,	XK_V }},
  {  95, 0,		{ XK_w,	XK_W }},
  {  96, 0,		{ XK_x,	XK_X }},
  {  97, 0,		{ XK_y,	XK_Y }},
  {  98, 0,		{ XK_z,	XK_Z }},
  { 104, 0,		{ XK_KP_0,	XK_KP_0 }},
  { 105, 0,		{ XK_KP_1,	XK_KP_1 }},
  { 106, 0,		{ XK_KP_2,	XK_KP_2 }},
  { 107, 0,		{ XK_KP_3,	XK_KP_3 }},
  { 108, 0,		{ XK_KP_4,	XK_KP_4 }},
  { 109, 0,		{ XK_KP_5,	XK_KP_5 }},
  { 110, 0,		{ XK_KP_6,	XK_KP_6 }},
  { 111, 0,		{ XK_KP_7,	XK_KP_7 }},
  { 112, 0,		{ XK_KP_8,	XK_KP_8 }},
  { 113, 0,		{ XK_KP_9,	XK_KP_9 }},
  { 114, 0,		{ XK_KP_Multiply,	XK_KP_Multiply }},
  { 115, 0,		{ XK_KP_Add,	XK_KP_Add }},
  { 116, 0,		{ XK_KP_Separator,	XK_KP_Separator }},
  { 117, 0,		{ XK_KP_Subtract,	XK_KP_Subtract }},
  { 118, 0,		{ XK_KP_Decimal,	XK_KP_Decimal }},
  { 119, 0,		{ XK_KP_Divide,	XK_KP_Divide }},
  { 120, 0,		{ XK_F1,	XK_F1 }},
  { 121, 0,		{ XK_F2,	XK_F2 }},
  { 122, 0,		{ XK_F3,	XK_F3 }},
  { 123, 0,		{ XK_F4,	XK_F4 }},
  { 124, 0,		{ XK_F5,	XK_F5 }},
  { 125, 0,		{ XK_F6,	XK_F6 }},
  { 126, 0,		{ XK_F7,	XK_F7 }},
  { 127, 0,		{ XK_F8,	XK_F8 }},
  { 128, 0,		{ XK_F9,	XK_F9 }},
  { 129, 0,		{ XK_F10,	XK_F10 }},
  { 130, 0,		{ XK_F11,	XK_F11 }},
  { 131, 0,		{ XK_F12,	XK_F12 }},
  { 132, 0,		{ XK_F13,	XK_F13 }},
  { 133, 0,		{ XK_F14,	XK_F14 }},
  { 134, 0,		{ XK_F15,	XK_F15 }},
  { 135, 0,		{ XK_F16,	XK_F16 }},
  { 152, 0,		{ XK_Num_Lock,	XK_Num_Lock }},
  { 153, 0,		{ XK_Scroll_Lock,	XK_Scroll_Lock }},
  { 194, 0,		{ XK_semicolon,	XK_colon }},
  { 195, 0,		{ XK_equal,	XK_plus }},
  { 196, 0,		{ XK_comma,	XK_less }},
  { 197, 0,		{ XK_minus,	XK_underscore }},
  { 198, 0,		{ XK_period,	XK_greater }},
  { 199, 0,		{ XK_slash,	XK_question }},
  { 200, 0,		{ XK_grave,	XK_asciitilde }},
  { 227, 0,		{ XK_bracketleft,	XK_braceleft }},
  { 228, 0,		{ XK_backslash,	XK_bar }},
  { 229, 0,		{ XK_bracketright,	XK_braceright }},
  { 230, 0,		{ XK_apostrophe,	XK_quotedbl }}
  };
