//////////////////////////////////////////////////////////////////////////////
// Name:        Elements_GetAttributes.cpp
// Author:      Alex Thuering
// Copyright:   (c) 2005 Alex Thuering
// Licence:     wxWindows licence
// Notes:       generated by genGetAttributes.py
//////////////////////////////////////////////////////////////////////////////

#include "String_wxsvg.h"
#include "SVGAElement.h"
#include "SVGElement.h"
#include "SVGURIReference.h"
#include "SVGTests.h"
#include "SVGLangSpace.h"
#include "SVGExternalResourcesRequired.h"
#include "SVGStylable.h"
#include "SVGTransformable.h"
#include "SVGAltGlyphDefElement.h"
#include "SVGAltGlyphElement.h"
#include "SVGTextPositioningElement.h"
#include "SVGTextContentElement.h"
#include "SVGAltGlyphItemElement.h"
#include "SVGAnimationElement.h"
#include "SVGAnimateColorElement.h"
#include "SVGAnimateElement.h"
#include "SVGAnimateMotionElement.h"
#include "SVGAnimateTransformElement.h"
#include "SVGAnimatedPathData.h"
#include "SVGAnimatedPoints.h"
#include "SVGCircleElement.h"
#include "SVGClipPathElement.h"
#include "SVGColorProfileElement.h"
#include "SVGComponentTransferFunctionElement.h"
#include "SVGCursorElement.h"
#include "SVGDefinitionSrcElement.h"
#include "SVGDefsElement.h"
#include "SVGDescElement.h"
#include "SVGEllipseElement.h"
#include "SVGFEBlendElement.h"
#include "SVGFilterPrimitiveStandardAttributes.h"
#include "SVGFEColorMatrixElement.h"
#include "SVGFEComponentTransferElement.h"
#include "SVGFECompositeElement.h"
#include "SVGFEConvolveMatrixElement.h"
#include "SVGFEDiffuseLightingElement.h"
#include "SVGFEDisplacementMapElement.h"
#include "SVGFEDistantLightElement.h"
#include "SVGFEFloodElement.h"
#include "SVGFEFuncAElement.h"
#include "SVGFEFuncBElement.h"
#include "SVGFEFuncGElement.h"
#include "SVGFEFuncRElement.h"
#include "SVGFEGaussianBlurElement.h"
#include "SVGFEImageElement.h"
#include "SVGFEMergeElement.h"
#include "SVGFEMergeNodeElement.h"
#include "SVGFEMorphologyElement.h"
#include "SVGFEOffsetElement.h"
#include "SVGFEPointLightElement.h"
#include "SVGFESpecularLightingElement.h"
#include "SVGFESpotLightElement.h"
#include "SVGFETileElement.h"
#include "SVGFETurbulenceElement.h"
#include "SVGFilterElement.h"
#include "SVGFitToViewBox.h"
#include "SVGFontElement.h"
#include "SVGFontFaceElement.h"
#include "SVGFontFaceFormatElement.h"
#include "SVGFontFaceNameElement.h"
#include "SVGFontFaceSrcElement.h"
#include "SVGFontFaceUriElement.h"
#include "SVGForeignObjectElement.h"
#include "SVGGElement.h"
#include "SVGGlyphElement.h"
#include "SVGGlyphRefElement.h"
#include "SVGGradientElement.h"
#include "SVGHKernElement.h"
#include "SVGImageElement.h"
#include "SVGLineElement.h"
#include "SVGLinearGradientElement.h"
#include "SVGMPathElement.h"
#include "SVGMarkerElement.h"
#include "SVGMaskElement.h"
#include "SVGMetadataElement.h"
#include "SVGMissingGlyphElement.h"
#include "SVGPathElement.h"
#include "SVGPatternElement.h"
#include "SVGPolygonElement.h"
#include "SVGPolylineElement.h"
#include "SVGRadialGradientElement.h"
#include "SVGRectElement.h"
#include "SVGSVGElement.h"
#include "SVGZoomAndPan.h"
#include "SVGScriptElement.h"
#include "SVGSetElement.h"
#include "SVGStopElement.h"
#include "SVGStyleElement.h"
#include "SVGSwitchElement.h"
#include "SVGSymbolElement.h"
#include "SVGTBreakElement.h"
#include "SVGTRefElement.h"
#include "SVGTSpanElement.h"
#include "SVGTextElement.h"
#include "SVGTextPathElement.h"
#include "SVGTitleElement.h"
#include "SVGUseElement.h"
#include "SVGVKernElement.h"
#include "SVGVideoElement.h"
#include "SVGViewElement.h"
#include "SVGViewSpec.h"

// wxSVGAnimateMotionElement
wxSvgXmlAttrHash wxSVGAnimateMotionElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGAnimationElement::GetAttributes());
  return attrs;
}

// wxSVGFontFaceUriElement
wxSvgXmlAttrHash wxSVGFontFaceUriElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGElement::GetAttributes());
  return attrs;
}

// wxSVGFontFaceElement
wxSvgXmlAttrHash wxSVGFontFaceElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGElement::GetAttributes());
  return attrs;
}

// wxSVGFEFuncBElement
wxSvgXmlAttrHash wxSVGFEFuncBElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGComponentTransferFunctionElement::GetAttributes());
  return attrs;
}

// wxSVGFEFuncAElement
wxSvgXmlAttrHash wxSVGFEFuncAElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGComponentTransferFunctionElement::GetAttributes());
  return attrs;
}

// wxSVGFEFuncRElement
wxSvgXmlAttrHash wxSVGFEFuncRElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGComponentTransferFunctionElement::GetAttributes());
  return attrs;
}

// wxSVGForeignObjectElement
wxSvgXmlAttrHash wxSVGForeignObjectElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (m_x.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("x"), m_x.GetBaseVal().GetValueAsString());
  if (m_y.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("y"), m_y.GetBaseVal().GetValueAsString());
  if (m_width.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("width"), m_width.GetBaseVal().GetValueAsString());
  if (m_height.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("height"), m_height.GetBaseVal().GetValueAsString());
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGTests::GetAttributes());
  attrs.Add(wxSVGLangSpace::GetAttributes());
  attrs.Add(wxSVGExternalResourcesRequired::GetAttributes());
  attrs.Add(wxSVGStylable::GetAttributes());
  attrs.Add(wxSVGTransformable::GetAttributes());
  return attrs;
}

// wxSVGFEMorphologyElement
wxSvgXmlAttrHash wxSVGFEMorphologyElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (!m_in1.GetBaseVal().IsEmpty())
    attrs.Add(wxT("in"), m_in1.GetBaseVal());
  if (m_operator.GetBaseVal() != 0)
    attrs.Add(wxT("operator"), wxString::Format(wxT("%d"), (char) m_operator.GetBaseVal()));
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGFilterPrimitiveStandardAttributes::GetAttributes());
  return attrs;
}

// wxSVGMarkerElement
wxSvgXmlAttrHash wxSVGMarkerElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (m_refX.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("refX"), m_refX.GetBaseVal().GetValueAsString());
  if (m_refY.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("refY"), m_refY.GetBaseVal().GetValueAsString());
  if (m_markerUnits.GetBaseVal() != 0)
    attrs.Add(wxT("markerUnits"), wxString::Format(wxT("%d"), (char) m_markerUnits.GetBaseVal()));
  if (m_markerWidth.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("markerWidth"), m_markerWidth.GetBaseVal().GetValueAsString());
  if (m_markerHeight.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("markerHeight"), m_markerHeight.GetBaseVal().GetValueAsString());
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGLangSpace::GetAttributes());
  attrs.Add(wxSVGExternalResourcesRequired::GetAttributes());
  attrs.Add(wxSVGStylable::GetAttributes());
  attrs.Add(wxSVGFitToViewBox::GetAttributes());
  return attrs;
}

// wxSVGFETileElement
wxSvgXmlAttrHash wxSVGFETileElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (!m_in1.GetBaseVal().IsEmpty())
    attrs.Add(wxT("in"), m_in1.GetBaseVal());
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGFilterPrimitiveStandardAttributes::GetAttributes());
  return attrs;
}

// wxSVGPathElement
wxSvgXmlAttrHash wxSVGPathElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (m_pathLength.GetBaseVal() > 0)
    attrs.Add(wxT("pathLength"), wxString::Format(wxT("%g"), m_pathLength.GetBaseVal()));
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGTests::GetAttributes());
  attrs.Add(wxSVGLangSpace::GetAttributes());
  attrs.Add(wxSVGExternalResourcesRequired::GetAttributes());
  attrs.Add(wxSVGStylable::GetAttributes());
  attrs.Add(wxSVGTransformable::GetAttributes());
  attrs.Add(wxSVGAnimatedPathData::GetAttributes());
  return attrs;
}

// wxSVGTSpanElement
wxSvgXmlAttrHash wxSVGTSpanElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGTextPositioningElement::GetAttributes());
  return attrs;
}

// wxSVGFEColorMatrixElement
wxSvgXmlAttrHash wxSVGFEColorMatrixElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (!m_in1.GetBaseVal().IsEmpty())
    attrs.Add(wxT("in"), m_in1.GetBaseVal());
  if (m_type.GetBaseVal() != 0)
    attrs.Add(wxT("type"), wxString::Format(wxT("%d"), (char) m_type.GetBaseVal()));
  if (!m_values.GetBaseVal().IsEmpty())
    attrs.Add(wxT("values"), m_values.GetBaseVal().GetValueAsString());
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGFilterPrimitiveStandardAttributes::GetAttributes());
  return attrs;
}

// wxSVGFontFaceFormatElement
wxSvgXmlAttrHash wxSVGFontFaceFormatElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGElement::GetAttributes());
  return attrs;
}

// wxSVGFEOffsetElement
wxSvgXmlAttrHash wxSVGFEOffsetElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (!m_in1.GetBaseVal().IsEmpty())
    attrs.Add(wxT("in"), m_in1.GetBaseVal());
  if (m_dx.GetBaseVal() > 0)
    attrs.Add(wxT("dx"), wxString::Format(wxT("%g"), m_dx.GetBaseVal()));
  if (m_dy.GetBaseVal() > 0)
    attrs.Add(wxT("dy"), wxString::Format(wxT("%g"), m_dy.GetBaseVal()));
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGFilterPrimitiveStandardAttributes::GetAttributes());
  return attrs;
}

// wxSVGSymbolElement
wxSvgXmlAttrHash wxSVGSymbolElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGLangSpace::GetAttributes());
  attrs.Add(wxSVGExternalResourcesRequired::GetAttributes());
  attrs.Add(wxSVGStylable::GetAttributes());
  attrs.Add(wxSVGFitToViewBox::GetAttributes());
  return attrs;
}

// wxSVGFEMergeNodeElement
wxSvgXmlAttrHash wxSVGFEMergeNodeElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (!m_in1.GetBaseVal().IsEmpty())
    attrs.Add(wxT("in"), m_in1.GetBaseVal());
  attrs.Add(wxSVGElement::GetAttributes());
  return attrs;
}

// wxSVGTBreakElement
wxSvgXmlAttrHash wxSVGTBreakElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGElement::GetAttributes());
  return attrs;
}

// wxSVGTransformable
wxSvgXmlAttrHash wxSVGTransformable::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (!m_transform.GetBaseVal().IsEmpty())
    attrs.Add(wxT("transform"), m_transform.GetBaseVal().GetValueAsString());
  return attrs;
}

// wxSVGStyleElement
wxSvgXmlAttrHash wxSVGStyleElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (!m_xmlspace.IsEmpty())
    attrs.Add(wxT("xml:space"), m_xmlspace);
  if (!m_type.IsEmpty())
    attrs.Add(wxT("type"), m_type);
  if (!m_media.IsEmpty())
    attrs.Add(wxT("media"), m_media);
  if (!m_title.IsEmpty())
    attrs.Add(wxT("title"), m_title);
  attrs.Add(wxSVGElement::GetAttributes());
  return attrs;
}

// wxSVGPolygonElement
wxSvgXmlAttrHash wxSVGPolygonElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGTests::GetAttributes());
  attrs.Add(wxSVGLangSpace::GetAttributes());
  attrs.Add(wxSVGExternalResourcesRequired::GetAttributes());
  attrs.Add(wxSVGStylable::GetAttributes());
  attrs.Add(wxSVGTransformable::GetAttributes());
  attrs.Add(wxSVGAnimatedPoints::GetAttributes());
  return attrs;
}

// wxSVGCursorElement
wxSvgXmlAttrHash wxSVGCursorElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (m_x.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("x"), m_x.GetBaseVal().GetValueAsString());
  if (m_y.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("y"), m_y.GetBaseVal().GetValueAsString());
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGURIReference::GetAttributes());
  attrs.Add(wxSVGTests::GetAttributes());
  attrs.Add(wxSVGExternalResourcesRequired::GetAttributes());
  return attrs;
}

// wxSVGFECompositeElement
wxSvgXmlAttrHash wxSVGFECompositeElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (!m_in1.GetBaseVal().IsEmpty())
    attrs.Add(wxT("in"), m_in1.GetBaseVal());
  if (!m_in2.GetBaseVal().IsEmpty())
    attrs.Add(wxT("in2"), m_in2.GetBaseVal());
  if (m_operator.GetBaseVal() != 0)
    attrs.Add(wxT("operator"), wxString::Format(wxT("%d"), (char) m_operator.GetBaseVal()));
  if (m_k1.GetBaseVal() > 0)
    attrs.Add(wxT("k1"), wxString::Format(wxT("%g"), m_k1.GetBaseVal()));
  if (m_k2.GetBaseVal() > 0)
    attrs.Add(wxT("k2"), wxString::Format(wxT("%g"), m_k2.GetBaseVal()));
  if (m_k3.GetBaseVal() > 0)
    attrs.Add(wxT("k3"), wxString::Format(wxT("%g"), m_k3.GetBaseVal()));
  if (m_k4.GetBaseVal() > 0)
    attrs.Add(wxT("k4"), wxString::Format(wxT("%g"), m_k4.GetBaseVal()));
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGFilterPrimitiveStandardAttributes::GetAttributes());
  return attrs;
}

// wxSVGGradientElement
wxSvgXmlAttrHash wxSVGGradientElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (m_gradientUnits.GetBaseVal() != 0)
    attrs.Add(wxT("gradientUnits"), m_gradientUnits.GetBaseVal() == wxSVG_UNIT_TYPE_USERSPACEONUSE ? wxT("userSpaceOnUse") : wxT("objectBoundingBox"));
  if (!m_gradientTransform.GetBaseVal().IsEmpty())
    attrs.Add(wxT("gradientTransform"), m_gradientTransform.GetBaseVal().GetValueAsString());
  if (m_spreadMethod.GetBaseVal() != 0)
    attrs.Add(wxT("spreadMethod"), wxString::Format(wxT("%d"), (char) m_spreadMethod.GetBaseVal()));
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGURIReference::GetAttributes());
  attrs.Add(wxSVGExternalResourcesRequired::GetAttributes());
  attrs.Add(wxSVGStylable::GetAttributes());
  return attrs;
}

// wxSVGLinearGradientElement
wxSvgXmlAttrHash wxSVGLinearGradientElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (m_x1.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("x1"), m_x1.GetBaseVal().GetValueAsString());
  if (m_y1.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("y1"), m_y1.GetBaseVal().GetValueAsString());
  if (m_x2.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("x2"), m_x2.GetBaseVal().GetValueAsString());
  if (m_y2.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("y2"), m_y2.GetBaseVal().GetValueAsString());
  attrs.Add(wxSVGGradientElement::GetAttributes());
  return attrs;
}

// wxSVGTextElement
wxSvgXmlAttrHash wxSVGTextElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGTextPositioningElement::GetAttributes());
  attrs.Add(wxSVGTransformable::GetAttributes());
  return attrs;
}

// wxSVGFEPointLightElement
wxSvgXmlAttrHash wxSVGFEPointLightElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (m_x.GetBaseVal() > 0)
    attrs.Add(wxT("x"), wxString::Format(wxT("%g"), m_x.GetBaseVal()));
  if (m_y.GetBaseVal() > 0)
    attrs.Add(wxT("y"), wxString::Format(wxT("%g"), m_y.GetBaseVal()));
  if (m_z.GetBaseVal() > 0)
    attrs.Add(wxT("z"), wxString::Format(wxT("%g"), m_z.GetBaseVal()));
  attrs.Add(wxSVGElement::GetAttributes());
  return attrs;
}

// wxSVGHKernElement
wxSvgXmlAttrHash wxSVGHKernElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGElement::GetAttributes());
  return attrs;
}

// wxSVGStopElement
wxSvgXmlAttrHash wxSVGStopElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (m_offset.GetBaseVal() > 0)
    attrs.Add(wxT("offset"), wxString::Format(wxT("%g"), m_offset.GetBaseVal()));
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGStylable::GetAttributes());
  return attrs;
}

// wxSVGFEDisplacementMapElement
wxSvgXmlAttrHash wxSVGFEDisplacementMapElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (!m_in1.GetBaseVal().IsEmpty())
    attrs.Add(wxT("in"), m_in1.GetBaseVal());
  if (!m_in2.GetBaseVal().IsEmpty())
    attrs.Add(wxT("in2"), m_in2.GetBaseVal());
  if (m_scale.GetBaseVal() > 0)
    attrs.Add(wxT("scale"), wxString::Format(wxT("%g"), m_scale.GetBaseVal()));
  if (m_xChannelSelector.GetBaseVal() != 0)
    attrs.Add(wxT("xChannelSelector"), wxString::Format(wxT("%d"), (char) m_xChannelSelector.GetBaseVal()));
  if (m_yChannelSelector.GetBaseVal() != 0)
    attrs.Add(wxT("yChannelSelector"), wxString::Format(wxT("%d"), (char) m_yChannelSelector.GetBaseVal()));
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGFilterPrimitiveStandardAttributes::GetAttributes());
  return attrs;
}

// wxSVGLineElement
wxSvgXmlAttrHash wxSVGLineElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (m_x1.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("x1"), m_x1.GetBaseVal().GetValueAsString());
  if (m_y1.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("y1"), m_y1.GetBaseVal().GetValueAsString());
  if (m_x2.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("x2"), m_x2.GetBaseVal().GetValueAsString());
  if (m_y2.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("y2"), m_y2.GetBaseVal().GetValueAsString());
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGTests::GetAttributes());
  attrs.Add(wxSVGLangSpace::GetAttributes());
  attrs.Add(wxSVGExternalResourcesRequired::GetAttributes());
  attrs.Add(wxSVGStylable::GetAttributes());
  attrs.Add(wxSVGTransformable::GetAttributes());
  return attrs;
}

// wxSVGFontFaceNameElement
wxSvgXmlAttrHash wxSVGFontFaceNameElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGElement::GetAttributes());
  return attrs;
}

// wxSVGPatternElement
wxSvgXmlAttrHash wxSVGPatternElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (m_patternUnits.GetBaseVal() != 0)
    attrs.Add(wxT("patternUnits"), wxString::Format(wxT("%d"), (char) m_patternUnits.GetBaseVal()));
  if (m_patternContentUnits.GetBaseVal() != 0)
    attrs.Add(wxT("patternContentUnits"), wxString::Format(wxT("%d"), (char) m_patternContentUnits.GetBaseVal()));
  if (!m_patternTransform.GetBaseVal().IsEmpty())
    attrs.Add(wxT("patternTransform"), m_patternTransform.GetBaseVal().GetValueAsString());
  if (m_x.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("x"), m_x.GetBaseVal().GetValueAsString());
  if (m_y.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("y"), m_y.GetBaseVal().GetValueAsString());
  if (m_width.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("width"), m_width.GetBaseVal().GetValueAsString());
  if (m_height.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("height"), m_height.GetBaseVal().GetValueAsString());
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGURIReference::GetAttributes());
  attrs.Add(wxSVGTests::GetAttributes());
  attrs.Add(wxSVGLangSpace::GetAttributes());
  attrs.Add(wxSVGExternalResourcesRequired::GetAttributes());
  attrs.Add(wxSVGStylable::GetAttributes());
  attrs.Add(wxSVGFitToViewBox::GetAttributes());
  return attrs;
}

// wxSVGExternalResourcesRequired
wxSvgXmlAttrHash wxSVGExternalResourcesRequired::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (m_externalResourcesRequired.GetBaseVal())
    attrs.Add(wxT("externalResourcesRequired"), wxString::Format(wxT("%d"), (bool) m_externalResourcesRequired.GetBaseVal()));
  return attrs;
}

// wxSVGScriptElement
wxSvgXmlAttrHash wxSVGScriptElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (!m_type.IsEmpty())
    attrs.Add(wxT("type"), m_type);
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGURIReference::GetAttributes());
  attrs.Add(wxSVGExternalResourcesRequired::GetAttributes());
  return attrs;
}

// wxSVGStylable
wxSvgXmlAttrHash wxSVGStylable::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (!m_className.GetBaseVal().IsEmpty())
    attrs.Add(wxT("class"), m_className.GetBaseVal());
  attrs.Add(GetCustomAttributes());
  if (!m_style.empty())
    attrs.Add(wxT("style"), m_style.GetCSSText());
  attrs.Add(GetCustomAttributes());
  return attrs;
}

// wxSVGFitToViewBox
wxSvgXmlAttrHash wxSVGFitToViewBox::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (!m_viewBox.GetBaseVal().IsEmpty())
    attrs.Add(wxT("viewBox"), m_viewBox.GetBaseVal().GetValueAsString());
  if (m_preserveAspectRatio.GetBaseVal().GetAlign() != wxSVG_PRESERVEASPECTRATIO_UNKNOWN && m_preserveAspectRatio.GetBaseVal().GetMeetOrSlice() != wxSVG_MEETORSLICE_UNKNOWN)
    attrs.Add(wxT("preserveAspectRatio"), m_preserveAspectRatio.GetBaseVal().GetValueAsString());
  return attrs;
}

// wxSVGTests
wxSvgXmlAttrHash wxSVGTests::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (!m_requiredFeatures.IsEmpty())
    attrs.Add(wxT("requiredFeatures"), m_requiredFeatures.GetValueAsString());
  if (!m_requiredExtensions.IsEmpty())
    attrs.Add(wxT("requiredExtensions"), m_requiredExtensions.GetValueAsString());
  if (!m_systemLanguage.IsEmpty())
    attrs.Add(wxT("systemLanguage"), m_systemLanguage.GetValueAsString());
  return attrs;
}

// wxSVGSVGElement
wxSvgXmlAttrHash wxSVGSVGElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (m_x.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("x"), m_x.GetBaseVal().GetValueAsString());
  if (m_y.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("y"), m_y.GetBaseVal().GetValueAsString());
  if (m_width.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("width"), m_width.GetBaseVal().GetValueAsString());
  if (m_height.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("height"), m_height.GetBaseVal().GetValueAsString());
  if (!m_contentScriptType.IsEmpty())
    attrs.Add(wxT("contentScriptType"), m_contentScriptType);
  if (!m_contentStyleType.IsEmpty())
    attrs.Add(wxT("contentStyleType"), m_contentStyleType);
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGTests::GetAttributes());
  attrs.Add(wxSVGLangSpace::GetAttributes());
  attrs.Add(wxSVGExternalResourcesRequired::GetAttributes());
  attrs.Add(wxSVGStylable::GetAttributes());
  attrs.Add(wxSVGFitToViewBox::GetAttributes());
  attrs.Add(wxSVGZoomAndPan::GetAttributes());
  return attrs;
}

// wxSVGViewSpec
wxSvgXmlAttrHash wxSVGViewSpec::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGZoomAndPan::GetAttributes());
  attrs.Add(wxSVGFitToViewBox::GetAttributes());
  return attrs;
}

// wxSVGVKernElement
wxSvgXmlAttrHash wxSVGVKernElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGElement::GetAttributes());
  return attrs;
}

// wxSVGMetadataElement
wxSvgXmlAttrHash wxSVGMetadataElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGElement::GetAttributes());
  return attrs;
}

// wxSVGAElement
wxSvgXmlAttrHash wxSVGAElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (!m_target.GetBaseVal().IsEmpty())
    attrs.Add(wxT("target"), m_target.GetBaseVal());
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGURIReference::GetAttributes());
  attrs.Add(wxSVGTests::GetAttributes());
  attrs.Add(wxSVGLangSpace::GetAttributes());
  attrs.Add(wxSVGExternalResourcesRequired::GetAttributes());
  attrs.Add(wxSVGStylable::GetAttributes());
  attrs.Add(wxSVGTransformable::GetAttributes());
  return attrs;
}

// wxSVGAltGlyphElement
wxSvgXmlAttrHash wxSVGAltGlyphElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (!m_glyphRef.IsEmpty())
    attrs.Add(wxT("glyphRef"), m_glyphRef);
  if (!m_format.IsEmpty())
    attrs.Add(wxT("format"), m_format);
  attrs.Add(wxSVGTextPositioningElement::GetAttributes());
  attrs.Add(wxSVGURIReference::GetAttributes());
  return attrs;
}

// wxSVGURIReference
wxSvgXmlAttrHash wxSVGURIReference::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (!m_href.GetBaseVal().IsEmpty())
    attrs.Add(wxT("xlink:href"), m_href.GetBaseVal());
  return attrs;
}

// wxSVGAnimateTransformElement
wxSvgXmlAttrHash wxSVGAnimateTransformElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGAnimationElement::GetAttributes());
  return attrs;
}

// wxSVGFEComponentTransferElement
wxSvgXmlAttrHash wxSVGFEComponentTransferElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (!m_in1.GetBaseVal().IsEmpty())
    attrs.Add(wxT("in"), m_in1.GetBaseVal());
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGFilterPrimitiveStandardAttributes::GetAttributes());
  return attrs;
}

// wxSVGFEBlendElement
wxSvgXmlAttrHash wxSVGFEBlendElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (!m_in1.GetBaseVal().IsEmpty())
    attrs.Add(wxT("in"), m_in1.GetBaseVal());
  if (!m_in2.GetBaseVal().IsEmpty())
    attrs.Add(wxT("in2"), m_in2.GetBaseVal());
  if (m_mode.GetBaseVal() != 0)
    attrs.Add(wxT("mode"), wxString::Format(wxT("%d"), (char) m_mode.GetBaseVal()));
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGFilterPrimitiveStandardAttributes::GetAttributes());
  return attrs;
}

// wxSVGFEMergeElement
wxSvgXmlAttrHash wxSVGFEMergeElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGFilterPrimitiveStandardAttributes::GetAttributes());
  return attrs;
}

// wxSVGTextPositioningElement
wxSvgXmlAttrHash wxSVGTextPositioningElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (!m_x.GetBaseVal().IsEmpty())
    attrs.Add(wxT("x"), m_x.GetBaseVal().GetValueAsString());
  if (!m_y.GetBaseVal().IsEmpty())
    attrs.Add(wxT("y"), m_y.GetBaseVal().GetValueAsString());
  if (!m_dx.GetBaseVal().IsEmpty())
    attrs.Add(wxT("dx"), m_dx.GetBaseVal().GetValueAsString());
  if (!m_dy.GetBaseVal().IsEmpty())
    attrs.Add(wxT("dy"), m_dy.GetBaseVal().GetValueAsString());
  if (!m_rotate.GetBaseVal().IsEmpty())
    attrs.Add(wxT("rotate"), m_rotate.GetBaseVal().GetValueAsString());
  attrs.Add(wxSVGTextContentElement::GetAttributes());
  return attrs;
}

// wxSVGEllipseElement
wxSvgXmlAttrHash wxSVGEllipseElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (m_cx.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("cx"), m_cx.GetBaseVal().GetValueAsString());
  if (m_cy.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("cy"), m_cy.GetBaseVal().GetValueAsString());
  if (m_rx.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("rx"), m_rx.GetBaseVal().GetValueAsString());
  if (m_ry.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("ry"), m_ry.GetBaseVal().GetValueAsString());
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGTests::GetAttributes());
  attrs.Add(wxSVGLangSpace::GetAttributes());
  attrs.Add(wxSVGExternalResourcesRequired::GetAttributes());
  attrs.Add(wxSVGStylable::GetAttributes());
  attrs.Add(wxSVGTransformable::GetAttributes());
  return attrs;
}

// wxSVGFilterElement
wxSvgXmlAttrHash wxSVGFilterElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (m_filterUnits.GetBaseVal() != 0)
    attrs.Add(wxT("filterUnits"), wxString::Format(wxT("%d"), (char) m_filterUnits.GetBaseVal()));
  if (m_primitiveUnits.GetBaseVal() != 0)
    attrs.Add(wxT("primitiveUnits"), wxString::Format(wxT("%d"), (char) m_primitiveUnits.GetBaseVal()));
  if (m_x.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("x"), m_x.GetBaseVal().GetValueAsString());
  if (m_y.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("y"), m_y.GetBaseVal().GetValueAsString());
  if (m_width.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("width"), m_width.GetBaseVal().GetValueAsString());
  if (m_height.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("height"), m_height.GetBaseVal().GetValueAsString());
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGURIReference::GetAttributes());
  attrs.Add(wxSVGLangSpace::GetAttributes());
  attrs.Add(wxSVGExternalResourcesRequired::GetAttributes());
  attrs.Add(wxSVGStylable::GetAttributes());
  return attrs;
}

// wxSVGClipPathElement
wxSvgXmlAttrHash wxSVGClipPathElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (m_clipPathUnits.GetBaseVal() != 0)
    attrs.Add(wxT("clipPathUnits"), wxString::Format(wxT("%d"), (char) m_clipPathUnits.GetBaseVal()));
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGTests::GetAttributes());
  attrs.Add(wxSVGLangSpace::GetAttributes());
  attrs.Add(wxSVGExternalResourcesRequired::GetAttributes());
  attrs.Add(wxSVGStylable::GetAttributes());
  attrs.Add(wxSVGTransformable::GetAttributes());
  return attrs;
}

// wxSVGSwitchElement
wxSvgXmlAttrHash wxSVGSwitchElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGTests::GetAttributes());
  attrs.Add(wxSVGLangSpace::GetAttributes());
  attrs.Add(wxSVGExternalResourcesRequired::GetAttributes());
  attrs.Add(wxSVGStylable::GetAttributes());
  attrs.Add(wxSVGTransformable::GetAttributes());
  return attrs;
}

// wxSVGMaskElement
wxSvgXmlAttrHash wxSVGMaskElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (m_maskUnits.GetBaseVal() != 0)
    attrs.Add(wxT("maskUnits"), wxString::Format(wxT("%d"), (char) m_maskUnits.GetBaseVal()));
  if (m_maskContentUnits.GetBaseVal() != 0)
    attrs.Add(wxT("maskContentUnits"), wxString::Format(wxT("%d"), (char) m_maskContentUnits.GetBaseVal()));
  if (m_x.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("x"), m_x.GetBaseVal().GetValueAsString());
  if (m_y.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("y"), m_y.GetBaseVal().GetValueAsString());
  if (m_width.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("width"), m_width.GetBaseVal().GetValueAsString());
  if (m_height.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("height"), m_height.GetBaseVal().GetValueAsString());
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGTests::GetAttributes());
  attrs.Add(wxSVGLangSpace::GetAttributes());
  attrs.Add(wxSVGExternalResourcesRequired::GetAttributes());
  attrs.Add(wxSVGStylable::GetAttributes());
  return attrs;
}

// wxSVGViewElement
wxSvgXmlAttrHash wxSVGViewElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (!m_viewTarget.IsEmpty())
    attrs.Add(wxT("viewTarget"), m_viewTarget.GetValueAsString());
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGExternalResourcesRequired::GetAttributes());
  attrs.Add(wxSVGFitToViewBox::GetAttributes());
  attrs.Add(wxSVGZoomAndPan::GetAttributes());
  return attrs;
}

// wxSVGDefinitionSrcElement
wxSvgXmlAttrHash wxSVGDefinitionSrcElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGElement::GetAttributes());
  return attrs;
}

// wxSVGFilterPrimitiveStandardAttributes
wxSvgXmlAttrHash wxSVGFilterPrimitiveStandardAttributes::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (m_x.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("x"), m_x.GetBaseVal().GetValueAsString());
  if (m_y.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("y"), m_y.GetBaseVal().GetValueAsString());
  if (m_width.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("width"), m_width.GetBaseVal().GetValueAsString());
  if (m_height.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("height"), m_height.GetBaseVal().GetValueAsString());
  if (!m_result.GetBaseVal().IsEmpty())
    attrs.Add(wxT("result"), m_result.GetBaseVal());
  attrs.Add(wxSVGStylable::GetAttributes());
  return attrs;
}

// wxSVGFEDistantLightElement
wxSvgXmlAttrHash wxSVGFEDistantLightElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (m_azimuth.GetBaseVal() > 0)
    attrs.Add(wxT("azimuth"), wxString::Format(wxT("%g"), m_azimuth.GetBaseVal()));
  if (m_elevation.GetBaseVal() > 0)
    attrs.Add(wxT("elevation"), wxString::Format(wxT("%g"), m_elevation.GetBaseVal()));
  attrs.Add(wxSVGElement::GetAttributes());
  return attrs;
}

// wxSVGFEDiffuseLightingElement
wxSvgXmlAttrHash wxSVGFEDiffuseLightingElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (!m_in1.GetBaseVal().IsEmpty())
    attrs.Add(wxT("in"), m_in1.GetBaseVal());
  if (m_surfaceScale.GetBaseVal() > 0)
    attrs.Add(wxT("surfaceScale"), wxString::Format(wxT("%g"), m_surfaceScale.GetBaseVal()));
  if (m_diffuseConstant.GetBaseVal() > 0)
    attrs.Add(wxT("diffuseConstant"), wxString::Format(wxT("%g"), m_diffuseConstant.GetBaseVal()));
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGFilterPrimitiveStandardAttributes::GetAttributes());
  return attrs;
}

// wxSVGAnimatedPathData
wxSvgXmlAttrHash wxSVGAnimatedPathData::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (!m_pathSegList.IsEmpty())
    attrs.Add(wxT("d"), m_pathSegList.GetValueAsString());
  return attrs;
}

// wxSVGFontFaceSrcElement
wxSvgXmlAttrHash wxSVGFontFaceSrcElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGElement::GetAttributes());
  return attrs;
}

// wxSVGZoomAndPan
wxSvgXmlAttrHash wxSVGZoomAndPan::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (m_zoomAndPan != wxSVG_ZOOMANDPAN_UNKNOWN)
    attrs.Add(wxT("zoomAndPan"), wxString::Format(wxT("%d"), (wxSVG_ZOOMANDPAN) m_zoomAndPan));
  return attrs;
}

// wxSVGDescElement
wxSvgXmlAttrHash wxSVGDescElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGLangSpace::GetAttributes());
  attrs.Add(wxSVGStylable::GetAttributes());
  return attrs;
}

// wxSVGSetElement
wxSvgXmlAttrHash wxSVGSetElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGAnimationElement::GetAttributes());
  return attrs;
}

// wxSVGAnimateElement
wxSvgXmlAttrHash wxSVGAnimateElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGAnimationElement::GetAttributes());
  return attrs;
}

// wxSVGLangSpace
wxSvgXmlAttrHash wxSVGLangSpace::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (!m_xmllang.IsEmpty())
    attrs.Add(wxT("xml:lang"), m_xmllang);
  if (!m_xmlspace.IsEmpty())
    attrs.Add(wxT("xml:space"), m_xmlspace);
  return attrs;
}

// wxSVGGlyphRefElement
wxSvgXmlAttrHash wxSVGGlyphRefElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (!m_glyphRef.IsEmpty())
    attrs.Add(wxT("glyphRef"), m_glyphRef);
  if (!m_format.IsEmpty())
    attrs.Add(wxT("format"), m_format);
  if (m_x > 0)
    attrs.Add(wxT("x"), wxString::Format(wxT("%g"), m_x));
  if (m_y > 0)
    attrs.Add(wxT("y"), wxString::Format(wxT("%g"), m_y));
  if (m_dx > 0)
    attrs.Add(wxT("dx"), wxString::Format(wxT("%g"), m_dx));
  if (m_dy > 0)
    attrs.Add(wxT("dy"), wxString::Format(wxT("%g"), m_dy));
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGURIReference::GetAttributes());
  attrs.Add(wxSVGStylable::GetAttributes());
  return attrs;
}

// wxSVGFESpotLightElement
wxSvgXmlAttrHash wxSVGFESpotLightElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (m_x.GetBaseVal() > 0)
    attrs.Add(wxT("x"), wxString::Format(wxT("%g"), m_x.GetBaseVal()));
  if (m_y.GetBaseVal() > 0)
    attrs.Add(wxT("y"), wxString::Format(wxT("%g"), m_y.GetBaseVal()));
  if (m_z.GetBaseVal() > 0)
    attrs.Add(wxT("z"), wxString::Format(wxT("%g"), m_z.GetBaseVal()));
  if (m_pointsAtX.GetBaseVal() > 0)
    attrs.Add(wxT("pointsAtX"), wxString::Format(wxT("%g"), m_pointsAtX.GetBaseVal()));
  if (m_pointsAtY.GetBaseVal() > 0)
    attrs.Add(wxT("pointsAtY"), wxString::Format(wxT("%g"), m_pointsAtY.GetBaseVal()));
  if (m_pointsAtZ.GetBaseVal() > 0)
    attrs.Add(wxT("pointsAtZ"), wxString::Format(wxT("%g"), m_pointsAtZ.GetBaseVal()));
  if (m_specularExponent.GetBaseVal() > 0)
    attrs.Add(wxT("specularExponent"), wxString::Format(wxT("%g"), m_specularExponent.GetBaseVal()));
  if (m_limitingConeAngle.GetBaseVal() > 0)
    attrs.Add(wxT("limitingConeAngle"), wxString::Format(wxT("%g"), m_limitingConeAngle.GetBaseVal()));
  attrs.Add(wxSVGElement::GetAttributes());
  return attrs;
}

// wxSVGAnimationElement
wxSvgXmlAttrHash wxSVGAnimationElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (!m_attributeName.IsEmpty())
    attrs.Add(wxT("attributeName"), m_attributeName);
  if (m_begin > 0)
    attrs.Add(wxT("begin"), wxString::Format(wxT("%g"), m_begin));
  if (m_dur > 0)
    attrs.Add(wxT("dur"), wxString::Format(wxT("%g"), m_dur));
  if (m_from.GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("from"), m_from.GetValueAsString());
  if (m_to.GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("to"), m_to.GetValueAsString());
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGTests::GetAttributes());
  attrs.Add(wxSVGExternalResourcesRequired::GetAttributes());
  return attrs;
}

// wxSVGAltGlyphDefElement
wxSvgXmlAttrHash wxSVGAltGlyphDefElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGElement::GetAttributes());
  return attrs;
}

// wxSVGFETurbulenceElement
wxSvgXmlAttrHash wxSVGFETurbulenceElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxT("numOctaves"), wxString::Format(wxT("%d"), (long int) m_numOctaves.GetBaseVal()));
  if (m_seed.GetBaseVal() > 0)
    attrs.Add(wxT("seed"), wxString::Format(wxT("%g"), m_seed.GetBaseVal()));
  if (m_stitchTiles.GetBaseVal() != 0)
    attrs.Add(wxT("stitchTiles"), wxString::Format(wxT("%d"), (char) m_stitchTiles.GetBaseVal()));
  if (m_type.GetBaseVal() != 0)
    attrs.Add(wxT("type"), wxString::Format(wxT("%d"), (char) m_type.GetBaseVal()));
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGFilterPrimitiveStandardAttributes::GetAttributes());
  return attrs;
}

// wxSVGComponentTransferFunctionElement
wxSvgXmlAttrHash wxSVGComponentTransferFunctionElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (m_type.GetBaseVal() != 0)
    attrs.Add(wxT("type"), wxString::Format(wxT("%d"), (char) m_type.GetBaseVal()));
  if (!m_tableValues.GetBaseVal().IsEmpty())
    attrs.Add(wxT("tableValues"), m_tableValues.GetBaseVal().GetValueAsString());
  if (m_slope.GetBaseVal() > 0)
    attrs.Add(wxT("slope"), wxString::Format(wxT("%g"), m_slope.GetBaseVal()));
  if (m_intercept.GetBaseVal() > 0)
    attrs.Add(wxT("intercept"), wxString::Format(wxT("%g"), m_intercept.GetBaseVal()));
  if (m_amplitude.GetBaseVal() > 0)
    attrs.Add(wxT("amplitude"), wxString::Format(wxT("%g"), m_amplitude.GetBaseVal()));
  if (m_exponent.GetBaseVal() > 0)
    attrs.Add(wxT("exponent"), wxString::Format(wxT("%g"), m_exponent.GetBaseVal()));
  if (m_offset.GetBaseVal() > 0)
    attrs.Add(wxT("offset"), wxString::Format(wxT("%g"), m_offset.GetBaseVal()));
  attrs.Add(wxSVGElement::GetAttributes());
  return attrs;
}

// wxSVGMPathElement
wxSvgXmlAttrHash wxSVGMPathElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGURIReference::GetAttributes());
  attrs.Add(wxSVGExternalResourcesRequired::GetAttributes());
  return attrs;
}

// wxSVGDefsElement
wxSvgXmlAttrHash wxSVGDefsElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGTests::GetAttributes());
  attrs.Add(wxSVGLangSpace::GetAttributes());
  attrs.Add(wxSVGExternalResourcesRequired::GetAttributes());
  attrs.Add(wxSVGStylable::GetAttributes());
  attrs.Add(wxSVGTransformable::GetAttributes());
  return attrs;
}

// wxSVGRectElement
wxSvgXmlAttrHash wxSVGRectElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (m_x.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("x"), m_x.GetBaseVal().GetValueAsString());
  if (m_y.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("y"), m_y.GetBaseVal().GetValueAsString());
  if (m_width.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("width"), m_width.GetBaseVal().GetValueAsString());
  if (m_height.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("height"), m_height.GetBaseVal().GetValueAsString());
  if (m_rx.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("rx"), m_rx.GetBaseVal().GetValueAsString());
  if (m_ry.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("ry"), m_ry.GetBaseVal().GetValueAsString());
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGTests::GetAttributes());
  attrs.Add(wxSVGLangSpace::GetAttributes());
  attrs.Add(wxSVGExternalResourcesRequired::GetAttributes());
  attrs.Add(wxSVGStylable::GetAttributes());
  attrs.Add(wxSVGTransformable::GetAttributes());
  return attrs;
}

// wxSVGPolylineElement
wxSvgXmlAttrHash wxSVGPolylineElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGTests::GetAttributes());
  attrs.Add(wxSVGLangSpace::GetAttributes());
  attrs.Add(wxSVGExternalResourcesRequired::GetAttributes());
  attrs.Add(wxSVGStylable::GetAttributes());
  attrs.Add(wxSVGTransformable::GetAttributes());
  attrs.Add(wxSVGAnimatedPoints::GetAttributes());
  return attrs;
}

// wxSVGColorProfileElement
wxSvgXmlAttrHash wxSVGColorProfileElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (!m_local.IsEmpty())
    attrs.Add(wxT("local"), m_local);
  if (!m_name.IsEmpty())
    attrs.Add(wxT("name"), m_name);
  attrs.Add(wxT("rendering-intent"), wxString::Format(wxT("%d"), (wxRENDERING_INTENT) m_renderingIntent));
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGURIReference::GetAttributes());
  return attrs;
}

// wxSVGAnimatedPoints
wxSvgXmlAttrHash wxSVGAnimatedPoints::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (!m_points.IsEmpty())
    attrs.Add(wxT("points"), m_points.GetValueAsString());
  return attrs;
}

// wxSVGCircleElement
wxSvgXmlAttrHash wxSVGCircleElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (m_cx.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("cx"), m_cx.GetBaseVal().GetValueAsString());
  if (m_cy.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("cy"), m_cy.GetBaseVal().GetValueAsString());
  if (m_r.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("r"), m_r.GetBaseVal().GetValueAsString());
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGTests::GetAttributes());
  attrs.Add(wxSVGLangSpace::GetAttributes());
  attrs.Add(wxSVGExternalResourcesRequired::GetAttributes());
  attrs.Add(wxSVGStylable::GetAttributes());
  attrs.Add(wxSVGTransformable::GetAttributes());
  return attrs;
}

// wxSVGTextContentElement
wxSvgXmlAttrHash wxSVGTextContentElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (m_textLength.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("textLength"), m_textLength.GetBaseVal().GetValueAsString());
  if (m_lengthAdjust.GetBaseVal() != 0)
    attrs.Add(wxT("lengthAdjust"), wxString::Format(wxT("%d"), (char) m_lengthAdjust.GetBaseVal()));
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGTests::GetAttributes());
  attrs.Add(wxSVGLangSpace::GetAttributes());
  attrs.Add(wxSVGExternalResourcesRequired::GetAttributes());
  attrs.Add(wxSVGStylable::GetAttributes());
  return attrs;
}

// wxSVGUseElement
wxSvgXmlAttrHash wxSVGUseElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (m_x.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("x"), m_x.GetBaseVal().GetValueAsString());
  if (m_y.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("y"), m_y.GetBaseVal().GetValueAsString());
  if (m_width.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("width"), m_width.GetBaseVal().GetValueAsString());
  if (m_height.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("height"), m_height.GetBaseVal().GetValueAsString());
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGURIReference::GetAttributes());
  attrs.Add(wxSVGTests::GetAttributes());
  attrs.Add(wxSVGLangSpace::GetAttributes());
  attrs.Add(wxSVGExternalResourcesRequired::GetAttributes());
  attrs.Add(wxSVGStylable::GetAttributes());
  attrs.Add(wxSVGTransformable::GetAttributes());
  return attrs;
}

// wxSVGMissingGlyphElement
wxSvgXmlAttrHash wxSVGMissingGlyphElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGStylable::GetAttributes());
  return attrs;
}

// wxSVGImageElement
wxSvgXmlAttrHash wxSVGImageElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (m_x.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("x"), m_x.GetBaseVal().GetValueAsString());
  if (m_y.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("y"), m_y.GetBaseVal().GetValueAsString());
  if (m_width.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("width"), m_width.GetBaseVal().GetValueAsString());
  if (m_height.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("height"), m_height.GetBaseVal().GetValueAsString());
  if (m_preserveAspectRatio.GetBaseVal().GetAlign() != wxSVG_PRESERVEASPECTRATIO_UNKNOWN && m_preserveAspectRatio.GetBaseVal().GetMeetOrSlice() != wxSVG_MEETORSLICE_UNKNOWN)
    attrs.Add(wxT("preserveAspectRatio"), m_preserveAspectRatio.GetBaseVal().GetValueAsString());
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGURIReference::GetAttributes());
  attrs.Add(wxSVGTests::GetAttributes());
  attrs.Add(wxSVGLangSpace::GetAttributes());
  attrs.Add(wxSVGExternalResourcesRequired::GetAttributes());
  attrs.Add(wxSVGStylable::GetAttributes());
  attrs.Add(wxSVGTransformable::GetAttributes());
  return attrs;
}

// wxSVGFEImageElement
wxSvgXmlAttrHash wxSVGFEImageElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGURIReference::GetAttributes());
  attrs.Add(wxSVGLangSpace::GetAttributes());
  attrs.Add(wxSVGExternalResourcesRequired::GetAttributes());
  attrs.Add(wxSVGFilterPrimitiveStandardAttributes::GetAttributes());
  return attrs;
}

// wxSVGTextPathElement
wxSvgXmlAttrHash wxSVGTextPathElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (m_startOffset.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("startOffset"), m_startOffset.GetBaseVal().GetValueAsString());
  if (m_method.GetBaseVal() != 0)
    attrs.Add(wxT("method"), wxString::Format(wxT("%d"), (char) m_method.GetBaseVal()));
  if (m_spacing.GetBaseVal() != 0)
    attrs.Add(wxT("spacing"), wxString::Format(wxT("%d"), (char) m_spacing.GetBaseVal()));
  attrs.Add(wxSVGTextContentElement::GetAttributes());
  attrs.Add(wxSVGURIReference::GetAttributes());
  return attrs;
}

// wxSVGFEFloodElement
wxSvgXmlAttrHash wxSVGFEFloodElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (!m_in1.GetBaseVal().IsEmpty())
    attrs.Add(wxT("in"), m_in1.GetBaseVal());
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGFilterPrimitiveStandardAttributes::GetAttributes());
  return attrs;
}

// wxSVGFontElement
wxSvgXmlAttrHash wxSVGFontElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGExternalResourcesRequired::GetAttributes());
  attrs.Add(wxSVGStylable::GetAttributes());
  return attrs;
}

// wxSVGVideoElement
wxSvgXmlAttrHash wxSVGVideoElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (m_x.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("x"), m_x.GetBaseVal().GetValueAsString());
  if (m_y.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("y"), m_y.GetBaseVal().GetValueAsString());
  if (m_width.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("width"), m_width.GetBaseVal().GetValueAsString());
  if (m_height.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("height"), m_height.GetBaseVal().GetValueAsString());
  if (m_preserveAspectRatio.GetBaseVal().GetAlign() != wxSVG_PRESERVEASPECTRATIO_UNKNOWN && m_preserveAspectRatio.GetBaseVal().GetMeetOrSlice() != wxSVG_MEETORSLICE_UNKNOWN)
    attrs.Add(wxT("preserveAspectRatio"), m_preserveAspectRatio.GetBaseVal().GetValueAsString());
  if (m_begin > 0)
    attrs.Add(wxT("begin"), wxString::Format(wxT("%g"), m_begin));
  if (m_dur > 0)
    attrs.Add(wxT("dur"), wxString::Format(wxT("%g"), m_dur));
  if (m_clipBegin > 0)
    attrs.Add(wxT("clipBegin"), wxString::Format(wxT("%g"), m_clipBegin));
  if (m_clipEnd > 0)
    attrs.Add(wxT("clipEnd"), wxString::Format(wxT("%g"), m_clipEnd));
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGURIReference::GetAttributes());
  attrs.Add(wxSVGLangSpace::GetAttributes());
  attrs.Add(wxSVGStylable::GetAttributes());
  attrs.Add(wxSVGTransformable::GetAttributes());
  return attrs;
}

// wxSVGRadialGradientElement
wxSvgXmlAttrHash wxSVGRadialGradientElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (m_cx.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("cx"), m_cx.GetBaseVal().GetValueAsString());
  if (m_cy.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("cy"), m_cy.GetBaseVal().GetValueAsString());
  if (m_r.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("r"), m_r.GetBaseVal().GetValueAsString());
  if (m_fx.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("fx"), m_fx.GetBaseVal().GetValueAsString());
  if (m_fy.GetBaseVal().GetUnitType() != wxSVG_LENGTHTYPE_UNKNOWN)
    attrs.Add(wxT("fy"), m_fy.GetBaseVal().GetValueAsString());
  attrs.Add(wxSVGGradientElement::GetAttributes());
  return attrs;
}

// wxSVGElement
wxSvgXmlAttrHash wxSVGElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (!m_id.IsEmpty())
    attrs.Add(wxT("id"), m_id);
  return attrs;
}

// wxSVGTitleElement
wxSvgXmlAttrHash wxSVGTitleElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGLangSpace::GetAttributes());
  attrs.Add(wxSVGStylable::GetAttributes());
  return attrs;
}

// wxSVGFEConvolveMatrixElement
wxSvgXmlAttrHash wxSVGFEConvolveMatrixElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (!m_kernelMatrix.GetBaseVal().IsEmpty())
    attrs.Add(wxT("kernelMatrix"), m_kernelMatrix.GetBaseVal().GetValueAsString());
  if (m_divisor.GetBaseVal() > 0)
    attrs.Add(wxT("divisor"), wxString::Format(wxT("%g"), m_divisor.GetBaseVal()));
  if (m_bias.GetBaseVal() > 0)
    attrs.Add(wxT("bias"), wxString::Format(wxT("%g"), m_bias.GetBaseVal()));
  attrs.Add(wxT("targetX"), wxString::Format(wxT("%d"), (long int) m_targetX.GetBaseVal()));
  attrs.Add(wxT("targetY"), wxString::Format(wxT("%d"), (long int) m_targetY.GetBaseVal()));
  if (m_edgeMode.GetBaseVal() != 0)
    attrs.Add(wxT("edgeMode"), wxString::Format(wxT("%d"), (char) m_edgeMode.GetBaseVal()));
  if (m_preserveAlpha.GetBaseVal())
    attrs.Add(wxT("preserveAlpha"), wxString::Format(wxT("%d"), (bool) m_preserveAlpha.GetBaseVal()));
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGFilterPrimitiveStandardAttributes::GetAttributes());
  return attrs;
}

// wxSVGFEGaussianBlurElement
wxSvgXmlAttrHash wxSVGFEGaussianBlurElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (!m_in1.GetBaseVal().IsEmpty())
    attrs.Add(wxT("in"), m_in1.GetBaseVal());
  attrs.Add(GetCustomAttributes());
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGFilterPrimitiveStandardAttributes::GetAttributes());
  return attrs;
}

// wxSVGGlyphElement
wxSvgXmlAttrHash wxSVGGlyphElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGStylable::GetAttributes());
  return attrs;
}

// wxSVGGElement
wxSvgXmlAttrHash wxSVGGElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGTests::GetAttributes());
  attrs.Add(wxSVGLangSpace::GetAttributes());
  attrs.Add(wxSVGExternalResourcesRequired::GetAttributes());
  attrs.Add(wxSVGStylable::GetAttributes());
  attrs.Add(wxSVGTransformable::GetAttributes());
  return attrs;
}

// wxSVGAnimateColorElement
wxSvgXmlAttrHash wxSVGAnimateColorElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGAnimationElement::GetAttributes());
  return attrs;
}

// wxSVGFEFuncGElement
wxSvgXmlAttrHash wxSVGFEFuncGElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGComponentTransferFunctionElement::GetAttributes());
  return attrs;
}

// wxSVGAltGlyphItemElement
wxSvgXmlAttrHash wxSVGAltGlyphItemElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGElement::GetAttributes());
  return attrs;
}

// wxSVGFESpecularLightingElement
wxSvgXmlAttrHash wxSVGFESpecularLightingElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  if (!m_in1.GetBaseVal().IsEmpty())
    attrs.Add(wxT("in"), m_in1.GetBaseVal());
  if (m_surfaceScale.GetBaseVal() > 0)
    attrs.Add(wxT("surfaceScale"), wxString::Format(wxT("%g"), m_surfaceScale.GetBaseVal()));
  if (m_specularConstant.GetBaseVal() > 0)
    attrs.Add(wxT("specularConstant"), wxString::Format(wxT("%g"), m_specularConstant.GetBaseVal()));
  if (m_specularExponent.GetBaseVal() > 0)
    attrs.Add(wxT("specularExponent"), wxString::Format(wxT("%g"), m_specularExponent.GetBaseVal()));
  attrs.Add(wxSVGElement::GetAttributes());
  attrs.Add(wxSVGFilterPrimitiveStandardAttributes::GetAttributes());
  return attrs;
}

// wxSVGTRefElement
wxSvgXmlAttrHash wxSVGTRefElement::GetAttributes() const
{
  wxSvgXmlAttrHash attrs;
  attrs.Add(wxSVGTextPositioningElement::GetAttributes());
  attrs.Add(wxSVGURIReference::GetAttributes());
  return attrs;
}

