use strict;
use warnings;

sub makevmatchargumenttable
{
  my ($minlength,$mindist,$query,$database) = @_;
  my $seedlength = $minlength - 2;
  my @arglisttable =
  (

    "-d -l ${minlength} -selfun selnone.so -best 10 -i ${database}",
    "-d -l ${minlength} -selfun selnone.so -i ${database}",
    "-d -l ${minlength} -best 10 -i ${database}",
    "-d -l ${minlength} -i ${database}",
    "-d -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -l ${minlength} -selfun selnone.so ${database}",
    "-d -l ${minlength} -best 10 ${database}",
    "-d -l ${minlength} ${database}",
    "-d -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -i ${database}",
    "-d -h ${mindist} -l ${minlength} -allmax -i ${database}",
    "-d -h ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-d -h ${mindist} -l ${minlength} -allmax ${database}",
    "-d -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -i ${database}",
    "-d -e ${mindist} -l ${minlength} -allmax -i ${database}",
    "-d -e ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-d -e ${mindist} -l ${minlength} -allmax ${database}",
    "-d -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -i ${database}",
    "-d -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -i ${database}",
    "-d -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -i ${database}",
    "-d -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -i ${database}",
    "-d -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-d -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-d -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} ${database}",
    "-d -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -i ${database}",
    "-d -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -i ${database}",
    "-d -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -i ${database}",
    "-d -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -i ${database}",
    "-d -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-d -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-d -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} ${database}",
    "-d -showdesc 20 -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -showdesc 20 -l ${minlength} -selfun selnone.so ${database}",
    "-d -showdesc 20 -l ${minlength} -best 10 ${database}",
    "-d -showdesc 20 -l ${minlength} ${database}",
    "-d -showdesc 20 -h ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-d -showdesc 20 -h ${mindist} -l ${minlength} -allmax ${database}",
    "-d -showdesc 20 -e ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-d -showdesc 20 -e ${mindist} -l ${minlength} -allmax ${database}",
    "-d -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-d -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-d -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} ${database}",
    "-d -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-d -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-d -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} ${database}",
    "-d -dbnomatch 100 -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -dbnomatch 100 -l ${minlength} -selfun selnone.so ${database}",
    "-d -dbnomatch 100 -l ${minlength} -best 10 ${database}",
    "-d -dbnomatch 100 -l ${minlength} ${database}",
    "-d -dbnomatch 100 -h ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-d -dbnomatch 100 -h ${mindist} -l ${minlength} -allmax ${database}",
    "-d -dbnomatch 100 -e ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-d -dbnomatch 100 -e ${mindist} -l ${minlength} -allmax ${database}",
    "-d -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-d -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-d -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} ${database}",
    "-d -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-d -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-d -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} ${database}",
    "-d -dbmaskmatch X -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -dbmaskmatch X -l ${minlength} -selfun selnone.so ${database}",
    "-d -dbmaskmatch X -l ${minlength} -best 10 ${database}",
    "-d -dbmaskmatch X -l ${minlength} ${database}",
    "-d -dbmaskmatch X -h ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-d -dbmaskmatch X -h ${mindist} -l ${minlength} -allmax ${database}",
    "-d -dbmaskmatch X -e ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-d -dbmaskmatch X -e ${mindist} -l ${minlength} -allmax ${database}",
    "-d -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-d -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-d -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} ${database}",
    "-d -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-d -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-d -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} ${database}",
    "-d -dbcluster 50 50 -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -dbcluster 50 50 -l ${minlength} -selfun selnone.so ${database}",
    "-d -dbcluster 50 50 -l ${minlength} -best 10 ${database}",
    "-d -dbcluster 50 50 -l ${minlength} ${database}",
    "-d -dbcluster 50 50 -h ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-d -dbcluster 50 50 -h ${mindist} -l ${minlength} -allmax ${database}",
    "-d -dbcluster 50 50 -e ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-d -dbcluster 50 50 -e ${mindist} -l ${minlength} -allmax ${database}",
    "-d -dbcluster 50 50 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -dbcluster 50 50 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-d -dbcluster 50 50 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-d -dbcluster 50 50 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} ${database}",
    "-d -dbcluster 50 50 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -dbcluster 50 50 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-d -dbcluster 50 50 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-d -dbcluster 50 50 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} ${database}",
    "-d -pp chain local 6b -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -pp chain local 6b -l ${minlength} -selfun selnone.so ${database}",
    "-d -pp chain local 6b -l ${minlength} -best 10 ${database}",
    "-d -pp chain local 6b -l ${minlength} ${database}",
    "-d -pp chain local 6b -h ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-d -pp chain local 6b -h ${mindist} -l ${minlength} -allmax ${database}",
    "-d -pp chain local 6b -e ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-d -pp chain local 6b -e ${mindist} -l ${minlength} -allmax ${database}",
    "-d -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-d -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-d -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} ${database}",
    "-d -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-d -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-d -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -l ${minlength} -selfun selnone.so ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -l ${minlength} -best 10 ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -l ${minlength} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -h ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -h ${mindist} -l ${minlength} -allmax ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -e ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -e ${mindist} -l ${minlength} -allmax ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} ${database}",
    "-d -l ${minlength} -online -selfun selnone.so -best 10 -i -q ${query} ${database}",
    "-d -l ${minlength} -online -selfun selnone.so -i -q ${query} ${database}",
    "-d -l ${minlength} -online -best 10 -i -q ${query} ${database}",
    "-d -l ${minlength} -online -i -q ${query} ${database}",
    "-d -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-d -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-d -l ${minlength} -online -q ${query} ${database}",
    "-d -l ${minlength} -selfun selnone.so -best 10 -i -q ${query} ${database}",
    "-d -l ${minlength} -selfun selnone.so -i -q ${query} ${database}",
    "-d -l ${minlength} -best 10 -i -q ${query} ${database}",
    "-d -l ${minlength} -i -q ${query} ${database}",
    "-d -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -l ${minlength} -q ${query} ${database}",
    "-d -h ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -i -q ${query} ${database}",
    "-d -h ${mindist} -l ${minlength} -online -allmax -i -q ${query} ${database}",
    "-d -h ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -h ${mindist} -l ${minlength} -online -allmax -q ${query} ${database}",
    "-d -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -i -q ${query} ${database}",
    "-d -h ${mindist} -l ${minlength} -allmax -i -q ${query} ${database}",
    "-d -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -h ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-d -e ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -i -q ${query} ${database}",
    "-d -e ${mindist} -l ${minlength} -online -allmax -i -q ${query} ${database}",
    "-d -e ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -e ${mindist} -l ${minlength} -online -allmax -q ${query} ${database}",
    "-d -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -i -q ${query} ${database}",
    "-d -e ${mindist} -l ${minlength} -allmax -i -q ${query} ${database}",
    "-d -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -e ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-d -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -i -q ${query} ${database}",
    "-d -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -i -q ${query} ${database}",
    "-d -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -best 10 -i -q ${query} ${database}",
    "-d -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -i -q ${query} ${database}",
    "-d -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-d -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-d -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -q ${query} ${database}",
    "-d -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -i -q ${query} ${database}",
    "-d -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -i -q ${query} ${database}",
    "-d -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -i -q ${query} ${database}",
    "-d -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -i -q ${query} ${database}",
    "-d -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-d -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -i -q ${query} ${database}",
    "-d -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -i -q ${query} ${database}",
    "-d -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -best 10 -i -q ${query} ${database}",
    "-d -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -i -q ${query} ${database}",
    "-d -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-d -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-d -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -q ${query} ${database}",
    "-d -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -i -q ${query} ${database}",
    "-d -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -i -q ${query} ${database}",
    "-d -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -i -q ${query} ${database}",
    "-d -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -i -q ${query} ${database}",
    "-d -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-d -showdesc 20 -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -showdesc 20 -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-d -showdesc 20 -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-d -showdesc 20 -l ${minlength} -online -q ${query} ${database}",
    "-d -showdesc 20 -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -showdesc 20 -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -showdesc 20 -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -showdesc 20 -l ${minlength} -q ${query} ${database}",
    "-d -showdesc 20 -h ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -showdesc 20 -h ${mindist} -l ${minlength} -online -allmax -q ${query} ${database}",
    "-d -showdesc 20 -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -showdesc 20 -h ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-d -showdesc 20 -e ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -showdesc 20 -e ${mindist} -l ${minlength} -online -allmax -q ${query} ${database}",
    "-d -showdesc 20 -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -showdesc 20 -e ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-d -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-d -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-d -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -q ${query} ${database}",
    "-d -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-d -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-d -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-d -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -q ${query} ${database}",
    "-d -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-d -dbnomatch 100 -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -dbnomatch 100 -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-d -dbnomatch 100 -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-d -dbnomatch 100 -l ${minlength} -online -q ${query} ${database}",
    "-d -dbnomatch 100 -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -dbnomatch 100 -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -dbnomatch 100 -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -dbnomatch 100 -l ${minlength} -q ${query} ${database}",
    "-d -dbnomatch 100 -h ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -dbnomatch 100 -h ${mindist} -l ${minlength} -online -allmax -q ${query} ${database}",
    "-d -dbnomatch 100 -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -dbnomatch 100 -h ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-d -dbnomatch 100 -e ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -dbnomatch 100 -e ${mindist} -l ${minlength} -online -allmax -q ${query} ${database}",
    "-d -dbnomatch 100 -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -dbnomatch 100 -e ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-d -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-d -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-d -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -q ${query} ${database}",
    "-d -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-d -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-d -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-d -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -q ${query} ${database}",
    "-d -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-d -qnomatch 100 -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -qnomatch 100 -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-d -qnomatch 100 -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-d -qnomatch 100 -l ${minlength} -online -q ${query} ${database}",
    "-d -qnomatch 100 -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -qnomatch 100 -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -qnomatch 100 -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -qnomatch 100 -l ${minlength} -q ${query} ${database}",
    "-d -qnomatch 100 -h ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -qnomatch 100 -h ${mindist} -l ${minlength} -online -allmax -q ${query} ${database}",
    "-d -qnomatch 100 -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -qnomatch 100 -h ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-d -qnomatch 100 -e ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -qnomatch 100 -e ${mindist} -l ${minlength} -online -allmax -q ${query} ${database}",
    "-d -qnomatch 100 -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -qnomatch 100 -e ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-d -qnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -qnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-d -qnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-d -qnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -q ${query} ${database}",
    "-d -qnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -qnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -qnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -qnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-d -qnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -qnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-d -qnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-d -qnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -q ${query} ${database}",
    "-d -qnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -qnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -qnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -qnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-d -dbmaskmatch X -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -dbmaskmatch X -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-d -dbmaskmatch X -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-d -dbmaskmatch X -l ${minlength} -online -q ${query} ${database}",
    "-d -dbmaskmatch X -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -dbmaskmatch X -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -dbmaskmatch X -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -dbmaskmatch X -l ${minlength} -q ${query} ${database}",
    "-d -dbmaskmatch X -h ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -dbmaskmatch X -h ${mindist} -l ${minlength} -online -allmax -q ${query} ${database}",
    "-d -dbmaskmatch X -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -dbmaskmatch X -h ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-d -dbmaskmatch X -e ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -dbmaskmatch X -e ${mindist} -l ${minlength} -online -allmax -q ${query} ${database}",
    "-d -dbmaskmatch X -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -dbmaskmatch X -e ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-d -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-d -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-d -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -q ${query} ${database}",
    "-d -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-d -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-d -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-d -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -q ${query} ${database}",
    "-d -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-d -qmaskmatch X -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -qmaskmatch X -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-d -qmaskmatch X -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-d -qmaskmatch X -l ${minlength} -online -q ${query} ${database}",
    "-d -qmaskmatch X -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -qmaskmatch X -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -qmaskmatch X -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -qmaskmatch X -l ${minlength} -q ${query} ${database}",
    "-d -qmaskmatch X -h ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -qmaskmatch X -h ${mindist} -l ${minlength} -online -allmax -q ${query} ${database}",
    "-d -qmaskmatch X -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -qmaskmatch X -h ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-d -qmaskmatch X -e ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -qmaskmatch X -e ${mindist} -l ${minlength} -online -allmax -q ${query} ${database}",
    "-d -qmaskmatch X -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -qmaskmatch X -e ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-d -qmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -qmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-d -qmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-d -qmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -q ${query} ${database}",
    "-d -qmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -qmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -qmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -qmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-d -qmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -qmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-d -qmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-d -qmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -q ${query} ${database}",
    "-d -qmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -qmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -qmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -qmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-d -pp chain local 6b -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -pp chain local 6b -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-d -pp chain local 6b -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-d -pp chain local 6b -l ${minlength} -online -q ${query} ${database}",
    "-d -pp chain local 6b -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -pp chain local 6b -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -pp chain local 6b -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -pp chain local 6b -l ${minlength} -q ${query} ${database}",
    "-d -pp chain local 6b -h ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -pp chain local 6b -h ${mindist} -l ${minlength} -online -allmax -q ${query} ${database}",
    "-d -pp chain local 6b -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -pp chain local 6b -h ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-d -pp chain local 6b -e ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -pp chain local 6b -e ${mindist} -l ${minlength} -online -allmax -q ${query} ${database}",
    "-d -pp chain local 6b -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -pp chain local 6b -e ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-d -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-d -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-d -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -q ${query} ${database}",
    "-d -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-d -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-d -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-d -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -q ${query} ${database}",
    "-d -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -l ${minlength} -online -q ${query} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -l ${minlength} -q ${query} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -h ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -h ${mindist} -l ${minlength} -online -allmax -q ${query} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -h ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -e ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -e ${mindist} -l ${minlength} -online -allmax -q ${query} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -e ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -q ${query} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -q ${query} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-d -mum -l ${minlength} -selfun selnone.so -best 10 -i -q ${query} ${database}",
    "-d -mum -l ${minlength} -selfun selnone.so -i -q ${query} ${database}",
    "-d -mum -l ${minlength} -best 10 -i -q ${query} ${database}",
    "-d -mum -l ${minlength} -i -q ${query} ${database}",
    "-d -mum -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -mum -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -mum -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -mum -l ${minlength} -q ${query} ${database}",
    "-d -mum -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -i -q ${query} ${database}",
    "-d -mum -h ${mindist} -l ${minlength} -allmax -i -q ${query} ${database}",
    "-d -mum -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -mum -h ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-d -mum -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -i -q ${query} ${database}",
    "-d -mum -e ${mindist} -l ${minlength} -allmax -i -q ${query} ${database}",
    "-d -mum -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -mum -e ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-d -mum -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -i -q ${query} ${database}",
    "-d -mum -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -i -q ${query} ${database}",
    "-d -mum -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -i -q ${query} ${database}",
    "-d -mum -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -i -q ${query} ${database}",
    "-d -mum -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -mum -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -mum -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -mum -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-d -mum -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -i -q ${query} ${database}",
    "-d -mum -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -i -q ${query} ${database}",
    "-d -mum -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -i -q ${query} ${database}",
    "-d -mum -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -i -q ${query} ${database}",
    "-d -mum -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -mum -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -mum -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -mum -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-d -mum -showdesc 20 -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -mum -showdesc 20 -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -mum -showdesc 20 -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -mum -showdesc 20 -l ${minlength} -q ${query} ${database}",
    "-d -mum -showdesc 20 -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -mum -showdesc 20 -h ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-d -mum -showdesc 20 -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -mum -showdesc 20 -e ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-d -mum -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -mum -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -mum -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -mum -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-d -mum -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -mum -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -mum -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -mum -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-d -mum -dbnomatch 100 -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -mum -dbnomatch 100 -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -mum -dbnomatch 100 -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -mum -dbnomatch 100 -l ${minlength} -q ${query} ${database}",
    "-d -mum -dbnomatch 100 -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -mum -dbnomatch 100 -h ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-d -mum -dbnomatch 100 -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -mum -dbnomatch 100 -e ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-d -mum -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -mum -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -mum -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -mum -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-d -mum -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -mum -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -mum -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -mum -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-d -mum -qnomatch 100 -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -mum -qnomatch 100 -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -mum -qnomatch 100 -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -mum -qnomatch 100 -l ${minlength} -q ${query} ${database}",
    "-d -mum -qnomatch 100 -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -mum -qnomatch 100 -h ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-d -mum -qnomatch 100 -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -mum -qnomatch 100 -e ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-d -mum -qnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -mum -qnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -mum -qnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -mum -qnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-d -mum -qnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -mum -qnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -mum -qnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -mum -qnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-d -mum -dbmaskmatch X -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -mum -dbmaskmatch X -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -mum -dbmaskmatch X -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -mum -dbmaskmatch X -l ${minlength} -q ${query} ${database}",
    "-d -mum -dbmaskmatch X -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -mum -dbmaskmatch X -h ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-d -mum -dbmaskmatch X -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -mum -dbmaskmatch X -e ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-d -mum -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -mum -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -mum -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -mum -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-d -mum -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -mum -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -mum -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -mum -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-d -mum -qmaskmatch X -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -mum -qmaskmatch X -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -mum -qmaskmatch X -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -mum -qmaskmatch X -l ${minlength} -q ${query} ${database}",
    "-d -mum -qmaskmatch X -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -mum -qmaskmatch X -h ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-d -mum -qmaskmatch X -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -mum -qmaskmatch X -e ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-d -mum -qmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -mum -qmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -mum -qmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -mum -qmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-d -mum -qmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -mum -qmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -mum -qmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -mum -qmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-d -mum -pp chain local 6b -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -mum -pp chain local 6b -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -mum -pp chain local 6b -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -mum -pp chain local 6b -l ${minlength} -q ${query} ${database}",
    "-d -mum -pp chain local 6b -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -mum -pp chain local 6b -h ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-d -mum -pp chain local 6b -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -mum -pp chain local 6b -e ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-d -mum -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -mum -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -mum -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -mum -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-d -mum -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -mum -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -mum -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -mum -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-d -mum -pp matchcluster erate 3 outprefix clout -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -mum -pp matchcluster erate 3 outprefix clout -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -mum -pp matchcluster erate 3 outprefix clout -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -mum -pp matchcluster erate 3 outprefix clout -l ${minlength} -q ${query} ${database}",
    "-d -mum -pp matchcluster erate 3 outprefix clout -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -mum -pp matchcluster erate 3 outprefix clout -h ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-d -mum -pp matchcluster erate 3 outprefix clout -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-d -mum -pp matchcluster erate 3 outprefix clout -e ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-d -mum -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -mum -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -mum -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -mum -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-d -mum -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -mum -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-d -mum -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-d -mum -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-d -tandem -l ${minlength} -selfun selnone.so -best 10 -i ${database}",
    "-d -tandem -l ${minlength} -selfun selnone.so -i ${database}",
    "-d -tandem -l ${minlength} -best 10 -i ${database}",
    "-d -tandem -l ${minlength} -i ${database}",
    "-d -tandem -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -tandem -l ${minlength} -selfun selnone.so ${database}",
    "-d -tandem -l ${minlength} -best 10 ${database}",
    "-d -tandem -l ${minlength} ${database}",
    "-d -tandem -showdesc 20 -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -tandem -showdesc 20 -l ${minlength} -selfun selnone.so ${database}",
    "-d -tandem -showdesc 20 -l ${minlength} -best 10 ${database}",
    "-d -tandem -showdesc 20 -l ${minlength} ${database}",
    "-d -tandem -dbnomatch 100 -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -tandem -dbnomatch 100 -l ${minlength} -selfun selnone.so ${database}",
    "-d -tandem -dbnomatch 100 -l ${minlength} -best 10 ${database}",
    "-d -tandem -dbnomatch 100 -l ${minlength} ${database}",
    "-d -tandem -dbmaskmatch X -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -tandem -dbmaskmatch X -l ${minlength} -selfun selnone.so ${database}",
    "-d -tandem -dbmaskmatch X -l ${minlength} -best 10 ${database}",
    "-d -tandem -dbmaskmatch X -l ${minlength} ${database}",
    "-d -tandem -pp matchcluster erate 3 outprefix clout -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -tandem -pp matchcluster erate 3 outprefix clout -l ${minlength} -selfun selnone.so ${database}",
    "-d -tandem -pp matchcluster erate 3 outprefix clout -l ${minlength} -best 10 ${database}",
    "-d -tandem -pp matchcluster erate 3 outprefix clout -l ${minlength} ${database}",
    "-d -supermax -l ${minlength} -selfun selnone.so -best 10 -i ${database}",
    "-d -supermax -l ${minlength} -selfun selnone.so -i ${database}",
    "-d -supermax -l ${minlength} -best 10 -i ${database}",
    "-d -supermax -l ${minlength} -i ${database}",
    "-d -supermax -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -supermax -l ${minlength} -selfun selnone.so ${database}",
    "-d -supermax -l ${minlength} -best 10 ${database}",
    "-d -supermax -l ${minlength} ${database}",
    "-d -supermax -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -i ${database}",
    "-d -supermax -h ${mindist} -l ${minlength} -allmax -i ${database}",
    "-d -supermax -h ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-d -supermax -h ${mindist} -l ${minlength} -allmax ${database}",
    "-d -supermax -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -i ${database}",
    "-d -supermax -e ${mindist} -l ${minlength} -allmax -i ${database}",
    "-d -supermax -e ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-d -supermax -e ${mindist} -l ${minlength} -allmax ${database}",
    "-d -supermax -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -i ${database}",
    "-d -supermax -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -i ${database}",
    "-d -supermax -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -i ${database}",
    "-d -supermax -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -i ${database}",
    "-d -supermax -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -supermax -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-d -supermax -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-d -supermax -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} ${database}",
    "-d -supermax -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -i ${database}",
    "-d -supermax -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -i ${database}",
    "-d -supermax -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -i ${database}",
    "-d -supermax -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -i ${database}",
    "-d -supermax -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -supermax -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-d -supermax -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-d -supermax -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} ${database}",
    "-d -supermax -showdesc 20 -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -supermax -showdesc 20 -l ${minlength} -selfun selnone.so ${database}",
    "-d -supermax -showdesc 20 -l ${minlength} -best 10 ${database}",
    "-d -supermax -showdesc 20 -l ${minlength} ${database}",
    "-d -supermax -showdesc 20 -h ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-d -supermax -showdesc 20 -h ${mindist} -l ${minlength} -allmax ${database}",
    "-d -supermax -showdesc 20 -e ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-d -supermax -showdesc 20 -e ${mindist} -l ${minlength} -allmax ${database}",
    "-d -supermax -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -supermax -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-d -supermax -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-d -supermax -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} ${database}",
    "-d -supermax -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -supermax -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-d -supermax -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-d -supermax -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} ${database}",
    "-d -supermax -dbnomatch 100 -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -supermax -dbnomatch 100 -l ${minlength} -selfun selnone.so ${database}",
    "-d -supermax -dbnomatch 100 -l ${minlength} -best 10 ${database}",
    "-d -supermax -dbnomatch 100 -l ${minlength} ${database}",
    "-d -supermax -dbnomatch 100 -h ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-d -supermax -dbnomatch 100 -h ${mindist} -l ${minlength} -allmax ${database}",
    "-d -supermax -dbnomatch 100 -e ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-d -supermax -dbnomatch 100 -e ${mindist} -l ${minlength} -allmax ${database}",
    "-d -supermax -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -supermax -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-d -supermax -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-d -supermax -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} ${database}",
    "-d -supermax -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -supermax -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-d -supermax -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-d -supermax -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} ${database}",
    "-d -supermax -dbmaskmatch X -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -supermax -dbmaskmatch X -l ${minlength} -selfun selnone.so ${database}",
    "-d -supermax -dbmaskmatch X -l ${minlength} -best 10 ${database}",
    "-d -supermax -dbmaskmatch X -l ${minlength} ${database}",
    "-d -supermax -dbmaskmatch X -h ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-d -supermax -dbmaskmatch X -h ${mindist} -l ${minlength} -allmax ${database}",
    "-d -supermax -dbmaskmatch X -e ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-d -supermax -dbmaskmatch X -e ${mindist} -l ${minlength} -allmax ${database}",
    "-d -supermax -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -supermax -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-d -supermax -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-d -supermax -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} ${database}",
    "-d -supermax -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -supermax -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-d -supermax -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-d -supermax -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} ${database}",
    "-d -supermax -dbcluster 50 50 -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -supermax -dbcluster 50 50 -l ${minlength} -selfun selnone.so ${database}",
    "-d -supermax -dbcluster 50 50 -l ${minlength} -best 10 ${database}",
    "-d -supermax -dbcluster 50 50 -l ${minlength} ${database}",
    "-d -supermax -dbcluster 50 50 -h ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-d -supermax -dbcluster 50 50 -h ${mindist} -l ${minlength} -allmax ${database}",
    "-d -supermax -dbcluster 50 50 -e ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-d -supermax -dbcluster 50 50 -e ${mindist} -l ${minlength} -allmax ${database}",
    "-d -supermax -dbcluster 50 50 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -supermax -dbcluster 50 50 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-d -supermax -dbcluster 50 50 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-d -supermax -dbcluster 50 50 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} ${database}",
    "-d -supermax -dbcluster 50 50 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -supermax -dbcluster 50 50 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-d -supermax -dbcluster 50 50 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-d -supermax -dbcluster 50 50 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} ${database}",
    "-d -supermax -pp chain local 6b -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -supermax -pp chain local 6b -l ${minlength} -selfun selnone.so ${database}",
    "-d -supermax -pp chain local 6b -l ${minlength} -best 10 ${database}",
    "-d -supermax -pp chain local 6b -l ${minlength} ${database}",
    "-d -supermax -pp chain local 6b -h ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-d -supermax -pp chain local 6b -h ${mindist} -l ${minlength} -allmax ${database}",
    "-d -supermax -pp chain local 6b -e ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-d -supermax -pp chain local 6b -e ${mindist} -l ${minlength} -allmax ${database}",
    "-d -supermax -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -supermax -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-d -supermax -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-d -supermax -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} ${database}",
    "-d -supermax -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -supermax -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-d -supermax -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-d -supermax -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} ${database}",
    "-d -supermax -pp matchcluster erate 3 outprefix clout -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -supermax -pp matchcluster erate 3 outprefix clout -l ${minlength} -selfun selnone.so ${database}",
    "-d -supermax -pp matchcluster erate 3 outprefix clout -l ${minlength} -best 10 ${database}",
    "-d -supermax -pp matchcluster erate 3 outprefix clout -l ${minlength} ${database}",
    "-d -supermax -pp matchcluster erate 3 outprefix clout -h ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-d -supermax -pp matchcluster erate 3 outprefix clout -h ${mindist} -l ${minlength} -allmax ${database}",
    "-d -supermax -pp matchcluster erate 3 outprefix clout -e ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-d -supermax -pp matchcluster erate 3 outprefix clout -e ${mindist} -l ${minlength} -allmax ${database}",
    "-d -supermax -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -supermax -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-d -supermax -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-d -supermax -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} ${database}",
    "-d -supermax -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-d -supermax -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-d -supermax -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-d -supermax -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} ${database}",
    "-d -complete -online -selfun selnone.so -best 10 -i -q ${query} ${database}",
    "-d -complete -online -selfun selnone.so -i -q ${query} ${database}",
    "-d -complete -online -best 10 -i -q ${query} ${database}",
    "-d -complete -online -i -q ${query} ${database}",
    "-d -complete -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -complete -online -selfun selnone.so -q ${query} ${database}",
    "-d -complete -online -best 10 -q ${query} ${database}",
    "-d -complete -online -q ${query} ${database}",
    "-d -complete -selfun selnone.so -best 10 -i -q ${query} ${database}",
    "-d -complete -selfun selnone.so -i -q ${query} ${database}",
    "-d -complete -best 10 -i -q ${query} ${database}",
    "-d -complete -i -q ${query} ${database}",
    "-d -complete -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -complete -selfun selnone.so -q ${query} ${database}",
    "-d -complete -best 10 -q ${query} ${database}",
    "-d -complete -q ${query} ${database}",
    "-d -complete -showdesc 20 -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -complete -showdesc 20 -online -selfun selnone.so -q ${query} ${database}",
    "-d -complete -showdesc 20 -online -best 10 -q ${query} ${database}",
    "-d -complete -showdesc 20 -online -q ${query} ${database}",
    "-d -complete -showdesc 20 -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -complete -showdesc 20 -selfun selnone.so -q ${query} ${database}",
    "-d -complete -showdesc 20 -best 10 -q ${query} ${database}",
    "-d -complete -showdesc 20 -q ${query} ${database}",
    "-d -complete -dbnomatch 100 -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -complete -dbnomatch 100 -online -selfun selnone.so -q ${query} ${database}",
    "-d -complete -dbnomatch 100 -online -best 10 -q ${query} ${database}",
    "-d -complete -dbnomatch 100 -online -q ${query} ${database}",
    "-d -complete -dbnomatch 100 -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -complete -dbnomatch 100 -selfun selnone.so -q ${query} ${database}",
    "-d -complete -dbnomatch 100 -best 10 -q ${query} ${database}",
    "-d -complete -dbnomatch 100 -q ${query} ${database}",
    "-d -complete -qnomatch 100 -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -complete -qnomatch 100 -online -selfun selnone.so -q ${query} ${database}",
    "-d -complete -qnomatch 100 -online -best 10 -q ${query} ${database}",
    "-d -complete -qnomatch 100 -online -q ${query} ${database}",
    "-d -complete -qnomatch 100 -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -complete -qnomatch 100 -selfun selnone.so -q ${query} ${database}",
    "-d -complete -qnomatch 100 -best 10 -q ${query} ${database}",
    "-d -complete -qnomatch 100 -q ${query} ${database}",
    "-d -complete -dbmaskmatch X -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -complete -dbmaskmatch X -online -selfun selnone.so -q ${query} ${database}",
    "-d -complete -dbmaskmatch X -online -best 10 -q ${query} ${database}",
    "-d -complete -dbmaskmatch X -online -q ${query} ${database}",
    "-d -complete -dbmaskmatch X -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -complete -dbmaskmatch X -selfun selnone.so -q ${query} ${database}",
    "-d -complete -dbmaskmatch X -best 10 -q ${query} ${database}",
    "-d -complete -dbmaskmatch X -q ${query} ${database}",
    "-d -complete -qmaskmatch X -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -complete -qmaskmatch X -online -selfun selnone.so -q ${query} ${database}",
    "-d -complete -qmaskmatch X -online -best 10 -q ${query} ${database}",
    "-d -complete -qmaskmatch X -online -q ${query} ${database}",
    "-d -complete -qmaskmatch X -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -complete -qmaskmatch X -selfun selnone.so -q ${query} ${database}",
    "-d -complete -qmaskmatch X -best 10 -q ${query} ${database}",
    "-d -complete -qmaskmatch X -q ${query} ${database}",
    "-d -complete -pp chain local 6b -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -complete -pp chain local 6b -online -selfun selnone.so -q ${query} ${database}",
    "-d -complete -pp chain local 6b -online -best 10 -q ${query} ${database}",
    "-d -complete -pp chain local 6b -online -q ${query} ${database}",
    "-d -complete -pp chain local 6b -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -complete -pp chain local 6b -selfun selnone.so -q ${query} ${database}",
    "-d -complete -pp chain local 6b -best 10 -q ${query} ${database}",
    "-d -complete -pp chain local 6b -q ${query} ${database}",
    "-d -complete -pp matchcluster erate 3 outprefix clout -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -complete -pp matchcluster erate 3 outprefix clout -online -selfun selnone.so -q ${query} ${database}",
    "-d -complete -pp matchcluster erate 3 outprefix clout -online -best 10 -q ${query} ${database}",
    "-d -complete -pp matchcluster erate 3 outprefix clout -online -q ${query} ${database}",
    "-d -complete -pp matchcluster erate 3 outprefix clout -selfun selnone.so -best 10 -q ${query} ${database}",
    "-d -complete -pp matchcluster erate 3 outprefix clout -selfun selnone.so -q ${query} ${database}",
    "-d -complete -pp matchcluster erate 3 outprefix clout -best 10 -q ${query} ${database}",
    "-d -complete -pp matchcluster erate 3 outprefix clout -q ${query} ${database}",
    "-p -l ${minlength} -selfun selnone.so -best 10 -i ${database}",
    "-p -l ${minlength} -selfun selnone.so -i ${database}",
    "-p -l ${minlength} -best 10 -i ${database}",
    "-p -l ${minlength} -i ${database}",
    "-p -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-p -l ${minlength} -selfun selnone.so ${database}",
    "-p -l ${minlength} -best 10 ${database}",
    "-p -l ${minlength} ${database}",
    "-p -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -i ${database}",
    "-p -h ${mindist} -l ${minlength} -allmax -i ${database}",
    "-p -h ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-p -h ${mindist} -l ${minlength} -allmax ${database}",
    "-p -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -i ${database}",
    "-p -e ${mindist} -l ${minlength} -allmax -i ${database}",
    "-p -e ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-p -e ${mindist} -l ${minlength} -allmax ${database}",
    "-p -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -i ${database}",
    "-p -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -i ${database}",
    "-p -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -i ${database}",
    "-p -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -i ${database}",
    "-p -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-p -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-p -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-p -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} ${database}",
    "-p -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -i ${database}",
    "-p -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -i ${database}",
    "-p -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -i ${database}",
    "-p -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -i ${database}",
    "-p -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-p -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-p -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-p -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} ${database}",
    "-p -showdesc 20 -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-p -showdesc 20 -l ${minlength} -selfun selnone.so ${database}",
    "-p -showdesc 20 -l ${minlength} -best 10 ${database}",
    "-p -showdesc 20 -l ${minlength} ${database}",
    "-p -showdesc 20 -h ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-p -showdesc 20 -h ${mindist} -l ${minlength} -allmax ${database}",
    "-p -showdesc 20 -e ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-p -showdesc 20 -e ${mindist} -l ${minlength} -allmax ${database}",
    "-p -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-p -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-p -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-p -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} ${database}",
    "-p -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-p -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-p -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-p -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} ${database}",
    "-p -dbnomatch 100 -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-p -dbnomatch 100 -l ${minlength} -selfun selnone.so ${database}",
    "-p -dbnomatch 100 -l ${minlength} -best 10 ${database}",
    "-p -dbnomatch 100 -l ${minlength} ${database}",
    "-p -dbnomatch 100 -h ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-p -dbnomatch 100 -h ${mindist} -l ${minlength} -allmax ${database}",
    "-p -dbnomatch 100 -e ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-p -dbnomatch 100 -e ${mindist} -l ${minlength} -allmax ${database}",
    "-p -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-p -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-p -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-p -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} ${database}",
    "-p -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-p -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-p -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-p -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} ${database}",
    "-p -dbmaskmatch X -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-p -dbmaskmatch X -l ${minlength} -selfun selnone.so ${database}",
    "-p -dbmaskmatch X -l ${minlength} -best 10 ${database}",
    "-p -dbmaskmatch X -l ${minlength} ${database}",
    "-p -dbmaskmatch X -h ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-p -dbmaskmatch X -h ${mindist} -l ${minlength} -allmax ${database}",
    "-p -dbmaskmatch X -e ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-p -dbmaskmatch X -e ${mindist} -l ${minlength} -allmax ${database}",
    "-p -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-p -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-p -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-p -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} ${database}",
    "-p -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-p -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-p -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-p -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} ${database}",
    "-p -dbcluster 50 50 -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-p -dbcluster 50 50 -l ${minlength} -selfun selnone.so ${database}",
    "-p -dbcluster 50 50 -l ${minlength} -best 10 ${database}",
    "-p -dbcluster 50 50 -l ${minlength} ${database}",
    "-p -dbcluster 50 50 -h ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-p -dbcluster 50 50 -h ${mindist} -l ${minlength} -allmax ${database}",
    "-p -dbcluster 50 50 -e ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-p -dbcluster 50 50 -e ${mindist} -l ${minlength} -allmax ${database}",
    "-p -dbcluster 50 50 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-p -dbcluster 50 50 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-p -dbcluster 50 50 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-p -dbcluster 50 50 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} ${database}",
    "-p -dbcluster 50 50 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-p -dbcluster 50 50 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-p -dbcluster 50 50 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-p -dbcluster 50 50 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} ${database}",
    "-p -pp chain local 6b -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-p -pp chain local 6b -l ${minlength} -selfun selnone.so ${database}",
    "-p -pp chain local 6b -l ${minlength} -best 10 ${database}",
    "-p -pp chain local 6b -l ${minlength} ${database}",
    "-p -pp chain local 6b -h ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-p -pp chain local 6b -h ${mindist} -l ${minlength} -allmax ${database}",
    "-p -pp chain local 6b -e ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-p -pp chain local 6b -e ${mindist} -l ${minlength} -allmax ${database}",
    "-p -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-p -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-p -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-p -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} ${database}",
    "-p -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-p -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-p -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-p -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -l ${minlength} -selfun selnone.so ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -l ${minlength} -best 10 ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -l ${minlength} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -h ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -h ${mindist} -l ${minlength} -allmax ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -e ${mindist} -l ${minlength} -selfun selnone.so -allmax ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -e ${mindist} -l ${minlength} -allmax ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} ${database}",
    "-p -l ${minlength} -online -selfun selnone.so -best 10 -i -q ${query} ${database}",
    "-p -l ${minlength} -online -selfun selnone.so -i -q ${query} ${database}",
    "-p -l ${minlength} -online -best 10 -i -q ${query} ${database}",
    "-p -l ${minlength} -online -i -q ${query} ${database}",
    "-p -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-p -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-p -l ${minlength} -online -q ${query} ${database}",
    "-p -l ${minlength} -selfun selnone.so -best 10 -i -q ${query} ${database}",
    "-p -l ${minlength} -selfun selnone.so -i -q ${query} ${database}",
    "-p -l ${minlength} -best 10 -i -q ${query} ${database}",
    "-p -l ${minlength} -i -q ${query} ${database}",
    "-p -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -l ${minlength} -q ${query} ${database}",
    "-p -h ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -i -q ${query} ${database}",
    "-p -h ${mindist} -l ${minlength} -online -allmax -i -q ${query} ${database}",
    "-p -h ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -h ${mindist} -l ${minlength} -online -allmax -q ${query} ${database}",
    "-p -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -i -q ${query} ${database}",
    "-p -h ${mindist} -l ${minlength} -allmax -i -q ${query} ${database}",
    "-p -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -h ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-p -e ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -i -q ${query} ${database}",
    "-p -e ${mindist} -l ${minlength} -online -allmax -i -q ${query} ${database}",
    "-p -e ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -e ${mindist} -l ${minlength} -online -allmax -q ${query} ${database}",
    "-p -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -i -q ${query} ${database}",
    "-p -e ${mindist} -l ${minlength} -allmax -i -q ${query} ${database}",
    "-p -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -e ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-p -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -i -q ${query} ${database}",
    "-p -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -i -q ${query} ${database}",
    "-p -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -best 10 -i -q ${query} ${database}",
    "-p -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -i -q ${query} ${database}",
    "-p -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-p -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-p -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -q ${query} ${database}",
    "-p -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -i -q ${query} ${database}",
    "-p -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -i -q ${query} ${database}",
    "-p -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -i -q ${query} ${database}",
    "-p -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -i -q ${query} ${database}",
    "-p -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-p -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -i -q ${query} ${database}",
    "-p -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -i -q ${query} ${database}",
    "-p -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -best 10 -i -q ${query} ${database}",
    "-p -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -i -q ${query} ${database}",
    "-p -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-p -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-p -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -q ${query} ${database}",
    "-p -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -i -q ${query} ${database}",
    "-p -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -i -q ${query} ${database}",
    "-p -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -i -q ${query} ${database}",
    "-p -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -i -q ${query} ${database}",
    "-p -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-p -showdesc 20 -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -showdesc 20 -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-p -showdesc 20 -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-p -showdesc 20 -l ${minlength} -online -q ${query} ${database}",
    "-p -showdesc 20 -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -showdesc 20 -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -showdesc 20 -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -showdesc 20 -l ${minlength} -q ${query} ${database}",
    "-p -showdesc 20 -h ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -showdesc 20 -h ${mindist} -l ${minlength} -online -allmax -q ${query} ${database}",
    "-p -showdesc 20 -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -showdesc 20 -h ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-p -showdesc 20 -e ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -showdesc 20 -e ${mindist} -l ${minlength} -online -allmax -q ${query} ${database}",
    "-p -showdesc 20 -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -showdesc 20 -e ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-p -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-p -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-p -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -q ${query} ${database}",
    "-p -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-p -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-p -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-p -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -q ${query} ${database}",
    "-p -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-p -dbnomatch 100 -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -dbnomatch 100 -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-p -dbnomatch 100 -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-p -dbnomatch 100 -l ${minlength} -online -q ${query} ${database}",
    "-p -dbnomatch 100 -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -dbnomatch 100 -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -dbnomatch 100 -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -dbnomatch 100 -l ${minlength} -q ${query} ${database}",
    "-p -dbnomatch 100 -h ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -dbnomatch 100 -h ${mindist} -l ${minlength} -online -allmax -q ${query} ${database}",
    "-p -dbnomatch 100 -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -dbnomatch 100 -h ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-p -dbnomatch 100 -e ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -dbnomatch 100 -e ${mindist} -l ${minlength} -online -allmax -q ${query} ${database}",
    "-p -dbnomatch 100 -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -dbnomatch 100 -e ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-p -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-p -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-p -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -q ${query} ${database}",
    "-p -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-p -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-p -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-p -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -q ${query} ${database}",
    "-p -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-p -qnomatch 100 -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -qnomatch 100 -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-p -qnomatch 100 -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-p -qnomatch 100 -l ${minlength} -online -q ${query} ${database}",
    "-p -qnomatch 100 -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -qnomatch 100 -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -qnomatch 100 -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -qnomatch 100 -l ${minlength} -q ${query} ${database}",
    "-p -qnomatch 100 -h ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -qnomatch 100 -h ${mindist} -l ${minlength} -online -allmax -q ${query} ${database}",
    "-p -qnomatch 100 -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -qnomatch 100 -h ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-p -qnomatch 100 -e ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -qnomatch 100 -e ${mindist} -l ${minlength} -online -allmax -q ${query} ${database}",
    "-p -qnomatch 100 -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -qnomatch 100 -e ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-p -qnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -qnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-p -qnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-p -qnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -q ${query} ${database}",
    "-p -qnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -qnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -qnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -qnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-p -qnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -qnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-p -qnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-p -qnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -q ${query} ${database}",
    "-p -qnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -qnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -qnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -qnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-p -dbmaskmatch X -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -dbmaskmatch X -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-p -dbmaskmatch X -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-p -dbmaskmatch X -l ${minlength} -online -q ${query} ${database}",
    "-p -dbmaskmatch X -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -dbmaskmatch X -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -dbmaskmatch X -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -dbmaskmatch X -l ${minlength} -q ${query} ${database}",
    "-p -dbmaskmatch X -h ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -dbmaskmatch X -h ${mindist} -l ${minlength} -online -allmax -q ${query} ${database}",
    "-p -dbmaskmatch X -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -dbmaskmatch X -h ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-p -dbmaskmatch X -e ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -dbmaskmatch X -e ${mindist} -l ${minlength} -online -allmax -q ${query} ${database}",
    "-p -dbmaskmatch X -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -dbmaskmatch X -e ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-p -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-p -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-p -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -q ${query} ${database}",
    "-p -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-p -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-p -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-p -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -q ${query} ${database}",
    "-p -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-p -qmaskmatch X -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -qmaskmatch X -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-p -qmaskmatch X -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-p -qmaskmatch X -l ${minlength} -online -q ${query} ${database}",
    "-p -qmaskmatch X -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -qmaskmatch X -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -qmaskmatch X -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -qmaskmatch X -l ${minlength} -q ${query} ${database}",
    "-p -qmaskmatch X -h ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -qmaskmatch X -h ${mindist} -l ${minlength} -online -allmax -q ${query} ${database}",
    "-p -qmaskmatch X -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -qmaskmatch X -h ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-p -qmaskmatch X -e ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -qmaskmatch X -e ${mindist} -l ${minlength} -online -allmax -q ${query} ${database}",
    "-p -qmaskmatch X -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -qmaskmatch X -e ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-p -qmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -qmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-p -qmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-p -qmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -q ${query} ${database}",
    "-p -qmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -qmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -qmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -qmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-p -qmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -qmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-p -qmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-p -qmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -q ${query} ${database}",
    "-p -qmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -qmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -qmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -qmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-p -pp chain local 6b -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -pp chain local 6b -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-p -pp chain local 6b -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-p -pp chain local 6b -l ${minlength} -online -q ${query} ${database}",
    "-p -pp chain local 6b -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -pp chain local 6b -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -pp chain local 6b -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -pp chain local 6b -l ${minlength} -q ${query} ${database}",
    "-p -pp chain local 6b -h ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -pp chain local 6b -h ${mindist} -l ${minlength} -online -allmax -q ${query} ${database}",
    "-p -pp chain local 6b -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -pp chain local 6b -h ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-p -pp chain local 6b -e ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -pp chain local 6b -e ${mindist} -l ${minlength} -online -allmax -q ${query} ${database}",
    "-p -pp chain local 6b -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -pp chain local 6b -e ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-p -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-p -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-p -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -q ${query} ${database}",
    "-p -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-p -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-p -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-p -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -q ${query} ${database}",
    "-p -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -l ${minlength} -online -q ${query} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -l ${minlength} -q ${query} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -h ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -h ${mindist} -l ${minlength} -online -allmax -q ${query} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -h ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -e ${mindist} -l ${minlength} -online -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -e ${mindist} -l ${minlength} -online -allmax -q ${query} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -e ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -online -q ${query} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -selfun selnone.so -q ${query} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -best 10 -q ${query} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -online -q ${query} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-p -mum -l ${minlength} -selfun selnone.so -best 10 -i -q ${query} ${database}",
    "-p -mum -l ${minlength} -selfun selnone.so -i -q ${query} ${database}",
    "-p -mum -l ${minlength} -best 10 -i -q ${query} ${database}",
    "-p -mum -l ${minlength} -i -q ${query} ${database}",
    "-p -mum -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -mum -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -mum -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -mum -l ${minlength} -q ${query} ${database}",
    "-p -mum -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -i -q ${query} ${database}",
    "-p -mum -h ${mindist} -l ${minlength} -allmax -i -q ${query} ${database}",
    "-p -mum -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -mum -h ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-p -mum -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -i -q ${query} ${database}",
    "-p -mum -e ${mindist} -l ${minlength} -allmax -i -q ${query} ${database}",
    "-p -mum -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -mum -e ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-p -mum -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -i -q ${query} ${database}",
    "-p -mum -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -i -q ${query} ${database}",
    "-p -mum -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -i -q ${query} ${database}",
    "-p -mum -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -i -q ${query} ${database}",
    "-p -mum -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -mum -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -mum -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -mum -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-p -mum -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -i -q ${query} ${database}",
    "-p -mum -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -i -q ${query} ${database}",
    "-p -mum -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -i -q ${query} ${database}",
    "-p -mum -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -i -q ${query} ${database}",
    "-p -mum -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -mum -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -mum -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -mum -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-p -mum -showdesc 20 -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -mum -showdesc 20 -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -mum -showdesc 20 -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -mum -showdesc 20 -l ${minlength} -q ${query} ${database}",
    "-p -mum -showdesc 20 -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -mum -showdesc 20 -h ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-p -mum -showdesc 20 -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -mum -showdesc 20 -e ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-p -mum -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -mum -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -mum -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -mum -showdesc 20 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-p -mum -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -mum -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -mum -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -mum -showdesc 20 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-p -mum -dbnomatch 100 -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -mum -dbnomatch 100 -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -mum -dbnomatch 100 -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -mum -dbnomatch 100 -l ${minlength} -q ${query} ${database}",
    "-p -mum -dbnomatch 100 -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -mum -dbnomatch 100 -h ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-p -mum -dbnomatch 100 -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -mum -dbnomatch 100 -e ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-p -mum -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -mum -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -mum -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -mum -dbnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-p -mum -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -mum -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -mum -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -mum -dbnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-p -mum -qnomatch 100 -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -mum -qnomatch 100 -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -mum -qnomatch 100 -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -mum -qnomatch 100 -l ${minlength} -q ${query} ${database}",
    "-p -mum -qnomatch 100 -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -mum -qnomatch 100 -h ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-p -mum -qnomatch 100 -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -mum -qnomatch 100 -e ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-p -mum -qnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -mum -qnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -mum -qnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -mum -qnomatch 100 -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-p -mum -qnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -mum -qnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -mum -qnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -mum -qnomatch 100 -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-p -mum -dbmaskmatch X -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -mum -dbmaskmatch X -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -mum -dbmaskmatch X -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -mum -dbmaskmatch X -l ${minlength} -q ${query} ${database}",
    "-p -mum -dbmaskmatch X -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -mum -dbmaskmatch X -h ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-p -mum -dbmaskmatch X -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -mum -dbmaskmatch X -e ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-p -mum -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -mum -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -mum -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -mum -dbmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-p -mum -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -mum -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -mum -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -mum -dbmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-p -mum -qmaskmatch X -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -mum -qmaskmatch X -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -mum -qmaskmatch X -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -mum -qmaskmatch X -l ${minlength} -q ${query} ${database}",
    "-p -mum -qmaskmatch X -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -mum -qmaskmatch X -h ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-p -mum -qmaskmatch X -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -mum -qmaskmatch X -e ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-p -mum -qmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -mum -qmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -mum -qmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -mum -qmaskmatch X -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-p -mum -qmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -mum -qmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -mum -qmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -mum -qmaskmatch X -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-p -mum -pp chain local 6b -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -mum -pp chain local 6b -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -mum -pp chain local 6b -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -mum -pp chain local 6b -l ${minlength} -q ${query} ${database}",
    "-p -mum -pp chain local 6b -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -mum -pp chain local 6b -h ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-p -mum -pp chain local 6b -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -mum -pp chain local 6b -e ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-p -mum -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -mum -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -mum -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -mum -pp chain local 6b -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-p -mum -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -mum -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -mum -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -mum -pp chain local 6b -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-p -mum -pp matchcluster erate 3 outprefix clout -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -mum -pp matchcluster erate 3 outprefix clout -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -mum -pp matchcluster erate 3 outprefix clout -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -mum -pp matchcluster erate 3 outprefix clout -l ${minlength} -q ${query} ${database}",
    "-p -mum -pp matchcluster erate 3 outprefix clout -h ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -mum -pp matchcluster erate 3 outprefix clout -h ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-p -mum -pp matchcluster erate 3 outprefix clout -e ${mindist} -l ${minlength} -selfun selnone.so -allmax -q ${query} ${database}",
    "-p -mum -pp matchcluster erate 3 outprefix clout -e ${mindist} -l ${minlength} -allmax -q ${query} ${database}",
    "-p -mum -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -mum -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -mum -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -mum -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -hxdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-p -mum -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -mum -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -selfun selnone.so -q ${query} ${database}",
    "-p -mum -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -best 10 -q ${query} ${database}",
    "-p -mum -pp matchcluster erate 3 outprefix clout -seedlength ${seedlength} -exdrop ${mindist} -l ${minlength} -q ${query} ${database}",
    "-p -complete -online -selfun selnone.so -best 10 -i -q ${query} ${database}",
    "-p -complete -online -selfun selnone.so -i -q ${query} ${database}",
    "-p -complete -online -best 10 -i -q ${query} ${database}",
    "-p -complete -online -i -q ${query} ${database}",
    "-p -complete -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -complete -online -selfun selnone.so -q ${query} ${database}",
    "-p -complete -online -best 10 -q ${query} ${database}",
    "-p -complete -online -q ${query} ${database}",
    "-p -complete -selfun selnone.so -best 10 -i -q ${query} ${database}",
    "-p -complete -selfun selnone.so -i -q ${query} ${database}",
    "-p -complete -best 10 -i -q ${query} ${database}",
    "-p -complete -i -q ${query} ${database}",
    "-p -complete -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -complete -selfun selnone.so -q ${query} ${database}",
    "-p -complete -best 10 -q ${query} ${database}",
    "-p -complete -q ${query} ${database}",
    "-p -complete -showdesc 20 -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -complete -showdesc 20 -online -selfun selnone.so -q ${query} ${database}",
    "-p -complete -showdesc 20 -online -best 10 -q ${query} ${database}",
    "-p -complete -showdesc 20 -online -q ${query} ${database}",
    "-p -complete -showdesc 20 -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -complete -showdesc 20 -selfun selnone.so -q ${query} ${database}",
    "-p -complete -showdesc 20 -best 10 -q ${query} ${database}",
    "-p -complete -showdesc 20 -q ${query} ${database}",
    "-p -complete -dbnomatch 100 -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -complete -dbnomatch 100 -online -selfun selnone.so -q ${query} ${database}",
    "-p -complete -dbnomatch 100 -online -best 10 -q ${query} ${database}",
    "-p -complete -dbnomatch 100 -online -q ${query} ${database}",
    "-p -complete -dbnomatch 100 -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -complete -dbnomatch 100 -selfun selnone.so -q ${query} ${database}",
    "-p -complete -dbnomatch 100 -best 10 -q ${query} ${database}",
    "-p -complete -dbnomatch 100 -q ${query} ${database}",
    "-p -complete -qnomatch 100 -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -complete -qnomatch 100 -online -selfun selnone.so -q ${query} ${database}",
    "-p -complete -qnomatch 100 -online -best 10 -q ${query} ${database}",
    "-p -complete -qnomatch 100 -online -q ${query} ${database}",
    "-p -complete -qnomatch 100 -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -complete -qnomatch 100 -selfun selnone.so -q ${query} ${database}",
    "-p -complete -qnomatch 100 -best 10 -q ${query} ${database}",
    "-p -complete -qnomatch 100 -q ${query} ${database}",
    "-p -complete -dbmaskmatch X -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -complete -dbmaskmatch X -online -selfun selnone.so -q ${query} ${database}",
    "-p -complete -dbmaskmatch X -online -best 10 -q ${query} ${database}",
    "-p -complete -dbmaskmatch X -online -q ${query} ${database}",
    "-p -complete -dbmaskmatch X -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -complete -dbmaskmatch X -selfun selnone.so -q ${query} ${database}",
    "-p -complete -dbmaskmatch X -best 10 -q ${query} ${database}",
    "-p -complete -dbmaskmatch X -q ${query} ${database}",
    "-p -complete -qmaskmatch X -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -complete -qmaskmatch X -online -selfun selnone.so -q ${query} ${database}",
    "-p -complete -qmaskmatch X -online -best 10 -q ${query} ${database}",
    "-p -complete -qmaskmatch X -online -q ${query} ${database}",
    "-p -complete -qmaskmatch X -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -complete -qmaskmatch X -selfun selnone.so -q ${query} ${database}",
    "-p -complete -qmaskmatch X -best 10 -q ${query} ${database}",
    "-p -complete -qmaskmatch X -q ${query} ${database}",
    "-p -complete -pp chain local 6b -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -complete -pp chain local 6b -online -selfun selnone.so -q ${query} ${database}",
    "-p -complete -pp chain local 6b -online -best 10 -q ${query} ${database}",
    "-p -complete -pp chain local 6b -online -q ${query} ${database}",
    "-p -complete -pp chain local 6b -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -complete -pp chain local 6b -selfun selnone.so -q ${query} ${database}",
    "-p -complete -pp chain local 6b -best 10 -q ${query} ${database}",
    "-p -complete -pp chain local 6b -q ${query} ${database}",
    "-p -complete -pp matchcluster erate 3 outprefix clout -online -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -complete -pp matchcluster erate 3 outprefix clout -online -selfun selnone.so -q ${query} ${database}",
    "-p -complete -pp matchcluster erate 3 outprefix clout -online -best 10 -q ${query} ${database}",
    "-p -complete -pp matchcluster erate 3 outprefix clout -online -q ${query} ${database}",
    "-p -complete -pp matchcluster erate 3 outprefix clout -selfun selnone.so -best 10 -q ${query} ${database}",
    "-p -complete -pp matchcluster erate 3 outprefix clout -selfun selnone.so -q ${query} ${database}",
    "-p -complete -pp matchcluster erate 3 outprefix clout -best 10 -q ${query} ${database}",
    "-p -complete -pp matchcluster erate 3 outprefix clout -q ${query} ${database}",
  );
  return \@arglisttable;
}

1;
