
#line 1 "Rfc5322HeaderParser.cpp"
/* Copyright (C) 2006 - 2014 Jan Kundrát <jkt@flaska.net>

   This file is part of the Trojita Qt IMAP e-mail client,
   http://trojita.flaska.net/

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License or (at your option) version 3 or any later version
   accepted by the membership of KDE e.V. (or its successor approved
   by the membership of KDE e.V.), which shall act as a proxy
   defined in Section 14 of version 3 of the license.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <QDebug>
#include "Imap/Parser/Rfc5322HeaderParser.h"

#define DBG(X) do {qDebug() << X << "(current char:" << *p << ")";} while(false);
//#define RAGEL_DEBUG

namespace Imap {
namespace LowLevelParser {


#line 140 "Rfc5322HeaderParser.cpp"


#ifdef __clang__
#pragma clang diagnostic push
#if defined(__has_warning) && __has_warning("-Wunused-const-variable")
#pragma clang diagnostic ignored "-Wunused-const-variable"
#endif
#endif

#line 46 "Rfc5322HeaderParser.generated.cpp"
static const int8_t _rfc5322_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 2, 
	0, 2, 2, 2, 0, 2, 2, 3, 
	2, 3, 0, 2, 3, 1, 2, 5, 
	4, 2, 6, 4, 2, 7, 4, 2, 
	8, 4
};

static const int16_t _rfc5322_key_offsets[] = {
	0, 0, 1, 4, 7, 11, 16, 20, 
	25, 30, 35, 40, 45, 49, 54, 59, 
	64, 67, 87, 107, 109, 112, 131, 133, 
	136, 141, 146, 151, 155, 160, 165, 170, 
	175, 178, 188, 193, 199, 204, 209, 214, 
	219, 224, 229, 233, 238, 243, 248, 251, 
	257, 259, 262, 270, 272, 275, 277, 296, 
	298, 301, 320, 327, 329, 332, 340, 342, 
	345, 347, 367, 369, 372, 392, 399, 401, 
	404, 412, 414, 417, 419, 438, 440, 443, 
	463, 468, 473, 475, 478, 483, 488, 493, 
	498, 503, 508, 513, 518, 523, 528, 531, 
	551, 571, 573, 576, 595, 597, 600, 609, 
	617, 619, 622, 624, 632, 634, 637, 639, 
	658, 660, 663, 682, 689, 691, 694, 702, 
	704, 707, 709, 729, 731, 734, 754, 761, 
	763, 766, 774, 776, 779, 781, 800, 802, 
	805, 825, 845, 865, 867, 870, 878, 880, 
	883, 885, 893, 895, 898, 900, 919, 927, 
	929, 932, 934, 944, 946, 949, 951, 957, 
	959, 962, 970, 972, 975, 977, 986, 994, 
	996, 999, 1001, 1009, 1011, 1014, 1016, 1024, 
	1026, 1029, 1031, 1034, 1059, 1084, 1089, 1095, 
	1119, 1124, 1130, 1139, 1148, 1153, 1159, 1162, 
	1171, 1179, 1184, 1190, 1193, 1201, 1225, 1230, 
	1236, 1260, 1269, 1274, 1280, 1288, 1293, 1299, 
	1302, 1310, 1335, 1340, 1346, 1371, 1380, 1385, 
	1391, 1399, 1404, 1410, 1413, 1421, 1445, 1450, 
	1456, 1481, 1506, 1531, 1536, 1542, 1550, 1555, 
	1561, 1564, 1572, 1580, 1585, 1591, 1594, 1602, 
	1626, 1634, 1639, 1645, 1648, 1656, 1666, 1671, 
	1677, 1680, 1690, 1698, 1703, 1709, 1717, 1722, 
	1728, 1731, 1739, 1748, 1757, 1762, 1768, 1771, 
	1780, 1788, 1793, 1799, 1802, 1810, 1818, 1823, 
	1829, 1832, 1840, 1846, 1854, 1856, 1859, 1861, 
	1869, 1871, 1874, 1876, 1895, 1903, 1905, 1908, 
	1910, 1920, 1922, 1925, 1927, 1933, 1935, 1938, 
	1946, 1948, 1951, 1953, 1962, 1970, 1972, 1975, 
	1977, 1985, 1987, 1990, 1992, 2000, 2005, 2011, 
	2019, 2024, 2030, 2033, 2041, 2065, 2070, 2076, 
	2100, 2109, 2114, 2120, 2128, 2133, 2139, 2142, 
	2150, 2175, 2180, 2186, 2211, 2220, 2225, 2231, 
	2239, 2244, 2250, 2253, 2261, 2285, 2290, 2296, 
	2321, 2328, 2335, 2340, 2346, 2354, 2359, 2365, 
	2368, 2376, 2384, 2389, 2395, 2398, 2406, 2430, 
	2438, 2443, 2449, 2452, 2460, 2470, 2475, 2481, 
	2484, 2494, 2502, 2507, 2513, 2521, 2526, 2532, 
	2535, 2543, 2552, 2561, 2566, 2572, 2575, 2584, 
	2592, 2597, 2603, 2606, 2614, 2622, 2627, 2633, 
	2636, 2644, 2653, 2658, 2660, 2666, 2669, 2677, 
	2679, 2682, 2684, 2692, 2695, 2699, 2707, 2712, 
	2718, 2726, 2731, 2737, 2740, 2748, 2756, 2761, 
	2767, 2775, 2780, 2786, 2789, 2797, 2806, 2811, 
	2820, 2822, 2831, 2834, 2845, 2853, 2858, 2864, 
	2872, 2877, 2883, 2886, 2894, 2905, 2910, 2916, 
	2927, 2932, 2938, 2950, 2957, 2966, 2971, 2981, 
	2987, 2993, 3003, 3013, 3018, 3024, 3034, 3039, 
	3050, 3058, 3063, 3069, 3072, 3080, 3086, 3097, 
	3108, 3113, 3119, 3130, 3135, 3141, 3152, 3157, 
	3163, 3169, 3179, 3189, 3195, 3205, 3215, 3220, 
	3226, 3235, 3237, 3246, 3249, 3260, 3271, 3276, 
	3282, 3293, 3298, 3304, 3316, 3326, 3331, 3341, 
	3347, 3356, 3362, 3372, 3382, 3387, 3393, 3399, 
	3409, 3419, 3426, 3431, 3439, 3445, 3453, 3458, 
	3464, 3467, 3475, 3484, 3489, 3499, 3505, 3511, 
	3521, 3531, 3536, 3542, 3552, 3557, 3568, 3576, 
	3581, 3587, 3590, 3598, 3604, 3615, 3623, 3628, 
	3634, 3643, 3650, 3659, 3665, 3670, 3676, 3686, 
	3691, 3702, 3708, 3711, 3719, 3725, 3735, 3745, 
	3756, 3761, 3767, 3778, 3783, 3789, 3801, 3811, 
	3817, 3822, 3828, 3834, 3844, 3854, 3859, 3862, 
	3866, 3875, 3883, 3885, 3888, 3890, 3898, 3900, 
	3903, 3905, 3924, 3926, 3929, 3948, 3955, 3957, 
	3960, 3968, 3970, 3973, 3975, 3995, 3997, 4000, 
	4020, 4027, 4029, 4032, 4040, 4042, 4045, 4047, 
	4066, 4068, 4071, 4091, 4111, 4131, 4133, 4136, 
	4144, 4146, 4149, 4151, 4159, 4161, 4164, 4166, 
	4185, 4193, 4195, 4198, 4200, 4210, 4212, 4215, 
	4217, 4223, 4225, 4228, 4236, 4238, 4241, 4243, 
	4252, 4260, 4262, 4265, 4267, 4275, 4277, 4280, 
	4282, 4290, 4292, 4295, 4297, 4300, 4325, 4350, 
	4355, 4361, 4385, 4390, 4396, 4405, 4414, 4419, 
	4425, 4428, 4437, 4445, 4450, 4456, 4459, 4467, 
	4491, 4496, 4502, 4526, 4535, 4540, 4546, 4554, 
	4559, 4565, 4568, 4576, 4601, 4606, 4612, 4637, 
	4646, 4651, 4657, 4665, 4670, 4676, 4679, 4687, 
	4711, 4716, 4722, 4747, 4772, 4797, 4802, 4808, 
	4816, 4821, 4827, 4830, 4838, 4846, 4851, 4857, 
	4860, 4868, 4892, 4900, 4905, 4911, 4914, 4922, 
	4932, 4937, 4943, 4946, 4956, 4964, 4969, 4975, 
	4983, 4988, 4994, 4997, 5005, 5014, 5023, 5028, 
	5034, 5037, 5046, 5054, 5059, 5065, 5068, 5076, 
	5084, 5089, 5095, 5098, 5106, 5112, 5125, 5126, 
	5141, 5156, 5171, 5186, 5201, 5216, 5231, 5246, 
	5261, 5276, 5291, 5306, 5321, 5336, 5351, 5366, 
	5381, 5396, 5411, 5426, 5441, 5456, 5471, 5486, 
	5501, 5516, 5531, 5546, 5561, 5576, 5591, 5606, 
	5621, 5636, 5651, 5666, 5681, 5696, 5711, 5726, 
	5741, 5756, 5771, 5786, 5801, 5816, 5831, 5846, 
	5861, 5876, 5891, 5906, 5921, 5936, 5951, 5966, 
	5981, 5996, 6011, 6026, 6041, 6056, 6071, 6086, 
	6101, 6116, 6131, 6146, 6161, 6176, 6191, 6206, 
	6221, 6236, 6251, 6266, 6281, 6296, 6311, 6326, 
	6341, 6356, 6371, 6386, 6401, 6416, 6431, 6446, 
	6461, 6476, 6491, 6506, 6521, 6536, 6551, 6566, 
	6581, 6596, 6611, 6626, 6641, 6656, 6671, 6686, 
	6701
};

static const int8_t _rfc5322_trans_keys[] = {
	10, 58, 33, 126, 13, 0, 127, 10, 
	13, 0, 127, 58, 78, 110, 33, 126, 
	45, 58, 33, 126, 58, 82, 114, 33, 
	126, 58, 69, 101, 33, 126, 58, 80, 
	112, 33, 126, 58, 76, 108, 33, 126, 
	58, 89, 121, 33, 126, 45, 58, 33, 
	126, 58, 84, 116, 33, 126, 58, 79, 
	111, 33, 126, 9, 32, 58, 33, 126, 
	9, 32, 58, 9, 10, 13, 32, 34, 
	40, 45, 60, 61, 63, 33, 39, 42, 
	43, 47, 57, 65, 90, 94, 126, 9, 
	10, 13, 32, 34, 40, 45, 60, 61, 
	63, 33, 39, 42, 43, 47, 57, 65, 
	90, 94, 126, 9, 32, 9, 10, 32, 
	9, 10, 13, 32, 34, 40, 60, 61, 
	63, 33, 39, 42, 43, 45, 57, 65, 
	90, 94, 126, 9, 32, 9, 10, 32, 
	58, 73, 105, 33, 126, 58, 83, 115, 
	33, 126, 58, 84, 116, 33, 126, 45, 
	58, 33, 126, 58, 80, 112, 33, 126, 
	58, 79, 111, 33, 126, 58, 83, 115, 
	33, 126, 58, 84, 116, 33, 126, 58, 
	33, 126, 9, 10, 13, 32, 40, 60, 
	78, 110, 0, 127, 9, 13, 32, 0, 
	127, 9, 10, 13, 32, 0, 127, 58, 
	69, 101, 33, 126, 58, 83, 115, 33, 
	126, 58, 83, 115, 33, 126, 58, 65, 
	97, 33, 126, 58, 71, 103, 33, 126, 
	58, 69, 101, 33, 126, 45, 58, 33, 
	126, 58, 73, 105, 33, 126, 58, 68, 
	100, 33, 126, 9, 32, 58, 33, 126, 
	9, 32, 58, 9, 10, 13, 32, 40, 
	60, 9, 32, 9, 10, 32, 10, 13, 
	41, 92, 1, 39, 42, 127, 9, 32, 
	9, 10, 32, 0, 127, 9, 10, 13, 
	32, 34, 40, 45, 61, 63, 33, 39, 
	42, 43, 47, 57, 65, 90, 94, 126, 
	9, 32, 9, 10, 32, 9, 10, 13, 
	32, 33, 40, 46, 61, 64, 35, 39, 
	42, 43, 45, 57, 63, 90, 94, 126, 
	9, 10, 13, 32, 40, 46, 64, 9, 
	32, 9, 10, 32, 10, 13, 41, 92, 
	1, 39, 42, 127, 9, 32, 9, 10, 
	32, 0, 127, 9, 10, 13, 32, 33, 
	40, 45, 61, 63, 91, 35, 39, 42, 
	43, 47, 57, 65, 90, 94, 126, 9, 
	32, 9, 10, 32, 9, 10, 13, 32, 
	33, 40, 46, 62, 35, 39, 42, 43, 
	45, 57, 61, 63, 65, 90, 94, 126, 
	9, 10, 13, 32, 40, 46, 62, 9, 
	32, 9, 10, 32, 10, 13, 41, 92, 
	1, 39, 42, 127, 9, 32, 9, 10, 
	32, 0, 127, 9, 10, 13, 32, 33, 
	40, 45, 61, 63, 35, 39, 42, 43, 
	47, 57, 65, 90, 94, 126, 9, 32, 
	9, 10, 32, 9, 10, 13, 32, 33, 
	40, 46, 62, 35, 39, 42, 43, 45, 
	57, 61, 63, 65, 90, 94, 126, 9, 
	10, 13, 32, 40, 9, 10, 13, 32, 
	40, 9, 32, 9, 10, 32, 58, 69, 
	101, 33, 126, 58, 70, 102, 33, 126, 
	58, 69, 101, 33, 126, 58, 82, 114, 
	33, 126, 58, 69, 101, 33, 126, 58, 
	78, 110, 33, 126, 58, 67, 99, 33, 
	126, 58, 69, 101, 33, 126, 58, 83, 
	115, 33, 126, 9, 32, 58, 33, 126, 
	9, 32, 58, 9, 10, 13, 32, 34, 
	40, 45, 60, 61, 63, 33, 39, 42, 
	43, 47, 57, 65, 90, 94, 126, 9, 
	10, 13, 32, 34, 40, 45, 60, 61, 
	63, 33, 39, 42, 43, 47, 57, 65, 
	90, 94, 126, 9, 32, 9, 10, 32, 
	9, 10, 13, 32, 34, 40, 60, 61, 
	63, 33, 39, 42, 43, 45, 57, 65, 
	90, 94, 126, 9, 32, 9, 10, 32, 
	9, 10, 13, 32, 92, 1, 33, 35, 
	127, 9, 10, 13, 32, 34, 92, 1, 
	127, 9, 32, 9, 10, 32, 0, 127, 
	10, 13, 41, 92, 1, 39, 42, 127, 
	9, 32, 9, 10, 32, 0, 127, 9, 
	10, 13, 32, 34, 40, 45, 61, 63, 
	33, 39, 42, 43, 47, 57, 65, 90, 
	94, 126, 9, 32, 9, 10, 32, 9, 
	10, 13, 32, 33, 40, 46, 61, 64, 
	35, 39, 42, 43, 45, 57, 63, 90, 
	94, 126, 9, 10, 13, 32, 40, 46, 
	64, 9, 32, 9, 10, 32, 10, 13, 
	41, 92, 1, 39, 42, 127, 9, 32, 
	9, 10, 32, -128, -1, 9, 10, 13, 
	32, 33, 40, 45, 61, 63, 91, 35, 
	39, 42, 43, 47, 57, 65, 90, 94, 
	126, 9, 32, 9, 10, 32, 9, 10, 
	13, 32, 33, 40, 46, 62, 35, 39, 
	42, 43, 45, 57, 61, 63, 65, 90, 
	94, 126, 9, 10, 13, 32, 40, 46, 
	62, 9, 32, 9, 10, 32, 10, 13, 
	41, 92, 1, 39, 42, 127, 9, 32, 
	9, 10, 32, 0, 127, 9, 10, 13, 
	32, 33, 40, 45, 61, 63, 35, 39, 
	42, 43, 47, 57, 65, 90, 94, 126, 
	9, 32, 9, 10, 32, 9, 10, 13, 
	32, 33, 40, 46, 62, 35, 39, 42, 
	43, 45, 57, 61, 63, 65, 90, 94, 
	126, 9, 10, 13, 32, 34, 40, 45, 
	60, 61, 63, 33, 39, 42, 43, 47, 
	57, 65, 90, 94, 126, 9, 10, 13, 
	32, 34, 40, 45, 60, 61, 63, 33, 
	39, 42, 43, 47, 57, 65, 90, 94, 
	126, 9, 32, 9, 10, 32, 10, 13, 
	41, 92, 1, 39, 42, 127, 9, 32, 
	9, 10, 32, 0, 127, 10, 13, 41, 
	92, 1, 39, 42, 127, 9, 32, 9, 
	10, 32, -128, -1, 9, 10, 13, 32, 
	33, 40, 45, 61, 63, 35, 39, 42, 
	43, 47, 57, 65, 90, 94, 126, 10, 
	13, 41, 92, 1, 39, 42, 127, 9, 
	32, 9, 10, 32, -128, -1, 9, 10, 
	13, 32, 92, 93, 1, 90, 94, 127, 
	9, 32, 9, 10, 32, 0, 127, 9, 
	10, 13, 32, 40, 62, 9, 32, 9, 
	10, 32, 10, 13, 41, 92, 1, 39, 
	42, 127, 9, 32, 9, 10, 32, 0, 
	127, 9, 10, 13, 32, 92, 1, 33, 
	35, 127, 9, 10, 13, 32, 34, 92, 
	1, 127, 9, 32, 9, 10, 32, 0, 
	127, 10, 13, 41, 92, 1, 39, 42, 
	127, 9, 32, 9, 10, 32, 0, 127, 
	10, 13, 41, 92, 1, 39, 42, 127, 
	9, 32, 9, 10, 32, -128, -1, 9, 
	10, 32, 9, 10, 13, 32, 34, 40, 
	41, 44, 46, 60, 61, 63, 127, 0, 
	31, 33, 57, 58, 64, 65, 90, 91, 
	93, 94, 126, 9, 10, 13, 32, 34, 
	40, 41, 44, 46, 60, 61, 63, 127, 
	0, 31, 33, 57, 58, 64, 65, 90, 
	91, 93, 94, 126, 9, 13, 32, 0, 
	127, 9, 10, 13, 32, 0, 127, 9, 
	10, 13, 32, 34, 40, 41, 44, 60, 
	61, 63, 127, 0, 31, 33, 57, 58, 
	64, 65, 90, 91, 93, 94, 126, 9, 
	13, 32, 0, 127, 9, 10, 13, 32, 
	0, 127, 0, 9, 10, 13, 32, 34, 
	92, 1, 127, 0, 9, 10, 13, 32, 
	34, 92, 1, 127, 9, 13, 32, 0, 
	127, 9, 10, 13, 32, 0, 127, 13, 
	0, 127, 0, 9, 10, 13, 32, 34, 
	92, 1, 127, 0, 10, 13, 40, 41, 
	92, 1, 127, 9, 13, 32, 0, 127, 
	9, 10, 13, 32, 0, 127, 13, 0, 
	127, 0, 10, 13, 40, 41, 92, 1, 
	127, 9, 10, 13, 32, 34, 40, 41, 
	44, 46, 61, 63, 127, 0, 31, 33, 
	57, 58, 64, 65, 90, 91, 93, 94, 
	126, 9, 13, 32, 0, 127, 9, 10, 
	13, 32, 0, 127, 9, 10, 13, 32, 
	33, 40, 41, 44, 46, 61, 64, 127, 
	0, 34, 35, 57, 58, 62, 63, 90, 
	91, 93, 94, 126, 9, 10, 13, 32, 
	40, 46, 64, 0, 127, 9, 13, 32, 
	0, 127, 9, 10, 13, 32, 0, 127, 
	0, 10, 13, 40, 41, 92, 1, 127, 
	9, 13, 32, 0, 127, 9, 10, 13, 
	32, 0, 127, 13, 0, 127, 0, 10, 
	13, 40, 41, 92, 1, 127, 9, 10, 
	13, 32, 33, 40, 41, 44, 46, 61, 
	63, 91, 127, 0, 34, 35, 57, 58, 
	64, 65, 90, 92, 93, 94, 126, 9, 
	13, 32, 0, 127, 9, 10, 13, 32, 
	0, 127, 9, 10, 13, 32, 33, 40, 
	41, 44, 46, 61, 62, 63, 127, 0, 
	34, 35, 57, 58, 64, 65, 90, 91, 
	93, 94, 126, 9, 10, 13, 32, 40, 
	46, 62, 0, 127, 9, 13, 32, 0, 
	127, 9, 10, 13, 32, 0, 127, 0, 
	10, 13, 40, 41, 92, 1, 127, 9, 
	13, 32, 0, 127, 9, 10, 13, 32, 
	0, 127, 13, 0, 127, 0, 10, 13, 
	40, 41, 92, 1, 127, 9, 10, 13, 
	32, 33, 40, 41, 44, 46, 61, 63, 
	127, 0, 34, 35, 57, 58, 64, 65, 
	90, 91, 93, 94, 126, 9, 13, 32, 
	0, 127, 9, 10, 13, 32, 0, 127, 
	9, 10, 13, 32, 33, 40, 41, 44, 
	46, 61, 62, 63, 127, 0, 34, 35, 
	57, 58, 64, 65, 90, 91, 93, 94, 
	126, 9, 10, 13, 32, 34, 40, 41, 
	44, 46, 60, 61, 63, 127, 0, 31, 
	33, 57, 58, 64, 65, 90, 91, 93, 
	94, 126, 9, 10, 13, 32, 34, 40, 
	41, 44, 46, 60, 61, 63, 127, 0, 
	31, 33, 57, 58, 64, 65, 90, 91, 
	93, 94, 126, 9, 13, 32, 0, 127, 
	9, 10, 13, 32, 0, 127, 0, 10, 
	13, 40, 41, 92, 1, 127, 9, 13, 
	32, 0, 127, 9, 10, 13, 32, 0, 
	127, 13, 0, 127, 0, 10, 13, 40, 
	41, 92, 1, 127, 0, 10, 13, 40, 
	41, 92, 1, 127, 9, 13, 32, 0, 
	127, 9, 10, 13, 32, 0, 127, 13, 
	0, 127, 0, 10, 13, 40, 41, 92, 
	1, 127, 9, 10, 13, 32, 33, 40, 
	41, 44, 46, 61, 63, 127, 0, 34, 
	35, 57, 58, 64, 65, 90, 91, 93, 
	94, 126, 0, 10, 13, 40, 41, 92, 
	1, 127, 9, 13, 32, 0, 127, 9, 
	10, 13, 32, 0, 127, 13, 0, 127, 
	0, 10, 13, 40, 41, 92, 1, 127, 
	0, 9, 10, 13, 32, 91, 92, 93, 
	1, 127, 9, 13, 32, 0, 127, 9, 
	10, 13, 32, 0, 127, 13, 0, 127, 
	0, 9, 10, 13, 32, 91, 92, 93, 
	1, 127, 9, 10, 13, 32, 40, 62, 
	0, 127, 9, 13, 32, 0, 127, 9, 
	10, 13, 32, 0, 127, 0, 10, 13, 
	40, 41, 92, 1, 127, 9, 13, 32, 
	0, 127, 9, 10, 13, 32, 0, 127, 
	13, 0, 127, 0, 10, 13, 40, 41, 
	92, 1, 127, 0, 9, 10, 13, 32, 
	34, 92, 1, 127, 0, 9, 10, 13, 
	32, 34, 92, 1, 127, 9, 13, 32, 
	0, 127, 9, 10, 13, 32, 0, 127, 
	13, 0, 127, 0, 9, 10, 13, 32, 
	34, 92, 1, 127, 0, 10, 13, 40, 
	41, 92, 1, 127, 9, 13, 32, 0, 
	127, 9, 10, 13, 32, 0, 127, 13, 
	0, 127, 0, 10, 13, 40, 41, 92, 
	1, 127, 0, 10, 13, 40, 41, 92, 
	1, 127, 9, 13, 32, 0, 127, 9, 
	10, 13, 32, 0, 127, 13, 0, 127, 
	0, 10, 13, 40, 41, 92, 1, 127, 
	9, 10, 13, 32, 0, 127, 10, 13, 
	41, 92, 1, 39, 42, 127, 9, 32, 
	9, 10, 32, 0, 127, 10, 13, 41, 
	92, 1, 39, 42, 127, 9, 32, 9, 
	10, 32, 0, 127, 9, 10, 13, 32, 
	33, 40, 45, 61, 63, 35, 39, 42, 
	43, 47, 57, 65, 90, 94, 126, 10, 
	13, 41, 92, 1, 39, 42, 127, 9, 
	32, 9, 10, 32, 0, 127, 9, 10, 
	13, 32, 92, 93, 1, 90, 94, 127, 
	9, 32, 9, 10, 32, 0, 127, 9, 
	10, 13, 32, 40, 62, 9, 32, 9, 
	10, 32, 10, 13, 41, 92, 1, 39, 
	42, 127, 9, 32, 9, 10, 32, -128, 
	-1, 9, 10, 13, 32, 92, 1, 33, 
	35, 127, 9, 10, 13, 32, 34, 92, 
	1, 127, 9, 32, 9, 10, 32, 0, 
	127, 10, 13, 41, 92, 1, 39, 42, 
	127, 9, 32, 9, 10, 32, 0, 127, 
	9, 10, 13, 32, 40, 60, 0, 127, 
	9, 13, 32, 0, 127, 9, 10, 13, 
	32, 0, 127, 0, 10, 13, 40, 41, 
	92, 1, 127, 9, 13, 32, 0, 127, 
	9, 10, 13, 32, 0, 127, 13, 0, 
	127, 0, 10, 13, 40, 41, 92, 1, 
	127, 9, 10, 13, 32, 34, 40, 41, 
	44, 46, 61, 63, 127, 0, 31, 33, 
	57, 58, 64, 65, 90, 91, 93, 94, 
	126, 9, 13, 32, 0, 127, 9, 10, 
	13, 32, 0, 127, 9, 10, 13, 32, 
	33, 40, 41, 44, 46, 61, 64, 127, 
	0, 34, 35, 57, 58, 62, 63, 90, 
	91, 93, 94, 126, 9, 10, 13, 32, 
	40, 46, 64, 0, 127, 9, 13, 32, 
	0, 127, 9, 10, 13, 32, 0, 127, 
	0, 10, 13, 40, 41, 92, 1, 127, 
	9, 13, 32, 0, 127, 9, 10, 13, 
	32, 0, 127, 13, 0, 127, 0, 10, 
	13, 40, 41, 92, 1, 127, 9, 10, 
	13, 32, 33, 40, 41, 44, 46, 61, 
	63, 91, 127, 0, 34, 35, 57, 58, 
	64, 65, 90, 92, 93, 94, 126, 9, 
	13, 32, 0, 127, 9, 10, 13, 32, 
	0, 127, 9, 10, 13, 32, 33, 40, 
	41, 44, 46, 61, 62, 63, 127, 0, 
	34, 35, 57, 58, 64, 65, 90, 91, 
	93, 94, 126, 9, 10, 13, 32, 40, 
	46, 62, 0, 127, 9, 13, 32, 0, 
	127, 9, 10, 13, 32, 0, 127, 0, 
	10, 13, 40, 41, 92, 1, 127, 9, 
	13, 32, 0, 127, 9, 10, 13, 32, 
	0, 127, 13, 0, 127, 0, 10, 13, 
	40, 41, 92, 1, 127, 9, 10, 13, 
	32, 33, 40, 41, 44, 46, 61, 63, 
	127, 0, 34, 35, 57, 58, 64, 65, 
	90, 91, 93, 94, 126, 9, 13, 32, 
	0, 127, 9, 10, 13, 32, 0, 127, 
	9, 10, 13, 32, 33, 40, 41, 44, 
	46, 61, 62, 63, 127, 0, 34, 35, 
	57, 58, 64, 65, 90, 91, 93, 94, 
	126, 9, 10, 13, 32, 40, 0, 127, 
	9, 10, 13, 32, 40, 0, 127, 9, 
	13, 32, 0, 127, 9, 10, 13, 32, 
	0, 127, 0, 10, 13, 40, 41, 92, 
	1, 127, 9, 13, 32, 0, 127, 9, 
	10, 13, 32, 0, 127, 13, 0, 127, 
	0, 10, 13, 40, 41, 92, 1, 127, 
	0, 10, 13, 40, 41, 92, 1, 127, 
	9, 13, 32, 0, 127, 9, 10, 13, 
	32, 0, 127, 13, 0, 127, 0, 10, 
	13, 40, 41, 92, 1, 127, 9, 10, 
	13, 32, 33, 40, 41, 44, 46, 61, 
	63, 127, 0, 34, 35, 57, 58, 64, 
	65, 90, 91, 93, 94, 126, 0, 10, 
	13, 40, 41, 92, 1, 127, 9, 13, 
	32, 0, 127, 9, 10, 13, 32, 0, 
	127, 13, 0, 127, 0, 10, 13, 40, 
	41, 92, 1, 127, 0, 9, 10, 13, 
	32, 91, 92, 93, 1, 127, 9, 13, 
	32, 0, 127, 9, 10, 13, 32, 0, 
	127, 13, 0, 127, 0, 9, 10, 13, 
	32, 91, 92, 93, 1, 127, 9, 10, 
	13, 32, 40, 62, 0, 127, 9, 13, 
	32, 0, 127, 9, 10, 13, 32, 0, 
	127, 0, 10, 13, 40, 41, 92, 1, 
	127, 9, 13, 32, 0, 127, 9, 10, 
	13, 32, 0, 127, 13, 0, 127, 0, 
	10, 13, 40, 41, 92, 1, 127, 0, 
	9, 10, 13, 32, 34, 92, 1, 127, 
	0, 9, 10, 13, 32, 34, 92, 1, 
	127, 9, 13, 32, 0, 127, 9, 10, 
	13, 32, 0, 127, 13, 0, 127, 0, 
	9, 10, 13, 32, 34, 92, 1, 127, 
	0, 10, 13, 40, 41, 92, 1, 127, 
	9, 13, 32, 0, 127, 9, 10, 13, 
	32, 0, 127, 13, 0, 127, 0, 10, 
	13, 40, 41, 92, 1, 127, 0, 10, 
	13, 40, 41, 92, 1, 127, 9, 13, 
	32, 0, 127, 9, 10, 13, 32, 0, 
	127, 13, 0, 127, 0, 10, 13, 40, 
	41, 92, 1, 127, 9, 10, 13, 32, 
	40, 60, 62, 0, 127, 10, 13, 40, 
	60, 62, 9, 32, 9, 10, 13, 32, 
	40, 62, 9, 10, 32, 10, 13, 41, 
	92, 1, 39, 42, 127, 9, 32, 9, 
	10, 32, 0, 127, 9, 10, 13, 32, 
	40, 44, 0, 127, 13, 0, 127, 10, 
	13, 0, 127, 9, 10, 13, 32, 40, 
	44, 0, 127, 9, 13, 32, 0, 127, 
	9, 10, 13, 32, 0, 127, 0, 10, 
	13, 40, 41, 92, 1, 127, 9, 13, 
	32, 0, 127, 9, 10, 13, 32, 0, 
	127, 13, 0, 127, 0, 10, 13, 40, 
	41, 92, 1, 127, 9, 10, 13, 32, 
	40, 60, 0, 127, 9, 13, 32, 0, 
	127, 9, 10, 13, 32, 0, 127, 0, 
	10, 13, 40, 41, 92, 1, 127, 9, 
	13, 32, 0, 127, 9, 10, 13, 32, 
	0, 127, 13, 0, 127, 0, 10, 13, 
	40, 41, 92, 1, 127, 9, 10, 13, 
	32, 40, 60, 62, 0, 127, 10, 13, 
	40, 60, 62, 10, 13, 60, 62, 92, 
	1, 40, 42, 127, 9, 32, 9, 10, 
	13, 32, 41, 62, 92, 1, 127, 9, 
	10, 32, 0, 9, 10, 13, 32, 40, 
	41, 44, 92, 1, 127, 0, 10, 13, 
	40, 41, 92, 1, 127, 9, 13, 32, 
	0, 127, 9, 10, 13, 32, 0, 127, 
	9, 10, 13, 32, 40, 62, 0, 127, 
	9, 13, 32, 0, 127, 9, 10, 13, 
	32, 0, 127, 13, 0, 127, 0, 10, 
	13, 40, 41, 92, 1, 127, 0, 9, 
	10, 13, 32, 40, 41, 44, 92, 1, 
	127, 9, 13, 32, 0, 127, 9, 10, 
	13, 32, 0, 127, 0, 9, 10, 13, 
	32, 40, 41, 60, 92, 1, 127, 9, 
	13, 32, 0, 127, 9, 10, 13, 32, 
	0, 127, 0, 9, 10, 13, 32, 40, 
	41, 60, 62, 92, 1, 127, 10, 13, 
	40, 60, 62, 0, 127, 0, 10, 13, 
	41, 60, 62, 92, 1, 127, 9, 13, 
	32, 0, 127, 0, 9, 10, 13, 32, 
	41, 62, 92, 1, 127, 9, 10, 13, 
	32, 0, 127, 10, 13, 60, 62, 0, 
	127, 0, 9, 10, 13, 32, 40, 41, 
	92, 1, 127, 0, 9, 10, 13, 32, 
	40, 41, 92, 1, 127, 9, 13, 32, 
	0, 127, 9, 10, 13, 32, 0, 127, 
	0, 10, 13, 40, 41, 60, 62, 92, 
	1, 127, 9, 13, 32, 0, 127, 0, 
	9, 10, 13, 32, 40, 41, 62, 92, 
	1, 127, 0, 10, 13, 40, 41, 92, 
	1, 127, 9, 13, 32, 0, 127, 9, 
	10, 13, 32, 0, 127, 13, 0, 127, 
	0, 10, 13, 40, 41, 92, 1, 127, 
	9, 10, 13, 32, 0, 127, 0, 9, 
	10, 13, 32, 40, 41, 44, 92, 1, 
	127, 0, 9, 10, 13, 32, 40, 41, 
	44, 92, 1, 127, 9, 13, 32, 0, 
	127, 9, 10, 13, 32, 0, 127, 0, 
	9, 10, 13, 32, 40, 41, 60, 92, 
	1, 127, 9, 13, 32, 0, 127, 9, 
	10, 13, 32, 0, 127, 0, 9, 10, 
	13, 32, 41, 60, 62, 92, 1, 127, 
	9, 13, 32, 0, 127, 9, 10, 13, 
	32, 0, 127, 10, 13, 60, 62, 0, 
	127, 0, 9, 10, 13, 32, 40, 41, 
	92, 1, 127, 0, 9, 10, 13, 32, 
	40, 41, 92, 1, 127, 10, 13, 60, 
	62, 0, 127, 9, 10, 13, 32, 41, 
	92, 1, 39, 42, 127, 9, 10, 13, 
	32, 41, 92, 1, 39, 42, 127, 9, 
	13, 32, 0, 127, 9, 10, 13, 32, 
	0, 127, 10, 13, 60, 62, 92, 1, 
	40, 42, 127, 9, 32, 9, 10, 13, 
	32, 41, 62, 92, 1, 127, 9, 10, 
	32, 0, 9, 10, 13, 32, 40, 41, 
	44, 92, 1, 127, 0, 9, 10, 13, 
	32, 40, 41, 44, 92, 1, 127, 9, 
	13, 32, 0, 127, 9, 10, 13, 32, 
	0, 127, 0, 9, 10, 13, 32, 40, 
	41, 60, 92, 1, 127, 9, 13, 32, 
	0, 127, 9, 10, 13, 32, 0, 127, 
	0, 9, 10, 13, 32, 40, 41, 60, 
	62, 92, 1, 127, 0, 10, 13, 40, 
	41, 60, 62, 92, 1, 127, 9, 13, 
	32, 0, 127, 0, 9, 10, 13, 32, 
	41, 62, 92, 1, 127, 9, 10, 13, 
	32, 0, 127, 9, 10, 13, 32, 40, 
	60, 62, 0, 127, 10, 13, 60, 62, 
	0, 127, 0, 9, 10, 13, 32, 40, 
	41, 92, 1, 127, 0, 9, 10, 13, 
	32, 40, 41, 92, 1, 127, 9, 13, 
	32, 0, 127, 9, 10, 13, 32, 0, 
	127, 10, 13, 60, 62, 0, 127, 9, 
	10, 13, 32, 41, 92, 1, 39, 42, 
	127, 9, 10, 13, 32, 41, 92, 1, 
	39, 42, 127, 10, 13, 40, 60, 62, 
	0, 127, 9, 13, 32, 0, 127, 9, 
	10, 13, 32, 40, 62, 0, 127, 9, 
	10, 13, 32, 0, 127, 0, 10, 13, 
	40, 41, 92, 1, 127, 9, 13, 32, 
	0, 127, 9, 10, 13, 32, 0, 127, 
	13, 0, 127, 0, 10, 13, 40, 41, 
	92, 1, 127, 0, 10, 13, 41, 60, 
	62, 92, 1, 127, 9, 13, 32, 0, 
	127, 0, 9, 10, 13, 32, 41, 62, 
	92, 1, 127, 9, 10, 13, 32, 0, 
	127, 10, 13, 60, 62, 0, 127, 0, 
	9, 10, 13, 32, 40, 41, 92, 1, 
	127, 0, 9, 10, 13, 32, 40, 41, 
	92, 1, 127, 9, 13, 32, 0, 127, 
	9, 10, 13, 32, 0, 127, 0, 10, 
	13, 40, 41, 60, 62, 92, 1, 127, 
	9, 13, 32, 0, 127, 0, 9, 10, 
	13, 32, 40, 41, 62, 92, 1, 127, 
	0, 10, 13, 40, 41, 92, 1, 127, 
	9, 13, 32, 0, 127, 9, 10, 13, 
	32, 0, 127, 13, 0, 127, 0, 10, 
	13, 40, 41, 92, 1, 127, 9, 10, 
	13, 32, 0, 127, 0, 9, 10, 13, 
	32, 40, 41, 44, 92, 1, 127, 0, 
	10, 13, 40, 41, 92, 1, 127, 9, 
	13, 32, 0, 127, 9, 10, 13, 32, 
	0, 127, 9, 10, 13, 32, 40, 60, 
	62, 0, 127, 10, 13, 40, 60, 62, 
	0, 127, 0, 10, 13, 41, 60, 62, 
	92, 1, 127, 10, 13, 60, 62, 0, 
	127, 9, 13, 32, 0, 127, 9, 10, 
	13, 32, 0, 127, 0, 10, 13, 40, 
	41, 60, 62, 92, 1, 127, 9, 13, 
	32, 0, 127, 0, 9, 10, 13, 32, 
	40, 41, 62, 92, 1, 127, 9, 10, 
	13, 32, 0, 127, 13, 0, 127, 0, 
	10, 13, 40, 41, 92, 1, 127, 10, 
	13, 60, 62, 0, 127, 0, 9, 10, 
	13, 32, 40, 41, 92, 1, 127, 0, 
	9, 10, 13, 32, 40, 41, 92, 1, 
	127, 0, 9, 10, 13, 32, 40, 41, 
	44, 92, 1, 127, 9, 13, 32, 0, 
	127, 9, 10, 13, 32, 0, 127, 0, 
	9, 10, 13, 32, 40, 41, 60, 92, 
	1, 127, 9, 13, 32, 0, 127, 9, 
	10, 13, 32, 0, 127, 0, 9, 10, 
	13, 32, 40, 41, 60, 62, 92, 1, 
	127, 0, 10, 13, 40, 41, 60, 62, 
	92, 1, 127, 10, 13, 60, 62, 0, 
	127, 9, 13, 32, 0, 127, 9, 10, 
	13, 32, 0, 127, 10, 13, 60, 62, 
	0, 127, 0, 9, 10, 13, 32, 40, 
	41, 92, 1, 127, 0, 9, 10, 13, 
	32, 40, 41, 92, 1, 127, 13, 79, 
	111, 0, 127, 13, 0, 127, 10, 13, 
	0, 127, 9, 10, 13, 32, 92, 1, 
	33, 35, 127, 9, 10, 13, 32, 34, 
	92, 1, 127, 9, 32, 9, 10, 32, 
	0, 127, 10, 13, 41, 92, 1, 39, 
	42, 127, 9, 32, 9, 10, 32, 0, 
	127, 9, 10, 13, 32, 34, 40, 45, 
	61, 63, 33, 39, 42, 43, 47, 57, 
	65, 90, 94, 126, 9, 32, 9, 10, 
	32, 9, 10, 13, 32, 33, 40, 46, 
	61, 64, 35, 39, 42, 43, 45, 57, 
	63, 90, 94, 126, 9, 10, 13, 32, 
	40, 46, 64, 9, 32, 9, 10, 32, 
	10, 13, 41, 92, 1, 39, 42, 127, 
	9, 32, 9, 10, 32, 0, 127, 9, 
	10, 13, 32, 33, 40, 45, 61, 63, 
	91, 35, 39, 42, 43, 47, 57, 65, 
	90, 94, 126, 9, 32, 9, 10, 32, 
	9, 10, 13, 32, 33, 40, 46, 62, 
	35, 39, 42, 43, 45, 57, 61, 63, 
	65, 90, 94, 126, 9, 10, 13, 32, 
	40, 46, 62, 9, 32, 9, 10, 32, 
	10, 13, 41, 92, 1, 39, 42, 127, 
	9, 32, 9, 10, 32, 0, 127, 9, 
	10, 13, 32, 33, 40, 45, 61, 63, 
	35, 39, 42, 43, 47, 57, 65, 90, 
	94, 126, 9, 32, 9, 10, 32, 9, 
	10, 13, 32, 33, 40, 46, 62, 35, 
	39, 42, 43, 45, 57, 61, 63, 65, 
	90, 94, 126, 9, 10, 13, 32, 34, 
	40, 45, 60, 61, 63, 33, 39, 42, 
	43, 47, 57, 65, 90, 94, 126, 9, 
	10, 13, 32, 34, 40, 45, 60, 61, 
	63, 33, 39, 42, 43, 47, 57, 65, 
	90, 94, 126, 9, 32, 9, 10, 32, 
	10, 13, 41, 92, 1, 39, 42, 127, 
	9, 32, 9, 10, 32, 0, 127, 10, 
	13, 41, 92, 1, 39, 42, 127, 9, 
	32, 9, 10, 32, 0, 127, 9, 10, 
	13, 32, 33, 40, 45, 61, 63, 35, 
	39, 42, 43, 47, 57, 65, 90, 94, 
	126, 10, 13, 41, 92, 1, 39, 42, 
	127, 9, 32, 9, 10, 32, -128, -1, 
	9, 10, 13, 32, 92, 93, 1, 90, 
	94, 127, 9, 32, 9, 10, 32, 0, 
	127, 9, 10, 13, 32, 40, 62, 9, 
	32, 9, 10, 32, 10, 13, 41, 92, 
	1, 39, 42, 127, 9, 32, 9, 10, 
	32, -128, -1, 9, 10, 13, 32, 92, 
	1, 33, 35, 127, 9, 10, 13, 32, 
	34, 92, 1, 127, 9, 32, 9, 10, 
	32, 0, 127, 10, 13, 41, 92, 1, 
	39, 42, 127, 9, 32, 9, 10, 32, 
	0, 127, 10, 13, 41, 92, 1, 39, 
	42, 127, 9, 32, 9, 10, 32, 0, 
	127, 9, 10, 32, 9, 10, 13, 32, 
	34, 40, 41, 44, 46, 60, 61, 63, 
	127, 0, 31, 33, 57, 58, 64, 65, 
	90, 91, 93, 94, 126, 9, 10, 13, 
	32, 34, 40, 41, 44, 46, 60, 61, 
	63, 127, 0, 31, 33, 57, 58, 64, 
	65, 90, 91, 93, 94, 126, 9, 13, 
	32, 0, 127, 9, 10, 13, 32, 0, 
	127, 9, 10, 13, 32, 34, 40, 41, 
	44, 60, 61, 63, 127, 0, 31, 33, 
	57, 58, 64, 65, 90, 91, 93, 94, 
	126, 9, 13, 32, 0, 127, 9, 10, 
	13, 32, 0, 127, 0, 9, 10, 13, 
	32, 34, 92, 1, 127, 0, 9, 10, 
	13, 32, 34, 92, 1, 127, 9, 13, 
	32, 0, 127, 9, 10, 13, 32, 0, 
	127, 13, 0, 127, 0, 9, 10, 13, 
	32, 34, 92, 1, 127, 0, 10, 13, 
	40, 41, 92, 1, 127, 9, 13, 32, 
	0, 127, 9, 10, 13, 32, 0, 127, 
	13, 0, 127, 0, 10, 13, 40, 41, 
	92, 1, 127, 9, 10, 13, 32, 34, 
	40, 41, 44, 46, 61, 63, 127, 0, 
	31, 33, 57, 58, 64, 65, 90, 91, 
	93, 94, 126, 9, 13, 32, 0, 127, 
	9, 10, 13, 32, 0, 127, 9, 10, 
	13, 32, 33, 40, 41, 44, 46, 61, 
	64, 127, 0, 34, 35, 57, 58, 62, 
	63, 90, 91, 93, 94, 126, 9, 10, 
	13, 32, 40, 46, 64, 0, 127, 9, 
	13, 32, 0, 127, 9, 10, 13, 32, 
	0, 127, 0, 10, 13, 40, 41, 92, 
	1, 127, 9, 13, 32, 0, 127, 9, 
	10, 13, 32, 0, 127, 13, 0, 127, 
	0, 10, 13, 40, 41, 92, 1, 127, 
	9, 10, 13, 32, 33, 40, 41, 44, 
	46, 61, 63, 91, 127, 0, 34, 35, 
	57, 58, 64, 65, 90, 92, 93, 94, 
	126, 9, 13, 32, 0, 127, 9, 10, 
	13, 32, 0, 127, 9, 10, 13, 32, 
	33, 40, 41, 44, 46, 61, 62, 63, 
	127, 0, 34, 35, 57, 58, 64, 65, 
	90, 91, 93, 94, 126, 9, 10, 13, 
	32, 40, 46, 62, 0, 127, 9, 13, 
	32, 0, 127, 9, 10, 13, 32, 0, 
	127, 0, 10, 13, 40, 41, 92, 1, 
	127, 9, 13, 32, 0, 127, 9, 10, 
	13, 32, 0, 127, 13, 0, 127, 0, 
	10, 13, 40, 41, 92, 1, 127, 9, 
	10, 13, 32, 33, 40, 41, 44, 46, 
	61, 63, 127, 0, 34, 35, 57, 58, 
	64, 65, 90, 91, 93, 94, 126, 9, 
	13, 32, 0, 127, 9, 10, 13, 32, 
	0, 127, 9, 10, 13, 32, 33, 40, 
	41, 44, 46, 61, 62, 63, 127, 0, 
	34, 35, 57, 58, 64, 65, 90, 91, 
	93, 94, 126, 9, 10, 13, 32, 34, 
	40, 41, 44, 46, 60, 61, 63, 127, 
	0, 31, 33, 57, 58, 64, 65, 90, 
	91, 93, 94, 126, 9, 10, 13, 32, 
	34, 40, 41, 44, 46, 60, 61, 63, 
	127, 0, 31, 33, 57, 58, 64, 65, 
	90, 91, 93, 94, 126, 9, 13, 32, 
	0, 127, 9, 10, 13, 32, 0, 127, 
	0, 10, 13, 40, 41, 92, 1, 127, 
	9, 13, 32, 0, 127, 9, 10, 13, 
	32, 0, 127, 13, 0, 127, 0, 10, 
	13, 40, 41, 92, 1, 127, 0, 10, 
	13, 40, 41, 92, 1, 127, 9, 13, 
	32, 0, 127, 9, 10, 13, 32, 0, 
	127, 13, 0, 127, 0, 10, 13, 40, 
	41, 92, 1, 127, 9, 10, 13, 32, 
	33, 40, 41, 44, 46, 61, 63, 127, 
	0, 34, 35, 57, 58, 64, 65, 90, 
	91, 93, 94, 126, 0, 10, 13, 40, 
	41, 92, 1, 127, 9, 13, 32, 0, 
	127, 9, 10, 13, 32, 0, 127, 13, 
	0, 127, 0, 10, 13, 40, 41, 92, 
	1, 127, 0, 9, 10, 13, 32, 91, 
	92, 93, 1, 127, 9, 13, 32, 0, 
	127, 9, 10, 13, 32, 0, 127, 13, 
	0, 127, 0, 9, 10, 13, 32, 91, 
	92, 93, 1, 127, 9, 10, 13, 32, 
	40, 62, 0, 127, 9, 13, 32, 0, 
	127, 9, 10, 13, 32, 0, 127, 0, 
	10, 13, 40, 41, 92, 1, 127, 9, 
	13, 32, 0, 127, 9, 10, 13, 32, 
	0, 127, 13, 0, 127, 0, 10, 13, 
	40, 41, 92, 1, 127, 0, 9, 10, 
	13, 32, 34, 92, 1, 127, 0, 9, 
	10, 13, 32, 34, 92, 1, 127, 9, 
	13, 32, 0, 127, 9, 10, 13, 32, 
	0, 127, 13, 0, 127, 0, 9, 10, 
	13, 32, 34, 92, 1, 127, 0, 10, 
	13, 40, 41, 92, 1, 127, 9, 13, 
	32, 0, 127, 9, 10, 13, 32, 0, 
	127, 13, 0, 127, 0, 10, 13, 40, 
	41, 92, 1, 127, 0, 10, 13, 40, 
	41, 92, 1, 127, 9, 13, 32, 0, 
	127, 9, 10, 13, 32, 0, 127, 13, 
	0, 127, 0, 10, 13, 40, 41, 92, 
	1, 127, 9, 10, 13, 32, 0, 127, 
	13, 73, 76, 77, 82, 105, 108, 109, 
	114, 33, 57, 59, 126, 13, 9, 13, 
	32, 73, 76, 77, 82, 105, 108, 109, 
	114, 33, 57, 59, 126, 9, 13, 32, 
	73, 76, 77, 82, 105, 108, 109, 114, 
	33, 57, 59, 126, 9, 13, 32, 73, 
	76, 77, 82, 105, 108, 109, 114, 33, 
	57, 59, 126, 9, 13, 32, 73, 76, 
	77, 82, 105, 108, 109, 114, 33, 57, 
	59, 126, 9, 13, 32, 73, 76, 77, 
	82, 105, 108, 109, 114, 33, 57, 59, 
	126, 9, 13, 32, 73, 76, 77, 82, 
	105, 108, 109, 114, 33, 57, 59, 126, 
	9, 13, 32, 73, 76, 77, 82, 105, 
	108, 109, 114, 33, 57, 59, 126, 9, 
	13, 32, 73, 76, 77, 82, 105, 108, 
	109, 114, 33, 57, 59, 126, 9, 13, 
	32, 73, 76, 77, 82, 105, 108, 109, 
	114, 33, 57, 59, 126, 9, 13, 32, 
	73, 76, 77, 82, 105, 108, 109, 114, 
	33, 57, 59, 126, 9, 13, 32, 73, 
	76, 77, 82, 105, 108, 109, 114, 33, 
	57, 59, 126, 9, 13, 32, 73, 76, 
	77, 82, 105, 108, 109, 114, 33, 57, 
	59, 126, 9, 13, 32, 73, 76, 77, 
	82, 105, 108, 109, 114, 33, 57, 59, 
	126, 9, 13, 32, 73, 76, 77, 82, 
	105, 108, 109, 114, 33, 57, 59, 126, 
	9, 13, 32, 73, 76, 77, 82, 105, 
	108, 109, 114, 33, 57, 59, 126, 9, 
	13, 32, 73, 76, 77, 82, 105, 108, 
	109, 114, 33, 57, 59, 126, 9, 13, 
	32, 73, 76, 77, 82, 105, 108, 109, 
	114, 33, 57, 59, 126, 9, 13, 32, 
	73, 76, 77, 82, 105, 108, 109, 114, 
	33, 57, 59, 126, 9, 13, 32, 73, 
	76, 77, 82, 105, 108, 109, 114, 33, 
	57, 59, 126, 9, 13, 32, 73, 76, 
	77, 82, 105, 108, 109, 114, 33, 57, 
	59, 126, 9, 13, 32, 73, 76, 77, 
	82, 105, 108, 109, 114, 33, 57, 59, 
	126, 9, 13, 32, 73, 76, 77, 82, 
	105, 108, 109, 114, 33, 57, 59, 126, 
	9, 13, 32, 73, 76, 77, 82, 105, 
	108, 109, 114, 33, 57, 59, 126, 9, 
	13, 32, 73, 76, 77, 82, 105, 108, 
	109, 114, 33, 57, 59, 126, 9, 13, 
	32, 73, 76, 77, 82, 105, 108, 109, 
	114, 33, 57, 59, 126, 9, 13, 32, 
	73, 76, 77, 82, 105, 108, 109, 114, 
	33, 57, 59, 126, 9, 13, 32, 73, 
	76, 77, 82, 105, 108, 109, 114, 33, 
	57, 59, 126, 9, 13, 32, 73, 76, 
	77, 82, 105, 108, 109, 114, 33, 57, 
	59, 126, 9, 13, 32, 73, 76, 77, 
	82, 105, 108, 109, 114, 33, 57, 59, 
	126, 9, 13, 32, 73, 76, 77, 82, 
	105, 108, 109, 114, 33, 57, 59, 126, 
	9, 13, 32, 73, 76, 77, 82, 105, 
	108, 109, 114, 33, 57, 59, 126, 9, 
	13, 32, 73, 76, 77, 82, 105, 108, 
	109, 114, 33, 57, 59, 126, 9, 13, 
	32, 73, 76, 77, 82, 105, 108, 109, 
	114, 33, 57, 59, 126, 9, 13, 32, 
	73, 76, 77, 82, 105, 108, 109, 114, 
	33, 57, 59, 126, 9, 13, 32, 73, 
	76, 77, 82, 105, 108, 109, 114, 33, 
	57, 59, 126, 9, 13, 32, 73, 76, 
	77, 82, 105, 108, 109, 114, 33, 57, 
	59, 126, 9, 13, 32, 73, 76, 77, 
	82, 105, 108, 109, 114, 33, 57, 59, 
	126, 9, 13, 32, 73, 76, 77, 82, 
	105, 108, 109, 114, 33, 57, 59, 126, 
	9, 13, 32, 73, 76, 77, 82, 105, 
	108, 109, 114, 33, 57, 59, 126, 9, 
	13, 32, 73, 76, 77, 82, 105, 108, 
	109, 114, 33, 57, 59, 126, 9, 13, 
	32, 73, 76, 77, 82, 105, 108, 109, 
	114, 33, 57, 59, 126, 9, 13, 32, 
	73, 76, 77, 82, 105, 108, 109, 114, 
	33, 57, 59, 126, 9, 13, 32, 73, 
	76, 77, 82, 105, 108, 109, 114, 33, 
	57, 59, 126, 9, 13, 32, 73, 76, 
	77, 82, 105, 108, 109, 114, 33, 57, 
	59, 126, 9, 13, 32, 73, 76, 77, 
	82, 105, 108, 109, 114, 33, 57, 59, 
	126, 9, 13, 32, 73, 76, 77, 82, 
	105, 108, 109, 114, 33, 57, 59, 126, 
	9, 13, 32, 73, 76, 77, 82, 105, 
	108, 109, 114, 33, 57, 59, 126, 9, 
	13, 32, 73, 76, 77, 82, 105, 108, 
	109, 114, 33, 57, 59, 126, 9, 13, 
	32, 73, 76, 77, 82, 105, 108, 109, 
	114, 33, 57, 59, 126, 9, 13, 32, 
	73, 76, 77, 82, 105, 108, 109, 114, 
	33, 57, 59, 126, 9, 13, 32, 73, 
	76, 77, 82, 105, 108, 109, 114, 33, 
	57, 59, 126, 9, 13, 32, 73, 76, 
	77, 82, 105, 108, 109, 114, 33, 57, 
	59, 126, 9, 13, 32, 73, 76, 77, 
	82, 105, 108, 109, 114, 33, 57, 59, 
	126, 9, 13, 32, 73, 76, 77, 82, 
	105, 108, 109, 114, 33, 57, 59, 126, 
	9, 13, 32, 73, 76, 77, 82, 105, 
	108, 109, 114, 33, 57, 59, 126, 9, 
	13, 32, 73, 76, 77, 82, 105, 108, 
	109, 114, 33, 57, 59, 126, 9, 13, 
	32, 73, 76, 77, 82, 105, 108, 109, 
	114, 33, 57, 59, 126, 9, 13, 32, 
	73, 76, 77, 82, 105, 108, 109, 114, 
	33, 57, 59, 126, 9, 13, 32, 73, 
	76, 77, 82, 105, 108, 109, 114, 33, 
	57, 59, 126, 9, 13, 32, 73, 76, 
	77, 82, 105, 108, 109, 114, 33, 57, 
	59, 126, 9, 13, 32, 73, 76, 77, 
	82, 105, 108, 109, 114, 33, 57, 59, 
	126, 9, 13, 32, 73, 76, 77, 82, 
	105, 108, 109, 114, 33, 57, 59, 126, 
	9, 13, 32, 73, 76, 77, 82, 105, 
	108, 109, 114, 33, 57, 59, 126, 9, 
	13, 32, 73, 76, 77, 82, 105, 108, 
	109, 114, 33, 57, 59, 126, 9, 13, 
	32, 73, 76, 77, 82, 105, 108, 109, 
	114, 33, 57, 59, 126, 9, 13, 32, 
	73, 76, 77, 82, 105, 108, 109, 114, 
	33, 57, 59, 126, 9, 13, 32, 73, 
	76, 77, 82, 105, 108, 109, 114, 33, 
	57, 59, 126, 9, 13, 32, 73, 76, 
	77, 82, 105, 108, 109, 114, 33, 57, 
	59, 126, 9, 13, 32, 73, 76, 77, 
	82, 105, 108, 109, 114, 33, 57, 59, 
	126, 9, 13, 32, 73, 76, 77, 82, 
	105, 108, 109, 114, 33, 57, 59, 126, 
	9, 13, 32, 73, 76, 77, 82, 105, 
	108, 109, 114, 33, 57, 59, 126, 9, 
	13, 32, 73, 76, 77, 82, 105, 108, 
	109, 114, 33, 57, 59, 126, 9, 13, 
	32, 73, 76, 77, 82, 105, 108, 109, 
	114, 33, 57, 59, 126, 9, 13, 32, 
	73, 76, 77, 82, 105, 108, 109, 114, 
	33, 57, 59, 126, 9, 13, 32, 73, 
	76, 77, 82, 105, 108, 109, 114, 33, 
	57, 59, 126, 9, 13, 32, 73, 76, 
	77, 82, 105, 108, 109, 114, 33, 57, 
	59, 126, 9, 13, 32, 73, 76, 77, 
	82, 105, 108, 109, 114, 33, 57, 59, 
	126, 9, 13, 32, 73, 76, 77, 82, 
	105, 108, 109, 114, 33, 57, 59, 126, 
	9, 13, 32, 73, 76, 77, 82, 105, 
	108, 109, 114, 33, 57, 59, 126, 9, 
	13, 32, 73, 76, 77, 82, 105, 108, 
	109, 114, 33, 57, 59, 126, 9, 13, 
	32, 73, 76, 77, 82, 105, 108, 109, 
	114, 33, 57, 59, 126, 9, 13, 32, 
	73, 76, 77, 82, 105, 108, 109, 114, 
	33, 57, 59, 126, 9, 13, 32, 73, 
	76, 77, 82, 105, 108, 109, 114, 33, 
	57, 59, 126, 9, 13, 32, 73, 76, 
	77, 82, 105, 108, 109, 114, 33, 57, 
	59, 126, 9, 13, 32, 73, 76, 77, 
	82, 105, 108, 109, 114, 33, 57, 59, 
	126, 9, 13, 32, 73, 76, 77, 82, 
	105, 108, 109, 114, 33, 57, 59, 126, 
	9, 13, 32, 73, 76, 77, 82, 105, 
	108, 109, 114, 33, 57, 59, 126, 9, 
	13, 32, 73, 76, 77, 82, 105, 108, 
	109, 114, 33, 57, 59, 126, 9, 13, 
	32, 73, 76, 77, 82, 105, 108, 109, 
	114, 33, 57, 59, 126, 9, 13, 32, 
	73, 76, 77, 82, 105, 108, 109, 114, 
	33, 57, 59, 126, 9, 13, 32, 73, 
	76, 77, 82, 105, 108, 109, 114, 33, 
	57, 59, 126, 9, 13, 32, 73, 76, 
	77, 82, 105, 108, 109, 114, 33, 57, 
	59, 126, 9, 13, 32, 73, 76, 77, 
	82, 105, 108, 109, 114, 33, 57, 59, 
	126, 9, 13, 32, 73, 76, 77, 82, 
	105, 108, 109, 114, 33, 57, 59, 126, 
	9, 13, 32, 73, 76, 77, 82, 105, 
	108, 109, 114, 33, 57, 59, 126, 9, 
	13, 32, 73, 76, 77, 82, 105, 108, 
	109, 114, 33, 57, 59, 126, 9, 13, 
	32, 73, 76, 77, 82, 105, 108, 109, 
	114, 33, 57, 59, 126, 9, 13, 32, 
	73, 76, 77, 82, 105, 108, 109, 114, 
	33, 57, 59, 126, 9, 13, 32, 73, 
	76, 77, 82, 105, 108, 109, 114, 33, 
	57, 59, 126, 9, 13, 32, 73, 76, 
	77, 82, 105, 108, 109, 114, 33, 57, 
	59, 126, 9, 13, 32, 73, 76, 77, 
	82, 105, 108, 109, 114, 33, 57, 59, 
	126, 9, 13, 32, 73, 76, 77, 82, 
	105, 108, 109, 114, 33, 57, 59, 126, 
	9, 13, 32, 73, 76, 77, 82, 105, 
	108, 109, 114, 33, 57, 59, 126, 9, 
	13, 32, 73, 76, 77, 82, 105, 108, 
	109, 114, 33, 57, 59, 126, 9, 13, 
	32, 73, 76, 77, 82, 105, 108, 109, 
	114, 33, 57, 59, 126, 9, 13, 32, 
	73, 76, 77, 82, 105, 108, 109, 114, 
	33, 57, 59, 126, 0
};

static const int8_t _rfc5322_single_lengths[] = {
	0, 1, 1, 1, 2, 3, 2, 3, 
	3, 3, 3, 3, 2, 3, 3, 3, 
	3, 10, 10, 2, 3, 9, 2, 3, 
	3, 3, 3, 2, 3, 3, 3, 3, 
	1, 8, 3, 4, 3, 3, 3, 3, 
	3, 3, 2, 3, 3, 3, 3, 6, 
	2, 3, 4, 2, 3, 0, 9, 2, 
	3, 9, 7, 2, 3, 4, 2, 3, 
	0, 10, 2, 3, 8, 7, 2, 3, 
	4, 2, 3, 0, 9, 2, 3, 8, 
	5, 5, 2, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 10, 
	10, 2, 3, 9, 2, 3, 5, 6, 
	2, 3, 0, 4, 2, 3, 0, 9, 
	2, 3, 9, 7, 2, 3, 4, 2, 
	3, 0, 10, 2, 3, 8, 7, 2, 
	3, 4, 2, 3, 0, 9, 2, 3, 
	8, 10, 10, 2, 3, 4, 2, 3, 
	0, 4, 2, 3, 0, 9, 4, 2, 
	3, 0, 6, 2, 3, 0, 6, 2, 
	3, 4, 2, 3, 0, 5, 6, 2, 
	3, 0, 4, 2, 3, 0, 4, 2, 
	3, 0, 3, 13, 13, 3, 4, 12, 
	3, 4, 7, 7, 3, 4, 1, 7, 
	6, 3, 4, 1, 6, 12, 3, 4, 
	12, 7, 3, 4, 6, 3, 4, 1, 
	6, 13, 3, 4, 13, 7, 3, 4, 
	6, 3, 4, 1, 6, 12, 3, 4, 
	13, 13, 13, 3, 4, 6, 3, 4, 
	1, 6, 6, 3, 4, 1, 6, 12, 
	6, 3, 4, 1, 6, 8, 3, 4, 
	1, 8, 6, 3, 4, 6, 3, 4, 
	1, 6, 7, 7, 3, 4, 1, 7, 
	6, 3, 4, 1, 6, 6, 3, 4, 
	1, 6, 4, 4, 2, 3, 0, 4, 
	2, 3, 0, 9, 4, 2, 3, 0, 
	6, 2, 3, 0, 6, 2, 3, 4, 
	2, 3, 0, 5, 6, 2, 3, 0, 
	4, 2, 3, 0, 6, 3, 4, 6, 
	3, 4, 1, 6, 12, 3, 4, 12, 
	7, 3, 4, 6, 3, 4, 1, 6, 
	13, 3, 4, 13, 7, 3, 4, 6, 
	3, 4, 1, 6, 12, 3, 4, 13, 
	5, 5, 3, 4, 6, 3, 4, 1, 
	6, 6, 3, 4, 1, 6, 12, 6, 
	3, 4, 1, 6, 8, 3, 4, 1, 
	8, 6, 3, 4, 6, 3, 4, 1, 
	6, 7, 7, 3, 4, 1, 7, 6, 
	3, 4, 1, 6, 6, 3, 4, 1, 
	6, 7, 5, 2, 6, 3, 4, 2, 
	3, 0, 6, 1, 2, 6, 3, 4, 
	6, 3, 4, 1, 6, 6, 3, 4, 
	6, 3, 4, 1, 6, 7, 5, 5, 
	2, 7, 3, 9, 6, 3, 4, 6, 
	3, 4, 1, 6, 9, 3, 4, 9, 
	3, 4, 10, 5, 7, 3, 8, 4, 
	4, 8, 8, 3, 4, 8, 3, 9, 
	6, 3, 4, 1, 6, 4, 9, 9, 
	3, 4, 9, 3, 4, 9, 3, 4, 
	4, 8, 8, 4, 6, 6, 3, 4, 
	5, 2, 7, 3, 9, 9, 3, 4, 
	9, 3, 4, 10, 8, 3, 8, 4, 
	7, 4, 8, 8, 3, 4, 4, 6, 
	6, 5, 3, 6, 4, 6, 3, 4, 
	1, 6, 7, 3, 8, 4, 4, 8, 
	8, 3, 4, 8, 3, 9, 6, 3, 
	4, 1, 6, 4, 9, 6, 3, 4, 
	7, 5, 7, 4, 3, 4, 8, 3, 
	9, 4, 1, 6, 4, 8, 8, 9, 
	3, 4, 9, 3, 4, 10, 8, 4, 
	3, 4, 4, 8, 8, 3, 1, 2, 
	5, 6, 2, 3, 0, 4, 2, 3, 
	0, 9, 2, 3, 9, 7, 2, 3, 
	4, 2, 3, 0, 10, 2, 3, 8, 
	7, 2, 3, 4, 2, 3, 0, 9, 
	2, 3, 8, 10, 10, 2, 3, 4, 
	2, 3, 0, 4, 2, 3, 0, 9, 
	4, 2, 3, 0, 6, 2, 3, 0, 
	6, 2, 3, 4, 2, 3, 0, 5, 
	6, 2, 3, 0, 4, 2, 3, 0, 
	4, 2, 3, 0, 3, 13, 13, 3, 
	4, 12, 3, 4, 7, 7, 3, 4, 
	1, 7, 6, 3, 4, 1, 6, 12, 
	3, 4, 12, 7, 3, 4, 6, 3, 
	4, 1, 6, 13, 3, 4, 13, 7, 
	3, 4, 6, 3, 4, 1, 6, 12, 
	3, 4, 13, 13, 13, 3, 4, 6, 
	3, 4, 1, 6, 6, 3, 4, 1, 
	6, 12, 6, 3, 4, 1, 6, 8, 
	3, 4, 1, 8, 6, 3, 4, 6, 
	3, 4, 1, 6, 7, 7, 3, 4, 
	1, 7, 6, 3, 4, 1, 6, 6, 
	3, 4, 1, 6, 4, 9, 1, 11, 
	11, 11, 11, 11, 11, 11, 11, 11, 
	11, 11, 11, 11, 11, 11, 11, 11, 
	11, 11, 11, 11, 11, 11, 11, 11, 
	11, 11, 11, 11, 11, 11, 11, 11, 
	11, 11, 11, 11, 11, 11, 11, 11, 
	11, 11, 11, 11, 11, 11, 11, 11, 
	11, 11, 11, 11, 11, 11, 11, 11, 
	11, 11, 11, 11, 11, 11, 11, 11, 
	11, 11, 11, 11, 11, 11, 11, 11, 
	11, 11, 11, 11, 11, 11, 11, 11, 
	11, 11, 11, 11, 11, 11, 11, 11, 
	11, 11, 11, 11, 11, 11, 11, 11, 
	11, 11, 11, 11, 11, 11, 11, 11, 
	11
};

static const int8_t _rfc5322_range_lengths[] = {
	0, 0, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	0, 5, 5, 0, 0, 5, 0, 0, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 0, 0, 
	0, 0, 2, 0, 0, 1, 5, 0, 
	0, 5, 0, 0, 0, 2, 0, 0, 
	1, 5, 0, 0, 6, 0, 0, 0, 
	2, 0, 0, 1, 5, 0, 0, 6, 
	0, 0, 0, 0, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 0, 5, 
	5, 0, 0, 5, 0, 0, 2, 1, 
	0, 0, 1, 2, 0, 0, 1, 5, 
	0, 0, 5, 0, 0, 0, 2, 0, 
	0, 1, 5, 0, 0, 6, 0, 0, 
	0, 2, 0, 0, 1, 5, 0, 0, 
	6, 5, 5, 0, 0, 2, 0, 0, 
	1, 2, 0, 0, 1, 5, 2, 0, 
	0, 1, 2, 0, 0, 1, 0, 0, 
	0, 2, 0, 0, 1, 2, 1, 0, 
	0, 1, 2, 0, 0, 1, 2, 0, 
	0, 1, 0, 6, 6, 1, 1, 6, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 6, 1, 1, 
	6, 1, 1, 1, 1, 1, 1, 1, 
	1, 6, 1, 1, 6, 1, 1, 1, 
	1, 1, 1, 1, 1, 6, 1, 1, 
	6, 6, 6, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 6, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 2, 0, 0, 1, 2, 
	0, 0, 1, 5, 2, 0, 0, 1, 
	2, 0, 0, 1, 0, 0, 0, 2, 
	0, 0, 1, 2, 1, 0, 0, 1, 
	2, 0, 0, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 6, 1, 1, 6, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	6, 1, 1, 6, 1, 1, 1, 1, 
	1, 1, 1, 1, 6, 1, 1, 6, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 6, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 0, 0, 0, 0, 2, 0, 
	0, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 0, 2, 
	0, 1, 0, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 2, 2, 1, 1, 
	2, 0, 1, 0, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 2, 
	2, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	2, 1, 0, 0, 1, 2, 0, 0, 
	1, 5, 0, 0, 5, 0, 0, 0, 
	2, 0, 0, 1, 5, 0, 0, 6, 
	0, 0, 0, 2, 0, 0, 1, 5, 
	0, 0, 6, 5, 5, 0, 0, 2, 
	0, 0, 1, 2, 0, 0, 1, 5, 
	2, 0, 0, 1, 2, 0, 0, 1, 
	0, 0, 0, 2, 0, 0, 1, 2, 
	1, 0, 0, 1, 2, 0, 0, 1, 
	2, 0, 0, 1, 0, 6, 6, 1, 
	1, 6, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 6, 
	1, 1, 6, 1, 1, 1, 1, 1, 
	1, 1, 1, 6, 1, 1, 6, 1, 
	1, 1, 1, 1, 1, 1, 1, 6, 
	1, 1, 6, 6, 6, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 6, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 2, 0, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2
};

static const int16_t _rfc5322_index_offsets[] = {
	0, 0, 2, 5, 8, 12, 17, 21, 
	26, 31, 36, 41, 46, 50, 55, 60, 
	65, 69, 85, 101, 104, 108, 123, 126, 
	130, 135, 140, 145, 149, 154, 159, 164, 
	169, 172, 182, 187, 193, 198, 203, 208, 
	213, 218, 223, 227, 232, 237, 242, 246, 
	253, 256, 260, 267, 270, 274, 276, 291, 
	294, 298, 313, 321, 324, 328, 335, 338, 
	342, 344, 360, 363, 367, 382, 390, 393, 
	397, 404, 407, 411, 413, 428, 431, 435, 
	450, 456, 462, 465, 469, 474, 479, 484, 
	489, 494, 499, 504, 509, 514, 519, 523, 
	539, 555, 558, 562, 577, 580, 584, 592, 
	600, 603, 607, 609, 616, 619, 623, 625, 
	640, 643, 647, 662, 670, 673, 677, 684, 
	687, 691, 693, 709, 712, 716, 731, 739, 
	742, 746, 753, 756, 760, 762, 777, 780, 
	784, 799, 815, 831, 834, 838, 845, 848, 
	852, 854, 861, 864, 868, 870, 885, 892, 
	895, 899, 901, 910, 913, 917, 919, 926, 
	929, 933, 940, 943, 947, 949, 957, 965, 
	968, 972, 974, 981, 984, 988, 990, 997, 
	1000, 1004, 1006, 1010, 1030, 1050, 1055, 1061, 
	1080, 1085, 1091, 1100, 1109, 1114, 1120, 1123, 
	1132, 1140, 1145, 1151, 1154, 1162, 1181, 1186, 
	1192, 1211, 1220, 1225, 1231, 1239, 1244, 1250, 
	1253, 1261, 1281, 1286, 1292, 1312, 1321, 1326, 
	1332, 1340, 1345, 1351, 1354, 1362, 1381, 1386, 
	1392, 1412, 1432, 1452, 1457, 1463, 1471, 1476, 
	1482, 1485, 1493, 1501, 1506, 1512, 1515, 1523, 
	1542, 1550, 1555, 1561, 1564, 1572, 1582, 1587, 
	1593, 1596, 1606, 1614, 1619, 1625, 1633, 1638, 
	1644, 1647, 1655, 1664, 1673, 1678, 1684, 1687, 
	1696, 1704, 1709, 1715, 1718, 1726, 1734, 1739, 
	1745, 1748, 1756, 1762, 1769, 1772, 1776, 1778, 
	1785, 1788, 1792, 1794, 1809, 1816, 1819, 1823, 
	1825, 1834, 1837, 1841, 1843, 1850, 1853, 1857, 
	1864, 1867, 1871, 1873, 1881, 1889, 1892, 1896, 
	1898, 1905, 1908, 1912, 1914, 1922, 1927, 1933, 
	1941, 1946, 1952, 1955, 1963, 1982, 1987, 1993, 
	2012, 2021, 2026, 2032, 2040, 2045, 2051, 2054, 
	2062, 2082, 2087, 2093, 2113, 2122, 2127, 2133, 
	2141, 2146, 2152, 2155, 2163, 2182, 2187, 2193, 
	2213, 2220, 2227, 2232, 2238, 2246, 2251, 2257, 
	2260, 2268, 2276, 2281, 2287, 2290, 2298, 2317, 
	2325, 2330, 2336, 2339, 2347, 2357, 2362, 2368, 
	2371, 2381, 2389, 2394, 2400, 2408, 2413, 2419, 
	2422, 2430, 2439, 2448, 2453, 2459, 2462, 2471, 
	2479, 2484, 2490, 2493, 2501, 2509, 2514, 2520, 
	2523, 2531, 2540, 2546, 2549, 2556, 2560, 2567, 
	2570, 2574, 2576, 2584, 2587, 2591, 2599, 2604, 
	2610, 2618, 2623, 2629, 2632, 2640, 2648, 2653, 
	2659, 2667, 2672, 2678, 2681, 2689, 2698, 2704, 
	2712, 2715, 2724, 2728, 2739, 2747, 2752, 2758, 
	2766, 2771, 2777, 2780, 2788, 2799, 2804, 2810, 
	2821, 2826, 2832, 2844, 2851, 2860, 2865, 2875, 
	2881, 2887, 2897, 2907, 2912, 2918, 2928, 2933, 
	2944, 2952, 2957, 2963, 2966, 2974, 2980, 2991, 
	3002, 3007, 3013, 3024, 3029, 3035, 3046, 3051, 
	3057, 3063, 3073, 3083, 3089, 3098, 3107, 3112, 
	3118, 3126, 3129, 3138, 3142, 3153, 3164, 3169, 
	3175, 3186, 3191, 3197, 3209, 3219, 3224, 3234, 
	3240, 3249, 3255, 3265, 3275, 3280, 3286, 3292, 
	3301, 3310, 3317, 3322, 3330, 3336, 3344, 3349, 
	3355, 3358, 3366, 3375, 3380, 3390, 3396, 3402, 
	3412, 3422, 3427, 3433, 3443, 3448, 3459, 3467, 
	3472, 3478, 3481, 3489, 3495, 3506, 3514, 3519, 
	3525, 3534, 3541, 3550, 3556, 3561, 3567, 3577, 
	3582, 3593, 3599, 3602, 3610, 3616, 3626, 3636, 
	3647, 3652, 3658, 3669, 3674, 3680, 3692, 3702, 
	3708, 3713, 3719, 3725, 3735, 3745, 3750, 3753, 
	3757, 3765, 3773, 3776, 3780, 3782, 3789, 3792, 
	3796, 3798, 3813, 3816, 3820, 3835, 3843, 3846, 
	3850, 3857, 3860, 3864, 3866, 3882, 3885, 3889, 
	3904, 3912, 3915, 3919, 3926, 3929, 3933, 3935, 
	3950, 3953, 3957, 3972, 3988, 4004, 4007, 4011, 
	4018, 4021, 4025, 4027, 4034, 4037, 4041, 4043, 
	4058, 4065, 4068, 4072, 4074, 4083, 4086, 4090, 
	4092, 4099, 4102, 4106, 4113, 4116, 4120, 4122, 
	4130, 4138, 4141, 4145, 4147, 4154, 4157, 4161, 
	4163, 4170, 4173, 4177, 4179, 4183, 4203, 4223, 
	4228, 4234, 4253, 4258, 4264, 4273, 4282, 4287, 
	4293, 4296, 4305, 4313, 4318, 4324, 4327, 4335, 
	4354, 4359, 4365, 4384, 4393, 4398, 4404, 4412, 
	4417, 4423, 4426, 4434, 4454, 4459, 4465, 4485, 
	4494, 4499, 4505, 4513, 4518, 4524, 4527, 4535, 
	4554, 4559, 4565, 4585, 4605, 4625, 4630, 4636, 
	4644, 4649, 4655, 4658, 4666, 4674, 4679, 4685, 
	4688, 4696, 4715, 4723, 4728, 4734, 4737, 4745, 
	4755, 4760, 4766, 4769, 4779, 4787, 4792, 4798, 
	4806, 4811, 4817, 4820, 4828, 4837, 4846, 4851, 
	4857, 4860, 4869, 4877, 4882, 4888, 4891, 4899, 
	4907, 4912, 4918, 4921, 4929, 4935, 4947, 4949, 
	4963, 4977, 4991, 5005, 5019, 5033, 5047, 5061, 
	5075, 5089, 5103, 5117, 5131, 5145, 5159, 5173, 
	5187, 5201, 5215, 5229, 5243, 5257, 5271, 5285, 
	5299, 5313, 5327, 5341, 5355, 5369, 5383, 5397, 
	5411, 5425, 5439, 5453, 5467, 5481, 5495, 5509, 
	5523, 5537, 5551, 5565, 5579, 5593, 5607, 5621, 
	5635, 5649, 5663, 5677, 5691, 5705, 5719, 5733, 
	5747, 5761, 5775, 5789, 5803, 5817, 5831, 5845, 
	5859, 5873, 5887, 5901, 5915, 5929, 5943, 5957, 
	5971, 5985, 5999, 6013, 6027, 6041, 6055, 6069, 
	6083, 6097, 6111, 6125, 6139, 6153, 6167, 6181, 
	6195, 6209, 6223, 6237, 6251, 6265, 6279, 6293, 
	6307, 6321, 6335, 6349, 6363, 6377, 6391, 6405, 
	6419
};

static const int16_t _rfc5322_indicies[] = {
	0, 1, 4, 3, 2, 5, 4, 2, 
	6, 5, 4, 2, 4, 7, 7, 3, 
	2, 8, 4, 3, 2, 4, 9, 9, 
	3, 2, 4, 10, 10, 3, 2, 4, 
	11, 11, 3, 2, 4, 12, 12, 3, 
	2, 4, 13, 13, 3, 2, 14, 4, 
	3, 2, 4, 15, 15, 3, 2, 4, 
	16, 16, 3, 2, 17, 17, 18, 3, 
	2, 17, 17, 19, 2, 20, 21, 22, 
	20, 24, 25, 23, 26, 23, 23, 23, 
	23, 23, 23, 23, 2, 27, 28, 29, 
	27, 24, 30, 23, 31, 23, 23, 23, 
	23, 23, 23, 23, 2, 27, 27, 2, 
	27, 28, 27, 2, 32, 33, 34, 32, 
	24, 35, 26, 23, 23, 23, 23, 23, 
	23, 23, 2, 36, 36, 2, 36, 37, 
	36, 2, 4, 38, 38, 3, 2, 4, 
	39, 39, 3, 2, 4, 40, 40, 3, 
	2, 41, 4, 3, 2, 4, 42, 42, 
	3, 2, 4, 43, 43, 3, 2, 4, 
	44, 44, 3, 2, 4, 45, 45, 3, 
	2, 46, 3, 2, 46, 47, 48, 46, 
	49, 50, 51, 51, 4, 2, 46, 5, 
	46, 4, 2, 46, 52, 5, 46, 4, 
	2, 4, 53, 53, 3, 2, 4, 54, 
	54, 3, 2, 4, 55, 55, 3, 2, 
	4, 56, 56, 3, 2, 4, 57, 57, 
	3, 2, 4, 58, 58, 3, 2, 59, 
	4, 3, 2, 4, 60, 60, 3, 2, 
	4, 61, 61, 3, 2, 62, 62, 63, 
	3, 2, 62, 62, 64, 2, 65, 66, 
	67, 65, 68, 69, 2, 65, 65, 2, 
	65, 66, 65, 2, 70, 71, 65, 72, 
	68, 68, 2, 68, 68, 2, 68, 70, 
	68, 2, 73, 2, 69, 74, 75, 69, 
	77, 78, 76, 76, 76, 76, 76, 76, 
	76, 76, 2, 69, 69, 2, 69, 74, 
	69, 2, 79, 80, 81, 79, 76, 82, 
	83, 76, 84, 76, 76, 76, 76, 76, 
	2, 79, 80, 81, 79, 82, 83, 84, 
	2, 79, 79, 2, 79, 80, 79, 2, 
	85, 86, 79, 87, 82, 82, 2, 82, 
	82, 2, 82, 85, 82, 2, 88, 2, 
	89, 90, 91, 89, 92, 93, 92, 92, 
	92, 94, 92, 92, 92, 92, 92, 2, 
	89, 89, 2, 89, 90, 89, 2, 95, 
	96, 97, 95, 92, 98, 99, 100, 92, 
	92, 92, 92, 92, 92, 2, 95, 96, 
	97, 95, 98, 101, 100, 2, 95, 95, 
	2, 95, 96, 95, 2, 102, 103, 95, 
	104, 98, 98, 2, 98, 98, 2, 98, 
	102, 98, 2, 105, 2, 101, 106, 107, 
	101, 108, 109, 108, 108, 108, 108, 108, 
	108, 108, 108, 2, 101, 101, 2, 101, 
	106, 101, 2, 95, 96, 97, 95, 108, 
	98, 101, 100, 108, 108, 108, 108, 108, 
	108, 2, 110, 111, 112, 110, 113, 2, 
	114, 115, 116, 114, 117, 2, 114, 114, 
	2, 114, 118, 114, 2, 4, 119, 119, 
	3, 2, 4, 120, 120, 3, 2, 4, 
	121, 121, 3, 2, 4, 122, 122, 3, 
	2, 4, 123, 123, 3, 2, 4, 124, 
	124, 3, 2, 4, 125, 125, 3, 2, 
	4, 126, 126, 3, 2, 4, 127, 127, 
	3, 2, 128, 128, 129, 3, 2, 128, 
	128, 130, 2, 131, 132, 133, 131, 135, 
	136, 134, 137, 134, 134, 134, 134, 134, 
	134, 134, 2, 138, 139, 140, 138, 135, 
	141, 134, 142, 134, 134, 134, 134, 134, 
	134, 134, 2, 138, 138, 2, 138, 139, 
	138, 2, 143, 144, 145, 143, 135, 146, 
	137, 134, 134, 134, 134, 134, 134, 134, 
	2, 147, 147, 2, 147, 148, 147, 2, 
	150, 151, 152, 150, 153, 149, 149, 2, 
	150, 151, 152, 150, 147, 153, 149, 2, 
	150, 150, 2, 150, 151, 150, 2, 154, 
	2, 156, 157, 147, 158, 155, 155, 2, 
	155, 155, 2, 155, 156, 155, 2, 159, 
	2, 142, 160, 161, 142, 163, 164, 162, 
	162, 162, 162, 162, 162, 162, 162, 2, 
	142, 142, 2, 142, 160, 142, 2, 165, 
	166, 167, 165, 162, 168, 169, 162, 170, 
	162, 162, 162, 162, 162, 2, 165, 166, 
	167, 165, 168, 169, 170, 2, 165, 165, 
	2, 165, 166, 165, 2, 171, 172, 165, 
	173, 168, 168, 2, 168, 168, 2, 168, 
	171, 168, 2, 2, 174, 175, 176, 177, 
	175, 178, 179, 178, 178, 178, 180, 178, 
	178, 178, 178, 178, 2, 175, 175, 2, 
	175, 176, 175, 2, 181, 182, 183, 181, 
	178, 184, 185, 186, 178, 178, 178, 178, 
	178, 178, 2, 181, 182, 183, 181, 184, 
	187, 186, 2, 181, 181, 2, 181, 182, 
	181, 2, 188, 189, 181, 190, 184, 184, 
	2, 184, 184, 2, 184, 188, 184, 2, 
	191, 2, 187, 192, 193, 187, 194, 195, 
	194, 194, 194, 194, 194, 194, 194, 194, 
	2, 187, 187, 2, 187, 192, 187, 2, 
	181, 182, 183, 181, 194, 184, 187, 186, 
	194, 194, 194, 194, 194, 194, 2, 196, 
	197, 198, 196, 200, 201, 199, 202, 199, 
	199, 199, 199, 199, 199, 199, 2, 203, 
	204, 205, 203, 135, 206, 134, 137, 134, 
	134, 134, 134, 134, 134, 134, 2, 207, 
	207, 2, 207, 208, 207, 2, 210, 211, 
	207, 212, 209, 209, 2, 209, 209, 2, 
	209, 210, 209, 2, 213, 2, 214, 215, 
	187, 216, 195, 195, 2, 195, 195, 2, 
	195, 214, 195, 2, 2, 217, 187, 192, 
	193, 187, 178, 195, 178, 178, 178, 178, 
	178, 178, 178, 178, 2, 218, 219, 175, 
	220, 179, 179, 2, 179, 179, 2, 179, 
	218, 179, 2, 2, 221, 222, 223, 224, 
	222, 225, 226, 180, 180, 2, 222, 222, 
	2, 222, 223, 222, 2, 227, 2, 228, 
	229, 230, 228, 231, 186, 2, 228, 228, 
	2, 228, 229, 228, 2, 232, 233, 228, 
	234, 231, 231, 2, 231, 231, 2, 231, 
	232, 231, 2, 235, 2, 237, 238, 239, 
	237, 240, 236, 236, 2, 237, 238, 239, 
	237, 165, 240, 236, 2, 237, 237, 2, 
	237, 238, 237, 2, 241, 2, 242, 243, 
	142, 244, 164, 164, 2, 164, 164, 2, 
	164, 242, 164, 2, 245, 2, 246, 247, 
	138, 248, 141, 141, 2, 141, 141, 2, 
	141, 246, 141, 2, 2, 249, 138, 250, 
	138, 2, 251, 252, 253, 251, 255, 256, 
	4, 4, 4, 257, 254, 254, 4, 4, 
	254, 4, 254, 4, 254, 2, 258, 259, 
	260, 258, 255, 261, 4, 4, 4, 262, 
	254, 254, 4, 4, 254, 4, 254, 4, 
	254, 2, 258, 5, 258, 4, 2, 258, 
	263, 5, 258, 4, 2, 264, 265, 266, 
	264, 255, 267, 4, 4, 257, 254, 254, 
	4, 4, 254, 4, 254, 4, 254, 2, 
	268, 5, 268, 4, 2, 268, 269, 5, 
	268, 4, 2, 4, 271, 272, 273, 271, 
	4, 274, 270, 2, 4, 271, 272, 273, 
	271, 268, 274, 270, 2, 271, 5, 271, 
	4, 2, 271, 275, 5, 271, 4, 2, 
	277, 276, 2, 4, 271, 275, 273, 271, 
	268, 274, 270, 2, 4, 279, 280, 4, 
	268, 281, 278, 2, 278, 5, 278, 4, 
	2, 278, 282, 5, 278, 4, 2, 284, 
	283, 2, 4, 282, 280, 4, 268, 281, 
	278, 2, 262, 285, 286, 262, 288, 289, 
	4, 4, 4, 287, 287, 4, 4, 287, 
	4, 287, 4, 287, 2, 262, 5, 262, 
	4, 2, 262, 290, 5, 262, 4, 2, 
	291, 292, 293, 291, 287, 294, 4, 4, 
	295, 287, 296, 4, 4, 287, 4, 287, 
	4, 287, 2, 291, 292, 293, 291, 294, 
	295, 296, 4, 2, 291, 5, 291, 4, 
	2, 291, 297, 5, 291, 4, 2, 4, 
	298, 299, 4, 291, 300, 294, 2, 294, 
	5, 294, 4, 2, 294, 301, 5, 294, 
	4, 2, 303, 302, 2, 4, 301, 299, 
	4, 291, 300, 294, 2, 304, 305, 306, 
	304, 307, 308, 4, 4, 4, 307, 307, 
	309, 4, 4, 307, 4, 307, 4, 307, 
	2, 304, 5, 304, 4, 2, 304, 310, 
	5, 304, 4, 2, 311, 312, 313, 311, 
	307, 314, 4, 4, 315, 307, 316, 307, 
	4, 4, 307, 4, 307, 4, 307, 2, 
	311, 312, 313, 311, 314, 317, 316, 4, 
	2, 311, 5, 311, 4, 2, 311, 318, 
	5, 311, 4, 2, 4, 319, 320, 4, 
	311, 321, 314, 2, 314, 5, 314, 4, 
	2, 314, 322, 5, 314, 4, 2, 324, 
	323, 2, 4, 322, 320, 4, 311, 321, 
	314, 2, 317, 325, 326, 317, 327, 328, 
	4, 4, 4, 327, 327, 4, 4, 327, 
	4, 327, 4, 327, 2, 317, 5, 317, 
	4, 2, 317, 329, 5, 317, 4, 2, 
	311, 312, 313, 311, 327, 314, 4, 4, 
	317, 327, 316, 327, 4, 4, 327, 4, 
	327, 4, 327, 2, 330, 331, 332, 330, 
	334, 335, 4, 4, 4, 336, 333, 333, 
	4, 4, 333, 4, 333, 4, 333, 2, 
	337, 338, 339, 337, 255, 340, 4, 4, 
	4, 257, 254, 254, 4, 4, 254, 4, 
	254, 4, 254, 2, 341, 5, 341, 4, 
	2, 341, 342, 5, 341, 4, 2, 4, 
	344, 345, 4, 341, 346, 343, 2, 343, 
	5, 343, 4, 2, 343, 347, 5, 343, 
	4, 2, 349, 348, 2, 4, 347, 345, 
	4, 341, 346, 343, 2, 4, 350, 351, 
	4, 317, 352, 328, 2, 328, 5, 328, 
	4, 2, 328, 353, 5, 328, 4, 2, 
	355, 354, 2, 4, 353, 351, 4, 317, 
	352, 328, 2, 317, 325, 326, 317, 307, 
	328, 4, 4, 4, 307, 307, 4, 4, 
	307, 4, 307, 4, 307, 2, 4, 356, 
	357, 4, 304, 358, 308, 2, 308, 5, 
	308, 4, 2, 308, 359, 5, 308, 4, 
	2, 361, 360, 2, 4, 359, 357, 4, 
	304, 358, 308, 2, 4, 362, 363, 364, 
	362, 4, 365, 366, 309, 2, 362, 5, 
	362, 4, 2, 362, 367, 5, 362, 4, 
	2, 369, 368, 2, 4, 362, 367, 364, 
	362, 4, 365, 366, 309, 2, 370, 371, 
	372, 370, 373, 316, 4, 2, 370, 5, 
	370, 4, 2, 370, 374, 5, 370, 4, 
	2, 4, 375, 376, 4, 370, 377, 373, 
	2, 373, 5, 373, 4, 2, 373, 378, 
	5, 373, 4, 2, 380, 379, 2, 4, 
	378, 376, 4, 370, 377, 373, 2, 4, 
	382, 383, 384, 382, 4, 385, 381, 2, 
	4, 382, 383, 384, 382, 291, 385, 381, 
	2, 382, 5, 382, 4, 2, 382, 386, 
	5, 382, 4, 2, 388, 387, 2, 4, 
	382, 386, 384, 382, 291, 385, 381, 2, 
	4, 389, 390, 4, 262, 391, 289, 2, 
	289, 5, 289, 4, 2, 289, 392, 5, 
	289, 4, 2, 394, 393, 2, 4, 392, 
	390, 4, 262, 391, 289, 2, 4, 395, 
	396, 4, 258, 397, 261, 2, 261, 5, 
	261, 4, 2, 261, 398, 5, 261, 4, 
	2, 400, 399, 2, 4, 398, 396, 4, 
	258, 397, 261, 2, 258, 401, 5, 258, 
	4, 2, 402, 403, 114, 404, 117, 117, 
	2, 117, 117, 2, 117, 402, 117, 2, 
	405, 2, 406, 407, 101, 408, 109, 109, 
	2, 109, 109, 2, 109, 406, 109, 2, 
	409, 2, 101, 106, 107, 101, 92, 109, 
	92, 92, 92, 92, 92, 92, 92, 92, 
	2, 410, 411, 89, 412, 93, 93, 2, 
	93, 93, 2, 93, 410, 93, 2, 413, 
	2, 414, 415, 416, 414, 417, 418, 94, 
	94, 2, 414, 414, 2, 414, 415, 414, 
	2, 419, 2, 420, 421, 422, 420, 423, 
	100, 2, 420, 420, 2, 420, 421, 420, 
	2, 424, 425, 420, 426, 423, 423, 2, 
	423, 423, 2, 423, 424, 423, 2, 2, 
	427, 429, 430, 431, 429, 432, 428, 428, 
	2, 429, 430, 431, 429, 79, 432, 428, 
	2, 429, 429, 2, 429, 430, 429, 2, 
	433, 2, 434, 435, 69, 436, 78, 78, 
	2, 78, 78, 2, 78, 434, 78, 2, 
	437, 2, 438, 439, 440, 438, 441, 442, 
	4, 2, 438, 5, 438, 4, 2, 438, 
	443, 5, 438, 4, 2, 4, 444, 445, 
	4, 438, 446, 441, 2, 441, 5, 441, 
	4, 2, 441, 447, 5, 441, 4, 2, 
	449, 448, 2, 4, 447, 445, 4, 438, 
	446, 441, 2, 442, 450, 451, 442, 453, 
	454, 4, 4, 4, 452, 452, 4, 4, 
	452, 4, 452, 4, 452, 2, 442, 5, 
	442, 4, 2, 442, 455, 5, 442, 4, 
	2, 456, 457, 458, 456, 452, 459, 4, 
	4, 460, 452, 461, 4, 4, 452, 4, 
	452, 4, 452, 2, 456, 457, 458, 456, 
	459, 460, 461, 4, 2, 456, 5, 456, 
	4, 2, 456, 462, 5, 456, 4, 2, 
	4, 463, 464, 4, 456, 465, 459, 2, 
	459, 5, 459, 4, 2, 459, 466, 5, 
	459, 4, 2, 468, 467, 2, 4, 466, 
	464, 4, 456, 465, 459, 2, 469, 470, 
	471, 469, 472, 473, 4, 4, 4, 472, 
	472, 474, 4, 4, 472, 4, 472, 4, 
	472, 2, 469, 5, 469, 4, 2, 469, 
	475, 5, 469, 4, 2, 476, 477, 478, 
	476, 472, 479, 4, 4, 480, 472, 481, 
	472, 4, 4, 472, 4, 472, 4, 472, 
	2, 476, 477, 478, 476, 479, 482, 481, 
	4, 2, 476, 5, 476, 4, 2, 476, 
	483, 5, 476, 4, 2, 4, 484, 485, 
	4, 476, 486, 479, 2, 479, 5, 479, 
	4, 2, 479, 487, 5, 479, 4, 2, 
	489, 488, 2, 4, 487, 485, 4, 476, 
	486, 479, 2, 482, 490, 491, 482, 492, 
	493, 4, 4, 4, 492, 492, 4, 4, 
	492, 4, 492, 4, 492, 2, 482, 5, 
	482, 4, 2, 482, 494, 5, 482, 4, 
	2, 476, 477, 478, 476, 492, 479, 4, 
	4, 482, 492, 481, 492, 4, 4, 492, 
	4, 492, 4, 492, 2, 495, 496, 497, 
	495, 498, 4, 2, 499, 500, 501, 499, 
	502, 4, 2, 499, 5, 499, 4, 2, 
	499, 503, 5, 499, 4, 2, 4, 504, 
	505, 4, 499, 506, 502, 2, 502, 5, 
	502, 4, 2, 502, 507, 5, 502, 4, 
	2, 509, 508, 2, 4, 507, 505, 4, 
	499, 506, 502, 2, 4, 510, 511, 4, 
	482, 512, 493, 2, 493, 5, 493, 4, 
	2, 493, 513, 5, 493, 4, 2, 515, 
	514, 2, 4, 513, 511, 4, 482, 512, 
	493, 2, 482, 490, 491, 482, 472, 493, 
	4, 4, 4, 472, 472, 4, 4, 472, 
	4, 472, 4, 472, 2, 4, 516, 517, 
	4, 469, 518, 473, 2, 473, 5, 473, 
	4, 2, 473, 519, 5, 473, 4, 2, 
	521, 520, 2, 4, 519, 517, 4, 469, 
	518, 473, 2, 4, 522, 523, 524, 522, 
	4, 525, 526, 474, 2, 522, 5, 522, 
	4, 2, 522, 527, 5, 522, 4, 2, 
	529, 528, 2, 4, 522, 527, 524, 522, 
	4, 525, 526, 474, 2, 530, 531, 532, 
	530, 533, 481, 4, 2, 530, 5, 530, 
	4, 2, 530, 534, 5, 530, 4, 2, 
	4, 535, 536, 4, 530, 537, 533, 2, 
	533, 5, 533, 4, 2, 533, 538, 5, 
	533, 4, 2, 540, 539, 2, 4, 538, 
	536, 4, 530, 537, 533, 2, 4, 542, 
	543, 544, 542, 4, 545, 541, 2, 4, 
	542, 543, 544, 542, 456, 545, 541, 2, 
	542, 5, 542, 4, 2, 542, 546, 5, 
	542, 4, 2, 548, 547, 2, 4, 542, 
	546, 544, 542, 456, 545, 541, 2, 4, 
	549, 550, 4, 442, 551, 454, 2, 454, 
	5, 454, 4, 2, 454, 552, 5, 454, 
	4, 2, 554, 553, 2, 4, 552, 550, 
	4, 442, 551, 454, 2, 4, 555, 556, 
	4, 46, 557, 49, 2, 49, 5, 49, 
	4, 2, 49, 558, 5, 49, 4, 2, 
	560, 559, 2, 4, 558, 556, 4, 46, 
	557, 49, 2, 563, 564, 565, 563, 566, 
	4, 567, 562, 561, 568, 569, 570, 2, 
	567, 561, 571, 571, 2, 571, 568, 569, 
	571, 572, 567, 2, 571, 568, 571, 2, 
	573, 574, 571, 575, 572, 572, 2, 572, 
	572, 2, 572, 573, 572, 2, 576, 2, 
	578, 579, 580, 578, 581, 582, 577, 2, 
	584, 583, 2, 585, 584, 583, 2, 586, 
	587, 588, 586, 589, 590, 583, 2, 586, 
	584, 586, 583, 2, 586, 591, 584, 586, 
	583, 2, 583, 592, 593, 583, 586, 594, 
	589, 2, 589, 584, 589, 583, 2, 589, 
	595, 584, 589, 583, 2, 597, 596, 2, 
	583, 595, 593, 583, 586, 594, 589, 2, 
	590, 598, 599, 590, 600, 601, 583, 2, 
	590, 584, 590, 583, 2, 590, 602, 584, 
	590, 583, 2, 583, 603, 604, 583, 590, 
	605, 600, 2, 600, 584, 600, 583, 2, 
	600, 606, 584, 600, 583, 2, 608, 607, 
	2, 583, 606, 604, 583, 590, 605, 600, 
	2, 611, 612, 613, 611, 614, 583, 567, 
	610, 609, 568, 569, 615, 2, 567, 609, 
	616, 617, 572, 618, 619, 615, 615, 609, 
	620, 620, 2, 620, 616, 617, 620, 571, 
	618, 575, 572, 2, 620, 616, 620, 2, 
	577, 622, 623, 624, 622, 581, 625, 626, 
	627, 621, 2, 583, 629, 630, 583, 631, 
	632, 628, 2, 628, 584, 628, 583, 2, 
	628, 633, 584, 628, 583, 2, 631, 634, 
	635, 631, 628, 567, 583, 2, 631, 584, 
	631, 583, 2, 631, 636, 584, 631, 583, 
	2, 638, 637, 2, 583, 633, 630, 583, 
	631, 632, 628, 2, 583, 639, 640, 641, 
	639, 589, 631, 642, 632, 628, 2, 639, 
	584, 639, 583, 2, 639, 643, 584, 639, 
	583, 2, 583, 642, 644, 645, 642, 600, 
	631, 646, 632, 628, 2, 642, 584, 642, 
	583, 2, 642, 647, 584, 642, 583, 2, 
	610, 649, 650, 651, 649, 614, 610, 628, 
	618, 652, 648, 609, 634, 635, 648, 583, 
	567, 610, 609, 610, 653, 654, 610, 628, 
	618, 652, 648, 609, 655, 584, 655, 583, 
	2, 583, 655, 653, 654, 655, 631, 618, 
	632, 628, 2, 655, 656, 584, 655, 583, 
	2, 658, 659, 637, 660, 657, 609, 583, 
	655, 629, 630, 655, 583, 631, 632, 628, 
	2, 583, 655, 656, 630, 655, 583, 631, 
	632, 628, 2, 661, 584, 661, 583, 2, 
	661, 662, 584, 661, 583, 2, 610, 663, 
	664, 648, 611, 665, 666, 667, 614, 609, 
	668, 584, 668, 583, 2, 583, 668, 663, 
	664, 668, 628, 669, 666, 670, 665, 2, 
	583, 671, 672, 583, 669, 670, 665, 2, 
	665, 584, 665, 583, 2, 665, 673, 584, 
	665, 583, 2, 675, 674, 2, 583, 673, 
	672, 583, 669, 670, 665, 2, 668, 676, 
	584, 668, 583, 2, 577, 678, 679, 680, 
	678, 581, 681, 682, 683, 677, 2, 583, 
	684, 685, 686, 684, 589, 669, 687, 670, 
	665, 2, 684, 584, 684, 583, 2, 684, 
	688, 584, 684, 583, 2, 583, 687, 689, 
	690, 687, 600, 669, 691, 670, 665, 2, 
	687, 584, 687, 583, 2, 687, 692, 584, 
	687, 583, 2, 610, 693, 694, 695, 693, 
	611, 665, 666, 667, 614, 609, 696, 584, 
	696, 583, 2, 696, 697, 584, 696, 583, 
	2, 699, 700, 674, 701, 698, 609, 583, 
	668, 671, 672, 668, 583, 669, 670, 665, 
	2, 583, 668, 676, 672, 668, 583, 669, 
	670, 665, 2, 703, 704, 576, 660, 702, 
	609, 620, 573, 574, 620, 571, 575, 572, 
	572, 2, 620, 616, 574, 620, 571, 575, 
	572, 572, 2, 669, 584, 669, 583, 2, 
	669, 705, 584, 669, 583, 2, 706, 707, 
	572, 708, 709, 570, 570, 561, 710, 710, 
	2, 710, 706, 707, 710, 571, 708, 575, 
	572, 2, 710, 706, 710, 2, 577, 711, 
	712, 713, 711, 581, 625, 714, 627, 621, 
	2, 583, 715, 716, 717, 715, 589, 631, 
	718, 632, 628, 2, 715, 584, 715, 583, 
	2, 715, 719, 584, 715, 583, 2, 583, 
	718, 720, 721, 718, 600, 631, 722, 632, 
	628, 2, 718, 584, 718, 583, 2, 718, 
	723, 584, 718, 583, 2, 610, 725, 726, 
	727, 725, 614, 728, 628, 708, 729, 724, 
	609, 610, 730, 731, 648, 728, 628, 708, 
	729, 724, 609, 732, 584, 732, 583, 2, 
	583, 732, 730, 731, 732, 631, 708, 632, 
	628, 2, 732, 733, 584, 732, 583, 2, 
	728, 634, 635, 728, 724, 583, 567, 610, 
	609, 735, 736, 637, 737, 734, 609, 583, 
	732, 629, 630, 732, 583, 631, 632, 628, 
	2, 583, 732, 733, 630, 732, 583, 631, 
	632, 628, 2, 738, 584, 738, 583, 2, 
	738, 739, 584, 738, 583, 2, 741, 742, 
	576, 737, 740, 561, 710, 573, 574, 710, 
	571, 575, 572, 572, 2, 710, 706, 574, 
	710, 571, 575, 572, 572, 2, 743, 744, 
	745, 4, 567, 562, 561, 746, 5, 746, 
	4, 2, 746, 743, 744, 746, 747, 567, 
	4, 2, 746, 748, 5, 746, 4, 2, 
	4, 749, 750, 4, 746, 751, 747, 2, 
	747, 5, 747, 4, 2, 747, 752, 5, 
	747, 4, 2, 754, 753, 2, 4, 752, 
	750, 4, 746, 751, 747, 2, 562, 755, 
	756, 562, 747, 708, 757, 745, 561, 758, 
	5, 758, 4, 2, 4, 758, 755, 756, 
	758, 746, 708, 751, 747, 2, 758, 759, 
	5, 758, 4, 2, 761, 762, 753, 737, 
	760, 561, 4, 758, 749, 750, 758, 4, 
	746, 751, 747, 2, 4, 758, 759, 750, 
	758, 4, 746, 751, 747, 2, 763, 5, 
	763, 4, 2, 763, 764, 5, 763, 4, 
	2, 562, 765, 766, 745, 563, 767, 768, 
	769, 566, 561, 770, 5, 770, 4, 2, 
	4, 770, 765, 766, 770, 747, 763, 768, 
	771, 767, 2, 4, 772, 773, 4, 763, 
	771, 767, 2, 767, 5, 767, 4, 2, 
	767, 774, 5, 767, 4, 2, 776, 775, 
	2, 4, 774, 773, 4, 763, 771, 767, 
	2, 770, 777, 5, 770, 4, 2, 577, 
	779, 780, 781, 779, 581, 782, 783, 784, 
	778, 2, 583, 786, 787, 583, 788, 789, 
	785, 2, 785, 584, 785, 583, 2, 785, 
	790, 584, 785, 583, 2, 792, 793, 794, 
	792, 795, 583, 567, 791, 561, 634, 635, 
	796, 583, 567, 791, 561, 791, 730, 731, 
	791, 628, 708, 797, 796, 561, 735, 736, 
	637, 737, 798, 561, 788, 584, 788, 583, 
	2, 788, 799, 584, 788, 583, 2, 791, 
	800, 801, 796, 792, 785, 768, 802, 795, 
	561, 803, 584, 803, 583, 2, 583, 803, 
	800, 801, 803, 628, 788, 768, 789, 785, 
	2, 803, 804, 584, 803, 583, 2, 806, 
	805, 2, 583, 790, 787, 583, 788, 789, 
	785, 2, 808, 809, 805, 810, 807, 561, 
	583, 803, 786, 787, 803, 583, 788, 789, 
	785, 2, 583, 803, 804, 787, 803, 583, 
	788, 789, 785, 2, 583, 811, 812, 813, 
	811, 589, 788, 814, 789, 785, 2, 811, 
	584, 811, 583, 2, 811, 815, 584, 811, 
	583, 2, 583, 814, 816, 817, 814, 600, 
	788, 818, 789, 785, 2, 814, 584, 814, 
	583, 2, 814, 819, 584, 814, 583, 2, 
	610, 821, 822, 823, 821, 614, 792, 785, 
	768, 824, 820, 609, 610, 800, 801, 648, 
	792, 785, 768, 824, 820, 609, 808, 809, 
	805, 810, 825, 609, 826, 584, 826, 583, 
	2, 826, 827, 584, 826, 583, 2, 829, 
	830, 775, 810, 828, 561, 4, 770, 772, 
	773, 770, 4, 763, 771, 767, 2, 4, 
	770, 777, 773, 770, 4, 763, 771, 767, 
	2, 5, 831, 831, 4, 2, 832, 831, 
	2, 833, 832, 831, 2, 835, 836, 837, 
	835, 838, 834, 834, 2, 835, 836, 837, 
	835, 36, 838, 834, 2, 835, 835, 2, 
	835, 836, 835, 2, 839, 2, 841, 842, 
	36, 843, 840, 840, 2, 840, 840, 2, 
	840, 841, 840, 2, 844, 2, 31, 845, 
	846, 31, 848, 849, 847, 847, 847, 847, 
	847, 847, 847, 847, 2, 31, 31, 2, 
	31, 845, 31, 2, 850, 851, 852, 850, 
	847, 853, 854, 847, 855, 847, 847, 847, 
	847, 847, 2, 850, 851, 852, 850, 853, 
	854, 855, 2, 850, 850, 2, 850, 851, 
	850, 2, 856, 857, 850, 858, 853, 853, 
	2, 853, 853, 2, 853, 856, 853, 2, 
	859, 2, 860, 861, 862, 860, 863, 864, 
	863, 863, 863, 865, 863, 863, 863, 863, 
	863, 2, 860, 860, 2, 860, 861, 860, 
	2, 866, 867, 868, 866, 863, 869, 870, 
	871, 863, 863, 863, 863, 863, 863, 2, 
	866, 867, 868, 866, 869, 872, 871, 2, 
	866, 866, 2, 866, 867, 866, 2, 873, 
	874, 866, 875, 869, 869, 2, 869, 869, 
	2, 869, 873, 869, 2, 876, 2, 872, 
	877, 878, 872, 879, 880, 879, 879, 879, 
	879, 879, 879, 879, 879, 2, 872, 872, 
	2, 872, 877, 872, 2, 866, 867, 868, 
	866, 879, 869, 872, 871, 879, 879, 879, 
	879, 879, 879, 2, 881, 882, 883, 881, 
	885, 886, 884, 887, 884, 884, 884, 884, 
	884, 884, 884, 2, 888, 889, 890, 888, 
	24, 891, 23, 26, 23, 23, 23, 23, 
	23, 23, 23, 2, 892, 892, 2, 892, 
	893, 892, 2, 895, 896, 892, 897, 894, 
	894, 2, 894, 894, 2, 894, 895, 894, 
	2, 898, 2, 899, 900, 872, 901, 880, 
	880, 2, 880, 880, 2, 880, 899, 880, 
	2, 902, 2, 872, 877, 878, 872, 863, 
	880, 863, 863, 863, 863, 863, 863, 863, 
	863, 2, 903, 904, 860, 905, 864, 864, 
	2, 864, 864, 2, 864, 903, 864, 2, 
	2, 906, 907, 908, 909, 907, 910, 911, 
	865, 865, 2, 907, 907, 2, 907, 908, 
	907, 2, 912, 2, 913, 914, 915, 913, 
	916, 871, 2, 913, 913, 2, 913, 914, 
	913, 2, 917, 918, 913, 919, 916, 916, 
	2, 916, 916, 2, 916, 917, 916, 2, 
	2, 920, 922, 923, 924, 922, 925, 921, 
	921, 2, 922, 923, 924, 922, 850, 925, 
	921, 2, 922, 922, 2, 922, 923, 922, 
	2, 926, 2, 927, 928, 31, 929, 849, 
	849, 2, 849, 849, 2, 849, 927, 849, 
	2, 930, 2, 931, 932, 27, 933, 30, 
	30, 2, 30, 30, 2, 30, 931, 30, 
	2, 934, 2, 27, 935, 27, 2, 936, 
	937, 938, 936, 940, 941, 4, 4, 4, 
	942, 939, 939, 4, 4, 939, 4, 939, 
	4, 939, 2, 943, 944, 945, 943, 940, 
	946, 4, 4, 4, 947, 939, 939, 4, 
	4, 939, 4, 939, 4, 939, 2, 943, 
	5, 943, 4, 2, 943, 948, 5, 943, 
	4, 2, 949, 950, 951, 949, 940, 952, 
	4, 4, 942, 939, 939, 4, 4, 939, 
	4, 939, 4, 939, 2, 953, 5, 953, 
	4, 2, 953, 954, 5, 953, 4, 2, 
	4, 956, 957, 958, 956, 4, 959, 955, 
	2, 4, 956, 957, 958, 956, 953, 959, 
	955, 2, 956, 5, 956, 4, 2, 956, 
	960, 5, 956, 4, 2, 962, 961, 2, 
	4, 956, 960, 958, 956, 953, 959, 955, 
	2, 4, 964, 965, 4, 953, 966, 963, 
	2, 963, 5, 963, 4, 2, 963, 967, 
	5, 963, 4, 2, 969, 968, 2, 4, 
	967, 965, 4, 953, 966, 963, 2, 947, 
	970, 971, 947, 973, 974, 4, 4, 4, 
	972, 972, 4, 4, 972, 4, 972, 4, 
	972, 2, 947, 5, 947, 4, 2, 947, 
	975, 5, 947, 4, 2, 976, 977, 978, 
	976, 972, 979, 4, 4, 980, 972, 981, 
	4, 4, 972, 4, 972, 4, 972, 2, 
	976, 977, 978, 976, 979, 980, 981, 4, 
	2, 976, 5, 976, 4, 2, 976, 982, 
	5, 976, 4, 2, 4, 983, 984, 4, 
	976, 985, 979, 2, 979, 5, 979, 4, 
	2, 979, 986, 5, 979, 4, 2, 988, 
	987, 2, 4, 986, 984, 4, 976, 985, 
	979, 2, 989, 990, 991, 989, 992, 993, 
	4, 4, 4, 992, 992, 994, 4, 4, 
	992, 4, 992, 4, 992, 2, 989, 5, 
	989, 4, 2, 989, 995, 5, 989, 4, 
	2, 996, 997, 998, 996, 992, 999, 4, 
	4, 1000, 992, 1001, 992, 4, 4, 992, 
	4, 992, 4, 992, 2, 996, 997, 998, 
	996, 999, 1002, 1001, 4, 2, 996, 5, 
	996, 4, 2, 996, 1003, 5, 996, 4, 
	2, 4, 1004, 1005, 4, 996, 1006, 999, 
	2, 999, 5, 999, 4, 2, 999, 1007, 
	5, 999, 4, 2, 1009, 1008, 2, 4, 
	1007, 1005, 4, 996, 1006, 999, 2, 1002, 
	1010, 1011, 1002, 1012, 1013, 4, 4, 4, 
	1012, 1012, 4, 4, 1012, 4, 1012, 4, 
	1012, 2, 1002, 5, 1002, 4, 2, 1002, 
	1014, 5, 1002, 4, 2, 996, 997, 998, 
	996, 1012, 999, 4, 4, 1002, 1012, 1001, 
	1012, 4, 4, 1012, 4, 1012, 4, 1012, 
	2, 1015, 1016, 1017, 1015, 1019, 1020, 4, 
	4, 4, 1021, 1018, 1018, 4, 4, 1018, 
	4, 1018, 4, 1018, 2, 1022, 1023, 1024, 
	1022, 940, 1025, 4, 4, 4, 942, 939, 
	939, 4, 4, 939, 4, 939, 4, 939, 
	2, 1026, 5, 1026, 4, 2, 1026, 1027, 
	5, 1026, 4, 2, 4, 1029, 1030, 4, 
	1026, 1031, 1028, 2, 1028, 5, 1028, 4, 
	2, 1028, 1032, 5, 1028, 4, 2, 1034, 
	1033, 2, 4, 1032, 1030, 4, 1026, 1031, 
	1028, 2, 4, 1035, 1036, 4, 1002, 1037, 
	1013, 2, 1013, 5, 1013, 4, 2, 1013, 
	1038, 5, 1013, 4, 2, 1040, 1039, 2, 
	4, 1038, 1036, 4, 1002, 1037, 1013, 2, 
	1002, 1010, 1011, 1002, 992, 1013, 4, 4, 
	4, 992, 992, 4, 4, 992, 4, 992, 
	4, 992, 2, 4, 1041, 1042, 4, 989, 
	1043, 993, 2, 993, 5, 993, 4, 2, 
	993, 1044, 5, 993, 4, 2, 1046, 1045, 
	2, 4, 1044, 1042, 4, 989, 1043, 993, 
	2, 4, 1047, 1048, 1049, 1047, 4, 1050, 
	1051, 994, 2, 1047, 5, 1047, 4, 2, 
	1047, 1052, 5, 1047, 4, 2, 1054, 1053, 
	2, 4, 1047, 1052, 1049, 1047, 4, 1050, 
	1051, 994, 2, 1055, 1056, 1057, 1055, 1058, 
	1001, 4, 2, 1055, 5, 1055, 4, 2, 
	1055, 1059, 5, 1055, 4, 2, 4, 1060, 
	1061, 4, 1055, 1062, 1058, 2, 1058, 5, 
	1058, 4, 2, 1058, 1063, 5, 1058, 4, 
	2, 1065, 1064, 2, 4, 1063, 1061, 4, 
	1055, 1062, 1058, 2, 4, 1067, 1068, 1069, 
	1067, 4, 1070, 1066, 2, 4, 1067, 1068, 
	1069, 1067, 976, 1070, 1066, 2, 1067, 5, 
	1067, 4, 2, 1067, 1071, 5, 1067, 4, 
	2, 1073, 1072, 2, 4, 1067, 1071, 1069, 
	1067, 976, 1070, 1066, 2, 4, 1074, 1075, 
	4, 947, 1076, 974, 2, 974, 5, 974, 
	4, 2, 974, 1077, 5, 974, 4, 2, 
	1079, 1078, 2, 4, 1077, 1075, 4, 947, 
	1076, 974, 2, 4, 1080, 1081, 4, 943, 
	1082, 946, 2, 946, 5, 946, 4, 2, 
	946, 1083, 5, 946, 4, 2, 1085, 1084, 
	2, 4, 1083, 1081, 4, 943, 1082, 946, 
	2, 943, 1086, 5, 943, 4, 2, 1087, 
	1088, 1089, 1090, 1091, 1088, 1089, 1090, 1091, 
	3, 3, 1, 1087, 1, 4, 1087, 4, 
	1088, 1089, 1090, 1091, 1088, 1089, 1090, 1091, 
	3, 3, 1, 36, 1092, 36, 1094, 1095, 
	1096, 1097, 1094, 1095, 1096, 1097, 1093, 1093, 
	1, 46, 1087, 46, 1088, 1089, 1090, 1091, 
	1088, 1089, 1090, 1091, 3, 3, 1, 114, 
	1098, 114, 1100, 1101, 1102, 1103, 1100, 1101, 
	1102, 1103, 1099, 1099, 1, 147, 1104, 147, 
	1106, 1107, 1108, 1109, 1106, 1107, 1108, 1109, 
	1105, 1105, 1, 207, 1104, 207, 1106, 1107, 
	1108, 1109, 1106, 1107, 1108, 1109, 1105, 1105, 
	1, 138, 1104, 138, 1106, 1107, 1108, 1109, 
	1106, 1107, 1108, 1109, 1105, 1105, 1, 258, 
	1087, 258, 1088, 1089, 1090, 1091, 1088, 1089, 
	1090, 1091, 3, 3, 1, 268, 1104, 268, 
	1106, 1107, 1108, 1109, 1106, 1107, 1108, 1109, 
	1105, 1105, 1, 271, 1087, 271, 1088, 1089, 
	1090, 1091, 1088, 1089, 1090, 1091, 3, 3, 
	1, 278, 1087, 278, 1088, 1089, 1090, 1091, 
	1088, 1089, 1090, 1091, 3, 3, 1, 262, 
	1087, 262, 1088, 1089, 1090, 1091, 1088, 1089, 
	1090, 1091, 3, 3, 1, 291, 1087, 291, 
	1088, 1089, 1090, 1091, 1088, 1089, 1090, 1091, 
	3, 3, 1, 294, 1087, 294, 1088, 1089, 
	1090, 1091, 1088, 1089, 1090, 1091, 3, 3, 
	1, 304, 1087, 304, 1088, 1089, 1090, 1091, 
	1088, 1089, 1090, 1091, 3, 3, 1, 311, 
	1087, 311, 1088, 1089, 1090, 1091, 1088, 1089, 
	1090, 1091, 3, 3, 1, 314, 1087, 314, 
	1088, 1089, 1090, 1091, 1088, 1089, 1090, 1091, 
	3, 3, 1, 317, 1087, 317, 1088, 1089, 
	1090, 1091, 1088, 1089, 1090, 1091, 3, 3, 
	1, 341, 1104, 341, 1106, 1107, 1108, 1109, 
	1106, 1107, 1108, 1109, 1105, 1105, 1, 343, 
	1087, 343, 1088, 1089, 1090, 1091, 1088, 1089, 
	1090, 1091, 3, 3, 1, 328, 1087, 328, 
	1088, 1089, 1090, 1091, 1088, 1089, 1090, 1091, 
	3, 3, 1, 308, 1087, 308, 1088, 1089, 
	1090, 1091, 1088, 1089, 1090, 1091, 3, 3, 
	1, 362, 1087, 362, 1088, 1089, 1090, 1091, 
	1088, 1089, 1090, 1091, 3, 3, 1, 370, 
	1087, 370, 1088, 1089, 1090, 1091, 1088, 1089, 
	1090, 1091, 3, 3, 1, 373, 1087, 373, 
	1088, 1089, 1090, 1091, 1088, 1089, 1090, 1091, 
	3, 3, 1, 382, 1087, 382, 1088, 1089, 
	1090, 1091, 1088, 1089, 1090, 1091, 3, 3, 
	1, 289, 1087, 289, 1088, 1089, 1090, 1091, 
	1088, 1089, 1090, 1091, 3, 3, 1, 261, 
	1087, 261, 1088, 1089, 1090, 1091, 1088, 1089, 
	1090, 1091, 3, 3, 1, 258, 1104, 258, 
	1106, 1107, 1108, 1109, 1106, 1107, 1108, 1109, 
	1105, 1105, 1, 438, 1087, 438, 1088, 1089, 
	1090, 1091, 1088, 1089, 1090, 1091, 3, 3, 
	1, 441, 1087, 441, 1088, 1089, 1090, 1091, 
	1088, 1089, 1090, 1091, 3, 3, 1, 442, 
	1087, 442, 1088, 1089, 1090, 1091, 1088, 1089, 
	1090, 1091, 3, 3, 1, 456, 1087, 456, 
	1088, 1089, 1090, 1091, 1088, 1089, 1090, 1091, 
	3, 3, 1, 459, 1087, 459, 1088, 1089, 
	1090, 1091, 1088, 1089, 1090, 1091, 3, 3, 
	1, 469, 1087, 469, 1088, 1089, 1090, 1091, 
	1088, 1089, 1090, 1091, 3, 3, 1, 476, 
	1087, 476, 1088, 1089, 1090, 1091, 1088, 1089, 
	1090, 1091, 3, 3, 1, 479, 1087, 479, 
	1088, 1089, 1090, 1091, 1088, 1089, 1090, 1091, 
	3, 3, 1, 482, 1087, 482, 1088, 1089, 
	1090, 1091, 1088, 1089, 1090, 1091, 3, 3, 
	1, 499, 1098, 499, 1100, 1101, 1102, 1103, 
	1100, 1101, 1102, 1103, 1099, 1099, 1, 502, 
	1087, 502, 1088, 1089, 1090, 1091, 1088, 1089, 
	1090, 1091, 3, 3, 1, 493, 1087, 493, 
	1088, 1089, 1090, 1091, 1088, 1089, 1090, 1091, 
	3, 3, 1, 473, 1087, 473, 1088, 1089, 
	1090, 1091, 1088, 1089, 1090, 1091, 3, 3, 
	1, 522, 1087, 522, 1088, 1089, 1090, 1091, 
	1088, 1089, 1090, 1091, 3, 3, 1, 530, 
	1087, 530, 1088, 1089, 1090, 1091, 1088, 1089, 
	1090, 1091, 3, 3, 1, 533, 1087, 533, 
	1088, 1089, 1090, 1091, 1088, 1089, 1090, 1091, 
	3, 3, 1, 542, 1087, 542, 1088, 1089, 
	1090, 1091, 1088, 1089, 1090, 1091, 3, 3, 
	1, 454, 1087, 454, 1088, 1089, 1090, 1091, 
	1088, 1089, 1090, 1091, 3, 3, 1, 49, 
	1087, 49, 1088, 1089, 1090, 1091, 1088, 1089, 
	1090, 1091, 3, 3, 1, 583, 1110, 583, 
	1112, 1113, 1114, 1115, 1112, 1113, 1114, 1115, 
	1111, 1111, 1, 586, 1110, 586, 1112, 1113, 
	1114, 1115, 1112, 1113, 1114, 1115, 1111, 1111, 
	1, 589, 1110, 589, 1112, 1113, 1114, 1115, 
	1112, 1113, 1114, 1115, 1111, 1111, 1, 590, 
	1110, 590, 1112, 1113, 1114, 1115, 1112, 1113, 
	1114, 1115, 1111, 1111, 1, 600, 1110, 600, 
	1112, 1113, 1114, 1115, 1112, 1113, 1114, 1115, 
	1111, 1111, 1, 628, 1110, 628, 1112, 1113, 
	1114, 1115, 1112, 1113, 1114, 1115, 1111, 1111, 
	1, 631, 1110, 631, 1112, 1113, 1114, 1115, 
	1112, 1113, 1114, 1115, 1111, 1111, 1, 639, 
	1110, 639, 1112, 1113, 1114, 1115, 1112, 1113, 
	1114, 1115, 1111, 1111, 1, 642, 1110, 642, 
	1112, 1113, 1114, 1115, 1112, 1113, 1114, 1115, 
	1111, 1111, 1, 655, 1110, 655, 1112, 1113, 
	1114, 1115, 1112, 1113, 1114, 1115, 1111, 1111, 
	1, 661, 1110, 661, 1112, 1113, 1114, 1115, 
	1112, 1113, 1114, 1115, 1111, 1111, 1, 665, 
	1110, 665, 1112, 1113, 1114, 1115, 1112, 1113, 
	1114, 1115, 1111, 1111, 1, 668, 1110, 668, 
	1112, 1113, 1114, 1115, 1112, 1113, 1114, 1115, 
	1111, 1111, 1, 684, 1110, 684, 1112, 1113, 
	1114, 1115, 1112, 1113, 1114, 1115, 1111, 1111, 
	1, 687, 1110, 687, 1112, 1113, 1114, 1115, 
	1112, 1113, 1114, 1115, 1111, 1111, 1, 696, 
	1110, 696, 1112, 1113, 1114, 1115, 1112, 1113, 
	1114, 1115, 1111, 1111, 1, 669, 1110, 669, 
	1112, 1113, 1114, 1115, 1112, 1113, 1114, 1115, 
	1111, 1111, 1, 715, 1110, 715, 1112, 1113, 
	1114, 1115, 1112, 1113, 1114, 1115, 1111, 1111, 
	1, 718, 1110, 718, 1112, 1113, 1114, 1115, 
	1112, 1113, 1114, 1115, 1111, 1111, 1, 732, 
	1110, 732, 1112, 1113, 1114, 1115, 1112, 1113, 
	1114, 1115, 1111, 1111, 1, 738, 1110, 738, 
	1112, 1113, 1114, 1115, 1112, 1113, 1114, 1115, 
	1111, 1111, 1, 746, 1087, 746, 1088, 1089, 
	1090, 1091, 1088, 1089, 1090, 1091, 3, 3, 
	1, 747, 1087, 747, 1088, 1089, 1090, 1091, 
	1088, 1089, 1090, 1091, 3, 3, 1, 758, 
	1087, 758, 1088, 1089, 1090, 1091, 1088, 1089, 
	1090, 1091, 3, 3, 1, 763, 1087, 763, 
	1088, 1089, 1090, 1091, 1088, 1089, 1090, 1091, 
	3, 3, 1, 767, 1087, 767, 1088, 1089, 
	1090, 1091, 1088, 1089, 1090, 1091, 3, 3, 
	1, 770, 1087, 770, 1088, 1089, 1090, 1091, 
	1088, 1089, 1090, 1091, 3, 3, 1, 785, 
	1110, 785, 1112, 1113, 1114, 1115, 1112, 1113, 
	1114, 1115, 1111, 1111, 1, 788, 1110, 788, 
	1112, 1113, 1114, 1115, 1112, 1113, 1114, 1115, 
	1111, 1111, 1, 803, 1110, 803, 1112, 1113, 
	1114, 1115, 1112, 1113, 1114, 1115, 1111, 1111, 
	1, 811, 1110, 811, 1112, 1113, 1114, 1115, 
	1112, 1113, 1114, 1115, 1111, 1111, 1, 814, 
	1110, 814, 1112, 1113, 1114, 1115, 1112, 1113, 
	1114, 1115, 1111, 1111, 1, 826, 1110, 826, 
	1112, 1113, 1114, 1115, 1112, 1113, 1114, 1115, 
	1111, 1111, 1, 831, 1087, 831, 1088, 1089, 
	1090, 1091, 1088, 1089, 1090, 1091, 3, 3, 
	1, 892, 1092, 892, 1094, 1095, 1096, 1097, 
	1094, 1095, 1096, 1097, 1093, 1093, 1, 27, 
	1092, 27, 1094, 1095, 1096, 1097, 1094, 1095, 
	1096, 1097, 1093, 1093, 1, 943, 1087, 943, 
	1088, 1089, 1090, 1091, 1088, 1089, 1090, 1091, 
	3, 3, 1, 953, 1092, 953, 1094, 1095, 
	1096, 1097, 1094, 1095, 1096, 1097, 1093, 1093, 
	1, 956, 1087, 956, 1088, 1089, 1090, 1091, 
	1088, 1089, 1090, 1091, 3, 3, 1, 963, 
	1087, 963, 1088, 1089, 1090, 1091, 1088, 1089, 
	1090, 1091, 3, 3, 1, 947, 1087, 947, 
	1088, 1089, 1090, 1091, 1088, 1089, 1090, 1091, 
	3, 3, 1, 976, 1087, 976, 1088, 1089, 
	1090, 1091, 1088, 1089, 1090, 1091, 3, 3, 
	1, 979, 1087, 979, 1088, 1089, 1090, 1091, 
	1088, 1089, 1090, 1091, 3, 3, 1, 989, 
	1087, 989, 1088, 1089, 1090, 1091, 1088, 1089, 
	1090, 1091, 3, 3, 1, 996, 1087, 996, 
	1088, 1089, 1090, 1091, 1088, 1089, 1090, 1091, 
	3, 3, 1, 999, 1087, 999, 1088, 1089, 
	1090, 1091, 1088, 1089, 1090, 1091, 3, 3, 
	1, 1002, 1087, 1002, 1088, 1089, 1090, 1091, 
	1088, 1089, 1090, 1091, 3, 3, 1, 1026, 
	1092, 1026, 1094, 1095, 1096, 1097, 1094, 1095, 
	1096, 1097, 1093, 1093, 1, 1028, 1087, 1028, 
	1088, 1089, 1090, 1091, 1088, 1089, 1090, 1091, 
	3, 3, 1, 1013, 1087, 1013, 1088, 1089, 
	1090, 1091, 1088, 1089, 1090, 1091, 3, 3, 
	1, 993, 1087, 993, 1088, 1089, 1090, 1091, 
	1088, 1089, 1090, 1091, 3, 3, 1, 1047, 
	1087, 1047, 1088, 1089, 1090, 1091, 1088, 1089, 
	1090, 1091, 3, 3, 1, 1055, 1087, 1055, 
	1088, 1089, 1090, 1091, 1088, 1089, 1090, 1091, 
	3, 3, 1, 1058, 1087, 1058, 1088, 1089, 
	1090, 1091, 1088, 1089, 1090, 1091, 3, 3, 
	1, 1067, 1087, 1067, 1088, 1089, 1090, 1091, 
	1088, 1089, 1090, 1091, 3, 3, 1, 974, 
	1087, 974, 1088, 1089, 1090, 1091, 1088, 1089, 
	1090, 1091, 3, 3, 1, 946, 1087, 946, 
	1088, 1089, 1090, 1091, 1088, 1089, 1090, 1091, 
	3, 3, 1, 943, 1092, 943, 1094, 1095, 
	1096, 1097, 1094, 1095, 1096, 1097, 1093, 1093, 
	1, 0
};

static const int16_t _rfc5322_trans_targs[] = {
	742, 0, 0, 2, 3, 4, 743, 6, 
	7, 8, 9, 10, 11, 12, 13, 14, 
	15, 16, 645, 17, 18, 19, 644, 21, 
	568, 640, 577, 18, 19, 20, 640, 577, 
	21, 22, 23, 573, 21, 744, 25, 26, 
	27, 28, 29, 30, 31, 32, 33, 34, 
	35, 388, 393, 565, 745, 37, 38, 39, 
	40, 41, 42, 43, 44, 45, 46, 308, 
	47, 47, 48, 49, 50, 54, 51, 52, 
	53, 50, 55, 56, 57, 299, 304, 58, 
	59, 60, 61, 54, 65, 62, 63, 64, 
	61, 65, 66, 67, 68, 284, 288, 69, 
	70, 71, 72, 283, 80, 76, 73, 74, 
	75, 72, 77, 78, 79, 279, 81, 82, 
	83, 275, 81, 82, 83, 275, 746, 85, 
	86, 87, 88, 89, 90, 91, 92, 93, 
	94, 179, 95, 96, 97, 178, 99, 102, 
	174, 111, 96, 97, 98, 174, 111, 99, 
	100, 101, 107, 99, 747, 103, 103, 104, 
	105, 106, 103, 107, 108, 109, 110, 107, 
	112, 113, 114, 165, 170, 115, 116, 117, 
	118, 111, 122, 119, 120, 121, 118, 122, 
	123, 124, 125, 150, 154, 126, 127, 128, 
	129, 149, 137, 133, 130, 131, 132, 129, 
	134, 135, 136, 145, 138, 139, 140, 99, 
	102, 141, 111, 138, 139, 140, 141, 138, 
	748, 141, 142, 143, 144, 141, 146, 147, 
	148, 145, 151, 152, 153, 150, 154, 155, 
	156, 157, 158, 154, 158, 159, 160, 161, 
	162, 163, 164, 161, 166, 166, 167, 168, 
	169, 166, 171, 172, 173, 170, 175, 176, 
	177, 174, 749, 180, 181, 274, 183, 186, 
	269, 197, 180, 181, 182, 269, 197, 750, 
	183, 184, 185, 192, 183, 751, 187, 187, 
	188, 189, 190, 752, 187, 191, 192, 193, 
	194, 195, 753, 192, 196, 198, 199, 200, 
	258, 264, 754, 201, 202, 203, 204, 197, 
	209, 755, 205, 206, 207, 756, 204, 208, 
	209, 210, 211, 212, 240, 245, 757, 213, 
	214, 215, 216, 239, 225, 221, 758, 217, 
	218, 219, 759, 216, 220, 222, 223, 224, 
	234, 760, 226, 227, 228, 183, 186, 229, 
	197, 226, 227, 228, 229, 226, 761, 229, 
	230, 231, 232, 762, 229, 233, 235, 236, 
	237, 763, 234, 238, 241, 242, 243, 764, 
	240, 244, 245, 246, 247, 248, 250, 765, 
	245, 249, 250, 251, 252, 253, 766, 254, 
	255, 256, 767, 253, 257, 259, 259, 260, 
	261, 262, 768, 259, 263, 265, 266, 267, 
	769, 264, 268, 270, 271, 272, 770, 269, 
	273, 771, 276, 277, 278, 275, 280, 281, 
	282, 279, 285, 286, 287, 284, 288, 289, 
	290, 291, 292, 288, 292, 293, 294, 295, 
	296, 297, 298, 295, 300, 300, 301, 302, 
	303, 300, 305, 306, 307, 304, 308, 309, 
	310, 311, 316, 772, 312, 313, 314, 773, 
	311, 315, 317, 318, 319, 377, 383, 774, 
	320, 321, 322, 323, 316, 328, 775, 324, 
	325, 326, 776, 323, 327, 328, 329, 330, 
	331, 359, 364, 777, 332, 333, 334, 335, 
	358, 344, 340, 778, 336, 337, 338, 779, 
	335, 339, 341, 342, 343, 353, 780, 345, 
	346, 347, 348, 345, 346, 347, 348, 781, 
	349, 350, 351, 782, 348, 352, 354, 355, 
	356, 783, 353, 357, 360, 361, 362, 784, 
	359, 363, 364, 365, 366, 367, 369, 785, 
	364, 368, 369, 370, 371, 372, 786, 373, 
	374, 375, 787, 372, 376, 378, 378, 379, 
	380, 381, 788, 378, 382, 384, 385, 386, 
	789, 383, 387, 389, 390, 391, 790, 388, 
	392, 394, 505, 393, 521, 522, 523, 402, 
	395, 397, 480, 396, 398, 399, 400, 401, 
	398, 403, 405, 406, 407, 408, 413, 403, 
	404, 791, 405, 406, 407, 408, 413, 792, 
	409, 410, 411, 793, 408, 412, 414, 415, 
	416, 421, 794, 417, 418, 419, 795, 416, 
	420, 422, 443, 421, 478, 479, 453, 423, 
	424, 426, 427, 475, 425, 428, 436, 437, 
	438, 431, 439, 434, 428, 429, 430, 431, 
	434, 796, 432, 433, 797, 428, 435, 436, 
	437, 438, 439, 798, 440, 441, 442, 799, 
	444, 442, 451, 452, 448, 445, 447, 446, 
	800, 444, 449, 450, 427, 442, 801, 454, 
	461, 456, 462, 472, 455, 421, 459, 457, 
	458, 802, 456, 460, 803, 456, 463, 464, 
	465, 421, 466, 459, 463, 464, 465, 466, 
	804, 467, 468, 469, 805, 469, 470, 471, 
	469, 806, 453, 473, 474, 462, 423, 476, 
	477, 807, 481, 483, 484, 502, 482, 485, 
	486, 487, 488, 485, 486, 487, 488, 808, 
	489, 490, 491, 809, 492, 491, 500, 501, 
	496, 497, 493, 495, 494, 810, 492, 498, 
	499, 484, 491, 811, 480, 503, 504, 506, 
	508, 514, 507, 509, 812, 510, 511, 512, 
	813, 509, 513, 515, 517, 518, 516, 814, 
	514, 519, 520, 393, 815, 524, 531, 526, 
	532, 562, 525, 529, 527, 528, 816, 526, 
	530, 817, 533, 551, 552, 553, 536, 554, 
	546, 533, 534, 535, 536, 546, 818, 537, 
	536, 540, 541, 542, 538, 539, 538, 819, 
	543, 545, 548, 544, 820, 533, 547, 542, 
	549, 550, 532, 551, 552, 553, 554, 821, 
	555, 556, 557, 822, 558, 557, 560, 561, 
	559, 558, 557, 823, 523, 563, 564, 566, 
	567, 824, 569, 569, 570, 571, 572, 569, 
	573, 574, 575, 576, 573, 578, 579, 580, 
	631, 636, 581, 582, 583, 584, 577, 588, 
	585, 586, 587, 584, 588, 589, 590, 591, 
	616, 620, 592, 593, 594, 595, 615, 603, 
	599, 596, 597, 598, 595, 600, 601, 602, 
	611, 604, 605, 606, 21, 568, 607, 577, 
	604, 605, 606, 607, 604, 825, 607, 608, 
	609, 610, 607, 612, 613, 614, 611, 617, 
	618, 619, 616, 620, 621, 622, 623, 624, 
	620, 624, 625, 626, 627, 628, 629, 630, 
	627, 632, 632, 633, 634, 635, 632, 637, 
	638, 639, 636, 641, 642, 643, 640, 826, 
	646, 647, 740, 649, 652, 735, 663, 646, 
	647, 648, 735, 663, 827, 649, 650, 651, 
	658, 649, 828, 653, 653, 654, 655, 656, 
	829, 653, 657, 658, 659, 660, 661, 830, 
	658, 662, 664, 665, 666, 724, 730, 831, 
	667, 668, 669, 670, 663, 675, 832, 671, 
	672, 673, 833, 670, 674, 675, 676, 677, 
	678, 706, 711, 834, 679, 680, 681, 682, 
	705, 691, 687, 835, 683, 684, 685, 836, 
	682, 686, 688, 689, 690, 700, 837, 692, 
	693, 694, 649, 652, 695, 663, 692, 693, 
	694, 695, 692, 838, 695, 696, 697, 698, 
	839, 695, 699, 701, 702, 703, 840, 700, 
	704, 707, 708, 709, 841, 706, 710, 711, 
	712, 713, 714, 716, 842, 711, 715, 716, 
	717, 718, 719, 843, 720, 721, 722, 844, 
	719, 723, 725, 725, 726, 727, 728, 845, 
	725, 729, 731, 732, 733, 846, 730, 734, 
	736, 737, 738, 847, 735, 739, 848, 1, 
	5, 24, 36, 84, 1, 2, 5, 24, 
	36, 84, 1, 2, 5, 24, 36, 84, 
	1, 2, 5, 24, 36, 84, 1, 2, 
	5, 24, 36, 84
};

static const int8_t _rfc5322_trans_actions[] = {
	0, 0, 21, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 9, 9, 3, 3, 3, 1, 
	0, 3, 3, 0, 0, 0, 0, 0, 
	3, 3, 3, 3, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 3, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 9, 
	9, 0, 0, 0, 0, 0, 0, 0, 
	5, 5, 0, 0, 1, 0, 0, 0, 
	0, 0, 0, 1, 1, 0, 0, 5, 
	5, 0, 0, 0, 1, 0, 1, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	5, 5, 0, 0, 1, 0, 7, 7, 
	7, 7, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 9, 9, 3, 3, 3, 1, 0, 
	3, 3, 0, 0, 0, 0, 0, 3, 
	3, 3, 3, 0, 0, 1, 0, 0, 
	0, 5, 5, 0, 0, 0, 5, 5, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 1, 1, 0, 0, 5, 5, 0, 
	0, 0, 1, 0, 1, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 5, 5, 
	0, 0, 1, 0, 35, 35, 35, 32, 
	7, 35, 35, 3, 3, 3, 3, 0, 
	0, 0, 0, 0, 5, 5, 0, 0, 
	5, 5, 0, 0, 5, 5, 0, 0, 
	0, 5, 1, 5, 0, 0, 0, 0, 
	0, 0, 5, 5, 1, 0, 0, 0, 
	5, 5, 0, 0, 5, 5, 0, 0, 
	5, 5, 0, 3, 3, 3, 1, 0, 
	3, 3, 0, 0, 0, 0, 0, 0, 
	3, 3, 3, 3, 0, 0, 1, 0, 
	0, 0, 5, 0, 5, 5, 0, 0, 
	0, 5, 0, 5, 5, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	1, 0, 0, 0, 5, 0, 5, 5, 
	0, 0, 0, 1, 0, 1, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	0, 5, 0, 5, 5, 0, 0, 1, 
	0, 0, 35, 35, 35, 32, 7, 35, 
	35, 3, 3, 3, 3, 0, 0, 0, 
	0, 0, 5, 0, 5, 5, 0, 0, 
	5, 0, 5, 5, 0, 0, 5, 0, 
	5, 5, 0, 0, 0, 5, 1, 0, 
	5, 5, 0, 0, 0, 0, 0, 0, 
	0, 5, 0, 5, 5, 1, 0, 0, 
	0, 5, 0, 5, 5, 0, 0, 5, 
	0, 5, 5, 0, 0, 5, 0, 5, 
	5, 0, 0, 0, 5, 5, 0, 0, 
	5, 5, 0, 0, 5, 5, 0, 0, 
	0, 5, 1, 5, 0, 0, 0, 0, 
	0, 0, 5, 5, 1, 0, 0, 0, 
	5, 5, 0, 0, 5, 5, 0, 0, 
	0, 0, 0, 0, 0, 0, 5, 0, 
	5, 5, 0, 0, 1, 0, 0, 0, 
	0, 0, 0, 0, 1, 1, 0, 0, 
	0, 5, 0, 5, 5, 0, 0, 0, 
	1, 0, 1, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 5, 0, 
	5, 5, 0, 0, 1, 0, 0, 7, 
	7, 7, 7, 0, 0, 0, 0, 0, 
	0, 0, 5, 0, 5, 5, 0, 0, 
	5, 0, 5, 5, 0, 0, 5, 0, 
	5, 5, 0, 0, 0, 5, 1, 0, 
	5, 5, 0, 0, 0, 0, 0, 0, 
	0, 5, 0, 5, 5, 1, 0, 0, 
	0, 5, 0, 5, 5, 0, 0, 5, 
	0, 5, 5, 0, 0, 5, 0, 5, 
	5, 1, 1, 1, 0, 0, 1, 0, 
	0, 0, 1, 0, 0, 0, 0, 5, 
	5, 7, 7, 7, 7, 7, 7, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 5, 0, 5, 5, 0, 0, 
	0, 3, 0, 0, 0, 5, 0, 5, 
	5, 1, 1, 1, 0, 0, 1, 1, 
	0, 0, 0, 23, 0, 7, 7, 7, 
	7, 7, 7, 29, 0, 0, 0, 0, 
	5, 0, 0, 0, 0, 5, 5, 0, 
	0, 0, 0, 0, 0, 0, 3, 0, 
	1, 1, 0, 0, 23, 0, 0, 0, 
	0, 23, 5, 5, 5, 0, 0, 0, 
	0, 0, 0, 26, 0, 0, 5, 0, 
	0, 0, 5, 5, 0, 7, 7, 7, 
	7, 7, 7, 29, 0, 0, 0, 0, 
	0, 0, 0, 3, 0, 1, 0, 0, 
	0, 0, 26, 5, 5, 5, 23, 5, 
	5, 0, 0, 0, 0, 23, 0, 7, 
	7, 7, 7, 0, 0, 0, 0, 0, 
	0, 0, 3, 0, 1, 1, 0, 0, 
	1, 26, 0, 0, 0, 0, 26, 5, 
	5, 5, 0, 0, 23, 5, 5, 0, 
	0, 1, 0, 0, 0, 0, 0, 5, 
	0, 5, 5, 0, 0, 23, 0, 0, 
	23, 5, 5, 0, 0, 0, 0, 0, 
	0, 26, 0, 5, 0, 0, 0, 5, 
	5, 0, 7, 7, 7, 7, 7, 7, 
	29, 0, 0, 0, 0, 5, 0, 1, 
	1, 0, 0, 1, 1, 23, 23, 0, 
	0, 0, 26, 0, 0, 5, 5, 26, 
	5, 5, 5, 0, 0, 0, 0, 0, 
	0, 0, 3, 0, 1, 1, 0, 0, 
	26, 26, 0, 0, 26, 5, 5, 0, 
	19, 0, 1, 0, 0, 0, 5, 5, 
	0, 0, 0, 5, 5, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 1, 1, 
	0, 0, 5, 5, 0, 0, 0, 1, 
	0, 1, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 5, 5, 0, 0, 1, 
	0, 35, 35, 35, 32, 7, 35, 35, 
	3, 3, 3, 3, 0, 0, 0, 0, 
	0, 5, 5, 0, 0, 5, 5, 0, 
	0, 5, 5, 0, 0, 0, 5, 1, 
	5, 0, 0, 0, 0, 0, 0, 5, 
	5, 1, 0, 0, 0, 5, 5, 0, 
	0, 5, 5, 0, 0, 5, 5, 0, 
	3, 3, 3, 1, 0, 3, 3, 0, 
	0, 0, 0, 0, 0, 3, 3, 3, 
	3, 0, 0, 1, 0, 0, 0, 5, 
	0, 5, 5, 0, 0, 0, 5, 0, 
	5, 5, 0, 0, 1, 0, 0, 0, 
	0, 0, 0, 0, 1, 1, 0, 0, 
	0, 5, 0, 5, 5, 0, 0, 0, 
	1, 0, 1, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 5, 0, 
	5, 5, 0, 0, 1, 0, 0, 35, 
	35, 35, 32, 7, 35, 35, 3, 3, 
	3, 3, 0, 0, 0, 0, 0, 5, 
	0, 5, 5, 0, 0, 5, 0, 5, 
	5, 0, 0, 5, 0, 5, 5, 0, 
	0, 0, 5, 1, 0, 5, 5, 0, 
	0, 0, 0, 0, 0, 0, 5, 0, 
	5, 5, 1, 0, 0, 0, 5, 0, 
	5, 5, 0, 0, 5, 0, 5, 5, 
	0, 0, 5, 0, 5, 5, 0, 0, 
	9, 9, 9, 9, 13, 13, 41, 41, 
	41, 41, 11, 11, 38, 38, 38, 38, 
	15, 15, 44, 44, 44, 44, 17, 17, 
	47, 47, 47, 47
};

static const int8_t _rfc5322_eof_actions[] = {
	0, 0, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 0, 0, 0, 
	13, 0, 11, 15, 15, 15, 0, 15, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 15, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 15, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 11, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 17, 17, 17, 17, 
	17, 17, 17, 17, 0, 0, 0, 0, 
	0, 0, 17, 17, 17, 17, 17, 17, 
	0, 13, 13, 0, 13, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 13, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	13
};

static const int rfc5322_start = 741;
static const int rfc5322_first_final = 741;
static const int rfc5322_error = 0;

static const int rfc5322_en_main = 741;


#line 150 "Rfc5322HeaderParser.cpp"

#ifdef __clang__
#pragma clang diagnostic pop
#endif

Rfc5322HeaderParser::Rfc5322HeaderParser():
    listPostNo(false), m_error(false)
{
}

void Rfc5322HeaderParser::clear()
{
    m_error = false;
    references.clear();
    listPost.clear();
    messageId.clear();
    inReplyTo.clear();
    listPostNo = false;
}

bool Rfc5322HeaderParser::parse(const QByteArray &data)
{
    clear();

    const char *p = data.constData();
    const char *pe = p + data.length();
    const char *eof = pe;
    int cs;

    QByteArray str;
    QList<QByteArray> list;

    
#line 2585 "Rfc5322HeaderParser.generated.cpp"
	{
	cs = rfc5322_start;
	}

#line 183 "Rfc5322HeaderParser.cpp"
    
#line 2592 "Rfc5322HeaderParser.generated.cpp"
	{
	int _klen;
	unsigned int _trans;
	const int8_t *_acts;
	unsigned int _nacts;
	const int8_t *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _rfc5322_trans_keys + _rfc5322_key_offsets[cs];
	_trans = _rfc5322_index_offsets[cs];

	_klen = _rfc5322_single_lengths[cs];
	if ( _klen > 0 ) {
		const int8_t *_lower = _keys;
		const int8_t *_mid;
		const int8_t *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _rfc5322_range_lengths[cs];
	if ( _klen > 0 ) {
		const int8_t *_lower = _keys;
		const int8_t *_mid;
		const int8_t *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	_trans = _rfc5322_indicies[_trans];
	cs = _rfc5322_trans_targs[_trans];

	if ( _rfc5322_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _rfc5322_actions + _rfc5322_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 35 "Rfc5322HeaderParser.cpp"
	{
#ifdef RAGEL_DEBUG
        qDebug() << "push_current_char " << *p;
#endif
        str.append(*p);
    }
	break;
	case 1:
#line 42 "Rfc5322HeaderParser.cpp"
	{
#ifdef RAGEL_DEBUG
        qDebug() << "clear_str";
#endif
        str.clear();
    }
	break;
	case 2:
#line 49 "Rfc5322HeaderParser.cpp"
	{
        switch (*p) {
            case 'n':
                str += "\n";
                break;
            case 'r':
                str += "\r";
                break;
            case '0':
                str += "\0";
                break;
            case '\\':
                str += "\\";
                break;
            default:
                str += '\\' + *p;
        }
#ifdef RAGEL_DEBUG
        qDebug() << "push_current_backslashed \\" << *p;
#endif
    }
	break;
	case 3:
#line 71 "Rfc5322HeaderParser.cpp"
	{
#ifdef RAGEL_DEBUG
        qDebug() << "push_string_list " << str.data();
#endif
        list.append(str);
        str.clear();
    }
	break;
	case 4:
#line 79 "Rfc5322HeaderParser.cpp"
	{
#ifdef RAGEL_DEBUG
        qDebug() << "clear_list";
#endif
        list.clear();
        str.clear();
    }
	break;
	case 5:
#line 87 "Rfc5322HeaderParser.cpp"
	{
        if (list.size() == 1) {
#ifdef RAGEL_DEBUG
            qDebug() << "Message-Id: " << list[0].data();
#endif
            messageId += list;
        } else {
#ifdef RAGEL_DEBUG
            qDebug() << "invalid Message-Id";
#endif
        }
    }
	break;
	case 6:
#line 100 "Rfc5322HeaderParser.cpp"
	{
        inReplyTo += list;
#ifdef RAGEL_DEBUG
        qDebug() << "In-Reply-To: " << list;
#endif
    }
	break;
	case 7:
#line 107 "Rfc5322HeaderParser.cpp"
	{
        references += list;
#ifdef RAGEL_DEBUG
        qDebug() << "got_references_header:" << references;
#endif
    }
	break;
	case 8:
#line 114 "Rfc5322HeaderParser.cpp"
	{
        listPost += list;
#ifdef RAGEL_DEBUG
        qDebug() << "got_list_post_header:" << listPost;
#endif
    }
	break;
	case 9:
#line 121 "Rfc5322HeaderParser.cpp"
	{
        listPostNo = true;
#ifdef RAGEL_DEBUG
        qDebug() << "got_list_post_no";
#endif
    }
	break;
	case 10:
#line 128 "Rfc5322HeaderParser.cpp"
	{
#ifdef RAGEL_DEBUG
        qDebug() << "Error when parsing RFC5322 headers";
#endif
        m_error = true;
    }
	break;
#line 2788 "Rfc5322HeaderParser.generated.cpp"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const int8_t *__acts = _rfc5322_actions + _rfc5322_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 5:
#line 87 "Rfc5322HeaderParser.cpp"
	{
        if (list.size() == 1) {
#ifdef RAGEL_DEBUG
            qDebug() << "Message-Id: " << list[0].data();
#endif
            messageId += list;
        } else {
#ifdef RAGEL_DEBUG
            qDebug() << "invalid Message-Id";
#endif
        }
    }
	break;
	case 6:
#line 100 "Rfc5322HeaderParser.cpp"
	{
        inReplyTo += list;
#ifdef RAGEL_DEBUG
        qDebug() << "In-Reply-To: " << list;
#endif
    }
	break;
	case 7:
#line 107 "Rfc5322HeaderParser.cpp"
	{
        references += list;
#ifdef RAGEL_DEBUG
        qDebug() << "got_references_header:" << references;
#endif
    }
	break;
	case 8:
#line 114 "Rfc5322HeaderParser.cpp"
	{
        listPost += list;
#ifdef RAGEL_DEBUG
        qDebug() << "got_list_post_header:" << listPost;
#endif
    }
	break;
	case 10:
#line 128 "Rfc5322HeaderParser.cpp"
	{
#ifdef RAGEL_DEBUG
        qDebug() << "Error when parsing RFC5322 headers";
#endif
        m_error = true;
    }
	break;
#line 2855 "Rfc5322HeaderParser.generated.cpp"
		}
	}
	}

	_out: {}
	}

#line 184 "Rfc5322HeaderParser.cpp"

    return !m_error;
}

}
}

#if 0
#include <iostream>
int main()
{
    QByteArray data;
    std::string line;

    while (std::getline(std::cin, line)) {
        data += line.c_str();
        data += '\n';
    }

    Imap::Parser::Rfc5322HeaderParser parser;
    bool res = parser.parse(data);
    if (!res) {
        qDebug() << "Parsing error.";
        return 1;
    }

    qDebug() << "References:" << parser.references;

    return 0;
}
#endif
