/*
Topal: GPG/GnuPG and Alpine/Pine integration
Copyright (C) 2001--2022  Phillip J. Brooke

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License version 3 as
published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <termios.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>

int setecho ()
{
  struct termios mode;
  struct termios new_mode;
  int fd = 0 /* stdin */;

  memset (&mode, 0, sizeof (mode));
  if (tcgetattr (fd, &mode))
    exit(1);
  mode.c_lflag = mode.c_lflag | ECHO;
  if (tcsetattr (fd, TCSADRAIN, &mode))
    exit(2);
  memset (&new_mode, 0, sizeof (new_mode));
  if (tcgetattr (fd, &new_mode))
    exit(3);
  if (memcmp (&mode, &new_mode, sizeof (mode)) != 0)
    exit(4);
  return 0;
}

int noechoT ()
{
  struct termios mode;
  struct termios new_mode;
  int fd = 0; /* stdin */

  memset (&mode, 0, sizeof (mode));
  if (tcgetattr (fd, &mode))
    exit(1);
  mode.c_lflag = mode.c_lflag & ~ECHO;
  if (tcsetattr (fd, TCSADRAIN, &mode))
    exit(2);
  memset (&new_mode, 0, sizeof (new_mode));
  if (tcgetattr (fd, &new_mode))
    exit(3);
  if (memcmp (&mode, &new_mode, sizeof (mode)) != 0)
    exit(4);
  return 0;
}

/* Save and restore terminal. */
struct termios term0;
struct termios term1;

int saveTerminal ()
{
  tcgetattr(0, &term0);
  tcgetattr(1, &term1);
  return 0;
}

int restoreTerminal()
{
  tcsetattr(0, TCSANOW, &term0);
  tcsetattr(1, TCSANOW, &term1);
  return 0;
}
