from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


_ = _Mock()

check = _Mock()

check_with_pep8 = _Mock()

check_with_pyflakes = _Mock()

dependencies = _Mock()

encoding = _Mock()

find_tasks = _Mock()

get_checker_executable = _Mock()

is_pyflakes_installed = _Mock()

os = _Mock()

programs = _Mock()

re = _Mock()

sys = _Mock()

tempfile = _Mock()

to_binary_string = _Mock()

to_text_string = _Mock()

traceback = _Mock()

DEBUG = 0

DEBUG_EDITOR = _Mock()

PEP8_REQVER = '>=0.6'

PIPE = -1

PY3 = _Mock()

PYFLAKES_REQVER = '>=0.5.0'

TASKS_PATTERN = '(^|#)[ ]*(TODO|FIXME|XXX|HINT|TIP|@todo)([^#]*)'

class Popen(_Mock):
  pass
  _child_created = False

