from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


make = _Mock()

np = _Mock()

print_function = _Mock()

run = _Mock()

time = _Mock()

SHOW = _Mock()

class BaseBM(_Mock):
  pass


class CurveBM(_Mock):
  pass


class CurveWindow(_Mock):
  pass
  AllowNestedDocks = 2
  AllowTabbedDocks = 4
  AnimatedDocks = 1
  DrawChildren = 2
  DrawWindowBackground = 1
  ForceTabbedDocks = 8
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  VerticalTabs = 16

class ErrorBarBM(_Mock):
  pass


class HistogramBM(_Mock):
  pass


class ImageBM(_Mock):
  pass


class ImageWindow(_Mock):
  pass
  AllowNestedDocks = 2
  AllowTabbedDocks = 4
  AnimatedDocks = 1
  DrawChildren = 2
  DrawWindowBackground = 1
  ForceTabbedDocks = 8
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  VerticalTabs = 16

class PColorBM(_Mock):
  pass


class QApplication(_Mock):
  pass
  CodecForTr = 0
  CustomColor = 1
  DefaultCodec = 0
  GuiClient = 1
  GuiServer = 2
  ManyColor = 2
  NormalColor = 0
  Tty = 0
  UnicodeUTF8 = 1

