from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


Event = _Mock()

cast_bytes = _Mock()

decorator = _Mock()

error = _Mock()

extract_dates = _Mock()

get_ipython_dir = _Mock()

getpass = _Mock()

is_local_ip = _Mock()

iteritems = _Mock()

json = _Mock()

localhost = _Mock()

os = _Mock()

parse_date = _Mock()

pjoin = _Mock()

pprint = _Mock()

print_function = _Mock()

rekey = _Mock()

serialize = _Mock()

spin_first = _Mock()

string_types = _Mock()

sys = _Mock()

time = _Mock()

tunnel = _Mock()

util = _Mock()

warnings = _Mock()

zmq = _Mock()



class Any(_Mock):
  pass
  info_text = 'any value'

class AsyncHubResult(_Mock):
  pass
  _single_result = False

class AsyncResult(_Mock):
  pass
  _single_result = False

class BaseIPythonApplication(_Mock):
  pass
  _in_init_profile_dir = False

class Bool(_Mock):
  pass
  default_value = False
  info_text = 'a boolean'

class Client(_Mock):
  pass
  _closed = False

class Dict(_Mock):
  pass
  info_text = 'any value'

class DirectView(_Mock):
  pass
  skip_doctest = True

class ExecuteReply(_Mock):
  pass


class HasTraits(_Mock):
  pass


class Instance(_Mock):
  pass
  info_text = 'any value'

class Integer(_Mock):
  pass
  default_value = 0
  info_text = 'an integer'

class List(_Mock):
  pass
  info_text = 'any value'

class LoadBalancedView(_Mock):
  pass
  skip_doctest = True

class Message(_Mock):
  pass


class Metadata(_Mock):
  pass


class MultipleInstanceError(_Mock):
  pass


class ProfileDir(_Mock):
  pass


class ProfileDirError(_Mock):
  pass


class Reference(_Mock):
  pass


class RichOutput(_Mock):
  pass


class Session(_Mock):
  pass


class Set(_Mock):
  pass
  info_text = 'any value'

class TermColors(_Mock):
  pass
  Black = '\x1b[0;30m'
  BlinkBlack = '\x1b[5;30m'
  BlinkBlue = '\x1b[5;34m'
  BlinkCyan = '\x1b[5;36m'
  BlinkGreen = '\x1b[5;32m'
  BlinkLightGray = '\x1b[5;37m'
  BlinkPurple = '\x1b[5;35m'
  BlinkRed = '\x1b[5;31m'
  BlinkYellow = '\x1b[5;33m'
  Blue = '\x1b[0;34m'
  Brown = '\x1b[0;33m'
  Cyan = '\x1b[0;36m'
  DarkGray = '\x1b[1;30m'
  Green = '\x1b[0;32m'
  LightBlue = '\x1b[1;34m'
  LightCyan = '\x1b[1;36m'
  LightGray = '\x1b[0;37m'
  LightGreen = '\x1b[1;32m'
  LightPurple = '\x1b[1;35m'
  LightRed = '\x1b[1;31m'
  NoColor = ''
  Normal = '\x1b[0m'
  Purple = '\x1b[0;35m'
  Red = '\x1b[0;31m'
  White = '\x1b[1;37m'
  Yellow = '\x1b[1;33m'
  _base = '\x1b[%sm'

class Thread(_Mock):
  pass
  _Thread__initialized = False

class Unicode(_Mock):
  pass
  default_value = u''
  info_text = 'a unicode string'

class datetime(_Mock):
  pass


class xrange(_Mock):
  pass


