from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


application = _Mock()

boolean_flag = _Mock()

catch_config_error = _Mock()

configurable = _Mock()

decorator = _Mock()

dedent = _Mock()

deepcopy = _Mock()

import_item = _Mock()

indent = _Mock()

iteritems = _Mock()

loader = _Mock()

logging = _Mock()

os = _Mock()

print_function = _Mock()

profile = _Mock()

py3compat = _Mock()

re = _Mock()

string_types = _Mock()

sys = _Mock()

wrap_paragraphs = _Mock()

keyvalue_description = "Parameters are set from command-line arguments of the form:\n`--Class.trait=value`.\nThis line is evaluated in Python, so simple expressions are allowed, e.g.::\n`--C.a='range(3)'` For setting C.a=[0,1,2]."

option_description = "Arguments that take values are actually convenience aliases to full\nConfigurables, whose aliases are listed on the help line. For more information\non full configurables, see '--help-all'."

subcommand_description = "\nSubcommands are launched as `{app} cmd [args]`. For information on using\nsubcommand 'cmd', do: `{app} cmd -h`.\n"

class Application(_Mock):
  pass


class ApplicationError(_Mock):
  pass


class ArgumentError(_Mock):
  pass


class Config(_Mock):
  pass


class ConfigFileNotFound(_Mock):
  pass


class Configurable(_Mock):
  pass


class ConfigurableError(_Mock):
  pass


class Dict(_Mock):
  pass
  info_text = 'any value'

class Enum(_Mock):
  pass
  info_text = 'any value'

class HasTraits(_Mock):
  pass


class Instance(_Mock):
  pass
  info_text = 'any value'

class JSONFileConfigLoader(_Mock):
  pass


class KVArgParseConfigLoader(_Mock):
  pass


class LazyConfigValue(_Mock):
  pass


class LevelFormatter(_Mock):
  pass
  highlevel_format = ' %(levelname)s |'
  highlevel_limit = 30

class List(_Mock):
  pass
  info_text = 'any value'

class LoggingConfigurable(_Mock):
  pass


class MultipleInstanceError(_Mock):
  pass


class PyFileConfigLoader(_Mock):
  pass


class SingletonConfigurable(_Mock):
  pass


class TraitError(_Mock):
  pass


class Unicode(_Mock):
  pass
  default_value = u''
  info_text = 'a unicode string'

class defaultdict(_Mock):
  pass


