package org.spview.gui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.io.IOException;
import java.net.URL;

import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class PopFile {
	/**
	 * Show help file text.
	 *
	 * @param nhelpf help file name
	 */
	public static void show(String nhelpf) {

		if (nhelpf == null) {
			JOptionPane.showMessageDialog(null, "No help provided for this item");
			return;
		}

		JTextArea jtahelp = new JTextArea();
		jtahelp.setFont(new Font("Serif", Font.PLAIN, 14));
		jtahelp.setLineWrap(true); // line wrap allowed
		jtahelp.setWrapStyleWord(true); // between 2 words
		jtahelp.setEditable(false); // not editable

		String lnsep = System.getProperty("line.separator");
		String fisep = System.getProperty("file.separator");

		JEditorPane editorPane = new JEditorPane();
		editorPane.setContentType("text/html");
		editorPane.setEditable(false);
		URL res = PopFile.class.getResource(fisep + nhelpf + ".html");
		if (res != null) {
			try {
				editorPane.setPage(res);
			} catch (IOException ioe) { // IO error
				JOptionPane.showMessageDialog(null,
						"IO error while reading file" + lnsep + fisep + nhelpf + ".html" + lnsep + ioe);
				return;
			}
		}
		final ImageIcon icon = new ImageIcon(new ImageIcon(JobPlay.class.getResource("/pixmaps/spview.png")).getImage()
				.getScaledInstance(64, 64, Image.SCALE_SMOOTH));

		JScrollPane scrollPane = new JScrollPane(editorPane);
		scrollPane.setPreferredSize(new Dimension(600, 200));
		JOptionPane.showMessageDialog(null, scrollPane, "Help", JOptionPane.PLAIN_MESSAGE, icon);
	}
}
