6.1 エフェクトの追加

# エフェクトの追加

このセクションでは、エフェクター「リバーブとエコー」の組み合わせを見ていきます。

それらをどのようにチェーン接続するか、どのように制御するのか、これらの使用方法について説明します。
Sonic Piのエフェクトシステムは、ブロックを使用します。

セクション5.1を読んでいなければ、戻って目を通してください。

## リバーブ

リバーブを使用する場合、この様に特殊なコード`with_fx :reverb`をブロックに書きます。

```
with_fx :reverb do
 play 50
 sleep 0.5
 sample :elec_plip
 sleep 0.5
 play 62
end
```

早速コードを実行してリバーブを聞いてみましょう。いいでしょ！音全体が残響効果で素晴らしくなります。

さあ、次はブロックの外にコードを書いて何が起こるか見てみましょう。

```
with_fx :reverb do
 play 50
 sleep 0.5
 sample :elec_plip
 sleep 0.5
 play 62
end

sleep 1
play 55
```

どうして最後の `play 55`にリバーブが適用されないのでしょうか。
それはブロックの*外部*に書かれているため、リバーブエフェクトは適応されないのです。
*do/end*ブロックの手前で音を生成する場合も同様にリバーブは適用されません。

```
play 55
sleep 1

with_fx :reverb do
 play 50
 sleep 0.5
 sample :elec_plip
 sleep 0.5
 play 62
end

sleep 1
play 55
```

## Echo：エコー

選択できる効果は他にもたくさんあります。エコーはどうでしょうか?

```
with_fx :echo do
 play 50
 sleep 0.5
 sample :elec_plip
 sleep 0.5
 play 62
end
```

Sonic Piのエフェクトブロックの強力な側面の一つは、既に`play`と`sample`で見てきたように、
オプションと同様の数値が渡されることです。たとえば、エコーの楽しいオプションは、
秒単位で遅れを示す`phase`で表され、エコーの長さを指定します。

下記のコードで、音の響きをゆっくりにしてみましょう。

```
with_fx :echo, phase: 0.5 do
 play 50
 sleep 0.5
 sample :elec_plip
 sleep 0.5
 play 62
end
```

エコーの遅れを早くしてみましょう。

```
with_fx :echo, phase: 0.125 do
 play 50
 sleep 0.5
 sample :elec_plip
 sleep 0.5
 play 62
end
```

エコーが８秒間の時間でフェードアウトする様に、`decay`を設定してみましょう。

```
with_fx :echo, phase: 0.5, decay: 8 do
 play 50
 sleep 0.5
 sample :elec_plip
 sleep 0.5
 play 62
end
```

## エフェクトの入れ子

ブロック効果の中で最も強力な側面の一つは、入れ子ができるということです。 これはとても簡単にエフェクト同士を連結することができます。たとえば、あなたはどのようにエコーとリバーブの両方を適応さますか？ その答えは単純です。一つの効果の内側にもう一方を配置するだけです。

```
with_fx :reverb do
 with_fx :echo, phase: 0.5, decay: 8 do
   play 50
   sleep 0.5
   sample :elec_blup
   sleep 0.5
   play 62
 end
end
```

オーディオの流れについて逆側から追ってみましょう。`play 50`を含む`block`の*do/end*ブロック内のコード全ては、最初にエコーエフェクトに送られ、その音がリバーブエフェクトへと順に送られていきます。

クレイジーなサウンドを得るために非常に深く入れ子を使用することができます。しかし、一度にたくさんのエフェクトを入れ子で実行すると多くのリソースを必要とするため、注意してください。そのため、特にラズベリーパイのような低電力供給のプラットフォームではエフェクトの使用を節約することも必要です。

## エフェクターの発見

Sonic Piは、あなたが演奏するためにたくさんのエフェクターを搭載しています。どういった効果が使えるのかを見つけ出すためには、ヘルプシステム画面の下にある効果ボタンをクリックし、利用可能なリストを見てください。ここに私のお気に入りを記載しておきます。

* wobble,
* reverb,
* echo,
* distortion,
* slicer

さあ、エフェクターを追加して驚きの新しいサウンドの虜となってくだい！
