#version 330

in vec3 Normal;
in float distance_from_start;
in float rl;
in float bondlength;
uniform vec3 lightPos;
layout( location = 0 ) out vec4 fragColor;

/*
uniform struct LightInfo {
  vec4_an%1000; // Position;  // Light position in eye coords.
  vec3 La;        // Ambient light intesity
  vec3 L;         // Diffuse and specular light intensity
} Light;

uniform struct MaterialInfo {
  vec3 Ka;            // Ambient reflectivity
  vec3 Kd;            // Diffuse reflectivity
  vec3 Ks;            // Specular reflectivity
  float Shininess;    // Specular shininess factor
} Material;
*/

vec3 blinnPhong( vec3 position, vec3 n , vec3 kd) {
    vec3 ambient = vec3(0.25, 0.25, 0.25);//Light.La * Material.Ka;
    vec3 intensity = vec3(0.95, 0.95, 0.95);
    vec3 s = normalize(lightPos - position );
    float sDotN = max(dot(s,n), 0.0 );
    vec3 diffuse = kd * sDotN;
    vec3 spec = vec3(0.0);
    float Shininess = 48.0;
    if (sDotN > 0.0) {
      vec3 v = normalize(-position.xyz);
      vec3 h = normalize(v + s);
      spec = vec3(1,1,1) * pow(max(dot(h,n), 0.0), Shininess);
    }
    return ambient + intensity * (diffuse + spec);
}

vec3 blinnPhongDirectional( vec3 n , vec3 kd) {
    vec3 ambient = kd * 0.5;//Light.La * Material.Ka;
    vec3 intensity = vec3(0.8, 0.8, 0.8);//specular and diffuse
    vec3 s = normalize(lightPos);// directional light
    float sDotN = abs(dot(s,n));
    vec3 diffuse = kd * sDotN;
    vec3 spec = vec3(0.0);
    float Shininess = 48.0;
    if (sDotN > 0.0) {
      spec = vec3(1,1,1) * pow(max(dot(s,n), 0.0), Shininess);
    }
    return ambient + intensity * (diffuse + spec);
}



void main(void){
    int st2 = 0;
    //two sided lighting:
    vec3 Color = (rl<1.5)?vec3(1.0,0.4,0.2):vec3(0.0,0.4,1.0);
    if (rl>2.5) Color = vec3(1,0,0);
    if (rl>3.5) Color = vec3(0,1,0);
    if (rl>4.5) Color = vec3(0,0,1);
    if (gl_FrontFacing) fragColor = vec4(blinnPhongDirectional(normalize(Normal), Color), 1.0);
    else fragColor = vec4(blinnPhongDirectional(normalize(-Normal), mix(Color,vec3(0.5,0.7,0.5),0.2)), 1.0);//a bit greener?

}
