// ==========================================================================
//                 SeqAn - The Library for Sequence Analysis
// ==========================================================================
// Copyright (c) 2006-2010, Knut Reinert, FU Berlin
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Knut Reinert or the FU Berlin nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL KNUT REINERT OR THE FU BERLIN BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ==========================================================================


#ifndef SEQAN_HEADER_INDEX_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_INDEX_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {
namespace impl {

//____________________________________________________________________________
// substringHelperPizzaChili

template <typename TValue, typename TSpec, typename TPos> struct substringHelperPizzaChili;       	// "seqan-1.3.1/seqan/index/index_pizzachili_string.h"(535)

} //namespace impl
} //namespace SEQAN_NAMESPACE_MAIN
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// AddResultsFunctor

template <typename TSAValue1, typename TSAValue2> struct AddResultsFunctor;       	// "seqan-1.3.1/seqan/index/find_index_approx.h"(43)

//____________________________________________________________________________
// AddSingleResultsFunctor

template <typename TSAValue> struct AddSingleResultsFunctor;       	// "seqan-1.3.1/seqan/index/find_index_approx.h"(124)

//____________________________________________________________________________
// Align

template <typename TSource, typename TSpec> class Align;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(225)

//____________________________________________________________________________
// AllocHelper_

template <typename TValue, typename TSpec> struct AllocHelper_;       	// "seqan-1.3.1/seqan/index/index_pizzachili_string.h"(298)

//____________________________________________________________________________
// ArrayGaps

struct ArrayGaps;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(222)

//____________________________________________________________________________
// BTree

template <unsigned BlockSize > struct BTree;       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(57)

//____________________________________________________________________________
// BottomUp

template <typename TSpec > struct BottomUp;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(145)

//____________________________________________________________________________
// BucketMap

template <typename THashValue> struct BucketMap;       	// "seqan-1.3.1/seqan/index/index_qgram_openaddressing.h"(46)

//____________________________________________________________________________
// Bwt

struct Bwt;       	// "seqan-1.3.1/seqan/index/index_base.h"(60)
struct Bwt;       	// "seqan-1.3.1/seqan/index/index_bwt.h"(44)

//____________________________________________________________________________
// BwtWalk

template <typename TSpec > struct BwtWalk;       	// "seqan-1.3.1/seqan/index/index_sa_bwtwalk.h"(62)

//____________________________________________________________________________
// BwtWalkFast_

struct BwtWalkFast_;       	// "seqan-1.3.1/seqan/index/index_sa_bwtwalk.h"(55)

//____________________________________________________________________________
// BwtWalkInPlace_

struct BwtWalkInPlace_;       	// "seqan-1.3.1/seqan/index/index_sa_bwtwalk.h"(58)

//____________________________________________________________________________
// Childtab

struct Childtab;       	// "seqan-1.3.1/seqan/index/index_childtab.h"(44)
struct Childtab;       	// "seqan-1.3.1/seqan/index/index_base.h"(59)

//____________________________________________________________________________
// CompareSkewDCStream

template <typename TValue> struct CompareSkewDCStream;       	// "seqan-1.3.1/seqan/index/pipe_merger7.h"(109)

//____________________________________________________________________________
// ContextLss_

template <typename TValue> struct ContextLss_;       	// "seqan-1.3.1/seqan/index/index_sa_lss.h"(64)

//____________________________________________________________________________
// DeepShallow

struct DeepShallow;       	// "seqan-1.3.1/seqan/index/index_shawarma.h"(56)

//____________________________________________________________________________
// DefaultIndexCreator

template <typename TIndex, typename TFibre > struct DefaultIndexCreator;       	// "seqan-1.3.1/seqan/index/index_base.h"(231)

//____________________________________________________________________________
// DefaultIndexSpec

template <typename TObject > struct DefaultIndexSpec;       	// "seqan-1.3.1/seqan/index/index_base.h"(109)

//____________________________________________________________________________
// DefaultIndexStringSpec

template <typename TIndex > struct DefaultIndexStringSpec;       	// "seqan-1.3.1/seqan/index/index_base.h"(125)

//____________________________________________________________________________
// Dfi

template <typename TPredHull , typename TPred > struct Dfi;       	// "seqan-1.3.1/seqan/index/index_dfi.h"(93)

//____________________________________________________________________________
// DfiEntry_

struct DfiEntry_;       	// "seqan-1.3.1/seqan/index/index_dfi.h"(46)

//____________________________________________________________________________
// DfiPredDefault_

template <bool Result> struct DfiPredDefault_;       	// "seqan-1.3.1/seqan/index/index_dfi.h"(58)

//____________________________________________________________________________
// DivSufSort

struct DivSufSort;       	// "seqan-1.3.1/seqan/index/index_shawarma.h"(55)

//____________________________________________________________________________
// EmptyEdges

struct EmptyEdges;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(122)

//____________________________________________________________________________
// ErrorAlphabet_

struct ErrorAlphabet_;       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(135)

//____________________________________________________________________________
// ErrorPackedString

struct ErrorPackedString;       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(157)

//____________________________________________________________________________
// ErrorPatternLess

struct ErrorPatternLess;       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(326)

//____________________________________________________________________________
// ErrorTypes

template <typename TDistance> struct ErrorTypes;       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(182)

//____________________________________________________________________________
// Extender3

struct Extender3;       	// "seqan-1.3.1/seqan/index/pump_extender3.h"(44)

//____________________________________________________________________________
// Extender7

template <typename TCompression > struct Extender7;       	// "seqan-1.3.1/seqan/index/pump_extender7.h"(47)

//____________________________________________________________________________
// Extender7Multi

template <typename TPair, typename TCompression > struct Extender7Multi;       	// "seqan-1.3.1/seqan/index/pump_extender7.h"(259)

//____________________________________________________________________________
// Fibre

template <typename TIndex, typename TSpec > struct Fibre;       	// "seqan-1.3.1/seqan/index/index_base.h"(194)

//____________________________________________________________________________
// FibreBucketMap_

struct FibreBucketMap_;       	// "seqan-1.3.1/seqan/index/index_qgram.h"(108)

//____________________________________________________________________________
// FibreBwt_

struct FibreBwt_;       	// "seqan-1.3.1/seqan/index/index_base.h"(327)

//____________________________________________________________________________
// FibreChildtab_

struct FibreChildtab_;       	// "seqan-1.3.1/seqan/index/index_base.h"(326)

//____________________________________________________________________________
// FibreCountsDir_

struct FibreCountsDir_;       	// "seqan-1.3.1/seqan/index/index_qgram.h"(107)

//____________________________________________________________________________
// FibreCounts_

struct FibreCounts_;       	// "seqan-1.3.1/seqan/index/index_qgram.h"(106)

//____________________________________________________________________________
// FibreDir_

struct FibreDir_;       	// "seqan-1.3.1/seqan/index/index_qgram.h"(103)

//____________________________________________________________________________
// FibreLcp_

struct FibreLcp_;       	// "seqan-1.3.1/seqan/index/index_base.h"(324)

//____________________________________________________________________________
// FibreLcpe_

struct FibreLcpe_;       	// "seqan-1.3.1/seqan/index/index_base.h"(325)

//____________________________________________________________________________
// FibreLess

struct FibreLess;       	// "seqan-1.3.1/seqan/index/index_base.h"(211)

//____________________________________________________________________________
// FibrePizzaChiliCompressed_

struct FibrePizzaChiliCompressed_;       	// "seqan-1.3.1/seqan/index/index_pizzachili.h"(56)

//____________________________________________________________________________
// FibreRawSA_

struct FibreRawSA_;       	// "seqan-1.3.1/seqan/index/index_base.h"(322)

//____________________________________________________________________________
// FibreRawText_

struct FibreRawText_;       	// "seqan-1.3.1/seqan/index/index_base.h"(320)

//____________________________________________________________________________
// FibreRecord

struct FibreRecord;       	// "seqan-1.3.1/seqan/index/index_base.h"(203)

//____________________________________________________________________________
// FibreSADir_

struct FibreSADir_;       	// "seqan-1.3.1/seqan/index/index_qgram.h"(104)

//____________________________________________________________________________
// FibreSA_

struct FibreSA_;       	// "seqan-1.3.1/seqan/index/index_base.h"(321)

//____________________________________________________________________________
// FibreSae_

struct FibreSae_;       	// "seqan-1.3.1/seqan/index/index_base.h"(323)

//____________________________________________________________________________
// FibreText_

struct FibreText_;       	// "seqan-1.3.1/seqan/index/index_base.h"(319)

//____________________________________________________________________________
// Fibre_Shape_

struct Fibre_Shape_;       	// "seqan-1.3.1/seqan/index/index_qgram.h"(105)

//____________________________________________________________________________
// FinderLcpe_

struct FinderLcpe_;       	// "seqan-1.3.1/seqan/index/index_base.h"(86)

//____________________________________________________________________________
// FinderMlr_

struct FinderMlr_;       	// "seqan-1.3.1/seqan/index/index_base.h"(85)

//____________________________________________________________________________
// FinderQGramLookup_

struct FinderQGramLookup_;       	// "seqan-1.3.1/seqan/index/find_index_qgram.h"(44)

//____________________________________________________________________________
// FinderSTree_

struct FinderSTree_;       	// "seqan-1.3.1/seqan/index/index_base.h"(87)

//____________________________________________________________________________
// FractionCompound_

template <typename TValue, typename TSize> struct FractionCompound_;       	// "seqan-1.3.1/seqan/index/index_esa_algs.h"(297)

//____________________________________________________________________________
// FractionHeader_

template <typename TSize> struct FractionHeader_;       	// "seqan-1.3.1/seqan/index/index_esa_algs.h"(286)

//____________________________________________________________________________
// FractionMultiCompound_

template <typename TValue, typename TSize> struct FractionMultiCompound_;       	// "seqan-1.3.1/seqan/index/index_esa_algs_multi.h"(166)

//____________________________________________________________________________
// FunctorGlobalize

template <typename InType, typename TLimitsString, typename Result > struct FunctorGlobalize;       	// "seqan-1.3.1/seqan/index/index_base.h"(481)

//____________________________________________________________________________
// GappedShape

template <typename TSpec> struct GappedShape;       	// "seqan-1.3.1/seqan/index/shape_base.h"(46)

//____________________________________________________________________________
// GetVSTreeIteratorTraits

template <typename TIterator> struct GetVSTreeIteratorTraits;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(169)

//____________________________________________________________________________
// Hamming_

struct Hamming_;       	// "seqan-1.3.1/seqan/index/find_swift.h"(100)

//____________________________________________________________________________
// HardwiredShape

template <int P00 , int P01 , int P02 , int P03 , int P04 , int P05 , int P06 , int P07 , int P08 , int P09 , int P10 , int P11 , int P12 , int P13 , int P14 , int P15 , int P16 , int P17 , int P18 , int P19 > struct HardwiredShape;       	// "seqan-1.3.1/seqan/index/shape_gapped.h"(66)

//____________________________________________________________________________
// HideEmptyEdges

struct HideEmptyEdges;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(121)

//____________________________________________________________________________
// HistoryStackEntry_

template <typename TVSTreeIter > struct HistoryStackEntry_;       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(186)

//____________________________________________________________________________
// HistoryStackEsa_

template <typename TSize> struct HistoryStackEsa_;       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(190)

//____________________________________________________________________________
// HistoryStackWotdModified_

template <typename TSize> struct HistoryStackWotdModified_;       	// "seqan-1.3.1/seqan/index/index_wotd.h"(296)

//____________________________________________________________________________
// HistoryStackWotdOriginal_

template <typename TSize> struct HistoryStackWotdOriginal_;       	// "seqan-1.3.1/seqan/index/index_wotd.h"(289)

//____________________________________________________________________________
// Index

template <typename TObject, typename TSpec > class Index;       	// "seqan-1.3.1/seqan/index/find_swift.h"(90)
template <typename TObject, typename TSpec > class Index;       	// "seqan-1.3.1/seqan/index/index_base.h"(163)

//____________________________________________________________________________
// IndexEsa

template <typename TSpec > struct IndexEsa;       	// "seqan-1.3.1/seqan/index/index_base.h"(94)

//____________________________________________________________________________
// IndexQGram

template <typename TShapeSpec, typename TSpec > struct IndexQGram;       	// "seqan-1.3.1/seqan/index/index_qgram.h"(151)

//____________________________________________________________________________
// IndexWotd

template <typename TSpec > struct IndexWotd;       	// "seqan-1.3.1/seqan/index/index_wotd.h"(101)

//____________________________________________________________________________
// InvalidPizzaChiliSpec

struct InvalidPizzaChiliSpec;       	// "seqan-1.3.1/seqan/index/pizzachili_api.h"(51)

//____________________________________________________________________________
// Kasai

struct Kasai;       	// "seqan-1.3.1/seqan/index/index_lcp.h"(44)
struct Kasai;       	// "seqan-1.3.1/seqan/index/index_base.h"(55)

//____________________________________________________________________________
// KasaiOriginal

struct KasaiOriginal;       	// "seqan-1.3.1/seqan/index/index_lcp.h"(45)
struct KasaiOriginal;       	// "seqan-1.3.1/seqan/index/index_base.h"(56)

//____________________________________________________________________________
// LarssonSadakane

struct LarssonSadakane;       	// "seqan-1.3.1/seqan/index/index_sa_lss.h"(360)
struct LarssonSadakane;       	// "seqan-1.3.1/seqan/index/index_base.h"(49)

//____________________________________________________________________________
// LcpConfig

struct LcpConfig;       	// "seqan-1.3.1/seqan/index/pump_lcp_core.h"(45)

//____________________________________________________________________________
// LcpCreatorRandomAccess_

template <typename TLCP, typename TText, typename TSA, typename TAlgSpec > struct LcpCreatorRandomAccess_;       	// "seqan-1.3.1/seqan/index/index_base.h"(255)

//____________________________________________________________________________
// LeftCompleteTree

struct LeftCompleteTree;       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(54)

//____________________________________________________________________________
// MSufSort

struct MSufSort;       	// "seqan-1.3.1/seqan/index/index_shawarma.h"(54)

//____________________________________________________________________________
// ManberMyers

struct ManberMyers;       	// "seqan-1.3.1/seqan/index/index_sa_mm.h"(41)
struct ManberMyers;       	// "seqan-1.3.1/seqan/index/index_base.h"(50)

//____________________________________________________________________________
// MaxRepeat

template <typename TSTree> struct MaxRepeat;       	// "seqan-1.3.1/seqan/index/index_esa_algs.h"(666)

//____________________________________________________________________________
// MaxRepeatOccurrences

struct MaxRepeatOccurrences;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(152)

//____________________________________________________________________________
// MaxRepeats_

template <typename TSpec > struct MaxRepeats_;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(126)

//____________________________________________________________________________
// Merger3

struct Merger3;       	// "seqan-1.3.1/seqan/index/pipe_merger3.h"(44)

//____________________________________________________________________________
// Merger7

struct Merger7;       	// "seqan-1.3.1/seqan/index/pipe_merger7.h"(162)

//____________________________________________________________________________
// Merger7Multi

template <typename TLimitsString> struct Merger7Multi;       	// "seqan-1.3.1/seqan/index/pipe_merger7.h"(171)

//____________________________________________________________________________
// MultiMem

template <typename TSTree> struct MultiMem;       	// "seqan-1.3.1/seqan/index/index_esa_algs_multi.h"(425)

//____________________________________________________________________________
// MultiMemOccurences

struct MultiMemOccurences;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(154)

//____________________________________________________________________________
// MultiMems_

struct MultiMems_;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(127)

//____________________________________________________________________________
// Mums

struct Mums;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(149)

//____________________________________________________________________________
// OneGappedShape

struct OneGappedShape;       	// "seqan-1.3.1/seqan/index/shape_onegapped.h"(71)

//____________________________________________________________________________
// OpenAddressing_

struct OpenAddressing_;       	// "seqan-1.3.1/seqan/index/index_qgram_openaddressing.h"(41)

//____________________________________________________________________________
// ParentLinks

template <typename TSpec > struct ParentLinks;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(141)

//____________________________________________________________________________
// Pipe

template <typename TInput, typename TSpec > struct Pipe;       	// "seqan-1.3.1/seqan/index/find_swift.h"(332)

//____________________________________________________________________________
// PizzaChili

template <typename TSpec> struct PizzaChili;       	// "seqan-1.3.1/seqan/index/index_pizzachili_string.h"(62)

//____________________________________________________________________________
// PizzaChiliAF_

struct PizzaChiliAF_;       	// "seqan-1.3.1/seqan/index/pizzachili_api.h"(82)

//____________________________________________________________________________
// PizzaChiliCcsa_

struct PizzaChiliCcsa_;       	// "seqan-1.3.1/seqan/index/pizzachili_api.h"(85)

//____________________________________________________________________________
// PizzaChiliCodeProvider

template <typename TSpec> struct PizzaChiliCodeProvider;       	// "seqan-1.3.1/seqan/index/pizzachili_api.h"(54)

//____________________________________________________________________________
// PizzaChiliFM_

struct PizzaChiliFM_;       	// "seqan-1.3.1/seqan/index/pizzachili_api.h"(88)

//____________________________________________________________________________
// PizzaChiliFinder_

struct PizzaChiliFinder_;       	// "seqan-1.3.1/seqan/index/index_pizzachili_find.h"(40)

//____________________________________________________________________________
// PizzaChiliLZ_

struct PizzaChiliLZ_;       	// "seqan-1.3.1/seqan/index/pizzachili_api.h"(91)

//____________________________________________________________________________
// PizzaChiliRlfm_

struct PizzaChiliRlfm_;       	// "seqan-1.3.1/seqan/index/pizzachili_api.h"(97)

//____________________________________________________________________________
// PizzaChiliRsa_

struct PizzaChiliRsa_;       	// "seqan-1.3.1/seqan/index/pizzachili_api.h"(94)

//____________________________________________________________________________
// PizzaChiliSA_

struct PizzaChiliSA_;       	// "seqan-1.3.1/seqan/index/pizzachili_api.h"(100)

//____________________________________________________________________________
// PizzaChiliSada_

struct PizzaChiliSada_;       	// "seqan-1.3.1/seqan/index/pizzachili_api.h"(103)

//____________________________________________________________________________
// PizzaChiliSsa_

struct PizzaChiliSsa_;       	// "seqan-1.3.1/seqan/index/pizzachili_api.h"(106)

//____________________________________________________________________________
// PizzaChiliTest_

struct PizzaChiliTest_;       	// "seqan-1.3.1/seqan/index/pizzachili_api.h"(109)

//____________________________________________________________________________
// Postorder

struct Postorder;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(116)

//____________________________________________________________________________
// PostorderEmptyEdges

struct PostorderEmptyEdges;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(118)

//____________________________________________________________________________
// Postorder_

struct Postorder_;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(43)

//____________________________________________________________________________
// Preorder

struct Preorder;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(115)

//____________________________________________________________________________
// PreorderEmptyEdges

struct PreorderEmptyEdges;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(117)

//____________________________________________________________________________
// Preorder_

struct Preorder_;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(42)

//____________________________________________________________________________
// QGramAlg

struct QGramAlg;       	// "seqan-1.3.1/seqan/index/index_base.h"(52)

//____________________________________________________________________________
// QGramLessNoCheckOffset_

template <typename TSAValue, typename TText > struct QGramLessNoCheckOffset_;       	// "seqan-1.3.1/seqan/index/index_qgram.h"(801)

//____________________________________________________________________________
// QGramLessNoCheck_

template <typename TSAValue, typename TText > struct QGramLessNoCheck_;       	// "seqan-1.3.1/seqan/index/index_qgram.h"(719)

//____________________________________________________________________________
// QGramLessOffset_

template <typename TSAValue, typename TText > struct QGramLessOffset_;       	// "seqan-1.3.1/seqan/index/index_qgram.h"(655)

//____________________________________________________________________________
// QGramLess_

template <typename TSAValue, typename TText > struct QGramLess_;       	// "seqan-1.3.1/seqan/index/index_qgram.h"(560)

//____________________________________________________________________________
// QSufSort

struct QSufSort;       	// "seqan-1.3.1/seqan/index/index_shawarma.h"(57)

//____________________________________________________________________________
// Quasar_

struct Quasar_;       	// "seqan-1.3.1/seqan/index/find_quasar.h"(47)

//____________________________________________________________________________
// Repeat

template <typename TPos, typename TPeriod> struct Repeat;       	// "seqan-1.3.1/seqan/index/repeat_base.h"(42)

//____________________________________________________________________________
// RepeatFinderParams

template <typename TSize> struct RepeatFinderParams;       	// "seqan-1.3.1/seqan/index/repeat_base.h"(60)

//____________________________________________________________________________
// RepeatLess_

template <typename TPos> struct RepeatLess_;       	// "seqan-1.3.1/seqan/index/repeat_base.h"(95)

//____________________________________________________________________________
// SACreatorRandomAccess_

template <typename TSA, typename TText, typename TAlgSpec > struct SACreatorRandomAccess_;       	// "seqan-1.3.1/seqan/index/index_base.h"(243)

//____________________________________________________________________________
// SAQSort

struct SAQSort;       	// "seqan-1.3.1/seqan/index/index_sa_qsort.h"(41)
struct SAQSort;       	// "seqan-1.3.1/seqan/index/index_base.h"(51)

//____________________________________________________________________________
// SAValue

template <typename TObject > struct SAValue;       	// "seqan-1.3.1/seqan/index/find_swift.h"(91)
template <typename TObject> struct SAValue;       	// "seqan-1.3.1/seqan/index/index_base.h"(371)

//____________________________________________________________________________
// SAValueLess_

template <typename TOccValue> struct SAValueLess_;       	// "seqan-1.3.1/seqan/index/index_shims.h"(519)

//____________________________________________________________________________
// SearchTreeIterator

template <typename TString, typename TSpec > class SearchTreeIterator;       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(60)

//____________________________________________________________________________
// SensitivityDPState_

template <typename TDistance, typename TFloat> struct SensitivityDPState_;       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(195)

//____________________________________________________________________________
// Shape

template <typename TValue , typename TSpec > class Shape;       	// "seqan-1.3.1/seqan/index/shape_base.h"(69)

//____________________________________________________________________________
// Shawarma

template <typename TSpec> struct Shawarma;       	// "seqan-1.3.1/seqan/index/index_shawarma.h"(52)

//____________________________________________________________________________
// Skew3

struct Skew3;       	// "seqan-1.3.1/seqan/index/index_skew3.h"(44)
struct Skew3;       	// "seqan-1.3.1/seqan/index/index_base.h"(47)

//____________________________________________________________________________
// Skew7

struct Skew7;       	// "seqan-1.3.1/seqan/index/index_skew7.h"(44)
struct Skew7;       	// "seqan-1.3.1/seqan/index/index_base.h"(48)

//____________________________________________________________________________
// Skew7StringSpec_

template <typename T> struct Skew7StringSpec_;       	// "seqan-1.3.1/seqan/index/index_skew7.h"(189)

//____________________________________________________________________________
// SkewDCStream

template <typename TValue> struct SkewDCStream;       	// "seqan-1.3.1/seqan/index/pipe_merger7.h"(85)

//____________________________________________________________________________
// SkewNIndex_

template <int I, typename T > struct SkewNIndex_;       	// "seqan-1.3.1/seqan/index/pipe_merger7.h"(48)

//____________________________________________________________________________
// SkewShift_

template <int I, typename T > struct SkewShift_;       	// "seqan-1.3.1/seqan/index/pipe_merger7.h"(45)

//____________________________________________________________________________
// SortedList

struct SortedList;       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(53)

//____________________________________________________________________________
// SuffixLessOffset_

template <typename TSAValue, typename TText > struct SuffixLessOffset_;       	// "seqan-1.3.1/seqan/index/index_sa_qsort.h"(126)

//____________________________________________________________________________
// SuffixLess_

template <typename TSAValue, typename TText > struct SuffixLess_;       	// "seqan-1.3.1/seqan/index/index_sa_qsort.h"(47)

//____________________________________________________________________________
// SuperMaxRepeats

struct SuperMaxRepeats;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(147)

//____________________________________________________________________________
// SuperMaxRepeatsFast

struct SuperMaxRepeatsFast;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(148)

//____________________________________________________________________________
// Swift

template <typename TSpec > struct Swift;       	// "seqan-1.3.1/seqan/index/find_swift.h"(105)

//____________________________________________________________________________
// SwiftBucketParams_

template <typename TSpec, typename TSize_, typename TShortSize_ > struct SwiftBucketParams_;       	// "seqan-1.3.1/seqan/index/find_swift.h"(181)

//____________________________________________________________________________
// SwiftBucket_

template <typename TSpec, typename TSize_, typename TShortSize_ > struct SwiftBucket_;       	// "seqan-1.3.1/seqan/index/find_swift.h"(151)

//____________________________________________________________________________
// SwiftHit_

template <typename TSpec, typename THstkPos> struct SwiftHit_;       	// "seqan-1.3.1/seqan/index/find_swift.h"(215)

//____________________________________________________________________________
// SwiftLocal_

struct SwiftLocal_;       	// "seqan-1.3.1/seqan/index/find_swift.h"(93)

//____________________________________________________________________________
// SwiftParameters

struct SwiftParameters;       	// "seqan-1.3.1/seqan/index/find_swift.h"(134)

//____________________________________________________________________________
// SwiftSemiGlobal_

template <typename TSpec > struct SwiftSemiGlobal_;       	// "seqan-1.3.1/seqan/index/find_swift.h"(97)

//____________________________________________________________________________
// TRepeatFinder

struct TRepeatFinder;       	// "seqan-1.3.1/seqan/index/repeat_base.h"(66)

//____________________________________________________________________________
// ThreshDPState_

template <typename TDistance> struct ThreshDPState_;       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(215)

//____________________________________________________________________________
// ThreshExact_

struct ThreshExact_;       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(42)

//____________________________________________________________________________
// ThreshHeuristic_

struct ThreshHeuristic_;       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(43)

//____________________________________________________________________________
// ThreshQGramLemma_

struct ThreshQGramLemma_;       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(41)

//____________________________________________________________________________
// TopDown

template <typename TSpec > struct TopDown;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(137)

//____________________________________________________________________________
// TranslateTableErrorToAscii_

template <typename T > struct TranslateTableErrorToAscii_;       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(143)

//____________________________________________________________________________
// UngappedShape

template <unsigned q> struct UngappedShape;       	// "seqan-1.3.1/seqan/index/shape_base.h"(42)

//____________________________________________________________________________
// VSTree

template <typename TSpec > struct VSTree;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(133)

//____________________________________________________________________________
// VSTreeIteratorTraits

template <typename TDfsOrder , typename THideEmptyEdges > struct VSTreeIteratorTraits;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(46)

//____________________________________________________________________________
// VertexEsa

template <typename TSize> struct VertexEsa;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(174)

//____________________________________________________________________________
// VertexWotdModified_

template <typename TSize> struct VertexWotdModified_;       	// "seqan-1.3.1/seqan/index/index_wotd.h"(241)

//____________________________________________________________________________
// VertexWotdOriginal_

template <typename TSize> struct VertexWotdOriginal_;       	// "seqan-1.3.1/seqan/index/index_wotd.h"(226)

//____________________________________________________________________________
// WotdOriginal_

struct WotdOriginal_;       	// "seqan-1.3.1/seqan/index/index_wotd.h"(97)

//____________________________________________________________________________
// _filterGlobalizer

template <typename InType, typename TLimitsString, typename Result > struct _filterGlobalizer;       	// "seqan-1.3.1/seqan/index/index_bwt.h"(144)

//____________________________________________________________________________
// _mapInverse

template <typename InType, typename Result > struct _mapInverse;       	// "seqan-1.3.1/seqan/index/index_lcp.h"(59)

//____________________________________________________________________________
// _mapInverseMulti

template <typename InType, typename TLimitsString, typename Result > struct _mapInverseMulti;       	// "seqan-1.3.1/seqan/index/index_lcp.h"(164)

//____________________________________________________________________________
// _qgramComp

template <typename InType, typename Result > struct _qgramComp;       	// "seqan-1.3.1/seqan/index/index_qgram.h"(1628)

//____________________________________________________________________________
// _qgramHash

template <typename TValue, typename TResult > struct _qgramHash;       	// "seqan-1.3.1/seqan/index/index_qgram.h"(1663)

//____________________________________________________________________________
// _skew3ExtendComp

template <typename InType, typename Result > struct _skew3ExtendComp;       	// "seqan-1.3.1/seqan/index/index_skew3.h"(121)

//____________________________________________________________________________
// _skew3NComp

template <typename InType, typename Result > struct _skew3NComp;       	// "seqan-1.3.1/seqan/index/index_skew3.h"(63)

//____________________________________________________________________________
// _skew3NMapExtended

template <typename InType, typename Result > struct _skew3NMapExtended;       	// "seqan-1.3.1/seqan/index/index_skew3.h"(115)

//____________________________________________________________________________
// _skew3NMapLinear

template <typename InType, typename Result > struct _skew3NMapLinear;       	// "seqan-1.3.1/seqan/index/index_skew3.h"(86)

//____________________________________________________________________________
// _skew3NMapSliced

template <typename InType, typename Result > struct _skew3NMapSliced;       	// "seqan-1.3.1/seqan/index/index_skew3.h"(94)

//____________________________________________________________________________
// _skew3UnslicerFunc

template <typename InType, typename Result > struct _skew3UnslicerFunc;       	// "seqan-1.3.1/seqan/index/index_skew3.h"(103)

//____________________________________________________________________________
// _skew7ExtendComp

template <typename InType, const int EXT_LENGTH, typename Result > struct _skew7ExtendComp;       	// "seqan-1.3.1/seqan/index/index_skew7.h"(151)

//____________________________________________________________________________
// _skew7GlobalSlicedMulti

template <typename InType, typename TLimitsString, typename TResultSize , typename Result > struct _skew7GlobalSlicedMulti;       	// "seqan-1.3.1/seqan/index/index_skew7_multi.h"(123)

//____________________________________________________________________________
// _skew7NComp

template <typename InType, typename Result > struct _skew7NComp;       	// "seqan-1.3.1/seqan/index/index_skew7.h"(63)

//____________________________________________________________________________
// _skew7NCompMulti

template <typename InType, typename Result > struct _skew7NCompMulti;       	// "seqan-1.3.1/seqan/index/index_skew7_multi.h"(56)

//____________________________________________________________________________
// _skew7NMapExtended

template <typename InType, typename Result > struct _skew7NMapExtended;       	// "seqan-1.3.1/seqan/index/index_skew7.h"(145)

//____________________________________________________________________________
// _skew7NMapLinear

template <typename InType, typename Result > struct _skew7NMapLinear;       	// "seqan-1.3.1/seqan/index/index_skew7.h"(105)

//____________________________________________________________________________
// _skew7NMapSliced

template <typename InType, typename Result > struct _skew7NMapSliced;       	// "seqan-1.3.1/seqan/index/index_skew7.h"(113)

//____________________________________________________________________________
// _skew7UnslicerFunc

template <typename InType, typename Result > struct _skew7UnslicerFunc;       	// "seqan-1.3.1/seqan/index/index_skew7.h"(129)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {
namespace impl {

//____________________________________________________________________________
// error_t

typedef int error_t;       	// "seqan-1.3.1/seqan/index/pizzachili_api.h"(48)

//____________________________________________________________________________
// index_t

typedef void* index_t;       	// "seqan-1.3.1/seqan/index/pizzachili_api.h"(47)

//____________________________________________________________________________
// uchar_t

typedef unsigned char uchar_t;       	// "seqan-1.3.1/seqan/index/pizzachili_api.h"(45)

//____________________________________________________________________________
// ulong_t

typedef unsigned long ulong_t;       	// "seqan-1.3.1/seqan/index/pizzachili_api.h"(46)

} //namespace impl
} //namespace SEQAN_NAMESPACE_MAIN
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// BwtWalkFast

typedef Tag<BwtWalkFast_> const BwtWalkFast;       	// "seqan-1.3.1/seqan/index/index_sa_bwtwalk.h"(56)

//____________________________________________________________________________
// BwtWalkInPlace

typedef Tag<BwtWalkInPlace_> const BwtWalkInPlace;       	// "seqan-1.3.1/seqan/index/index_sa_bwtwalk.h"(59)

//____________________________________________________________________________
// ErrorAlphabet

typedef SimpleType<unsigned char, ErrorAlphabet_> ErrorAlphabet;       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(136)

//____________________________________________________________________________
// EsaBwt

typedef FibreBwt EsaBwt;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(276)

//____________________________________________________________________________
// EsaChildtab

typedef FibreChildtab EsaChildtab;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(275)

//____________________________________________________________________________
// EsaFindLcpe

typedef Tag<FinderLcpe_> const EsaFindLcpe;       	// "seqan-1.3.1/seqan/index/index_base.h"(90)

//____________________________________________________________________________
// EsaFindMlr

typedef Tag<FinderMlr_> const EsaFindMlr;       	// "seqan-1.3.1/seqan/index/index_base.h"(89)

//____________________________________________________________________________
// EsaLcp

typedef FibreLcp EsaLcp;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(273)

//____________________________________________________________________________
// EsaLcpe

typedef FibreLcpe EsaLcpe;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(274)

//____________________________________________________________________________
// EsaRawSA

typedef FibreRawSA EsaRawSA;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(271)

//____________________________________________________________________________
// EsaRawText

typedef FibreRawText EsaRawText;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(269)

//____________________________________________________________________________
// EsaSA

typedef FibreSA EsaSA;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(270)

//____________________________________________________________________________
// EsaSae

typedef FibreSae EsaSae;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(272)

//____________________________________________________________________________
// EsaText

typedef FibreText EsaText;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(268)

//____________________________________________________________________________
// FibreBucketMap

typedef Tag<FibreBucketMap_> const FibreBucketMap;       	// "seqan-1.3.1/seqan/index/index_qgram.h"(115)

//____________________________________________________________________________
// FibreBwt

typedef Tag<FibreBwt_> const FibreBwt;       	// "seqan-1.3.1/seqan/index/index_base.h"(337)

//____________________________________________________________________________
// FibreChildtab

typedef Tag<FibreChildtab_> const FibreChildtab;       	// "seqan-1.3.1/seqan/index/index_base.h"(336)

//____________________________________________________________________________
// FibreCounts

typedef Tag<FibreCounts_> const FibreCounts;       	// "seqan-1.3.1/seqan/index/index_qgram.h"(113)

//____________________________________________________________________________
// FibreCountsDir

typedef Tag<FibreCountsDir_> const FibreCountsDir;       	// "seqan-1.3.1/seqan/index/index_qgram.h"(114)

//____________________________________________________________________________
// FibreDir

typedef Tag<FibreDir_> const FibreDir;       	// "seqan-1.3.1/seqan/index/index_qgram.h"(110)

//____________________________________________________________________________
// FibreLcp

typedef Tag<FibreLcp_> const FibreLcp;       	// "seqan-1.3.1/seqan/index/index_base.h"(334)

//____________________________________________________________________________
// FibreLcpe

typedef Tag<FibreLcpe_> const FibreLcpe;       	// "seqan-1.3.1/seqan/index/index_base.h"(335)

//____________________________________________________________________________
// FibrePizzaChiliCompressed

typedef Tag<FibrePizzaChiliCompressed_> const FibrePizzaChiliCompressed;       	// "seqan-1.3.1/seqan/index/index_pizzachili.h"(59)

//____________________________________________________________________________
// FibrePizzaChiliText

typedef Tag<FibreText_> const FibrePizzaChiliText;       	// "seqan-1.3.1/seqan/index/index_pizzachili.h"(58)

//____________________________________________________________________________
// FibreRawSA

typedef Tag<FibreRawSA_> const FibreRawSA;       	// "seqan-1.3.1/seqan/index/index_base.h"(332)

//____________________________________________________________________________
// FibreRawText

typedef Tag<FibreRawText_> const FibreRawText;       	// "seqan-1.3.1/seqan/index/index_base.h"(330)

//____________________________________________________________________________
// FibreSA

typedef Tag<FibreSA_> const FibreSA;       	// "seqan-1.3.1/seqan/index/index_base.h"(331)

//____________________________________________________________________________
// FibreSADir

typedef Tag<FibreSADir_> const FibreSADir;       	// "seqan-1.3.1/seqan/index/index_qgram.h"(111)

//____________________________________________________________________________
// FibreSae

typedef Tag<FibreSae_> const FibreSae;       	// "seqan-1.3.1/seqan/index/index_base.h"(333)

//____________________________________________________________________________
// FibreShape

typedef Tag<Fibre_Shape_> const FibreShape;       	// "seqan-1.3.1/seqan/index/index_qgram.h"(112)

//____________________________________________________________________________
// FibreText

typedef Tag<FibreText_> const FibreText;       	// "seqan-1.3.1/seqan/index/index_base.h"(329)

//____________________________________________________________________________
// FinderSTree

typedef Tag<FinderSTree_> const FinderSTree;       	// "seqan-1.3.1/seqan/index/index_base.h"(91)

//____________________________________________________________________________
// GenericShape

typedef GappedShape<Default> GenericShape;       	// "seqan-1.3.1/seqan/index/shape_base.h"(47)

//____________________________________________________________________________
// MaxRepeats

typedef MaxRepeats_<void> MaxRepeats;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(151)

//____________________________________________________________________________
// MultiMems

typedef MaxRepeats_<MultiMems_> MultiMems;       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(153)

//____________________________________________________________________________
// OpenAddressing

typedef Tag<OpenAddressing_> OpenAddressing;       	// "seqan-1.3.1/seqan/index/index_qgram_openaddressing.h"(42)

//____________________________________________________________________________
// PizzaChiliAF

typedef Tag<PizzaChiliAF_> const PizzaChiliAF;       	// "seqan-1.3.1/seqan/index/pizzachili_api.h"(83)

//____________________________________________________________________________
// PizzaChiliCcsa

typedef Tag<PizzaChiliCcsa_> const PizzaChiliCcsa;       	// "seqan-1.3.1/seqan/index/pizzachili_api.h"(86)

//____________________________________________________________________________
// PizzaChiliCompressed

typedef FibrePizzaChiliCompressed PizzaChiliCompressed;       	// "seqan-1.3.1/seqan/index/index_pizzachili.h"(62)

//____________________________________________________________________________
// PizzaChiliFM

typedef Tag<PizzaChiliFM_> const PizzaChiliFM;       	// "seqan-1.3.1/seqan/index/pizzachili_api.h"(89)

//____________________________________________________________________________
// PizzaChiliFinder

typedef Tag<PizzaChiliFinder_> const PizzaChiliFinder;       	// "seqan-1.3.1/seqan/index/index_pizzachili_find.h"(51)

//____________________________________________________________________________
// PizzaChiliLZ

typedef Tag<PizzaChiliLZ_> const PizzaChiliLZ;       	// "seqan-1.3.1/seqan/index/pizzachili_api.h"(92)

//____________________________________________________________________________
// PizzaChiliRlfm

typedef Tag<PizzaChiliRlfm_> const PizzaChiliRlfm;       	// "seqan-1.3.1/seqan/index/pizzachili_api.h"(98)

//____________________________________________________________________________
// PizzaChiliRsa

typedef Tag<PizzaChiliRsa_> const PizzaChiliRsa;       	// "seqan-1.3.1/seqan/index/pizzachili_api.h"(95)

//____________________________________________________________________________
// PizzaChiliSA

typedef Tag<PizzaChiliSA_> const PizzaChiliSA;       	// "seqan-1.3.1/seqan/index/pizzachili_api.h"(101)

//____________________________________________________________________________
// PizzaChiliSada

typedef Tag<PizzaChiliSada_> const PizzaChiliSada;       	// "seqan-1.3.1/seqan/index/pizzachili_api.h"(104)

//____________________________________________________________________________
// PizzaChiliSsa

typedef Tag<PizzaChiliSsa_> const PizzaChiliSsa;       	// "seqan-1.3.1/seqan/index/pizzachili_api.h"(107)

//____________________________________________________________________________
// PizzaChiliTest

typedef Tag<PizzaChiliTest_> const PizzaChiliTest;       	// "seqan-1.3.1/seqan/index/pizzachili_api.h"(110)

//____________________________________________________________________________
// PizzaChiliText

typedef FibrePizzaChiliText PizzaChiliText;       	// "seqan-1.3.1/seqan/index/index_pizzachili.h"(61)

//____________________________________________________________________________
// QGramBucketMap

typedef FibreBucketMap QGramBucketMap;       	// "seqan-1.3.1/seqan/index/index_qgram.h"(128)

//____________________________________________________________________________
// QGramCounts

typedef FibreCounts QGramCounts;       	// "seqan-1.3.1/seqan/index/index_qgram.h"(126)

//____________________________________________________________________________
// QGramCountsDir

typedef FibreCountsDir QGramCountsDir;       	// "seqan-1.3.1/seqan/index/index_qgram.h"(127)

//____________________________________________________________________________
// QGramDir

typedef FibreDir QGramDir;       	// "seqan-1.3.1/seqan/index/index_qgram.h"(123)

//____________________________________________________________________________
// QGramFindLookup

typedef Tag<FinderQGramLookup_> const QGramFindLookup;       	// "seqan-1.3.1/seqan/index/find_index_qgram.h"(53)

//____________________________________________________________________________
// QGramRawSA

typedef FibreRawSA QGramRawSA;       	// "seqan-1.3.1/seqan/index/index_qgram.h"(122)

//____________________________________________________________________________
// QGramSA

typedef FibreSA QGramSA;       	// "seqan-1.3.1/seqan/index/index_qgram.h"(121)

//____________________________________________________________________________
// QGramSADir

typedef FibreSADir QGramSADir;       	// "seqan-1.3.1/seqan/index/index_qgram.h"(124)

//____________________________________________________________________________
// QGramShape

typedef FibreShape QGramShape;       	// "seqan-1.3.1/seqan/index/index_qgram.h"(125)

//____________________________________________________________________________
// QGramText

typedef FibreText QGramText;       	// "seqan-1.3.1/seqan/index/index_qgram.h"(119)

//____________________________________________________________________________
// QGram_RawText

typedef FibreRawText QGram_RawText;       	// "seqan-1.3.1/seqan/index/index_qgram.h"(120)

//____________________________________________________________________________
// Quasar

typedef Tag<Quasar_> Quasar;       	// "seqan-1.3.1/seqan/index/find_quasar.h"(48)

//____________________________________________________________________________
// SimpleShape

typedef UngappedShape<0> SimpleShape;       	// "seqan-1.3.1/seqan/index/shape_base.h"(43)

//____________________________________________________________________________
// SwiftLocal

typedef Tag<SwiftLocal_> SwiftLocal;       	// "seqan-1.3.1/seqan/index/find_swift.h"(94)

//____________________________________________________________________________
// SwiftSemiGlobal

typedef Tag<SwiftSemiGlobal_<void> > SwiftSemiGlobal;       	// "seqan-1.3.1/seqan/index/find_swift.h"(98)

//____________________________________________________________________________
// SwiftSemiGlobalHamming

typedef Tag<SwiftSemiGlobal_<Hamming_> > SwiftSemiGlobalHamming;       	// "seqan-1.3.1/seqan/index/find_swift.h"(101)

//____________________________________________________________________________
// ThreshExact

typedef Tag<ThreshExact_> const  ThreshExact;       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(47)

//____________________________________________________________________________
// ThreshHeuristic

typedef Tag<ThreshHeuristic_> const ThreshHeuristic;       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(46)

//____________________________________________________________________________
// ThreshQGramLemma

typedef Tag<ThreshQGramLemma_> const ThreshQGramLemma;       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(45)

//____________________________________________________________________________
// WotdDir

typedef FibreDir WotdDir;       	// "seqan-1.3.1/seqan/index/index_wotd.h"(76)

//____________________________________________________________________________
// WotdOriginal

typedef Tag<WotdOriginal_> const WotdOriginal;       	// "seqan-1.3.1/seqan/index/index_wotd.h"(98)

//____________________________________________________________________________
// WotdRawSA

typedef FibreRawSA WotdRawSA;       	// "seqan-1.3.1/seqan/index/index_wotd.h"(75)

//____________________________________________________________________________
// WotdRawText

typedef FibreRawText WotdRawText;       	// "seqan-1.3.1/seqan/index/index_wotd.h"(73)

//____________________________________________________________________________
// WotdSA

typedef FibreSA WotdSA;       	// "seqan-1.3.1/seqan/index/index_wotd.h"(74)

//____________________________________________________________________________
// WotdText

typedef FibreText WotdText;       	// "seqan-1.3.1/seqan/index/index_wotd.h"(72)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {
namespace impl {

//____________________________________________________________________________
// clearIndex

template <typename TText, typename TSpec> inline void clearIndex(Index<TText, PizzaChili<TSpec> >& me);       	// "seqan-1.3.1/seqan/index/index_pizzachili.h"(148)

//____________________________________________________________________________
// createPizzaChiliIndex

template <typename TText, typename TSpec> inline bool createPizzaChiliIndex( Index<TText, PizzaChili<TSpec> >& me, uchar_t* textstart, ulong_t textlength );       	// "seqan-1.3.1/seqan/index/index_pizzachili.h"(272)

//____________________________________________________________________________
// getOptionsString

template <typename TText, typename TSpec> inline char const* getOptionsString(Index<TText, PizzaChili<TSpec> >& );       	// "seqan-1.3.1/seqan/index/index_pizzachili.h"(178)
template <typename TText> inline char const* getOptionsString(Index<TText, PizzaChili<PizzaChiliSA> >& );       	// "seqan-1.3.1/seqan/index/index_pizzachili.h"(185)
template <typename TText> inline char const* getOptionsString(Index<TText, PizzaChili<PizzaChiliFM> >& );       	// "seqan-1.3.1/seqan/index/index_pizzachili.h"(192)
template <typename TText> inline char const* getOptionsString(Index<TText, PizzaChili<PizzaChiliRsa> >& );       	// "seqan-1.3.1/seqan/index/index_pizzachili.h"(199)

//____________________________________________________________________________
// getPizzaChiliString

template <typename TPattern> inline uchar_t* getPizzaChiliString(TPattern const& pattern);       	// "seqan-1.3.1/seqan/index/index_pizzachili_find.h"(107)
inline uchar_t* getPizzaChiliString(char const* pattern);       	// "seqan-1.3.1/seqan/index/index_pizzachili_find.h"(125)

//____________________________________________________________________________
// queryText

template <typename TValue, typename TSpec> inline void queryText(String<TValue, PizzaChili<TSpec> > const& me);       	// "seqan-1.3.1/seqan/index/index_pizzachili_string.h"(434)

} //namespace impl
} //namespace SEQAN_NAMESPACE_MAIN
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _adjustRightBorder

template <typename TText, typename TSpec > inline void _adjustRightBorder( Iter< Index<TText, IndexWotd<WotdOriginal> >, VSTree< TopDown<TSpec> > > &);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(631)
template <typename TText, typename TIndexSpec, typename TSpec > inline void _adjustRightBorder( Iter< Index<TText, IndexWotd<TIndexSpec> >, VSTree< TopDown<TSpec> > > &it);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(637)

//____________________________________________________________________________
// _approximateStringSearch

template <typename TOnFoundFunctor, typename TString, typename TStringPos, typename TTreeIterator, typename TIterPos, typename TErrors > inline void _approximateStringSearch( TOnFoundFunctor &onFoundFunctor, TString const &string, TStringPos stringPos, TTreeIterator iter, TIterPos iterPos, TErrors errorsLeft);       	// "seqan-1.3.1/seqan/index/find_index_approx.h"(150)

//____________________________________________________________________________
// _approximateTreeSearch

template <bool enumerateA, bool enumerateB, typename TOnFoundFunctor, typename TTreeIteratorA, typename TIterPosA, typename TTreeIteratorB, typename TIterPosB, typename TErrors > inline void _approximateTreeSearch( TOnFoundFunctor &onFoundFunctor, TTreeIteratorA iterA, TIterPosA iterPosA, TTreeIteratorB iterB_, TIterPosB iterPosB, TErrors  errorsLeft);       	// "seqan-1.3.1/seqan/index/find_index_approx.h"(76)

//____________________________________________________________________________
// _bucketLcp

template <typename TSA, typename TText > typename Size<TText>::Type _bucketLcp(TSA const &sa, TText const &text);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(1444)
template <typename TSA, typename TText, typename TSize > typename Size<TText>::Type _bucketLcp(TSA const &sa, TText const &text, TSize prefixLen);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(1478)
template <typename TSA, typename TText, typename TSpec, typename TSize > typename Size<TText>::Type _bucketLcp(TSA const &sa, StringSet<TText, TSpec> const &stringSet, TSize prefixLen);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(1510)

//____________________________________________________________________________
// _childtabProcess

template <typename TLCPInput, typename TDest > inline void _childtabProcess(TLCPInput &lcpIn, TDest &dest);       	// "seqan-1.3.1/seqan/index/index_childtab.h"(58)

//____________________________________________________________________________
// _copySwiftHit

template <typename TFinder, typename TIndex, typename TSpec> inline void _copySwiftHit( TFinder &finder, Pattern<TIndex, Swift<TSpec> > &pattern);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1648)
template <typename TFinder, typename TIndex, typename TSpec> inline void _copySwiftHit( TFinder &finder, Pattern<TIndex, Swift<Tag<SwiftSemiGlobal_<TSpec> > > > &pattern);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1659)

//____________________________________________________________________________
// _createBWTableWrapper

template <typename TBWT, typename TText, typename TSA, typename TTextRandom_ > inline void _createBWTableWrapper(TBWT &bwt, TText const &s, TSA const &sa, TTextRandom_ const);       	// "seqan-1.3.1/seqan/index/index_shims.h"(494)
template <typename TBWT, typename TText, typename TSA > inline void _createBWTableWrapper(TBWT &bwt, TText const &s, TSA const &sa, True const);       	// "seqan-1.3.1/seqan/index/index_shims.h"(502)

//____________________________________________________________________________
// _createHit

template <typename THaystack, typename TIndex, typename TSpec, typename TBucket, typename TBucketParams, typename TSize > inline void _createHit( Finder<THaystack, Swift<TSpec> > & finder, Pattern<TIndex, Swift<TSpec> > & pattern, TBucket & bkt, TBucketParams & bucketParams, __int64 diag, TSize ndlSeqNo);       	// "seqan-1.3.1/seqan/index/find_swift.h"(828)

//____________________________________________________________________________
// _createLCPTablePipelining

template <typename TLCPTable, typename TObject, typename TSA, typename TAlgSpec > void _createLCPTablePipelining( TLCPTable &LCP, TObject const &text, TSA const &suffixArray, TAlgSpec const);       	// "seqan-1.3.1/seqan/index/index_shims.h"(223)
template <typename TLCPTable, typename TString, typename TSpec, typename TSA, typename TAlgSpec > void _createLCPTablePipelining( TLCPTable &LCP, StringSet<TString, TSpec> const &stringSet, TSA const &suffixArray, TAlgSpec const);       	// "seqan-1.3.1/seqan/index/index_shims.h"(254)

//____________________________________________________________________________
// _createLCPTableRandomAccess

template <typename TLCPTable, typename TText, typename TSA > void _createLCPTableRandomAccess( TLCPTable &LCP, TText const &s, TSA const &SA, KasaiOriginal const);       	// "seqan-1.3.1/seqan/index/index_lcp.h"(282)
template <typename TLCPTable, typename TText, typename TSA > void _createLCPTableRandomAccess( TLCPTable &LCP, TText const &s, TSA const &SA, Kasai const);       	// "seqan-1.3.1/seqan/index/index_lcp.h"(346)
template <typename TLCPTable, typename TString, typename TSpec, typename TSA > void _createLCPTableRandomAccess( TLCPTable &LCP, StringSet<TString, TSpec> const &sset, TSA const &SA, Kasai const);       	// "seqan-1.3.1/seqan/index/index_lcp.h"(431)

//____________________________________________________________________________
// _createLCPTableWrapper

template <typename TLCP, typename TText, typename TSA, typename TAlgSpec > inline void _createLCPTableWrapper( TLCP &lcp, TText const &s, TSA const &sa, TAlgSpec const &alg, True);       	// "seqan-1.3.1/seqan/index/index_shims.h"(304)
template <typename TLCP, typename TText, typename TSA, typename TAlgSpec > inline void _createLCPTableWrapper( TLCP &lcp, TText const &s, TSA const &sa, TAlgSpec const &alg, False);       	// "seqan-1.3.1/seqan/index/index_shims.h"(320)

//____________________________________________________________________________
// _createSuffixArray

template <typename TSA, typename TText > inline void _createSuffixArray( TSA &SA, TText const &s, BwtWalk<BwtWalkFast> const &, True const &);       	// "seqan-1.3.1/seqan/index/index_sa_bwtwalk.h"(140)
template <typename TSA, typename TText > inline void _createSuffixArray( TSA &SA, TText const& s, BwtWalk<BwtWalkFast> const &, False const &);       	// "seqan-1.3.1/seqan/index/index_sa_bwtwalk.h"(175)
template <typename TSA, typename TText > inline void _createSuffixArray( TSA &SA, TText const &s, BwtWalk<BwtWalkInPlace> const &, False const &);       	// "seqan-1.3.1/seqan/index/index_sa_bwtwalk.h"(209)
template <typename TSA, typename TText, typename TValue, typename TArray > inline void _createSuffixArray( TSA &SA, TArray & lexxorpos, TValue & p, TText const &s, TValue const & NIL, TValue const &, TValue const &, BwtWalk<BwtWalkInPlace> const &, True const &, True const &);       	// "seqan-1.3.1/seqan/index/index_sa_bwtwalk.h"(255)
template <typename TSA, typename TText, typename TValue, typename TArray > inline void _createSuffixArray( TSA &SA, TArray & lexxorpos, TValue & p, TText const &s, TValue const & NIL, TValue const & FLAGBIT, TValue const & NOTFLAGBIT, BwtWalk<BwtWalkInPlace> const &, True const &, False const &);       	// "seqan-1.3.1/seqan/index/index_sa_bwtwalk.h"(304)
template <typename TSA, typename TText > inline void _createSuffixArray( TSA &SA, TText const &s, BwtWalk<BwtWalkInPlace> const &, True const &);       	// "seqan-1.3.1/seqan/index/index_sa_bwtwalk.h"(382)

//____________________________________________________________________________
// _createSuffixArrayHandleTooLongSuffixArrayType

template <typename TSA, typename TText, typename TValue, typename TArray > inline void _createSuffixArrayHandleTooLongSuffixArrayType( TSA &SA, TArray & lexxorpos, TValue & p, TText const &s, TValue const & NIL, TValue const & FLAGBIT, TValue const & NOTFLAGBIT, BwtWalk<BwtWalkInPlace> const &, True const &, True const &);       	// "seqan-1.3.1/seqan/index/index_sa_bwtwalk.h"(350)
template <typename TSA, typename TText, typename TValue, typename TArray > inline void _createSuffixArrayHandleTooLongSuffixArrayType( TSA &SA, TArray & lexxorpos, TValue & p, TText const &s, TValue const & NIL, TValue const & FLAGBIT, TValue const & NOTFLAGBIT, BwtWalk<BwtWalkInPlace> const &, True const &, False const &);       	// "seqan-1.3.1/seqan/index/index_sa_bwtwalk.h"(368)

//____________________________________________________________________________
// _createSuffixArrayPipelining

template <typename TSA, typename TObject, typename TAlgSpec > void _createSuffixArrayPipelining( TSA &suffixArray, TObject const &text, TAlgSpec const);       	// "seqan-1.3.1/seqan/index/index_shims.h"(54)
template <typename TSA, typename TString, typename TSpec, typename TAlgSpec > void _createSuffixArrayPipelining( TSA &suffixArray, StringSet<TString, TSpec> const &stringSet, TAlgSpec const);       	// "seqan-1.3.1/seqan/index/index_shims.h"(88)

//____________________________________________________________________________
// _createSuffixArrayRandomAccess

template <typename TSA, typename TText, typename TAlgSpec > inline void _createSuffixArrayRandomAccess( TSA &sa, TText const &s, TAlgSpec const &alg);       	// "seqan-1.3.1/seqan/index/index_shims.h"(137)

//____________________________________________________________________________
// _createSuffixArrayWrapper

template <typename TSA, typename TText, typename TAlgSpec > inline void _createSuffixArrayWrapper( TSA &sa, TText const &s, TAlgSpec const &alg, True);       	// "seqan-1.3.1/seqan/index/index_shims.h"(155)
template <typename TSA, typename TSequence, typename TSetSpec, typename TAlgSpec > inline void _createSuffixArrayWrapper( TSA &sa, StringSet<TSequence, TSetSpec> const &s, TAlgSpec const &, True);       	// "seqan-1.3.1/seqan/index/index_shims.h"(171)
template <typename TSA, typename TText, typename TAlgSpec > inline void _createSuffixArrayWrapper( TSA &sa, TText const &s, TAlgSpec const &alg, False);       	// "seqan-1.3.1/seqan/index/index_shims.h"(185)

//____________________________________________________________________________
// _createSuffixList

template <typename TArray, typename TText> inline typename Value<TArray>::Type _createSuffixList( TArray &lexprevpos, TArray &lexnextpos, TText const &s);       	// "seqan-1.3.1/seqan/index/index_sa_bwtwalk.h"(444)

//____________________________________________________________________________
// _createXoredSuffixList

template <typename TArray, typename TText> inline typename Value<TArray>::Type _createXoredSuffixList( TArray &lexxorpos, TText const &s);       	// "seqan-1.3.1/seqan/index/index_sa_bwtwalk.h"(539)

//____________________________________________________________________________
// _cutErrorPattern

template <typename TPattern> inline int _cutErrorPattern(TPattern &_pattern);       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(382)

//____________________________________________________________________________
// _dataHost

template <typename TText, typename TSpec> inline Holder<TText> & _dataHost(Index<TText, TSpec> &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(589)
template <typename TText, typename TSpec> inline Holder<TText> const & _dataHost(Index<TText, TSpec> const &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(593)

//____________________________________________________________________________
// _deallocateStorage

template <typename TValue, typename TSpec> inline void _deallocateStorage( String<TValue, PizzaChili<TSpec> >& , TValue* begin, typename Size<String<TValue, PizzaChili<TSpec> > >::Type );       	// "seqan-1.3.1/seqan/index/index_pizzachili_string.h"(385)

//____________________________________________________________________________
// _dfsClear

template <typename TIndex, class TSpec > inline void _dfsClear(Iter<TIndex, VSTree<TSpec> > &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1767)

//____________________________________________________________________________
// _dfsLcp

template <typename TIndex, class TSpec > inline typename Size<TIndex>::Type & _dfsLcp(Iter< TIndex, VSTree< BottomUp<TSpec> > > &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(2275)
template <typename TIndex, class TSpec > inline typename Size<TIndex>::Type _dfsLcp(Iter< TIndex, VSTree< BottomUp<TSpec> > > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(2281)

//____________________________________________________________________________
// _dfsOnLeaf

template <typename TSTree, typename TSpec > inline void _dfsOnLeaf(Iter<TSTree, VSTree< BottomUp<MaxRepeats_<TSpec> > > > &it);       	// "seqan-1.3.1/seqan/index/index_esa_algs.h"(560)
template <typename TIndex, typename TSpec > inline void _dfsOnLeaf(Iter<TIndex, VSTree< BottomUp<TSpec> > > &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(389)
template <typename TSTree > inline void _dfsOnLeaf(Iter<TSTree, VSTree< BottomUp<MultiMems> > > &it);       	// "seqan-1.3.1/seqan/index/index_esa_algs_multi.h"(378)

//____________________________________________________________________________
// _dfsOnPop

template <typename TIndex, typename TSpec, typename TSize > inline void _dfsOnPop(Iter<TIndex, VSTree< BottomUp<TSpec> > > &it, TSize const);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(377)

//____________________________________________________________________________
// _dfsOnPush

template <typename TSTree, typename TElement, typename TSpec > inline void _dfsOnPush(Iter<TSTree, VSTree< BottomUp<MaxRepeats_<TSpec> > > > &it, TElement const &e);       	// "seqan-1.3.1/seqan/index/index_esa_algs.h"(546)
template <typename TIndex, typename TSpec, typename TElement > inline void _dfsOnPush(Iter<TIndex, VSTree< BottomUp<TSpec> > > &it, TElement const &e);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(384)

//____________________________________________________________________________
// _dfsRange

template <typename TIndex, class TSpec > inline Pair<typename Size<TIndex>::Type> & _dfsRange(Iter< TIndex, VSTree< BottomUp<TSpec> > > &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(2262)
template <typename TIndex, class TSpec > inline Pair<typename Size<TIndex>::Type> const & _dfsRange(Iter< TIndex, VSTree< BottomUp<TSpec> > > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(2269)

//____________________________________________________________________________
// _dfsReversedOrder

template <typename TIndex, typename TSpec > inline bool _dfsReversedOrder(Iter<TIndex, VSTree< BottomUp<TSpec> > > &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(371)

//____________________________________________________________________________
// _dump

template <typename TText, typename TSpec> inline void _dump(Index<TText, IndexEsa<TSpec> > &index);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(351)
template <typename TText, typename TPredHull, typename TPred> inline void _dump(Index<TText, IndexWotd< Dfi<TPredHull, TPred> > > &index);       	// "seqan-1.3.1/seqan/index/index_dfi.h"(523)
template <typename TText, typename TSpec> inline void _dump(Index<TText, IndexWotd<TSpec> > &index);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(1784)

//____________________________________________________________________________
// _dumpFreq

template <typename TText, typename TPredHull, typename TPred> inline void _dumpFreq(Index<TText, IndexWotd< Dfi<TPredHull, TPred> > > &index);       	// "seqan-1.3.1/seqan/index/index_dfi.h"(551)

//____________________________________________________________________________
// _dumpHistoryStack

template <typename TIndex, typename TSpec > inline void _dumpHistoryStack(Iter<TIndex, VSTree<TSpec> > &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(342)

//____________________________________________________________________________
// _equalRangeLcpe

template <typename TText, typename TSA, typename TLCP, typename TSpec, typename TQuery > inline Pair< typename Iterator<TSA, Standard>::Type > _equalRangeLcpe( TText &text, TSA &sa, SearchTreeIterator< TLCP, TSpec > treeIter, TQuery &query);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(1517)
template <typename TText, typename TSA, typename TLCP, typename TQuery > inline Pair< typename Iterator<TSA, Standard>::Type > _equalRangeLcpe( TText &text, TSA &sa, TLCP &lcp, TQuery &query);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(1669)

//____________________________________________________________________________
// _equalRangeSA

template <typename TText, typename TSA, typename TSpec, typename TQuery > inline Pair< typename Iterator<TSA, Standard>::Type > _equalRangeSA( TText &text, SearchTreeIterator< TSA, TSpec > treeIter, TQuery &query);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(760)

//____________________________________________________________________________
// _equalRangeSANaive

template <typename TText, typename TSA, typename TSpec, typename TQuery > inline Pair< typename Iterator<TSA, Standard>::Type > _equalRangeSANaive( TText &text, SearchTreeIterator< TSA, TSpec > treeIter, TQuery &query);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(704)

//____________________________________________________________________________
// _findFirstIndex

template <typename TText, typename TSpec, typename TSpecFinder, typename TPattern > inline void _findFirstIndex( Finder< Index<TText, TSpec>, TSpecFinder > &finder, TPattern const &pattern, QGramFindLookup const);       	// "seqan-1.3.1/seqan/index/find_index_qgram.h"(72)
template <typename TText, typename TSpec, typename TSpecFinder, typename TPattern> inline void _findFirstIndex( Finder<Index<TText, PizzaChili<TSpec> >, TSpecFinder>& finder, TPattern const& pattern, PizzaChiliFinder const );       	// "seqan-1.3.1/seqan/index/index_pizzachili_find.h"(138)
template <typename TText, typename TSpec, typename TSpecFinder, typename TPattern > inline void _findFirstIndex( Finder< Index<TText, TSpec>, TSpecFinder > &finder, TPattern const &pattern, EsaFindMlr const);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(1897)
template <typename TText, typename TSpec, typename TSpecFinder, typename TPattern > inline void _findFirstIndex( Finder< Index<TText, TSpec>, TSpecFinder > &finder, TPattern const &pattern, EsaFindLcpe const);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(1909)
template <typename TText, typename TSpec, typename TSpecFinder, typename TPattern > inline void _findFirstIndex( Finder< Index<TText, TSpec>, TSpecFinder > &finder, TPattern const &pattern, FinderSTree const);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(1922)

//____________________________________________________________________________
// _findNewCharInsertionPosition

template <typename TArray, typename TValue > inline void _findNewCharInsertionPosition( TArray &lexfirstpos, TArray &lexlastpos, TValue &pMinus, TValue &pPlus, unsigned int cOrd);       	// "seqan-1.3.1/seqan/index/index_sa_bwtwalk.h"(413)

//____________________________________________________________________________
// _firstNonRepeatRange

template <typename TFinder, typename TIndex, typename TSpec> inline bool _firstNonRepeatRange( TFinder &finder, Pattern<TIndex, Swift<TSpec> > &pattern);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1618)

//____________________________________________________________________________
// _fractionMerge

template <typename TSTree, typename TSpec, typename TValue, typename TSize > inline void _fractionMerge( Iter<TSTree, VSTree< BottomUp<TSpec> > > &it, FractionCompound_<TValue, TSize> &parent, FractionCompound_<TValue, TSize> &child);       	// "seqan-1.3.1/seqan/index/index_esa_algs.h"(515)
template <typename TSTree, typename TSpec, typename TValue, typename TSize > inline void _fractionMerge( Iter<TSTree, VSTree< BottomUp<TSpec> > > &it, FractionMultiCompound_<TValue, TSize> &parent, FractionMultiCompound_<TValue, TSize> &child);       	// "seqan-1.3.1/seqan/index/index_esa_algs_multi.h"(357)

//____________________________________________________________________________
// _fullDir2Length

template <typename TIndex> inline __int64 _fullDir2Length(TIndex const &index);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(543)

//____________________________________________________________________________
// _fullDirLength

template <typename TIndex> inline __int64 _fullDirLength(TIndex const &index);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(535)
template <typename TObject, typename TShapeSpec> inline __int64 _fullDirLength(Index<TObject, IndexQGram<TShapeSpec, OpenAddressing> > const &index);       	// "seqan-1.3.1/seqan/index/index_qgram_openaddressing.h"(306)

//____________________________________________________________________________
// _getDown

template <typename TSize, typename TIndex > inline TSize _getDown(TSize i, TIndex const &index);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(2251)

//____________________________________________________________________________
// _getErrorPatternIndex

template <typename TPatternStore, typename TPattern> inline int _getErrorPatternIndex(TPatternStore const &patternStore, TPattern const &pattern);       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(363)

//____________________________________________________________________________
// _getId

template <typename TSize > inline typename Id< VertexEsa<TSize> const >::Type _getId(VertexEsa<TSize> const &desc);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(754)
template <typename TSize > inline typename Id< VertexEsa<TSize> >::Type _getId(VertexEsa<TSize> &desc);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(768)
template <typename TSize > inline typename Id< VertexWotdOriginal_<TSize> const >::Type _getId(VertexWotdOriginal_<TSize> const &desc);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(377)
template <typename TSize > inline typename Id< VertexWotdOriginal_<TSize> >::Type _getId(VertexWotdOriginal_<TSize> &desc);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(384)
template <typename TSize > inline typename Id< VertexWotdModified_<TSize> const >::Type _getId(VertexWotdModified_<TSize> const &desc);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(391)
template <typename TSize > inline typename Id< VertexWotdModified_<TSize> >::Type _getId(VertexWotdModified_<TSize> &desc);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(398)

//____________________________________________________________________________
// _getLastPatternProb

template <typename TState, typename TLogErrorDistr, typename TPattern > inline void _getLastPatternProb(TState &state, TLogErrorDistr const &logError, TPattern const &pattern, int span);       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(422)
template <typename TState, typename TPattern > inline void _getLastPatternProb(TState &, Nothing const &, TPattern const &, int);       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(437)

//____________________________________________________________________________
// _getNextl

template <typename TSize, typename TIndex > inline TSize _getNextl(TSize i, TIndex const &index);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(2236)

//____________________________________________________________________________
// _getNodeByChar

template <typename TText, class TIndexSpec, class TSpec, typename TValue > inline bool _getNodeByChar( Iter< Index<TText, IndexEsa<TIndexSpec> >, VSTree<TSpec> > const &it, TValue c, typename VertexDescriptor< Index<TText, IndexEsa<TIndexSpec> > >::Type &childDesc);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1090)

//____________________________________________________________________________
// _getNodeLP

template <typename TText, typename TSpec, typename TPos> inline TPos _getNodeLP( Index<TText, IndexWotd<TSpec> > const &index, TPos pos);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(1561)

//____________________________________________________________________________
// _getProb

template <typename TLogErrorDistr > typename Value<TLogErrorDistr>::Type _getProb(TLogErrorDistr const &logError, int errorType, int readPos);       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(411)

//____________________________________________________________________________
// _getUp

template <typename TSize, typename TIndex > inline TSize _getUp(TSize i, TIndex const &index);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(2242)

//____________________________________________________________________________
// _goDown

template <typename TText, class TIndexSpec, class TSpec, typename TDfsOrder > inline bool _goDown( Iter< Index<TText, IndexEsa<TIndexSpec> >, VSTree< TopDown<TSpec> > > &it, VSTreeIteratorTraits<TDfsOrder, False> const);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1391)
template <typename TText, class TIndexSpec, class TSpec, typename TDfsOrder > inline bool _goDown( Iter< Index<TText, IndexEsa<TIndexSpec> >, VSTree< TopDown<TSpec> > > &it, VSTreeIteratorTraits<TDfsOrder, True> const);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1411)
template <typename TText, typename TSpec, typename TDfsOrder, typename THideEmptyEdges > inline bool _goDown( Iter< Index<TText, IndexWotd<WotdOriginal> >, VSTree< TopDown<TSpec> > > &it, VSTreeIteratorTraits<TDfsOrder, THideEmptyEdges> const);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(662)
template <typename TText, typename TIndexSpec, typename TSpec, typename TDfsOrder, typename THideEmptyEdges > inline bool _goDown( Iter< Index<TText, IndexWotd<TIndexSpec> >, VSTree< TopDown<TSpec> > > &it, VSTreeIteratorTraits<TDfsOrder, THideEmptyEdges> const);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(698)

//____________________________________________________________________________
// _goDownChar

template <typename TIndex, class TSpec, typename TValue > inline bool _goDownChar(Iter< TIndex, VSTree< TopDown<TSpec> > > &it, TValue c);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1456)
template <typename TText, class TSpec, typename TValue > inline bool _goDownChar( Iter<Index<TText, IndexWotd<WotdOriginal> >, VSTree< TopDown<TSpec> > > &it, TValue c);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(1813)
template <typename TText, class TIndexSpec, class TSpec, typename TValue > inline bool _goDownChar( Iter<Index<TText, IndexWotd<TIndexSpec> >, VSTree< TopDown<TSpec> > > &it, TValue c);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(1835)

//____________________________________________________________________________
// _goDownObject

template <typename TIndex, typename TSpec, typename TObject > inline bool _goDownObject( Iter< TIndex, VSTree< TopDown<TSpec> > > &it, TObject const &obj, False);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1524)
template <typename TIndex, typename TSpec, typename TObject > inline bool _goDownObject( Iter< TIndex, VSTree< TopDown<TSpec> > > &it, TObject const &obj, True);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1534)

//____________________________________________________________________________
// _goDownString

template <typename TIndex, typename TSpec, typename TString, typename TSize > inline bool _goDownString( Iter< TIndex, VSTree< TopDown<TSpec> > > &node, TString const &pattern, TSize &lcp);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1474)

//____________________________________________________________________________
// _goRight

template <typename TText, class TIndexSpec, class TSpec, typename TDfsOrder, typename THideEmptyEdges > inline bool _goRight( Iter< Index<TText, IndexEsa<TIndexSpec> >, VSTree< TopDown<TSpec> > > &it, VSTreeIteratorTraits<TDfsOrder, THideEmptyEdges> const);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1660)
template <typename TText, typename TSpec, typename TDfsOrder, typename THideEmptyEdges > inline bool _goRight( Iter< Index<TText, IndexWotd<WotdOriginal> >, VSTree< TopDown<TSpec> > > &it, VSTreeIteratorTraits<TDfsOrder, THideEmptyEdges> const);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(734)
template <typename TText, typename TIndexSpec, typename TSpec, typename TDfsOrder, typename THideEmptyEdges > inline bool _goRight( Iter< Index<TText, IndexWotd<TIndexSpec> >, VSTree< TopDown<TSpec> > > &it, VSTreeIteratorTraits<TDfsOrder, THideEmptyEdges> const);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(758)

//____________________________________________________________________________
// _goUp

template <typename TIndex, class TSpec > inline bool _goUp(Iter< TIndex, VSTree< TopDown<TSpec> > > &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1576)
template <typename TIndex, class TSpec > inline bool _goUp(Iter< TIndex, VSTree< TopDown< ParentLinks<TSpec> > > > &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1588)
template <typename TText, typename TWotdSpec, typename TSpec > inline bool _goUp(Iter< Index<TText, IndexWotd<TWotdSpec> >, VSTree< TopDown<TSpec> > > &it);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(783)
template <typename TText, typename TSpec > inline bool _goUp(Iter< Index<TText, IndexWotd<WotdOriginal> >, VSTree< TopDown< ParentLinks<TSpec> > > > &it);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(795)
template <typename TText, typename TIndexSpec, typename TSpec > inline bool _goUp(Iter< Index<TText, IndexWotd<TIndexSpec> >, VSTree< TopDown< ParentLinks<TSpec> > > > &it);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(812)

//____________________________________________________________________________
// _hashFixedShape

template <typename THValue, typename TValue, typename TIter> inline THValue _hashFixedShape(THValue hash, TIter &, TValue const, UngappedShape<1> const);       	// "seqan-1.3.1/seqan/index/shape_base.h"(338)
template <typename THValue, typename TValue, typename TIter, unsigned q> inline THValue _hashFixedShape(THValue hash, TIter &it, TValue const, UngappedShape<q> const);       	// "seqan-1.3.1/seqan/index/shape_base.h"(344)

//____________________________________________________________________________
// _hashHardwiredShape

template <typename THValue, typename TValue, typename TIter> inline THValue _hashHardwiredShape(THValue hash, TIter &, TValue const, HardwiredShape< 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0 > const);       	// "seqan-1.3.1/seqan/index/shape_gapped.h"(479)
template <int P01, int P02, int P03, int P04, int P05, int P06, int P07, int P08, int P09, int P10, int P11, int P12, int P13, int P14, int P15, int P16, int P17, int P18, int P19, typename THValue, typename TValue, typename TIter > inline THValue _hashHardwiredShape(THValue hash, TIter &it, TValue const, HardwiredShape< 1 ,P01,P02,P03,P04, P05,P06,P07,P08,P09, P10,P11,P12,P13,P14, P15,P16,P17,P18,P19 > const);       	// "seqan-1.3.1/seqan/index/shape_gapped.h"(496)
template <int P00, int P01, int P02, int P03, int P04, int P05, int P06, int P07, int P08, int P09, int P10, int P11, int P12, int P13, int P14, int P15, int P16, int P17, int P18, int P19, typename THValue, typename TValue, typename TIter > inline THValue _hashHardwiredShape(THValue hash, TIter &it, TValue const, HardwiredShape< P00,P01,P02,P03,P04, P05,P06,P07,P08,P09, P10,P11,P12,P13,P14, P15,P16,P17,P18,P19 > const);       	// "seqan-1.3.1/seqan/index/shape_gapped.h"(519)

//____________________________________________________________________________
// _hashTuple2FixedShape

template <typename THValue, typename TValue, typename TTValue, unsigned SIZE, typename TCompressed> inline THValue _hashTuple2FixedShape( THValue const, Tuple<TTValue, SIZE, TCompressed> const &tuple, TValue const, UngappedShape<1> const);       	// "seqan-1.3.1/seqan/index/shape_base.h"(401)
template <typename THValue, typename TValue, typename TTValue, unsigned SIZE, typename TCompressed, unsigned q> inline THValue _hashTuple2FixedShape( THValue const, Tuple<TTValue, SIZE, TCompressed> const &tuple, TValue const, UngappedShape<q> const);       	// "seqan-1.3.1/seqan/index/shape_base.h"(412)

//____________________________________________________________________________
// _haveMaximalRepeats

template <typename TValue, typename TSize> int _haveMaximalRepeats( FractionCompound_<TValue, TSize> const &a, FractionCompound_<TValue, TSize> const &b);       	// "seqan-1.3.1/seqan/index/index_esa_algs.h"(315)
template <typename TValue, typename TSize> int _haveMaximalRepeats( FractionCompound_<TValue, TSize> const &a, FractionCompound_<TValue, TSize> const &b, TValue &equalKey);       	// "seqan-1.3.1/seqan/index/index_esa_algs.h"(336)

//____________________________________________________________________________
// _historyClear

template <typename TIndex, class TSpec > inline void _historyClear(Iter< TIndex, VSTree<TSpec> > &);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1337)
template <typename TIndex, class TSpec > inline void _historyClear(Iter< TIndex, VSTree< TopDown< ParentLinks<TSpec> > > > &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1342)

//____________________________________________________________________________
// _historyPush

template <typename TText, class TIndexSpec, class TSpec > inline void _historyPush(Iter< Index<TText, IndexEsa<TIndexSpec> >, VSTree< TopDown<TSpec> > > &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1355)
template <typename TText, class TIndexSpec, class TSpec > inline void _historyPush(Iter< Index<TText, IndexEsa<TIndexSpec> >, VSTree< TopDown< ParentLinks<TSpec> > > > &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1362)
template <typename TText, typename TIndexSpec, typename TSpec > inline void _historyPush(Iter< Index<TText, IndexWotd<TIndexSpec> >, VSTree< TopDown<TSpec> > > &it);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(322)
template <typename TText, typename TSpec > inline void _historyPush(Iter< Index<TText, IndexWotd<WotdOriginal> >, VSTree< TopDown< ParentLinks<TSpec> > > > &it);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(331)
template <typename TText, typename TIndexSpec, typename TSpec > inline void _historyPush(Iter< Index<TText, IndexWotd<TIndexSpec> >, VSTree< TopDown< ParentLinks<TSpec> > > > &it);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(342)

//____________________________________________________________________________
// _indexRequireBottomUpIteration

template <typename TText, typename TSpec > void _indexRequireBottomUpIteration(Index<TText, IndexEsa<TSpec> > &index);       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(354)

//____________________________________________________________________________
// _indexRequireTopDownIteration

template <typename TText, typename TSpec > void _indexRequireTopDownIteration(Index<TText, IndexEsa<TSpec> > &index);       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(346)
template <typename TText, typename TSpec > void _indexRequireTopDownIteration(Index<TText, IndexWotd<TSpec> > &index);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(280)

//____________________________________________________________________________
// _insertAfter

template <typename TArray, typename TValue > inline void _insertAfter( TArray &lexprevpos, TArray &lexnextpos, TValue p, TValue predecessor);       	// "seqan-1.3.1/seqan/index/index_sa_bwtwalk.h"(115)

//____________________________________________________________________________
// _insertBefore

template <typename TArray, typename TValue > inline void _insertBefore( TArray &lexprevpos, TArray &lexnextpos, TValue p, TValue successor);       	// "seqan-1.3.1/seqan/index/index_sa_bwtwalk.h"(104)

//____________________________________________________________________________
// _insertBetween

template <typename TArray, typename TValue > inline void _insertBetween( TArray &lexprevpos, TArray &lexnextpos, TValue p, TValue predecessor, TValue successor);       	// "seqan-1.3.1/seqan/index/index_sa_bwtwalk.h"(89)

//____________________________________________________________________________
// _insertXorBetween

template <typename TArray, typename TValue > inline void _insertXorBetween( TArray &lexxorpos, TValue p, TValue predecessor, TValue successor);       	// "seqan-1.3.1/seqan/index/index_sa_bwtwalk.h"(126)

//____________________________________________________________________________
// _isLeaf

template <typename TSize > inline bool _isLeaf(VertexEsa<TSize> const &vDesc);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(2165)
template <typename TIndex, class TSpec, typename TDfsOrder > inline bool _isLeaf( Iter<TIndex, VSTree<TSpec> > const &it, VSTreeIteratorTraits<TDfsOrder, False> const);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(2175)
template <typename TIndex, class TSpec, typename TDfsOrder > inline bool _isLeaf( Iter<TIndex, VSTree<TSpec> > const &it, VSTreeIteratorTraits<TDfsOrder, True> const);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(2184)
template <typename TText, typename TIndexSpec, typename TSpec, typename TDfsOrder > inline bool _isLeaf( Iter< Index<TText, IndexWotd<TIndexSpec> >, VSTree<TSpec> > const &it, VSTreeIteratorTraits<TDfsOrder, False> const);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(419)
template <typename TText, typename TIndexSpec, typename TSpec, typename TDfsOrder > inline bool _isLeaf( Iter< Index<TText, IndexWotd<TIndexSpec> >, VSTree<TSpec> > const &it, VSTreeIteratorTraits<TDfsOrder, True> const);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(430)

//____________________________________________________________________________
// _isNextl

template <typename TSize, typename TIndex > inline bool _isNextl(TSize i, TIndex const &index);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(2220)

//____________________________________________________________________________
// _isRoot

template <typename TSize > inline bool _isRoot(VertexEsa<TSize> const &value);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1909)
template <typename TSize > inline bool _isRoot(VertexWotdOriginal_<TSize> const &value);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(405)
template <typename TSize > inline bool _isRoot(VertexWotdModified_<TSize> const &value);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(410)

//____________________________________________________________________________
// _isSizeInval

template <typename TValue> inline bool _isSizeInval(TValue const &v);       	// "seqan-1.3.1/seqan/index/index_base.h"(1008)

//____________________________________________________________________________
// _isUp

template <typename TSize, typename TIndex > inline bool _isUp(TSize i, TIndex const &index);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(2228)

//____________________________________________________________________________
// _lcpProcess

template <typename TTextInput, typename TInvertedSAInput, typename TDest > static void _lcpProcess(TTextInput &textIn, TInvertedSAInput &invertedSAIn, TDest &dest, LcpConfig conf);       	// "seqan-1.3.1/seqan/index/pump_lcp_core.h"(70)
template <typename TTextInput, typename TInvertedSAInput, typename TDest > static inline void _lcpProcess(TTextInput &textIn, TInvertedSAInput &invertedSAIn, TDest &dest);       	// "seqan-1.3.1/seqan/index/pump_lcp_core.h"(210)

//____________________________________________________________________________
// _lcpProcessMulti

template <typename TTextInput, typename TLimitsString, typename TInvertedSAInput, typename TDest > static void _lcpProcessMulti( TTextInput &textIn, TLimitsString const &limits, TInvertedSAInput &invertedSAIn, TDest &dest, LcpConfig conf);       	// "seqan-1.3.1/seqan/index/pump_lcp_core.h"(222)
template <typename TTextInput, typename TLimitsString, typename TInvertedSAInput, typename TDest > static void _lcpProcessMulti( TTextInput &textIn, TLimitsString const &limits, TInvertedSAInput &invertedSAIn, TDest &dest);       	// "seqan-1.3.1/seqan/index/pump_lcp_core.h"(381)

//____________________________________________________________________________
// _leqSkew3

template <typename T, typename ST> inline bool _leqSkew3(T a1, ST a2,  T b1, ST b2);       	// "seqan-1.3.1/seqan/index/index_skew3.h"(327)
template <typename T, typename ST> inline bool _leqSkew3(T a1, T a2, ST a3,  T b1, T b2, ST b3);       	// "seqan-1.3.1/seqan/index/index_skew3.h"(333)

//____________________________________________________________________________
// _leqSkew7

template <typename TTextIter, typename TSize> inline bool _leqSkew7(TTextIter a1, TSize a2,  TTextIter b1, TSize b2,  TSize n);       	// "seqan-1.3.1/seqan/index/index_skew7.h"(433)
template <typename TTextIter, typename TSize> inline bool _leqSkew7(TTextIter a,  TTextIter b,  TSize n);       	// "seqan-1.3.1/seqan/index/index_skew7.h"(444)
template <typename TTextIter, typename TSize, typename TString> inline bool _leqSkew7(unsigned a, unsigned b,  TTextIter spos[], const TSize tpos[], const bool islast[], const TString &s124, const TSize adjust[7][7]);       	// "seqan-1.3.1/seqan/index/index_skew7.h"(455)

//____________________________________________________________________________
// _lowerBoundLcpe

template <typename TText, typename TSA, typename TLCP, typename TSpec, typename TQuery, typename TDiff_ > inline typename Iterator<TSA, Standard>::Type _lowerBoundLcpe( TText &text, TSA &sa, SearchTreeIterator< TLCP, TSpec > treeIter, TQuery &query, TDiff_ lcpLower, TDiff_ lcpUpper);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(1147)
template <typename TText, typename TSA, typename TLCP, typename TSpec, typename TQuery > inline typename Iterator<TSA, Standard>::Type _lowerBoundLcpe( TText &text, TSA &sa, SearchTreeIterator< TLCP, TSpec > &treeIter, TQuery &query);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(1324)

//____________________________________________________________________________
// _lowerBoundSA

template <typename TText, typename TSA, typename TSpec, typename TQuery > inline typename Iterator<TSA, Standard>::Type _lowerBoundSA( TText &text, SearchTreeIterator< TSA, TSpec > treeIter, TQuery &query);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(553)

//____________________________________________________________________________
// _lowerBoundSANaive

template <typename TText, typename TSA, typename TSpec, typename TQuery > inline typename Iterator<TSA, Standard>::Type _lowerBoundSANaive( TText &text, SearchTreeIterator< TSA, TSpec > treeIter, TQuery &query);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(511)

//____________________________________________________________________________
// _nextNonRepeatRange

template <typename TFinder, typename TIndex, typename TSpec> inline bool _nextNonRepeatRange( TFinder &finder, Pattern<TIndex, Swift<TSpec> > &pattern);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1582)

//____________________________________________________________________________
// _onGoDown

template <typename TIndex, typename TSpec > inline void _onGoDown(Iter<TIndex, VSTree< TopDown<TSpec> > > &);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1374)

//____________________________________________________________________________
// _onGoRight

template <typename TIndex, typename TSpec > inline void _onGoRight(Iter<TIndex, VSTree< TopDown<TSpec> > > &);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1377)

//____________________________________________________________________________
// _onGoUp

template <typename TIndex, typename TSpec > inline void _onGoUp(Iter<TIndex, VSTree< TopDown< ParentLinks<TSpec> > > > &);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1380)

//____________________________________________________________________________
// _patternInit

template <typename TNeedle> inline void _patternInit (Pattern<TNeedle, Quasar> & );       	// "seqan-1.3.1/seqan/index/find_quasar.h"(123)
template <typename TIndex, typename TFloat, typename TSize_, typename TSpec> inline void _patternInit(Pattern<TIndex, Swift<TSpec> > &pattern, TFloat errorRate, TSize_ minLengthForAll);       	// "seqan-1.3.1/seqan/index/find_swift.h"(567)

//____________________________________________________________________________
// _pizzaChiliDeallocate

template <typename TValue> inline void _pizzaChiliDeallocate(TValue* begin);       	// "seqan-1.3.1/seqan/index/index_pizzachili_string.h"(291)

//____________________________________________________________________________
// _pizzaChiliReallocate

template <typename TValue, typename TSpec> inline typename Value<String<TValue, PizzaChili<TSpec> > >::Type* _pizzaChiliReallocate( String<TValue, PizzaChili<TSpec> >& me, typename Size<String<TValue, PizzaChili<TSpec> > >::Type new_capacity );       	// "seqan-1.3.1/seqan/index/index_pizzachili_string.h"(274)

//____________________________________________________________________________
// _printDots

template <typename THaystack, typename TSpec> inline void _printDots(Finder<THaystack, Swift<TSpec> > &finder);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1564)

//____________________________________________________________________________
// _printSwiftBuckets

template <typename TIndex, typename TSpec> inline void _printSwiftBuckets(Pattern< TIndex, Swift<TSpec> > &p);       	// "seqan-1.3.1/seqan/index/find_swift.h"(460)

//____________________________________________________________________________
// _printSwiftParams

template <typename TSpec_, typename TSize, typename TShortSize> inline void _printSwiftParams(SwiftBucketParams_<TSpec_, TSize, TShortSize > &bucketParams);       	// "seqan-1.3.1/seqan/index/find_swift.h"(437)
template <typename TSpec_, typename TSize, typename TShortSize> inline void _printSwiftParams(SwiftBucketParams_<Tag<SwiftSemiGlobal_<TSpec_> >, TSize, TShortSize > &bucketParams);       	// "seqan-1.3.1/seqan/index/find_swift.h"(449)

//____________________________________________________________________________
// _probAdd

template <typename TValue> inline void _probAdd(TValue &a, TValue b);       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(288)

//____________________________________________________________________________
// _probDiv

template <typename TValue> inline TValue _probDiv(TValue a, TValue b);       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(316)

//____________________________________________________________________________
// _probMul

template <typename TValue> inline TValue _probMul(TValue a, TValue b);       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(305)

//____________________________________________________________________________
// _qgramClearDir

template <typename TDir > inline void _qgramClearDir(TDir &dir, Nothing &);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(868)
template <typename TDir, typename THashValue > inline void _qgramClearDir(TDir &dir, BucketMap<THashValue> &bucketMap);       	// "seqan-1.3.1/seqan/index/index_qgram_openaddressing.h"(177)

//____________________________________________________________________________
// _qgramCountQGrams

template <typename TDir, typename TBucketMap, typename TText, typename TShape, typename TStepSize > inline void _qgramCountQGrams(TDir &dir, TBucketMap &bucketMap, TText const &text, TShape shape, TStepSize stepSize);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(877)
template <typename TDir, typename TBucketMap, typename TString, typename TSpec, typename TShape, typename TStepSize > inline void _qgramCountQGrams(TDir &dir, TBucketMap &bucketMap, StringSet<TString, TSpec> const &stringSet, TShape shape, TStepSize stepSize);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(904)

//____________________________________________________________________________
// _qgramCummulativeSum

template <typename TDir, typename TWithConstraints > inline typename Value<TDir>::Type _qgramCummulativeSum(TDir &dir, TWithConstraints);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(949)

//____________________________________________________________________________
// _qgramCummulativeSumAlt

template <typename TDir, typename TWithConstraints > inline typename Value<TDir>::Type _qgramCummulativeSumAlt(TDir &dir, TWithConstraints const);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(981)

//____________________________________________________________________________
// _qgramDisableBuckets

template <typename TIndex > inline bool _qgramDisableBuckets(TIndex &);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(1181)

//____________________________________________________________________________
// _qgramFillSuffixArray

template <typename TSA, typename TText, typename TShape, typename TDir, typename TBucketMap, typename TWithConstraints, typename TStepSize > inline void _qgramFillSuffixArray( TSA &sa, TText const &text, TShape shape, TDir &dir, TBucketMap &bucketMap, TStepSize stepSize, TWithConstraints const);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(1021)
template <typename TSA, typename TString, typename TSpec, typename TShape, typename TDir, typename TBucketMap, typename TStepSize, typename TWithConstraints > inline void _qgramFillSuffixArray( TSA &sa, StringSet<TString, TSpec> const &stringSet, TShape shape, TDir &dir, TBucketMap &bucketMap, TStepSize stepSize, TWithConstraints const);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(1076)

//____________________________________________________________________________
// _qgramLemma

template <typename TIndex, typename TSpec, typename TSeqNo> inline int _qgramLemma(Pattern<TIndex, Swift<TSpec> > const & pattern, TSeqNo seqNo, int errors);       	// "seqan-1.3.1/seqan/index/find_swift.h"(505)

//____________________________________________________________________________
// _qgramPostprocessBuckets

template <typename TDir > inline void _qgramPostprocessBuckets(TDir &dir);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(1140)

//____________________________________________________________________________
// _qgramQGramCount

template <typename TText, typename TShapeSpec, typename TSpec> inline typename Size<Index<TText, IndexQGram<TShapeSpec, TSpec> > >::Type _qgramQGramCount(Index<TText, IndexQGram<TShapeSpec, TSpec> > const &index);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(1863)

//____________________________________________________________________________
// _reallocateStorage

template <typename TValue, typename TSpec> inline typename Value<String<TValue, PizzaChili<TSpec> > >::Type* _reallocateStorage( String<TValue, PizzaChili<TSpec> >& me, typename Size<String<TValue, PizzaChili<TSpec> > >::Type new_capacity, Exact );       	// "seqan-1.3.1/seqan/index/index_pizzachili_string.h"(374)

//____________________________________________________________________________
// _refineQGramIndex

template <typename TSA, typename TDir, typename TText, typename TSize1, typename TSize2 > void _refineQGramIndex( TSA &sa, TDir &dir, TText const &text, TSize1 oldQ, TSize2 newQ);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(1385)

//____________________________________________________________________________
// _repeatMaskValue

template <typename TValue> inline bool _repeatMaskValue(TValue);       	// "seqan-1.3.1/seqan/index/repeat_base.h"(104)
template <> inline bool _repeatMaskValue(Dna5 val);       	// "seqan-1.3.1/seqan/index/repeat_base.h"(110)
template <> inline bool _repeatMaskValue(Iupac val);       	// "seqan-1.3.1/seqan/index/repeat_base.h"(116)

//____________________________________________________________________________
// _resetBucket

template <typename TSpec, typename TSize, typename TShortSize, typename TPos> inline void _resetBucket(SwiftBucket_<TSpec, TSize, TShortSize> & bkt, TPos lastIncrement);       	// "seqan-1.3.1/seqan/index/find_swift.h"(532)
template <typename TSpec, typename TSize, typename TShortSize, typename TPos, typename TThresh> inline void _resetBucket(SwiftBucket_<TSpec, TSize, TShortSize> & bkt, TPos lastIncrement, TThresh threshold);       	// "seqan-1.3.1/seqan/index/find_swift.h"(541)
template <typename TSpec_, typename TSize, typename TShortSize, typename TPos> inline void _resetBucket(SwiftBucket_<SwiftSemiGlobal_<TSpec_>, TSize, TShortSize> & bkt, TPos lastIncrement);       	// "seqan-1.3.1/seqan/index/find_swift.h"(551)
template <typename TSpec_, typename TSize, typename TShortSize, typename TPos, typename TThresh> inline void _resetBucket(SwiftBucket_<SwiftSemiGlobal_<TSpec_>, TSize, TShortSize> & bkt, TPos lastIncrement, TThresh threshold);       	// "seqan-1.3.1/seqan/index/find_swift.h"(559)

//____________________________________________________________________________
// _setLength

template <typename TValue, typename TSpec> inline void _setLength( String<TValue, PizzaChili<TSpec> >& me, size_t new_length );       	// "seqan-1.3.1/seqan/index/index_pizzachili_string.h"(424)

//____________________________________________________________________________
// _setSizeInval

template <typename TValue> inline void _setSizeInval(TValue &v);       	// "seqan-1.3.1/seqan/index/index_base.h"(1003)

//____________________________________________________________________________
// _skew3Extend

template <typename TTextInput, typename TNameInput, typename TOut0, typename TOut12 > static bool _skew3Extend(TTextInput &textIn, TNameInput &nameIn, TOut0 &out0, TOut12 &out12);       	// "seqan-1.3.1/seqan/index/pump_extender3.h"(68)

//____________________________________________________________________________
// _skew7Extend

template <typename TTextInput, typename TNameInput, typename TOut0, typename TOut3, typename TOut5, typename TOut6, typename TOut124 > static bool _skew7Extend(TTextInput &textIn, TNameInput &nameIn, TOut0 &out0, TOut3 &out3, TOut5 &out5, TOut6 &out6, TOut124 &out124);       	// "seqan-1.3.1/seqan/index/pump_extender7.h"(89)

//____________________________________________________________________________
// _skew7ExtendMulti

template <typename TTextInput, typename TLimitsString, typename TNameInput, typename TOut0, typename TOut3, typename TOut5, typename TOut6, typename TOut124 > static bool _skew7ExtendMulti( TTextInput &textIn, TLimitsString const &limits, TNameInput &nameIn1, TNameInput &nameIn2, TNameInput &nameIn4, TOut0 &out0, TOut3 &out3, TOut5 &out5, TOut6 &out6, TOut124 &out124);       	// "seqan-1.3.1/seqan/index/pump_extender7.h"(296)

//____________________________________________________________________________
// _skew7SeparateSlices

template <typename TInput, typename TFunctor, typename TOut1, typename TOut2, typename TOut4 > static void _skew7SeparateSlices( TInput &in, TFunctor const &funcSlice, TOut1 &out1, TOut2 &out2, TOut4 &out4);       	// "seqan-1.3.1/seqan/index/pump_separator7.h"(49)

//____________________________________________________________________________
// _sortBucketQuickSort

template <typename TSA, typename TText, typename TSize> void _sortBucketQuickSort( TSA &sa, TText &text, TSize lcp);       	// "seqan-1.3.1/seqan/index/index_sa_qsort.h"(142)

//____________________________________________________________________________
// _sortFirstWotdBucket

template <typename TText, typename TSpec, typename TPredHull, typename TPred > typename Size< Index<StringSet<TText, TSpec>, IndexWotd<Dfi<TPredHull, TPred> > > >::Type _sortFirstWotdBucket(Index<StringSet<TText, TSpec>, IndexWotd<Dfi<TPredHull, TPred> > > &index);       	// "seqan-1.3.1/seqan/index/index_dfi.h"(206)
template <typename TIndex > typename Size<TIndex>::Type _sortFirstWotdBucket(TIndex &index);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(1074)
template <typename TText, typename TSpec, typename TIndexSpec > typename Size< Index<StringSet<TText, TSpec>, TIndexSpec> >::Type _sortFirstWotdBucket(Index<StringSet<TText, TSpec>, TIndexSpec> &index);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(1119)

//____________________________________________________________________________
// _sortWotdBucket

template <typename TText, typename TSpec, typename TPredHull, typename TPred, typename TBeginPos, typename TEndPos, typename TSize > TSize _sortWotdBucket( Index<StringSet<TText, TSpec>, IndexWotd<Dfi<TPredHull, TPred> > > &index, TBeginPos left, TEndPos right, TSize prefixLen);       	// "seqan-1.3.1/seqan/index/index_dfi.h"(299)
template <typename TText, typename TBeginPos, typename TEndPos, typename TSize > TSize _sortWotdBucket( Index<TText, IndexWotd<WotdOriginal> > &index, TBeginPos left, TEndPos right, TSize prefixLen);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(1183)
template <typename TIndex, typename TBeginPos, typename TEndPos, typename TSize > TSize _sortWotdBucket( TIndex &index, TBeginPos left, TEndPos right, TSize prefixLen);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(1297)
template <typename TText, typename TSpec, typename TIndexSpec, typename TBeginPos, typename TEndPos, typename TSize > TSize _sortWotdBucket( Index<StringSet<TText, TSpec>, TIndexSpec> &index, TBeginPos left, TEndPos right, TSize prefixLen);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(1363)

//____________________________________________________________________________
// _storeWotdChildren

template <typename TText, typename TPredHull, typename TPred, typename TSize> inline void _storeWotdChildren( Index<TText, IndexWotd<Dfi<TPredHull, TPred> > > &index, TSize dirOfs, TSize lcp);       	// "seqan-1.3.1/seqan/index/index_dfi.h"(445)
template <typename TText, typename TPos> inline void _storeWotdChildren( Index<TText, IndexWotd<WotdOriginal> > &index, TPos dirOfs);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(1580)
template <typename TText, typename TSpec, typename TSize> inline void _storeWotdChildren( Index<TText, IndexWotd<TSpec> > &index, TSize dirOfs, TSize lcp);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(1640)

//____________________________________________________________________________
// _swiftBucketNo

template <typename TIndex, typename TSpec, typename TParams, typename TSize> inline unsigned _swiftBucketNo(Pattern<TIndex, Swift<TSpec> > const &, TParams &bucketParams, TSize seqNo);       	// "seqan-1.3.1/seqan/index/find_swift.h"(495)

//____________________________________________________________________________
// _swiftBucketParams

template <typename TIndex, typename TSpec, typename TSize> inline typename Pattern<TIndex, Swift<TSpec> >::TBucketParams & _swiftBucketParams(Pattern<TIndex, Swift<TSpec> > & pattern, TSize seqNo);       	// "seqan-1.3.1/seqan/index/find_swift.h"(485)

//____________________________________________________________________________
// _swiftMultiFlushBuckets

template <typename TFinder, typename TIndex, typename TSpec > inline bool _swiftMultiFlushBuckets( TFinder & finder, Pattern<TIndex, Swift<TSpec> > & pattern );       	// "seqan-1.3.1/seqan/index/find_swift.h"(1150)
template <typename TFinder, typename TIndex, typename TSpec_ > inline bool _swiftMultiFlushBuckets( TFinder &, Pattern<TIndex, Swift<Tag<SwiftSemiGlobal_<TSpec_> > > > &);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1209)

//____________________________________________________________________________
// _swiftMultiProcessQGram

template <typename TFinder, typename TIndex, typename TSpec, typename THashValue > inline bool _swiftMultiProcessQGram( TFinder & finder, Pattern<TIndex, Swift<TSpec> > & pattern, THashValue hash);       	// "seqan-1.3.1/seqan/index/find_swift.h"(875)
template <typename TFinder, typename TIndex, typename TSpec_, typename THValue > inline bool _swiftMultiProcessQGram( TFinder &finder, Pattern<TIndex, Swift<Tag<SwiftSemiGlobal_<TSpec_> > > > &pattern, THValue hash);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1008)

//____________________________________________________________________________
// _transform

template <typename TValue> inline long double _transform(TValue a);       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(264)

//____________________________________________________________________________
// _transformBack

template <typename TValue> inline long double _transformBack(TValue a);       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(275)

//____________________________________________________________________________
// _treeLevels

template <typename TSize > inline unsigned _treeLevels(TSize lcpSize);       	// "seqan-1.3.1/seqan/index/index_lcp_tree.h"(160)

//____________________________________________________________________________
// _upperBoundLcpe

template <typename TText, typename TSA, typename TLCP, typename TSpec, typename TQuery, typename TDiff_ > inline typename Iterator<TSA, Standard>::Type _upperBoundLcpe( TText &text, TSA &sa, SearchTreeIterator< TLCP, TSpec > treeIter, TQuery &query, TDiff_ lcpLower, TDiff_ lcpUpper);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(1347)
template <typename TText, typename TSA, typename TLCP, typename TSpec, typename TQuery > inline typename Iterator<TSA, Standard>::Type _upperBoundLcpe( TText &text, TSA &sa, SearchTreeIterator< TLCP, TSpec > &treeIter, TQuery &query);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(1497)

//____________________________________________________________________________
// _upperBoundSA

template <typename TText, typename TSA, typename TSpec, typename TQuery > inline typename Iterator<TSA, Standard>::Type _upperBoundSA( TText &text, SearchTreeIterator< TSA, TSpec > treeIter, TQuery &query);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(650)

//____________________________________________________________________________
// _upperBoundSANaive

template <typename TText, typename TSA, typename TSpec, typename TQuery > inline typename Iterator<TSA, Standard>::Type _upperBoundSANaive( TText &text, SearchTreeIterator< TSA, TSpec > treeIter, TQuery &query);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(607)

//____________________________________________________________________________
// _wotdCountChars

template <typename TBuckets, typename TText > inline void _wotdCountChars(TBuckets &buckets, TText const &text);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(883)
template <typename TBuckets, typename TText, typename TSpec > inline void _wotdCountChars(TBuckets &buckets, StringSet<TText, TSpec> const &stringSet);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(897)
template <typename TBuckets, typename TText, typename TSA, typename TSize > inline typename Size<TText>::Type _wotdCountChars( TBuckets &buckets, TText const &text, TSA const &sa, TSize prefixLen);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(950)
template <typename TBuckets, typename TText, typename TSpec, typename TSA, typename TSize > inline typename Size<TText>::Type _wotdCountChars( TBuckets &buckets, StringSet<TText, TSpec> const &stringSet, TSA const &sa, TSize prefixLen);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(986)

//____________________________________________________________________________
// _wotdCountCharsWotdOriginal

template <typename TBuckets, typename TText, typename TSA, typename TSize > inline typename Size<TText>::Type _wotdCountCharsWotdOriginal( TBuckets &buckets, TText const &text, TSA &sa, TSize prefixLen);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(919)

//____________________________________________________________________________
// _wotdCreateFirstLevel

template <typename TText, typename TSpec> inline void _wotdCreateFirstLevel(Index<TText, IndexWotd<TSpec> > &index);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(1885)

//____________________________________________________________________________
// _wotdCummulativeSum

template <typename TBounds, typename TBuckets, typename TSize > inline typename Size<TBuckets>::Type _wotdCummulativeSum(TBounds &bounds, TBuckets const &buckets, TSize offset);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(1027)
template <typename TBounds, typename TBuckets > inline typename Size<TBuckets>::Type _wotdCummulativeSum(TBounds &bounds, TBuckets const &buckets);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(1053)

//____________________________________________________________________________
// _wotdEvaluate

template <typename TText, typename TSpec > inline typename Size< Index<TText, IndexWotd<WotdOriginal> > >::Type _wotdEvaluate(Iter< Index<TText, IndexWotd<WotdOriginal> >, VSTree<TSpec> > const &it);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(1700)
template <typename TText, typename TIndexSpec, typename TSpec > inline typename Size< Index<TText, IndexWotd<TIndexSpec> > >::Type _wotdEvaluate(Iter< Index<TText, IndexWotd<TIndexSpec> >, VSTree<TSpec> > const &it);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(1741)

//____________________________________________________________________________
// alignment

template <typename TString, typename TSSetSpec, typename TIndexSpec, class TSpec > inline Align<TString, ArrayGaps> alignment(Iter< Index< StringSet<TString, TSSetSpec>, TIndexSpec >, VSTree<TSpec> > &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(892)
template <typename TString, typename TConcSpec, typename TIndexSpec, class TSpec > inline Align<TString, ArrayGaps> alignment(Iter< Index< StringSet<TString, Owner<ConcatDirect<TConcSpec> > >, TIndexSpec >, VSTree<TSpec> > &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(938)

//____________________________________________________________________________
// approximateStringSearch

template <typename TOnFoundFunctor, typename TString, typename TTreeIterator, typename TErrors> inline void approximateStringSearch( TOnFoundFunctor &onFoundFunctor, TString const &string, TTreeIterator &iter, TErrors errorsLeft);       	// "seqan-1.3.1/seqan/index/find_index_approx.h"(198)

//____________________________________________________________________________
// approximateTreeSearch

template <typename TOnFoundFunctor, typename TTreeIteratorA, typename TTreeIteratorB, typename TErrors> inline void approximateTreeSearch( TOnFoundFunctor &onFoundFunctor, TTreeIteratorA const &iterA, TTreeIteratorB const &iterB, TErrors errorsLeft);       	// "seqan-1.3.1/seqan/index/find_index_approx.h"(218)

//____________________________________________________________________________
// assign

inline void assign(Ascii & c_target, ErrorAlphabet const & source);       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(151)
template <typename TValue, typename TSpec, typename TSource, typename TExpand> inline void assign( String<TValue, PizzaChili<TSpec> >& target, TSource const& source, Tag<TExpand> const );       	// "seqan-1.3.1/seqan/index/index_pizzachili_string.h"(211)
template <typename TValue, typename TSpec, typename TSource, typename TExpand> inline void assign( String<TValue, PizzaChili<TSpec> >& target, TSource const* source, Tag<TExpand> const );       	// "seqan-1.3.1/seqan/index/index_pizzachili_string.h"(225)
template <typename TValue, typename TSpec, typename TExpand> inline void assign( String<TValue, PizzaChili<TSpec> >& target, String<TValue, PizzaChili<TSpec> > const& source, Tag<TExpand> const );       	// "seqan-1.3.1/seqan/index/index_pizzachili_string.h"(239)

//____________________________________________________________________________
// atBegin

template <typename TText, typename TSpec, typename TSpecFinder > inline bool atBegin(Finder< Index<TText, TSpec>, TSpecFinder > & me);       	// "seqan-1.3.1/seqan/index/find_index.h"(197)

//____________________________________________________________________________
// atEnd

template <typename TRepeat > inline bool atEnd(Iter<TRepeat, MaxRepeatOccurrences> const &it);       	// "seqan-1.3.1/seqan/index/index_esa_algs.h"(911)
template <typename TRepeat > inline bool atEnd(Iter<TRepeat, MaxRepeatOccurrences> &it);       	// "seqan-1.3.1/seqan/index/index_esa_algs.h"(916)
template <typename THaystack, typename TSpec> inline bool atEnd(Finder<THaystack, Swift<TSpec> > & me);       	// "seqan-1.3.1/seqan/index/find_swift.h"(371)
template <typename TIndex, class TSpec > inline bool atEnd(Iter<TIndex, VSTree<TSpec> > &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1874)
template <typename TIndex, class TSpec > inline bool atEnd(Iter<TIndex, VSTree<TSpec> > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1880)
template <typename TRepeat > inline bool atEnd(Iter<TRepeat, MultiMemOccurences> const &it);       	// "seqan-1.3.1/seqan/index/index_esa_algs_multi.h"(686)
template <typename TRepeat > inline bool atEnd(Iter<TRepeat, MultiMemOccurences> &it);       	// "seqan-1.3.1/seqan/index/index_esa_algs_multi.h"(691)
template <typename TText, typename TSpec, typename TSpecFinder > inline bool atEnd(Finder< Index<TText, TSpec>, TSpecFinder > & me);       	// "seqan-1.3.1/seqan/index/find_index.h"(205)
template <typename TText, typename TSpec > inline bool atEnd(Iter<Index<TText, IndexWotd<WotdOriginal> >, VSTree<TSpec> > &it);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(615)
template <typename TText, typename TSpec > inline bool atEnd(Iter<Index<TText, IndexWotd<WotdOriginal> >, VSTree<TSpec> > const &it);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(621)

//____________________________________________________________________________
// begin

template <typename TSTree, class TSpec > inline typename Iterator< Iter< TSTree, VSTree< BottomUp<MaxRepeats_<TSpec> > > > >::Type begin(Iter< TSTree, VSTree< BottomUp<MaxRepeats_<TSpec> > > > &it);       	// "seqan-1.3.1/seqan/index/index_esa_algs.h"(643)
template <typename TText, typename TIndexSpec, class TSpec > inline typename Iterator<Index<TText, TIndexSpec>, TSpec >::Type begin(Index<TText, TIndexSpec> &index, TSpec const);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1203)
template <typename TValue, typename TSpec, typename TTag> inline typename Iterator<String<TValue, PizzaChili<TSpec> >, Tag<TSpec> const>::Type begin( String<TValue, PizzaChili<TSpec> >& me, Tag<TTag> const );       	// "seqan-1.3.1/seqan/index/index_pizzachili_string.h"(479)
template <typename TValue, typename TSpec, typename TTag> inline typename Iterator<String<TValue, PizzaChili<TSpec> > const, Tag<TSpec> const>::Type begin( String<TValue, PizzaChili<TSpec> > const& me, Tag<TTag> const );       	// "seqan-1.3.1/seqan/index/index_pizzachili_string.h"(490)

//____________________________________________________________________________
// beginPosition

template <typename THaystack, typename TSpec> inline __int64 beginPosition(Finder<THaystack, Swift<TSpec> > const & finder);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1288)
template <typename THaystack, typename TSpec> inline __int64 beginPosition(Finder<THaystack, Swift<TSpec> > & finder);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1295)
template <typename TIndex, typename TSpec> inline typename SAValue<TIndex>::Type beginPosition(Pattern<TIndex, Swift<TSpec> > const & pattern);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1304)
template <typename TIndex, typename TSpec> inline typename SAValue<TIndex >::Type beginPosition(Pattern<TIndex, Swift<Tag<SwiftSemiGlobal_<TSpec> > > > const & pattern);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1316)
template <typename TIndex, typename TSpec> inline typename SAValue<TIndex>::Type beginPosition(Pattern<TIndex, Swift<TSpec> > & pattern);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1325)
template <typename TText, typename TSpec, typename TSpecFinder > inline typename Position< Finder< Index<TText, TSpec>, TSpecFinder > >::Type beginPosition(Finder< Index<TText, TSpec>, TSpecFinder > & me);       	// "seqan-1.3.1/seqan/index/find_index.h"(233)
template <typename TText, typename TSpec, typename TSpecFinder > inline typename Position< Finder< Index<TText, TSpec>, TSpecFinder > >::Type beginPosition(Finder< Index<TText, TSpec>, TSpecFinder > const & me);       	// "seqan-1.3.1/seqan/index/find_index.h"(242)

//____________________________________________________________________________
// bwtAt

template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex, FibreBwt>::Type>::Type bwtAt(TPos i, TIndex &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(991)
template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex const, FibreBwt>::Type>::Type bwtAt(TPos i, TIndex const &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(995)

//____________________________________________________________________________
// cargo

template <typename TText, typename TSpec> inline typename Reference< typename Cargo<Index<TText, TSpec> >::Type >::Type cargo(Index<TText, TSpec> & me);       	// "seqan-1.3.1/seqan/index/index_shims.h"(670)
template <typename TText, typename TSpec> inline typename Reference< typename Cargo<Index<TText, TSpec> const>::Type >::Type cargo(Index<TText, TSpec> const & me);       	// "seqan-1.3.1/seqan/index/index_shims.h"(678)

//____________________________________________________________________________
// childAt

template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex, FibreChildtab>::Type>::Type childAt(TPos i, TIndex &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(969)
template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex const, FibreChildtab>::Type>::Type childAt(TPos i, TIndex const &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(973)

//____________________________________________________________________________
// childrenAreLeaves

template <typename TIndex, class TSpec > inline bool childrenAreLeaves(Iter<TIndex, VSTree<TSpec> > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(2148)

//____________________________________________________________________________
// clear

template <typename TText, typename TSpec> inline void clear(Index<TText, PizzaChili<TSpec> >& me);       	// "seqan-1.3.1/seqan/index/index_pizzachili.h"(166)
template <typename TIndex, typename TSpec> inline void clear(Pattern<TIndex, Swift<TSpec> > & me);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1224)
template <typename TIndex, class TSpec > inline void clear(Iter<TIndex, VSTree<TSpec> > &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1761)
template <typename TText, typename TShapeSpec, typename TSpec > inline void clear(Index<TText, IndexQGram<TShapeSpec, TSpec> > &index);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(2352)
template <typename TValue, typename TSpec> inline void clear(String<TValue, PizzaChili<TSpec> >& me);       	// "seqan-1.3.1/seqan/index/index_pizzachili_string.h"(193)
template <typename TText, typename TSpec> inline void clear(Index<TText, IndexEsa<TSpec> > &index);       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(363)
template <typename TText, typename TSpec, typename TSpecFinder > inline void clear(Finder< Index<TText, TSpec>, TSpecFinder > & me);       	// "seqan-1.3.1/seqan/index/find_index.h"(183)
template <typename TText, typename TSpec > inline void clear(Index<TText, IndexWotd<TSpec> > &index);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(1934)

//____________________________________________________________________________
// computeExactQGramThreshold

template <typename TThreshString, typename TStateString > void computeExactQGramThreshold( TThreshString &treshPerError, TStateString const &states, int span, int maxErrors, int maxN, bool optionMinOutput);       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(778)

//____________________________________________________________________________
// computeQGramFilteringSensitivity

template <typename TLossString, typename TLogErrorDistr, typename TStateString > void computeQGramFilteringSensitivity( TLossString &found, TStateString const &states, int span, int maxT, int maxErrors, TLogErrorDistr const &logError, bool optionMinOutput);       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(910)

//____________________________________________________________________________
// container

template <typename TIndex, class TSpec > inline TIndex const & container(Iter< TIndex, VSTree<TSpec> > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(694)
template <typename TIndex, class TSpec > inline TIndex & container(Iter< TIndex, VSTree<TSpec> > &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(700)
template <typename TText, typename TSpec, typename TSpecFinder > inline typename Parameter_< Index<TText, TSpec> >::Type container(Finder< Index<TText, TSpec>, TSpecFinder > & me);       	// "seqan-1.3.1/seqan/index/find_index.h"(116)
template <typename TText, typename TSpec, typename TSpecFinder > inline typename Parameter_< Index<TText, TSpec> >::Type container(Finder< Index<TText, TSpec>, TSpecFinder > const & me);       	// "seqan-1.3.1/seqan/index/find_index.h"(124)

//____________________________________________________________________________
// control

template <typename TInput > inline bool control(Pipe< TInput, LarssonSadakane > &me, ControlBeginRead const &command);       	// "seqan-1.3.1/seqan/index/index_sa_lss.h"(437)
template <typename TInput > inline bool control(Pipe< TInput, Merger7 > &me, ControlBeginRead const &command);       	// "seqan-1.3.1/seqan/index/pipe_merger7.h"(459)
template <typename TInput > inline bool control(Pipe< TInput, Merger7 > &me, ControlEof const &);       	// "seqan-1.3.1/seqan/index/pipe_merger7.h"(467)
template <typename TInput > inline bool control(Pipe< TInput, Merger7 > &me, ControlEos const &);       	// "seqan-1.3.1/seqan/index/pipe_merger7.h"(472)
template <typename TInput, typename TLimitsString > inline bool control(Pipe< TInput, Merger7Multi<TLimitsString> > &me, ControlBeginRead const &command);       	// "seqan-1.3.1/seqan/index/pipe_merger7.h"(490)
template <typename TInput, typename TLimitsString > inline bool control(Pipe< TInput, Merger7Multi<TLimitsString> > &me, ControlEof const &);       	// "seqan-1.3.1/seqan/index/pipe_merger7.h"(497)
template <typename TInput, typename TLimitsString > inline bool control(Pipe< TInput, Merger7Multi<TLimitsString> > &me, ControlEos const &);       	// "seqan-1.3.1/seqan/index/pipe_merger7.h"(502)
template <typename TInput > inline bool control(Pipe< TInput, Merger3 > &me, ControlBeginRead const &command);       	// "seqan-1.3.1/seqan/index/pipe_merger3.h"(148)

//____________________________________________________________________________
// coprimeTest

template <typename TSize> inline unsigned coprimeTest(TSize hlen);       	// "seqan-1.3.1/seqan/index/index_qgram_openaddressing.h"(289)

//____________________________________________________________________________
// countChildren

template <typename TIndex, typename TSpec > inline typename Size<TIndex>::Type countChildren(Iter<TIndex, VSTree<TSpec> > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1018)
template <typename TText, typename TIndexSpec, typename TSpec > inline typename Size<Index<TText, IndexEsa<TIndexSpec> > >::Type countChildren(Iter< Index<TText, IndexEsa<TIndexSpec> >, VSTree<TSpec> > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1035)

//____________________________________________________________________________
// countOccurrences

template <typename TIndex, class TSpec > inline typename Size<TIndex>::Type countOccurrences(Iter< TIndex, VSTree<TSpec> > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(810)
template <typename TObject, typename TShapeSpec, typename TSpec, typename TShapeSpec2, typename TValue > inline typename Size< typename Fibre< Index< TObject, IndexQGram<TShapeSpec, TSpec> >, FibreSA>::Type const >::Type countOccurrences( Index< TObject, IndexQGram<TShapeSpec, TSpec> > const &index, Shape< TValue, TShapeSpec2 > const &shape);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(2291)
template <typename TObject, typename TShapeSpec, typename TSpec, typename TShapeSpec2, typename TValue > inline typename Size< typename Fibre< Index< TObject, IndexQGram<TShapeSpec, TSpec> >, FibreSA>::Type const >::Type countOccurrences( Index< TObject, IndexQGram<TShapeSpec, TSpec> > &index, Shape< TValue, TShapeSpec2 > const &shape);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(2302)

//____________________________________________________________________________
// countOccurrencesMultiple

template <typename TObject, typename TShapeSpec, typename TSpec, typename TShapeSpec2, typename TValue > inline typename Infix< typename Fibre< Index< TObject, IndexQGram<TShapeSpec, TSpec> >, FibreCounts>::Type const >::Type countOccurrencesMultiple( Index< TObject, IndexQGram<TShapeSpec, TSpec> > const &index, Shape< TValue, TShapeSpec2 > const &shape);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(2330)
template <typename TObject, typename TShapeSpec, typename TSpec, typename TShapeSpec2, typename TValue > inline typename Infix< typename Fibre< Index< TObject, IndexQGram<TShapeSpec, TSpec> >, FibreCounts>::Type const >::Type countOccurrencesMultiple( Index< TObject, IndexQGram<TShapeSpec, TSpec> > &index, Shape< TValue, TShapeSpec2 > const &shape);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(2341)

//____________________________________________________________________________
// countSequences

template <typename TText, typename TSpec> inline typename Size<TText>::Type countSequences(Index<TText, TSpec> const &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(747)

//____________________________________________________________________________
// cp___

template <typename Dest, typename Ofs, typename Src> static finline Src const cp___(Dest &dst, Ofs const ofs, Src const src);       	// "seqan-1.3.1/seqan/index/pump_extender7.h"(81)

//____________________________________________________________________________
// createBWTable

template <typename TBWT, typename TText, typename TSA > inline void createBWTable(TBWT &bwt, TText const &s, TSA const &sa);       	// "seqan-1.3.1/seqan/index/index_shims.h"(509)

//____________________________________________________________________________
// createBWTableExt

template <typename TBWT, typename TText, typename TSA > void createBWTableExt( TBWT &bwt, TText const &s, TSA const &SA);       	// "seqan-1.3.1/seqan/index/index_shims.h"(462)

//____________________________________________________________________________
// createBWTableInt

template <typename TBWT, typename TText, typename TSA > void createBWTableInt( TBWT &bwt, TText const &s, TSA const &SA);       	// "seqan-1.3.1/seqan/index/index_bwt.h"(261)
template <typename TBWT, typename TString, typename TSpec, typename TSA > void createBWTableInt( TBWT &bwt, StringSet<TString, TSpec> const &s, TSA const &SA);       	// "seqan-1.3.1/seqan/index/index_bwt.h"(287)

//____________________________________________________________________________
// createChildtab

template <typename TLCPTable, typename TValue, typename TConfig > inline void createChildtab( String<TValue, External<TConfig> > &childtab, TLCPTable &lcp);       	// "seqan-1.3.1/seqan/index/index_childtab.h"(217)
template <typename TLCPInput, typename TDest > inline void createChildtab(TDest &dest, TLCPInput const &lcpIn);       	// "seqan-1.3.1/seqan/index/index_childtab.h"(229)

//____________________________________________________________________________
// createChildtabExt

template <typename TLCPTable, typename TChildTable > void createChildtabExt( TChildTable &childtab, TLCPTable &lcp);       	// "seqan-1.3.1/seqan/index/index_childtab.h"(190)

//____________________________________________________________________________
// createCountsArray

template <typename TCounts, typename TDir, typename TBucketMap, typename TString, typename TSpec, typename TShape, typename TStepSize > void createCountsArray( TCounts &counts, TDir &dir, TBucketMap &bucketMap, StringSet<TString, TSpec> const &stringSet, TShape shape, TStepSize stepSize);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(1525)

//____________________________________________________________________________
// createLcpBinTree

template <class LCPFwdIt, class FlatOutIt > inline FlatOutIt createLcpBinTree( LCPFwdIt First_, LCPFwdIt _Last, FlatOutIt Dest_);       	// "seqan-1.3.1/seqan/index/index_lcp_tree.h"(47)
template <typename TLCPE, typename TLCP > inline void createLcpBinTree(TLCPE &lcp_enhanced, TLCP &lcp);       	// "seqan-1.3.1/seqan/index/index_lcp_tree.h"(153)
template <typename TValue, typename TConfig, typename TLCP > inline void createLcpBinTree(String<TValue, External<TConfig> > &lcp_enhanced, TLCP &lcp);       	// "seqan-1.3.1/seqan/index/index_lcp_tree.h"(169)

//____________________________________________________________________________
// createLcpTable

template <typename TLCP, typename TText, typename TSA, typename TAlgSpec > inline void createLcpTable( TLCP &lcp, TText const &s, TSA const &sa, TAlgSpec const &alg);       	// "seqan-1.3.1/seqan/index/index_shims.h"(335)

//____________________________________________________________________________
// createLcpeTable

template <typename TValue, typename TSpec, typename TText, typename TSA, typename TLCP, typename TAlgSpec > void createLcpeTable( String< TValue, TSpec > &LCPE, TText const &s, TSA const &, TLCP const &LCP, TAlgSpec const);       	// "seqan-1.3.1/seqan/index/index_shims.h"(401)
template <typename TValue, typename TConfig, typename TText, typename TSA, typename TLCP, typename TAlgSpec > void createLcpeTable( String< TValue, External<TConfig> > &LCPE, TText const &s, TSA const &SA, TLCP const &LCP, TAlgSpec const alg);       	// "seqan-1.3.1/seqan/index/index_shims.h"(425)
template <typename TValue, typename TSpec, typename TText, typename TSA, typename TLCP> inline void createLcpeTable( String< TValue, TSpec > &LCPE, TText &s, TSA &SA, TLCP &LCP);       	// "seqan-1.3.1/seqan/index/index_shims.h"(441)

//____________________________________________________________________________
// createLcpeTableExt

template <typename TValue, typename TSpec, typename TObject, typename TSA, typename TLCP, typename TAlgSpec > void createLcpeTableExt( String< TValue, TSpec > &LCPE, TObject const &text, TSA const &suffixArray, TLCP const & , TAlgSpec const);       	// "seqan-1.3.1/seqan/index/index_shims.h"(366)

//____________________________________________________________________________
// createQGramIndex

template <typename TIndex > void createQGramIndex(TIndex &index);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(1187)
template <typename TSA, typename TDir, typename TBucketMap, typename TText, typename TShape, typename TStepSize > void createQGramIndex( TSA &sa, TDir &dir, TBucketMap &bucketMap, TText const &text, TShape &shape, TStepSize stepSize);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(1238)
template <typename TSA, typename TDir, typename TBucketMap, typename TText, typename TShape, typename TStepSize > void createQGramIndex( TSA &sa, TDir &dir, TBucketMap &bucketMap, TText const &text, TShape &shape);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(1269)

//____________________________________________________________________________
// createQGramIndexDirOnly

template <typename TDir, typename TBucketMap, typename TText, typename TShape, typename TStepSize > void createQGramIndexDirOnly( TDir &dir, TBucketMap &bucketMap, TText const &text, TShape &shape, TStepSize stepSize);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(1450)
template <typename TDir, typename TBucketMap, typename TString, typename TSpec, typename TShape, typename TStepSize > void createQGramIndexDirOnly( TDir &dir, TBucketMap &bucketMap, StringSet<TString, TSpec> const &stringSet, TShape &shape, TStepSize stepSize);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(1476)

//____________________________________________________________________________
// createQGramIndexExt

template <typename TSA, typename TDir, typename TText, typename TValue, unsigned q > void createQGramIndexExt( TSA &suffixArray, TDir &dir, TText &text, Shape<TValue, UngappedShape<q> >);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(1689)
template <typename TSA, typename TDir, typename TString, typename TSpec, typename TValue, unsigned q, typename TLimitsString > void createQGramIndexExt( TSA &suffixArray, TDir &dir, StringSet<TString, TSpec> const &stringSet, Shape<TValue, UngappedShape<q> >, TLimitsString &limits);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(1778)

//____________________________________________________________________________
// createQGramIndexSAOnly

template <typename TSA, typename TText, typename TShape, typename TStepSize > void createQGramIndexSAOnly( TSA &sa, TText const &text, TShape &shape, TStepSize stepSize);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(1299)
template <typename TSA, typename TString, typename TSpec, typename TShape, typename TStepSize > void createQGramIndexSAOnly( TSA &sa, StringSet<TString, TSpec> const &stringSet, TShape &shape, TStepSize stepSize);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(1336)

//____________________________________________________________________________
// createSABTree

template <class SAFwdIt, class FlatOutIt > inline FlatOutIt createSABTree( SAFwdIt First_, SAFwdIt _Last, FlatOutIt Dest_, unsigned BlockSize);       	// "seqan-1.3.1/seqan/index/index_sa_btree.h"(47)
template <typename TSAB, typename TSA > inline void createSABTree(TSAB &sa_btree, TSA &sa, unsigned BlockSize);       	// "seqan-1.3.1/seqan/index/index_sa_btree.h"(110)
template <typename TValue, typename TConfig, typename TSA > inline void createSABTree(String<TValue, External<TConfig> > &sa_btree, TSA &sa, unsigned BlockSize);       	// "seqan-1.3.1/seqan/index/index_sa_btree.h"(124)

//____________________________________________________________________________
// createSuffixArray

template <typename TSA, typename TText > void createSuffixArray( TSA &SA, TText &s, Skew7 const &, unsigned K, unsigned maxdepth, unsigned depth);       	// "seqan-1.3.1/seqan/index/index_skew7.h"(491)
template <typename TSA, typename TText > inline void createSuffixArray( TSA &SA, TText &s, Skew7 const &alg, unsigned K, unsigned maxdepth);       	// "seqan-1.3.1/seqan/index/index_skew7.h"(815)
template <typename TSA, typename TText > void createSuffixArray( TSA &SA, TText &s, LarssonSadakane const &, unsigned K);       	// "seqan-1.3.1/seqan/index/index_sa_lss.h"(376)
template <typename TSA, typename TText > void createSuffixArray( TSA &SA, TText &s, Shawarma<DeepShallow> const);       	// "seqan-1.3.1/seqan/index/index_shawarma.h"(72)
template <typename TSA, typename TText > void createSuffixArray( TSA &SA, TText &s, ManberMyers const &, unsigned K, unsigned maxdepth);       	// "seqan-1.3.1/seqan/index/index_sa_mm.h"(56)
template <typename TSA, typename TValue, typename TConfig > inline void createSuffixArray( TSA &SA, String< TValue, External<TConfig> > &s, Skew3 const &spec, unsigned , unsigned );       	// "seqan-1.3.1/seqan/index/index_skew3.h"(313)
template <typename TSA, typename TText > void createSuffixArray( TSA &SA, TText &s, Skew3 const &, unsigned K, unsigned maxdepth, unsigned depth);       	// "seqan-1.3.1/seqan/index/index_skew3.h"(356)
template <typename TSA, typename TText > inline void createSuffixArray( TSA &SA, TText &s, Skew3 const &alg, unsigned K, unsigned maxdepth);       	// "seqan-1.3.1/seqan/index/index_skew3.h"(506)
template <typename TSA, typename TText > inline void createSuffixArray( TSA &SA, TText &s, SAQSort const &);       	// "seqan-1.3.1/seqan/index/index_sa_qsort.h"(157)
template <typename TSA, typename TText, typename TSSetSpec > inline void createSuffixArray( TSA &SA, StringSet< TText, TSSetSpec > const &s, SAQSort const &);       	// "seqan-1.3.1/seqan/index/index_sa_qsort.h"(182)
template <typename TSA, typename TText, typename TAlgSpec > inline void createSuffixArray( TSA &sa, TText const &s, TAlgSpec const &alg);       	// "seqan-1.3.1/seqan/index/index_shims.h"(198)
template <typename TSA, typename TText, typename TSpec > inline void createSuffixArray( TSA &SA, TText const &s, BwtWalk<TSpec> const &);       	// "seqan-1.3.1/seqan/index/index_sa_bwtwalk.h"(73)

//____________________________________________________________________________
// createSuffixArrayPart

template <typename TSA, typename TText, typename TSize > inline void createSuffixArrayPart( TSA &SA, TText &s, Skew7 const &_dummy, TSize maxLCP, unsigned K);       	// "seqan-1.3.1/seqan/index/index_skew7.h"(829)
template <typename TSA, typename TText, typename TSize > inline void createSuffixArrayPart( TSA &SA, TText &s, Skew7 const &_dummy, TSize maxLCP);       	// "seqan-1.3.1/seqan/index/index_skew7.h"(845)
template <typename TSA, typename TText, typename TSize > inline void createSuffixArrayPart( TSA &SA, TText &s, ManberMyers const &alg, TSize maxLCP, unsigned K);       	// "seqan-1.3.1/seqan/index/index_sa_mm.h"(181)
template <typename TSA, typename TText, typename TSize > inline void createSuffixArrayPart( TSA &SA, TText &s, ManberMyers const &alg, TSize maxLCP);       	// "seqan-1.3.1/seqan/index/index_sa_mm.h"(195)
template <typename TSA, typename TText, typename TSize > inline void createSuffixArrayPart( TSA &SA, TText &s, Skew3 const &_dummy, TSize maxLCP, unsigned K);       	// "seqan-1.3.1/seqan/index/index_skew3.h"(520)
template <typename TSA, typename TText, typename TSize > inline void createSuffixArrayPart( TSA &SA, TText &s, Skew3 const &_dummy, TSize maxLCP);       	// "seqan-1.3.1/seqan/index/index_skew3.h"(535)

//____________________________________________________________________________
// dirAt

template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex, FibreDir>::Type>::Type dirAt(TPos i, TIndex &index);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(385)
template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex const, FibreDir>::Type>::Type dirAt(TPos i, TIndex const &index);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(390)

//____________________________________________________________________________
// empty

template <typename TIndex, typename TSpec> inline bool empty(Pattern<TIndex, Swift<TSpec> > & me);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1217)
template <typename TIndex, class TSpec > inline bool empty(Iter<TIndex, VSTree<TSpec> > &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1859)
template <typename TIndex, class TSpec > inline bool empty(Iter<TIndex, VSTree<TSpec> > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1865)
template <typename TText, typename TSpec, typename TSpecFinder > inline bool empty(Finder< Index<TText, TSpec>, TSpecFinder > & me);       	// "seqan-1.3.1/seqan/index/find_index.h"(175)

//____________________________________________________________________________
// emptyParentEdge

template <typename TIndex, typename TSpec > inline bool emptyParentEdge(Iter< TIndex, VSTree<TopDown<TSpec> > > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(564)
template <typename TText, typename TIndexSpec, typename TSpec > inline bool emptyParentEdge(Iter< Index<TText, IndexWotd<TIndexSpec> >, VSTree<TopDown<TSpec> > > const &it);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(563)
template <typename TText, typename TIndexSpec, typename TSpec > inline bool emptyParentEdge(Iter< Index<TText, IndexWotd<TIndexSpec> >, VSTree<TopDown<ParentLinks<TSpec> > > > const &it);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(576)

//____________________________________________________________________________
// end

template <typename TSTree, class TSpec > inline typename Iterator< Iter< TSTree, VSTree< BottomUp<MaxRepeats_<TSpec> > > > >::Type end(Iter< TSTree, VSTree< BottomUp<MaxRepeats_<TSpec> > > > &it);       	// "seqan-1.3.1/seqan/index/index_esa_algs.h"(653)
template <typename TText, typename TIndexSpec, class TSpec > inline typename Iterator<Index<TText, TIndexSpec>, TSpec >::Type end(Index<TText, TIndexSpec> &index, TSpec const);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1254)
template <typename TValue, typename TSpec, typename TTag> inline typename Iterator<String<TValue, PizzaChili<TSpec> >, Tag<TSpec> const>::Type end( String<TValue, PizzaChili<TSpec> >& me, Tag<TTag> const );       	// "seqan-1.3.1/seqan/index/index_pizzachili_string.h"(501)
template <typename TValue, typename TSpec, typename TTag> inline typename Iterator<String<TValue, PizzaChili<TSpec> > const, Tag<TSpec> const>::Type end( String<TValue, PizzaChili<TSpec> > const& me, Tag<TTag> const );       	// "seqan-1.3.1/seqan/index/index_pizzachili_string.h"(512)

//____________________________________________________________________________
// endPosition

template <typename THaystack, typename TSpec> inline typename Position<Finder<THaystack, Swift<TSpec> > >::Type endPosition(Finder<THaystack, Swift<TSpec> > const & finder);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1334)
template <typename THaystack, typename TSpec> inline typename Position<Finder<THaystack, Swift<TSpec> > >::Type endPosition(Finder<THaystack, Swift<TSpec> > & finder);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1342)
template <typename TIndex, typename TSpec> inline typename SAValue<TIndex>::Type endPosition(Pattern<TIndex, Swift<TSpec> > const & pattern);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1351)
template <typename TIndex, typename TSpec> inline typename SAValue<TIndex >::Type endPosition(Pattern<TIndex, Swift<Tag<SwiftSemiGlobal_<TSpec> > > > const & pattern);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1364)
template <typename TIndex, typename TSpec> inline typename SAValue<TIndex>::Type endPosition(Pattern<TIndex, Swift<TSpec> > & pattern);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1374)
template <typename TText, typename TSpec, typename TSpecFinder > inline typename Position< Finder< Index<TText, TSpec>, TSpecFinder > >::Type endPosition(Finder< Index<TText, TSpec>, TSpecFinder > & me);       	// "seqan-1.3.1/seqan/index/find_index.h"(253)
template <typename TText, typename TSpec, typename TSpecFinder > inline typename Position< Finder< Index<TText, TSpec>, TSpecFinder > >::Type endPosition(Finder< Index<TText, TSpec>, TSpecFinder > const & me);       	// "seqan-1.3.1/seqan/index/find_index.h"(261)

//____________________________________________________________________________
// eof

template <typename TIndex, class TSpec > inline bool eof(Iter<TIndex, VSTree<TSpec> > &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1847)
template <typename TIndex, class TSpec > inline bool eof(Iter<TIndex, VSTree<TSpec> > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1853)

//____________________________________________________________________________
// equalRangeLcpe

template <typename TText, typename TSA, typename TLCPE, typename TQuery > inline Pair< typename Position<TSA>::Type > equalRangeLcpe( TText const &text, TSA const &sa, TLCPE const &lcpe, TQuery const &query);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(1741)
template <typename TText, typename TSA, typename TLCPE, typename TQuery > inline Pair< typename Position<TSA>::Type > equalRangeLcpe( TText const &text, TSA const &sa, TLCPE const &lcpe, TQuery *query);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(1843)

//____________________________________________________________________________
// equalRangeLcpeIterator

template <typename TText, typename TSA, typename TLCPE, typename TQuery > inline Pair< typename Iterator<TSA, Standard>::Type > equalRangeLcpeIterator( TText const &text, TSA const &sa, TLCPE const &lcpe, TQuery const &query);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(1792)
template <typename TText, typename TSA, typename TLCPE, typename TQuery > inline Pair< typename Iterator<TSA, Standard>::Type > equalRangeLcpeIterator( TText const &text, TSA const &sa, TLCPE const &lcpe, TQuery *query);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(1862)

//____________________________________________________________________________
// equalRangeSA

template <typename TText, typename TSA, typename TQuery, typename TFlatTreeSpec > inline Pair< typename Position<TSA>::Type > equalRangeSA( TText const &text, TSA const &sa, TQuery const &query, TFlatTreeSpec const);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(1008)
template <typename TText, typename TSA, typename TQuery > inline Pair< typename Position<TSA>::Type > equalRangeSA( TText const &text, TSA const &sa, TQuery const &query);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(1025)
template <typename TText, typename TSA, typename TQuery, typename TFlatTreeSpec > inline Pair< typename Position<TSA>::Type > equalRangeSA( TText const &text, TSA const &sa, TQuery *query, TFlatTreeSpec const);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(1105)
template <typename TText, typename TSA, typename TQuery > inline Pair< typename Position<TSA>::Type > equalRangeSA( TText const &text, TSA const &sa, TQuery *query);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(1122)

//____________________________________________________________________________
// equalRangeSAIterator

template <typename TText, typename TSA, typename TQuery > inline Pair< typename Iterator<TSA const, Standard>::Type > equalRangeSAIterator( TText const &text, TSA const &sa, TQuery const &query);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(869)
template <typename TText, typename TSA, typename TQuery > inline Pair< typename Iterator<TSA const, Standard>::Type > equalRangeSAIterator( TText const &text, TSA const &sa, TQuery *query);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(928)

//____________________________________________________________________________
// equalRangeSANaiveIterator

template <typename TText, typename TSA, typename TQuery > inline Pair< typename Iterator<TSA const, Standard>::Type > equalRangeSANaiveIterator( TText const &text, TSA const &sa, TQuery const &query);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(883)

//____________________________________________________________________________
// find

template <typename TFinder, typename TNeedle> inline bool find(TFinder & finder, Pattern<TNeedle, Quasar> & me);       	// "seqan-1.3.1/seqan/index/find_quasar.h"(152)
template <typename TFinder, typename TIndex, typename TSpec> inline bool find( TFinder &finder, Pattern<TIndex, Swift<Tag<SwiftSemiGlobal_<TSpec> > > > &pattern, double errorRate);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1671)
template <typename THaystack, typename TIndex, typename TSpec, typename TSize> inline bool find( Finder<THaystack, Swift<TSpec> > &finder, Pattern<TIndex, Swift<TSpec> > &pattern, double errorRate, TSize minLength);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1682)
template <typename THashes, typename TPipeSpec, typename TIndex, typename TSpec> inline bool find( Finder<Pipe<THashes, TPipeSpec>, Swift<TSpec> > &finder, Pattern<TIndex, Swift<TSpec> > &pattern, double errorRate);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1758)
template <typename TText, typename TSpec, typename TSpecFinder, typename TPattern > inline bool find( Finder<Index<TText, TSpec>, TSpecFinder> &finder, TPattern const &pattern);       	// "seqan-1.3.1/seqan/index/find_index.h"(291)
template <typename TText, typename TSpec, typename TSpecFinder > inline bool find(Finder<Index<TText, TSpec>, TSpecFinder> &finder);       	// "seqan-1.3.1/seqan/index/find_index.h"(304)

//____________________________________________________________________________
// findRepeats

template <typename TRepeatStore, typename TString, typename TRepeatSize> inline void findRepeats(TRepeatStore &repString, TString const &text, TRepeatSize minRepeatLen);       	// "seqan-1.3.1/seqan/index/repeat_base.h"(130)
template <typename TRepeatStore, typename TString, typename TSpec, typename TRepeatSize> inline void findRepeats(TRepeatStore &repString, StringSet<TString, TSpec> const &text, TRepeatSize minRepeatLen);       	// "seqan-1.3.1/seqan/index/repeat_base.h"(176)
template <typename TRepeatStore, typename TText, typename TRepeatSize, typename TPeriodSize> void findRepeats(TRepeatStore &repString, TText const &text, TRepeatSize minRepeatLen, TPeriodSize maxPeriod);       	// "seqan-1.3.1/seqan/index/repeat_base.h"(228)

//____________________________________________________________________________
// getBucket

template <typename THashValue > inline THashValue getBucket(Nothing const &, THashValue hash);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(859)
template <typename THashValue, typename THashValue2 > inline THashValue getBucket(BucketMap<THashValue> const &bucketMap, THashValue2 hash);       	// "seqan-1.3.1/seqan/index/index_qgram_openaddressing.h"(242)

//____________________________________________________________________________
// getFibre

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, PizzaChili<TSpec> > const, PizzaChiliText>::Type getFibre(Index<TText, PizzaChili<TSpec> > const& me, PizzaChiliText const);       	// "seqan-1.3.1/seqan/index/index_pizzachili.h"(226)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, PizzaChili<TSpec> >, PizzaChiliText>::Type getFibre(Index<TText, PizzaChili<TSpec> >& me, PizzaChiliText const);       	// "seqan-1.3.1/seqan/index/index_pizzachili.h"(233)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, FibreDir>::Type & getFibre(Index<TText, TSpec> &index, FibreDir);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(294)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, FibreDir>::Type & getFibre(Index<TText, TSpec> const &index, FibreDir);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(299)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, FibreCounts>::Type & getFibre(Index<TText, TSpec> &index, FibreCounts);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(305)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, FibreCounts>::Type & getFibre(Index<TText, TSpec> const &index, FibreCounts);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(310)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, FibreCountsDir>::Type & getFibre(Index<TText, TSpec> &index, FibreCountsDir);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(316)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, FibreCountsDir>::Type & getFibre(Index<TText, TSpec> const &index, FibreCountsDir);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(321)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, FibreBucketMap>::Type & getFibre(Index<TText, TSpec> &index, FibreBucketMap);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(327)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, FibreBucketMap>::Type & getFibre(Index<TText, TSpec> const &index, FibreBucketMap);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(332)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, FibreShape>::Type & getFibre(Index<TText, TSpec> &index, FibreShape);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(338)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, FibreShape>::Type & getFibre(Index<TText, TSpec> const &index, FibreShape);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(343)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, FibreText>::Type & getFibre(Index<TText, TSpec> &index, FibreText);       	// "seqan-1.3.1/seqan/index/index_base.h"(601)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, FibreText>::Type & getFibre(Index<TText, TSpec> const &index, FibreText);       	// "seqan-1.3.1/seqan/index/index_base.h"(606)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, FibreRawText>::Type & getFibre(Index<TText, TSpec> &index, FibreRawText);       	// "seqan-1.3.1/seqan/index/index_base.h"(614)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, FibreRawText>::Type & getFibre(Index<TText, TSpec> const &index, FibreRawText);       	// "seqan-1.3.1/seqan/index/index_base.h"(619)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, FibreSA>::Type & getFibre(Index<TText, TSpec> &index, FibreSA);       	// "seqan-1.3.1/seqan/index/index_base.h"(627)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, FibreSA>::Type & getFibre(Index<TText, TSpec> const &index, FibreSA);       	// "seqan-1.3.1/seqan/index/index_base.h"(632)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, FibreRawSA>::Type getFibre(Index<TText, TSpec> &index, FibreRawSA);       	// "seqan-1.3.1/seqan/index/index_base.h"(667)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, FibreLcp>::Type & getFibre(Index<TText, TSpec> &index, FibreLcp);       	// "seqan-1.3.1/seqan/index/index_base.h"(686)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, FibreLcp>::Type & getFibre(Index<TText, TSpec> const &index, FibreLcp);       	// "seqan-1.3.1/seqan/index/index_base.h"(691)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, FibreLcpe>::Type & getFibre(Index<TText, TSpec> &index, FibreLcpe);       	// "seqan-1.3.1/seqan/index/index_base.h"(699)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, FibreLcpe>::Type & getFibre(Index<TText, TSpec> const &index, FibreLcpe);       	// "seqan-1.3.1/seqan/index/index_base.h"(704)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, FibreChildtab>::Type & getFibre(Index<TText, TSpec> &index, FibreChildtab);       	// "seqan-1.3.1/seqan/index/index_base.h"(712)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, FibreChildtab>::Type & getFibre(Index<TText, TSpec> const &index, FibreChildtab);       	// "seqan-1.3.1/seqan/index/index_base.h"(717)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, FibreBwt>::Type & getFibre(Index<TText, TSpec> &index, FibreBwt);       	// "seqan-1.3.1/seqan/index/index_base.h"(725)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, FibreBwt>::Type & getFibre(Index<TText, TSpec> const &index, FibreBwt);       	// "seqan-1.3.1/seqan/index/index_base.h"(730)

//____________________________________________________________________________
// getFrequency

template <typename TIndex, class TSpec, typename TSet > inline typename Size<TIndex>::Type getFrequency(Iter<TIndex, VSTree<TSpec> > const &it, TSet &set);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(2099)
template <typename TIndex, class TSpec > inline typename Size<TIndex>::Type getFrequency(Iter<TIndex, VSTree<TSpec> > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(2127)

//____________________________________________________________________________
// getKmerSimilarityMatrix

template <typename TObject, typename TShapeSpec, typename TSpec, typename TDistMatrix > inline void getKmerSimilarityMatrix( Index< TObject, IndexQGram<TShapeSpec, TSpec> > &index, TDistMatrix &distMat);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(1954)
template <typename TObject, typename TShapeSpec, typename TSpec, typename TDistMatrix, typename TSeqNoString > inline void getKmerSimilarityMatrix( Index< TObject, IndexQGram<TShapeSpec, TSpec> > &index, TDistMatrix &distMat, TSeqNoString const &seqNo);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(2054)

//____________________________________________________________________________
// getOccurrence

template <typename TIndex, class TSpec > inline typename SAValue<TIndex>::Type getOccurrence(Iter< TIndex, VSTree<TSpec> > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(789)
template <typename TObject, typename TShapeSpec, typename TSpec, typename TShapeSpec2, typename TValue > inline typename SAValue< Index< TObject, IndexQGram<TShapeSpec, TSpec> > >::Type getOccurrence( Index< TObject, IndexQGram<TShapeSpec, TSpec> > const &index, Shape< TValue, TShapeSpec2 > const &shape);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(2221)
template <typename TObject, typename TShapeSpec, typename TSpec, typename TShapeSpec2, typename TValue > inline typename SAValue< Index< TObject, IndexQGram<TShapeSpec, TSpec> > >::Type getOccurrence( Index< TObject, IndexQGram<TShapeSpec, TSpec> > &index, Shape< TValue, TShapeSpec2 > const &shape);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(2230)
template <typename TText, typename TSpec > inline typename SAValue<Index<TText, IndexWotd<WotdOriginal> > >::Type getOccurrence(Iter< Index<TText, IndexWotd<WotdOriginal> >, VSTree<TSpec> > const &it);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(556)

//____________________________________________________________________________
// getOccurrences

template <typename TIndex, class TSpec > inline typename Infix< typename Fibre<TIndex, FibreSA>::Type const >::Type getOccurrences(Iter< TIndex, VSTree<TSpec> > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(868)
template <typename TObject, typename TShapeSpec, typename TSpec, typename TShapeSpec2, typename TValue > inline typename Infix< typename Fibre< Index< TObject, IndexQGram<TShapeSpec, TSpec> >, FibreSA>::Type const >::Type getOccurrences( Index< TObject, IndexQGram<TShapeSpec, TSpec> > const &index, Shape< TValue, TShapeSpec2 > const &shape);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(2255)
template <typename TObject, typename TShapeSpec, typename TSpec, typename TShapeSpec2, typename TValue > inline typename Infix< typename Fibre< Index< TObject, IndexQGram<TShapeSpec, TSpec> >, FibreSA>::Type const >::Type getOccurrences( Index< TObject, IndexQGram<TShapeSpec, TSpec> > &index, Shape< TValue, TShapeSpec2 > const &shape);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(2266)

//____________________________________________________________________________
// getOccurrencesBwt

template <typename TIndex, class TSpec > inline typename Infix< typename Fibre<TIndex, EsaBwt>::Type const >::Type getOccurrencesBwt(Iter< TIndex, VSTree<TSpec> > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(974)

//____________________________________________________________________________
// getSequenceByNo

template <typename TSeqNo, typename TText, typename TSpec> inline typename GetSequenceByNo< Index<TText, TSpec> >::Type getSequenceByNo(TSeqNo seqNo, Index<TText, TSpec> &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(770)
template <typename TSeqNo, typename TText, typename TSpec> inline typename GetSequenceByNo< Index<TText, TSpec> const>::Type getSequenceByNo(TSeqNo seqNo, Index<TText, TSpec> const &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(777)

//____________________________________________________________________________
// getStepSize

template <typename TText, typename TShapeSpec, typename TSpec> inline typename Size<TText>::Type getStepSize(Index<TText, IndexQGram<TShapeSpec, TSpec> > const &index);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(504)

//____________________________________________________________________________
// getSwiftHits

template <typename THaystack, typename TSpec> inline typename Finder<THaystack, Swift<TSpec> >::THitString & getSwiftHits(Finder<THaystack, Swift<TSpec> > &finder);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1948)

//____________________________________________________________________________
// goBegin

template <typename TRepeat > inline void goBegin(Iter<TRepeat, MaxRepeatOccurrences> &it);       	// "seqan-1.3.1/seqan/index/index_esa_algs.h"(897)
template <typename TText, typename TIndexSpec, class TSpec > inline void goBegin(Iter<Index<TText, TIndexSpec>, VSTree<TSpec> > &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1214)
template <typename TText, typename TIndexSpec, class TSpec > inline void goBegin(Iter<Index<TText, IndexEsa<TIndexSpec> >, VSTree< BottomUp<TSpec> > > &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1233)
template <typename TText, typename TSpec, typename TSpecFinder > inline void goBegin(Finder< Index<TText, TSpec>, TSpecFinder > & me);       	// "seqan-1.3.1/seqan/index/find_index.h"(215)

//____________________________________________________________________________
// goDown

template <typename TIndex, class TSpec > inline bool goDown(Iter< TIndex, VSTree< TopDown<TSpec> > > &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1441)
template <typename TIndex, typename TSpec, typename TObject > inline bool goDown( Iter< TIndex, VSTree< TopDown<TSpec> > > &it, TObject const &obj);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1546)
template <typename TIndex, typename TSpec, typename TString, typename TSize > inline bool goDown( Iter< TIndex, VSTree< TopDown<TSpec> > > &it, TString const &pattern, TSize &lcp);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1556)

//____________________________________________________________________________
// goEnd

template <typename TRepeat > inline void goEnd(Iter<TRepeat, MaxRepeatOccurrences> &it);       	// "seqan-1.3.1/seqan/index/index_esa_algs.h"(906)
template <typename THaystack, typename TSpec> inline void goEnd(Finder<THaystack, Swift<TSpec> > & me);       	// "seqan-1.3.1/seqan/index/find_swift.h"(378)
template <typename TText, typename TIndexSpec, class TSpec > inline void goEnd(Iter<Index<TText, IndexEsa<TIndexSpec> >, VSTree<TSpec> > &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1265)
template <typename TText, typename TIndexSpec, class TSpec > inline void goEnd(Iter<Index<TText, IndexEsa<TIndexSpec> >, VSTree< BottomUp<TSpec> > > &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1272)
template <typename TText, typename TSpec, typename TSpecFinder > inline void goEnd(Finder< Index<TText, TSpec>, TSpecFinder > & me);       	// "seqan-1.3.1/seqan/index/find_index.h"(223)

//____________________________________________________________________________
// goNext

template <typename TSTree > inline void goNext(Iter< TSTree, VSTree< BottomUp<SuperMaxRepeats> > > &it);       	// "seqan-1.3.1/seqan/index/index_esa_algs.h"(121)
template <typename TText, typename TSpec > inline void goNext(Iter< Index<TText, IndexEsa<TSpec> >, VSTree< BottomUp<SuperMaxRepeatsFast> > > &it);       	// "seqan-1.3.1/seqan/index/index_esa_algs.h"(223)
template <typename TSTree, typename TSpec > inline void goNext(Iter< TSTree, VSTree< BottomUp<MaxRepeats_<TSpec> > > > &it);       	// "seqan-1.3.1/seqan/index/index_esa_algs.h"(597)
template <typename TRepeat > inline Iter<TRepeat, MaxRepeatOccurrences> & goNext(Iter<TRepeat, MaxRepeatOccurrences> &it);       	// "seqan-1.3.1/seqan/index/index_esa_algs.h"(880)
template <typename TIndex, typename TSpec > inline void goNext(Iter<TIndex, VSTree<TSpec> > &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1283)
template <typename TIndex, typename TSpec, typename TTraits > inline void goNext(Iter<TIndex, VSTree<TSpec> > &it, TTraits const traits);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1288)
template <typename TSTree > inline void goNext(Iter< TSTree, VSTree< BottomUp<Mums> > > &it);       	// "seqan-1.3.1/seqan/index/index_esa_algs_multi.h"(123)
template <typename TRepeat > inline Iter<TRepeat, MultiMemOccurences> & goNext(Iter<TRepeat, MultiMemOccurences> &it);       	// "seqan-1.3.1/seqan/index/index_esa_algs_multi.h"(672)

//____________________________________________________________________________
// goNextImpl

template <typename TIndex, typename TSpec, typename THideEmptyEdges > inline void goNextImpl( Iter<TIndex, VSTree< BottomUp<TSpec> > > &it, VSTreeIteratorTraits<Postorder_, THideEmptyEdges> const);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(401)
template <typename TIndex, typename TSpec, typename THideEmptyEdges > inline void goNextImpl( Iter< TIndex, VSTree< TopDown< ParentLinks<TSpec> > > > &it, VSTreeIteratorTraits<Preorder_, THideEmptyEdges> const);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1779)
template <typename TIndex, typename TSpec, typename THideEmptyEdges > inline void goNextImpl( Iter< TIndex, VSTree< TopDown< ParentLinks<TSpec> > > > &it, VSTreeIteratorTraits<Postorder_, THideEmptyEdges> const);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1829)

//____________________________________________________________________________
// goNextRight

template <typename TIndex, typename TSpec > inline void goNextRight(Iter<TIndex, VSTree<TSpec> > &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1293)
template <typename TIndex, typename TSpec, typename TTraits > inline void goNextRight(Iter<TIndex, VSTree<TSpec> > &it, TTraits const traits);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1298)

//____________________________________________________________________________
// goNextRightImpl

template <typename TIndex, typename TSpec, typename THideEmptyEdges > inline void goNextRightImpl( Iter< TIndex, VSTree< TopDown< ParentLinks<TSpec> > > > &it, VSTreeIteratorTraits<Preorder_, THideEmptyEdges> const);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1795)

//____________________________________________________________________________
// goNextUp

template <typename TIndex, typename TSpec > inline void goNextUp(Iter<TIndex, VSTree<TSpec> > &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1303)
template <typename TIndex, typename TSpec, typename TTraits > inline void goNextUp(Iter<TIndex, VSTree<TSpec> > &it, TTraits const traits);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1308)

//____________________________________________________________________________
// goNextUpImpl

template <typename TIndex, typename TSpec, typename THideEmptyEdges > inline void goNextUpImpl( Iter< TIndex, VSTree< TopDown< ParentLinks<TSpec> > > > &it, VSTreeIteratorTraits<Preorder_, THideEmptyEdges> const);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1811)

//____________________________________________________________________________
// goRight

template <typename TIndex, class TSpec > inline bool goRight(Iter< TIndex, VSTree< TopDown<TSpec> > > &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1687)

//____________________________________________________________________________
// goRoot

template <typename TText, typename TIndexSpec, class TSpec > inline void goRoot(Iter<Index<TText, TIndexSpec>, VSTree<TSpec> > &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1191)
template <typename TText, typename TSpec > inline void goRoot(Iter< Index<TText, IndexWotd<WotdOriginal> >, VSTree<TSpec> > &it);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(592)
template <typename TText, typename TIndexSpec, typename TSpec > inline void goRoot(Iter< Index<TText, IndexWotd<TIndexSpec> >, VSTree<TSpec> > &it);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(604)

//____________________________________________________________________________
// goUp

template <typename TIndex, class TSpec > inline bool goUp(Iter< TIndex, VSTree< TopDown< ParentLinks<TSpec> > > > &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1601)

//____________________________________________________________________________
// hash

template <typename TValue, typename TIter> inline typename Value< Shape<TValue, OneGappedShape> >::Type hash(Shape<TValue, OneGappedShape> &me, TIter it);       	// "seqan-1.3.1/seqan/index/shape_onegapped.h"(171)
template <typename TValue, typename TIter, typename TSize> inline typename Value< Shape<TValue, OneGappedShape> >::Type hash(Shape<TValue, OneGappedShape> &me, TIter it, TSize charsLeft);       	// "seqan-1.3.1/seqan/index/shape_onegapped.h"(192)
template <typename TValue, typename TIter> typename Value< Shape<TValue, SimpleShape> >::Type hash(Shape<TValue, SimpleShape> &me, TIter it);       	// "seqan-1.3.1/seqan/index/shape_base.h"(319)
template <typename TValue, unsigned q, typename TIter> inline typename Value< Shape<TValue, UngappedShape<q> > >::Type hash(Shape<TValue, UngappedShape<q> > &me, TIter it);       	// "seqan-1.3.1/seqan/index/shape_base.h"(355)
template <typename TValue, typename TSpec, typename TIter, typename TSize> inline typename Value< Shape<TValue, TSpec> >::Type hash(Shape<TValue, TSpec> &me, TIter it, TSize charsLeft);       	// "seqan-1.3.1/seqan/index/shape_base.h"(368)
template <typename TValue, typename TTValue, unsigned SIZE, unsigned q> typename Value< Shape<TValue, UngappedShape<q> > >::Type hash( Shape<TValue, UngappedShape<q> > &me, Tuple<TTValue, SIZE, Compressed> const &tuple);       	// "seqan-1.3.1/seqan/index/shape_base.h"(427)
template <typename TValue, typename TTValue, unsigned SIZE, typename TCompressed, unsigned q> typename Value< Shape<TValue, UngappedShape<q> > >::Type hash( Shape<TValue, UngappedShape<q> > &me, Tuple<TTValue, SIZE, TCompressed> const &tuple);       	// "seqan-1.3.1/seqan/index/shape_base.h"(448)
template <typename TValue, typename TIter> inline typename Value< Shape<TValue, GenericShape> >::Type hash(Shape<TValue, GenericShape> &me, TIter it);       	// "seqan-1.3.1/seqan/index/shape_gapped.h"(393)
template <typename TValue, typename TSpec, typename TIter, typename TSize> inline typename Value< Shape<TValue, GappedShape<TSpec> > >::Type hash(Shape<TValue, GappedShape<TSpec> > &me, TIter it, TSize charsLeft);       	// "seqan-1.3.1/seqan/index/shape_gapped.h"(410)
template <int P00, int P01, int P02, int P03, int P04, int P05, int P06, int P07, int P08, int P09, int P10, int P11, int P12, int P13, int P14, int P15, int P16, int P17, int P18, int P19, typename TValue, typename TIter > inline typename Value< Shape<TValue, GappedShape< HardwiredShape< P00,P01,P02,P03,P04, P05,P06,P07,P08,P09, P10,P11,P12,P13,P14, P15,P16,P17,P18,P19 > > > >::Type hash(Shape<TValue, GappedShape< HardwiredShape< P00,P01,P02,P03,P04, P05,P06,P07,P08,P09, P10,P11,P12,P13,P14, P15,P16,P17,P18,P19 > > > &me, TIter it);       	// "seqan-1.3.1/seqan/index/shape_gapped.h"(548)

//____________________________________________________________________________
// hash2

template <typename TValue, typename TSpec, typename TIter, typename TSize> inline typename Value< Shape<TValue, TSpec> >::Type hash2(Shape<TValue, TSpec> &me, TIter it, TSize charsLeft);       	// "seqan-1.3.1/seqan/index/shape_base.h"(543)

//____________________________________________________________________________
// hash2Next

template <typename TValue, typename TSpec, typename TIter, typename TSize> inline typename Value< Shape<TValue, TSpec> >::Type hash2Next(Shape<TValue, TSpec> &me, TIter &it, TSize charsLeft);       	// "seqan-1.3.1/seqan/index/shape_base.h"(635)

//____________________________________________________________________________
// hash2Upper

template <typename TValue, typename TSpec, typename TIter, typename TSize> inline typename Value< Shape<TValue, TSpec> >::Type hash2Upper(Shape<TValue, TSpec> &me, TIter it, TSize charsLeft);       	// "seqan-1.3.1/seqan/index/shape_base.h"(585)

//____________________________________________________________________________
// hashNext

template <typename TValue, typename TIter> inline typename Value< Shape<TValue, OneGappedShape> >::Type hashNext(Shape<TValue, OneGappedShape> &me, TIter &_it);       	// "seqan-1.3.1/seqan/index/shape_onegapped.h"(274)
template <typename TValue, typename TSpec, typename TIter> inline typename Value< Shape<TValue, TSpec> >::Type hashNext(Shape<TValue, TSpec> &me, TIter const &it);       	// "seqan-1.3.1/seqan/index/shape_base.h"(513)
template <typename TValue, typename TSpec, typename TIter> inline typename Value< Shape<TValue, GappedShape<TSpec> > >::Type hashNext(Shape<TValue, GappedShape<TSpec> > &me, TIter &it);       	// "seqan-1.3.1/seqan/index/shape_gapped.h"(567)

//____________________________________________________________________________
// hashUpper

template <typename TValue, typename TIter, typename TSize> inline typename Value< Shape<TValue, OneGappedShape> >::Type hashUpper(Shape<TValue, OneGappedShape> &me, TIter it, TSize charsLeft);       	// "seqan-1.3.1/seqan/index/shape_onegapped.h"(232)
template <typename TValue, typename TSpec, typename TIter, typename TSize> inline typename Value< Shape<TValue, TSpec> >::Type hashUpper(Shape<TValue, TSpec> &me, TIter it, TSize charsLeft);       	// "seqan-1.3.1/seqan/index/shape_base.h"(471)
template <typename TValue, typename TSpec, typename TIter, typename TSize> inline typename Value< Shape<TValue, GappedShape<TSpec> > >::Type hashUpper(Shape<TValue, GappedShape<TSpec> > &me, TIter it, TSize charsLeft);       	// "seqan-1.3.1/seqan/index/shape_gapped.h"(440)

//____________________________________________________________________________
// host

template <typename TNeedle> inline typename Host<Pattern<TNeedle, Quasar>const>::Type & host(Pattern<TNeedle, Quasar> & me);       	// "seqan-1.3.1/seqan/index/find_quasar.h"(133)
template <typename TNeedle> inline typename Host<Pattern<TNeedle, Quasar>const>::Type & host(Pattern<TNeedle, Quasar> const & me);       	// "seqan-1.3.1/seqan/index/find_quasar.h"(141)
template <typename TText, typename TSpec, typename TSpecFinder > inline typename Parameter_< Index<TText, TSpec> >::Type host(Finder< Index<TText, TSpec>, TSpecFinder > & me);       	// "seqan-1.3.1/seqan/index/find_index.h"(100)
template <typename TText, typename TSpec, typename TSpecFinder > inline typename Parameter_< Index<TText, TSpec> >::Type host(Finder< Index<TText, TSpec>, TSpecFinder > const & me);       	// "seqan-1.3.1/seqan/index/find_index.h"(108)

//____________________________________________________________________________
// hostIterator

template <typename TText, typename TSpec, typename TSpecFinder > inline typename Iterator< typename Fibre<Index<TText, TSpec>, FibreSA>::Type const, Standard>::Type & hostIterator(Finder< Index<TText, TSpec>, TSpecFinder > & me);       	// "seqan-1.3.1/seqan/index/find_index.h"(156)
template <typename TText, typename TSpec, typename TSpecFinder > inline typename Iterator< typename Fibre<Index<TText, TSpec>, FibreSA>::Type const, Standard>::Type const & hostIterator(Finder< Index<TText, TSpec>, TSpecFinder > const & me);       	// "seqan-1.3.1/seqan/index/find_index.h"(164)

//____________________________________________________________________________
// indexBucketMap

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, FibreBucketMap>::Type & indexBucketMap(Index<TText, TSpec> &index);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(455)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, FibreBucketMap>::Type & indexBucketMap(Index<TText, TSpec> const &index);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(460)

//____________________________________________________________________________
// indexBwt

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, FibreBwt>::Type & indexBwt(Index<TText, TSpec> &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(1158)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, FibreBwt>::Type & indexBwt(Index<TText, TSpec> const &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(1160)

//____________________________________________________________________________
// indexChildtab

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, FibreChildtab>::Type & indexChildtab(Index<TText, TSpec> &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(1175)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, FibreChildtab>::Type & indexChildtab(Index<TText, TSpec> const &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(1177)

//____________________________________________________________________________
// indexCounts

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, FibreCounts>::Type & indexCounts(Index<TText, TSpec> &index);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(409)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, FibreCounts>::Type & indexCounts(Index<TText, TSpec> const &index);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(414)

//____________________________________________________________________________
// indexCountsDir

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, FibreCountsDir>::Type & indexCountsDir(Index<TText, TSpec> &index);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(432)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, FibreCountsDir>::Type & indexCountsDir(Index<TText, TSpec> const &index);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(437)

//____________________________________________________________________________
// indexCreate

template <typename TText, typename TSpec> inline bool indexCreate(Index<TText, PizzaChili<TSpec> >& me, PizzaChiliCompressed const);       	// "seqan-1.3.1/seqan/index/index_pizzachili.h"(294)
template <typename TText, typename TShapeSpec, typename TSpec> inline bool indexCreate( Index<TText, IndexQGram<TShapeSpec, TSpec> > &index, FibreSADir, Default const);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(1884)
template <typename TText, typename TShapeSpec, typename TSpec> inline bool indexCreate( Index<TText, IndexQGram<TShapeSpec, TSpec> > &index, FibreSA, Default const);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(1901)
template <typename TText, typename TShapeSpec, typename TSpec> inline bool indexCreate( Index<TText, IndexQGram<TShapeSpec, TSpec> > &index, FibreCounts, Default const);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(1912)
template <typename TText, typename TShapeSpec, typename TSpec> inline bool indexCreate( Index<TText, IndexQGram<TShapeSpec, TSpec> > &index, FibreDir, Default const);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(1923)
template <typename TText, typename TSpec, typename TSpecAlg> inline bool indexCreate(Index<TText, TSpec> &index, FibreSA, TSpecAlg const alg);       	// "seqan-1.3.1/seqan/index/index_shims.h"(570)
template <typename TText, typename TSpec, typename TSpecAlg> inline bool indexCreate(Index<TText, TSpec> &index, FibreLcp, TSpecAlg const alg);       	// "seqan-1.3.1/seqan/index/index_shims.h"(578)
template <typename TText, typename TSpec, typename TSpecAlg> inline bool indexCreate(Index<TText, TSpec> &index, FibreLcpe, TSpecAlg const alg);       	// "seqan-1.3.1/seqan/index/index_shims.h"(586)
template <typename TText, typename TSpec> inline bool indexCreate(Index<TText, TSpec> &index, FibreBwt, Bwt const);       	// "seqan-1.3.1/seqan/index/index_shims.h"(596)
template <typename TText, typename TSpec> inline bool indexCreate(Index<TText, TSpec> &index, FibreChildtab, Childtab const);       	// "seqan-1.3.1/seqan/index/index_shims.h"(604)
template <typename TText, typename TSpec, typename TFibre> inline bool indexCreate(Index<TText, TSpec> &index, Tag<TFibre> const fibre);       	// "seqan-1.3.1/seqan/index/index_shims.h"(612)
template <typename TText, typename TPredHull, typename TPred> inline bool indexCreate(Index<TText, IndexWotd<Dfi<TPredHull, TPred> > > &index, WotdDir const, Default const);       	// "seqan-1.3.1/seqan/index/index_dfi.h"(579)
template <typename TText, typename TSpec> inline bool indexCreate(Index<TText, IndexWotd<TSpec> > &index, WotdDir const, Default const);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(1924)

//____________________________________________________________________________
// indexDir

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, FibreDir>::Type & indexDir(Index<TText, TSpec> &index);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(361)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, FibreDir>::Type & indexDir(Index<TText, TSpec> const &index);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(366)

//____________________________________________________________________________
// indexLcp

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, FibreLcp>::Type & indexLcp(Index<TText, TSpec> &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(1124)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, FibreLcp>::Type & indexLcp(Index<TText, TSpec> const &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(1126)

//____________________________________________________________________________
// indexLcpe

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, FibreLcpe>::Type & indexLcpe(Index<TText, TSpec> &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(1141)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, FibreLcpe>::Type & indexLcpe(Index<TText, TSpec> const &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(1143)

//____________________________________________________________________________
// indexRawSA

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, FibreRawSA>::Type indexRawSA(Index<TText, TSpec> &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(1107)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, FibreRawSA>::Type indexRawSA(Index<TText, TSpec> const &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(1109)

//____________________________________________________________________________
// indexRawText

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, FibreRawText>::Type & indexRawText(Index<TText, TSpec> &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(1068)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, FibreRawText>::Type & indexRawText(Index<TText, TSpec> const &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(1070)

//____________________________________________________________________________
// indexRequire

template <typename TText, typename TSpec, typename TFibre> inline bool indexRequire(Index<TText, TSpec> &index, Tag<TFibre> const fibre);       	// "seqan-1.3.1/seqan/index/index_shims.h"(656)

//____________________________________________________________________________
// indexSA

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, FibreSA>::Type & indexSA(Index<TText, TSpec> &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(1085)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, FibreSA>::Type & indexSA(Index<TText, TSpec> const &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(1087)

//____________________________________________________________________________
// indexShape

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, FibreShape>::Type & indexShape(Index<TText, TSpec> &index);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(480)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, FibreShape>::Type & indexShape(Index<TText, TSpec> const &index);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(485)

//____________________________________________________________________________
// indexSolveDependencies

template <typename TText, typename TSpec> inline bool indexSolveDependencies(Index<TText, PizzaChili<TSpec> >& me, PizzaChiliCompressed const);       	// "seqan-1.3.1/seqan/index/index_pizzachili.h"(258)
template <typename TText, typename TSpec, typename TFibre> inline bool indexSolveDependencies(Index<TText, TSpec> &, Tag<TFibre> const);       	// "seqan-1.3.1/seqan/index/index_shims.h"(687)
template <typename TText, typename TSpec> inline bool indexSolveDependencies(Index<TText, TSpec> &index, FibreLcp);       	// "seqan-1.3.1/seqan/index/index_shims.h"(693)
template <typename TText, typename TSpec> inline bool indexSolveDependencies(Index<TText, TSpec> &index, FibreLcpe);       	// "seqan-1.3.1/seqan/index/index_shims.h"(699)
template <typename TText, typename TSpec> inline bool indexSolveDependencies(Index<TText, TSpec> &index, FibreChildtab);       	// "seqan-1.3.1/seqan/index/index_shims.h"(705)
template <typename TText, typename TSpec> inline bool indexSolveDependencies(Index<TText, TSpec> &index, FibreBwt);       	// "seqan-1.3.1/seqan/index/index_shims.h"(711)

//____________________________________________________________________________
// indexSupplied

template <typename TText, typename TSpec> inline bool indexSupplied(Index<TText, PizzaChili<TSpec> >& me, PizzaChiliCompressed const);       	// "seqan-1.3.1/seqan/index/index_pizzachili.h"(242)
template <typename TText, typename TSpec> inline bool indexSupplied(Index<TText, PizzaChili<TSpec> >& me, PizzaChiliText const);       	// "seqan-1.3.1/seqan/index/index_pizzachili.h"(249)
template <typename TText, typename TSpec> inline bool indexSupplied(Index<TText, TSpec> &index, FibreSADir);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(1892)
template <typename TText, typename TSpec, typename TFibre> inline bool indexSupplied(Index<TText, TSpec> &index, Tag<TFibre> const fibre);       	// "seqan-1.3.1/seqan/index/index_shims.h"(634)

//____________________________________________________________________________
// indexText

template <typename TText, typename TSpec> inline typename Fibre<Index<TText, PizzaChili<TSpec> >, PizzaChiliText>::Type indexText(Index<TText, PizzaChili<TSpec> >& me);       	// "seqan-1.3.1/seqan/index/index_pizzachili.h"(210)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, PizzaChili<TSpec> > const, PizzaChiliText>::Type indexText(Index<TText, PizzaChili<TSpec> > const& me);       	// "seqan-1.3.1/seqan/index/index_pizzachili.h"(217)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec>, FibreText>::Type & indexText(Index<TText, TSpec> &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(1025)
template <typename TText, typename TSpec> inline typename Fibre<Index<TText, TSpec> const, FibreText>::Type & indexText(Index<TText, TSpec> const &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(1027)

//____________________________________________________________________________
// infix

template <typename THaystack, typename TSpec> inline typename Infix<THaystack>::Type infix(Finder<THaystack, Swift<TSpec> > &finder);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1495)
template <typename THaystack, typename TSpec, typename TText> inline typename Infix<TText>::Type infix(Finder<THaystack, Swift<TSpec> > &finder, TText &text);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1502)
template <typename TIndex, typename TSpec, typename TText> inline typename Infix<TText>::Type infix(Pattern<TIndex, Swift<TSpec> > const & pattern, TText &text);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1527)
template <typename TIndex, typename TSpec> inline typename Infix< typename GetSequenceByNo< TIndex const >::Type >::Type infix(Pattern<TIndex, Swift<TSpec> > const & pattern);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1541)
template <typename TIndex, typename TSpec> inline typename Infix< typename GetSequenceByNo< TIndex const >::Type >::Type infix(Pattern<TIndex, Swift<Tag<SwiftSemiGlobal_<TSpec> > > > const & pattern);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1548)
template <typename TIndex, typename TSpec> inline typename Infix< typename GetSequenceByNo< TIndex const >::Type >::Type infix(Pattern<TIndex, Swift<TSpec> > & pattern);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1555)
template <typename TValue, typename TSpec, typename TPosBegin, typename TPosEnd> inline typename Infix<String<TValue, PizzaChili<TSpec> > >::Type infix( String<TValue, PizzaChili<TSpec> > const& me, TPosBegin begin, TPosEnd end );       	// "seqan-1.3.1/seqan/index/index_pizzachili_string.h"(739)
template <typename TValue, typename TSpec, typename TPosBegin, typename TPosEnd> inline typename Infix<String<TValue, PizzaChili<TSpec> > >::Type infix( String<TValue, PizzaChili<TSpec> >& me, TPosBegin begin, TPosEnd end );       	// "seqan-1.3.1/seqan/index/index_pizzachili_string.h"(750)
template <typename TText, typename TSpec, typename TPosBegin, typename TPosEnd> inline typename Infix<TText>::Type infix(Index<TText, TSpec> &index, TPosBegin pos_begin, TPosEnd pos_end);       	// "seqan-1.3.1/seqan/index/index_base.h"(837)
template <typename TText, typename TSpec, typename TPosBegin, typename TPosEnd> inline typename Infix<TText>::Type infix(Index<TText, TSpec> const &index, TPosBegin pos_begin, TPosEnd pos_end);       	// "seqan-1.3.1/seqan/index/index_base.h"(844)

//____________________________________________________________________________
// infixNoClip

template <typename THaystack, typename TSpec> inline typename Infix<THaystack>::Type infixNoClip(Finder<THaystack, Swift<TSpec> > &finder);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1511)
template <typename THaystack, typename TSpec, typename TText> inline typename Infix<TText>::Type infixNoClip(Finder<THaystack, Swift<TSpec> > &finder, TText &text);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1518)

//____________________________________________________________________________
// initPatterns

template <typename TStateString, typename TShape, typename TLogErrorDistr, typename TDistance > void initPatterns( TStateString &states, TShape const &bitShape, int maxErrors, TLogErrorDistr const &logError, TDistance, bool optionMinOutput);       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(455)

//____________________________________________________________________________
// isLeaf

template <typename TIndex, class TSpec > inline bool isLeaf(Iter<TIndex, VSTree<TSpec> > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(2210)

//____________________________________________________________________________
// isLeftMaximal

template <typename TIndex, class TSpec > inline bool isLeftMaximal(Iter<TIndex, VSTree<TSpec> > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1951)

//____________________________________________________________________________
// isPartiallyLeftExtensible

template <typename TIndex, class TSpec, typename TSet > inline bool isPartiallyLeftExtensible(Iter<TIndex, VSTree<TSpec> > const &it, TSet &charSet);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(2000)
template <typename TIndex, class TSpec > inline bool isPartiallyLeftExtensible(Iter<TIndex, VSTree<TSpec> > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(2034)

//____________________________________________________________________________
// isRightTerminal

template <typename TIndex, class TSpec > inline bool isRightTerminal(Iter<TIndex, VSTree<TSpec> > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1927)

//____________________________________________________________________________
// isRoot

template <typename TIndex, class TSpec > inline bool isRoot(Iter<TIndex, VSTree< BottomUp<TSpec> > > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1897)
template <typename TIndex, class TSpec > inline bool isRoot(Iter<TIndex, VSTree<TSpec> > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1903)

//____________________________________________________________________________
// isUnique

template <typename TIndex, class TSpec, typename TSet > inline bool isUnique(Iter<TIndex, VSTree<TSpec> > const &it, TSet &set);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(2053)
template <typename TIndex, class TSpec > inline bool isUnique(Iter<TIndex, VSTree<TSpec> > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(2076)

//____________________________________________________________________________
// isinf

template <typename TValue> inline bool isinf(TValue value);       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(240)
template <typename TValue> inline bool isinf(TValue value);       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(254)

//____________________________________________________________________________
// isnan

template <typename TValue> inline bool isnan(TValue value);       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(234)
template <typename TValue> inline bool isnan(TValue value);       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(248)

//____________________________________________________________________________
// lca

template <typename TIndex, class TSpec1, class TSpec2 > inline bool lca( Iter<TIndex, VSTree< TopDown< ParentLinks<TSpec1> > > > &a, Iter<TIndex, VSTree< TopDown< ParentLinks<TSpec2> > > > &b, Iter<TIndex, VSTree< TopDown< ParentLinks<TSpec1> > > > &_lca);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(595)

//____________________________________________________________________________
// lcp

template <typename TIndex, class TSpec1, class TSpec2 > inline typename Size<TIndex>::Type lcp( Iter<TIndex, VSTree< TopDown< ParentLinks<TSpec1> > > > &a, Iter<TIndex, VSTree< TopDown< ParentLinks<TSpec2> > > > &b);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(652)

//____________________________________________________________________________
// lcpAt

template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex, FibreLcp>::Type>::Type lcpAt(TPos i, TIndex &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(925)
template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex const, FibreLcp>::Type>::Type lcpAt(TPos i, TIndex const &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(929)

//____________________________________________________________________________
// lcpeAt

template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex, FibreLcpe>::Type>::Type lcpeAt(TPos i, TIndex &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(947)
template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex const, FibreLcpe>::Type>::Type lcpeAt(TPos i, TIndex const &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(951)

//____________________________________________________________________________
// length

template <typename TSTree, typename TSpec > inline typename Size<TSTree>::Type length(Iter< TSTree, VSTree< BottomUp<MaxRepeats_<TSpec> > > > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_algs.h"(634)
template <typename TSTree> inline typename Size< MaxRepeat<TSTree> >::Type length(MaxRepeat<TSTree> const &repeat);       	// "seqan-1.3.1/seqan/index/index_esa_algs.h"(683)
template <typename TInput > inline typename Size< Pipe< TInput, LarssonSadakane > >::Type length(Pipe< TInput, LarssonSadakane > const &me);       	// "seqan-1.3.1/seqan/index/index_sa_lss.h"(445)
template <typename TValue> inline typename Size< Shape<TValue, OneGappedShape> >::Type length(Shape<TValue, OneGappedShape> const &me);       	// "seqan-1.3.1/seqan/index/shape_onegapped.h"(151)
template <typename TInput > inline typename Size< Pipe< TInput, Merger7 > >::Type length(Pipe< TInput, Merger7 > const &me);       	// "seqan-1.3.1/seqan/index/pipe_merger7.h"(478)
template <typename TInput, typename TLimitsString > inline typename Size< Pipe< TInput, Merger7Multi<TLimitsString> > >::Type length(Pipe< TInput, Merger7Multi<TLimitsString> > const &me);       	// "seqan-1.3.1/seqan/index/pipe_merger7.h"(508)
template <typename TInput > inline typename Size< Pipe< TInput, Merger3 > >::Type length(Pipe< TInput, Merger3 > const &me);       	// "seqan-1.3.1/seqan/index/pipe_merger3.h"(159)
template <typename TValue, typename TSpec> inline typename Size< Shape<TValue, TSpec> >::Type length(Shape<TValue, TSpec> const &me);       	// "seqan-1.3.1/seqan/index/shape_base.h"(259)
template <typename TValue, typename TSpec> inline typename Size<String<TValue, PizzaChili<TSpec> > >::Type length(String<TValue, PizzaChili<TSpec> > const& me);       	// "seqan-1.3.1/seqan/index/index_pizzachili_string.h"(394)
template <typename TSTree> inline typename Size< MultiMem<TSTree> >::Type length(MultiMem<TSTree> const &repeat);       	// "seqan-1.3.1/seqan/index/index_esa_algs_multi.h"(442)
template <typename TText, typename TSpec> inline typename Size<Index<TText, TSpec> >::Type length(Index<TText, TSpec> const &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(739)

//____________________________________________________________________________
// lowerBoundLcpe

template <typename TText, typename TSA, typename TLCPE, typename TQuery > inline typename Position<TLCPE>::Type lowerBoundLcpe( TText const &text, TSA const &sa, TLCPE const &lcpe, TQuery const &query);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(1709)
template <typename TText, typename TSA, typename TLCPE, typename TQuery > inline typename Position<TLCPE>::Type lowerBoundLcpe( TText const &text, TSA const &sa, TLCPE const &lcpe, TQuery *query);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(1811)

//____________________________________________________________________________
// lowerBoundLcpeIterator

template <typename TText, typename TSA, typename TLCPE, typename TQuery > inline typename Iterator<TSA, Standard>::Type lowerBoundLcpeIterator( TText const &text, TSA const &sa, TLCPE const &lcpe, TQuery const &query);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(1760)

//____________________________________________________________________________
// lowerBoundSA

template <typename TText, typename TSA, typename TQuery, typename TFlatTreeSpec > inline typename Position<TSA>::Type lowerBoundSA( TText const &text, TSA const &sa, TQuery const &query, TFlatTreeSpec const);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(948)
template <typename TText, typename TSA, typename TQuery > inline typename Position<TSA>::Type lowerBoundSA( TText const &text, TSA const &sa, TQuery const &query);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(962)
template <typename TText, typename TSA, typename TQuery, typename TFlatTreeSpec > inline typename Position<TSA>::Type lowerBoundSA( TText const &text, TSA const &sa, TQuery *query, TFlatTreeSpec const);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(1045)
template <typename TText, typename TSA, typename TQuery > inline typename Position<TSA>::Type lowerBoundSA( TText const &text, TSA const &sa, TQuery *query);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(1059)

//____________________________________________________________________________
// lowerBoundSAIterator

template <typename TText, typename TSA, typename TQuery > inline typename Iterator<TSA const, Standard>::Type lowerBoundSAIterator( TText const &text, TSA const &sa, TQuery const &query);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(841)
template <typename TText, typename TSA, typename TQuery > inline typename Iterator<TSA const, Standard>::Type lowerBoundSAIterator( TText const &text, TSA const &sa, TQuery *query);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(900)

//____________________________________________________________________________
// lowerBoundSANaiveIterator

template <typename TText, typename TSA, typename TQuery > inline typename Iterator<TSA const, Standard>::Type lowerBoundSANaiveIterator( TText const &text, TSA const &sa, TQuery const &query);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(827)

//____________________________________________________________________________
// nodeDepth

template <typename TIndex, typename TSpec > inline typename Size<TIndex>::Type nodeDepth(Iter< TIndex, VSTree<TopDown<ParentLinks<TSpec> > > > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(523)

//____________________________________________________________________________
// nodeHullPredicate

template <typename TIndex, class TSpec > inline bool nodeHullPredicate(Iter<TIndex, TSpec> &);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1173)
template <typename TText, typename TSpec> bool nodeHullPredicate(Iter<Index<TText, IndexWotd<TRepeatFinder> >, TSpec> &it);       	// "seqan-1.3.1/seqan/index/repeat_base.h"(88)
template <typename TText, typename TPredHull, typename TPred, typename TSpec > inline bool nodeHullPredicate( Iter<Index<TText, IndexWotd< Dfi<TPredHull, TPred> > >, TSpec> &it);       	// "seqan-1.3.1/seqan/index/index_dfi.h"(193)

//____________________________________________________________________________
// nodePredicate

template <typename TIndex, class TSpec > inline bool nodePredicate(Iter<TIndex, TSpec> &);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1154)
template <typename TText, typename TSpec> bool nodePredicate(Iter<Index<TText, IndexWotd<TRepeatFinder> >, TSpec> &it);       	// "seqan-1.3.1/seqan/index/repeat_base.h"(80)
template <typename TText, typename TPredHull, typename TPred, typename TSpec > inline bool nodePredicate( Iter<Index<TText, IndexWotd< Dfi<TPredHull, TPred> > >, TSpec> &it);       	// "seqan-1.3.1/seqan/index/index_dfi.h"(180)

//____________________________________________________________________________
// nodeUp

template <typename TIndex, class TSpec > inline typename VertexDescriptor<TIndex>::Type nodeUp(Iter< TIndex, VSTree< TopDown< ParentLinks<TSpec> > > > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1626)
template <typename TIndex, class TSpec > inline typename VertexDescriptor<TIndex>::Type const & nodeUp(Iter< TIndex, VSTree< TopDown<TSpec> > > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1641)
template <typename TText, typename TSpec > inline typename VertexDescriptor< Index<TText, IndexWotd<WotdOriginal> > >::Type nodeUp(Iter< Index<TText, IndexWotd<WotdOriginal> >, VSTree< TopDown< ParentLinks<TSpec> > > > const &it);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(834)
template <typename TText, typename TIndexSpec, typename TSpec > inline typename VertexDescriptor< Index<TText, IndexWotd<TIndexSpec> > >::Type nodeUp(Iter< Index<TText, IndexWotd<TIndexSpec> >, VSTree< TopDown< ParentLinks<TSpec> > > > const &it);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(859)

//____________________________________________________________________________
// open

template <typename TText, typename TSpec> inline bool open( Index<TText, PizzaChili<TSpec> >& me, char const* filename );       	// "seqan-1.3.1/seqan/index/index_pizzachili.h"(350)
template <typename TObject, typename TShapeSpec, typename TSpec > inline bool open( Index< TObject, IndexQGram<TShapeSpec, TSpec> > &index, const char *fileName, int openMode);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(2367)
template <typename TObject, typename TShapeSpec, typename TSpec > inline bool open( Index< TObject, IndexQGram<TShapeSpec, TSpec> > &index, const char *fileName);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(2383)
template <typename TValue, typename TSpec > inline bool open(String<TValue, TSpec> &string, const char *fileName, int openMode);       	// "seqan-1.3.1/seqan/index/index_shims.h"(721)
template <typename TValue, typename TSpec > inline bool open(String<TValue, TSpec> &string, const char *fileName);       	// "seqan-1.3.1/seqan/index/index_shims.h"(729)
template <typename THost, typename TSpec > inline bool open(Segment<THost, TSpec> &string, const char *fileName, int openMode);       	// "seqan-1.3.1/seqan/index/index_shims.h"(735)
template <typename THost, typename TSpec > inline bool open(Segment<THost, TSpec> &string, const char *fileName);       	// "seqan-1.3.1/seqan/index/index_shims.h"(743)
template <typename TValue, typename TSpec, typename TSSSpec > inline bool open(StringSet<String<TValue, TSpec>, TSSSpec> &multi, const char *fileName, int openMode);       	// "seqan-1.3.1/seqan/index/index_shims.h"(752)
template <typename TValue, typename TSpec, typename TSSSpec > inline bool open(StringSet<String<TValue, TSpec>, Owner<ConcatDirect<TSSSpec> > > &multi, const char *fileName, int openMode);       	// "seqan-1.3.1/seqan/index/index_shims.h"(776)
template <typename TValue, typename TSpec, typename TSSSpec> inline bool open(StringSet<String<TValue, TSpec>, TSSSpec> &multi, const char *fileName);       	// "seqan-1.3.1/seqan/index/index_shims.h"(796)
template <typename TObject, typename TSpec > inline bool open( Index< TObject, IndexEsa<TSpec> > &index, const char *fileName, int openMode);       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(380)
template <typename TObject, typename TSpec > inline bool open( Index< TObject, IndexEsa<TSpec> > &index, const char *fileName);       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(399)
template <typename TText, typename TSpec > inline bool open( Index< TText, IndexWotd<TSpec> > &index, const char *fileName, int openMode);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(1947)
template <typename TText, typename TSpec > inline bool open( Index< TText, IndexWotd<TSpec> > &index, const char *fileName);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(1962)

//____________________________________________________________________________
// operator!=

template <typename TRepeat > inline bool operator!= ( Iter<TRepeat, MaxRepeatOccurrences> const &itA, Iter<TRepeat, MaxRepeatOccurrences> const &itB);       	// "seqan-1.3.1/seqan/index/index_esa_algs.h"(938)
template <typename TSize> inline bool operator!=(VertexEsa<TSize> const &a, VertexEsa<TSize> const &b);       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(205)

//____________________________________________________________________________
// operator<<

template <typename TInput, typename TObject > inline bool operator<<(Pipe< TInput, Skew7 > &me, TObject &textIn);       	// "seqan-1.3.1/seqan/index/index_skew7.h"(418)
template <typename TInput, typename TTextInput_, typename TSuffixArrayInput_ > inline bool operator<<(Pipe< TInput, Kasai > &me, Bundle2< TTextInput_, TSuffixArrayInput_ > const &bundleIn);       	// "seqan-1.3.1/seqan/index/index_lcp.h"(147)
template <typename TInput, typename TTextInput_, typename TSuffixArrayInput_, typename TPair, typename TLimitsString > inline bool operator<<(Pipe< TInput, Multi<Kasai, TPair, TLimitsString> > &me, Bundle2< TTextInput_, TSuffixArrayInput_ > const &bundleIn);       	// "seqan-1.3.1/seqan/index/index_lcp.h"(252)
template <typename TInput, typename TObject > inline bool operator<<(Pipe< TInput, Skew3 > &me, TObject &textIn);       	// "seqan-1.3.1/seqan/index/index_skew3.h"(299)
template <typename TInput, typename TLcpInput_ > inline bool operator<<(Pipe< TInput, Childtab > &me, TLcpInput_ const &in);       	// "seqan-1.3.1/seqan/index/index_childtab.h"(181)
template <typename TValue> std::ostream& operator<<(std::ostream &out, const SkewDCStream<TValue> &s);       	// "seqan-1.3.1/seqan/index/pipe_merger7.h"(91)
template <typename TInput, typename TObject, typename TPair, typename TLimitsString > inline bool operator<<(Pipe< TInput, Multi<Skew7, TPair, TLimitsString> > &me, TObject &textIn);       	// "seqan-1.3.1/seqan/index/index_skew7_multi.h"(418)
template <typename TInput, typename TTextInput_, typename TSuffixArrayInput_ > inline bool operator<<(Pipe< TInput, Bwt > &me, Bundle2< TTextInput_, TSuffixArrayInput_ > const &bundleIn);       	// "seqan-1.3.1/seqan/index/index_bwt.h"(127)
template <typename TInput, typename TTextInput_, typename TSuffixArrayInput_, typename TPair, typename TLimitsString > inline bool operator<<(Pipe< TInput, Multi<Bwt, TPair, TLimitsString> > &me, Bundle2< TTextInput_, TSuffixArrayInput_ > const &bundleIn);       	// "seqan-1.3.1/seqan/index/index_bwt.h"(243)

//____________________________________________________________________________
// operator==

template <typename TRepeat > inline bool operator== ( Iter<TRepeat, MaxRepeatOccurrences> const &itA, Iter<TRepeat, MaxRepeatOccurrences> const &itB);       	// "seqan-1.3.1/seqan/index/index_esa_algs.h"(927)
template <typename TSize> inline bool operator==(VertexEsa<TSize> const &a, VertexEsa<TSize> const &b);       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(199)

//____________________________________________________________________________
// orderOccurrences

template <typename TValue, typename TSpec> inline void orderOccurrences(String<TValue, TSpec> &occString);       	// "seqan-1.3.1/seqan/index/index_shims.h"(545)

//____________________________________________________________________________
// parentEdgeFirstChar

template <typename TIndex, class TSpec > inline typename Value<TIndex>::Type parentEdgeFirstChar(Iter< TIndex, VSTree<TSpec> > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1751)

//____________________________________________________________________________
// parentEdgeLabel

template <typename TIndex, class TSpec > inline typename Infix< typename Fibre<TIndex, FibreText>::Type const >::Type parentEdgeLabel(Iter< TIndex, VSTree< TopDown<TSpec> > > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1730)
template <typename TText, typename TSpec > inline typename Infix< typename Fibre<Index<TText, IndexWotd<WotdOriginal> >, EsaText>::Type const >::Type parentEdgeLabel(Iter< Index<TText, IndexWotd<WotdOriginal> >, VSTree< TopDown<TSpec> > > const &it);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(539)

//____________________________________________________________________________
// parentEdgeLength

template <typename TText, class TIndexSpec, class TSpec > inline typename Size< Index<TText, IndexEsa<TIndexSpec> > >::Type parentEdgeLength(Iter< Index<TText, IndexEsa<TIndexSpec> >, VSTree< TopDown< ParentLinks<TSpec> > > > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(1711)
template <typename TIndex, typename TSize > inline typename Size<TIndex>::Type parentEdgeLength(TIndex const &index, VertexWotdOriginal_<TSize> &vDesc);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(447)
template <typename TIndex, typename TSize > inline typename Size<TIndex>::Type parentEdgeLength(TIndex const &index, VertexWotdModified_<TSize> &vDesc);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(470)
template <typename TText, typename TIndexSpec, typename TSpec > inline typename Size< Index<TText, IndexWotd<TIndexSpec> > >::Type parentEdgeLength(Iter< Index<TText, IndexWotd<TIndexSpec> >, VSTree< TopDown<TSpec> > > const &it);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(502)

//____________________________________________________________________________
// parentRepLength

template <typename TIndex, typename TSpec > inline typename Size<TIndex>::Type parentRepLength(Iter< TIndex, VSTree<TopDown<TSpec> > > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(543)
template <typename TText, typename TIndexSpec, typename TSpec > inline typename Size< Index<TText, IndexWotd<TIndexSpec> > >::Type parentRepLength(Iter< Index<TText, IndexWotd<TIndexSpec> >, VSTree< TopDown<TSpec> > > const &it);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(512)
template <typename TText, typename TIndexSpec, typename TSpec > inline typename Size< Index<TText, IndexWotd<TIndexSpec> > >::Type parentRepLength(Iter< Index<TText, IndexWotd<TIndexSpec> >, VSTree< TopDown< ParentLinks<TSpec> > > > const &it);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(521)

//____________________________________________________________________________
// position

template <typename THaystack, typename TSpec> inline typename Position<Finder<THaystack, Swift<TSpec> > >::Type position(Finder<THaystack, Swift<TSpec> > const & finder);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1239)
template <typename THaystack, typename TSpec> inline typename Position<Finder<THaystack, Swift<TSpec> > >::Type position(Finder<THaystack, Swift<TSpec> > & finder);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1247)
template <typename TIndex, typename TSpec> inline typename SAValue<TIndex>::Type position(Pattern<TIndex, Swift<TSpec> > const & pattern);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1256)
template <typename TIndex, typename TSpec> inline typename SAValue<TIndex>::Type position(Pattern<TIndex, Swift<Tag<SwiftSemiGlobal_<TSpec> > > > const & pattern);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1269)
template <typename TIndex, typename TSpec> inline typename SAValue<TIndex>::Type position(Pattern<TIndex, Swift<TSpec> > & pattern);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1279)
template <typename TText, typename TSpec, typename TSpecFinder > inline typename Position< Finder< Index<TText, TSpec>, TSpecFinder > >::Type position(Finder< Index<TText, TSpec>, TSpecFinder > & me);       	// "seqan-1.3.1/seqan/index/find_index.h"(271)
template <typename TText, typename TSpec, typename TSpecFinder > inline typename Position< Finder< Index<TText, TSpec>, TSpecFinder > >::Type position(Finder< Index<TText, TSpec>, TSpecFinder > const & me);       	// "seqan-1.3.1/seqan/index/find_index.h"(279)

//____________________________________________________________________________
// positionRange

template <typename THaystack, typename TSpec> inline Pair<typename Position<Finder<THaystack, Swift<TSpec> > >::Type> positionRange(Finder<THaystack, Swift<TSpec> > const & finder);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1434)
template <typename THaystack, typename TSpec> inline Pair<typename Position<Finder<THaystack, Swift<TSpec> > >::Type> positionRange(Finder<THaystack, Swift<TSpec> > & finder);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1451)
template <typename TIndex, typename TSpec> inline Pair<typename SAValue<TIndex>::Type> positionRange(Pattern<TIndex, Swift<TSpec> > & pattern);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1460)

//____________________________________________________________________________
// positionRangeNoClip

template <typename THaystack, typename TSpec> inline Pair<typename Position<Finder<THaystack, Swift<TSpec> > >::Type> positionRangeNoClip(Finder<THaystack, Swift<TSpec> > const & finder);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1399)
template <typename THaystack, typename TSpec> inline Pair<typename Position<Finder<THaystack, Swift<TSpec> > >::Type> positionRangeNoClip(Finder<THaystack, Swift<TSpec> > & finder);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1409)

//____________________________________________________________________________
// prefix

template <typename TValue, typename TSpec, typename TPos> inline typename Prefix<String<TValue, PizzaChili<TSpec> > >::Type prefix( String<TValue, PizzaChili<TSpec> > const& me, TPos end );       	// "seqan-1.3.1/seqan/index/index_pizzachili_string.h"(762)
template <typename TValue, typename TSpec, typename TPos> inline typename Prefix<String<TValue, PizzaChili<TSpec> > >::Type prefix( String<TValue, PizzaChili<TSpec> >& me, TPos end );       	// "seqan-1.3.1/seqan/index/index_pizzachili_string.h"(772)

//____________________________________________________________________________
// qgramFilteringSensitivity

template <typename TSensitivityMatrix, typename TShape, typename TPatternSize, typename TErrors, typename TThresh, typename TDistance, typename TErrorDist> void qgramFilteringSensitivity( TSensitivityMatrix & sensMat, TShape const & shape, TPatternSize patternLength, TErrors errors, TThresh maxThresh, TDistance const dist, ThreshExact const, TErrorDist const & logErrorDistribution);       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(1108)

//____________________________________________________________________________
// qgramThreshold

template <typename TShape, typename TPatternLength, typename TErrors, typename TDistance> inline int qgramThreshold(TShape const & shape, TPatternLength patternLength, TErrors errors, TDistance const, ThreshQGramLemma const);       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(59)
template <typename TShape, typename TPatternSize, typename TErrors, typename TDistance> int qgramThreshold(TShape const & shape, TPatternSize patternLength, TErrors errors, TDistance const, ThreshHeuristic const);       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(74)
template <typename TShape, typename TPatternSize, typename TErrors, typename TDistance> int qgramThreshold(TShape const & shape, TPatternSize patternLength, TErrors errors, TDistance const dist, ThreshExact const);       	// "seqan-1.3.1/seqan/index/shape_threshold.h"(1080)

//____________________________________________________________________________
// radixExtend

template <typename TSortedArray, typename TUnsortedArray, typename TCountArray, typename TText > void radixExtend( TSortedArray &b, TUnsortedArray const &a, TText const &r, TCountArray &c, unsigned K);       	// "seqan-1.3.1/seqan/index/radix.h"(132)

//____________________________________________________________________________
// radixExtendClip

template <typename TSortedArray, typename TUnsortedArray, typename TCountArray, typename TText > void radixExtendClip( TSortedArray &b, TUnsortedArray const &a, TText const &r, TCountArray &c, unsigned K);       	// "seqan-1.3.1/seqan/index/radix.h"(167)

//____________________________________________________________________________
// radixPass

template <typename TSortedArray, typename TUnsortedArray, typename TCountArray, typename TText > void radixPass( TSortedArray &b, TUnsortedArray const &a, TText const &r, TCountArray &c, unsigned K);       	// "seqan-1.3.1/seqan/index/radix.h"(53)
template <typename TSortedArray, typename TUnsortedArray, typename TCountArray, typename TText, typename TShift > void radixPass( TSortedArray &b, TUnsortedArray const &a, TText const &r, TCountArray &c, unsigned K, TShift shift);       	// "seqan-1.3.1/seqan/index/radix.h"(89)

//____________________________________________________________________________
// range

template <typename TText, typename TSpec, typename TDesc > inline Pair<typename Size<Index<TText, TSpec> >::Type> range(Index<TText, TSpec> const &index, TDesc const &desc);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(835)
template <typename TIndex, class TSpec > inline Pair<typename Size<TIndex>::Type> range(Iter< TIndex, VSTree<TSpec> > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(845)
template <typename TObject, typename TShapeSpec, typename TSpec, typename TShapeSpec2, typename TValue > inline Pair<typename Size< Index< TObject, IndexQGram<TShapeSpec, TSpec> > >::Type> range( Index< TObject, IndexQGram<TShapeSpec, TSpec> > const &index, Shape< TValue, TShapeSpec2 > const &shape);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(2185)
template <typename TObject, typename TShapeSpec, typename TSpec, typename TShapeSpec2, typename TValue > inline Pair<typename Size< Index< TObject, IndexQGram<TShapeSpec, TSpec> > >::Type> range( Index< TObject, IndexQGram<TShapeSpec, TSpec> > &index, Shape< TValue, TShapeSpec2 > const &shape);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(2197)

//____________________________________________________________________________
// rawsaAt

template <typename TPos, typename TIndex> inline typename Value<typename Fibre<TIndex const, FibreRawSA>::Type>::Type rawsaAt(TPos i, TIndex const &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(906)

//____________________________________________________________________________
// rawtextAt

template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex, FibreRawText>::Type>::Type rawtextAt(TPos i, TIndex &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(862)
template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex const, FibreRawText>::Type>::Type rawtextAt(TPos i, TIndex const &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(866)

//____________________________________________________________________________
// repLength

template <typename TSTree, typename TSpec > inline typename Size<TSTree>::Type repLength(Iter< TSTree, VSTree< BottomUp<MaxRepeats_<TSpec> > > > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_algs.h"(626)
template <typename TIndex, typename TSpec > inline typename Size<TIndex>::Type repLength(Iter< TIndex, VSTree<BottomUp<TSpec> > > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(474)
template <typename TIndex, typename TSize > inline typename Size<TIndex>::Type repLength(TIndex const &index, VertexEsa<TSize> const &vDesc);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(486)
template <typename TIndex, typename TSpec > inline typename Size<TIndex>::Type repLength(Iter< TIndex, VSTree<TopDown<TSpec> > > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(502)
template <typename TText, typename TIndexSpec, typename TSpec > inline typename Size< Index<TText, IndexWotd<TIndexSpec> > >::Type repLength(Iter< Index<TText, IndexWotd<TIndexSpec> >, VSTree< TopDown<TSpec> > > const &it);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(530)

//____________________________________________________________________________
// representative

template <typename TIndex, class TSpec > inline typename Infix< typename Fibre<TIndex, FibreText>::Type const >::Type representative(Iter< TIndex, VSTree<TSpec> > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(997)

//____________________________________________________________________________
// requestBucket

template <typename THashValue > inline THashValue requestBucket(Nothing &, THashValue hash);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(852)
template <typename THashValue, typename THashValue2 > inline THashValue requestBucket(BucketMap<THashValue> &bucketMap, THashValue2 hash);       	// "seqan-1.3.1/seqan/index/index_qgram_openaddressing.h"(188)

//____________________________________________________________________________
// resize

template <typename TValue, typename TSize> inline typename Size< Shape<TValue, SimpleShape> >::Type resize(Shape<TValue, SimpleShape> & me, TSize new_length);       	// "seqan-1.3.1/seqan/index/shape_base.h"(290)

//____________________________________________________________________________
// resizeVertexMap

template <typename TText, typename TSpec, typename TPropertyMap > inline void resizeVertexMap( Index<TText, TSpec> const& index, TPropertyMap & pm);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(737)
template <typename TText, typename TIndexSpec, typename TPropertyMap > inline void resizeVertexMap( Index<TText, IndexWotd<TIndexSpec> > const& index, TPropertyMap & pm);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(359)

//____________________________________________________________________________
// reverse

template <typename TValue> inline void reverse(Shape<TValue, OneGappedShape> &me);       	// "seqan-1.3.1/seqan/index/shape_onegapped.h"(364)
template <typename TValue, typename TSpec> inline void reverse(Shape<TValue, TSpec> &);       	// "seqan-1.3.1/seqan/index/shape_base.h"(745)
template <typename TValue, typename TSpec> inline void reverse(Shape<TValue, GappedShape<TSpec> > &me);       	// "seqan-1.3.1/seqan/index/shape_gapped.h"(654)

//____________________________________________________________________________
// saAt

template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex, FibreSA>::Type>::Type saAt(TPos i, TIndex &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(884)
template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex const, FibreSA>::Type>::Type saAt(TPos i, TIndex const &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(888)

//____________________________________________________________________________
// save

template <typename TText, typename TSpec> inline bool save( Index<TText, PizzaChili<TSpec> >& me, char const* filename );       	// "seqan-1.3.1/seqan/index/index_pizzachili.h"(368)
template <typename TObject, typename TShapeSpec, typename TSpec > inline bool save( Index< TObject, IndexQGram<TShapeSpec, TSpec> > &index, const char *fileName, int openMode);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(2396)
template <typename TObject, typename TShapeSpec, typename TSpec > inline bool save( Index< TObject, IndexQGram<TShapeSpec, TSpec> > &index, const char *fileName);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(2410)
template <typename TValue, typename TSpec > inline bool save(String<TValue, TSpec> const &string, const char *fileName, int openMode);       	// "seqan-1.3.1/seqan/index/index_shims.h"(806)
template <typename TValue, typename TSpec > inline bool save(String<TValue, TSpec> &string, const char *fileName);       	// "seqan-1.3.1/seqan/index/index_shims.h"(816)
template <typename THost, typename TSpec > inline bool save(Segment<THost, TSpec> const &string, const char *fileName, int openMode);       	// "seqan-1.3.1/seqan/index/index_shims.h"(822)
template <typename THost, typename TSpec > inline bool save(Segment<THost, TSpec> const &string, const char *fileName);       	// "seqan-1.3.1/seqan/index/index_shims.h"(831)
template <typename TValue, typename TSpec, typename TSSSpec> inline bool save(StringSet<String<TValue, TSpec>, TSSSpec> const &multi, const char *fileName, int openMode);       	// "seqan-1.3.1/seqan/index/index_shims.h"(837)
template <typename TValue, typename TSpec, typename TSSSpec > inline bool save(StringSet<String<TValue, TSpec>, Owner<ConcatDirect<TSSSpec> > > &multi, const char *fileName, int openMode);       	// "seqan-1.3.1/seqan/index/index_shims.h"(853)
template <typename TValue, typename TSpec, typename TSSSpec> inline bool save(StringSet<String<TValue, TSpec>, TSSSpec> const &multi, const char *fileName);       	// "seqan-1.3.1/seqan/index/index_shims.h"(865)
template <typename TObject, typename TSpec > inline bool save( Index< TObject, IndexEsa<TSpec> > &index, const char *fileName, int openMode);       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(412)
template <typename TObject, typename TSpec > inline bool save( Index< TObject, IndexEsa<TSpec> > &index, const char *fileName);       	// "seqan-1.3.1/seqan/index/index_esa_base.h"(428)
template <typename TText, typename TSpec > inline bool save( Index< TText, IndexWotd<TSpec> > &index, const char *fileName, int openMode);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(1975)
template <typename TText, typename TSpec > inline bool save( Index< TText, IndexWotd<TSpec> > &index, const char *fileName);       	// "seqan-1.3.1/seqan/index/index_wotd.h"(1989)

//____________________________________________________________________________
// sequenceLength

template <typename TSeqNo, typename TText, typename TSpec> inline typename Size<Index<TText, TSpec> >::Type sequenceLength(TSeqNo seqNo, Index<TText, TSpec> const &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(785)

//____________________________________________________________________________
// setContainer

template <typename TText, typename TSpec, typename TSpecFinder > inline void setContainer( Finder< Index<TText, TSpec>, TSpecFinder > & me, typename Parameter_<Index<TText, TSpec> >::Type );       	// "seqan-1.3.1/seqan/index/find_index.h"(146)

//____________________________________________________________________________
// setHost

template <typename TNeedle, typename TNeedle2> inline void setHost (Pattern<TNeedle, Quasar> & me, TNeedle2 const& needle);       	// "seqan-1.3.1/seqan/index/find_quasar.h"(106)
template <typename TNeedle, typename TNeedle2> inline void setHost (Pattern<TNeedle, Quasar> & me, TNeedle2 & needle);       	// "seqan-1.3.1/seqan/index/find_quasar.h"(114)
template <typename TText, typename TSpec, typename TSpecFinder > inline void setHost( Finder< Index<TText, TSpec>, TSpecFinder > & me, typename Parameter_<Index<TText, TSpec> >::Type );       	// "seqan-1.3.1/seqan/index/find_index.h"(136)

//____________________________________________________________________________
// setIndexText

template <typename TText, typename TSpec, typename TOtherText> inline void setIndexText(Index<TText, PizzaChili<TSpec> >& me, TOtherText& text);       	// "seqan-1.3.1/seqan/index/index_pizzachili.h"(319)

//____________________________________________________________________________
// setMinThreshold

template <typename TIndex, typename TSpec, typename TSeqNo, typename TThreshold> inline void setMinThreshold(Pattern<TIndex, Swift<TSpec> > & pattern, TSeqNo seqNo, TThreshold thresh);       	// "seqan-1.3.1/seqan/index/find_swift.h"(514)

//____________________________________________________________________________
// setStepSize

template <typename TText, typename TShapeSpec, typename TSpec, typename TSize> inline void setStepSize(Index<TText, IndexQGram<TShapeSpec, TSpec> > &index, TSize stepSize);       	// "seqan-1.3.1/seqan/index/index_qgram.h"(527)

//____________________________________________________________________________
// shapeToString

template <typename TShapeString, typename TValue> inline void shapeToString( TShapeString &bitmap, Shape<TValue, OneGappedShape> const &me);       	// "seqan-1.3.1/seqan/index/shape_onegapped.h"(349)
template <typename TShapeString, typename TValue, unsigned q> inline void shapeToString( TShapeString &bitmap, Shape<TValue, UngappedShape<q> > const &me);       	// "seqan-1.3.1/seqan/index/shape_base.h"(731)
template <typename TShapeString, typename TValue, typename TSpec> inline void shapeToString( TShapeString &bitmap, Shape<TValue, GappedShape<TSpec> > const &me);       	// "seqan-1.3.1/seqan/index/shape_gapped.h"(634)

//____________________________________________________________________________
// sizeofLcpe

template <typename TSize > inline TSize sizeofLcpe(TSize n);       	// "seqan-1.3.1/seqan/index/index_lcp_tree.h"(119)
template <class LCPFwdIt, typename TSize > inline void sizeofLcpe(LCPFwdIt First_, LCPFwdIt _Last, TSize &Size_);       	// "seqan-1.3.1/seqan/index/index_lcp_tree.h"(138)

//____________________________________________________________________________
// sizeofLcph

template <typename TSize > inline TSize sizeofLcph(TSize n);       	// "seqan-1.3.1/seqan/index/index_lcp_tree.h"(130)
template <class LCPFwdIt, typename TSize > inline void sizeofLcph(LCPFwdIt First_, LCPFwdIt _Last, TSize &Size_);       	// "seqan-1.3.1/seqan/index/index_lcp_tree.h"(146)

//____________________________________________________________________________
// sizeofSABTree

template <typename TSize > inline TSize sizeofSABTree(TSize n, unsigned BlockSize);       	// "seqan-1.3.1/seqan/index/index_sa_btree.h"(93)
template <class SAFwdIt, typename TSize > inline void sizeofSABTree(SAFwdIt First_, SAFwdIt _Last, TSize &Size_, unsigned BlockSize);       	// "seqan-1.3.1/seqan/index/index_sa_btree.h"(104)

//____________________________________________________________________________
// stringSetLimits

template <typename TText, typename TSpec> inline typename StringSetLimits<TText const>::Type stringSetLimits(Index<TText, TSpec> &);       	// "seqan-1.3.1/seqan/index/index_base.h"(1033)
template <typename TText, typename TSpec> inline typename StringSetLimits<TText const>::Type stringSetLimits(Index<TText, TSpec> const &);       	// "seqan-1.3.1/seqan/index/index_base.h"(1039)
template <typename TString, typename TSSetSpec, typename TSpec> inline typename StringSetLimits< StringSet<TString, TSSetSpec> const >::Type & stringSetLimits(Index<StringSet<TString, TSSetSpec>, TSpec> &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(1045)
template <typename TString, typename TSSetSpec, typename TSpec> inline typename StringSetLimits< StringSet<TString, TSSetSpec> const >::Type & stringSetLimits(Index<StringSet<TString, TSSetSpec>, TSpec> const &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(1051)

//____________________________________________________________________________
// stringToShape

template <typename TValue, typename TShapeString> inline bool stringToShape( Shape<TValue, OneGappedShape> &me, TShapeString const &bitmap);       	// "seqan-1.3.1/seqan/index/shape_onegapped.h"(311)
template <typename TValue, typename TShapeString> inline bool stringToShape( Shape<TValue, SimpleShape> &me, TShapeString const &bitmap);       	// "seqan-1.3.1/seqan/index/shape_base.h"(694)
template <typename TValue, typename TSpec, typename TShapeString> inline bool stringToShape( Shape<TValue, GappedShape<TSpec> > &me, TShapeString const &bitmap);       	// "seqan-1.3.1/seqan/index/shape_gapped.h"(581)

//____________________________________________________________________________
// suffix

template <typename TValue, typename TSpec, typename TPos> inline typename Suffix<String<TValue, PizzaChili<TSpec> > >::Type suffix( String<TValue, PizzaChili<TSpec> > const& me, TPos begin );       	// "seqan-1.3.1/seqan/index/index_pizzachili_string.h"(784)
template <typename TValue, typename TSpec, typename TPos> inline typename Suffix<String<TValue, PizzaChili<TSpec> > >::Type suffix( String<TValue, PizzaChili<TSpec> >& me, TPos begin );       	// "seqan-1.3.1/seqan/index/index_pizzachili_string.h"(794)

//____________________________________________________________________________
// suffixLength

template <typename TPos, typename TText, typename TSpec> inline typename Size<Index<TText, TSpec> >::Type suffixLength(TPos pos, Index<TText, TSpec> const &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(793)

//____________________________________________________________________________
// swiftInfix

template <typename TSwiftHit, typename TText> inline typename Infix<TText>::Type swiftInfix(TSwiftHit const &hit, TText &text);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1476)

//____________________________________________________________________________
// swiftInfixNoClip

template <typename TSwiftHit, typename TText> inline typename Infix<TText>::Type swiftInfixNoClip(TSwiftHit const &hit, TText &text);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1469)

//____________________________________________________________________________
// textAt

template <typename TPos, typename TIndex> inline typename Reference<typename Fibre<TIndex, FibreRawText>::Type>::Type textAt(TPos i, TIndex &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(813)
template <typename TPos, typename TString, typename TSSetSpec, typename TSpec> inline typename Reference<typename Fibre< Index< StringSet<TString, TSSetSpec>, TSpec>, FibreRawText>::Type>::Type textAt(TPos i, Index< StringSet<TString, TSSetSpec>, TSpec> &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(818)
template <typename TPos, typename TString, typename TSpec> inline typename Reference<typename Fibre< Index< StringSet<TString, Owner<Default> >, TSpec>, FibreRawText>::Type>::Type textAt(TPos i, Index< StringSet<TString, Owner<Default> >, TSpec> &index);       	// "seqan-1.3.1/seqan/index/index_base.h"(823)

//____________________________________________________________________________
// treeLevelsSAB

template <typename TSize > inline unsigned treeLevelsSAB(TSize saSize, unsigned BlockSize);       	// "seqan-1.3.1/seqan/index/index_sa_btree.h"(117)

//____________________________________________________________________________
// unhash

template <typename TString, typename THash> inline void unhash(TString &result, THash hash, unsigned q);       	// "seqan-1.3.1/seqan/index/shape_base.h"(660)

//____________________________________________________________________________
// upperBoundLcpe

template <typename TText, typename TSA, typename TLCPE, typename TQuery > inline typename Position<TLCPE>::Type upperBoundLcpe( TText const &text, TSA const &sa, TLCPE const &lcpe, TQuery const &query);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(1725)
template <typename TText, typename TSA, typename TLCPE, typename TQuery > inline typename Position<TLCPE>::Type upperBoundLcpe( TText const &text, TSA const &sa, TLCPE const &lcpe, TQuery *query);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(1827)

//____________________________________________________________________________
// upperBoundLcpeIterator

template <typename TText, typename TSA, typename TLCPE, typename TQuery > inline typename Iterator<TSA, Standard>::Type upperBoundLcpeIterator( TText const &text, TSA const &sa, TLCPE const &lcpe, TQuery const &query);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(1776)

//____________________________________________________________________________
// upperBoundSA

template <typename TText, typename TSA, typename TQuery, typename TFlatTreeSpec > inline typename Position<TSA>::Type upperBoundSA( TText const &text, TSA const &sa, TQuery const &query, TFlatTreeSpec const);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(978)
template <typename TText, typename TSA, typename TQuery > inline typename Position<TSA>::Type upperBoundSA( TText const &text, TSA const &sa, TQuery const &query);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(992)
template <typename TText, typename TSA, typename TQuery, typename TFlatTreeSpec > inline typename Position<TSA>::Type upperBoundSA( TText const &text, TSA const &sa, TQuery *query, TFlatTreeSpec const);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(1075)
template <typename TText, typename TSA, typename TQuery > inline typename Position<TSA>::Type upperBoundSA( TText const &text, TSA const &sa, TQuery *query);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(1089)

//____________________________________________________________________________
// upperBoundSAIterator

template <typename TText, typename TSA, typename TQuery > inline typename Iterator<TSA const, Standard>::Type upperBoundSAIterator( TText const &text, TSA const &sa, TQuery const &query);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(855)
template <typename TText, typename TSA, typename TQuery > inline typename Iterator<TSA const, Standard>::Type upperBoundSAIterator( TText const &text, TSA const &sa, TQuery *query);       	// "seqan-1.3.1/seqan/index/find_index_esa.h"(914)

//____________________________________________________________________________
// value

template <typename TSTree, typename TSpec > inline typename VertexDescriptor<TSTree>::Type value(Iter< TSTree, VSTree< BottomUp<MaxRepeats_<TSpec> > > > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_algs.h"(615)
template <typename TRepeat > inline typename Value< Iter<TRepeat, MaxRepeatOccurrences> >::Type & value(Iter<TRepeat, MaxRepeatOccurrences> const &it);       	// "seqan-1.3.1/seqan/index/index_esa_algs.h"(867)
template <typename TRepeat > inline typename Value< Iter<TRepeat, MaxRepeatOccurrences> >::Type & value(Iter<TRepeat, MaxRepeatOccurrences> &it);       	// "seqan-1.3.1/seqan/index/index_esa_algs.h"(873)
template <typename TIndex, class TSpec > inline typename VertexDescriptor<TIndex>::Type & value(Iter< TIndex, VSTree<TSpec> > &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(710)
template <typename TIndex, class TSpec > inline typename VertexDescriptor<TIndex>::Type const & value(Iter< TIndex, VSTree<TSpec> > const &it);       	// "seqan-1.3.1/seqan/index/index_esa_stree.h"(716)
template <typename TValue, typename TSpec> inline typename Value< Shape<TValue, TSpec> >::Type value(Shape<TValue, TSpec> &me);       	// "seqan-1.3.1/seqan/index/shape_base.h"(241)
template <typename TValue, typename TSpec> inline typename Value< Shape<TValue, TSpec> >::Type value(Shape<TValue, TSpec> const &me);       	// "seqan-1.3.1/seqan/index/shape_base.h"(248)
template <typename TRepeat > inline typename Value< Iter<TRepeat, MultiMemOccurences> >::Type & value(Iter<TRepeat, MultiMemOccurences> const &it);       	// "seqan-1.3.1/seqan/index/index_esa_algs_multi.h"(659)
template <typename TRepeat > inline typename Value< Iter<TRepeat, MultiMemOccurences> >::Type & value(Iter<TRepeat, MultiMemOccurences> &it);       	// "seqan-1.3.1/seqan/index/index_esa_algs_multi.h"(665)

//____________________________________________________________________________
// weight

template <typename TValue> inline typename Size< Shape<TValue, OneGappedShape> >::Type weight(Shape<TValue, OneGappedShape> const & me);       	// "seqan-1.3.1/seqan/index/shape_onegapped.h"(161)
template <typename TValue, typename TSpec> inline typename Size< Shape<TValue, TSpec> >::Type weight(Shape<TValue, TSpec> const &me);       	// "seqan-1.3.1/seqan/index/shape_base.h"(279)
template <typename TValue, typename TSpec> inline typename Size< Shape<TValue, GappedShape<TSpec> > >::Type weight(Shape<TValue, GappedShape<TSpec> > const & me);       	// "seqan-1.3.1/seqan/index/shape_gapped.h"(383)

//____________________________________________________________________________
// windowFindBegin

template <typename THaystack, typename TIndex, typename TSpec> inline bool windowFindBegin( Finder<THaystack, Swift<TSpec> > &finder, Pattern<TIndex, Swift<TSpec> > &pattern, double errorRate);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1835)

//____________________________________________________________________________
// windowFindEnd

template <typename THaystack, typename TIndex, typename TSpec> inline void windowFindEnd( Finder<THaystack, Swift<TSpec> > & finder, Pattern<TIndex, Swift<TSpec> > &pattern);       	// "seqan-1.3.1/seqan/index/find_swift.h"(1929)

//____________________________________________________________________________
// windowFindNext

template <typename THaystack, typename TIndex, typename TSpec, typename TSize> inline bool windowFindNext( Finder<THaystack, Swift<TSpec> > &finder, Pattern<TIndex, Swift<TSpec> > &pattern, TSize finderWindowLength );       	// "seqan-1.3.1/seqan/index/find_swift.h"(1874)

//____________________________________________________________________________
// write

template <typename TFile, typename TText, typename TESASpec> void write(TFile & file, Index<TText, IndexEsa<TESASpec> > & stree, DotDrawing);       	// "seqan-1.3.1/seqan/index/index_esa_drawing.h"(45)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

