% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.demo.R
\name{rk.demo}
\alias{rk.demo}
\title{Opens an R demo script for editing}
\usage{
rk.demo(topic, package, lib.loc = NULL)
}
\arguments{
\item{topic}{topic of the example}

\item{package}{package(s) to search for the demo. If missing (the default), all
currently loaded packages are searched.}

\item{lib.loc}{Library locations, passed on to \code{\link[base:system.file]{system.file}}.}
}
\value{
Return \code{NULL}, unconditionally.
}
\description{
\code{rk.demo} behaves similar to \code{\link{demo}}, but opens the demo
script for editing, instead of sourcing it. Contrary to \code{\link{demo}},
the specification of a topic is mandatory.
}
\examples{
\dontrun{
rk.demo("graphics")
}
}
\seealso{
\code{\link{rk.edit.files}}, \code{\link{rk.show.files}},
  \code{\link{demo}}
}
\author{
Thomas Friedrichsmeier \email{rkward-devel@kde.org}
}
\keyword{IO}
\keyword{utilities}
