// file automatically generated by "../../../rheolef/nfem/pbasis/basis_symbolic_cxx.cc"
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "P0.h"
namespace rheolef {
using namespace std;
template<class T>
class basis_P0_p {
public:
  typedef basis_rep<T>              base;
  typedef typename base::size_type size_type;
  static void eval      (const point_basic<T>& hat_x, vector<T>& values);
  static void eval      (const point_basic<T>& hat_x, typename vector<T>::iterator values);
  static void grad_eval (const point_basic<T>& hat_x, vector<point_basic<T> >& values);
  static void grad_eval (const point_basic<T>& hat_x, typename vector<point_basic<T> >::iterator values);
  static void hat_node  (vector<point_basic<T> >& hat_node);
  static void hat_node  (typename vector<point_basic<T> >::iterator values);
};
template<class T>
class basis_P0_e {
public:
  typedef basis_rep<T>              base;
  typedef typename base::size_type size_type;
  static void eval      (const point_basic<T>& hat_x, vector<T>& values);
  static void eval      (const point_basic<T>& hat_x, typename vector<T>::iterator values);
  static void grad_eval (const point_basic<T>& hat_x, vector<point_basic<T> >& values);
  static void grad_eval (const point_basic<T>& hat_x, typename vector<point_basic<T> >::iterator values);
  static void hat_node  (vector<point_basic<T> >& hat_node);
  static void hat_node  (typename vector<point_basic<T> >::iterator values);
};
template<class T>
class basis_P0_t {
public:
  typedef basis_rep<T>              base;
  typedef typename base::size_type size_type;
  static void eval      (const point_basic<T>& hat_x, vector<T>& values);
  static void eval      (const point_basic<T>& hat_x, typename vector<T>::iterator values);
  static void grad_eval (const point_basic<T>& hat_x, vector<point_basic<T> >& values);
  static void grad_eval (const point_basic<T>& hat_x, typename vector<point_basic<T> >::iterator values);
  static void hat_node  (vector<point_basic<T> >& hat_node);
  static void hat_node  (typename vector<point_basic<T> >::iterator values);
};
template<class T>
class basis_P0_q {
public:
  typedef basis_rep<T>              base;
  typedef typename base::size_type size_type;
  static void eval      (const point_basic<T>& hat_x, vector<T>& values);
  static void eval      (const point_basic<T>& hat_x, typename vector<T>::iterator values);
  static void grad_eval (const point_basic<T>& hat_x, vector<point_basic<T> >& values);
  static void grad_eval (const point_basic<T>& hat_x, typename vector<point_basic<T> >::iterator values);
  static void hat_node  (vector<point_basic<T> >& hat_node);
  static void hat_node  (typename vector<point_basic<T> >::iterator values);
};
template<class T>
class basis_P0_T {
public:
  typedef basis_rep<T>              base;
  typedef typename base::size_type size_type;
  static void eval      (const point_basic<T>& hat_x, vector<T>& values);
  static void eval      (const point_basic<T>& hat_x, typename vector<T>::iterator values);
  static void grad_eval (const point_basic<T>& hat_x, vector<point_basic<T> >& values);
  static void grad_eval (const point_basic<T>& hat_x, typename vector<point_basic<T> >::iterator values);
  static void hat_node  (vector<point_basic<T> >& hat_node);
  static void hat_node  (typename vector<point_basic<T> >::iterator values);
};
template<class T>
class basis_P0_P {
public:
  typedef basis_rep<T>              base;
  typedef typename base::size_type size_type;
  static void eval      (const point_basic<T>& hat_x, vector<T>& values);
  static void eval      (const point_basic<T>& hat_x, typename vector<T>::iterator values);
  static void grad_eval (const point_basic<T>& hat_x, vector<point_basic<T> >& values);
  static void grad_eval (const point_basic<T>& hat_x, typename vector<point_basic<T> >::iterator values);
  static void hat_node  (vector<point_basic<T> >& hat_node);
  static void hat_node  (typename vector<point_basic<T> >::iterator values);
};
template<class T>
class basis_P0_H {
public:
  typedef basis_rep<T>              base;
  typedef typename base::size_type size_type;
  static void eval      (const point_basic<T>& hat_x, vector<T>& values);
  static void eval      (const point_basic<T>& hat_x, typename vector<T>::iterator values);
  static void grad_eval (const point_basic<T>& hat_x, vector<point_basic<T> >& values);
  static void grad_eval (const point_basic<T>& hat_x, typename vector<point_basic<T> >::iterator values);
  static void hat_node  (vector<point_basic<T> >& hat_node);
  static void hat_node  (typename vector<point_basic<T> >::iterator values);
};
template<class T>
void
basis_P0_p<T>::eval(
  const point_basic<T>&        hat_x,
  typename vector<T>::iterator values)
{
  values[0] = 1.0;
}
template<class T>
void
basis_P0_p<T>::eval(
  const point_basic<T>& hat_x,
  vector<T>&            values)
{
  values.resize(1);
  eval (hat_x, values.begin());
}
template<class T>
void
basis_P0_p<T>::grad_eval(
  const point_basic<T>&                      hat_x,
  typename vector<point_basic<T> >::iterator values)
{
}
template<class T>
void
basis_P0_p<T>::grad_eval(
  const point_basic<T>&    hat_x,
  vector<point_basic<T> >& values)
{
  values.resize(1);
  grad_eval (hat_x, values.begin());
}
template<class T>
void
basis_P0_p<T>::hat_node (typename vector<point_basic<T> >::iterator x)
{
  x[0] = point_basic<T>();
}
template<class T>
void
basis_P0_p<T>::hat_node (vector<point_basic<T> >& x)
{
  x.resize(1);
  hat_node (x.begin());
}
template<class T>
void
basis_P0_e<T>::eval(
  const point_basic<T>&        hat_x,
  typename vector<T>::iterator values)
{
  values[0] = 1.0;
}
template<class T>
void
basis_P0_e<T>::eval(
  const point_basic<T>& hat_x,
  vector<T>&            values)
{
  values.resize(1);
  eval (hat_x, values.begin());
}
template<class T>
void
basis_P0_e<T>::grad_eval(
  const point_basic<T>&                      hat_x,
  typename vector<point_basic<T> >::iterator values)
{
  values[0][0] = 0.0;
}
template<class T>
void
basis_P0_e<T>::grad_eval(
  const point_basic<T>&    hat_x,
  vector<point_basic<T> >& values)
{
  values.resize(1);
  grad_eval (hat_x, values.begin());
}
template<class T>
void
basis_P0_e<T>::hat_node (typename vector<point_basic<T> >::iterator x)
{
  x[0] = point_basic<T>(5.0000000000000000e-01);
}
template<class T>
void
basis_P0_e<T>::hat_node (vector<point_basic<T> >& x)
{
  x.resize(1);
  hat_node (x.begin());
}
template<class T>
void
basis_P0_t<T>::eval(
  const point_basic<T>&        hat_x,
  typename vector<T>::iterator values)
{
  values[0] = 1.0;
}
template<class T>
void
basis_P0_t<T>::eval(
  const point_basic<T>& hat_x,
  vector<T>&            values)
{
  values.resize(1);
  eval (hat_x, values.begin());
}
template<class T>
void
basis_P0_t<T>::grad_eval(
  const point_basic<T>&                      hat_x,
  typename vector<point_basic<T> >::iterator values)
{
  values[0][0] = 0.0;
  values[0][1] = 0.0;
}
template<class T>
void
basis_P0_t<T>::grad_eval(
  const point_basic<T>&    hat_x,
  vector<point_basic<T> >& values)
{
  values.resize(1);
  grad_eval (hat_x, values.begin());
}
template<class T>
void
basis_P0_t<T>::hat_node (typename vector<point_basic<T> >::iterator x)
{
  x[0] = point_basic<T>((1.0/3.0), (1.0/3.0));
}
template<class T>
void
basis_P0_t<T>::hat_node (vector<point_basic<T> >& x)
{
  x.resize(1);
  hat_node (x.begin());
}
template<class T>
void
basis_P0_q<T>::eval(
  const point_basic<T>&        hat_x,
  typename vector<T>::iterator values)
{
  values[0] = 1.0;
}
template<class T>
void
basis_P0_q<T>::eval(
  const point_basic<T>& hat_x,
  vector<T>&            values)
{
  values.resize(1);
  eval (hat_x, values.begin());
}
template<class T>
void
basis_P0_q<T>::grad_eval(
  const point_basic<T>&                      hat_x,
  typename vector<point_basic<T> >::iterator values)
{
  values[0][0] = 0.0;
  values[0][1] = 0.0;
}
template<class T>
void
basis_P0_q<T>::grad_eval(
  const point_basic<T>&    hat_x,
  vector<point_basic<T> >& values)
{
  values.resize(1);
  grad_eval (hat_x, values.begin());
}
template<class T>
void
basis_P0_q<T>::hat_node (typename vector<point_basic<T> >::iterator x)
{
  x[0] = point_basic<T>(0.0, 0.0);
}
template<class T>
void
basis_P0_q<T>::hat_node (vector<point_basic<T> >& x)
{
  x.resize(1);
  hat_node (x.begin());
}
template<class T>
void
basis_P0_T<T>::eval(
  const point_basic<T>&        hat_x,
  typename vector<T>::iterator values)
{
  values[0] = 1.0;
}
template<class T>
void
basis_P0_T<T>::eval(
  const point_basic<T>& hat_x,
  vector<T>&            values)
{
  values.resize(1);
  eval (hat_x, values.begin());
}
template<class T>
void
basis_P0_T<T>::grad_eval(
  const point_basic<T>&                      hat_x,
  typename vector<point_basic<T> >::iterator values)
{
  values[0][0] = 0.0;
  values[0][1] = 0.0;
  values[0][2] = 0.0;
}
template<class T>
void
basis_P0_T<T>::grad_eval(
  const point_basic<T>&    hat_x,
  vector<point_basic<T> >& values)
{
  values.resize(1);
  grad_eval (hat_x, values.begin());
}
template<class T>
void
basis_P0_T<T>::hat_node (typename vector<point_basic<T> >::iterator x)
{
  x[0] = point_basic<T>(2.5000000000000000e-01, 2.5000000000000000e-01, 2.5000000000000000e-01);
}
template<class T>
void
basis_P0_T<T>::hat_node (vector<point_basic<T> >& x)
{
  x.resize(1);
  hat_node (x.begin());
}
template<class T>
void
basis_P0_P<T>::eval(
  const point_basic<T>&        hat_x,
  typename vector<T>::iterator values)
{
  values[0] = 1.0;
}
template<class T>
void
basis_P0_P<T>::eval(
  const point_basic<T>& hat_x,
  vector<T>&            values)
{
  values.resize(1);
  eval (hat_x, values.begin());
}
template<class T>
void
basis_P0_P<T>::grad_eval(
  const point_basic<T>&                      hat_x,
  typename vector<point_basic<T> >::iterator values)
{
  values[0][0] = 0.0;
  values[0][1] = 0.0;
  values[0][2] = 0.0;
}
template<class T>
void
basis_P0_P<T>::grad_eval(
  const point_basic<T>&    hat_x,
  vector<point_basic<T> >& values)
{
  values.resize(1);
  grad_eval (hat_x, values.begin());
}
template<class T>
void
basis_P0_P<T>::hat_node (typename vector<point_basic<T> >::iterator x)
{
  x[0] = point_basic<T>((1.0/3.0), (1.0/3.0), 0.0);
}
template<class T>
void
basis_P0_P<T>::hat_node (vector<point_basic<T> >& x)
{
  x.resize(1);
  hat_node (x.begin());
}
template<class T>
void
basis_P0_H<T>::eval(
  const point_basic<T>&        hat_x,
  typename vector<T>::iterator values)
{
  values[0] = 1.0;
}
template<class T>
void
basis_P0_H<T>::eval(
  const point_basic<T>& hat_x,
  vector<T>&            values)
{
  values.resize(1);
  eval (hat_x, values.begin());
}
template<class T>
void
basis_P0_H<T>::grad_eval(
  const point_basic<T>&                      hat_x,
  typename vector<point_basic<T> >::iterator values)
{
  values[0][0] = 0.0;
  values[0][1] = 0.0;
  values[0][2] = 0.0;
}
template<class T>
void
basis_P0_H<T>::grad_eval(
  const point_basic<T>&    hat_x,
  vector<point_basic<T> >& values)
{
  values.resize(1);
  grad_eval (hat_x, values.begin());
}
template<class T>
void
basis_P0_H<T>::hat_node (typename vector<point_basic<T> >::iterator x)
{
  x[0] = point_basic<T>(0.0, 0.0, 0.0);
}
template<class T>
void
basis_P0_H<T>::hat_node (vector<point_basic<T> >& x)
{
  x.resize(1);
  hat_node (x.begin());
}
template<class T>
basis_P0<T>::~basis_P0()
{
}
template<class T>
typename basis_P0<T>::size_type
basis_P0<T>::degree () const
{
    return 0;
}
template<class T>
typename basis_P0<T>::size_type
basis_P0<T>::size (
    reference_element hat_K) const
{
    switch (hat_K.variant()) {
      case reference_element::p: {
        return 1;
      }
      case reference_element::e: {
        return 1;
      }
      case reference_element::t: {
        return 1;
      }
      case reference_element::q: {
        return 1;
      }
      case reference_element::T: {
        return 1;
      }
      case reference_element::P: {
        return 1;
      }
      case reference_element::H: {
        return 1;
      }
      default : {
        error_macro ("size: unsupported `" << hat_K.name() << "' element type");
        return 0;
      }
    }
}
template<class T>
void
basis_P0<T>::eval(
    reference_element     hat_K,
    const point_basic<T>& hat_x,
    vector<T>&        values) const
{
    switch (hat_K.variant()) {
      case reference_element::p: {
        return basis_P0_p<T>::eval (hat_x, values);
      }
      case reference_element::e: {
        return basis_P0_e<T>::eval (hat_x, values);
      }
      case reference_element::t: {
        return basis_P0_t<T>::eval (hat_x, values);
      }
      case reference_element::q: {
        return basis_P0_q<T>::eval (hat_x, values);
      }
      case reference_element::T: {
        return basis_P0_T<T>::eval (hat_x, values);
      }
      case reference_element::P: {
        return basis_P0_P<T>::eval (hat_x, values);
      }
      case reference_element::H: {
        return basis_P0_H<T>::eval (hat_x, values);
      }
      default : {
        error_macro ("eval: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
template<class T>
void
basis_P0<T>::eval(
    reference_element     hat_K,
    const point_basic<T>& hat_x,
    typename vector<T>::iterator        values) const
{
    switch (hat_K.variant()) {
      case reference_element::p: {
        return basis_P0_p<T>::eval (hat_x, values);
      }
      case reference_element::e: {
        return basis_P0_e<T>::eval (hat_x, values);
      }
      case reference_element::t: {
        return basis_P0_t<T>::eval (hat_x, values);
      }
      case reference_element::q: {
        return basis_P0_q<T>::eval (hat_x, values);
      }
      case reference_element::T: {
        return basis_P0_T<T>::eval (hat_x, values);
      }
      case reference_element::P: {
        return basis_P0_P<T>::eval (hat_x, values);
      }
      case reference_element::H: {
        return basis_P0_H<T>::eval (hat_x, values);
      }
      default : {
        error_macro ("eval: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
template<class T>
void
basis_P0<T>::grad_eval(
    reference_element        hat_K,
    const point_basic<T>&    hat_x,
    vector<point_basic<T> >&            values) const
{
    switch (hat_K.variant()) {
      case reference_element::p: {
      return basis_P0_p<T>::grad_eval (hat_x, values);
      }
      case reference_element::e: {
      return basis_P0_e<T>::grad_eval (hat_x, values);
      }
      case reference_element::t: {
      return basis_P0_t<T>::grad_eval (hat_x, values);
      }
      case reference_element::q: {
      return basis_P0_q<T>::grad_eval (hat_x, values);
      }
      case reference_element::T: {
      return basis_P0_T<T>::grad_eval (hat_x, values);
      }
      case reference_element::P: {
      return basis_P0_P<T>::grad_eval (hat_x, values);
      }
      case reference_element::H: {
      return basis_P0_H<T>::grad_eval (hat_x, values);
      }
      default : {
        error_macro ("grad_eval: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
template<class T>
void
basis_P0<T>::grad_eval(
    reference_element        hat_K,
    const point_basic<T>&    hat_x,
    typename vector<point_basic<T> >::iterator            values) const
{
    switch (hat_K.variant()) {
      case reference_element::p: {
      return basis_P0_p<T>::grad_eval (hat_x, values);
      }
      case reference_element::e: {
      return basis_P0_e<T>::grad_eval (hat_x, values);
      }
      case reference_element::t: {
      return basis_P0_t<T>::grad_eval (hat_x, values);
      }
      case reference_element::q: {
      return basis_P0_q<T>::grad_eval (hat_x, values);
      }
      case reference_element::T: {
      return basis_P0_T<T>::grad_eval (hat_x, values);
      }
      case reference_element::P: {
      return basis_P0_P<T>::grad_eval (hat_x, values);
      }
      case reference_element::H: {
      return basis_P0_H<T>::grad_eval (hat_x, values);
      }
      default : {
        error_macro ("grad_eval: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
template<class T>
void
basis_P0<T>::hat_node(
    reference_element hat_K,
    vector<point_basic<T> >&     hat_node) const
{
    switch (hat_K.variant()) {
      case reference_element::p: {
        return basis_P0_p<T>::hat_node (hat_node);
      }
      case reference_element::e: {
        return basis_P0_e<T>::hat_node (hat_node);
      }
      case reference_element::t: {
        return basis_P0_t<T>::hat_node (hat_node);
      }
      case reference_element::q: {
        return basis_P0_q<T>::hat_node (hat_node);
      }
      case reference_element::T: {
        return basis_P0_T<T>::hat_node (hat_node);
      }
      case reference_element::P: {
        return basis_P0_P<T>::hat_node (hat_node);
      }
      case reference_element::H: {
        return basis_P0_H<T>::hat_node (hat_node);
      }
      default : {
        error_macro ("hat_node: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
template<class T>
void
basis_P0<T>::hat_node(
    reference_element hat_K,
    typename vector<point_basic<T> >::iterator     hat_node) const
{
    switch (hat_K.variant()) {
      case reference_element::p: {
        return basis_P0_p<T>::hat_node (hat_node);
      }
      case reference_element::e: {
        return basis_P0_e<T>::hat_node (hat_node);
      }
      case reference_element::t: {
        return basis_P0_t<T>::hat_node (hat_node);
      }
      case reference_element::q: {
        return basis_P0_q<T>::hat_node (hat_node);
      }
      case reference_element::T: {
        return basis_P0_T<T>::hat_node (hat_node);
      }
      case reference_element::P: {
        return basis_P0_P<T>::hat_node (hat_node);
      }
      case reference_element::H: {
        return basis_P0_H<T>::hat_node (hat_node);
      }
      default : {
        error_macro ("hat_node: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
// instantiation in library:
template class basis_P0<Float>;
} // namespace rheolef
