set terminal pslatex auxfile
set output "crack-P1-uniform.tex"

set logscale
set size square

set xtics (\
        "{$10^{-3}$}" 1e-3, \
	"{$10^{-2}$}" 1e-2, \
	"{$10^{-1}$}" 1e-1, \
	"{$10^{0}$}"  1e+0  \
	)
set ytics (\
        "[r]{$10^{-3}$}" 1e-3, \
	"[r]{$10^{-2}$}" 1e-2, \
	"[r]{$10^{-1}$}" 1e-1  \
	)

# x-label
set label "{$nelt^{-{1 \\over 2}}$}" at graph 0.90, 0.10 right
set label "[l]{$P_1$ element}" at graph 0.10, 0.10 left

set label "[l]{$\\Vert u-u_h \\Vert_{0,\\infty,\\Omega}$}" at graph 0.05, 0.87
set label "[l]{$\\Vert u-u_h \\Vert_{0,2,\\Omega}$}"       at graph 0.05, 0.55

# triangle slope: 0.5
set arrow from graph 0.20, 0.70 to graph 0.40, 0.70 nohead lt 1
set arrow from graph 0.40, 0.70 to graph 0.40, 0.80 nohead lt 1
set arrow from graph 0.40, 0.80 to graph 0.20, 0.70 nohead lt 1
set label "[l]{$\\scriptstyle {1 \\over 2} = \\alpha $}" at graph 0.43, 0.75 left

# triangle slope: 1
set arrow from graph 0.20, 0.30 to graph 0.40, 0.30 nohead lt 1
set arrow from graph 0.40, 0.30 to graph 0.40, 0.50 nohead lt 1
set arrow from graph 0.40, 0.50 to graph 0.20, 0.30 nohead lt 1
set label "[l]{$\\scriptstyle 1 = \\alpha + {1 \\over 2}$}" at graph 0.43, 0.40 left

plot [0.001:1][0.0001:0.1] \
	"crack-P1-uniform.gdat" u (1./sqrt($1)):3 notitle with linespoints linetype 1, \
	"crack-P1-uniform.gdat" u (1./sqrt($1)):4 notitle with linespoints linetype 1

# pause -1 "<retour>"

