\name{InvBasis.wp}
\alias{InvBasis.wp}
\title{Invert a wp library representation with a particular basis spec}
\usage{
\method{InvBasis}{wp}(wp, nvwp, pktlist, verbose=FALSE, \dots)
}
\arguments{
\item{wp}{The wavelet packet object you wish to invert.}
\item{nvwp}{A basis specification in the format of a node vector (wp) object,
	obtained, eg by the \code{\link{MaNoVe.wp}} function}
\item{pktlist}{Another way of specifying the basis. If this argument is
	not specified then it is generated automatically from the
	\code{nvwp} argument. If it is specified then it overrides
	the one generated by \code{nvwp}}
\item{verbose}{If TRUE then informative messages are printed.}
\item{...}{Other arguments, not used}
}
\description{
Inverts a wp basis representation with a given basis specification,
for example an output from the \code{\link{MaNoVe}} function.}
\details{
Objects arising from a \code{\link{wp.object}} specification
are a representation of a signal with respect to a library
of wavelet packet basis functions.
A particular basis specification can be obtained
using the \code{\link{numtonv}} function which can pick an indexed
basis function, or \code{\link{MaNoVe.wp}} which uses the
Coifman-Wickerhauser minimum entropy method to select a basis.
This function takes a \code{\link{wp.object}} and
a particular basis description (in a \code{\link{nv.object}} node vector
object) and inverts the representation with respect to that selected basis.

The function can alternatively take a packet list \code{pktlist}
specification which
overrides the node vector if supplied. If the \code{pktlist} is missing
then one is generated internally from the \code{nvwp} object using the
\code{\link{print.nvwp}} function.
}
\value{
The inverted reconstruction
}
\seealso{\code{\link{InvBasis}},\code{\link{MaNoVe.wp}},\code{\link{numtonv}},\code{\link{print.nvwp}},\code{\link{wp}}}
\examples{
#
# The example in InvBasis.wst can be used here, but replaced wst by wp
#
}
\author{G P Nason}
\keyword{smooth}
