% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filechoose.R, R/dirchoose.R, R/filesave.R
\name{shinyFiles-parsers}
\alias{shinyFiles-parsers}
\alias{parseFilePaths}
\alias{parseDirPath}
\alias{parseSavePath}
\title{Convert the output of a selection to platform specific path(s)}
\usage{
parseFilePaths(roots, selection)

parseDirPath(roots, selection)

parseSavePath(roots, selection)
}
\arguments{
\item{roots}{The path to the root as specified in the \code{shinyFileChoose()}
call in \code{shinyServer()}}

\item{selection}{The corresponding input variable to be parsed}
}
\value{
A data frame matching the format of \code{\link[shiny:fileInput]{shiny::fileInput()}}
}
\description{
This function takes the value of a shinyFiles button input variable and
converts it to be easier to work with on the server side. In the case of file
selections  and saving the input variable is converted to a data frame (using
\code{parseFilePaths()} or \code{parseSavePath() respectively}) of the same
format as that provided by \code{\link[shiny:fileInput]{shiny::fileInput()}}. The only caveat
here is that the MIME type cannot be inferred in file selections so this will
always be an empty string and new files doesn't have a size so this is left
out with file saving. In the case of folder selection the input variable is
converted to a string (using \code{parseDirPath()}) giving the absolute path
to the selected folder.
}
\details{
The use of \code{parseFilePaths} makes it easy to substitute fileInput and
shinyFiles in your code as code that relies on the values of a file selection
doesn't have to change.
}
\examples{
\dontrun{
ui <- shinyUI(bootstrapPage(
  shinyFilesButton('files', 'File select', 'Please select a file', FALSE),
  verbatimTextOutput('rawInputValue'),
  verbatimTextOutput('filepaths')
))
server <- shinyServer(function(input, output) {
  roots = c(wd='.')
  shinyFileChoose(input, 'files', roots=roots, filetypes=c('', 'txt'))
  output$rawInputValue <- renderPrint({str(input$files)})
  output$filepaths <- renderPrint({parseFilePaths(roots, input$files)})
})

runApp(list(
  ui=ui,
  server=server
))
}

}
\seealso{
Other shinyFiles: \code{\link{shinyFiles-buttons}},
  \code{\link{shinyFiles-observers}},
  \code{\link{shinyFilesExample}}
}
\concept{shinyFiles}
