% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale.R
\name{step_scale}
\alias{step_scale}
\title{Scaling Numeric Data}
\usage{
step_scale(recipe, ..., role = NA, trained = FALSE, sds = NULL,
  na.rm = TRUE)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of 
operations for this recipe.}

\item{...}{One or more selector functions to choose which variables are 
affected by the step. See \code{\link{selections}} for more details.}

\item{role}{Not used by this step since no new variables are created.}

\item{trained}{A logical to indicate if the quantities for preprocessing 
have been estimated.}

\item{sds}{A named numeric vector of standard deviations This is \code{NULL}
until computed by \code{\link{prep.recipe}}.}

\item{na.rm}{A logical value indicating whether \code{NA} values should be
removed when computing the standard deviation.}
}
\value{
An updated version of \code{recipe} with the
  new step added to the sequence of existing steps (if any).
}
\description{
\code{step_scale} creates a \emph{specification} of a recipe step that
  will normalize numeric data to have a standard deviation of one.
}
\details{
Scaling data means that the standard deviation of a variable is
  divided out of the data. \code{step_scale} estimates the variable
  standard deviations from the data used in the \code{training} argument of
  \code{prep.recipe}. \code{bake.recipe} then applies the scaling to
  new data sets using these standard deviations.
}
\examples{
data(biomass)

biomass_tr <- biomass[biomass$dataset == "Training",]
biomass_te <- biomass[biomass$dataset == "Testing",]

rec <- recipe(HHV ~ carbon + hydrogen + oxygen + nitrogen + sulfur,
              data = biomass_tr)

scaled_trans <- rec \%>\%
  step_scale(carbon, hydrogen)

scaled_obj <- prep(scaled_trans, training = biomass_tr)

transformed_te <- bake(scaled_obj, biomass_te)

biomass_te[1:10, names(transformed_te)]
transformed_te
}
\concept{
preprocessing normalization_methods
}
\keyword{datagen}
