% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emmGrid-methods.R
\docType{data}
\name{emm_options}
\alias{emm_options}
\alias{get_emm_option}
\alias{emm_defaults}
\title{Set or change emmeans options}
\format{An object of class \code{list} of length 17.}
\usage{
emm_options(...)

get_emm_option(x, default = emm_defaults[[x]])

emm_defaults
}
\arguments{
\item{...}{Option names and values (see Details)}

\item{x}{Character value - the name of an option to be queried}

\item{default}{Value to return if \code{x} is not found}
}
\value{
\code{emm_options} returns the current options (same as the result 
  of \samp{getOption("emmeans")}) -- invisibly, unless called with no arguments.

\code{get_emm_option} returns the currently stored option for \code{x}, 
  or its default value if not found.
}
\description{
Use \code{emm_options} to set or change various options that are used in
the \pkg{emmeans} package. These options are set separately for different contexts in
which \code{emmGrid} objects are created, in a named list of option lists.
}
\details{
Currently, the following main list entries are supported:
\describe{
\item{\code{ref_grid}}{A named \code{list} of defaults for objects created by
\code{\link{ref_grid}}. This could affect other objects as well. For example,
if \code{emmeans} is called with a fitted model object, it calls
\code{ref_grid} and this option will affect the resulting \code{emmGrid}
object.}
\item{\code{emmeans}}{A named \code{list} of defaults for objects created by
  \code{\link{emmeans}} or \code{\link{emtrends}}.}
\item{\code{contrast}}{A named \code{list} of defaults for objects created by
  \code{\link{contrast.emmGrid}} or \code{\link{pairs.emmGrid}}.}
\item{\code{summary}}{A named \code{list} of defaults used by the methods
  \code{\link{summary.emmGrid}}, \code{\link{predict.emmGrid}}, \code{\link{test.emmGrid}},
  \code{\link{confint.emmGrid}}, and \code{\link{emmip}}. The only option that can
  affect the latter four is \code{"predict.method"}.}
\item{\code{cov.keep}}{The default value of \code{cov.keep} in \code{\link{ref_grid}}.
  Defaults to \code{"2"}, i.e., two-level covariates are treated like factors.}
\item{\code{graphics.engine}}{A character value matching 
  \code{c("ggplot", "lattice")}, setting the default engine to use in
  \code{\link{emmip}} and \code{\link{plot.emmGrid}}.  Defaults to \code{"ggplot"}.}
\item{\code{msg.interaction}}{A logical value controlling whether or not
  a message is displayed when \code{emmeans} averages over a factor involved
  in an interaction. It is probably not appropriate to do this, unless
  the interaction is weak. Defaults to \code{TRUE}.}
\item{\code{msg.nesting}}{A logical value controlling whether or not to
  display a message when a nesting structure is auto-detected. The existence
  of such a structure affects computations of EMMs. Sometimes, a nesting
  structure is falsely detected -- namely when a user has omitted some
  main effects but included them in interactions. This does not change the
  model fit, but it produces a different parameterization that is picked
  up when the reference grid is constructed. Defaults to \code{TRUE}.}
\item{\code{simplify.names}}{A logical value controlling whether to
  simplify (when possible) names in the model formula that refer to datasets --
  for example, should we simplify a predictor name like \dQuote{\code{data$trt}}
  to just \dQuote{\code{trt}}? Defaults to \code{TRUE}.}
\item{\code{opt.digits}}{A logical value controlling the precision with which
  summaries are printed. If \code{TRUE} (default), the number of digits
  displayed is just enough to reasonably distinguish estimates from the ends
  of their confidence intervals; but always at least 3 digits. If
  \code{FALSE}, the system value \code{getOption("digits")} is used.}
\item{\code{back.bias.adj}}{A logical value controlling whether we 
  try to adjust bias when back-transforming. If \code{FALSE}, we use naive
  back transformation. If \code{TRUE} \emph{and \code{sigma} is available}, a
  second-order adjustment is applied to estimate the mean on the response
  scale.}
  
}%%% end describe{}
Some other options have more specific purposes:
\describe{
\item{\code{estble.tol}}{Tolerance for determining estimability in
rank-deficient cases. If absent, the value in \code{emm_defaults$estble.tol)}
is used.}
\item{\code{save.ref_grid}}{Logical value of \code{TRUE} if you wish the 
latest reference grid created to be saved in \code{.Last.ref_grid}}
\item{Options for \code{lme4::lmerMod} models}{Options \code{lmer.df},
\code{disable.pbkrtest}, \code{pbkrtest.limit}, \code{disable.lmerTest},
and \code{lmerTest.limit}
options affect how degrees of freedom are computed for \code{lmerMod} objects
produced by the \pkg{lme4} package). See that section of the "models" vignette
for details.}
} %%%%%% end \describe
}
\examples{
\dontrun{
emm_options(ref_grid = list(level = .90),
            contrast = list(infer = c(TRUE,FALSE)),
            estble.tol = 1e-6)
# Sets default confidence level to .90 for objects created by ref.grid
# AS WELL AS emmeans called with a model object (since it creates a 
# reference grid). In addition, when we call 'contrast', 'pairs', etc.,
# confidence intervals rather than tests are displayed by default.
}

\dontrun{
emm_options(disable.pbkrtest = TRUE)
# This forces use of asymptotic methods for lmerMod objects.
# Set to FALSE or NULL to re-enable using pbkrtest.
}

# See tolerance being used for determining estimability
get_emm_option("estble.tol")

}
\seealso{
\code{\link{update.emmGrid}}
}
\keyword{datasets}
