% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rma-mv.R
\name{findCluster.rma.mv}
\alias{findCluster.rma.mv}
\title{Detect cluster structure of an rma.mv object}
\usage{
findCluster.rma.mv(obj)
}
\arguments{
\item{obj}{A fitted \code{rma.mv} object.}
}
\value{
A a vector of ID variables for the highest level of clustering in \code{obj}.
}
\description{
\code{findCluster.rma.mv} returns a vector of ID variables for the highest level of clustering in a fitted \code{rma.mv} model.
}
\examples{
library(metafor)
data(hierdat, package = "robumeta")

mfor_fit <- rma.mv(effectsize ~ binge + followup + sreport + age, 
                 V = var, random = list(~ 1 | esid, ~ 1 | studyid),
                 data = hierdat)
findCluster.rma.mv(mfor_fit)

}
