% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survey-tidiers.R
\name{tidy.svyolr}
\alias{tidy.svyolr}
\alias{svyolr_tidiers}
\title{Tidy a(n) svyolr object}
\usage{
\method{tidy}{svyolr}(x, conf.int = FALSE, conf.level = 0.95, exponentiate = FALSE, ...)
}
\arguments{
\item{x}{A \code{svyolr} object returned from \code{\link[survey:svyolr]{survey::svyolr()}}.}

\item{conf.int}{Logical indicating whether or not to include a confidence
interval in the tidied output. Defaults to \code{FALSE}.}

\item{conf.level}{The confidence level to use for the confidence interval
if \code{conf.int = TRUE}. Must be strictly greater than 0 and less than 1.
Defaults to 0.95, which corresponds to a 95 percent confidence interval.}

\item{exponentiate}{Logical indicating whether or not to exponentiate the
the coefficient estimates. This is typical for logistic and multinomial
regressions, but a bad idea if there is no log or logit link. Defaults
to \code{FALSE}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Two exceptions here are:
\itemize{
\item \code{tidy()} methods will warn when supplied an \code{exponentiate} argument if
it will be ignored.
\item \code{augment()} methods will warn when supplied a \code{newdata} argument if it
will be ignored.
}}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\details{
The \code{tidy.svyolr()} tidier is a light wrapper around
\code{\link[=tidy.polr]{tidy.polr()}}. However, the implementation for p-value calculation
in \code{\link[=tidy.polr]{tidy.polr()}} is both computationally intensive and specific to that
model, so the \code{p.values} argument to \code{tidy.svyolr()} is currently ignored,
and will raise a warning when passed.
}
\examples{
\dontshow{if (rlang::is_installed(c("survey", "MASS"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(broom)
library(survey)

data(api)
dclus1 <- svydesign(id = ~dnum, weights = ~pw, data = apiclus1, fpc = ~fpc)
dclus1 <- update(dclus1, mealcat = cut(meals, c(0, 25, 50, 75, 100)))

m <- svyolr(mealcat ~ avg.ed + mobility + stype, design = dclus1)

m

tidy(m, conf.int = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
\link{tidy}, \code{\link[survey:svyolr]{survey::svyolr()}}

Other ordinal tidiers: 
\code{\link{augment.clm}()},
\code{\link{augment.polr}()},
\code{\link{glance.clm}()},
\code{\link{glance.clmm}()},
\code{\link{glance.polr}()},
\code{\link{glance.svyolr}()},
\code{\link{tidy.clm}()},
\code{\link{tidy.clmm}()},
\code{\link{tidy.polr}()}
}
\concept{ordinal tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{conf.high}{Upper bound on the confidence interval for the estimate.}
  \item{conf.low}{Lower bound on the confidence interval for the estimate.}
  \item{estimate}{The estimated value of the regression term.}
  \item{p.value}{The two-sided p-value associated with the observed statistic.}
  \item{statistic}{The value of a T-statistic to use in a hypothesis that the regression term is non-zero.}
  \item{std.error}{The standard error of the regression term.}
  \item{term}{The name of the regression term.}

}
