% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htest_tidiers.R
\name{htest_tidiers}
\alias{htest_tidiers}
\alias{tidy.htest}
\alias{glance.htest}
\title{Tidying methods for an htest object}
\usage{
\method{tidy}{htest}(x, ...)

\method{glance}{htest}(x, ...)
}
\arguments{
\item{x}{An object of class \code{"htest"}}

\item{...}{extra arguments (not used)}
}
\value{
Both \code{tidy} and \code{glance} return the same output,
a one-row data frame with one or more of the following columns:
  \item{estimate}{Estimate of the effect size}
  \item{statistic}{Test statistic used to compute the p-value}
  \item{p.value}{P-value}
  \item{parameter}{Parameter field in the htest, typically degrees of
  freedom}
  \item{conf.low}{Lower bound on a confidence interval}
  \item{conf.high}{Upper bound on a confidence interval}
  \item{estimate1}{Sometimes two estimates are computed, such as in a
  two-sample t-test}
  \item{estimate2}{Sometimes two estimates are computed, such as in a
  two-sample t-test}
  \item{method}{Method used to compute the statistic as a string}
  \item{alternative}{Alternative hypothesis as a string}
  
Which columns are included depends on the hypothesis test used.
}
\description{
Tidies hypothesis test objects, such as those from \code{cor.test},
\code{t.test}, and \code{wilcox.test}, into a one-row data frame.
}
\details{
No \code{augment} method is provided for \code{"htest"},
since there is no sense in which a hypothesis test generates one
value for each observation.
}
\examples{

tt <- t.test(rnorm(10))
tidy(tt)
glance(tt)  # same output for all htests

tt <- t.test(mpg ~ am, data = mtcars)
tidy(tt)

wt <- wilcox.test(mpg ~ am, data = mtcars)
tidy(wt)

ct <- cor.test(mtcars$wt, mtcars$mpg)
tidy(ct)

}
