\name{Heatmap}
\alias{Heatmap}
\title{
Constructor method for Heatmap class
}
\description{
Constructor method for Heatmap class
}
\usage{
Heatmap(matrix, col, name,
    na_col = "grey",
    color_space = "LAB",
    rect_gp = gpar(col = NA),
    border = NA,
    border_gp = gpar(col = "black"),
    cell_fun = NULL,
    layer_fun = NULL,
    jitter = FALSE,
    
    row_title = character(0),
    row_title_side = c("left", "right"),
    row_title_gp = gpar(fontsize = 13.2),
    row_title_rot = switch(row_title_side[1], "left" = 90, "right" = 270),
    column_title = character(0),
    column_title_side = c("top", "bottom"),
    column_title_gp = gpar(fontsize = 13.2),
    column_title_rot = 0,
    
    cluster_rows = TRUE,
    cluster_row_slices = TRUE,
    clustering_distance_rows = "euclidean",
    clustering_method_rows = "complete",
    row_dend_side = c("left", "right"),
    row_dend_width = unit(10, "mm"),
    show_row_dend = TRUE,
    row_dend_reorder = is.logical(cluster_rows) || is.function(cluster_rows),
    row_dend_gp = gpar(),
    cluster_columns = TRUE,
    cluster_column_slices = TRUE,
    clustering_distance_columns = "euclidean",
    clustering_method_columns = "complete",
    column_dend_side = c("top", "bottom"),
    column_dend_height = unit(10, "mm"),
    show_column_dend = TRUE,
    column_dend_gp = gpar(),
    column_dend_reorder = is.logical(cluster_columns) || is.function(cluster_columns),
    
    row_order = NULL,
    column_order = NULL,
    
    row_labels = rownames(matrix),
    row_names_side = c("right", "left"),
    show_row_names = TRUE,
    row_names_max_width = unit(6, "cm"),
    row_names_gp = gpar(fontsize = 12),
    row_names_rot = 0,
    row_names_centered = FALSE,
    column_labels = colnames(matrix),
    column_names_side = c("bottom", "top"),
    show_column_names = TRUE,
    column_names_max_height = unit(6, "cm"),
    column_names_gp = gpar(fontsize = 12),
    column_names_rot = 90,
    column_names_centered = FALSE,
    
    top_annotation = NULL,
    bottom_annotation = NULL,
    left_annotation = NULL,
    right_annotation = NULL,
    
    km = 1,
    split = NULL,
    row_km = km,
    row_km_repeats = 1,
    row_split = split,
    column_km = 1,
    column_km_repeats = 1,
    column_split = NULL,
    gap = unit(1, "mm"),
    row_gap = unit(1, "mm"),
    column_gap = unit(1, "mm"),
    show_parent_dend_line = ht_opt$show_parent_dend_line,
    
    heatmap_width = unit(1, "npc"),
    width = NULL,
    heatmap_height = unit(1, "npc"),
    height = NULL,
    
    show_heatmap_legend = TRUE,
    heatmap_legend_param = list(title = name),
    
    use_raster = NULL,
    raster_device = c("png", "jpeg", "tiff", "CairoPNG", "CairoJPEG", "CairoTIFF", "agg_png"),
    raster_quality = 1,
    raster_device_param = list(),
    raster_resize_mat = FALSE,
    raster_by_magick = requireNamespace("magick", quietly = TRUE),
    raster_magick_filter = NULL,
    
    post_fun = NULL)
}
\arguments{

  \item{matrix}{A matrix. Either numeric or character. If it is a simple vector, it will be converted to a one-column matrix.}
  \item{col}{A vector of colors if the color mapping is discrete or a color mapping  function if the matrix is continuous numbers (should be generated by \code{\link[circlize]{colorRamp2}}). If the matrix is continuous, the value can also be a vector of colors so that colors can be interpolated. Pass to \code{\link{ColorMapping}}. For more details and examples, please refer to \url{https://jokergoo.github.io/ComplexHeatmap-reference/book/a-single-heatmap.html#colors} .}
  \item{name}{Name of the heatmap. By default the heatmap name is used as the title of the heatmap legend.}
  \item{na_col}{Color for \code{NA} values.}
  \item{rect_gp}{Graphic parameters for drawing rectangles (for heatmap body). The value should be specified by \code{\link[grid]{gpar}} and \code{fill} parameter is ignored.}
  \item{color_space}{The color space in which colors are interpolated. Only used if \code{matrix} is numeric and  \code{col} is a vector of colors. Pass to \code{\link[circlize]{colorRamp2}}.}
  \item{border}{Whether draw border. The value can be logical or a string of color.}
  \item{border_gp}{Graphic parameters for the borders. If you want to set different parameters for different heatmap slices, please consider to use \code{\link{decorate_heatmap_body}}.}
  \item{cell_fun}{Self-defined function to add graphics on each cell. Seven parameters will be passed into  this function: \code{j}, \code{i}, \code{x}, \code{y}, \code{width}, \code{height}, \code{fill} which are column index, row index in \code{matrix}, coordinate of the cell, the width and height of the cell and the filled color. \code{x}, \code{y}, \code{width} and \code{height} are all \code{\link[grid]{unit}} objects.}
  \item{layer_fun}{Similar as \code{cell_fun}, but is vectorized. Check \url{https://jokergoo.github.io/ComplexHeatmap-reference/book/a-single-heatmap.html#customize-the-heatmap-body} .}
  \item{jitter}{Random shifts added to the matrix. The value can be logical or a single numeric value. It it is \code{TRUE}, random  values from uniform distribution between 0 and 1e-10 are generated. If it is a numeric value, the range for the uniform distribution is (0, \code{jitter}). It is mainly to solve the problem of "Error: node stack overflow" when there are too many identical rows/columns for plotting the dendrograms. ADD: From version 2.5.6, the error of node stack overflow has been fixed, now this argument is ignored.}
  \item{row_title}{Title on the row.}
  \item{row_title_side}{Will the title be put on the left or right of the heatmap?}
  \item{row_title_gp}{Graphic parameters for row title.}
  \item{row_title_rot}{Rotation of row title.}
  \item{column_title}{Title on the column.}
  \item{column_title_side}{Will the title be put on the top or bottom of the heatmap?}
  \item{column_title_gp}{Graphic parameters for column title.}
  \item{column_title_rot}{Rotation of column titles.}
  \item{cluster_rows}{If the value is a logical, it controls whether to make cluster on rows. The value can also be a \code{\link[stats]{hclust}} or a \code{\link[stats]{dendrogram}} which already contains clustering. Check \url{https://jokergoo.github.io/ComplexHeatmap-reference/book/a-single-heatmap.html#clustering} .}
  \item{cluster_row_slices}{If rows are split into slices, whether perform clustering on the slice means?}
  \item{clustering_distance_rows}{It can be a pre-defined character which is in  ("euclidean", "maximum", "manhattan", "canberra", "binary",  "minkowski", "pearson", "spearman", "kendall"). It can also be a function. If the function has one argument, the input argument should be a matrix and  the returned value should be a \code{\link[stats]{dist}} object. If the function has two arguments, the input arguments are two vectors and the function calculates distance between these two vectors.}
  \item{clustering_method_rows}{Method to perform hierarchical clustering, pass to \code{\link[stats]{hclust}}.}
  \item{row_dend_side}{Should the row dendrogram be put on the left or right of the heatmap?}
  \item{row_dend_width}{Width of the row dendrogram, should be a \code{\link[grid]{unit}} object.}
  \item{show_row_dend}{Whether show row dendrogram?}
  \item{row_dend_gp}{Graphic parameters for the dendrogram segments. If users already provide a \code{\link[stats]{dendrogram}} object with edges rendered, this argument will be ignored.}
  \item{row_dend_reorder}{Apply reordering on row dendrograms. The value can be a logical value or a vector which contains weight  which is used to reorder rows. The reordering is applied by \code{\link[stats]{reorder.dendrogram}}.}
  \item{cluster_columns}{Whether make cluster on columns? Same settings as \code{cluster_rows}.}
  \item{cluster_column_slices}{If columns are split into slices, whether perform clustering on the slice means?}
  \item{clustering_distance_columns}{Same setting as \code{clustering_distance_rows}.}
  \item{clustering_method_columns}{Method to perform hierarchical clustering, pass to \code{\link[stats]{hclust}}.}
  \item{column_dend_side}{Should the column dendrogram be put on the top or bottom of the heatmap?}
  \item{column_dend_height}{height of the column cluster, should be a \code{\link[grid]{unit}} object.}
  \item{show_column_dend}{Whether show column dendrogram?}
  \item{column_dend_gp}{Graphic parameters for dendrogram segments. Same settings as \code{row_dend_gp}.}
  \item{column_dend_reorder}{Apply reordering on column dendrograms. Same settings as \code{row_dend_reorder}.}
  \item{row_order}{Order of rows. Manually setting row order turns off clustering.}
  \item{column_order}{Order of column.}
  \item{row_labels}{Optional row labels which are put as row names in the heatmap.}
  \item{row_names_side}{Should the row names be put on the left or right of the heatmap?}
  \item{show_row_names}{Whether show row names.}
  \item{row_names_max_width}{Maximum width of row names viewport.}
  \item{row_names_gp}{Graphic parameters for row names.}
  \item{row_names_rot}{Rotation of row names.}
  \item{row_names_centered}{Should row names put centered?}
  \item{column_labels}{Optional column labels which are put as column names in the heatmap.}
  \item{column_names_side}{Should the column names be put on the top or bottom of the heatmap?}
  \item{column_names_max_height}{Maximum height of column names viewport.}
  \item{show_column_names}{Whether show column names.}
  \item{column_names_gp}{Graphic parameters for drawing text.}
  \item{column_names_rot}{Rotation of column names.}
  \item{column_names_centered}{Should column names put centered?}
  \item{top_annotation}{A \code{\link{HeatmapAnnotation}} object.}
  \item{bottom_annotation}{A \code{\link{HeatmapAnnotation}} object.}
  \item{left_annotation}{It should be specified by \code{\link{rowAnnotation}}.}
  \item{right_annotation}{it should be specified by \code{\link{rowAnnotation}}.}
  \item{km}{Apply k-means clustering on rows. If the value is larger than 1, the heatmap will be split by rows according to the k-means clustering. For each row slice, hierarchical clustering is still applied with parameters above.}
  \item{split}{A vector or a data frame by which the rows are split. But if \code{cluster_rows} is a clustering object, \code{split} can be a single number indicating to split the dendrogram by \code{\link[stats]{cutree}}.}
  \item{row_km}{Same as \code{km}.}
  \item{row_km_repeats}{Number of k-means runs to get a consensus k-means clustering. Note if \code{row_km_repeats} is set to more than one, the final number of groups might be smaller than \code{row_km}, but this might means the original \code{row_km} is not a good choice.}
  \item{row_split}{Same as \code{split}.}
  \item{column_km}{K-means clustering on columns.}
  \item{column_km_repeats}{Number of k-means runs to get a consensus k-means clustering. Similar as \code{row_km_repeats}.}
  \item{column_split}{Split on columns. For heatmap splitting, please refer to \url{https://jokergoo.github.io/ComplexHeatmap-reference/book/a-single-heatmap.html#heatmap-split} .}
  \item{gap}{Gap between row slices if the heatmap is split by rows. The value should be a \code{\link[grid]{unit}} object.}
  \item{row_gap}{Same as \code{gap}.}
  \item{column_gap}{Gap between column slices.}
  \item{show_parent_dend_line}{When heatmap is split, whether to add a dashed line to mark parent dendrogram and children dendrograms?}
  \item{width}{Width of the heatmap body.}
  \item{height}{Height of the heatmap body.}
  \item{heatmap_width}{Width of the whole heatmap (including heatmap components)}
  \item{heatmap_height}{Height of the whole heatmap (including heatmap components). Check \url{https://jokergoo.github.io/ComplexHeatmap-reference/book/a-single-heatmap.html#size-of-the-heatmap} .}
  \item{show_heatmap_legend}{Whether show heatmap legend?}
  \item{heatmap_legend_param}{A list contains parameters for the heatmap legends. See \code{\link{color_mapping_legend,ColorMapping-method}} for all available parameters.}
  \item{use_raster}{Whether render the heatmap body as a raster image. It helps to reduce file size when the matrix is huge. If number of rows or columns is more than 2000, it is by default turned on. Note if \code{cell_fun} is set, \code{use_raster} is enforced to be \code{FALSE}.}
  \item{raster_device}{Graphic device which is used to generate the raster image.}
  \item{raster_quality}{A value larger than 1.}
  \item{raster_device_param}{A list of further parameters for the selected graphic device. For raster image support, please check \url{https://jokergoo.github.io/ComplexHeatmap-reference/book/a-single-heatmap.html#heatmap-as-raster-image} .}
  \item{raster_resize_mat}{Whether resize the matrix to let the dimension of the matrix the same as the dimension of the raster image? The value can be logical. If it is \code{TRUE}, \code{\link[base]{mean}} is used to summarize the sub matrix which corresponds to a single pixel. The value can also be a summary function, e.g. \code{\link[base:Extremes]{max}}.}
  \item{raster_by_magick}{Whether to use \code{\link[magick:transform]{image_resize}} to scale the image.}
  \item{raster_magick_filter}{Pass to \code{filter} argument of \code{\link[magick:transform]{image_resize}}. A character scalar and all possible values are in \code{\link[magick:options]{filter_types}}. The default is \code{"Lanczos"}.}
  \item{post_fun}{A function which will be executed after the heatmap list is drawn.}

}
\details{
The initialization function only applies parameter checking and fill values to the slots with some validation.

Following methods can be applied to the \code{\link{Heatmap-class}} object:

\itemize{
  \item \code{\link{show,Heatmap-method}}: draw a single heatmap with default parameters
  \item \code{\link{draw,Heatmap-method}}: draw a single heatmap.
  \item \code{+} or \code{\link[=pct_v_pct]{\%v\%}} append heatmaps and annotations to a list of heatmaps.
}

The constructor function pretends to be a high-level graphic function because the \code{show} method
of the \code{\link{Heatmap-class}} object actually plots the graphics.
}
\seealso{
\url{https://jokergoo.github.io/ComplexHeatmap-reference/book/a-single-heatmap.html}
}
\value{
A \code{\link{Heatmap-class}} object.
}
\author{
Zuguang Gu <z.gu@dkfz.de>
}
\examples{
# There is no example
NULL

}
