// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{Display, Visual, Window};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem::transmute};

glib::wrapper! {
    #[doc(alias = "GdkScreen")]
    pub struct Screen(Object<ffi::GdkScreen>);

    match fn {
        type_ => || ffi::gdk_screen_get_type(),
    }
}

impl Screen {
    #[doc(alias = "gdk_screen_get_display")]
    #[doc(alias = "get_display")]
    pub fn display(&self) -> Display {
        unsafe { from_glib_none(ffi::gdk_screen_get_display(self.to_glib_none().0)) }
    }

    #[doc(alias = "gdk_screen_get_resolution")]
    #[doc(alias = "get_resolution")]
    pub fn resolution(&self) -> f64 {
        unsafe { ffi::gdk_screen_get_resolution(self.to_glib_none().0) }
    }

    #[doc(alias = "gdk_screen_get_rgba_visual")]
    #[doc(alias = "get_rgba_visual")]
    pub fn rgba_visual(&self) -> Option<Visual> {
        unsafe { from_glib_none(ffi::gdk_screen_get_rgba_visual(self.to_glib_none().0)) }
    }

    #[doc(alias = "gdk_screen_get_root_window")]
    #[doc(alias = "get_root_window")]
    pub fn root_window(&self) -> Option<Window> {
        unsafe { from_glib_none(ffi::gdk_screen_get_root_window(self.to_glib_none().0)) }
    }

    #[doc(alias = "gdk_screen_get_system_visual")]
    #[doc(alias = "get_system_visual")]
    pub fn system_visual(&self) -> Option<Visual> {
        unsafe { from_glib_none(ffi::gdk_screen_get_system_visual(self.to_glib_none().0)) }
    }

    #[doc(alias = "gdk_screen_get_toplevel_windows")]
    #[doc(alias = "get_toplevel_windows")]
    pub fn toplevel_windows(&self) -> Vec<Window> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::gdk_screen_get_toplevel_windows(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gdk_screen_get_window_stack")]
    #[doc(alias = "get_window_stack")]
    pub fn window_stack(&self) -> Vec<Window> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::gdk_screen_get_window_stack(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gdk_screen_is_composited")]
    pub fn is_composited(&self) -> bool {
        unsafe { from_glib(ffi::gdk_screen_is_composited(self.to_glib_none().0)) }
    }

    #[doc(alias = "gdk_screen_list_visuals")]
    pub fn list_visuals(&self) -> Vec<Visual> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::gdk_screen_list_visuals(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gdk_screen_set_font_options")]
    pub fn set_font_options(&self, options: Option<&cairo::FontOptions>) {
        unsafe {
            ffi::gdk_screen_set_font_options(self.to_glib_none().0, options.to_glib_none().0);
        }
    }

    #[doc(alias = "gdk_screen_set_resolution")]
    pub fn set_resolution(&self, dpi: f64) {
        unsafe {
            ffi::gdk_screen_set_resolution(self.to_glib_none().0, dpi);
        }
    }

    #[doc(alias = "gdk_screen_get_default")]
    #[doc(alias = "get_default")]
    #[allow(clippy::should_implement_trait)]
    pub fn default() -> Option<Screen> {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::gdk_screen_get_default()) }
    }

    #[doc(alias = "composited-changed")]
    pub fn connect_composited_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn composited_changed_trampoline<F: Fn(&Screen) + 'static>(
            this: *mut ffi::GdkScreen,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"composited-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    composited_changed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "monitors-changed")]
    pub fn connect_monitors_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn monitors_changed_trampoline<F: Fn(&Screen) + 'static>(
            this: *mut ffi::GdkScreen,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"monitors-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    monitors_changed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "size-changed")]
    pub fn connect_size_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn size_changed_trampoline<F: Fn(&Screen) + 'static>(
            this: *mut ffi::GdkScreen,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"size-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    size_changed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "font-options")]
    pub fn connect_font_options_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_font_options_trampoline<F: Fn(&Screen) + 'static>(
            this: *mut ffi::GdkScreen,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::font-options\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_font_options_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "resolution")]
    pub fn connect_resolution_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_resolution_trampoline<F: Fn(&Screen) + 'static>(
            this: *mut ffi::GdkScreen,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::resolution\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_resolution_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for Screen {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Screen")
    }
}
