# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Awaitable, Optional, TYPE_CHECKING

from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.mgmt.core import AsyncARMPipelineClient
from msrest import Deserializer, Serializer

from .. import models
from ._configuration import AzureMachineLearningWorkspacesConfiguration
from .operations import DataCallOperations, DataContainerOperations, DataVersionOperations, DatasetControllerV2Operations, DatasetV2Operations, DatasetsV1Operations, DeleteOperations, GetOperationStatusOperations

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential

class AzureMachineLearningWorkspaces:
    """AzureMachineLearningWorkspaces.

    :ivar data_call: DataCallOperations operations
    :vartype data_call: azure.mgmt.machinelearningservices.aio.operations.DataCallOperations
    :ivar data_container: DataContainerOperations operations
    :vartype data_container:
     azure.mgmt.machinelearningservices.aio.operations.DataContainerOperations
    :ivar delete: DeleteOperations operations
    :vartype delete: azure.mgmt.machinelearningservices.aio.operations.DeleteOperations
    :ivar datasets_v1: DatasetsV1Operations operations
    :vartype datasets_v1: azure.mgmt.machinelearningservices.aio.operations.DatasetsV1Operations
    :ivar dataset_controller_v2: DatasetControllerV2Operations operations
    :vartype dataset_controller_v2:
     azure.mgmt.machinelearningservices.aio.operations.DatasetControllerV2Operations
    :ivar dataset_v2: DatasetV2Operations operations
    :vartype dataset_v2: azure.mgmt.machinelearningservices.aio.operations.DatasetV2Operations
    :ivar data_version: DataVersionOperations operations
    :vartype data_version: azure.mgmt.machinelearningservices.aio.operations.DataVersionOperations
    :ivar get_operation_status: GetOperationStatusOperations operations
    :vartype get_operation_status:
     azure.mgmt.machinelearningservices.aio.operations.GetOperationStatusOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param base_url: Service URL. Default value is ''.
    :type base_url: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        base_url: str = "",
        **kwargs: Any
    ) -> None:
        self._config = AzureMachineLearningWorkspacesConfiguration(credential=credential, **kwargs)
        self._client = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.data_call = DataCallOperations(self._client, self._config, self._serialize, self._deserialize)
        self.data_container = DataContainerOperations(self._client, self._config, self._serialize, self._deserialize)
        self.delete = DeleteOperations(self._client, self._config, self._serialize, self._deserialize)
        self.datasets_v1 = DatasetsV1Operations(self._client, self._config, self._serialize, self._deserialize)
        self.dataset_controller_v2 = DatasetControllerV2Operations(self._client, self._config, self._serialize, self._deserialize)
        self.dataset_v2 = DatasetV2Operations(self._client, self._config, self._serialize, self._deserialize)
        self.data_version = DataVersionOperations(self._client, self._config, self._serialize, self._deserialize)
        self.get_operation_status = GetOperationStatusOperations(self._client, self._config, self._serialize, self._deserialize)


    def _send_request(
        self,
        request: HttpRequest,
        **kwargs: Any
    ) -> Awaitable[AsyncHttpResponse]:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = await client._send_request(request)
        <AsyncHttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/python/protocol/quickstart

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.AsyncHttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "AzureMachineLearningWorkspaces":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details) -> None:
        await self._client.__aexit__(*exc_details)
