/*******************************************************************************
    PRODIGAL (PROkaryotic DynamIc Programming Genefinding ALgorithm)
    Copyright (C) 2007-2015 University of Tennessee / UT-Battelle

    Code Author:  Doug Hyatt

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*******************************************************************************/

#include "training.h"

/* Reads a training file to use for gene prediction */

int read_training_file(char *fn, struct _training *tinf) {
  size_t rv;
  FILE *fh;
  fh = fopen(fn, "rb");
  if(fh == NULL) return 1;
  rv = fread(tinf, sizeof(struct _training), 1, fh);
  fclose(fh);
  if(rv != 1) return -1;
  return 0;
}

/* Writes a training file to use for a later run of gene prediction */

int write_training_file(char *fn, struct _training *tinf) {
  size_t rv;
  FILE *fh;
  fh = fopen(fn, "wb");
  if(fh == NULL) return -1;
  rv = fwrite(tinf, sizeof(struct _training), 1, fh);
  fclose(fh);
  if(rv != 1) return -1;
  return 0;
}

/*******************************************************************************
  The following functions initialize training data for the model genomes that
  we chose as our "bins" for metagenomic data.  Rather than put this info in
  binary files, we decided to hard code it here so that it would be part of
  the executable (making the Prodigal binary much larger but self-contained).
*******************************************************************************/
void initialize_metagenome_0(struct _training *tptr) {
  struct _training tinf = {
    0.293, 4, 4.350, { 2.312, 0.463, 0.226 }, { 0.906, -2.406, -2.642 }, 1, 
    { -1.200, -2.605, -0.720, -0.067, -0.020, -4.000, -0.152, -4.000, 1.287, -0.759, 1.538, -4.000, 1.302, 0.336, 0.651, 2.000, 2.581, 1.735, 1.874, 2.402, 2.791, 3.350, 3.152, 3.330, 3.330, 2.791, 3.330, 3.212 }, 
    {{ 0.026, -1.141, -1.291, 0.442},{ 0.256, -0.700, -0.394, 0.051},{ 0.144, 0.224, -0.631, -0.068},{ 0.224, 0.003, -0.718, -0.040},{ 0.209, -0.100, -0.535, -0.022},{ 0.230, -0.434, -0.476, 0.044},{ 0.212, -0.271, -0.598, 0.047},{ 0.256, -0.225, -0.647, -0.010},{ 0.206, -0.566, -0.330, 0.065},{ 0.197, -0.236, -0.203, -0.056},{ 0.148, -0.421, -0.171, 0.047},{ 0.138, -0.150, -0.476, 0.065},{ 0.197, -0.282, -0.330, 0.001},{ 0.125, -0.434, -0.225, 0.092},{ 0.176, -0.394, -0.248, 0.033},{ 0.128, -0.271, -0.421, 0.099},{ 0.112, -0.306, -0.355, 0.109},{ 0.105, -0.225, -0.520, 0.132},{ 0.188, -0.318, -0.225, -0.010},{ 0.259, -0.192, -0.407, -0.088},{ 0.151, -0.236, -0.182, -0.007},{ 0.176, -0.120, -0.282, -0.044},{ 0.224, -0.150, -0.421, -0.052},{ 0.166, -0.259, -0.448, 0.061},{ 0.065, -0.236, -0.434, 0.154},{ 0.058, -0.248, -0.259, 0.119},{ 0.148, -0.294, -0.236, 0.033},{ 0.141, -0.182, -0.225, 0.001},{ 0.115, -0.182, -0.343, 0.065},{ 0.151, -0.282, -0.434, 0.082},{ 0.157, -0.248, -0.140, -0.025},{ 0.176, -0.090, -0.282, -0.056} }, 
    {{{ 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000},
   { 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000},
   { 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000},
   { 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000}
   },{{ 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000},
   { 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000},
   { 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000},
   { 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000}
   },{{ 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000},
   { 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000},
   { 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000},
   { 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000}
   },{{ 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000},
   { 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000},
   { 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000},
   { 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000}} }, 
    0.000, { 0.618, 1.158, 0.185, -5.000, 0.157, 0.870, -1.148, -0.716, 0.182, 0.589, 0.233, 0.330, 0.088, 0.455, 0.053, 0.376, 0.289, 0.515, -0.844, -5.000, -1.109, -0.054, -1.894, -1.520, -1.179, -0.342, -1.363, 0.109, 0.035, -0.592, -1.586, -0.565, 0.467, 1.172, 0.052, 0.504, 0.133, 1.055, -0.190, -1.320, 0.152, 0.393, 0.052, -0.848, -0.160, 0.004, -0.550, -0.432, 0.682, 1.233, 0.022, 0.435, 0.320, 1.200, 0.838, -1.039, 0.681, 1.077, 0.962, 0.396, 0.591, 1.077, 0.657, 0.363, 1.141, 1.399, 0.784, -5.000, 1.026, 0.873, -0.604, 0.465, 0.684, 0.866, 0.978, 0.676, 0.775, 1.001, 0.573, 1.124, 0.856, 0.919, -0.619, -5.000, 0.075, 0.923, -0.524, -0.690, -0.866, 0.099, 0.038, 0.226, 0.521, -0.028, -1.312, 0.266, 1.168, 1.448, 0.542, 1.201, 1.096, 1.480, 0.852, 0.428, 1.107, 1.184, 1.048, 0.690, 0.937, 1.057, 0.402, 0.503, 1.028, 1.452, 0.838, 0.920, 0.999, 1.469, 1.373, -0.076, 1.130, 1.461, 1.340, 1.038, 1.120, 1.325, 0.315, 0.682, 0.285, 0.972, -0.065, -5.000, 0.240, 0.844, -2.146, -0.807, 0.112, 0.730, 0.694, 0.633, -0.246, 0.388, -0.435, 0.141, 0.244, 0.776, -0.762, -5.000, -0.812, 0.349, -1.789, -1.222, -0.378, 0.166, 0.415, 0.691, 0.123, 0.297, -1.142, -0.234, 0.166, 0.709, -0.932, -0.137, -0.280, 0.910, -1.093, -2.073, -0.029, 0.191, -0.332, -0.724, -0.563, -0.690, -0.740, -0.260, 0.301, 1.055, -1.017, -0.113, 0.163, 0.964, 0.392, -1.433, 0.452, 0.694, 0.241, 0.137, 0.167, 0.566, -0.700, -0.666, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, 0.174, 1.037, 0.180, -5.000, 0.089, 0.619, -1.578, -1.186, 0.080, 0.482, 0.541, -0.197, 0.597, 0.640, 0.187, 0.569, 0.120, 0.501, -0.475, -5.000, -1.564, -0.643, -2.016, -1.189, -1.258, -0.259, 0.040, -0.572, 0.281, -0.516, -1.490, -0.518, 0.515, 1.291, 0.548, 0.114, 0.122, 1.205, -0.285, -0.866, -0.100, -0.181, -1.106, -1.793, -0.490, -0.146, -1.396, -0.823, 0.550, 1.179, -0.100, 0.394, 0.214, 1.209, 0.719, -0.608, 0.649, 1.117, 0.973, 0.640, 0.037, 0.700, 0.135, 0.029, 0.710, 1.237, 0.709, -5.000, 0.929, 0.628, -0.885, 0.008, 0.876, 1.199, 1.061, 0.442, 0.545, 0.663, 0.571, 0.891, 0.718, 1.162, 0.124, -5.000, 0.745, 0.917, -0.917, -0.801, 0.442, 0.713, 0.757, -0.027, 0.881, 0.052, -0.279, 0.087, 1.107, 1.314, 1.282, 1.117, 0.855, 1.531, -0.447, -0.992, 1.093, 0.947, 0.980, 0.218, 0.708, 1.036, -0.125, 0.151, 0.794, 1.299, 0.793, 0.650, 0.707, 1.457, 1.188, -0.062, 1.146, 1.167, 0.855, 0.961, 0.788, 1.016, 0.453, 0.417, -1.026, -0.406, -1.700, -5.000, -1.028, -2.076, -1.858, -2.551, -1.782, -0.342, -0.885, -1.195, -0.536, -0.319, -1.700, -1.255, -1.561, 0.121, -0.978, -5.000, -1.445, -0.505, -5.000, -2.327, -5.000, -0.629, -0.342, 0.213, -0.307, -1.235, -1.071, -2.508, -0.666, -0.378, -5.000, -2.501, -2.124, -0.342, -1.035, -2.989, -0.938, -0.683, -0.447, -0.874, -1.076, -1.440, -5.000, -1.160, -1.517, -0.016, -1.316, -0.833, -0.958, 0.246, -0.709, -1.690, -1.951, 0.707, 0.010, -0.978, -1.769, -1.016, -1.782, -1.664, -0.464, 0.213, -0.698, -5.000, -0.804, -0.285, -2.066, -2.392, -0.338, 0.059, 0.211, -0.151, -1.170, -0.545, -0.592, -0.821, -0.536, 0.563, -0.767, -5.000, -2.498, -0.670, -1.626, -2.775, -2.105, -1.007, -0.798, -1.195, -0.144, -0.077, -1.659, -0.516, -0.427, 0.841, -0.784, -0.485, -1.557, 0.111, -0.899, -2.562, -1.244, -0.819, -1.906, -2.537, -1.303, -0.999, -1.207, -1.362, -1.189, -0.207, -1.304, -1.222, -1.301, -0.022, -0.882, -2.903, -0.598, -0.329, -0.439, -1.013, -0.688, -0.336, -1.282, -1.272, 0.375, 0.938, 0.242, -5.000, 0.445, 1.012, -1.512, -0.392, 0.332, 0.528, 0.445, 0.082, 0.056, 0.558, 0.249, 0.126, 0.134, 0.215, -0.702, -5.000, -1.817, 0.246, -1.016, -1.149, -0.153, 0.384, -0.186, 0.207, -0.048, -0.184, -1.385, -0.793, 0.548, 1.174, 0.442, 0.811, 0.199, 1.075, -1.562, -0.917, -0.166, 0.195, 0.230, -1.550, -0.144, 0.158, -0.709, -0.181, 0.501, 0.977, 0.025, 0.456, 0.230, 1.341, 0.818, -1.170, 0.246, 0.845, 0.841, 0.390, 0.397, 0.808, 0.460, 0.387, 0.643, 1.025, 0.353, -5.000, 0.774, 0.867, 0.534, -0.232, 0.526, 0.681, 0.469, -0.036, 0.488, 0.664, 0.179, 0.434, 0.261, 0.964, -0.797, -5.000, 0.064, 0.655, -1.062, -0.271, -0.447, 0.626, -0.587, 0.102, 0.409, 0.117, -0.775, -0.338, 0.619, 1.203, 0.452, 0.044, 0.801, 1.391, -0.054, -0.262, 0.136, 0.453, -0.224, -1.685, 0.173, 0.374, -0.830, -0.265, 0.871, 1.233, 0.717, 0.914, 0.690, 1.446, 0.480, -0.181, 0.707, 1.158, 0.561, 0.628, 0.658, 0.843, 0.310, 0.432, 0.475, 0.638, 0.274, -5.000, 0.754, 1.071, -1.205, -0.590, 0.432, 0.292, -0.136, -0.180, 0.092, 0.381, -0.002, 0.194, 0.383, 0.501, -0.082, -5.000, 0.010, 0.741, -0.173, -1.565, -0.208, 0.002, -0.274, -0.129, 0.696, 0.419, -0.605, 0.082, 1.101, 1.153, 0.366, 0.970, 0.455, 1.162, -1.235, -0.597, 0.542, 0.415, 0.447, 0.010, 0.442, 0.326, 0.402, 0.425, 0.875, 1.293, 0.116, 0.471, 0.477, 0.976, 1.048, -0.215, 0.757, 0.894, 0.234, 0.064, 0.770, 0.708, 0.558, -0.028, 0.372, 0.921, 0.167, -5.000, 0.126, 0.577, -1.459, -0.578, 0.287, 0.427, 0.108, -0.009, -0.122, 0.207, 0.230, 0.064, 0.353, 0.681, 0.001, -5.000, -1.505, 0.019, -1.656, -1.222, -0.437, -0.271, 0.040, -0.249, 0.439, 0.048, -0.331, -0.381, 0.505, 0.838, 0.606, 0.425, 0.261, 0.865, -0.496, -1.554, -0.042, 0.124, -0.542, -1.413, 0.025, 0.407, -0.603, -0.168, 0.205, 1.033, -0.122, 0.369, 0.159, 0.970, 0.887, -1.261, -0.043, 0.611, 0.106, -0.459, 0.293, 0.546, 0.412, -0.365, 0.210, 0.906, 0.006, -5.000, 0.254, 0.679, -0.900, -0.894, 0.048, 0.423, 0.352, 0.050, -0.099, 0.129, -0.350, -0.119, -0.312, 0.366, -0.876, -5.000, -1.101, 0.432, -1.076, -1.352, -0.580, -0.493, -0.814, -0.428, -0.420, -0.957, -1.194, -0.903, 0.100, 0.832, -0.014, 0.177, -0.295, 0.580, -0.637, -1.554, -0.883, -0.226, -1.020, -1.184, -0.972, -0.883, -1.020, -0.709, 0.134, 0.824, -0.687, -0.011, -0.187, 0.814, 0.374, -1.416, 0.082, 0.578, 0.318, 0.103, -0.102, 0.661, -0.085, -0.114, 0.420, 1.199, 0.246, -5.000, 0.578, 0.532, -1.235, -0.207, 0.617, 0.635, 0.578, 0.289, 0.088, 0.490, -0.369, 0.468, -0.109, -0.137, -1.000, -5.000, 0.064, 0.351, -1.062, -1.428, -1.477, -0.458, -1.258, 0.332, -0.108, -0.332, -1.381, -0.467, 0.396, 0.727, 0.064, -0.447, 0.479, 1.045, 0.543, -0.997, -0.409, 0.420, -0.042, -0.403, -0.575, -0.146, -1.265, -0.562, 0.591, 1.205, 0.266, 0.526, 0.254, 0.975, 0.966, -1.217, 0.612, 0.812, 0.432, 0.243, 0.327, 0.847, -0.258, 0.116, 0.288, 0.644, -0.462, -5.000, 0.512, 1.018, -0.709, -0.217, 0.360, 0.618, 0.403, 0.300, 0.024, 0.019, -0.215, 0.131, 0.136, 0.645, -0.833, -5.000, -0.572, 0.675, -5.000, -1.073, 0.079, 0.317, 0.071, -0.301, 0.012, -0.001, -1.241, -0.388, -0.155, 0.503, -2.073, -0.555, -0.781, 0.600, -1.007, -1.599, -0.265, 0.079, 0.013, -0.294, -0.581, -0.646, -0.998, -0.751, -0.139, 0.639, -0.806, -0.426, -0.463, 0.725, -0.249, -1.121, -0.234, -0.090, -0.801, -0.764, -0.202, -0.266, -1.333, -0.945, 0.506, 1.085, 0.157, -5.000, 0.675, 0.841, -0.978, -0.413, 0.466, 0.552, 0.421, 0.384, 0.037, 0.500, -0.255, 0.210, 0.125, 0.781, -0.137, -5.000, -0.488, -0.509, -1.312, -1.084, -0.482, -0.203, 0.095, 0.278, -0.361, 0.058, -1.244, -0.362, 0.437, 1.063, -0.138, 0.294, 0.129, 0.824, -0.680, -1.132, 0.153, 0.709, -0.584, -0.676, 0.067, 0.224, -0.901, -0.073, 0.294, 0.923, -0.434, 0.082, 0.004, 0.856, 0.404, -1.039, -0.000, 0.566, -0.044, -0.517, 0.391, 0.507, 0.008, -0.120, 0.078, 0.818, -0.087, -5.000, -0.088, 0.783, -1.358, -1.150, -0.109, 0.301, 0.002, -0.037, -0.428, 0.133, -0.718, -0.140, -0.290, -0.137, -1.775, -5.000, -1.320, -0.759, -1.906, -2.314, -2.091, -1.213, -1.301, -0.173, -0.503, -0.772, -2.605, -1.013, 0.312, 0.885, -0.483, 0.126, 0.207, 1.050, 0.042, -1.220, -0.596, 0.376, -0.364, -1.276, -0.289, -0.505, -0.420, -0.327, 0.577, 1.142, -0.386, 0.260, 0.222, 1.243, 1.035, -1.012, 0.733, 1.165, 0.854, 0.393, 0.526, 1.089, 0.530, 0.155, 0.810, 1.237, 0.530, -5.000, 0.503, 0.324, -0.422, -0.008, 0.469, 0.538, 0.580, 0.269, 0.251, -0.035, -0.035, 0.621, -0.019, 0.329, -1.213, -5.000, -0.304, 0.616, -0.181, -1.795, -0.396, -0.978, 0.207, 0.064, -0.006, -0.129, -1.995, -0.180, 0.677, 1.129, -1.062, 0.344, 1.186, 1.443, 0.603, -0.542, 0.710, 0.917, 0.197, 0.685, 0.293, 0.469, 0.652, 0.603, 0.760, 1.265, 0.209, 0.598, 0.541, 1.303, 0.499, -0.843, 0.777, 1.196, 0.849, 0.662, 0.774, 1.099, 0.007, 0.255, -0.268, 0.332, -1.803, -5.000, 0.022, 0.619, -5.000, -1.652, -0.318, 0.500, 0.321, -0.090, -0.819, -0.702, -0.542, -0.279, -0.606, 0.035, -1.636, -5.000, -1.363, -0.447, -2.170, -3.438, -0.360, -0.747, -0.224, -0.090, -0.839, -1.241, -1.894, -0.988, -0.600, 0.217, -2.639, -1.987, -0.210, 0.102, -2.036, -2.161, -1.289, -2.170, -1.728, -0.885, -0.958, -5.000, -1.147, -1.687, -0.436, 0.342, -1.741, -1.228, -0.491, 0.299, -0.784, -1.218, -0.467, -0.245, -0.784, -0.351, -0.550, -0.463, -1.283, -1.481, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -5.000, -0.958, 0.426, -1.084, -5.000, -1.053, -0.489, -2.655, -2.591, -1.342, -0.307, -0.673, -1.464, -0.604, -0.510, -0.906, -0.518, -0.896, -1.440, -1.205, -5.000, -1.140, -0.181, -1.189, -1.846, -0.587, -1.363, -5.000, -1.089, -1.108, -0.938, -1.343, -1.368, -0.995, -0.016, -0.480, -0.912, -0.752, 0.358, -0.784, -1.755, -2.046, -1.546, -1.882, -2.610, -2.429, -1.068, -2.041, -2.472, -0.915, 0.313, -1.184, -0.327, -1.031, 0.246, 0.246, -2.076, -0.559, 0.021, -0.519, -0.372, -0.703, -0.078, -0.554, -1.194, 0.269, 0.900, 0.445, -5.000, 0.930, 0.213, 0.469, -0.725, 0.495, 0.469, 0.547, 0.292, -0.059, 0.453, 0.469, 0.341, -0.535, 0.218, -1.578, -5.000, -0.555, -0.050, -5.000, -0.342, -1.189, 0.814, 0.826, -0.042, 0.536, -0.285, -1.323, -1.120, 0.442, 0.862, 0.121, -0.042, 0.302, 1.288, -0.159, -0.917, -0.670, 0.329, -0.137, -1.323, -0.422, 0.010, -0.090, -0.839, 0.140, 0.933, 0.593, -0.159, 0.013, 1.179, 0.703, -0.686, 0.458, 0.549, 0.683, 0.146, 0.428, 0.801, -0.181, 0.143, -1.340, -0.997, -1.128, -5.000, -2.272, -1.235, -5.000, -1.906, -5.000, -0.735, -1.728, -2.407, -1.363, -0.629, -0.369, -5.000, -1.653, -0.542, -0.874, -5.000, -1.262, -5.000, -5.000, -2.414, -5.000, -5.000, -0.629, -5.000, 0.159, -5.000, -5.000, -0.935, -1.589, 0.826, -1.782, -1.951, -0.285, 0.297, -0.978, -5.000, -5.000, -1.323, -5.000, -5.000, -5.000, -0.784, -1.403, -2.526, -1.403, -1.929, -5.000, -2.066, -0.047, -0.853, -5.000, -5.000, -5.000, -0.629, -5.000, -5.000, -1.995, -0.657, -5.000, -1.700, -1.481, -0.423, -1.981, -5.000, -2.418, -0.853, -2.475, -2.205, -0.572, 0.019, -0.542, -1.012, -1.487, -0.393, -0.969, -1.746, -1.406, -0.261, -1.089, -5.000, -3.472, -5.000, -1.323, -2.701, -2.288, -5.000, -1.728, -5.000, -0.788, -1.280, -2.205, -1.155, -1.836, 0.297, -1.355, -1.773, -2.225, -0.601, -1.403, -2.387, -2.250, -2.666, -2.449, -3.574, -2.092, -2.421, -2.161, -1.736, -1.330, -0.195, -4.063, -1.871, -1.219, -2.036, -1.323, -3.276, -1.508, -0.984, -0.599, -2.219, -1.486, -1.003, -2.426, -1.854, -0.752, 0.451, -0.900, -5.000, -0.334, 0.469, -1.403, -1.311, -0.430, -0.236, 0.287, -0.189, -0.489, 0.332, -1.062, -0.612, -1.095, -2.133, -0.784, -5.000, -0.917, -0.917, -5.000, -1.755, -1.995, -5.000, 0.064, -0.709, -0.470, -0.505, -2.575, -1.969, -1.179, 0.788, -0.560, -1.071, -0.165, 0.603, -5.000, -0.501, -1.568, -0.728, 0.010, -5.000, -2.205, -5.000, -1.235, -1.923, -0.229, 0.264, -0.354, -0.224, -0.323, 0.023, 0.064, -1.323, -0.192, 0.246, 0.113, -0.593, -0.853, -0.396, -0.804, -0.304, -0.153, 0.570, -0.010, -5.000, 0.220, 0.643, 0.151, -1.412, 0.167, 0.707, -0.304, -0.206, -0.090, 0.144, -0.281, -0.173, -0.465, 0.389, -1.570, -5.000, -0.005, 0.197, -5.000, -1.235, -0.601, -5.000, -0.285, -0.629, -1.135, -1.951, -1.343, -1.786, -0.629, 0.315, -0.016, -1.403, -0.447, 1.162, -5.000, -0.747, -0.978, 0.315, -5.000, -5.000, -0.396, -1.403, -5.000, -0.629, -0.007, 1.126, 0.339, -0.144, 0.336, 1.337, -0.285, -1.157, -0.042, 1.199, 0.315, 0.469, 0.812, 0.814, -0.321, 0.072, -0.503, 0.597, -1.440, -5.000, -0.016, -0.629, 0.351, -0.270, -0.390, -0.690, -0.070, -0.527, 0.490, -0.396, -0.364, -0.308, -0.551, -0.169, -2.096, -5.000, -0.054, 0.603, -1.546, -5.000, -5.000, -1.062, -1.546, -0.447, -0.224, -0.070, -2.170, -0.402, 0.182, 1.488, 0.064, -0.657, 0.005, 0.875, 0.197, -1.755, 0.568, -0.224, 0.556, -0.917, -0.557, -0.137, -1.280, 0.064, 0.156, 0.995, 0.040, 0.371, 0.043, -5.000, 0.315, -2.115, 0.442, 0.924, 0.757, 0.623, 0.216, 0.090, 0.040, -0.715, 0.174, 0.939, -0.657, -5.000, 0.723, 0.015, -1.035, -1.053, -0.526, -0.512, 0.164, -0.317, -0.720, 0.332, -0.629, -0.103, 0.131, 0.632, -0.557, -5.000, -0.853, -0.181, -5.000, -2.303, -0.542, -1.235, 0.814, -0.249, 0.246, 0.308, -1.235, -0.153, 0.329, 0.644, 0.632, 0.374, -0.042, 0.367, -1.235, -5.000, -0.917, 0.246, -0.224, -0.192, 0.172, 0.662, -0.709, -0.016, -0.093, 0.929, -0.759, -0.525, 0.573, 0.677, 0.543, -1.512, 0.005, 0.269, 0.389, -0.805, 0.020, 0.495, 0.064, -0.538, 0.024, 0.903, -0.088, -5.000, 0.612, 1.094, -0.472, -0.600, 0.288, 0.714, 0.436, 0.225, -0.420, 0.068, -0.870, -0.255, -0.467, -0.266, -1.230, -5.000, -0.809, 0.628, -5.000, -2.166, -1.213, -0.722, -0.090, -0.542, -0.653, -0.803, -2.740, -1.308, -0.451, 0.167, -0.784, -0.832, -0.987, 0.351, -1.858, -1.666, -1.343, -0.101, -5.000, -1.448, -2.337, -1.980, -1.793, -1.004, 0.239, 0.750, -0.838, 0.012, -0.043, 1.131, 0.493, -0.884, -0.202, 0.897, 0.539, -0.215, 0.108, 0.763, -0.009, -0.012, 0.029, 0.687, -0.444, -5.000, 0.333, 0.545, -5.000, -0.492, -0.004, 0.419, -0.020, -0.001, -0.396, -0.192, -1.178, -0.340, -0.563, -0.459, -1.652, -5.000, -1.363, 0.164, -5.000, -2.769, -1.714, -0.512, -1.089, -0.396, -0.702, -1.023, -1.627, -1.273, -0.692, 0.420, -1.323, -2.421, -0.090, 0.900, -5.000, -2.188, -1.782, 0.447, 0.121, -2.152, -1.089, -0.901, -1.350, -0.726, 0.160, 0.890, -0.616, 0.136, -0.135, 0.893, -0.378, -0.621, 0.317, 0.757, 0.562, 0.266, -0.033, 0.492, -0.612, -0.140, -0.772, -0.581, -1.357, -5.000, -0.789, 0.594, -1.251, -1.767, -0.755, -0.393, -0.501, -0.268, -1.113, -1.076, -1.241, -0.925, -1.473, -1.653, -2.616, -5.000, -0.847, -0.519, -2.096, -2.944, -1.512, -0.409, -0.364, -0.189, -1.177, -1.560, -2.735, -1.678, -1.012, -0.694, -2.122, -1.486, -1.121, -1.403, -2.263, -1.444, -1.929, -0.747, -0.885, -2.179, -1.718, -1.618, -1.569, -2.677, -1.108, -0.488, -1.984, -1.483, -0.651, 0.010, -5.000, -1.618, -1.368, -0.917, -1.610, -1.217, -0.985, -0.996, -1.340, -1.825, -0.341, 0.301, -1.025, -5.000, -0.123, 0.397, -1.755, -1.314, -0.390, 0.212, -0.323, -0.174, -0.752, -0.409, -1.169, -0.711, -0.958, -0.112, -1.248, -5.000, -1.329, -0.378, -2.539, -2.124, -1.150, -0.968, -0.434, 0.035, -1.076, -0.391, -2.334, -1.262, -0.256, 0.652, -1.076, -0.331, -0.703, 0.221, -1.578, -1.866, -1.116, -0.066, -1.570, -2.008, -0.848, -0.430, -1.189, -0.859, -0.530, 0.404, -1.697, -0.676, -0.834, 0.122, -0.813, -2.155, -0.978, -0.416, -0.741, -1.282, -0.445, -0.506, -1.018, -0.897, 0.456, 1.040, 0.254, -5.000, 0.008, 1.009, -1.248, -0.717, 0.460, 0.554, 0.517, 0.506, 0.099, 0.264, -0.211, 0.438, -0.075, 0.516, -1.371, -5.000, -1.380, -0.296, -0.866, -2.041, -1.165, -0.825, -0.146, 0.283, -0.020, -1.060, -1.095, -0.825, 0.120, 0.720, -0.582, 0.212, -0.387, 0.539, -1.488, -1.350, -0.524, -0.204, -0.554, -1.594, -0.725, -0.421, -1.220, -1.018, 0.289, 1.100, -0.156, 0.276, -0.086, 0.924, -0.077, -1.838, 0.678, 0.943, 0.830, 0.078, 0.285, 0.712, 0.152, 0.202, 1.162, 1.462, 0.746, -5.000, 1.203, 1.151, 0.151, 0.386, 0.855, 0.911, 1.105, 0.778, 0.617, 0.563, 0.266, 1.013, 1.154, 1.143, -0.365, -5.000, 0.432, 1.162, -5.000, -1.140, 0.632, 0.226, -0.090, 0.757, 0.797, -0.314, -1.412, -0.022, 1.154, 1.205, 0.110, 0.116, 0.977, 1.358, -0.016, -0.676, 0.203, 0.469, 1.309, 0.263, 0.436, 0.692, 0.287, 0.113, 1.051, 1.350, 0.559, 1.028, 1.091, 1.529, 1.162, -0.056, 1.059, 1.342, 1.400, 1.026, 1.174, 1.327, 0.374, 0.789, -0.090, 0.769, -0.525, -5.000, -0.003, 0.481, -0.896, -0.982, 0.159, 0.309, 0.278, 0.462, -0.672, 0.073, -0.615, -0.040, -0.288, 0.262, -1.273, -5.000, -1.453, 0.362, -2.016, -2.338, -0.388, 0.226, 0.917, 0.017, -0.333, -0.067, -1.934, -0.463, 0.142, 0.767, -1.359, -1.025, -0.943, 0.526, -1.546, -1.898, -0.608, -0.176, -0.755, -0.978, -0.994, -0.784, -1.074, -0.790, -0.130, 0.575, -1.576, -0.335, -0.442, 0.917, 0.370, -1.154, 0.039, 0.662, 0.266, 0.064, 0.042, 0.454, -0.516, -0.803, 0.440, 1.012, 0.075, -5.000, 0.193, 0.842, -0.555, -0.879, 0.521, 0.579, 0.488, 0.240, -0.129, 0.051, -0.165, -0.044, 0.295, 0.683, -0.064, -5.000, -0.569, -0.224, -1.089, -1.465, 0.305, 0.031, 0.064, -0.137, 0.022, -0.307, -0.328, -0.570, 0.406, 1.148, -0.097, 0.434, -0.662, 0.926, -0.224, -2.069, -0.794, 0.021, -0.869, -1.189, -0.441, -0.978, -1.604, -0.486, 0.028, 1.051, -1.161, -0.291, -0.593, 0.947, -0.709, -2.629, -0.285, 0.450, 0.418, -0.814, -0.052, 0.741, -0.521, -0.370, -0.097, 0.729, 0.131, -5.000, -0.534, 0.766, -1.602, -1.547, -0.241, 0.354, 0.186, 0.033, 0.078, 0.075, 0.098, 0.367, -0.168, 0.320, -0.581, -5.000, -1.472, -0.396, -5.000, -1.733, -2.599, -0.245, -0.629, -1.858, -0.301, -1.396, -1.477, -1.234, -0.225, 0.801, -0.606, -0.392, -1.702, 0.038, -1.440, -2.028, -1.083, -0.942, -0.629, -2.902, -1.267, -1.407, -1.512, -1.837, -0.024, 1.006, -1.137, -0.375, -0.150, 0.862, -0.159, -2.572, 0.301, 0.365, 0.740, -0.014, -0.123, 0.148, 0.223, -0.376, 1.026, 1.454, 0.822, -5.000, 0.839, 0.886, -5.000, -0.307, 0.920, 0.846, 1.118, 0.811, 0.632, 0.790, 0.820, 0.983, 0.691, 0.911, -0.593, -5.000, 0.128, 0.603, -0.224, -1.089, -0.159, 0.280, 0.469, 0.010, 0.771, -0.309, -0.560, 0.260, 1.014, 1.376, 0.688, 0.420, 0.064, 1.329, 1.162, -1.157, 0.489, 0.875, -0.587, 0.359, 0.114, 0.652, -5.000, 0.194, 0.834, 1.519, 0.757, 0.624, 0.841, 1.551, 0.658, -0.547, 1.125, 1.361, 1.195, 0.781, 0.801, 1.142, 0.536, 0.614, 0.072, 0.374, -1.150, -5.000, -0.181, 0.501, -0.542, -1.226, -0.114, 0.106, -0.496, -1.700, -1.301, -0.192, 0.106, -0.403, -0.959, -0.917, -1.795, -5.000, -5.000, -0.016, 0.036, -3.042, -0.159, -0.137, -5.000, 0.064, -0.300, -0.690, -1.035, -1.115, -0.203, -1.035, -0.512, -0.709, -0.879, -5.000, -1.062, -1.626, -0.119, -1.512, -0.285, -1.995, -0.759, -0.978, -2.076, -1.659, -0.407, -0.798, -2.514, -0.282, -0.552, 0.521, -0.181, -2.255, -0.892, -0.245, -0.670, -0.413, -0.917, -1.336, -1.058, -1.657, -1.255, -0.456, -2.163, -5.000, -1.572, -0.108, -5.000, -2.399, -1.425, -1.165, -0.769, -0.534, -1.789, -1.300, -1.192, -1.413, -1.080, -0.127, -1.616, -5.000, -1.263, -0.747, -2.076, -3.458, -1.755, -0.874, -5.000, -1.594, -1.054, -0.876, -2.520, -1.317, -1.293, -0.542, -2.414, -1.300, -1.954, -1.057, -5.000, -3.397, -1.717, -1.700, -5.000, -3.057, -2.262, -0.784, -1.379, -1.768, -1.850, -1.038, -2.653, -1.242, -2.030, -0.744, -0.929, -2.511, -1.773, -0.981, -0.926, -1.828, -1.119, -1.314, -1.417, -1.463, -0.084, 0.575, -0.173, -5.000, -0.031, 1.020, -1.115, -1.249, 0.205, 0.623, 0.266, -0.094, -0.092, -0.009, -0.042, 0.139, -0.761, 0.336, -2.475, -5.000, -1.007, -0.342, -5.000, -1.995, -0.728, -1.782, -0.853, -0.447, -0.147, -1.057, -1.205, -1.315, -1.014, 0.234, -0.206, -0.982, -1.408, 0.501, -1.882, -2.334, -1.641, -1.995, -1.157, -1.882, -1.232, -1.791, -1.130, -1.942, -0.641, 0.230, -1.172, -0.267, -0.236, 0.632, 0.246, -2.243, -0.447, -0.591, 0.621, -0.774, -0.427, 0.494, -0.574, -0.643, 0.337, 0.848, 0.282, -5.000, 0.141, 0.700, -5.000, -1.038, 0.489, 0.592, 0.172, -0.071, 0.246, 0.377, -0.008, 0.420, 0.143, 0.442, -0.103, -5.000, -0.997, 0.351, 0.469, -5.000, -0.709, 0.469, 0.010, -0.054, 0.026, -0.167, -0.709, -1.254, -0.447, 0.917, -0.016, -0.342, -0.342, 0.818, -5.000, -0.853, -1.323, -0.319, -1.546, -1.678, -1.906, -1.383, -0.418, -1.991, 0.184, 1.140, 0.351, 0.069, -0.270, 0.934, -0.090, -0.967, 0.341, 1.000, 0.090, -0.101, 0.098, 0.425, -0.302, -0.261, -0.696, 0.300, -0.666, -5.000, -1.247, -5.000, -1.280, -1.462, -0.480, -0.342, -0.759, -0.447, -0.681, 0.336, 0.213, -0.382, -0.778, 0.911, -0.296, -5.000, -2.115, 0.469, -0.090, -2.303, 0.501, -0.709, 0.420, -1.016, -0.032, 0.266, -1.546, -0.847, -0.557, 0.556, -1.089, -1.546, -0.784, -5.000, -1.189, -2.779, 0.290, -0.090, -0.301, -1.973, 0.010, -1.235, -0.173, -1.339, -0.055, 0.806, -0.819, -0.772, -0.076, -0.342, 0.875, -0.765, -0.901, 0.010, 0.329, -0.355, 0.094, 0.109, -1.165, -0.660, -1.109, -0.072, -0.727, -5.000, -1.708, -1.403, -5.000, -2.455, -0.997, -0.578, -0.629, -0.831, -1.205, -1.003, -1.182, -0.910, -1.042, -0.369, -1.546, -5.000, -1.755, -5.000, -5.000, -5.000, -1.205, -0.885, -5.000, -2.076, -0.675, -0.484, -1.578, -1.167, -0.994, 0.203, -0.554, -2.176, -2.000, -1.440, -5.000, -2.567, -2.205, -5.000, -0.480, -5.000, -1.910, -1.557, -1.350, -1.334, -1.067, -0.075, -2.595, -1.806, -1.612, -0.307, -1.323, -3.448, -0.911, -0.677, -0.489, -2.010, -0.591, -0.583, -0.935, -1.558, -0.400, 0.607, -0.451, -5.000, -0.835, 0.872, -1.390, -2.169, 0.219, 0.423, -0.067, 0.016, -0.302, -0.335, -0.822, -0.145, -0.752, -0.176, -1.487, -5.000, -2.272, 0.113, -1.403, -3.004, -5.000, -0.798, -0.830, -1.220, -0.549, -0.273, -2.100, -1.725, -0.611, 0.121, -0.943, -0.530, -1.203, -0.105, -0.560, -2.431, -1.394, -1.213, -1.465, -2.228, -1.429, -1.029, -2.319, -1.732, -0.521, 0.510, -0.989, -0.566, -0.837, 0.567, -0.188, -2.061, -0.327, 0.305, 0.507, -0.627, -0.266, -0.095, -0.831, -0.920, -0.483, 0.190, -0.447, -5.000, 0.445, -0.385, -5.000, -0.859, 0.416, 0.256, -0.242, -0.487, -0.652, -0.615, -0.224, 0.044, -0.722, 0.469, -2.303, -5.000, -1.671, -0.255, -5.000, -5.000, -0.938, -0.629, -5.000, -0.784, -0.789, -1.403, -1.469, -1.015, -1.728, 0.164, -1.882, -1.671, -0.164, 0.329, -5.000, -2.016, -1.189, -1.882, -0.342, -2.152, -1.425, -5.000, -5.000, -1.436, -0.087, 0.952, -0.720, -0.188, -0.509, 0.957, -0.224, -1.326, 0.115, 0.108, 0.064, -0.788, -0.002, 0.582, -1.077, -0.641, -0.935, -0.337, -1.378, -5.000, -0.476, 0.442, -0.978, -1.940, -0.566, -0.027, -0.261, -0.842, -1.263, -0.355, -2.205, -1.011, -1.348, -0.111, -1.317, -5.000, -1.661, -0.524, -5.000, -2.691, 0.010, -0.224, -0.255, 0.275, -0.590, -0.737, -2.002, -1.020, -1.629, -5.000, -0.342, -1.235, -0.961, -5.000, -5.000, -3.079, -1.728, -1.728, -0.629, -5.000, -3.114, -0.728, -2.379, -1.646, -0.479, -0.384, -1.554, -1.958, -1.094, -0.917, -2.133, -2.330, -0.399, -0.016, -0.342, -1.093, -1.138, -0.487, -1.167, -1.491, -0.265, 0.420, -0.686, -5.000, -0.378, 0.643, -2.152, -1.652, -0.088, 0.355, -0.346, -0.051, -0.923, -0.542, -0.570, -0.278, -0.481, 0.464, -1.078, -5.000, -1.140, -0.698, -2.622, -2.414, -0.909, -0.255, -0.709, -0.917, -0.424, -0.293, -1.508, -1.196, -0.509, 0.603, -1.002, -0.699, -1.487, -0.265, -1.014, -2.404, -1.055, -1.501, -1.403, -1.613, -1.668, -1.603, -2.213, -1.153, -0.799, 0.211, -1.655, -0.997, -1.409, 0.087, -0.294, -1.829, -0.771, -0.294, -0.892, -1.305, -0.617, -0.497, -0.936, -1.015, 0.511, 1.089, 0.198, -5.000, 0.224, 0.748, -0.987, -0.695, 0.273, 0.561, 0.593, 0.357, 0.180, 0.367, 0.009, 0.277, 0.079, 0.497, -0.660, -5.000, -1.400, 0.168, -1.488, -2.128, -0.795, -0.311, -0.049, 0.050, -0.002, -0.305, -1.772, -0.534, 0.217, 1.076, 0.051, 0.405, -0.014, 0.733, -0.542, -1.381, -0.405, 0.165, -0.616, -0.959, -0.527, -0.571, -0.924, -0.581, 0.540, 1.151, 0.001, 0.478, 0.166, 0.937, 0.629, -1.181, 0.383, 0.865, 0.739, 0.221, 0.454, 0.900, 0.428, 0.241, 1.212, 1.380, 0.963, -5.000, 1.057, 1.284, -0.196, 0.501, 0.963, 1.119, 1.006, 0.765, 0.793, 1.028, 0.629, 1.087, 0.882, 1.013, 0.011, -5.000, 0.078, 0.616, -0.963, -0.197, -0.373, 0.014, -0.486, 0.716, 0.774, 0.719, -0.481, 0.011, 1.119, 1.396, 0.553, 0.978, 1.110, 1.552, 0.783, 0.073, 0.889, 1.341, 1.082, 0.110, 0.871, 0.842, 0.213, 0.413, 1.075, 1.457, 0.966, 1.096, 1.095, 1.476, 1.406, 0.058, 1.181, 1.300, 1.294, 0.988, 1.107, 1.286, 0.546, 0.688, -0.195, 0.475, -1.160, -5.000, -0.136, 0.842, -1.220, -1.330, -0.018, -0.277, 0.598, 0.199, -0.819, 0.047, -1.016, -0.385, -0.282, 0.221, -1.600, -5.000, -1.348, 0.340, -2.789, -2.364, -0.654, -0.213, 0.534, 0.594, -0.243, -0.308, -1.660, -0.673, -0.432, 0.210, -1.172, -0.588, -0.734, 0.351, -1.358, -1.735, -0.901, -0.461, -1.289, -1.370, -1.241, -1.062, -1.537, -1.010, -0.221, 0.363, -1.307, -0.595, -0.616, 0.650, -0.308, -1.127, -0.449, 0.157, 0.031, -0.714, -0.591, -0.152, -0.979, -1.198, 0.380, 0.978, -0.005, -5.000, 0.148, 0.869, -1.125, -0.946, 0.397, 0.500, 0.357, 0.226, -0.213, 0.030, -0.283, 0.008, 0.414, 0.947, -0.292, -5.000, -0.969, -0.034, -1.995, -1.007, -0.531, 0.085, 0.177, -0.130, 0.225, -0.183, -1.163, -0.379, 0.343, 1.191, -0.136, 0.354, -0.539, 0.698, -1.512, -1.950, -0.195, 0.347, -0.250, -0.649, -0.448, -0.182, -1.030, -0.573, 0.022, 0.692, -0.939, -0.216, -0.278, 0.725, 0.022, -1.048, 0.140, 0.406, 0.471, -0.147, 0.063, 0.549, -0.281, -0.249, 0.120, 0.782, 0.016, -5.000, -0.045, 0.450, -1.140, -1.300, -0.004, 0.185, 0.372, 0.095, 0.026, 0.303, -0.103, 0.101, -0.275, 0.432, -1.145, -5.000, -1.610, -0.496, -1.755, -1.377, -0.515, -1.808, -0.512, -1.258, 0.141, -0.514, -1.606, -0.976, -0.191, 0.808, -0.577, -0.715, 0.029, 0.606, -0.293, -1.549, -1.140, -0.442, -0.841, -2.280, -1.192, -0.660, -1.363, -1.353, 0.241, 0.923, -0.635, -0.169, -0.140, 0.577, 0.501, -2.031, 0.511, 0.663, 0.707, 0.359, 0.182, 0.195, -0.018, 0.065, 1.162, 1.421, 1.182, -5.000, 0.917, 1.162, 0.182, 0.721, 0.947, 1.151, 0.982, 0.787, 0.870, 1.083, 0.909, 1.106, 0.675, 0.837, -1.235, -5.000, -0.329, 0.423, -0.125, 0.021, 0.603, 0.469, 0.469, 0.603, 1.168, 0.644, -0.819, 0.003, 0.935, 1.450, 0.783, 0.507, 0.757, 1.511, 0.121, 0.290, 0.652, 0.919, 1.035, -0.005, 0.460, 0.950, -0.137, 0.081, 1.023, 1.501, 1.055, 1.015, 0.745, 1.511, 1.341, 0.474, 1.280, 1.336, 1.045, 0.968, 0.925, 1.221, 0.706, 0.664, 0.523, 1.019, 0.376, -5.000, 0.771, 1.098, -0.542, -0.542, 0.871, 0.985, 0.708, 0.420, -0.125, 0.757, -0.159, 0.447, -0.021, 0.991, -0.819, -5.000, -1.500, 0.501, -5.000, -1.371, 0.064, 0.939, 0.875, 1.162, 0.915, 0.556, -0.765, 0.166, 0.748, 1.055, 0.426, 0.875, 0.301, 0.831, -0.314, -0.447, 0.092, 0.757, -0.496, -5.000, 0.079, -0.572, 0.164, -0.335, 0.143, 0.706, 0.040, 0.427, 0.568, 1.441, 1.001, -0.605, 0.515, 1.333, 0.799, 1.140, 0.388, 0.872, 0.019, -0.843, -0.838, -0.627, -1.293, -5.000, -1.126, -0.422, -1.825, -2.552, -0.328, -0.327, -0.204, -0.166, -1.466, -0.774, -1.218, -0.892, -1.310, -0.139, -1.448, -5.000, -2.593, -0.480, -1.201, -2.622, -1.870, -0.807, -5.000, -1.377, -0.545, -0.758, -1.705, -1.069, -1.107, 0.070, -1.850, -1.320, -1.863, -0.846, -1.973, -2.344, -1.752, -1.289, -1.773, -2.779, -1.105, -1.520, -2.493, -2.078, -1.605, -0.447, -1.048, -1.324, -1.990, -0.776, -1.529, -2.247, -0.735, -0.821, -0.843, -1.027, -1.114, -0.714, -1.060, -1.244, 0.457, 0.981, 0.451, -5.000, 0.395, 1.016, -1.314, -0.753, 0.500, 0.738, 0.564, 0.147, 0.200, 0.766, 0.184, 0.154, -0.096, 0.246, -0.337, -5.000, -0.391, 0.666, -1.343, -1.005, -0.595, -0.185, -0.403, 0.279, 0.095, -0.086, -0.600, -0.518, 0.197, 1.015, 0.339, 0.241, -0.239, 0.934, -0.512, -1.572, -0.216, -0.082, 0.013, -1.372, -0.607, -0.247, -0.736, -0.371, 0.364, 0.905, -0.335, 0.294, -0.018, 0.927, 0.082, -1.258, 0.391, 0.813, 0.695, 0.034, 0.451, 0.877, 0.347, 0.173, 0.844, 1.320, 1.040, -5.000, 0.690, 1.219, -0.447, -0.507, 0.832, 0.943, 0.719, 0.569, 0.583, 0.889, 0.399, 0.669, 0.583, 0.965, 0.121, -5.000, -0.147, 1.073, -2.393, -0.615, -0.009, 0.946, 0.580, 0.550, 0.762, 0.694, -1.021, 0.108, 0.574, 0.934, 0.569, 0.165, 0.378, 1.305, 0.064, -0.703, -0.159, 0.890, -0.304, -0.755, -0.228, 0.029, -0.784, -0.619, 0.780, 1.409, 0.790, 0.780, 0.797, 1.300, 0.871, -0.330, 0.611, 1.287, 0.847, 0.579, 0.728, 1.114, 0.108, 0.383, 0.704, 0.939, 0.420, -5.000, 0.791, 1.135, -0.447, -0.373, 0.833, 0.215, 0.024, 0.086, 0.306, 0.327, 0.002, 0.229, 0.488, 0.942, -0.241, -5.000, 0.023, 1.217, -1.440, -0.683, 0.492, 0.200, 0.306, 0.139, 0.489, 0.627, -0.365, 0.176, 1.057, 1.291, 0.674, 0.336, 0.612, 0.849, -0.005, -0.812, 0.732, 0.351, -0.422, 0.014, 0.365, 0.351, 0.138, 0.316, 0.978, 1.355, 0.271, 0.633, 0.192, 1.041, 0.692, -0.775, 0.955, 0.818, 0.469, 0.246, 0.713, 0.714, 0.552, -0.119, 0.357, 0.695, 0.045, -5.000, 0.076, 0.353, -1.546, -1.127, 0.177, 0.300, 0.099, -0.051, -0.373, 0.284, 0.001, 0.083, 0.199, 0.698, 0.222, -5.000, -1.276, 0.257, -5.000, -2.272, -1.309, 0.186, -1.578, -0.016, 0.361, 0.220, -0.538, -0.751, -0.064, 0.252, 0.053, -0.195, -0.317, 0.489, -0.186, -0.913, -0.587, -0.097, -1.422, -2.016, -0.598, -0.641, -0.532, -1.005, -0.067, 0.685, -0.613, -0.123, -0.252, 0.829, 0.461, -1.267, -0.229, 0.405, -0.020, -0.989, 0.163, 0.556, 0.052, -0.575, 0.481, 1.122, 0.274, -5.000, 0.351, 0.896, -1.459, -0.934, 0.540, 0.739, 0.504, 0.344, 0.147, 0.514, -0.357, 0.395, 0.086, 0.676, -0.375, -5.000, -1.262, 0.487, -1.690, -1.642, -0.759, 0.034, -0.391, -0.244, 0.206, 0.158, -1.331, -0.498, 0.198, 0.907, 0.308, 0.334, -0.131, 0.775, -1.280, -0.985, -0.631, -0.183, -0.641, -1.805, -0.647, -0.573, -1.547, -0.834, 0.371, 1.106, -0.350, 0.153, -0.121, 1.100, 0.299, -1.222, 0.363, 0.871, 0.724, 0.102, 0.281, 0.829, 0.110, 0.009, 0.872, 1.270, 0.711, -5.000, 0.676, 0.843, -1.280, -0.435, 0.880, 1.054, 0.770, 0.555, 0.443, 0.732, 0.313, 0.778, 0.663, 0.751, -0.574, -5.000, -0.136, 0.454, -0.224, -1.123, -0.155, -0.290, 0.357, 0.504, 0.415, -0.013, -1.233, -0.121, 0.499, 1.144, 0.246, 0.031, 0.591, 1.283, -1.035, -1.108, -0.512, 0.568, -0.051, -0.917, -0.378, -0.324, -2.789, -0.441, 0.810, 1.309, 0.584, 0.555, 0.544, 1.265, 0.875, -0.629, 0.752, 1.083, 0.851, 0.324, 0.673, 0.994, -0.135, 0.244, 0.238, 0.781, -0.447, -5.000, -0.044, 0.772, -0.620, -1.151, 0.482, 0.731, 0.763, 0.322, -0.394, -0.015, -0.310, -0.025, 0.299, 0.770, -0.829, -5.000, -0.527, 0.534, -2.161, -1.703, 0.260, 0.519, 0.522, 0.484, 0.386, 0.368, -0.623, -0.194, -0.169, 0.705, -1.116, -1.054, -1.026, 0.384, -1.764, -1.631, -0.154, -0.367, -0.455, -0.491, -1.352, -1.106, -0.712, -1.265, 0.191, 0.565, -1.057, -0.471, -0.550, 0.713, -0.402, -1.420, -0.004, 0.297, -0.272, -0.363, -0.154, 0.076, -1.169, -1.195, 0.200, 0.724, -0.152, -5.000, 0.063, 0.720, -1.560, -0.995, 0.223, 0.440, 0.200, 0.176, -0.464, 0.033, -0.141, -0.132, 0.179, 0.782, -0.526, -5.000, -0.940, -0.061, -0.577, -1.434, -0.458, -0.157, -0.888, -0.196, 0.214, 0.171, -0.807, -0.601, -0.020, 1.112, -0.144, 0.042, -0.679, 0.652, -0.529, -1.487, -0.654, -0.301, -0.098, -1.270, -0.820, -0.794, -1.304, -0.759, -0.205, 0.596, -0.778, -0.500, -0.359, 0.677, 0.062, -1.325, -0.315, 0.072, 0.021, -1.038, -0.309, -0.057, -0.570, -0.670 } 
  };
  memcpy(tptr, &tinf, sizeof(struct _training));
}

void initialize_metagenome_1(struct _training *tptr) {
  struct _training tinf = {
    0.400, 4, 4.350, { 1.489, 0.435, 1.076 }, { 1.241, -0.914, -2.852 }, 0, 
    { 0.005, -1.183, -0.414, -0.063, -0.433, 1.393, -0.651, -4.000, -4.000, 0.540, 2.029, -4.000, 0.022, -0.281, -0.118, -0.093, -2.177, 0.636, -4.000, -0.612, 1.502, 1.518, 2.072, -4.000, 1.580, -4.000, 3.310, 3.492 }, 
    {{ 0.250, -0.135, -0.232, -0.063},{ -0.041, -0.723, 0.103, 0.271},{ 0.254, -0.192, -0.435, 0.061},{ 0.307, -0.340, -0.306, 0.009},{ 0.267, -0.232, -0.192, -0.052},{ 0.158, -0.173, -0.386, 0.139},{ 0.291, -0.569, -0.274, 0.105},{ 0.134, -0.212, -0.072, 0.030},{ 0.207, -0.375, -0.117, 0.051},{ 0.211, -0.317, -0.154, 0.040},{ 0.144, -0.222, -0.163, 0.076},{ 0.125, -0.500, -0.232, 0.237},{ 0.051, -0.386, -0.173, 0.237},{ 0.185, -0.222, -0.072, -0.024},{ 0.171, -0.212, -0.232, 0.076},{ 0.216, -0.232, -0.243, 0.040},{ 0.110, -0.192, -0.038, 0.025},{ 0.096, -0.212, 0.011, 0.019},{ 0.056, -0.108, -0.055, 0.045},{ 0.019, 0.043, -0.163, 0.051},{ 0.115, -0.243, -0.173, 0.120},{ 0.120, 0.043, -0.099, -0.098},{ 0.105, -0.212, -0.064, 0.056},{ 0.096, -0.154, -0.108, 0.061},{ 0.003, 0.003, -0.222, 0.120},{ 0.071, -0.013, 0.003, -0.069},{ 0.071, -0.154, -0.173, 0.120},{ 0.003, -0.108, -0.047, 0.091},{ -0.013, -0.021, -0.055, 0.061},{ 0.003, -0.317, -0.038, 0.185},{ -0.002, 0.117, -0.005, -0.081},{ 0.110, -0.064, 0.027, -0.098} }, 
    {{{ -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000},
   { -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000},
   { -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000},
   { -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, 0.577, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000}
   },{{ -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000},
   { -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000},
   { -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000},
   { -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, 0.890, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000}
   },{{ -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000},
   { -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000},
   { -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000},
   { 0.677, -4.000, -4.000, 1.090, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, 1.473, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, 0.993, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, 0.964, -4.000, -4.000, 1.034, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, 1.654, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, 1.220, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, 0.941, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000}
   },{{ -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000},
   { -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000},
   { -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000},
   { 1.502, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, 1.550, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, 2.619, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.000, -4.